/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookMessageInfo;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.LetterOfCreditBookNotifyBuilder;
import com.kingdee.eas.fm.fin.LetterOfCreditCollection;
import com.kingdee.eas.fm.fin.LetterOfCreditException;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LetterOperateTypeEnum;
import com.kingdee.eas.fm.fin.LetterStatusEnum;
import com.kingdee.eas.fm.fin.app.AbstractLetterOfCreditBooKFacadeControllerBean;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LetterOfCreditBooKFacadeControllerBean
extends AbstractLetterOfCreditBooKFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.LetterOfCreditBooKFacadeControllerBean");

    @Override
    protected Map _book(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashMap ret = new HashMap();
        if (idSet == null || idSet.isEmpty()) {
            return ret;
        }
        Set ids = this.doCheckAndFilter(ctx, idSet, ret);
        IBookNotifyFacade bookInstance = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        Object[] idsArr = ids.toArray();
        String billID = null;
        String userId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString();
        String sql = "UPDATE T_FIN_LetterOfCredit SET FCashierID = ? WHERE FID = ? ";
        int size = idsArr.length;
        for (int i = 0; i < size; ++i) {
            BookMessageInfo msgInfo;
            billID = (String)idsArr[i];
            if (this.isBooked(ctx, billID) || !(msgInfo = bookInstance.book(LetterOfCreditBookNotifyBuilder.class.getName(), billID)).isSuccess()) continue;
            FMHelper.execute((Context)ctx, (String)sql, (Object[])new Object[]{userId, billID});
        }
        return ret;
    }

    private Set doCheckAndFilter(Context ctx, Set idSet, Map msgMap) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        HashSet<String> idSetRet = new HashSet<String>();
        LetterOfCreditCollection coll = this.getLetterOfCreditColByIDSet(ctx, idSet);
        int size = coll.size();
        LetterOfCreditInfo info = null;
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (!this.canBeBook(coll.get(i))) continue;
            idSetRet.add(info.getId().toString());
        }
        msgMap.put("failrecord", sb);
        return idSetRet;
    }

    private boolean isZero(BigDecimal va) {
        return va == null || va.compareTo(Constants.ZERO) <= 0;
    }

    private boolean canBeBook(LetterOfCreditInfo letterOfCreditInfo) throws BOSException, EASBizException {
        if (letterOfCreditInfo.getCashier() != null) {
            throw new LetterOfCreditException(LetterOfCreditException.BOOKERROR5, new Object[]{letterOfCreditInfo.getNumber()});
        }
        if (letterOfCreditInfo.getLetterStatus() == LetterStatusEnum.close || letterOfCreditInfo.getOperateStatus() != LetterOperateTypeEnum.AUDIT) {
            throw new LetterOfCreditException(LetterOfCreditException.BOOKERROR9, new Object[]{letterOfCreditInfo.getNumber()});
        }
        if (this.isZero(letterOfCreditInfo.getMarginEx())) {
            throw new LetterOfCreditException(LetterOfCreditException.BOOKERROR1, new Object[]{letterOfCreditInfo.getNumber()});
        }
        if (letterOfCreditInfo.getMarginAcct() == null && letterOfCreditInfo.getPayBankAcct() == null && !this.isZero(letterOfCreditInfo.getMarginEx())) {
            throw new LetterOfCreditException(LetterOfCreditException.BOOKERROR3, new Object[]{letterOfCreditInfo.getNumber()});
        }
        if (letterOfCreditInfo.getPayBankAcct() != null && letterOfCreditInfo.getMarginAcct() != null) {
            if (letterOfCreditInfo.getPayBankAcct().getId().equals((Object)letterOfCreditInfo.getMarginAcct().getId())) {
                throw new LetterOfCreditException(LetterOfCreditException.BOOKERROR8, new Object[]{letterOfCreditInfo.getNumber()});
            }
            CurrencyInfo payBankAcctCurrency = letterOfCreditInfo.getPayBankAcct().getCurrency();
            CurrencyInfo marginAcctCurrency = letterOfCreditInfo.getMarginAcct().getCurrency();
            if (payBankAcctCurrency != null && marginAcctCurrency != null && !payBankAcctCurrency.getId().equals((Object)marginAcctCurrency.getId())) {
                throw new LetterOfCreditException(LetterOfCreditException.BOOKERROR2, new Object[]{letterOfCreditInfo.getNumber()});
            }
        }
        if (letterOfCreditInfo.getPayBankAcct() != null && letterOfCreditInfo.getMarginAcct() != null && letterOfCreditInfo.getPayBankAcct().getCurrency() == null && letterOfCreditInfo.getMarginAcct().getCurrency() == null && letterOfCreditInfo.getMarginCurrency() == null) {
            throw new LetterOfCreditException(LetterOfCreditException.BOOKERROR4, new Object[]{letterOfCreditInfo.getNumber()});
        }
        if (letterOfCreditInfo.getPayBankAcct() == null && letterOfCreditInfo.getMarginAcct() != null && letterOfCreditInfo.getMarginAcct().getCurrency() == null && letterOfCreditInfo.getMarginCurrency() == null) {
            throw new LetterOfCreditException(LetterOfCreditException.BOOKERROR6, new Object[]{letterOfCreditInfo.getNumber()});
        }
        if (letterOfCreditInfo.getPayBankAcct() != null && letterOfCreditInfo.getMarginAcct() == null && letterOfCreditInfo.getPayBankAcct().getCurrency() == null && letterOfCreditInfo.getMarginCurrency() == null) {
            throw new LetterOfCreditException(LetterOfCreditException.BOOKERROR7, new Object[]{letterOfCreditInfo.getNumber()});
        }
        return true;
    }

    private LetterOfCreditCollection getLetterOfCreditColByIDSet(Context ctx, Set idSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.getSelector().add("payBankAcct.currency.id");
        evi.getSelector().add("marginAcct.currency.id");
        evi.setFilter(filter);
        LetterOfCreditCollection coll = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditCollection(evi);
        return coll;
    }

    @Override
    protected Map _cancelBook(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashMap ret = new HashMap();
        if (idSet == null || idSet.isEmpty()) {
            return ret;
        }
        this.verifyCancelBook(ctx, idSet);
        String sql = "UPDATE T_FIN_LetterOfCredit SET FCashierID = ? WHERE FID = ? ";
        IBookNotifyFacade bookFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        String billID = null;
        Object[] idsArr = idSet.toArray();
        int size = idsArr.length;
        for (int i = 0; i < size; ++i) {
            billID = (String)idsArr[i];
            bookFacade.antiBook(billID);
            FMHelper.execute((Context)ctx, (String)sql, (Object[])new Object[]{null, billID});
        }
        return ret;
    }

    private void verifyCancelBook(Context ctx, Set idSet) throws BOSException, EASBizException {
        LetterOfCreditCollection coll = this.getLetterOfCreditColByIDSet(ctx, idSet);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            this.canBeCancelBook(coll.get(i));
        }
    }

    private void canBeCancelBook(LetterOfCreditInfo letterOfCreditInfo) throws BOSException, EASBizException {
        if (letterOfCreditInfo.getAccountant() != null) {
            throw new LetterOfCreditException(LetterOfCreditException.CANCELBOOKERROR1, new Object[]{letterOfCreditInfo.getNumber()});
        }
        if (letterOfCreditInfo.getCashier() == null) {
            throw new LetterOfCreditException(LetterOfCreditException.CANCELBOOKERROR3, new Object[]{letterOfCreditInfo.getNumber()});
        }
        if (letterOfCreditInfo.isIsGenRepayment()) {
            throw new LetterOfCreditException(LetterOfCreditException.CANCELBOOKERROR2, new Object[]{letterOfCreditInfo.getNumber()});
        }
    }

    private boolean isBooked(Context ctx, String billId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        view.setFilter(filter);
        JournalCollection coll = JournalFactory.getLocalInstance((Context)ctx).getJournalCollection(view);
        return coll != null && coll.size() > 0;
    }
}

