/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.FundsMoveException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.FMBooleanEnum;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fin.CreditLimitUsedCollection;
import com.kingdee.eas.fm.fin.CreditLimitUsedFactory;
import com.kingdee.eas.fm.fin.CreditLimitUsedInfo;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.LCForecastedBlockingFlowGenerator;
import com.kingdee.eas.fm.fin.LetOfCreditAcctRecordCollection;
import com.kingdee.eas.fm.fin.LetOfCreditAcctRecordFactory;
import com.kingdee.eas.fm.fin.LetOfCreditAcctRecordInfo;
import com.kingdee.eas.fm.fin.LetterException;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LetterOperateTypeEnum;
import com.kingdee.eas.fm.fin.LetterStatusEnum;
import com.kingdee.eas.fm.fin.app.AbstractLetterOfCreditControllerBean;
import com.kingdee.eas.fm.mnt.ForecastedBlockingFlowFactory;
import com.kingdee.eas.fm.nt.AssureAmountFactory;
import com.kingdee.eas.fm.nt.AssureAmountInfo;
import com.kingdee.eas.fm.nt.AssureStateEnum;
import com.kingdee.eas.fm.nt.LetterOfCreditApplyException;
import com.kingdee.eas.fm.nt.LetterOfCreditApplyFactory;
import com.kingdee.eas.fm.nt.LetterOfCreditApplyInfo;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class LetterOfCreditControllerBean
extends AbstractLetterOfCreditControllerBean {
    private static final String EDIT = "EDIT";
    private static final String ADDNEW = "ADDNEW";
    protected final String autoAssoNumber = "AutoNumberFromBTP_";
    private static final String SQLUP_LOC_STATUS = "UPDATE T_FIN_LetterOfCredit SET FLETTERSTATUS = ? WHERE FID = ? ";

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LetterOfCreditInfo info = (LetterOfCreditInfo)model;
        NTTypeInfo ni = info.getNtType();
        SelectorItemCollection sic1 = new SelectorItemCollection();
        sic1.add(new SelectorItemInfo("*"));
        sic1.add(new SelectorItemInfo("financeType.FinancingSource.id"));
        ni = NTTypeFactory.getLocalInstance((Context)ctx).getNTTypeInfo((IObjectPK)new ObjectUuidPK(ni.getId()), sic1);
        if (ni.getFinanceType() == null) {
            throw new FinBizException(FinBizException.NTTYPEERROR, new Object[]{ni.getName()});
        }
        if (info.getCreditCurExRate() == null) {
            info.setCreditCurExRate(Constants.ZERO);
        }
        if (info.getContractCurrenc() == null) {
            info.setContractCurrenc(info.getCurrency());
        }
        if (info.getOperateStatus() != null && !info.getOperateStatus().equals((Object)LetterOperateTypeEnum.AUDIT)) {
            info.setOperateStatus(LetterOperateTypeEnum.submit);
        }
        info.setSource(ni.getFinanceType().getFinancingSource());
        info.setType(ni.getFinanceType());
        IObjectPK pk = super._submit(ctx, model);
        this.dispose(ctx, info, LetterOperateTypeEnum.submit);
        ForecastedBlockingFlowFactory.getLocalInstance((Context)ctx).genForecastedBlockingFlow(BOSUuid.read((String)pk.toString()), LCForecastedBlockingFlowGenerator.class.getName());
        return pk;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LetterOfCreditInfo lcInfo = this.getLetterOfCreditInfo(ctx, pk);
        if (lcInfo.getOperateStatus() != LetterOperateTypeEnum.temporarily && lcInfo.getBalance().compareTo(lcInfo.getAmount()) != 0) {
            throw new FinBizException(FinBizException.AMOUNTNOTEQUALBALANCECANNOTDELETE);
        }
        super._delete(ctx, pk);
        this.dispose(ctx, lcInfo, LetterOperateTypeEnum.DELETE);
        ForecastedBlockingFlowFactory.getLocalInstance((Context)ctx).deleteForecastedBlockingFlow(BOSUuid.read((String)pk.toString()));
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)lcInfo, (String)lcInfo.getCompany().getId().toString());
    }

    @Override
    protected void verify(Context ctx, FinancingBillInfo finBill) throws BOSException, EASBizException {
        if (((LetterOfCreditInfo)finBill).getOperateStatus() != LetterOperateTypeEnum.temporarily) {
            super.verify(ctx, finBill);
            LetterOfCreditInfo letter = (LetterOfCreditInfo)finBill;
            if (!letter.isIsDYZ()) {
                FMVerifyHelper.checkMustMoreThanZero((Context)ctx, (IObjectValue)finBill, (String)"Balance");
            }
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)finBill, (String)"Beneficiary");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)finBill, (String)"Institution");
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LetterOfCreditInfo info = (LetterOfCreditInfo)model;
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        boolean isMustCreateFrom = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("FIN015", (IObjectPK)new ObjectUuidPK(currentCompany.getId()));
        if (isMustCreateFrom && FMHelper.isEmpty((String)info.getSourceBillId())) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.ISMUSTCREATEFROM);
        }
        if (FMHelper.isEmpty((String)info.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        this._checkNumberDup(ctx, (IObjectValue)info);
        if (info.getNtType() != null) {
            info.setType(info.getNtType().getFinanceType());
        }
        this.setAssureAmount(ctx, info);
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"letterNumber");
        IObjectPK pk = super._addnew(ctx, model);
        LetterOfCreditControllerBean.createBotpWithLetterOfCreditApply(ctx, info);
        this._letterNumberUniqueCheck(ctx, pk.toString(), ADDNEW, info.getLetterNumber());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("Balance");
        LetterOfCreditInfo lcInfo = (LetterOfCreditInfo)this._getValue(ctx, pk, sic);
        if (lcInfo.getBalance().compareTo(SysConstant.BIGZERO) == 0) {
            throw new FinBizException(FinBizException.BALANCEISZERO);
        }
        return pk;
    }

    public static void createBotpWithLetterOfCreditApply(Context ctx, LetterOfCreditInfo info) throws BOSException, EASBizException {
        if (info == null || info.getSourceBillId() == null) {
            return;
        }
        FinUtils.addBotRelation(ctx, info.getSourceBillId(), info.getId().toString());
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        LetterOfCreditInfo lcInfo = (LetterOfCreditInfo)model;
        if (FMHelper.isEmpty((String)lcInfo.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)lcInfo, (String)lcInfo.getCompany().getId().toString());
            lcInfo.setNumber(numberSilent);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)lcInfo, (String)"number");
        this._checkNumberDup(ctx, (IObjectValue)lcInfo);
        this._letterNumberUniqueCheck(ctx, pk.toString(), EDIT, lcInfo.getLetterNumber());
        super._update(ctx, pk, model);
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            LetterOfCreditInfo info = (LetterOfCreditInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccountant(null);
            } else if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.ADDNEW)) {
                info.setAccountant(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
            }
        }
        super.updateOnlyModel(ctx, srcBillPK, srcBillVO);
    }

    @Override
    protected SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("DeferReturnCLEntrys.*");
        return sic;
    }

    @Override
    protected void _letterClose(Context ctx, String id) throws BOSException, EASBizException {
        LetterOfCreditInfo info = this.getLetterOfCreditInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        if (info.getLetterStatus().getValue() == "1") {
            throw new FinBizException(FinBizException.CLOSED);
        }
        super.modifyQuantum(ctx, (IObjectPK)new ObjectUuidPK(id), true);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("bill", (Object)info.getId().toString()));
        evi.setFilter(fi);
        LetOfCreditAcctRecordCollection colls = LetOfCreditAcctRecordFactory.getLocalInstance(ctx).getLetOfCreditAcctRecordCollection(evi);
        for (int i = 0; i < colls.size(); ++i) {
            LetOfCreditAcctRecordInfo recordInfo = colls.get(i);
            if (!recordInfo.getState().equals((Object)FMBooleanEnum.No)) continue;
            throw new FinBizException(FinBizException.CANNOTCLOSE);
        }
        String sql = "UPDATE T_FIN_LetterOfCredit SET FLETTERSTATUS = ?, FCloseTime = ? WHERE FID = ? ";
        Timestamp closeTime = new Timestamp(System.currentTimeMillis());
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{"1", closeTime, id});
    }

    @Override
    protected void _letterOpen(Context ctx, String id) throws BOSException, EASBizException {
        LetterOfCreditInfo info = this.getLetterOfCreditInfo(ctx, (IObjectPK)new ObjectUuidPK(id), this.getSelectors());
        if (info.getLetterStatus().getValue() == "0") {
            throw new FinBizException(FinBizException.OPENPED);
        }
        super.modifyQuantum(ctx, (IObjectPK)new ObjectUuidPK(id), false);
        String sql = "UPDATE T_FIN_LetterOfCredit SET FLETTERSTATUS = ?, FCloseTime = null WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{"0", id});
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LetterOfCreditInfo info = (LetterOfCreditInfo)model;
        NTTypeInfo ni = info.getNtType();
        if (ni.getFinanceType() == null) {
            throw new FinBizException(FinBizException.NTTYPEERROR, new Object[]{ni.getName()});
        }
        info.setSource(ni.getFinanceType().getFinancingSource());
        info.setType(ni.getFinanceType());
        if (info.getCreditCurExRate() == null) {
            info.setCreditCurExRate(Constants.ZERO);
        }
        if (info.getContractCurrenc() == null) {
            info.setContractCurrenc(info.getCurrency());
        }
        if (info.getHorizon() == null) {
            info.setHorizon(Constants.ZERO);
        }
        info.setOperateStatus(LetterOperateTypeEnum.temporarily);
        this.dispose(ctx, info, LetterOperateTypeEnum.EDIT);
        return super._save(ctx, model);
    }

    @Override
    protected void _delLetterCheck(Context ctx, String id) throws BOSException, EASBizException {
        String sqlForModify = "Select count(*) as total_1 From T_FIN_ModifyLetter Where FLetterID = ? ";
        String sqlForFee = "Select count(*) as total_1 From t_fin_feemanage Where FLetterCreditID = ? ";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sqlForModify, (Object[])new Object[]{id});
        int num = 0;
        try {
            if (rowset.next() && (num = rowset.getInt("total_1")) > 0) {
                throw new LetterException(LetterException.CANNOTDELFORMODIFY);
            }
            rowset = DbUtil.executeQuery((Context)ctx, (String)sqlForFee, (Object[])new Object[]{id});
            if (rowset.next() && (num = rowset.getInt("total_1")) > 0) {
                throw new LetterException(LetterException.CANNOTDELFORFEE);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _letterNumberUniqueCheck(Context ctx, String id, String oprType, String letterNumber) throws BOSException, EASBizException {
        String sqlResearch = "Select count(*) as total_1 From T_FIN_LetterOfCredit Where fletternumber = ? and fid <> ?";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sqlResearch, (Object[])new Object[]{letterNumber, id});
        int num = 0;
        try {
            if (rowset.next()) {
                num = rowset.getInt("total_1");
            }
            if (oprType.equals(ADDNEW) && num > 0) {
                throw new LetterException(LetterException.LETTERNUMBERISEXIST);
            }
            if (oprType.equals(EDIT) && num > 0 && num > 1) {
                throw new LetterException(LetterException.LETTERNUMBERISEXIST);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean _isRelatingRepayment(Context ctx, String id) throws BOSException {
        String strSql = "select FSrcObjectID from T_BOT_Relation where FDestEntityID='18180D81' and FSrcEntityID='107C69A8' and FSrcObjectID = '" + id + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSql);
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void _autoClose(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LetterOfCreditInfo info = this.getLetterOfCreditInfo(ctx, pk);
        if (info == null) {
            return;
        }
        if (info.isIsDYZ() || info.getBalance().compareTo(SysConstant.BIGZERO) != 0) return;
        if (info.isIsInCredit()) {
            CreditLimitUsedCollection cols = CreditLimitUsedFactory.getLocalInstance(ctx).getColsByBillId(pk.toString());
            if (cols == null || cols.size() <= 0) return;
            CreditLimitUsedInfo usedInfo = cols.get(0);
            if (usedInfo.getUsedQuota().compareTo(usedInfo.getReturnedQuota()) == 0 && info.getDeferReturnCreditLimitDays() == 0) {
                this.updateDBsetLetterOfCreditStatus(ctx, pk.toString(), LetterStatusEnum.close);
            }
        } else {
            this.updateDBsetLetterOfCreditStatus(ctx, pk.toString(), LetterStatusEnum.close);
        }
        String bizBillId = info.getId().toString();
        Set destBill = FMHelper.getDestBillIdSet((Context)ctx, (String)bizBillId);
        if (destBill.size() <= 0) return;
        for (int i = 0; i < destBill.size(); ++i) {
            String destId = (String)FMHelper.set2List((Set)destBill).get(i);
            if (!BOSUuid.read((String)destId).getType().equals((Object)new AssureAmountInfo().getBOSType())) continue;
            AssureAmountInfo assureAmount = AssureAmountFactory.getLocalInstance((Context)ctx).getAssureAmountInfo((IObjectPK)new ObjectStringPK(destId));
            assureAmount.setAssureState(AssureStateEnum.CANCELLED);
            AssureAmountFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectStringPK(destId), (CoreBaseInfo)assureAmount);
        }
    }

    private void updateDBsetLetterOfCreditStatus(Context ctx, String id, LetterStatusEnum status) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)SQLUP_LOC_STATUS, (Object[])new Object[]{status.getValue(), id});
    }

    @Override
    protected void _autoOpen(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LetterOfCreditInfo info = this.getLetterOfCreditInfo(ctx, pk);
        if (info.getLetterStatus() != LetterStatusEnum.close) {
            return;
        }
        this.updateDBsetLetterOfCreditStatus(ctx, pk.toString(), LetterStatusEnum.open);
        String bizBillId = info.getId().toString();
        Set destBill = FMHelper.getDestBillIdSet((Context)ctx, (String)bizBillId);
        if (destBill.size() > 0) {
            for (int i = 0; i < destBill.size(); ++i) {
                String destId = (String)FMHelper.set2List((Set)destBill).get(i);
                if (!BOSUuid.read((String)destId).getType().equals((Object)new AssureAmountInfo().getBOSType())) continue;
                AssureAmountInfo assureAmount = AssureAmountFactory.getLocalInstance((Context)ctx).getAssureAmountInfo((IObjectPK)new ObjectStringPK(destId));
                assureAmount.setAssureState(AssureStateEnum.SAVED);
                AssureAmountFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectStringPK(destId), (CoreBaseInfo)assureAmount);
            }
        }
    }

    @Override
    protected void _antiAudit(Context ctx, Set pks) throws BOSException, EASBizException {
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        if (pks == null || pks.size() == 0) {
            throw new FundsMoveException(FundsMoveException.IDSETISNULL);
        }
        Iterator it = pks.iterator();
        while (it.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)it.next().toString()));
            this.singleAnitAudit(ctx, (IObjectPK)pk);
        }
    }

    @Override
    protected void _audit(Context ctx, Set pks) throws BOSException, EASBizException {
        if (pks == null || pks.size() == 0) {
            throw new FMException(FMException.IDSETISNULL);
        }
        Iterator it = pks.iterator();
        while (it.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)it.next().toString()));
            this.singleAudit(ctx, (IObjectPK)pk);
        }
    }

    @Override
    protected boolean _isSupportWorkFlow(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        boolean isSupportWorkFolw = true;
        return isSupportWorkFolw;
    }

    @Override
    protected void _singleAnitAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        boolean isAccept = false;
        LetterOfCreditInfo info = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo(pk);
        if (info.getOperateStatus() != LetterOperateTypeEnum.AUDIT) {
            throw new FMException(FMException.SELECT_AUDIT_BILL);
        }
        int seq = LetOfCreditAcctRecordFactory.getLocalInstance(ctx).getMaxSeqByID((IObjectPK)new ObjectUuidPK(info.getId().toString()));
        if (seq > 0) {
            isAccept = true;
        }
        if (info.getLetterStatus() == LetterStatusEnum.close || NTHelper.checkIsReachDispose((Context)ctx, (FinancingBillInfo)info) || info.isIsGenRepayment() || info.isIsGenLoanReq() || isAccept) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.CANNOTANTIAUDIT);
        }
        DbUtil.execute((Context)ctx, (String)MessageFormat.format("update T_FIN_LetterOfCredit set FoperateStatus={0}, FauditorId=null where FId=''{1}'' ", String.valueOf(5), pk.toString()));
    }

    private void dispose(Context ctx, LetterOfCreditInfo info, LetterOperateTypeEnum disposerActionEnum) throws BOSException, EASBizException {
        String sourceBillId = info.getSourceBillId();
        if (FMHelper.isEmpty((String)sourceBillId)) {
            return;
        }
        BOSObjectType bosType = BOSUuid.read((String)sourceBillId).getType();
        if (bosType.equals((Object)new LetterOfCreditApplyInfo().getBOSType())) {
            LetterOfCreditApplyInfo desinfo = LetterOfCreditApplyFactory.getLocalInstance((Context)ctx).getLetterOfCreditApplyInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
            if (disposerActionEnum.equals((Object)LetterOperateTypeEnum.DELETE)) {
                desinfo.setIsLetterCredit(false);
            } else {
                desinfo.setIsLetterCredit(true);
            }
            LetterOfCreditApplyFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(sourceBillId), (CoreBaseInfo)desinfo);
        }
    }

    @Override
    protected void _singleAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        LetterOfCreditInfo info = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo(pk);
        if (info.getLetterStatus() == LetterStatusEnum.close) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.CANAUDITCLOSE);
        }
        if (info.getOperateStatus() != LetterOperateTypeEnum.submit) {
            throw new FMException(FMException.SELECT_SUBMITED_BILL);
        }
        DbUtil.execute((Context)ctx, (String)MessageFormat.format("update T_FIN_LetterOfCredit set FoperateStatus={0}, FauditorId=''{1}'' where FId=''{2}'' ", String.valueOf(1), userInfo.getId().toString(), pk.toString()));
    }

    private void setAssureAmount(Context ctx, LetterOfCreditInfo info) throws BOSException, EASBizException {
        String id;
        Set destBill;
        if (FMHelper.isEmpty((String)info.getSourceBillId())) {
            return;
        }
        String bizBillId = info.getSourceBillId();
        if (BOSUuid.read((String)bizBillId).getType().equals((Object)new LetterOfCreditApplyInfo().getBOSType()) && (destBill = FMHelper.getDestBillIdSet((Context)ctx, (String)bizBillId)).size() > 0 && BOSUuid.read((String)(id = (String)FMHelper.set2List((Set)destBill).get(0))).getType().equals((Object)new AssureAmountInfo().getBOSType())) {
            AssureAmountInfo assureAmount = AssureAmountFactory.getLocalInstance((Context)ctx).getAssureAmountInfo((IObjectPK)new ObjectStringPK(id));
            info.setMarginCurrency(assureAmount.getCurrency());
            info.setMarginRate(assureAmount.getAssureRate().multiply(Constants.ONE_HUNDRED));
            info.setMarginEx(assureAmount.getAmount());
            if (assureAmount.getAssureState().equals((Object)AssureStateEnum.CANCELLED)) {
                info.setMarginBalance(Constants.ZERO);
            } else {
                info.setMarginBalance(assureAmount.getAmount());
            }
            assureAmount.setPayablebill(info.getLetterNumber());
            AssureAmountFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectStringPK(assureAmount.getId().toString()), (CoreBaseInfo)assureAmount);
            HashMap<String, String> idMap = new HashMap<String, String>();
            idMap.put(info.getId().toString(), assureAmount.getId().toString());
            FMHelper.saveBOTRelation((Context)ctx, idMap);
        }
    }
}

