/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ebservice.CreditDealReceivedDetail;
import com.kingdee.bos.ebservice.CreditDealReceivedQueryResponseBody;
import com.kingdee.bos.ebservice.CreditDealReceivedResponseBody;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.app.service.LetterOfCreditEBGServiceUtil;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.be.app.service.vo.CreditDealReceivedPayDetailVO;
import com.kingdee.eas.fm.be.app.service.vo.CreditDealReceivedPayVO;
import com.kingdee.eas.fm.be.app.service.vo.DealReceivedPayQueryVO;
import com.kingdee.eas.fm.be.app.util.FmBeWebUtils;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.DeferReturnCLEntryFactory;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.fin.IRepayment;
import com.kingdee.eas.fm.fin.LetterException;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LetterOperateTypeEnum;
import com.kingdee.eas.fm.fin.LetterStatusEnum;
import com.kingdee.eas.fm.fin.LoanException;
import com.kingdee.eas.fm.fin.RepaymentCollection;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.app.AbstractRepaymentStragety;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.fm.nt.LetterOfCreditReachFactory;
import com.kingdee.eas.fm.nt.LetterOfCreditReachInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;

public class LetterOfCreditRepaymentStragety
extends AbstractRepaymentStragety {
    public static final int MAXLENGTH = 1000;
    public static final String RESOURCE = "com.kingdee.eas.fm.fin.FinWebResource";
    private static final String NTP_RES = "com.kingdee.eas.fm.ntp.NtpResource";

    @Override
    protected void beforeAddNew(Context ctx, IObjectValue model, FinancingBillInfo finBillInfo) throws BOSException, EASBizException {
    }

    @Override
    protected void dispose(Context ctx, IObjectValue model, FinancingBillInfo finBillInfo) throws BOSException, EASBizException {
    }

    @Override
    protected void afterAddNew(Context ctx, IObjectValue model, FinancingBillInfo finBillInfo) throws BOSException, EASBizException {
        LetterOfCreditFactory.getLocalInstance(ctx).autoClose((IObjectPK)new ObjectUuidPK(finBillInfo.getId()));
    }

    @Override
    protected void delBookAndSubsidiary(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RepaymentInfo info = (RepaymentInfo)model;
        SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).cancelBook(info.getId().toString());
        BookNotifyFacadeFactory.getLocalInstance((Context)ctx).antiBook(info.getId().toString());
    }

    @Override
    protected boolean isCancelLimit(Context ctx, IObjectValue model, FinancingBillInfo finBillInfo) throws BOSException, EASBizException {
        return true;
    }

    @Override
    protected void beforeDelete(Context ctx, IObjectValue model, FinancingBillInfo finBillInfo) throws BOSException, EASBizException {
        RepaymentInfo info = (RepaymentInfo)model;
        DeferReturnCLEntryFactory.getLocalInstance(ctx).cancelRecordedDeferReturnCL(info.getId().toString(), finBillInfo.getId().toString());
        if (((LetterOfCreditInfo)finBillInfo).getLetterStatus() == LetterStatusEnum.close) {
            LetterOfCreditFactory.getLocalInstance(ctx).autoOpen((IObjectPK)new ObjectStringPK(finBillInfo.getId().toString()));
        }
    }

    @Override
    protected void afterDelete(Context ctx, IObjectValue model, FinancingBillInfo finBillInfo) throws BOSException, EASBizException {
        RepaymentInfo info = (RepaymentInfo)model;
        this.dispose(ctx, (IObjectValue)info, LetterOperateTypeEnum.DELETE);
        this._updateLetterOfCredit(ctx, info.getSourceBillId());
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RepaymentInfo repayInfo = (RepaymentInfo)model;
        if (repayInfo.getPayment() == null) {
            repayInfo.setPayment(Constants.ZERO);
        }
        return super._save(ctx, model);
    }

    private void dispose(Context ctx, IObjectValue model, LetterOperateTypeEnum disposerActionEnum) throws EASBizException, BOSException {
        RepaymentInfo info = (RepaymentInfo)model;
        String sourceBillId = info.getSourceBillId();
        if (FMHelper.isEmpty((String)sourceBillId)) {
            return;
        }
        if (BOSUuid.read((String)info.getSourceBillId()).getType().equals((Object)new LetterOfCreditInfo().getBOSType())) {
            LetterOfCreditReachInfo reachinfo;
            LetterOfCreditInfo desinfo = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(sourceBillId), this.getLetterOfCreditSelector());
            int isGenRepayment = disposerActionEnum.equals((Object)LetterOperateTypeEnum.DELETE) || desinfo.getBalance().compareTo(Constants.ZERO) > 0 || desinfo.isIsDYZ() ? 0 : 1;
            this.updateLetterOfCredit(ctx, sourceBillId, new Integer(isGenRepayment));
            if (!EmptyUtil.isEmpty((String)info.getLetterOfCreditReachID()) && !EmptyUtil.isEmpty((CoreBaseInfo)(reachinfo = LetterOfCreditReachFactory.getLocalInstance((Context)ctx).getLetterOfCreditReachInfo((IObjectPK)new ObjectUuidPK(info.getLetterOfCreditReachID().toString()))))) {
                if (disposerActionEnum.equals((Object)LetterOperateTypeEnum.DELETE)) {
                    reachinfo.setIsGenPay(false);
                    reachinfo.setActualPayDate(null);
                } else {
                    reachinfo.setIsGenPay(true);
                    reachinfo.setActualPayDate(info.getBizDate());
                    HashMap<String, String> idMap = new HashMap<String, String>();
                    idMap.put(reachinfo.getId().toString(), info.getId().toString());
                    FMHelper.saveBOTRelation((Context)ctx, idMap);
                }
                LetterOfCreditReachFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(info.getLetterOfCreditReachID().toString()), (CoreBaseInfo)reachinfo);
            }
        }
    }

    private void updateLetterOfCredit(Context ctx, String sourceBillId, Integer isGenRepayment) throws BOSException, EASBizException {
        String sql = " update t_fin_letterofcredit set fisGenRepayment=? where fid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{isGenRepayment, sourceBillId});
    }

    private SelectorItemCollection getLetterOfCreditSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("payBankAcct.*");
        sic.add("payBankAcct.currency.id");
        sic.add("marginAcct.*");
        sic.add("marginAcct.currency.id");
        sic.add("payBankAcct.account.id");
        sic.add("marginAcct.account.id");
        sic.add("marginAcct.account.id");
        sic.add("CreditLimit.*");
        return sic;
    }

    @Override
    protected void _updateLetterOfCredit(Context ctx, String letterOfCreditID) throws BOSException, EASBizException {
        String sql = "select fid,fhxdnumber,fbabnumber from t_Fin_Repayment where fsourcebillid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{letterOfCreditID});
        String hxdNumber = "";
        String babNumber = "";
        try {
            while (rs.next()) {
                if (rs.getString("fhxdnumber") != null && !rs.getString("fhxdnumber").equals("")) {
                    hxdNumber = hxdNumber + rs.getString("fhxdnumber") + ",";
                }
                if (rs.getString("fbabnumber") == null || rs.getString("fbabnumber").equals("")) continue;
                babNumber = babNumber + rs.getString("fbabnumber") + ",";
            }
            if (hxdNumber.indexOf(",") > 0) {
                hxdNumber = hxdNumber.substring(0, hxdNumber.lastIndexOf(","));
            }
            if (babNumber.indexOf(",") > 0) {
                babNumber = babNumber.substring(0, babNumber.lastIndexOf(","));
            }
            String updateSQL = "UPDATE t_Fin_Letterofcredit SET FHxdNumber = ? ,FBabNumber = ? WHERE FID = ?";
            DbUtil.execute((Context)ctx, (String)updateSQL, (Object[])new Object[]{hxdNumber, babNumber, letterOfCreditID});
        }
        catch (SQLException e) {
            throw new SQLDataException();
        }
    }

    @Override
    protected void afterSubmit(Context ctx, IObjectValue model, FinancingBillInfo finBillInfo, boolean isAddNew) throws BOSException, EASBizException {
        RepaymentInfo info = (RepaymentInfo)model;
        this.dispose(ctx, (IObjectValue)info, LetterOperateTypeEnum.submit);
        this._updateLetterOfCredit(ctx, info.getSourceBillId());
    }

    @Override
    protected void subVerifyBeforeBook(Context ctx, RepaymentInfo info) throws BOSException, EASBizException {
        String PayBankAcctCurrencyID;
        String billCurrecyID = info.getCurrency().getId().toString();
        if (info.getBankAcct() != null && info.getBankAcct().isIsByCurrency() && !billCurrecyID.equals(PayBankAcctCurrencyID = info.getBankAcct().getCurrency().getId().toString())) {
            throw new LoanException(LoanException.NOTBOOK2, new Object[]{info.getNumber()});
        }
    }

    @Override
    protected void _writeLetterOfCredit(Context ctx, IObjectValue mode) throws BOSException, EASBizException {
        RepaymentInfo info = (RepaymentInfo)mode;
        String id = info.getSourceBillId();
        LetterOfCreditInfo letterOfCreditInfo = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(id));
        String letterHxdNumber = letterOfCreditInfo.getHxdNumber();
        String letterBabNumber = letterOfCreditInfo.getBabNumber();
        String repaymentHxdNumber = info.getHxdNumber();
        String repaymentBabNumber = info.getBabNumber();
        Object[] param = null;
        String sql = "UPDATE t_Fin_Letterofcredit SET";
        String hxdNumber = "";
        String babNumber = "";
        if (!repaymentHxdNumber.equals("") && !repaymentHxdNumber.equals("")) {
            sql = sql + " FHxdNumber = ? ,FBabNumber = ? WHERE FID = ? ";
            hxdNumber = letterHxdNumber == null ? repaymentHxdNumber : letterHxdNumber + " , " + repaymentHxdNumber;
            babNumber = letterBabNumber == null ? repaymentBabNumber : letterBabNumber + " , " + repaymentBabNumber;
            param = new Object[]{hxdNumber, babNumber, id};
        } else if (!repaymentHxdNumber.equals("")) {
            sql = sql + " FHxdNumber = ? WHERE FID = ? ";
            hxdNumber = letterHxdNumber == null ? repaymentHxdNumber : letterHxdNumber + " , " + repaymentHxdNumber;
            param = new Object[]{hxdNumber, id};
        } else {
            sql = sql + " FBabNumber = ? WHERE FID = ? ";
            babNumber = letterBabNumber == null ? repaymentBabNumber : letterBabNumber + " , " + repaymentBabNumber;
            param = new Object[]{babNumber, id};
        }
        if (hxdNumber.length() > 1000 || babNumber.length() > 1000) {
            throw new FinBizException(FinBizException.TOOLONG);
        }
        DbUtil.execute((Context)ctx, (String)sql, (Object[])param);
    }

    @Override
    protected Map _commitToBe(Context ctx, String[] ids) throws BOSException, EASBizException {
        IRepayment repayment = RepaymentFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        Set idSet = CASWebUtil.ids2Set((String[])ids);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.setSelector(this.getSelectors());
        RepaymentCollection coll = repayment.getRepaymentCollection(ev);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        ArrayList idList = new ArrayList(idSet);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
        for (int i = 0; i < coll.size(); ++i) {
            RepaymentInfo info = coll.get(i);
            try {
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_repayment_commitToBe");
                if (!isPermission) {
                    throw new RuntimeException(EASResource.getString((String)RESOURCE, (String)"NO_COMMIT_TO_BE_PERMISSION", (Object[])new String[]{info.getCompany().getName()}));
                }
                LetterOfCreditReachInfo lcrInfo = null;
                if (info.getLetterOfCreditReachID() == null) {
                    throw new Exception(EASResource.getString((String)RESOURCE, (String)"ReachId_IsNull_185", (Object[])new String[]{info.getNumber()}));
                }
                lcrInfo = LetterOfCreditReachFactory.getLocalInstance((Context)ctx).getLetterOfCreditReachInfo((IObjectPK)new ObjectUuidPK(info.getLetterOfCreditReachID()), this.getLcrSelectors());
                LetterOfCreditInfo lcInfo = null;
                if (lcrInfo.getCredit().getId() == null) {
                    throw new Exception(EASResource.getString((String)RESOURCE, (String)"LetterId_IsNull_186", (Object[])new String[]{info.getNumber()}));
                }
                lcInfo = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(lcrInfo.getCredit().getId().toString()), this.getLcSelectors());
                Boolean isLocked = (Boolean)requestMap.get(info.getId().toString());
                this.beforeCommit(ctx, info, lcInfo, lcrInfo, isLocked);
                this.doCommitToBe(ctx, info, lcInfo, lcrInfo);
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(EASResource.getString((String)RESOURCE, (String)"REPAYMENT_COMMIT_TO_BE_FAILED", (Object[])new String[]{info.getNumber(), e.getMessage()}));
            }
        }
        summary = success == ids.length ? summary + EASResource.getString((String)RESOURCE, (String)"ALL_COMMIT_TO_BE_SUCCESS") : summary + EASResource.getString((String)RESOURCE, (String)"COMMIT_TO_BE_RESULT", (Object[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    private void doCommitToBe(Context ctx, RepaymentInfo info, LetterOfCreditInfo lcInfo, LetterOfCreditReachInfo lcrInfo) throws EASBizException, BOSException {
        LetterOfCreditEBGServiceUtil util = new LetterOfCreditEBGServiceUtil();
        try {
            CreditDealReceivedPayVO vo = this.beforeProcess(ctx, info, lcInfo, lcrInfo);
            CreditDealReceivedResponseBody res = util.dealReceivedPay(ctx, vo);
            info.setIsCommitToBe(true);
            this.updatePartial(ctx, (CoreBaseInfo)info, ConvertUtils.SIC((Object[])new Object[]{"isCommitToBe"}));
            this.afterProcess(ctx, lcInfo, lcrInfo, info, res.getDetails(), null);
        }
        catch (BEException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            if (err instanceof AxisFault && ((AxisFault)err).getFaultString().indexOf("SAXException") != -1) {
                throw new BEException(BEException.EBSERVICE_PARAM_PARSE_ERROR);
            }
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
    }

    private void afterProcess(Context ctx, LetterOfCreditInfo lcInfo, LetterOfCreditReachInfo lcrInfo, RepaymentInfo info, CreditDealReceivedDetail[] details, String detailSeqId) throws EASBizException, BOSException, ParseException {
        SelectorItemCollection sic = new SelectorItemCollection();
        for (int i = 0; i < details.length; ++i) {
            CreditDealReceivedDetail detail = details[i];
            if (detailSeqId != null && !detailSeqId.equals(detail.getDetailSeqId())) continue;
            sic.add(new SelectorItemInfo("bankReturnStatus"));
            info.setBankReturnStatus(BankReturnStatusEnum.getEnum((String)detail.getEbStatus()));
            sic.add(new SelectorItemInfo("bankReturnMsg"));
            info.setBankReturnMsg(detail.getBankStatusMsg());
            sic.add(new SelectorItemInfo("detailSeqID"));
            info.setDetailSeqID(detail.getDetailSeqId());
            if (3 != info.getBankReturnStatus().getValue()) continue;
            this.updateCreditOfLetterReach(ctx, lcrInfo, detail);
            this.updateCreditOfLetter(ctx, lcrInfo, lcInfo, detail);
        }
        this.updatePartial(ctx, (CoreBaseInfo)info, sic);
    }

    private void updateCreditOfLetterReach(Context ctx, LetterOfCreditReachInfo lcrInfo, CreditDealReceivedDetail detail) throws ParseException, EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        lcrInfo.setActualPayDate(sdf.parse(detail.getPayDate()));
        sic.add(new SelectorItemInfo("ActualPayDate"));
        LetterOfCreditReachFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)lcrInfo, sic);
    }

    private void updateCreditOfLetter(Context ctx, LetterOfCreditReachInfo lcrInfo, LetterOfCreditInfo lcInfo, CreditDealReceivedDetail detail) throws ParseException, EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        BigDecimal balance = lcInfo.getBalance().subtract(lcrInfo.getAmount());
        if (!lcInfo.isIsDYZ() && balance.equals(Constants.ZERO)) {
            sic.add(new SelectorItemInfo("closeTime"));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            lcInfo.setCloseTime(sdf.parse(detail.getPayDate()));
        }
        lcInfo.setBalance(balance);
        sic.add(new SelectorItemInfo("Balance"));
        LetterOfCreditFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)lcInfo, sic);
    }

    private CreditDealReceivedPayVO beforeProcess(Context ctx, RepaymentInfo info, LetterOfCreditInfo lcInfo, LetterOfCreditReachInfo lcrInfo) throws EASBizException, BOSException {
        CreditDealReceivedPayVO vo = new CreditDealReceivedPayVO();
        String[] serialNos = beServiceHelper.getSerialNumber((int)1);
        vo.setAccNo(lcInfo.getPayBankAcct().getBankAccountNumber());
        vo.setBatchSeqId(serialNos[0]);
        vo.setCurrency(info.getCurrency().getIsoCode());
        vo.setTotalCount("1");
        CreditDealReceivedPayDetailVO detailVo = new CreditDealReceivedPayDetailVO();
        ArrayList<CreditDealReceivedPayDetailVO> details = new ArrayList<CreditDealReceivedPayDetailVO>();
        detailVo.setAmount(info.getAmount().toString());
        detailVo.setApplicant(lcrInfo.getApplicant());
        detailVo.setApplyDate(info.getBizDate());
        detailVo.setBranchNo(lcrInfo.getBranchNo());
        detailVo.setBeneficiary(lcrInfo.getBeneficiary());
        detailVo.setClaimAmount(lcrInfo.getClaimAmount().toString());
        detailVo.setContractNo(lcrInfo.getContractNo());
        detailVo.setCreditNo(lcInfo.getLetterNumber());
        detailVo.setDetailBizNo(info.getNumber());
        detailVo.setDetailSeqId(serialNos[0]);
        detailVo.setIsForward(lcInfo.isIsForward());
        detailVo.setReferenceNum(lcrInfo.getReferenceNum());
        detailVo.setReceivedCreditNumber(lcrInfo.getNumber());
        details.add(detailVo);
        vo.setDetails(details);
        info.setDetailSeqID(serialNos[0]);
        info.setIsCommitToBe(true);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isCommitToBe"));
        sic.add(new SelectorItemInfo("detailSeqID"));
        this.updatePartial(ctx, (CoreBaseInfo)info, sic);
        return vo;
    }

    private void beforeCommit(Context ctx, RepaymentInfo info, LetterOfCreditInfo lcInfo, LetterOfCreditReachInfo lcrInfo, boolean isLocked) throws Exception {
        if (lcrInfo.isIsAccept()) {
            throw new Exception(EASResource.getString((String)RESOURCE, (String)"REACH_IS_ACCEPT"));
        }
        if (!isLocked) {
            throw new Exception(EASResource.getString((String)RESOURCE, (String)"REPAYMENT_IS_LOCKED"));
        }
        if (!lcInfo.isIsDirect()) {
            throw new Exception(EASResource.getString((String)RESOURCE, (String)"CantCommitToBE_183"));
        }
        if (1 != info.getStatusExtEnum().getValue()) {
            throw new Exception(EASResource.getString((String)RESOURCE, (String)"REPAYMENT_NOT_AUDIT"));
        }
        boolean isBEProcessing = false;
        if (info.getBankReturnStatus() == null || BankReturnStatusEnum.EB_PROCESSING.equals((Object)info.getBankReturnStatus()) || BankReturnStatusEnum.BANK_PROCESSING.equals((Object)info.getBankReturnStatus()) || BankReturnStatusEnum.BANK_EXCEPTION.equals((Object)info.getBankReturnStatus())) {
            isBEProcessing = true;
        }
        if (info.isIsCommitToBe() && isBEProcessing) {
            throw new Exception(EASResource.getString((String)NTP_RES, (String)"012_BE_PROCESSING_WAITING"));
        }
        if (info.isIsCommitToBe() && BankReturnStatusEnum.BANK_SUCCESS.equals((Object)info.getBankReturnStatus())) {
            throw new Exception(EASResource.getString((String)NTP_RES, (String)"043_COMMITTOBE_FINISHED"));
        }
    }

    @Override
    protected Map _synStatus(Context ctx, String[] ids) throws BOSException, EASBizException {
        IRepayment repayment = RepaymentFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        Set idSet = CASWebUtil.ids2Set((String[])ids);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.setSelector(this.getSelectors());
        RepaymentCollection coll = repayment.getRepaymentCollection(ev);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        ArrayList idList = new ArrayList(idSet);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
        int success = 0;
        for (int i = 0; i < coll.size(); ++i) {
            RepaymentInfo info = coll.get(i);
            try {
                LetterOfCreditReachInfo lcrInfo = null;
                if (info.getLetterOfCreditReachID() == null) {
                    throw new Exception(EASResource.getString((String)RESOURCE, (String)"ReachId_IsNull_185", (Object[])new String[]{info.getNumber()}));
                }
                lcrInfo = LetterOfCreditReachFactory.getLocalInstance((Context)ctx).getLetterOfCreditReachInfo((IObjectPK)new ObjectUuidPK(info.getLetterOfCreditReachID()), this.getLcrSelectors());
                LetterOfCreditInfo lcInfo = null;
                if (lcrInfo.getCredit().getId() == null) {
                    throw new Exception(EASResource.getString((String)RESOURCE, (String)"LetterId_IsNull_186", (Object[])new String[]{info.getNumber()}));
                }
                lcInfo = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(lcrInfo.getCredit().getId().toString()), this.getLcSelectors());
                Boolean isLocked = (Boolean)requestMap.get(info.getId().toString());
                this.beforeSynStatus(ctx, info, lcInfo, lcrInfo.isIsAccept(), isLocked);
                if (info.getBankReturnStatus() == null || info.getBankReturnStatus().getValue() != 3) {
                    this.doSynStatus(ctx, info, lcInfo, lcrInfo);
                }
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(EASResource.getString((String)RESOURCE, (String)"REPAYMENT_SYN_STATUS_FAILED", (Object[])new String[]{info.getNumber(), e.getMessage()}));
            }
        }
        summary = success == ids.length ? summary + EASResource.getString((String)RESOURCE, (String)"ALL_SYN_STATUS_SUCCESS") : summary + EASResource.getString((String)RESOURCE, (String)"REPAYMENT_SYN_STATUS_RESULT", (Object[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    private void doSynStatus(Context ctx, RepaymentInfo info, LetterOfCreditInfo lcInfo, LetterOfCreditReachInfo lcrInfo) throws EASBizException, BOSException {
        LetterOfCreditEBGServiceUtil util = new LetterOfCreditEBGServiceUtil();
        try {
            DealReceivedPayQueryVO vo = this.beforeProcess4Update(ctx, info, lcInfo);
            CreditDealReceivedQueryResponseBody res = util.dealReceivedPayQuery(ctx, vo);
            this.afterProcess(ctx, lcInfo, lcrInfo, info, res.getDetails(), info.getDetailSeqID());
        }
        catch (BEException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            if (err instanceof AxisFault && ((AxisFault)err).getFaultString().indexOf("SAXException") != -1) {
                throw new BEException(BEException.EBSERVICE_PARAM_PARSE_ERROR);
            }
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
    }

    private DealReceivedPayQueryVO beforeProcess4Update(Context ctx, RepaymentInfo info, LetterOfCreditInfo lcInfo) {
        DealReceivedPayQueryVO vo = new DealReceivedPayQueryVO();
        vo.setAccNo(lcInfo.getPayBankAcct().getBankAccountNumber());
        vo.setBatchBizNo(info.getNumber());
        vo.setBatchSeqId(info.getDetailSeqID());
        vo.setCurrency(info.getCurrency().getIsoCode());
        vo.setIsForward(lcInfo.isIsForward());
        return vo;
    }

    private void beforeSynStatus(Context ctx, RepaymentInfo info, LetterOfCreditInfo lcInfo, Boolean isAccept, Boolean isLocked) throws EASBizException, BOSException {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_repayment_synStatus");
        if (!isPermission) {
            throw new RuntimeException(EASResource.getString((String)RESOURCE, (String)"NO_SYN_STATUS_PERMISSION", (Object[])new String[]{info.getCompany().getName()}));
        }
        if (!lcInfo.isIsDirect()) {
            throw new RuntimeException(EASResource.getString((String)RESOURCE, (String)"CantSynStatus_184"));
        }
        if (isAccept.booleanValue()) {
            throw new RuntimeException(EASResource.getString((String)RESOURCE, (String)"REACH_IS_ACCEPT"));
        }
        if (!info.isIsCommitToBe()) {
            throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"062_CANNOT_SYNCSTATUS"));
        }
        if (info.getBankReturnStatus() == BankReturnStatusEnum.BANK_FAIL || info.getBankReturnStatus() == BankReturnStatusEnum.BANK_SUCCESS || info.getBankReturnStatus() == BankReturnStatusEnum.BANK_EXCEPTION) {
            throw new LetterException(LetterException.SUCCESSORFAILCANTSYNSTATUS_064);
        }
    }

    @Override
    protected Map _modifyBankReturnStatus(Context ctx, String id, int status) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("bankReturnStatus"));
        RepaymentInfo info = RepaymentFactory.getLocalInstance(ctx).getRepaymentInfo((IObjectPK)new ObjectUuidPK(id));
        try {
            if (!BankReturnStatusEnum.BANK_EXCEPTION.equals((Object)info.getBankReturnStatus())) {
                throw new LetterException(LetterException.CANTMODIFYBANKRETURNSTATUS_080);
            }
            info.setBankReturnStatus(BankReturnStatusEnum.getEnum((int)status));
            if (status == 3) {
                LetterOfCreditReachInfo lcrInfo = null;
                String lcrId = info.getLetterOfCreditReachID();
                if (lcrId != null && "E9E77DEA".equals(BOSUuid.read((String)lcrId).getType().toString())) {
                    lcrInfo = LetterOfCreditReachFactory.getLocalInstance((Context)ctx).getLetterOfCreditReachInfo((IObjectPK)new ObjectUuidPK(lcrId));
                    SelectorItemCollection lrcsic = new SelectorItemCollection();
                    lcrInfo.setActualPayDate(new Date());
                    sic.add(new SelectorItemInfo("ActualPayDate"));
                    LetterOfCreditReachFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)lcrInfo, lrcsic);
                }
                SelectorItemCollection lcsic = new SelectorItemCollection();
                if (FinancingBillTypeEnum.LetterOfCredit.equals((Object)info.getSourceType()) && info.getSourceBillId() != null && lcrInfo != null) {
                    LetterOfCreditInfo lcInfo = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
                    BigDecimal balance = lcInfo.getBalance().subtract(lcrInfo.getAmount());
                    if (!lcInfo.isIsDYZ() && balance.equals(Constants.ZERO)) {
                        lcsic.add(new SelectorItemInfo("closeTime"));
                        lcInfo.setCloseTime(new Date());
                    }
                    lcInfo.setBalance(balance);
                    sic.add(new SelectorItemInfo("Balance"));
                    LetterOfCreditFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)lcInfo, lcsic);
                }
            }
            RepaymentFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
            result.setError(0);
            result.setSummaryMsg(EASResource.getString((String)"com.kingdee.eas.fm.fin.LetterOfCreditWebResource", (String)"StatusUpdateSuccess_103"));
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }

    private SelectorItemCollection getLcSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isDirect"));
        sic.add(new SelectorItemInfo("payBankAcct.*"));
        sic.add(new SelectorItemInfo("payBankAcct.id"));
        sic.add(new SelectorItemInfo("payBankAcct.name"));
        sic.add(new SelectorItemInfo("payBankAcct.bankAccountNumber"));
        sic.add(new SelectorItemInfo("payBankAcct.number"));
        sic.add(new SelectorItemInfo("Currency.*"));
        sic.add(new SelectorItemInfo("Currency.id"));
        sic.add(new SelectorItemInfo("Currency.isoCode"));
        sic.add(new SelectorItemInfo("Amount"));
        sic.add(new SelectorItemInfo("Balance"));
        sic.add(new SelectorItemInfo("LocalCurExRate"));
        sic.add(new SelectorItemInfo("IsInCredit"));
        sic.add(new SelectorItemInfo("IssueDate"));
        sic.add(new SelectorItemInfo("ExpiredDate"));
        sic.add(new SelectorItemInfo("Horizon"));
        sic.add(new SelectorItemInfo("Remark"));
        sic.add(new SelectorItemInfo("Garantee"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("GaranteeType.name"));
        sic.add(new SelectorItemInfo("Currency.name"));
        sic.add(new SelectorItemInfo("Currency.name"));
        sic.add(new SelectorItemInfo("Currency.*"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("IsForward"));
        sic.add(new SelectorItemInfo("Beneficiary"));
        sic.add(new SelectorItemInfo("Institution.name"));
        sic.add(new SelectorItemInfo("Currency.id"));
        sic.add(new SelectorItemInfo("accountant.name"));
        sic.add(new SelectorItemInfo("creditPercentage"));
        sic.add(new SelectorItemInfo("ntType.name"));
        sic.add(new SelectorItemInfo("marginRate"));
        sic.add(new SelectorItemInfo("limitMargin"));
        sic.add(new SelectorItemInfo("marginCurrency.name"));
        sic.add(new SelectorItemInfo("marginExRate"));
        sic.add(new SelectorItemInfo("marginEx"));
        sic.add(new SelectorItemInfo("marginAcct.name"));
        sic.add(new SelectorItemInfo("marginBalance"));
        sic.add(new SelectorItemInfo("payBankAcct.name"));
        sic.add(new SelectorItemInfo("marginAlgorithm"));
        sic.add(new SelectorItemInfo("cashier.name"));
        sic.add(new SelectorItemInfo("department.name"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("LetterStatus"));
        sic.add(new SelectorItemInfo("operateStatus"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("contractNumber"));
        sic.add(new SelectorItemInfo("contractCurrenc.name"));
        sic.add(new SelectorItemInfo("letterNumber"));
        sic.add(new SelectorItemInfo("contractAmount"));
        sic.add(new SelectorItemInfo("AmountLocalCur"));
        sic.add(new SelectorItemInfo("BeneficiaryStat.name"));
        sic.add(new SelectorItemInfo("forwardDate"));
        sic.add(new SelectorItemInfo("intendPayDate"));
        sic.add(new SelectorItemInfo("TransportMode"));
        sic.add(new SelectorItemInfo("LoadPort"));
        sic.add(new SelectorItemInfo("DestinationPort"));
        sic.add(new SelectorItemInfo("LoadDate"));
        sic.add(new SelectorItemInfo("IsBatch"));
        sic.add(new SelectorItemInfo("IsDivert"));
        sic.add(new SelectorItemInfo("IsDYZ"));
        sic.add(new SelectorItemInfo("FluctuateScale"));
        sic.add(new SelectorItemInfo("LtterHandler.name"));
        sic.add(new SelectorItemInfo("babNumber"));
        sic.add(new SelectorItemInfo("hxdNumber"));
        sic.add(new SelectorItemInfo("NotifyBank.name"));
        sic.add(new SelectorItemInfo("guaranteeTypeInputMode"));
        sic.add(new SelectorItemInfo("contractCurrenc.id"));
        sic.add(new SelectorItemInfo("DeferReturnCreditLimitDays"));
        sic.add(new SelectorItemInfo("DeferReturnCLEntrys.seq"));
        sic.add(new SelectorItemInfo("Repayment.bizDate"));
        sic.add(new SelectorItemInfo("DeferReturnCLEntrys.isReturnedCL"));
        sic.add(new SelectorItemInfo("DeferReturnCLEntrys.supposeCLReturnDate"));
        sic.add(new SelectorItemInfo("DeferReturnCLEntrys.actualCLReturnDate"));
        sic.add(new SelectorItemInfo("Repayment.ReturnedQuota"));
        sic.add(new SelectorItemInfo("Repayment.id"));
        sic.add(new SelectorItemInfo("DeferReturnCLEntrys.id"));
        sic.add(new SelectorItemInfo("FluctuateScalefloor"));
        sic.add(new SelectorItemInfo("Currency2.id"));
        sic.add(new SelectorItemInfo("closeTime"));
        sic.add(new SelectorItemInfo("Currency2.name"));
        sic.add(new SelectorItemInfo("CreditCurExRate"));
        sic.add(new SelectorItemInfo("creditLocalAmt"));
        sic.add(new SelectorItemInfo("LtterHandler.name"));
        return sic;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("Currency.*"));
        sic.add(new SelectorItemInfo("Currency.id"));
        sic.add(new SelectorItemInfo("Currency.isoCode"));
        sic.add(new SelectorItemInfo("letterOfCreditReachID"));
        sic.add(new SelectorItemInfo("detailSeqID"));
        sic.add(new SelectorItemInfo("bankReturnStatus"));
        sic.add(new SelectorItemInfo("bankReturnMsg"));
        sic.add(new SelectorItemInfo("isCommitToBe"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("statusExtEnum"));
        sic.add(new SelectorItemInfo("CTLCancel"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("SourceType"));
        sic.add(new SelectorItemInfo("Creditor.id"));
        sic.add(new SelectorItemInfo("Creditor.number"));
        sic.add(new SelectorItemInfo("Creditor.name"));
        sic.add(new SelectorItemInfo("Currency.*"));
        sic.add(new SelectorItemInfo("BankAcct.id"));
        sic.add(new SelectorItemInfo("BankAcct.number"));
        sic.add(new SelectorItemInfo("BankAcct.name"));
        sic.add(new SelectorItemInfo("BankAcct.bankAccountNumber"));
        sic.add(new SelectorItemInfo("LoanAcct.id"));
        sic.add(new SelectorItemInfo("LoanAcct.number"));
        sic.add(new SelectorItemInfo("LoanAcct.name"));
        sic.add(new SelectorItemInfo("CreditCurrency.*"));
        sic.add(new SelectorItemInfo("CreditCurrency.id"));
        sic.add(new SelectorItemInfo("CreditCurrency.number"));
        sic.add(new SelectorItemInfo("CreditCurrency.name"));
        sic.add(new SelectorItemInfo("CreditCurExRate"));
        sic.add(new SelectorItemInfo("ReturnedQuota"));
        sic.add(new SelectorItemInfo("CreditLimit.id"));
        sic.add(new SelectorItemInfo("CreditLimit.number"));
        sic.add(new SelectorItemInfo("creditPercetage"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("LocalCurExRate"));
        sic.add(new SelectorItemInfo("LocalAmount"));
        sic.add(new SelectorItemInfo("useAssureBill"));
        sic.add(new SelectorItemInfo("assureBill.id"));
        sic.add(new SelectorItemInfo("assureBill.number"));
        sic.add(new SelectorItemInfo("assCurrency.*"));
        sic.add(new SelectorItemInfo("assExRate"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("cautionAmt"));
        sic.add(new SelectorItemInfo("acutionAcctBank.id"));
        sic.add(new SelectorItemInfo("acutionAcctBank.number"));
        sic.add(new SelectorItemInfo("acutionAcctBank.name"));
        sic.add(new SelectorItemInfo("marginCurrency.*"));
        sic.add(new SelectorItemInfo("marginCurrency.id"));
        sic.add(new SelectorItemInfo("marginCurrency.number"));
        sic.add(new SelectorItemInfo("marginCurrency.name"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("costCenter.id"));
        sic.add(new SelectorItemInfo("costCenter.number"));
        sic.add(new SelectorItemInfo("costCenter.name"));
        sic.add(new SelectorItemInfo("isCalInt"));
        sic.add(new SelectorItemInfo("isRepayInt"));
        sic.add(new SelectorItemInfo("isCalPunishInt"));
        sic.add(new SelectorItemInfo("isPerformanced"));
        sic.add(new SelectorItemInfo("babNumber"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("Payment"));
        sic.add(new SelectorItemInfo("Interest"));
        sic.add(new SelectorItemInfo("hxdNumber"));
        sic.add(new SelectorItemInfo("InterestAcct.id"));
        sic.add(new SelectorItemInfo("InterestAcct.number"));
        sic.add(new SelectorItemInfo("InterestAcct.name"));
        sic.add(new SelectorItemInfo("SourceCurrency.id"));
        sic.add(new SelectorItemInfo("SourceCurrency.number"));
        sic.add(new SelectorItemInfo("SourceCurrency.name"));
        sic.add(new SelectorItemInfo("SourceCurExRate"));
        sic.add(new SelectorItemInfo("marginBalance"));
        sic.add(new SelectorItemInfo("Amount"));
        sic.add(new SelectorItemInfo("addAmount"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("repaySeq"));
        sic.add(new SelectorItemInfo("innerAccount.id"));
        sic.add(new SelectorItemInfo("innerAccount.number"));
        sic.add(new SelectorItemInfo("innerAccount.name"));
        sic.add(new SelectorItemInfo("intFeeAcctView.id"));
        sic.add(new SelectorItemInfo("intFeeAcctView.number"));
        sic.add(new SelectorItemInfo("intFeeAcctView.name"));
        sic.add(new SelectorItemInfo("description"));
        return sic;
    }

    public SelectorItemCollection getLcrSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("claimAmount"));
        sic.add(new SelectorItemInfo("branchNo"));
        sic.add(new SelectorItemInfo("referenceNum"));
        sic.add(new SelectorItemInfo("noticedDate"));
        sic.add(new SelectorItemInfo("receivedNoticeDate"));
        sic.add(new SelectorItemInfo("systemBuisnessNo"));
        sic.add(new SelectorItemInfo("contractNo"));
        sic.add(new SelectorItemInfo("applicant"));
        sic.add(new SelectorItemInfo("beneficiary"));
        sic.add(new SelectorItemInfo("BillState"));
        sic.add(new SelectorItemInfo("Credit.Amount"));
        sic.add(new SelectorItemInfo("Credit.Balance"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("dealMode"));
        sic.add(new SelectorItemInfo("ReachDate"));
        sic.add(new SelectorItemInfo("ReachNum"));
        sic.add(new SelectorItemInfo("Amount"));
        sic.add(new SelectorItemInfo("handler.name"));
        sic.add(new SelectorItemInfo("ActualPayDate"));
        sic.add(new SelectorItemInfo("Credit.id"));
        sic.add(new SelectorItemInfo("Credit.IsBatch"));
        sic.add(new SelectorItemInfo("Credit.intendPayDate"));
        sic.add(new SelectorItemInfo("Remark"));
        sic.add(new SelectorItemInfo("IsRefuse"));
        sic.add(new SelectorItemInfo("IsGenPay"));
        sic.add(new SelectorItemInfo("IsGenLoanReq"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("IsAccept"));
        sic.add(new SelectorItemInfo("AccREcord.bizDate"));
        sic.add(new SelectorItemInfo("Currency.name"));
        sic.add(new SelectorItemInfo("AccREcord.rate"));
        sic.add(new SelectorItemInfo("AccREcord.amount"));
        sic.add(new SelectorItemInfo("DraftDay"));
        sic.add(new SelectorItemInfo("PlanPayDate"));
        sic.add(new SelectorItemInfo("Credit.letterNumber"));
        return sic;
    }
}

