/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ebservice.CreditOpenBody;
import com.kingdee.bos.ebservice.CreditOpenDetail;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.basedata.CasUtilFacadeFactory;
import com.kingdee.eas.fi.cas.basedata.ICasUtilFacade;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.app.service.LetterOfCreditEBGServiceUtil;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.be.app.service.vo.OpenCreditDetailVO;
import com.kingdee.eas.fm.be.app.service.vo.OpenCreditQueryVO;
import com.kingdee.eas.fm.be.app.service.vo.OpenCreditVO;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.FMBooleanEnum;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ctl.AssureBillFactory;
import com.kingdee.eas.fm.ctl.AssureBillInfo;
import com.kingdee.eas.fm.ctl.BankFactorFactory;
import com.kingdee.eas.fm.ctl.BankFactorInfo;
import com.kingdee.eas.fm.fin.AtEnum;
import com.kingdee.eas.fm.fin.DeferReturnCLEntryCollection;
import com.kingdee.eas.fm.fin.DeferReturnCLEntryFactory;
import com.kingdee.eas.fm.fin.DeferReturnCLEntryInfo;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.GuanTypeBillEnum;
import com.kingdee.eas.fm.fin.GuaranteeDetailInfo;
import com.kingdee.eas.fm.fin.GuaranteeTypeInputModeEnum;
import com.kingdee.eas.fm.fin.ILetterOfCredit;
import com.kingdee.eas.fm.fin.LetOfCreditAcctRecordCollection;
import com.kingdee.eas.fm.fin.LetOfCreditAcctRecordFactory;
import com.kingdee.eas.fm.fin.LetOfCreditAcctRecordInfo;
import com.kingdee.eas.fm.fin.LetterException;
import com.kingdee.eas.fm.fin.LetterOfCreditCollection;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LetterOperateTypeEnum;
import com.kingdee.eas.fm.fin.LetterStatusEnum;
import com.kingdee.eas.fm.fin.ModifyLetterCollection;
import com.kingdee.eas.fm.fin.ModifyLetterFactory;
import com.kingdee.eas.fm.fin.WageFactory;
import com.kingdee.eas.fm.fin.WageInfo;
import com.kingdee.eas.fm.fin.app.AbstractLetterOfCreditWebFacadeControllerBean;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.fm.nt.LetterOfCreditApplyException;
import com.kingdee.eas.fm.nt.NTTypeCollection;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LetterOfCreditWebFacadeControllerBean
extends AbstractLetterOfCreditWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.LetterOfCreditWebFacadeControllerBean");
    public static final String CBS_RES = "com.kingdee.eas.fm.ntp.NtpResource";
    public static final String RESOURCE = "com.kingdee.eas.fm.fin.LetterOfCreditWebResource";

    @Override
    protected Map _batchAudit(Context ctx, String[] Ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{Ids.length + ""});
        int success = 0;
        for (int i = 0; i < Ids.length; ++i) {
            LetterOfCreditInfo info = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(Ids[i]));
            try {
                this.verifybeforeAudit(ctx, info);
                LetterOfCreditFactory.getLocalInstance(ctx).singleAudit((IObjectPK)new ObjectUuidPK(Ids[i]));
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(this.getResouceString("CREDITAUDITERROR_77", info.getNumber(), e.getMessage()));
            }
        }
        summary = success == Ids.length ? summary + EASResource.getString((String)RESOURCE, (String)"ALL_AUDIT_SUCCESS") : summary + EASResource.getString((String)RESOURCE, (String)"AUDIT_RESULT", (Object[])new String[]{String.valueOf(success), String.valueOf(Ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    private void verifybeforeAudit(Context ctx, LetterOfCreditInfo info) throws EASBizException, BOSException {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_LetterOfCredit_audit");
        if (!isPermission) {
            String companyId = info.getCompany().getId().toString();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NOCREDITAUDITPERMISSION_066, (Object[])new String[]{company.getName()});
        }
        boolean idInProcess = FMHelper.hasWFInstance((Context)ctx, (String)info.getId().toString());
        if (idInProcess) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.INWORKFLOWCANTAUDIT_067);
        }
        if (info.getLetterStatus() == LetterStatusEnum.close) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.CLOSEDCREDITCANTAUDIT_068);
        }
    }

    @Override
    protected Map _batchUnAudit(Context ctx, String[] Ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{Ids.length + ""});
        int success = 0;
        for (int i = 0; i < Ids.length; ++i) {
            LetterOfCreditInfo info = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(Ids[i]));
            try {
                this.verifyBeforeUnAudit(ctx, info);
                LetterOfCreditFactory.getLocalInstance(ctx).singleAnitAudit((IObjectPK)new ObjectUuidPK(Ids[i]));
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(this.getResouceString("CREDITUNAUDITERROR_78", info.getNumber(), e.getMessage()));
            }
        }
        summary = success == Ids.length ? summary + EASResource.getString((String)RESOURCE, (String)"UNAUDIT_SUCCESS") : summary + EASResource.getString((String)RESOURCE, (String)"UNAUDIT_RESULT", (Object[])new String[]{String.valueOf(success), String.valueOf(Ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    private void verifyBeforeUnAudit(Context ctx, LetterOfCreditInfo info) throws EASBizException, BOSException {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_LetterOfCredit_unaudit");
        if (!isPermission) {
            String companyId = info.getCompany().getId().toString();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NOCREDITUNAUDITPERMISSION_069, (Object[])new String[]{company.getName()});
        }
        boolean idInProcess = FMHelper.hasWFInstance((Context)ctx, (String)info.getId().toString());
        if (idInProcess) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.INWORKFLOWCANTUNAUDIT_070);
        }
        if (info.getOperateStatus() != LetterOperateTypeEnum.AUDIT) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NOAUDITCANTUNAUDIT_071);
        }
        if (info.isIsCommitToBe() && info.getBankReturnStatus() != BankReturnStatusEnum.BANK_FAIL && info.getBankReturnStatus() != BankReturnStatusEnum.COMMIT_FAIL) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.CMTTOBECANTUNAUDIT_072);
        }
        if (info.getLetterStatus() == LetterStatusEnum.close) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.CLOSEDCREDITCANTUNAUDIT_073);
        }
    }

    @Override
    protected Map _modifyLetter(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("company.id"));
            sic.add(new SelectorItemInfo("company.name"));
            sic.add(new SelectorItemInfo("isCommitToBe"));
            sic.add(new SelectorItemInfo("bankReturnStatus"));
            sic.add(new SelectorItemInfo("LetterStatus"));
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("letterNumber"));
            LetterOfCreditInfo info = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(id), sic);
            boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), (String)"fin_ModifyLetter_addnew");
            if (!isPermission) {
                throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NOMODIFYLETTERPERMISSION_074, (Object[])new String[]{info.getCompany().getName()});
            }
            if (!info.isIsCommitToBe() || !BankReturnStatusEnum.BANK_SUCCESS.equals((Object)info.getBankReturnStatus())) {
                throw new LetterOfCreditApplyException(LetterOfCreditApplyException.OPENSUCCESSCANMODIFY_075);
            }
            if (LetterStatusEnum.close.equals((Object)info.getLetterStatus())) {
                throw new LetterOfCreditApplyException(LetterOfCreditApplyException.CREDITCLOSEDCANTMODIFY_076);
            }
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("letterId", (Object)info.getId().toString(), CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("bankReturnStatus", (Object)3, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("bankReturnStatus", null, CompareType.EQUALS));
            filter.setMaskString("#0 and (#1 or #2)");
            ev.setFilter(filter);
            ModifyLetterCollection collection = ModifyLetterFactory.getLocalInstance(ctx).getModifyLetterCollection(ev);
            if (collection.size() > 0) {
                throw new LetterOfCreditApplyException(LetterOfCreditApplyException.UNCONFIRMEDMODIFYITEMEXIST_077);
            }
            String summaryMsg = EASResource.getString((String)RESOURCE, (String)"MODIFY_VERIFY_SUCCESS_79");
            result.setError(0);
            result.setSummaryMsg(summaryMsg);
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }

    @Override
    protected Map _batchSubmit(Context ctx, String[] Ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{Ids.length + ""});
        int success = 0;
        for (int i = 0; i < Ids.length; ++i) {
            LetterOfCreditInfo info = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(Ids[i]));
            try {
                this.verifyBeforeSubmit(ctx, info);
                info.setOperateStatus(LetterOperateTypeEnum.submit);
                LetterOfCreditFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(this.getResouceString("SUBMIT_ERROR_MSG_80", info.getNumber(), e.getMessage()));
            }
        }
        summary = success == Ids.length ? summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_SUBMIT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"SUBMIT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(Ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    private void verifyBeforeSubmit(Context ctx, LetterOfCreditInfo info) throws Exception {
        String companyId = info.getCompany().getId().toString();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), (String)"fin_LetterOfCredit_submit");
        if (!isPermission) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NOCREDITSUBMITPERMISSION_078, (Object[])new String[]{company.getName()});
        }
        if (info.getLetterStatus() == LetterStatusEnum.close) {
            throw new LetterException(LetterException.CLOSEDCREDITCANTSUBMIT_021);
        }
        if (info.getOperateStatus() != LetterOperateTypeEnum.temporarily) {
            throw new LetterException(LetterException.NOTEMPCANTSUBMIT_022);
        }
        if (info.getFluctuateScale() != 0 && info.getFluctuateScalefloor() != 0 && info.getFluctuateScalefloor() > info.getFluctuateScale()) {
            throw new LetterException(LetterException.FLUCTUATESCALECANTLTLIMIT_023);
        }
        if (info.getAmount() == null || info.getAmount().equals(Constants.ZERO)) {
            throw new LetterException(LetterException.AMOUNTNOTNULL_024);
        }
        if (info.getCurrency() == null) {
            throw new LetterException(LetterException.CURRENCYNOTNULL_025);
        }
        if (info.getInstitution() == null) {
            throw new LetterException(LetterException.INSTITUTIONNOTNULL_026);
        }
        if (info.getSwiftCode() == null) {
            throw new LetterException(LetterException.SWIFTCODENOTNULL_027);
        }
        if (info.getContractNumber() == null) {
            throw new LetterException(LetterException.CONTRACTNUMNOUTNULL_028);
        }
        if (info.getContractAmount() == null || info.getContractAmount().equals(Constants.ZERO)) {
            throw new LetterException(LetterException.CONTRACTAMOUNTNOTMULL_029);
        }
        if (info.getLatestShipDate() == null) {
            throw new LetterException(LetterException.LASTESTSHIPDATENOTNULL_031);
        }
        if (info.getExpiredDate() == null) {
            throw new LetterException(LetterException.EXPIREDDATENOTNULL_032);
        }
        if (info.getExpiredPlace() == null) {
            throw new LetterException(LetterException.EXPIREDPLACENOTNULL_033);
        }
        if (info.getTenors() == null) {
            throw new LetterException(LetterException.TENORSNOTNULL_034);
        }
        if (info.getApplicantName() == null) {
            throw new LetterException(LetterException.APPLICANTNOTNULL_035);
        }
        if (info.getBeneficiary() == null) {
            throw new LetterException(LetterException.BENEFICIARYNOTNULL_036);
        }
        if (info.getIssueDate() == null) {
            throw new LetterException(LetterException.ISSUEDATENOTNULL_030);
        }
        this.verifyChinese(info);
    }

    @Override
    protected Map _batchDelete(Context ctx, String[] Ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{Ids.length + ""});
        int success = 0;
        for (int i = 0; i < Ids.length; ++i) {
            LetterOfCreditInfo info = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(Ids[i]));
            try {
                this.verifyBeforeDelete(ctx, info);
                LetterOfCreditFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(Ids[i]));
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(this.getResouceString("CREDIT_DELETE_ERRORMSG_81", info.getNumber(), e.getMessage()));
            }
        }
        summary = success == Ids.length ? summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_DELETE_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"DELETE_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(Ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    private void verifyBeforeDelete(Context ctx, LetterOfCreditInfo info) throws EASBizException, BOSException {
        String companyId = info.getCompany().getId().toString();
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), (String)"fin_LetterOfCredit_delete");
        if (!isPermission) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
            throw new LetterException(LetterException.NOCREDITDELETEPERMISSION_040);
        }
        boolean idInProcess = FMHelper.hasWFInstance((Context)ctx, (String)info.getId().toString());
        if (idInProcess) {
            throw new LetterException(LetterException.INWORKFLOWCANTDELETE_041);
        }
        if (info.getOperateStatus() == LetterOperateTypeEnum.AUDIT) {
            throw new LetterException(LetterException.AUDITEDCREDITCANTDELETE_042);
        }
        if (info.getLetterStatus() == LetterStatusEnum.close) {
            throw new LetterException(LetterException.CLOSEDCREDITCANTDELETE_043);
        }
        int seq = LetOfCreditAcctRecordFactory.getLocalInstance(ctx).getMaxSeqByID((IObjectPK)new ObjectUuidPK(info.getId().toString()));
        if (seq > 0) {
            throw new LetterException(LetterException.ACCEPTEDCREDITCANTDELETE_044);
        }
        if (info.isIsGenRepayment() && info.isIsDirect()) {
            throw new LetterException(LetterException.PAYEDANDDIRECTCREDITCANTDELETE_045);
        }
        LetterOfCreditFactory.getLocalInstance(ctx).delLetterCheck(info.getId().toString());
    }

    @Override
    protected Map _batchClose(Context ctx, String[] Ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{Ids.length + ""});
        int success = 0;
        for (int i = 0; i < Ids.length; ++i) {
            LetterOfCreditInfo info = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(Ids[i]));
            try {
                this.verifyBeforeClose(ctx, info);
                LetterOfCreditFactory.getLocalInstance(ctx).letterClose(info.getId().toString());
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(this.getResouceString("CREDIT_CLOSE_ERRORMSG_082", info.getNumber(), e.getMessage()));
            }
        }
        summary = success == Ids.length ? summary + EASResource.getString((String)RESOURCE, (String)"closeSuccess") : summary + EASResource.getString((String)RESOURCE, (String)"LETTER_CLOSE_RESULT", (Object[])new String[]{String.valueOf(success), String.valueOf(Ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    private void verifyBeforeClose(Context ctx, LetterOfCreditInfo info) throws Exception {
        String companyId = info.getCompany().getId().toString();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), (String)"fin_LetterOfCredit_unaudit");
        if (!isPermission) {
            throw new LetterException(LetterException.NOCLOSECREDITPERMISSION_046, new String[]{company.getName()});
        }
        boolean idInProcess = FMHelper.hasWFInstance((Context)ctx, (String)info.getId().toString());
        if (idInProcess) {
            throw new LetterException(LetterException.CREDITINWORKFLOWCANTCLOSE_047);
        }
        if (info.getOperateStatus() == LetterOperateTypeEnum.temporarily) {
            throw new LetterException(LetterException.TSCREDITCANTCLOSE_048);
        }
        if (info.getLetterStatus().getValue() == "1") {
            throw new FinBizException(FinBizException.CLOSED);
        }
        this.checkRecord(ctx, info);
    }

    private void checkRecord(Context ctx, LetterOfCreditInfo info) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("bill", (Object)info.getId().toString()));
        evi.setFilter(fi);
        LetOfCreditAcctRecordCollection colls = LetOfCreditAcctRecordFactory.getLocalInstance(ctx).getLetOfCreditAcctRecordCollection(evi);
        for (int i = 0; i < colls.size(); ++i) {
            LetOfCreditAcctRecordInfo recordInfo = colls.get(i);
            if (!recordInfo.getState().equals((Object)FMBooleanEnum.No)) continue;
            throw new FinBizException(FinBizException.CANNOTCLOSE);
        }
    }

    @Override
    protected Map _batchOpen(Context ctx, String[] Ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{Ids.length + ""});
        int success = 0;
        for (int i = 0; i < Ids.length; ++i) {
            LetterOfCreditInfo info = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(Ids[i]));
            try {
                this.verifyBeforeOpen(ctx, info);
                LetterOfCreditFactory.getLocalInstance(ctx).letterOpen(info.getId().toString());
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(this.getResouceString("CREDIT_OPEN_ERRORMSG_83", info.getNumber(), e.getMessage()));
            }
        }
        summary = success == Ids.length ? summary + EASResource.getString((String)RESOURCE, (String)"openSuccess") : summary + EASResource.getString((String)RESOURCE, (String)"LETTER_OPEN_RESULT", (Object[])new String[]{String.valueOf(success), String.valueOf(Ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    private void verifyBeforeOpen(Context ctx, LetterOfCreditInfo info) throws EASBizException, BOSException {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_LetterOfCredit_open");
        if (!isPermission) {
            String companyId = info.getCompany().getId().toString();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
            throw new LetterException(LetterException.NOOPENCREDITPERMISSION_049, new String[]{company.getName()});
        }
        boolean idInProcess = FMHelper.hasWFInstance((Context)ctx, (String)info.getId().toString());
        if (idInProcess) {
            throw new LetterException(LetterException.CREDITINWORKFLOWCANTOPEN_050);
        }
        if (info.getOperateStatus() == LetterOperateTypeEnum.temporarily) {
            throw new LetterException(LetterException.TSCREDITCANTOPEN_051);
        }
        if (info.getLetterStatus().getValue() == "0") {
            throw new FinBizException(FinBizException.OPENPED);
        }
    }

    @Override
    protected Map _batchReturnCL(Context ctx, String[] Ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{Ids.length + ""});
        int success = 0;
        for (int i = 0; i < Ids.length; ++i) {
            LetterOfCreditInfo info = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(Ids[i]));
            try {
                if (info.getOperateStatus() != LetterOperateTypeEnum.AUDIT) {
                    throw new LetterException(LetterException.NOTAUDITCANTRETURNCREDITLETTER_052);
                }
                this.checkCanReturnCL(info, true);
                this.checkReturnCLOrder(info, ctx);
                DeferReturnCLEntryFactory.getLocalInstance(ctx).returnCL(info.getDeferReturnCLEntrys().get(0).getId().toString());
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(this.getResouceString("RETURNCREDITLETTER_ERRORMSG_084", info.getNumber(), e.getMessage()));
            }
        }
        summary = success == Ids.length ? summary + EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"232_LetterOfCreditListUI") : summary + EASResource.getString((String)"RETURN_RESULT_85", (Object[])new String[]{String.valueOf(success), String.valueOf(Ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    private void checkReturnCLOrder(LetterOfCreditInfo info, Context ctx) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isReturnedCL", (Object)Boolean.FALSE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)info.getId().toString(), CompareType.EQUALS));
        filter.setMaskString("( #0 and #1 )");
        evi.setFilter(filter);
        SorterItemInfo sort = new SorterItemInfo("seq");
        sort.setSortType(SortType.ASCEND);
        evi.getSorter().add(sort);
        DeferReturnCLEntryInfo dfentryInfo = DeferReturnCLEntryFactory.getLocalInstance(ctx).getDeferReturnCLEntryCollection(evi).get(0);
        if (null == dfentryInfo) {
            throw new Exception(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"234_LetterOfCreditListUI"));
        }
    }

    private void checkCanReturnCL(LetterOfCreditInfo info, boolean isReturn) throws Exception {
        if (info.getLetterStatus() == null && info.getLetterStatus() != LetterStatusEnum.open) {
            throw new Exception(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"239_LetterOfCreditListUI"));
        }
        if (String.valueOf(info.getDeferReturnCreditLimitDays()) == null && info.getDeferReturnCreditLimitDays() > 0) {
            throw new Exception(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"240_LetterOfCreditListUI"));
        }
        boolean isrepaymentId = false;
        boolean isReturned = false;
        if (info.getDeferReturnCLEntrys() == null) {
            throw new Exception(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"241_LetterOfCreditListUI"));
        }
        DeferReturnCLEntryCollection clEntryCollection = info.getDeferReturnCLEntrys();
        for (int i = 0; i < clEntryCollection.size(); ++i) {
            DeferReturnCLEntryInfo clEntryInfo = clEntryCollection.get(i);
            if (clEntryInfo.getRepayment() != null) {
                isrepaymentId = true;
            }
            isReturned = clEntryInfo.isIsReturnedCL();
        }
        boolean isReturnedOK = false;
        isReturnedOK = isReturn;
        if (!isrepaymentId) {
            throw new LetterException(LetterException.CREDITLETTERRETURN_053);
        }
        if (isReturned == !isReturnedOK) {
            throw new LetterException(LetterException.CREDITLETTERRETURN_054);
        }
    }

    @Override
    protected Map _batchCancleReturnCL(Context ctx, String[] Ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{Ids.length + ""});
        int success = 0;
        for (int i = 0; i < Ids.length; ++i) {
            LetterOfCreditInfo info = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(Ids[i]));
            try {
                if (info.getOperateStatus() != LetterOperateTypeEnum.AUDIT) {
                    throw new LetterException(LetterException.NOAUDITCANTRETURNCREDITLETTER_055);
                }
                this.checkCanReturnCL(info, false);
                this.checkCancelReturnCLOrder(info, ctx);
                DeferReturnCLEntryFactory.getLocalInstance(ctx).cancleReturnCL(info.getDeferReturnCLEntrys().get(0).getId().toString());
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(this.getResouceString("CANCELRETURN_ERRORMSG_86", info.getNumber(), e.getMessage()));
            }
        }
        summary = success == Ids.length ? summary + EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"236_LetterOfCreditListUI") : summary + this.getResouceString("CANCELRETURN_RESULT_87", String.valueOf(success), String.valueOf(Ids.length - success));
        result.setSummaryMsg(summary);
        return result;
    }

    private void checkCancelReturnCLOrder(LetterOfCreditInfo info, Context ctx) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isReturnedCL", (Object)Boolean.TRUE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)info.getId().toString(), CompareType.EQUALS));
        filter.setMaskString("( #0 and #1 )");
        evi.setFilter(filter);
        SorterItemInfo sort = new SorterItemInfo("seq");
        sort.setSortType(SortType.DESCEND);
        evi.getSorter().add(sort);
        DeferReturnCLEntryInfo dfentryInfo = DeferReturnCLEntryFactory.getLocalInstance(ctx).getDeferReturnCLEntryCollection(evi).get(0);
        if (null == dfentryInfo) {
            throw new Exception(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"234_LetterOfCreditListUI"));
        }
    }

    @Override
    protected LetterOfCreditInfo _createNewModel(Context ctx, String companyId, String operate, String billId) throws BOSException, EASBizException {
        LetterOfCreditInfo lettercreditInfo = new LetterOfCreditInfo();
        if (operate == null) {
            UserInfo userinfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            lettercreditInfo.setCreator(userinfo);
            CompanyOrgUnitInfo defaultOrgUnit = this.getCompany(ctx, companyId);
            lettercreditInfo.setCompany(defaultOrgUnit);
            lettercreditInfo.setBizDate(new Date());
            lettercreditInfo.setCurrency(defaultOrgUnit.getBaseCurrency());
            lettercreditInfo.setIssueDate(DateUtil.getDayBegin());
            lettercreditInfo.setExpiredDate(DateUtil.getDayBegin());
            lettercreditInfo.setHorizon(SysConstant.BIGZERO);
            lettercreditInfo.setLocalCurExRate(Constants.ONE);
            lettercreditInfo.setCreditCurExRate(Constants.ZERO);
            lettercreditInfo.setUseAssureBill(false);
            lettercreditInfo.setIsInCredit(false);
            lettercreditInfo.setIsCommitToBe(false);
            lettercreditInfo.setAmount(Constants.ZERO);
            lettercreditInfo.setAmountLocalCur(Constants.ZERO);
            lettercreditInfo.setBalance(Constants.ZERO);
            lettercreditInfo.setCreditCurExRate(Constants.ZERO);
            lettercreditInfo.setUsedCreditAmt(FMHelper.multiply((BigDecimal)lettercreditInfo.getAmount(), (BigDecimal)lettercreditInfo.getCreditPercentage()));
            lettercreditInfo.setCreditLocalAmt(Constants.ZERO);
            lettercreditInfo.setLatestShipDate(new Date());
            lettercreditInfo.setFluctuateScale(0);
            lettercreditInfo.setFluctuateScalefloor(0);
            lettercreditInfo.setDeferReturnCreditLimitDays(0);
            lettercreditInfo.setIsInCredit(false);
            lettercreditInfo.setIsRelBankInCredit(false);
            NTTypeCollection ntTypeColls = LetterOfCreditWebFacadeControllerBean.getNTTypesBySuperGroup(ctx, NTTypeGroupEnum.ImportCredit);
            lettercreditInfo.setNtType(ntTypeColls.get(0));
            lettercreditInfo.setIsDirect(true);
            lettercreditInfo.setForwardDate(0);
            lettercreditInfo.setIsForward(true);
            lettercreditInfo.setAt(AtEnum.SIGH);
            lettercreditInfo.setLetterStatus(LetterStatusEnum.open);
            NTTypeInfo info = NTTypeFactory.getLocalInstance((Context)ctx).getNTTypeInfo((IObjectPK)new ObjectUuidPK("55555555-5555-5555-5555-5555555555551C9A9013"));
            lettercreditInfo.setNtType(info);
            lettercreditInfo.setGuaranteeTypeInputMode(GuaranteeTypeInputModeEnum.assure);
        } else if (operate.equals("copy")) {
            ILetterOfCredit iLetterOfCredit = LetterOfCreditFactory.getLocalInstance(ctx);
            LetterOfCreditInfo oldInfo = iLetterOfCredit.getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
            lettercreditInfo = oldInfo.copy();
            NTTypeInfo info = NTTypeFactory.getLocalInstance((Context)ctx).getNTTypeInfo((IObjectPK)new ObjectUuidPK("55555555-5555-5555-5555-5555555555551C9A9013"));
            lettercreditInfo.setNtType(info);
            lettercreditInfo.setLetterStatus(LetterStatusEnum.open);
            lettercreditInfo.setBizDate(new Date());
        }
        return lettercreditInfo;
    }

    private CompanyOrgUnitInfo getCompany(Context ctx, String companyId) throws BOSException, EASBizException {
        ICasUtilFacade casUtil = CasUtilFacadeFactory.getLocalInstance((Context)ctx);
        String permItem = "fin_LetterOfCredit_addnew";
        CompanyOrgUnitInfo company = null;
        company = companyId == null || companyId.equals("false") ? ContextUtil.getCurrentFIUnit((Context)ctx) : CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), this.getcompanySelector());
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(company.getId().toString()), (String)permItem);
        if (company.isIsBizUnit()) {
            if (!isPermission) {
                throw new CasWebException(CasWebException.NO_ADDNEW_AUTHRIZED);
            }
        } else {
            throw new CasWebException(CasWebException.NO_BANKSTATEMENT_NOT_BIZUNIT);
        }
        company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()), this.getcompanySelector());
        return company;
    }

    @Override
    protected Map _submit(Context ctx, LetterOfCreditInfo info) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        try {
            String companyId = info.getCompany().getId().toString();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
            boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), (String)"fin_LetterOfCredit_submit");
            if (!isPermission) {
                throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NOCREDITSUBMITPERMISSION_078, (Object[])new String[]{company.getName()});
            }
            this.verifyChinese(info);
            if (info.getAt() == AtEnum.SIGH) {
                info.setIsForward(false);
            } else {
                info.setIsForward(true);
            }
            info.setIsDirect(true);
            if (info.getId() == null) {
                info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            }
            ILetterOfCredit iLetterOfCredit = LetterOfCreditFactory.getLocalInstance(ctx);
            info.setOperateStatus(LetterOperateTypeEnum.submit);
            info.setBalance(info.getAmount());
            if (!info.isIsInCredit()) {
                LetterOfCreditFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
            } else {
                info.setIsInCredit(false);
                BigDecimal creditLocalAmt = info.getCreditLocalAmt();
                BigDecimal usedCreditAmt = info.getUsedCreditAmt();
                LetterOfCreditFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
                if (creditLocalAmt != null && usedCreditAmt != null) {
                    StringBuffer sql = new StringBuffer();
                    sql.append("update T_FIN_LetterOfCredit set FIsInCredit = 1 ");
                    sql.append(", FCreditLocalAmt = ? ");
                    sql.append(", FUsedCreditAmt = ? ");
                    sql.append("where fid = '");
                    sql.append(info.getId().toString());
                    sql.append("'");
                    DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{creditLocalAmt, usedCreditAmt});
                }
            }
            result.setError(0);
            result.setSummaryMsg(EASResource.getString((String)RESOURCE, (String)"CreditSubmitSuccess_93"));
        }
        catch (Exception e) {
            logger.error((Object)e);
            e.printStackTrace();
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }

    private void verifyChinese(LetterOfCreditInfo info) throws Exception {
        if (info.getExpiredDate().before(info.getIssueDate())) {
            throw new LetterException(LetterException.EXPIREDDATEMUSTLTISSUEDATE_038);
        }
        if (info.getLatestShipDate() != null && info.getLatestShipDate().before(info.getIssueDate())) {
            throw new LetterException(LetterException.SHIPDATEMUSTLTISSUEDATE_039);
        }
        String[] propertyKey = new String[]{"IncotermsText", "goods", "tenors", "applicantName", "Beneficiary", "NotifyBankName2", "expiredPlace", "drawee", "DeferredDetails", "MixedDetails", "LoadPort", "DestinationPort", "Draftsat", "documents", "finalPlace", "additionalConditions", "Charges"};
        LetterOfCreditInfo objectValue = info;
        String regex = "[\u4e00-\u9fa5]+";
        for (int i = 0; i < propertyKey.length; ++i) {
            String text;
            if (objectValue.get(propertyKey[i]) == null || !(text = objectValue.get(propertyKey[i]).toString()).matches(regex)) continue;
            throw new LetterException(LetterException.VERIFYCHINESE_037);
        }
    }

    @Override
    protected Map _save(Context ctx, LetterOfCreditInfo info) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        try {
            if (info.getAt() == AtEnum.SIGH) {
                info.setIsForward(false);
            } else {
                info.setIsForward(true);
            }
            info.setIsDirect(true);
            info.setBalance(info.getAmount());
            info.setOperateStatus(LetterOperateTypeEnum.temporarily);
            if (info.getNumber() == null) {
                String companyId = info.getCompany().getId().toString();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
                throw new LetterException(LetterException.NOCODERULE_056, new String[]{company.getName()});
            }
            if (info.getId() == null) {
                info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            }
            if (!info.isIsInCredit()) {
                LetterOfCreditFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
            } else {
                info.setIsInCredit(false);
                BigDecimal creditLocalAmt = info.getCreditLocalAmt();
                BigDecimal usedCreditAmt = info.getUsedCreditAmt();
                LetterOfCreditFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
                if (creditLocalAmt != null && usedCreditAmt != null) {
                    StringBuffer sql = new StringBuffer();
                    sql.append("update T_FIN_LetterOfCredit set FIsInCredit = 1 ");
                    sql.append(", FCreditLocalAmt = ? ");
                    sql.append(", FUsedCreditAmt = ? ");
                    sql.append("where fid = '");
                    sql.append(info.getId().toString());
                    sql.append("'");
                    DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{creditLocalAmt, usedCreditAmt});
                }
            }
            result.setError(0);
            result.setSummaryMsg(EASResource.getString((String)RESOURCE, (String)"CreditSaveSuccess_94"));
        }
        catch (Exception e) {
            logger.error((Object)e);
            e.printStackTrace();
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }

    @Override
    protected Map _commitToBe(Context ctx, String[] Ids) throws BOSException, EASBizException {
        int size = Ids.length;
        int success = 0;
        BatchExecuteResult result = new BatchExecuteResult();
        Set idSet = CASWebUtil.ids2Set((String[])Ids);
        ILetterOfCredit iLetterOfCredit = LetterOfCreditFactory.getLocalInstance(ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.setSelector(this.getSelector());
        LetterOfCreditCollection collection = iLetterOfCredit.getLetterOfCreditCollection(ev);
        ArrayList idList = new ArrayList(idSet);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{Ids.length + ""});
        LetterOfCreditEBGServiceUtil letterOfCreditEBGServiceUtil = new LetterOfCreditEBGServiceUtil();
        for (int i = 0; i < collection.size(); ++i) {
            LetterOfCreditInfo info = collection.get(i);
            try {
                Boolean isLocked = (Boolean)requestMap.get(info.getId().toString());
                this.verifyBeforeCommitToBE(ctx, isLocked, info);
                OpenCreditVO openVo = this.praseCommitToBEVO(ctx, info);
                CreditOpenBody resposeBody = letterOfCreditEBGServiceUtil.openCredit(ctx, openVo);
                info.setIsCommitToBe(true);
                iLetterOfCredit.updatePartial((CoreBaseInfo)info, ConvertUtils.SIC((Object[])new Object[]{"isCommitToBe"}));
                info.setBatchSeqID(resposeBody.getBatchSeqId());
                CreditOpenDetail[] resposeList = resposeBody.getDetails();
                this.dealWithResponse(ctx, resposeList, info, info.getDetailSeqID());
                ++success;
                continue;
            }
            catch (Exception e) {
                e.getStackTrace();
                info.setBatchSeqID(null);
                info.setDetailSeqID(null);
                info.setIsCommitToBe(false);
                SelectorItemCollection LCsic = new SelectorItemCollection();
                LCsic.add(new SelectorItemInfo("batchSeqID"));
                LCsic.add(new SelectorItemInfo("detailSeqID"));
                LCsic.add(new SelectorItemInfo("isCommitToBe"));
                LetterOfCreditFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, LCsic);
                result.getDetailMsgList().add(this.getResouceString("CREDIT_COMMITTOBE_ERRORMSG_88", info.getNumber(), e.getMessage()));
            }
        }
        summary = success == Ids.length ? summary + EASResource.getString((String)RESOURCE, (String)"ALL_COMMIT_TO_BE_SUCCESS") : summary + EASResource.getString((String)RESOURCE, (String)"COMMIT_TO_BE_RESULT", (Object[])new String[]{String.valueOf(success), String.valueOf(Ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    private void verifyBeforeCommitToBE(Context ctx, boolean isLocked, LetterOfCreditInfo info) throws Exception {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_LetterOfCredit_commitToBe");
        if (!isPermission) {
            String companyId = info.getCompany().getId().toString();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
            throw new LetterException(LetterException.NOCOMMITTOBEPERMISSION_057, new String[]{company.getName()});
        }
        if (!isLocked) {
            throw new LetterException(LetterException.ISLOCKEDCANTCOMMITTOBE_059);
        }
        if (!info.isIsDirect()) {
            throw new LetterException(LetterException.ONLYDIRECTCANCMTTOBE);
        }
        if (info.getOperateStatus() != LetterOperateTypeEnum.AUDIT) {
            throw new LetterException(LetterException.AUDITBEFORECOMMITTOBE_060);
        }
        if (info.isIsCommitToBe() && (!info.isIsCommitToBe() || info.getBankReturnStatus() == null || BankReturnStatusEnum.COMMIT_FAIL.equals((Object)info.getBankReturnStatus()))) {
            throw new LetterException(LetterException.NORETURNFAILCANTCMTTOBE_061);
        }
    }

    @Override
    protected Map _synStatus(Context ctx, String[] ids) throws BOSException, EASBizException {
        int size = ids.length;
        int success = 0;
        BatchExecuteResult result = new BatchExecuteResult();
        Set idSet = CASWebUtil.ids2Set((String[])ids);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.setSelector(this.getSelector());
        LetterOfCreditCollection collection = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditCollection(ev);
        ArrayList idList = new ArrayList(idSet);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
        LetterOfCreditEBGServiceUtil letterOfCreditEBGServiceUtil = new LetterOfCreditEBGServiceUtil();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        for (int i = 0; i < collection.size(); ++i) {
            LetterOfCreditInfo info = collection.get(i);
            try {
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_LetterOfCredit_synStatus");
                if (!isPermission) {
                    String companyId = info.getCompany().getId().toString();
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("name"));
                    CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
                    throw new LetterException(LetterException.NOCREDITSYNSTATUSPERMISSION_065, new String[]{company.getName()});
                }
                Boolean isLocked = (Boolean)requestMap.get(info.getId().toString());
                this.verifyBeforesynStatus(ctx, isLocked, info);
                OpenCreditQueryVO openQueryVo = this.praseSynStatusVO(ctx, info);
                CreditOpenBody resposeBody = letterOfCreditEBGServiceUtil.openCreditQuery(ctx, openQueryVo);
                CreditOpenDetail[] resposeList = resposeBody.getDetails();
                this.dealWithResponse(ctx, resposeList, info, info.getDetailSeqID());
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(this.getResouceString("CREDIT_SYNSTATUS_ERRORMSG_89", info.getNumber(), e.getMessage()));
            }
        }
        summary = success == ids.length ? summary + EASResource.getString((String)RESOURCE, (String)"ALL_SYN_STATUS_SUCCESS") : summary + EASResource.getString((String)RESOURCE, (String)"MODIFYLETTER_SYN_STATUS_RESULT", (Object[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    private void verifyBeforesynStatus(Context ctx, boolean isLocked, LetterOfCreditInfo info) throws Exception {
        if (!isLocked) {
            throw new LetterException(LetterException.ISLOCKEDCANTSYNSTATUS_062);
        }
        if (!info.isIsCommitToBe()) {
            throw new LetterException(LetterException.CMTTOBEBEFORESYNSTATUS_063);
        }
        if (info.getBankReturnStatus() == BankReturnStatusEnum.BANK_FAIL || info.getBankReturnStatus() == BankReturnStatusEnum.BANK_SUCCESS || info.getBankReturnStatus() == BankReturnStatusEnum.BANK_EXCEPTION) {
            throw new LetterException(LetterException.SUCCESSORFAILCANTSYNSTATUS_064);
        }
    }

    private void dealWithResponse(Context ctx, CreditOpenDetail[] resposeList, LetterOfCreditInfo info, String detailSeqId) throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        if (resposeList != null && resposeList.length > 0) {
            for (int i = 0; i < resposeList.length; ++i) {
                CreditOpenDetail detail = resposeList[i];
                ILetterOfCredit iLetterOfCredit = LetterOfCreditFactory.getLocalInstance(ctx);
                if (detailSeqId != null && detailSeqId.equals(detail.getDetailSeqId())) {
                    sic.add(new SelectorItemInfo("bankReturnStatus"));
                    info.setBankReturnStatus(BankReturnStatusEnum.getEnum((String)detail.getEbStatus()));
                    sic.add(new SelectorItemInfo("bankReturnMsg"));
                    info.setBankReturnMsg(detail.getBankStatusMsg());
                    sic.add(new SelectorItemInfo("detailSeqID"));
                    info.setDetailSeqID(detail.getDetailSeqId());
                    sic.add(new SelectorItemInfo("batchSeqID"));
                    if (detail.getCreditReferenceNo() != null) {
                        info.setLetterNumber(detail.getCreditReferenceNo());
                        sic.add(new SelectorItemInfo("letterNumber"));
                    }
                }
                if (!info.isIsInCredit()) {
                    iLetterOfCredit.updatePartial((CoreBaseInfo)info, sic);
                    continue;
                }
                iLetterOfCredit.delete(info.getId().toString());
                iLetterOfCredit.addnew((CoreBaseInfo)info);
            }
        } else {
            logger.error((Object)"there is nothing resposed from be");
            throw new Exception(EASResource.getString((String)RESOURCE, (String)"NothingResponseFromBE_100"));
        }
    }

    private OpenCreditVO praseCommitToBEVO(Context ctx, LetterOfCreditInfo info) throws EASBizException, BOSException, IOException {
        OpenCreditVO openVo = new OpenCreditVO();
        if (info.getPayBankAcct() != null) {
            openVo.setAccNo(info.getPayBankAcct().getBankAccountNumber());
        }
        openVo.setCurrency(FmBeHelper.getCurrencyISO((Context)ctx, (CurrencyInfo)info.getCurrency()));
        String[] serialNos = beServiceHelper.getSerialNumber((int)1);
        openVo.setBatchSeqId(serialNos[0]);
        openVo.setBatchBizNo(serialNos[0]);
        openVo.setTotalCount("1");
        info.setBatchSeqID(serialNos[0]);
        info.setDetailSeqID(serialNos[0]);
        info.setIsCommitToBe(true);
        SelectorItemCollection LCsic = new SelectorItemCollection();
        LCsic.add(new SelectorItemInfo("batchSeqID"));
        LCsic.add(new SelectorItemInfo("detailSeqID"));
        LCsic.add(new SelectorItemInfo("isCommitToBe"));
        LetterOfCreditFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, LCsic);
        ArrayList<OpenCreditDetailVO> openjectList = new ArrayList<OpenCreditDetailVO>();
        OpenCreditDetailVO openDetailVO = new OpenCreditDetailVO();
        openDetailVO.setDetailSeqId(serialNos[0]);
        openDetailVO.setDetailBizNo(info.getContractNumber());
        openDetailVO.setCreditType(info.getTransferable().getName());
        if (info.getCurrency() != null) {
            openDetailVO.setNominalCurrency(FmBeHelper.getCurrencyISO((Context)ctx, (CurrencyInfo)info.getCurrency()));
        }
        openDetailVO.setNominalAmount(info.getAmount().setScale(2, 4).toString());
        openDetailVO.setInitialCode(info.getInitialCode());
        openDetailVO.setIssuedDate(info.getIssueDate());
        openDetailVO.setLatestShipmentDate(info.getLatestShipDate());
        openDetailVO.setExpiringDate(info.getExpiredDate());
        openDetailVO.setExpiryPlace(info.getExpiredPlace());
        if (info.getTenors() != null) {
            openDetailVO.setTenors(new String(info.getTenors(), "UTF-8").replace("_", "-"));
        }
        openDetailVO.setApplicableRules(info.getApplicableRules().getName());
        openDetailVO.setContractNo(info.getContractNumber());
        if (info.getContractAmount() != null) {
            openDetailVO.setContractAmount(info.getContractAmount().setScale(2, 4).toString());
        }
        openDetailVO.setApplicant(info.getApplicantName());
        if (info.getSwiftCode() != null) {
            String number = info.getSwiftCode().getNumber().concat(",");
            String bebank = info.getSwiftCode().getBeBank();
            String advisingBank = number.concat(bebank).replace("_", "  ");
            openDetailVO.setAdvisingBank(advisingBank);
        }
        openDetailVO.setBeneficiary(info.getBeneficiary());
        openDetailVO.setConfirmInstruction(info.getConfirmation().getName());
        openDetailVO.setApplicantBank(info.getApplicantName());
        openDetailVO.setOtherAdvisingBank(info.getNotifyBankName2());
        openDetailVO.setAvailableWithBank(info.getCreditAvable().getName());
        openDetailVO.setAvailableBy(info.getAvailableBy().getName());
        openDetailVO.setDraftsAt(info.getDraftsat());
        if (info.getDrawee() != null) {
            openDetailVO.setDrawee(new String(info.getDrawee(), "UTF-8"));
        }
        openDetailVO.setDefPaymentDetails(info.getDeferredDetails());
        if (info.getMixedDetails() != null) {
            openDetailVO.setMixedPaymentDetails(new String(info.getMixedDetails(), "UTF-8"));
        }
        openDetailVO.setPresentationPeriod(info.getIncotermsText());
        openDetailVO.setDetailsOfCharges(info.getCharges());
        if (info.getBeneficiaryStat() != null) {
            openDetailVO.setCountryCode(info.getBeneficiaryStat().getISOCode());
        }
        openDetailVO.setPatialShipment(info.isIsBatch() ? "Y" : "N");
        openDetailVO.setTransshipment(info.isIsDivert() ? "Y" : "N");
        openDetailVO.setPlaceOfReceipt(info.getLoadPort());
        openDetailVO.setPortOfLoading(info.getLoadPort());
        openDetailVO.setPortOfDischarge(info.getDestinationPort());
        if (info.getFinalPlace() != null) {
            openDetailVO.setFinalDestination(new String(info.getFinalPlace(), "UTF-8"));
        }
        openDetailVO.setShipmentPeriod(info.getShipmentperiod());
        if (info.getGoods() != null) {
            openDetailVO.setGoods(new String(info.getGoods(), "UTF-8"));
        }
        if (info.getDocuments() != null) {
            openDetailVO.setDocuments(new String(info.getDocuments(), "UTF-8"));
        }
        if (info.getAdditionalConditions() != null) {
            openDetailVO.setAdditionalConditions(new String(info.getAdditionalConditions(), "UTF-8"));
        }
        openDetailVO.setComment(info.getRemark());
        openjectList.add(openDetailVO);
        openVo.setDetails(openjectList);
        return openVo;
    }

    private OpenCreditQueryVO praseSynStatusVO(Context ctx, LetterOfCreditInfo info) throws EASBizException, BOSException, ParseException {
        OpenCreditQueryVO creditQueryVO = new OpenCreditQueryVO();
        creditQueryVO.setBatchSeqId(info.getBatchSeqID());
        if (info.getPayBankAcct() != null) {
            creditQueryVO.setAccNo(info.getPayBankAcct().getBankAccountNumber());
        }
        creditQueryVO.setCurrency(FmBeHelper.getCurrencyISO((Context)ctx, (CurrencyInfo)info.getCurrency()));
        Date endDate = new Date();
        creditQueryVO.setEndDate(endDate);
        creditQueryVO.setStartDate(info.getIssueDate());
        return creditQueryVO;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("Currency.*"));
        sic.add(new SelectorItemInfo("Currency.isoCode"));
        sic.add(new SelectorItemInfo("NotifyBank.name"));
        sic.add(new SelectorItemInfo("NotifyBank.*"));
        sic.add(new SelectorItemInfo("Institution.*"));
        sic.add(new SelectorItemInfo("Institution.accountBank.*"));
        sic.add(new SelectorItemInfo("BeneficiaryStat.*"));
        sic.add(new SelectorItemInfo("payBankAcct.*"));
        sic.add(new SelectorItemInfo("swiftCode.*"));
        sic.add(new SelectorItemInfo("CreditLimit.*"));
        sic.add(new SelectorItemInfo("CreditCurrency.*"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.*"));
        return sic;
    }

    private SelectorItemCollection getcompanySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("CU.longNumber"));
        return sic;
    }

    @Override
    protected Map _addFee(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("company.id"));
            sic.add(new SelectorItemInfo("company.name"));
            sic.add(new SelectorItemInfo("LetterStatus"));
            sic.add(new SelectorItemInfo("letterNumber"));
            LetterOfCreditInfo info = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(id), sic);
            boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_FeeManager_addnew");
            if (!isPermission) {
                throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NO_ADDFEE_PERMISSION_41, (Object[])new String[]{info.getCompany().getName()});
            }
            if (LetterStatusEnum.close.equals((Object)info.getLetterStatus())) {
                throw new LetterException(LetterException.CANTADDFEECAUSECOLSED_079, new String[]{info.getLetterNumber()});
            }
            result.setError(0);
            String successMsg = EASResource.getString((String)RESOURCE, (String)"ADDFEESUCCESS_76");
            result.setSummaryMsg(successMsg);
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }

    private String getResouceString(String key, String infoNum, String errorMsg) {
        return EASResource.getString((String)RESOURCE, (String)key, (Object[])new String[]{infoNum, errorMsg});
    }

    private void verifyGuaranteeWage(Context ctx, CoreBaseCollection gdColl) throws EASBizException, BOSException {
        for (int i = 0; i < gdColl.size(); ++i) {
            SelectorItemCollection sic;
            GuaranteeDetailInfo gdInfo = (GuaranteeDetailInfo)gdColl.get(i);
            if (EmptyUtil.isEmpty((String)gdInfo.getBillId()) || gdInfo.getBilltype() == null) continue;
            String id = gdInfo.getBillId();
            if (gdInfo.getBilltype().equals((Object)GuanTypeBillEnum.AssureBill)) {
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("canceled"));
                AssureBillInfo assureInfo = AssureBillFactory.getLocalInstance((Context)ctx).getAssureBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
                if (!assureInfo.isCanceled()) continue;
                throw new FinBizException(FinBizException.ASSURECANCELED);
            }
            if (gdInfo.getBilltype().equals((Object)GuanTypeBillEnum.wage)) {
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("isAntiWage"));
                WageInfo wage = WageFactory.getLocalInstance(ctx).getWageInfo((IObjectPK)new ObjectUuidPK(id), sic);
                if (!wage.isIsAntiWage()) continue;
                throw new FinBizException(FinBizException.WAGECANCEL);
            }
            if (!gdInfo.getBilltype().equals((Object)GuanTypeBillEnum.ReceivableBill) || !BOSUuid.read((String)id).getType().equals((Object)new BankFactorInfo().getBOSType())) continue;
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("isCancel"));
            sic.add(new SelectorItemInfo("isRetrade"));
            sic.add(new SelectorItemInfo("isMortgage"));
            BankFactorInfo factorInfo = BankFactorFactory.getLocalInstance((Context)ctx).getBankFactorInfo((IObjectPK)new ObjectUuidPK(id), sic);
            if (!factorInfo.isIsCancel() && !factorInfo.isIsRetrade() && !factorInfo.isIsMortgage()) continue;
            throw new FinBizException(FinBizException.BANKFACTORCANCEL);
        }
    }

    @Override
    protected Map _modifyBankReturnStatus(Context ctx, String id, int status) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("bankReturnStatus"));
        LetterOfCreditInfo info = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(id), sic);
        try {
            if (!BankReturnStatusEnum.BANK_EXCEPTION.equals((Object)info.getBankReturnStatus())) {
                throw new LetterException(LetterException.CANTMODIFYBANKRETURNSTATUS_080);
            }
            info.setBankReturnStatus(BankReturnStatusEnum.getEnum((int)status));
            LetterOfCreditFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
            result.setError(0);
            result.setSummaryMsg(EASResource.getString((String)RESOURCE, (String)"StatusUpdateSuccess_103"));
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }

    private static NTTypeCollection getNTTypesBySuperGroup(Context ctx, NTTypeGroupEnum ntenum) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (null != ntenum) {
            filter.getFilterItems().add(new FilterItemInfo("superGroup", (Object)new Integer(ntenum.getValue()), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("isused", (Object)new Integer(1), CompareType.EQUALS));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("financeType.*"));
        view.getSelector().add(new SelectorItemInfo("financeType.FinancingSource.*"));
        return NTTypeFactory.getLocalInstance((Context)ctx).getNTTypeCollection(view);
    }
}

