/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.CasDataException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.LimitDataTypeEnum;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class LimitFetchCalculator {
    private SortedParameterArray params = null;
    private ICalculateContextProvider context;
    private Context serverCtx = null;
    private static String MAIN_QUERY = "SELECT SUM(ISNULL(LIM.FBALANCE,0)) AS BALANCE, SUM(ISNULL(LIM.FQUOTAAMOUNT,0))AS QUOTAAMOUNT, SUM(ISNULL(LIM.FUSEDAMOUNT,0))AS USEDAMOUNT FROM T_FIN_CREDITLIMIT AS LIM INNER JOIN T_BD_CURRENCY AS CURRENCY ON LIM.FCURRENCYID = CURRENCY.FID INNER JOIN T_ORG_COMPANY AS COMPANY ON LIM.FCOMPANYID = COMPANY.FID INNER JOIN T_FIN_CREDITUSAGE AS CREDITUSAGE ON CREDITUSAGE.FID =  LIM.FCREDITUSAGEID LEFT OUTER JOIN T_BD_BANK AS BANK ON BANK.FID = LIM.FCREDITINSTITUTIONID LEFT OUTER JOIN T_BD_PROJECT AS PROJECT ON LIM.FPROJECTID = PROJECT.FID LEFT OUTER JOIN T_FIN_GUARANTEETYPE AS GARANTEETYPE ON LIM.FGUARANTEETYPEID = GARANTEETYPE.FID WHERE 1=1 ";

    public void initialize(ICalculateContextProvider context, Context serverCtx, SortedParameterArray params) {
        this.setContext(context);
        this.setServerCtx(serverCtx);
        this.setParams(params);
    }

    public void execute(ICalculateContextProvider context, Context serverCtx, SortedParameterArray params) {
        this.initialize(context, serverCtx, params);
        for (int i = 0; i < params.size(); ++i) {
            Parameter param = params.getParameter(i);
            Object[] args = param.getArgs();
            try {
                BigDecimal valueReturn = this.getInAccBatch(serverCtx, args);
                param.setValue((Object)valueReturn);
                continue;
            }
            catch (Exception e) {
                param.setValue((Object)e.getMessage());
            }
        }
    }

    private BigDecimal getInAccBatch(Context ctx, Object[] args) throws BOSException, EASBizException {
        String resourcePath = "com.kingdee.eas.fm.fin.LoanExceptionMessageResource";
        LimitDataTypeEnum DataType = LimitDataTypeEnum.getEnum(args[9].toString());
        if (DataType == null) {
            throw new FSException(FSException.INACCTTYPEISNULL);
        }
        String Rsql = "";
        IRowSet rs = null;
        try {
            Rsql = this.getSQL(this.context, this.serverCtx, args);
            rs = this.getResultBySQL(this.serverCtx, Rsql);
        }
        catch (BOSException e) {
            throw new BOSException(EASCommonResource.getString((String)resourcePath, (String)"breakOutBOSException", (Locale)ctx.getLocale()));
        }
        BigDecimal result = SysConstant.BIGZERO;
        try {
            if (DataType.getValue().equals("Y")) {
                while (rs.next()) {
                    result = rs.getBigDecimal(1);
                }
            }
            if (DataType.getValue().equals("S")) {
                while (rs.next()) {
                    result = rs.getBigDecimal(2);
                }
            }
            if (DataType.getValue().equals("C")) {
                while (rs.next()) {
                    result = rs.getBigDecimal(3);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException(EASCommonResource.getString((String)resourcePath, (String)"breakOutSQLException", (Locale)ctx.getLocale()));
        }
        return result == null ? SysConstant.BIGZERO : result;
    }

    private String getSQL(ICalculateContextProvider context, Context ctx, Object[] args) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql = sql.append(MAIN_QUERY);
        if (args[0] != null && !args[0].equals("")) {
            sql.append(" and ").append(FMHelper.buildIn((String)" COMPANY.fid ", (Object[])this.getCompanyIds(ctx, args[0].toString()).toArray()));
        } else {
            String companyNum = this.getReportCompany(context, ctx);
            sql.append(" and ").append(FMHelper.buildIn((String)" COMPANY.fid ", (Object[])this.getCompanyIds(ctx, companyNum).toArray()));
        }
        if (args[1] != null && !args[1].equals("")) {
            if ("REVOLVING_AMOUNT".equals(args[1].toString())) {
                sql.append(" and LIM.FProperty = 1 ");
            } else if ("FIXED_AMOUNT".equals(args[1].toString())) {
                sql.append(" and LIM.FProperty = 2 ");
            }
        }
        if (args[2] != null && !args[2].equals("")) {
            if ("ALL".equals(args[2].toString())) {
                sql.append(" and ").append(" LIM.FIsBankCredit IS NOT NULL ");
            } else if ("FALSE".equals(args[2].toString())) {
                sql.append(" and ").append(" LIM.FIsBankCredit = 0 ");
            } else if ("TRUE".equals(args[2].toString())) {
                sql.append(" and ").append(" LIM.FIsBankCredit = 1 ");
            } else if ("INNER".equals(args[2].toString())) {
                sql.append(" and ").append(" LIM.FIsBankCredit = 2 ");
            }
        }
        if (args[3] != null && !args[3].equals("")) {
            if ("INNER".equals(args[2].toString())) {
                sql.append(" and ").append(FMHelper.buildIn((String)" LIM.FcreditCompanyID ", (Object[])this.getCompanyIds(ctx, args[3].toString()).toArray()));
            } else if ("TRUE".equals(args[2].toString())) {
                sql.append(" and ").append(FMHelper.buildIn((String)" BANK.fid ", (Object[])this.getBankAcctIds(ctx, args[3].toString()).toArray()));
            } else if ("FALSE".equals(args[2].toString())) {
                sql.append(" and ").append(FMHelper.buildIn((String)" BANK.fid ", (Object[])this.getBankAcctIds(ctx, args[3].toString()).toArray()));
            }
        }
        if (args[4] != null && !args[4].equals("")) {
            sql.append(" and CREDITUSAGE.fnumber = '" + args[4].toString() + "'");
        }
        if (args[5] != null && !args[5].equals("")) {
            sql.append(" and CURRENCY.fnumber='" + args[5].toString() + "'");
        } else {
            String currency = this.getReportCurrency(context, ctx);
            sql.append(" and CURRENCY.fnumber='" + currency + "'");
        }
        if (args[6] != null && !args[6].equals("")) {
            sql.append(" and LIM.fIssueDate >= {").append(args[6].toString()).append("} ");
        } else {
            Date beginDate = this.getReportStartDate(context, ctx);
            sql.append(" and LIM.fIssueDate >= {").append(beginDate).append("} ");
        }
        if (args[7] != null && !args[7].equals("")) {
            sql.append(" and LIM.fIssueDate <= {").append(args[7].toString()).append("} ");
        } else {
            Date endDate = this.getReportEndDate(context, ctx);
            sql.append(" and LIM.fIssueDate < {").append(endDate).append("} ");
        }
        if (args[8] != null && !args[8].equals("")) {
            sql.append(" and ( " + args[8].toString()).append(" )");
        }
        return sql.toString();
    }

    private Set getCompanyIds(Context ctx, String companyNum) throws BOSException {
        if (FMHelper.isEmpty((String)companyNum)) {
            return null;
        }
        StringBuffer sql = new StringBuffer(120);
        sql.append("select fid from t_org_company where (");
        if (companyNum.indexOf(";") > 0) {
            String[] nums = companyNum.split(";");
            for (int i = 0; i < nums.length; ++i) {
                if (i > 0) {
                    sql.append(" or ");
                }
                sql.append(" (FNumber = '").append(nums[i].trim()).append("'").append(" or FLongNumber like '").append(companyNum).append("!%' ").append(" or FLongNumber like '%!").append(companyNum).append("!%') ");
            }
        } else {
            sql.append(" FNumber = '").append(companyNum.trim()).append("'").append(" or FLongNumber like '").append(companyNum).append("!%' ").append(" or FLongNumber like '%!").append(companyNum).append("!%'");
        }
        sql.append(" ) and FIsOnlyUnion =0 ");
        sql.append(" order by FLongNumber asc");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            HashSet<String> idSet = new HashSet<String>();
            while (rs.next()) {
                idSet.add(rs.getString("fid"));
            }
            if (idSet.size() > 0) {
                return idSet;
            }
            return null;
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private Set getBankAcctIds(Context ctx, String bankAcctNum) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)bankAcctNum)) {
            return null;
        }
        StringBuffer sql = new StringBuffer(100);
        sql.append("select Fid from t_bd_bank where 1=1");
        if (!StringUtils.isEmpty((String)bankAcctNum)) {
            if (bankAcctNum.indexOf(";") > 0) {
                sql.append(" and FNumber in (");
                String[] nums = bankAcctNum.split(";");
                for (int i = 0; i < nums.length; ++i) {
                    if (i > 0) {
                        sql.append(",");
                    }
                    sql.append(" '").append(nums[i].trim()).append("'");
                }
                sql.append(")");
            } else {
                sql.append(" and FNumber = '").append(bankAcctNum.trim()).append("'");
            }
        }
        HashSet<String> bankAcctIdSet = new HashSet<String>();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                if (rs.getString("FID") == null) continue;
                bankAcctIdSet.add(rs.getString("FID"));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        if (bankAcctIdSet.size() > 0) {
            return bankAcctIdSet;
        }
        throw new CasDataException(CasDataException.NULL_ACCOUNTBANK);
    }

    private IRowSet getResultBySQL(Context ctx, String sql) throws SQLDataException, BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        DynamicRowSet drs = null;
        try {
            int i;
            ResultSetMetaData rsmd = rs.getMetaData();
            int colCount = rsmd.getColumnCount();
            drs = new DynamicRowSet(colCount);
            String[] columnNameArray = new String[colCount];
            for (i = 0; i < colCount; ++i) {
                String columnName = rsmd.getColumnName(i + 1);
                int columnClz = rsmd.getColumnType(i + 1);
                String columnlbl = rsmd.getColumnLabel(i + 1);
                columnNameArray[i] = columnName;
                ColInfo ciId = new ColInfo(columnName, columnlbl, columnClz, null);
                drs.setColInfo(i + 1, ciId);
            }
            while (rs.next()) {
                drs.moveToInsertRow();
                for (i = 0; i < colCount; ++i) {
                    drs.updateObject(columnNameArray[i], rs.getObject(columnNameArray[i]));
                }
                drs.insertRow();
            }
            drs.beforeFirst();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return drs;
    }

    private Date getReportEndDate(ICalculateContextProvider context, Context ctx) {
        return (Date)context.getReportAdapter().getReportProperty("Report_EndDate");
    }

    private String getReportCompany(ICalculateContextProvider context, Context ctx) {
        BatchHelper batchHelper = new BatchHelper(context, ctx);
        return batchHelper.getCompany_Number();
    }

    private String getReportCurrency(ICalculateContextProvider context, Context ctx) {
        return (String)context.getReportAdapter().getReportProperty("Currency.Number");
    }

    private Date getReportStartDate(ICalculateContextProvider context, Context ctx) {
        BatchHelper batchHelper = new BatchHelper(context, ctx);
        return batchHelper.getReport_StartDate();
    }

    public ICalculateContextProvider getContext() {
        return this.context;
    }

    public void setContext(ICalculateContextProvider context) {
        this.context = context;
    }

    public SortedParameterArray getParams() {
        return this.params;
    }

    public void setParams(SortedParameterArray params) {
        this.params = params;
    }

    public Context getServerCtx() {
        return this.serverCtx;
    }

    public void setServerCtx(Context serverCtx) {
        this.serverCtx = serverCtx;
    }
}

