/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FloatActionEnum;
import com.kingdee.eas.fm.fin.IntRateModifyType;
import com.kingdee.eas.fm.fin.IsOrNoEnum;
import com.kingdee.eas.fm.fin.LoanAdjustInterestInfo;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.app.AbstractLoanAdjustInterestControllerBean;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.im.PenAccrualTypeEnum;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LoanAdjustInterestControllerBean
extends AbstractLoanAdjustInterestControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.LoanAdjustInterestControllerBean");

    protected SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("lastPreIntDate"));
        sic.add(new SelectorItemInfo("lastIntDate"));
        sic.add(new SelectorItemInfo("Institution.*"));
        sic.add(new SelectorItemInfo("GroupID.*"));
        sic.add(new SelectorItemInfo("contractNum"));
        sic.add(new SelectorItemInfo("BankAcct.*"));
        return sic;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)((BillBaseInfo)model), (AbstractCoreBaseControllerBean)this);
        LoanAdjustInterestInfo info = (LoanAdjustInterestInfo)model;
        HashMap<String, String> botpRelationShip = new HashMap<String, String>();
        this.checkNumberDup(ctx, model);
        this.checkSeqDup(ctx, model);
        this.checkSameDay(ctx, (LoanAdjustInterestInfo)model);
        this.checkContinuity(ctx, (LoanAdjustInterestInfo)model);
        IObjectPK pk = super._submit(ctx, (IObjectValue)info);
        botpRelationShip.put(info.getLoan().getId().toString(), info.getId().toString());
        FMHelper.saveBOTRelation((Context)ctx, botpRelationShip);
        if (IntRateModifyType.LPR.equals((Object)info.getModifyRateType())) {
            String sql = " UPDATE T_FIN_LOAN SET FISLPR = 1 WHERE FID = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getLoan().getId().toString()});
        } else if (IntRateModifyType.Agreement.equals((Object)info.getModifyRateType())) {
            String sql = " UPDATE T_FIN_LOAN SET FISLPR = 0 WHERE FID = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getLoan().getId().toString()});
        }
        return pk;
    }

    private void checkSameDay(Context ctx, LoanAdjustInterestInfo info) throws BOSException, EASBizException {
        String id = info.getLoan().getId().toString();
        String sql = "select fid from t_fin_LoanAdjustInterest where floanid = ? and FAdjustDate = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{id, info.getAdjustDate()});
        try {
            if (rs.next() && !(info.getId() + "").equals(rs.getString("fid"))) {
                throw new FinBizException(FinBizException.SAMEDAY, new Object[]{info.getLoan().getNumber()});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkContinuity(Context ctx, LoanAdjustInterestInfo info) throws BOSException, EASBizException {
        String loanId = info.getLoan().getId().toString();
        String sql = null;
        if (!EmptyUtil.isEmpty((Object)info.getId())) {
            String loanAdjustInterestId = info.getId().toString();
            sql = "select max(FADJUSTDATE) as adj from t_fin_LoanAdjustInterest where floanid = ? and fid <> '" + loanAdjustInterestId + "'";
        } else {
            sql = "select max(FADJUSTDATE) as adj from t_fin_LoanAdjustInterest where floanid = ?";
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{loanId});
        try {
            while (rs.next()) {
                Date lastAdjDate = rs.getDate("adj");
                if (lastAdjDate == null || !lastAdjDate.after(info.getAdjustDate())) continue;
                throw new FinBizException(FinBizException.ADJUSTERROR);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected void checkSeqDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = this.getCheckSeqDupFilter(model, true, "adjustSeq");
        if (this._exists(ctx, filter)) {
            throw new FinBizException(FinBizException.CHECKDUPSEQ, new Object[]{model.getString("adjustSeq"), ""});
        }
    }

    protected FilterInfo getCheckSeqDupFilter(IObjectValue model, boolean isNeedComp, String seqName) {
        FilterInfo filter = new FilterInfo();
        if (isNeedComp) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)model.getObjectValue("company").getBOSUuid("id")));
        }
        filter.getFilterItems().add(new FilterItemInfo(seqName, (Object)model.getString(seqName)));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)model.getBOSUuid("id"), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("loan.id", (Object)model.getString("loan.id")));
        return filter;
    }

    @Override
    protected Integer _getMaxSeq(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        int maxAdjustSeq = 0;
        String sql = " select isnull(max(FAdjustSeq),0) from T_FIN_LoanAdjustInterest where FLoanID = ? ";
        Connection cn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            cn = this.getConnection(ctx);
            pstmt = cn.prepareStatement(sql);
            pstmt.setString(1, pk.toString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                maxAdjustSeq = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
        return new Integer(++maxAdjustSeq);
    }

    @Override
    protected Map _batchAdjust(Context ctx, Set loanIDSet, java.util.Date adjustDate, IntRateTypeExpressionEnum intRateTypeExpression, Integer yearDays, BigDecimal adjustAfterRate, PenAccrualTypeEnum penAccrualType, BigDecimal adjustPenAccrualRate, Map addValueMap) throws BOSException, EASBizException {
        HashMap<String, Serializable> hm = new HashMap<String, Serializable>();
        HashSet<IObjectPK> createdIdSet = new HashSet<IObjectPK>();
        CompanyOrgUnitInfo CURRENT_COMPANY = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        UserInfo CURRENT_USER = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        StringBuffer errMsg = new StringBuffer();
        for (String loanID : loanIDSet) {
            java.util.Date lastSettleDate = null;
            java.util.Date lastPreDate = null;
            LoanInfo loanInfo = LoanFactory.getLocalInstance(ctx).getLoanInfo((IObjectPK)new ObjectUuidPK(loanID), this.getSelectors());
            try {
                if (adjustDate.before(loanInfo.getIssueDate())) {
                    throw new FinBizException(FinBizException.ADJUSTDATEMUSTAFTERLOANDATE);
                }
                java.util.Date comDate = null;
                lastPreDate = loanInfo.getLastPreIntDate();
                lastSettleDate = loanInfo.getLastIntDate();
                if (lastSettleDate != null || lastPreDate != null) {
                    if (lastSettleDate == null) {
                        comDate = lastPreDate;
                    } else if (lastPreDate == null) {
                        comDate = lastSettleDate;
                    } else {
                        java.util.Date date = comDate = lastSettleDate.after(lastPreDate) ? lastSettleDate : lastPreDate;
                    }
                    if (adjustDate.getTime() <= comDate.getTime()) {
                        throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"114_LoanAdjustInterestControllerBean", (Locale)ctx.getLocale()));
                    }
                }
                LoanAdjustInterestInfo adjustInfo = new LoanAdjustInterestInfo();
                adjustInfo.setLoan(loanInfo);
                adjustInfo.setCreditorAsCompany(loanInfo.getGroupID());
                adjustInfo.setCreditorAsBank(loanInfo.getInstitution());
                adjustInfo.setAccount(loanInfo.getBankAcct());
                adjustInfo.setContractNum(loanInfo.getContractNum());
                adjustInfo.setAdjustSeq(this._getMaxSeq(ctx, (IObjectPK)new ObjectUuidPK(loanID)));
                adjustInfo.setAdjustDate(adjustDate);
                adjustInfo.setIntRateTypeExpression(intRateTypeExpression);
                adjustInfo.setYearDays(yearDays);
                adjustInfo.setAdjustAfterRate(adjustAfterRate);
                if (!EmptyUtil.isEmpty((Object)penAccrualType)) {
                    adjustInfo.setPenAccrualType(penAccrualType);
                }
                if (!EmptyUtil.isEmpty((Object)adjustPenAccrualRate)) {
                    adjustInfo.setPenAccrualRate(adjustPenAccrualRate);
                }
                adjustInfo.setIsUsed(IsOrNoEnum.NO);
                adjustInfo.setCreator(CURRENT_USER);
                adjustInfo.setCompany(CURRENT_COMPANY);
                adjustInfo.setModifyRateType((IntRateModifyType)((Object)addValueMap.get("rateModifyType")));
                if (!EmptyUtil.isEmpty(addValueMap.get("rateType"))) {
                    adjustInfo.setIntRateType((IntRateTypeInfo)addValueMap.get("rateType"));
                }
                if (!EmptyUtil.isEmpty(addValueMap.get("floatAction"))) {
                    adjustInfo.setFloatAction((FloatActionEnum)((Object)addValueMap.get("floatAction")));
                }
                if (!EmptyUtil.isEmpty(addValueMap.get("basePoints"))) {
                    adjustInfo.setBasePoints((BigDecimal)addValueMap.get("basePoints"));
                }
                if (!EmptyUtil.isEmpty(addValueMap.get("firstRateAjdust"))) {
                    adjustInfo.setFirstRateAdjustDate((java.util.Date)addValueMap.get("firstRateAjdust"));
                }
                if (!EmptyUtil.isEmpty(addValueMap.get("rateAdjustPeriod"))) {
                    adjustInfo.setRateAdjustPeriod(Integer.valueOf(addValueMap.get("rateAdjustPeriod").toString()));
                }
                adjustInfo.setIsBond(loanInfo.isIsBonds());
                IObjectPK pk = this._submit(ctx, (IObjectValue)adjustInfo);
                createdIdSet.add(pk);
            }
            catch (Exception e) {
                errMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"115_LoanAdjustInterestControllerBean", (Locale)ctx.getLocale()) + loanInfo.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"116_LoanAdjustInterestControllerBean", (Locale)ctx.getLocale()) + e.getMessage() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"117_LoanAdjustInterestControllerBean", (Locale)ctx.getLocale()));
                errMsg.append("\n");
            }
        }
        hm.put("createdIdSet", createdIdSet);
        hm.put("errMsg", errMsg);
        return hm;
    }

    @Override
    protected Set _filterLoanIDSet(Context ctx, Set loanIDSet) throws BOSException, EASBizException {
        HashSet<String> filterLoanIDSet = new HashSet<String>();
        for (String loanID : loanIDSet) {
            LoanInfo loanInfo = LoanFactory.getLocalInstance(ctx).getLoanInfo((IObjectPK)new ObjectUuidPK(loanID));
            if (loanInfo.getEntLoanID() != null) continue;
            filterLoanIDSet.add(loanID);
        }
        return filterLoanIDSet;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanAdjustInterestInfo loanAdjustInterestInfo = this.getLoanAdjustInterestInfo(ctx, pk);
        if (IntRateModifyType.LPR.equals((Object)loanAdjustInterestInfo.getModifyRateType())) {
            String sql = " UPDATE T_FIN_LOAN SET FISLPR = 0 WHERE FID = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{loanAdjustInterestInfo.getLoan().getId().toString()});
        }
        super._delete(ctx, pk);
    }
}

