/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinancingResultEnum;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LetterOperateTypeEnum;
import com.kingdee.eas.fm.fin.LoanApplyBillCollection;
import com.kingdee.eas.fm.fin.LoanApplyBillInfo;
import com.kingdee.eas.fm.fin.LoanApplyBillStatusEnum;
import com.kingdee.eas.fm.fin.LoanApplyException;
import com.kingdee.eas.fm.fin.LoanContractCollection;
import com.kingdee.eas.fm.fin.LoanContractFactory;
import com.kingdee.eas.fm.fin.app.AbstractLoanApplyBillControllerBean;
import com.kingdee.eas.fm.nt.LetterOfCreditReachFactory;
import com.kingdee.eas.fm.nt.LetterOfCreditReachInfo;
import com.kingdee.eas.fm.nt.LetterOfCreditReceiveInfo;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class LoanApplyBillControllerBean
extends AbstractLoanApplyBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.LoanApplyBillControllerBean");

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sql = "update T_FIN_LoanApplyBill set FStatus = ? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(3), pk.toString()});
    }

    @Override
    protected void _batchAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        ObjectUuidPK pk = null;
        Iterator iter = idSet.iterator();
        while (iter.hasNext()) {
            pk = new ObjectUuidPK((String)iter.next());
            super.audit(ctx, (IObjectPK)pk);
        }
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanApplyBillInfo info = this.getLoanApplyBillInfo(ctx, pk);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)info.getId().toString()));
        view.setFilter(filter);
        LoanContractCollection col = LoanContractFactory.getLocalInstance(ctx).getLoanContractCollection(view);
        if (col.size() > 0) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"118_LoanApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
        String sql = "update T_FIN_LoanApplyBill set FStatus = ? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(1), pk.toString()});
    }

    @Override
    protected void _batchAntiAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        this.checkAntiAudit(ctx, idSet);
        this.doAntiAudit(ctx, idSet);
    }

    private void doAntiAudit(Context ctx, Set idSet) throws EASBizException, BOSException {
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK((String)it.next());
            this.antiAudit(ctx, (IObjectPK)pk);
        }
    }

    private void checkAntiAudit(Context ctx, Set idSet) throws EASBizException, BOSException {
        LoanApplyBillCollection loanApplyCol = this.getLoanApplyCol(ctx, idSet);
        LoanApplyBillInfo tmpInfo = null;
        for (int i = 0; i < loanApplyCol.size(); ++i) {
            tmpInfo = loanApplyCol.get(i);
            if (tmpInfo.getStatus() != LoanApplyBillStatusEnum.AUDITED) {
                throw new LoanApplyException(LoanApplyException.SAVE_BILL_ANTIAUDIT_ERROR, new Object[]{tmpInfo.getNumber()});
            }
            if (tmpInfo.isIsGenLoanBill()) {
                throw new LoanApplyException(LoanApplyException.HAS_GEN_LOAN_BILL, new Object[]{tmpInfo.getNumber()});
            }
            if (!tmpInfo.isIsGenLoanOrgBill()) continue;
            throw new LoanApplyException(LoanApplyException.HAS_GEN_LOAN_ORG_BILL, new Object[]{tmpInfo.getNumber()});
        }
    }

    private LoanApplyBillCollection getLoanApplyCol(Context ctx, Set idSet) throws EASBizException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        return this.getLoanApplyBillCollection(ctx, evi);
    }

    private void checkStatus(Context ctx, LoanApplyBillInfo loanApplyBillInfo) throws EASBizException, BOSException {
        LoanApplyBillInfo oldInfo;
        boolean isExist;
        if (!EmptyUtil.isEmpty((Object)loanApplyBillInfo.getId()) && (isExist = this.exists(ctx, (IObjectPK)new ObjectUuidPK(loanApplyBillInfo.getId()))) && !EmptyUtil.isEmpty((CoreBaseInfo)(oldInfo = this.getLoanApplyBillInfo(ctx, (IObjectPK)new ObjectUuidPK(loanApplyBillInfo.getId())))) && LoanApplyBillStatusEnum.AUDITED == oldInfo.getStatus()) {
            throw new FinBizException(FinBizException.FINFEESUBMIT);
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        LoanApplyBillInfo loanApplyBillInfo = (LoanApplyBillInfo)model;
        this.checkStatus(ctx, loanApplyBillInfo);
        loanApplyBillInfo.setStatus(LoanApplyBillStatusEnum.SAVE);
        IObjectPK pk = super._save(ctx, (IObjectValue)loanApplyBillInfo);
        return pk;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanApplyBillInfo loanApplyBillInfo = (LoanApplyBillInfo)model;
        this.checkStatus(ctx, loanApplyBillInfo);
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)loanApplyBillInfo);
        loanApplyBillInfo.setStatus(LoanApplyBillStatusEnum.SUBMIT);
        this.dispose(ctx, loanApplyBillInfo, LetterOperateTypeEnum.submit);
        IObjectPK pk = super._submit(ctx, (IObjectValue)loanApplyBillInfo);
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)loanApplyBillInfo);
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)loanApplyBillInfo);
        NTHelper.OnWaybgCtrl((Context)ctx, (String)pk.toString());
        return pk;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)model);
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)((BillBaseInfo)model), (AbstractCoreBaseControllerBean)this);
        this.checkNumberDup(ctx, model);
        ((LoanApplyBillInfo)model).setFinancingResult(FinancingResultEnum.OTHER);
        IObjectPK pkReturn = super._addnew(ctx, model);
        return pkReturn;
    }

    private void dispose(Context ctx, LoanApplyBillInfo info, LetterOperateTypeEnum disposerActionEnum) throws BOSException, EASBizException {
        String sourceBillId = info.getSourceBillId();
        if (FMHelper.isEmpty((String)sourceBillId)) {
            return;
        }
        BOSObjectType bosType = BOSUuid.read((String)sourceBillId).getType();
        if (bosType.equals((Object)new LetterOfCreditReachInfo().getBOSType())) {
            LetterOfCreditReachInfo srcinfo = LetterOfCreditReachFactory.getLocalInstance((Context)ctx).getLetterOfCreditReachInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
            if (disposerActionEnum.equals((Object)LetterOperateTypeEnum.submit)) {
                srcinfo.setIsGenLoanReq(true);
            } else {
                srcinfo.setIsGenLoanReq(false);
            }
            LetterOfCreditReachFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)srcinfo, this.getUpdatePartialSelectors());
        } else if (bosType.equals((Object)new LetterOfCreditInfo().getBOSType())) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("CreditLimit.*");
            sic.add("CreditLimit.CreditUsage.*");
            LetterOfCreditInfo srcinfo = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(sourceBillId), sic);
            if (disposerActionEnum.equals((Object)LetterOperateTypeEnum.submit)) {
                srcinfo.setIsGenLoanReq(true);
            } else {
                srcinfo.setIsGenLoanReq(false);
            }
            LetterOfCreditFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)srcinfo, this.getUpdatePartialSelectors());
            HashMap<String, String> idMap = new HashMap<String, String>();
            idMap.put(srcinfo.getId().toString(), info.getId().toString());
            FMHelper.saveBOTRelation((Context)ctx, idMap);
        } else if (bosType.equals((Object)new LetterOfCreditReceiveInfo().getBOSType())) {
            Integer isOutput = LetterOperateTypeEnum.submit.equals((Object)disposerActionEnum) ? Constants.TRUE : Constants.FALSE;
            String sql = " update T_NT_LetterOfCreditReceive set FIsOutput = ? where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{isOutput, info.getSourceBillId()});
        }
    }

    private SelectorItemCollection getUpdatePartialSelectors() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("IsGenLoanReq");
        return selectors;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanApplyBillInfo info = this.getLoanApplyBillInfo(ctx, pk);
        this.dispose(ctx, info, LetterOperateTypeEnum.DELETE);
        NumberRuleUtil.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
        FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)pk);
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
        super._delete(ctx, pk);
    }

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    @Override
    protected void _setAuditingStatus(Context ctx, IObjectPK loanApplyPK) throws BOSException, EASBizException {
        String sql = "update T_FIN_LoanApplyBill set FStatus = ? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(1), loanApplyPK.toString()});
    }

    @Override
    protected void _setSubmitedStatus(Context ctx, IObjectPK loanApplyBillPK) throws BOSException, EASBizException {
        String sql = "update T_FIN_LoanApplyBill set FStatus = ? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(1), loanApplyBillPK.toString()});
    }

    @Override
    protected boolean _isSupportWithWorkFlow(Context ctx) throws BOSException, EASBizException {
        boolean isSupportWorkFolw = false;
        IContextHelper iContextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo currencyCompany = iContextHelper.getCurrentCompany();
        isSupportWorkFolw = iContextHelper.getBooleanParam("not-Yet-add", (IObjectPK)new ObjectUuidPK(currencyCompany.getId()));
        return isSupportWorkFolw;
    }

    @Override
    protected List _batchSubmit(Context ctx, Set ids) throws BOSException, EASBizException {
        LoanApplyBillCollection loanApplyCol = this.getLoanApplyCol(ctx, ids);
        ArrayList<String> returnList = new ArrayList<String>();
        LoanApplyBillInfo tmpInfo = null;
        for (int i = 0; i < loanApplyCol.size(); ++i) {
            tmpInfo = loanApplyCol.get(i);
            try {
                if (tmpInfo.getStatus() != LoanApplyBillStatusEnum.SAVE) continue;
                super.submit(ctx, (CoreBaseInfo)tmpInfo);
                continue;
            }
            catch (Exception e) {
                returnList.add(tmpInfo.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"7_LoanApplyBillControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
            }
        }
        return returnList;
    }
}

