/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.ProjectFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AbstractFMDataImport;
import com.kingdee.eas.fi.cas.FundFlowItemFactory;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.app.RecAndPayDataImportUtil2;
import com.kingdee.eas.fm.fin.CreditorGroupCollection;
import com.kingdee.eas.fm.fin.CreditorGroupFactory;
import com.kingdee.eas.fm.fin.FinBillStatusEnum;
import com.kingdee.eas.fm.fin.FinancingProductsFactory;
import com.kingdee.eas.fm.fin.FinancingProductsInfo;
import com.kingdee.eas.fm.fin.FinancingSourcesInfo;
import com.kingdee.eas.fm.fin.FloatActionEnum;
import com.kingdee.eas.fm.fin.GuaranteeTypeCollection;
import com.kingdee.eas.fm.fin.GuaranteeTypeFactory;
import com.kingdee.eas.fm.fin.GuaranteeTypeInputModeEnum;
import com.kingdee.eas.fm.fin.ILoan;
import com.kingdee.eas.fm.fin.LoanCollection;
import com.kingdee.eas.fm.fin.LoanEntryFactory;
import com.kingdee.eas.fm.fin.LoanEntryInfo;
import com.kingdee.eas.fm.fin.LoanException;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.RepayIntTypeEnum;
import com.kingdee.eas.fm.fin.RepaymentTypeEnum;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.IntRateTypeFactory;
import com.kingdee.eas.fm.im.IntSchemeFactory;
import com.kingdee.eas.fm.im.PenAccrualTypeEnum;
import com.kingdee.eas.fm.mnt.BlockingFlowTypeCollection;
import com.kingdee.eas.fm.mnt.BlockingFlowTypeFactory;
import com.kingdee.eas.fm.mnt.BlockingFlowTypeInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class LoanBill4HistroyDataImport
extends AbstractFMDataImport {
    private static Logger logger = Logger.getLogger((String)LoanBill4HistroyDataImport.class.getName());
    private static String WD = "\u59d4\u6258\u8d37\u6b3e";
    private static String OTHER = "\u5176\u4ed6";
    private static String TRUE = "true";
    private static String FALSE = "false";
    LoanEntryInfo entryInfo = null;
    protected CompanyOrgUnitInfo importCompanyInfo = null;

    protected ICoreBase _getController(Context ctx) throws EASBizException, BOSException {
        return LoanFactory.getLocalInstance(ctx);
    }

    protected CoreBaseInfo _transmit(Hashtable hsData, Context ctx) throws EASBizException, BOSException {
        String number = (String)this.getData(hsData, "FNumber");
        String companyId = null;
        CompanyOrgUnitInfo company = null;
        Object companyData = this.getData(hsData, "FCompany_number");
        if (companyData != null && companyData.toString().trim().length() > 0) {
            company = RecAndPayDataImportUtil2.getCompanyByNumber((Context)ctx, (String)((String)companyData));
        }
        if (company == null) {
            company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        }
        companyId = company.getId().toString();
        this.importCompanyInfo = company;
        LoanInfo info = new LoanInfo();
        ObjectUuidPK companyPK = new ObjectUuidPK(company.getId().toString());
        ObjectUuidPK userPK = new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId());
        boolean hasFunctionPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)userPK, (IObjectPK)companyPK, "fin_Loan_loanImport");
        if (!hasFunctionPermission) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"661_LoanImport", (Locale)ctx.getLocale()));
        }
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        info = this.getHeadInfo(ctx, mode, number, companyId);
        info.setCompany(company);
        info = this.parseInfo(hsData, ctx, info);
        return info;
    }

    private LoanInfo parseInfo(Hashtable hsData, Context ctx, LoanInfo info) throws BOSException, EASBizException {
        AccountViewCollection collection;
        AccountTableInfo accountTableInfo;
        Object collection2;
        FilterInfo filter;
        EntityViewInfo view;
        this.prepareImport(ctx, (IObjectValue)info, hsData);
        Object data = null;
        data = this.getData(hsData, "FNumber");
        if (data != null && data.toString().trim().length() > 0) {
            info.setNumber(data.toString());
        }
        if ((data = this.getData(hsData, "FBizDate")) == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"16_AgentPayBillDataImport", (Locale)ctx.getLocale()));
        }
        info.setBizDate(RecAndPayDataImportUtil2.objToDate((Context)ctx, (Object)data));
        data = this.getData(hsData, "FDescription");
        if (data != null && data.toString().trim().length() > 0) {
            if (data.toString().length() > 255) {
                throw new RecPayException(RecPayException.DESCNOTMORE, (Object[])new String[]{String.valueOf(255)});
            }
            info.setDescription(data.toString());
        }
        if ((data = this.getData(hsData, "FType_number")) != null && data.toString().trim().length() > 0) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            view.setFilter(filter);
            collection2 = FinancingProductsFactory.getLocalInstance((Context)ctx).getFinancingProductsCollection(view);
            if (collection2.size() > 0) {
                info.setType(collection2.get(0));
            } else {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1090_LoanImport", (Locale)ctx.getLocale()));
            }
        }
        if ((data = this.getData(hsData, "FContractNum")) != null && data.toString().trim().length() > 0) {
            info.setContractNum(data.toString());
        }
        if ((data = this.getData(hsData, "FCurrency_number")) != null && data.toString().trim().length() > 0) {
            info.setCurrency(RecAndPayDataImportUtil2.getCurrencyByNumber((Context)ctx, (String)data.toString()));
        } else {
            CompanyOrgUnitInfo company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            try {
                info.setCurrency(ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(info.getCompany()));
            }
            catch (Exception e) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"17_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        data = this.getData(hsData, "FAmount");
        if (data != null && data.toString().trim().length() > 0) {
            if (TypeConversionUtils.objToBigDecimal((Object)data).compareTo(BigDecimal.ZERO) < 1) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"662_LoanImport", (Locale)ctx.getLocale()));
            }
        } else {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"121_LoanBill4HistroyDataImport", (Locale)ctx.getLocale()));
        }
        info.setAmount(TypeConversionUtils.objToBigDecimal((Object)data));
        data = this.getData(hsData, "FBalance");
        if (data != null && data.toString().trim().length() > 0) {
            if (TypeConversionUtils.objToBigDecimal((Object)data).compareTo(BigDecimal.ZERO) < 1) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"122_LoanBill4HistroyDataImport", (Locale)ctx.getLocale()));
            }
        } else {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"123_LoanBill4HistroyDataImport", (Locale)ctx.getLocale()));
        }
        info.setBalance(TypeConversionUtils.objToBigDecimal((Object)data));
        if (info.getAmount().compareTo(info.getBalance()) != 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"124_LoanBill4HistroyDataImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "FLocalCurExRate");
        if (data != null && data.toString().trim().length() > 0) {
            info.setLocalCurExRate(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        if ((data = this.getData(hsData, "FAmountLocalCur")) != null && data.toString().trim().length() > 0) {
            info.setAmountLocalCur(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        if ((data = this.getData(hsData, "FIssueDate")) == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"663_LoanImport", (Locale)ctx.getLocale()));
        }
        info.setIssueDate(RecAndPayDataImportUtil2.objToDate((Context)ctx, (Object)data));
        data = this.getData(hsData, "FExpiredDate");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"664_LoanImport", (Locale)ctx.getLocale()));
        }
        info.setExpiredDate(RecAndPayDataImportUtil2.objToDate((Context)ctx, (Object)data));
        if (info.getExpiredDate().compareTo(info.getIssueDate()) <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"671_LoanImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "FHorizon");
        if (data != null && data.toString().trim().length() > 0) {
            if (TypeConversionUtils.objToBigDecimal((Object)data).compareTo(BigDecimal.ZERO) < 1) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"665_LoanImport", (Locale)ctx.getLocale()));
            }
            info.setHorizon(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        if ((data = this.getData(hsData, "FHistoryBill")) != null && data.toString().trim().length() > 0) {
            boolean historyBill = false;
            if (!TRUE.equalsIgnoreCase(data.toString()) && !FALSE.equalsIgnoreCase(data.toString())) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"673_LoanImport", (Locale)ctx.getLocale()));
            }
            if (TRUE.equalsIgnoreCase(data.toString())) {
                historyBill = true;
            }
            info.setHistoryBill(historyBill);
        }
        if ((data = this.getData(hsData, "FIsGroupLoan")) != null && data.toString().trim().length() > 0) {
            boolean isGroupLoan = false;
            if (!TRUE.equalsIgnoreCase(data.toString()) && !FALSE.equalsIgnoreCase(data.toString())) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"674_LoanImport", (Locale)ctx.getLocale()));
            }
            if (TRUE.equalsIgnoreCase(data.toString())) {
                isGroupLoan = true;
            }
            info.setIsGroupLoan(isGroupLoan);
        }
        if ((data = this.getData(hsData, "FIsBankLoan")) != null && data.toString().trim().length() > 0) {
            boolean isBankLoan = false;
            if (!TRUE.equalsIgnoreCase(data.toString()) && !FALSE.equalsIgnoreCase(data.toString())) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"675_LoanImport", (Locale)ctx.getLocale()));
            }
            if (TRUE.equalsIgnoreCase(data.toString())) {
                isBankLoan = true;
            }
            info.setIsBankLoan(isBankLoan);
        }
        if ((data = this.getData(hsData, "FInstitution_number")) != null && data.toString().trim().length() > 0) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            view.setFilter(filter);
            collection2 = BankFactory.getLocalInstance((Context)ctx).getBankCollection(view);
            if (collection2.size() > 0) {
                info.setInstitution(collection2.get(0));
            }
        } else if (info.isIsBankLoan()) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"666_LoanImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "FGroupID_number");
        if (data != null && data.toString().trim().length() > 0) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            view.setFilter(filter);
            collection2 = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
            if (collection2.size() > 0) {
                info.setGroupID(collection2.get(0));
            }
        } else if (!info.isIsBankLoan() && info.isIsGroupLoan()) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"667_LoanImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "FCreditorGroup_number");
        if (data != null && data.toString().trim().length() > 0) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            view.setFilter(filter);
            collection2 = CreditorGroupFactory.getLocalInstance(ctx).getCreditorGroupCollection(view);
            if (collection2.size() > 0) {
                info.setCreditorGroup(((CreditorGroupCollection)((Object)collection2)).get(0));
            } else {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1091_LoanImport", (Locale)ctx.getLocale()));
            }
        }
        if ((data = this.getData(hsData, "FBankAcct_number")) != null && data.toString().trim().length() > 0) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            view.setFilter(filter);
            collection2 = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
            if (collection2.size() > 0) {
                info.setBankAcct(collection2.get(0));
            }
        }
        if ((data = this.getData(hsData, "FSettlementAcct_number")) != null && data.toString().trim().length() > 0) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)this.importCompanyInfo.getId().toString()));
            accountTableInfo = this.importCompanyInfo.getAccountTable();
            if (accountTableInfo != null && accountTableInfo.getId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTableInfo.getId().toString()));
            }
            view.setFilter(filter);
            collection = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
            if (collection.size() > 0) {
                info.setSettlementAcct(collection.get(0));
            }
        }
        if ((data = this.getData(hsData, "FLoanAcct_number")) != null && data.toString().trim().length() > 0) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)this.importCompanyInfo.getId().toString()));
            accountTableInfo = this.importCompanyInfo.getAccountTable();
            if (accountTableInfo != null && accountTableInfo.getId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTableInfo.getId().toString()));
            }
            view.setFilter(filter);
            collection = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
            if (collection.size() > 0) {
                info.setLoanAcct(collection.get(0));
            }
        }
        if ((data = this.getData(hsData, "FBasePoints")) != null && data.toString().trim().length() > 0) {
            info.setBasePoints(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        if ((data = this.getData(hsData, "FFloatAction")) != null && data.toString().trim().length() > 0) {
            try {
                info.setFloatAction(FloatActionEnum.getEnum(Integer.parseInt(data.toString())));
            }
            catch (NumberFormatException e) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"672_LoanImport", (Locale)ctx.getLocale()));
            }
        } else {
            info.setFloatAction(FloatActionEnum.BASEINTRATE_FLOAT);
        }
        data = this.getData(hsData, "FYieldRate");
        if (data != null && data.toString().trim().length() > 0) {
            if (TypeConversionUtils.objToBigDecimal((Object)data).compareTo(BigDecimal.ZERO) < 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"668_LoanImport", (Locale)ctx.getLocale()));
            }
            info.setYieldRate(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        if ((data = this.getData(hsData, "FIntRateType_number")) != null && data.toString().trim().length() > 0) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            view.setFilter(filter);
            collection2 = IntRateTypeFactory.getLocalInstance((Context)ctx).getIntRateTypeCollection(view);
            if (collection2.size() > 0) {
                info.setIntRateType(collection2.get(0));
            }
        }
        if ((data = this.getData(hsData, "FPayIntMode_number")) != null && data.toString().trim().length() > 0) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            view.setFilter(filter);
            collection2 = IntSchemeFactory.getLocalInstance((Context)ctx).getIntSchemeCollection(view);
            if (collection2.size() > 0) {
                info.setPayIntMode(collection2.get(0));
            }
        }
        if ((data = this.getData(hsData, "FIntFeeAcctView_number")) != null && data.toString().trim().length() > 0) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)this.importCompanyInfo.getId().toString()));
            accountTableInfo = this.importCompanyInfo.getAccountTable();
            if (accountTableInfo != null && accountTableInfo.getId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTableInfo.getId().toString()));
            }
            view.setFilter(filter);
            collection = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
            if (collection.size() > 0) {
                info.setIntFeeAcctView(collection.get(0));
            }
        }
        if ((data = this.getData(hsData, "FIntFreeAmt")) != null && data.toString().trim().length() > 0) {
            info.setIntFreeAmt(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        if ((data = this.getData(hsData, "FLastIntDate")) != null && data.toString().trim().length() > 0) {
            info.setLastIntDate(RecAndPayDataImportUtil2.objToDate((Context)ctx, (Object)data));
            if (info.getLastIntDate().before(info.getIssueDate())) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"699_LoanImport", (Locale)ctx.getLocale()));
            }
        } else if (info.isHistoryBill()) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"698_LoanImport", (Locale)ctx.getLocale()));
        }
        if ((data = this.getData(hsData, "FLastPreIntDate")) != null && data.toString().trim().length() > 0) {
            info.setLastPreIntDate(RecAndPayDataImportUtil2.objToDate((Context)ctx, (Object)data));
        }
        if ((data = this.getData(hsData, "FIntRateTypeExpression")) != null && data.toString().trim().length() > 0) {
            info.setIntRateTypeExpression(IntRateTypeExpressionEnum.getEnum((String)data.toString()));
        }
        if ((data = this.getData(hsData, "FYearDays")) != null && data.toString().trim().length() > 0) {
            int parseInt = Integer.parseInt(data.toString());
            if (parseInt <= 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"669_LoanImport", (Locale)ctx.getLocale()));
            }
            info.setYearDays(parseInt);
        } else {
            info.setYearDays(360);
        }
        data = this.getData(hsData, "FPenAccrualType");
        if (data != null && data.toString().trim().length() > 0) {
            info.setPenAccrualType(PenAccrualTypeEnum.getEnum((String)data.toString()));
        } else {
            info.setPenAccrualType(PenAccrualTypeEnum.ADD_PERCENT);
        }
        data = this.getData(hsData, "FPenAccrualRate");
        if (data != null && data.toString().trim().length() > 0) {
            info.setPenAccrualRate(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        if ((data = this.getData(hsData, "FFirstRateAdjustDate")) != null && data.toString().trim().length() > 0) {
            info.setFirstRateAdjustDate(RecAndPayDataImportUtil2.objToDate((Context)ctx, (Object)data));
        } else {
            info.setFirstRateAdjustDate(info.getIssueDate());
        }
        data = this.getData(hsData, "FRateAdjustPeriod");
        if (data != null && data.toString().trim().length() > 0) {
            info.setRateAdjustPeriod(Integer.parseInt(data.toString()));
        }
        if ((data = this.getData(hsData, "FRepaymentType")) != null && data.toString().trim().length() > 0) {
            info.setRepaymentType(RepaymentTypeEnum.getEnum(Integer.parseInt(data.toString())));
        } else {
            info.setRepaymentType(RepaymentTypeEnum.BY_LUMP_SUM);
        }
        data = this.getData(hsData, "FGaranteeType_number");
        if (data != null && data.toString().trim().length() > 0) {
            EntityViewInfo view2 = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            view2.setFilter(filter);
            collection2 = GuaranteeTypeFactory.getLocalInstance(ctx).getGuaranteeTypeCollection(view2);
            if (collection2.size() > 0) {
                info.setGaranteeType(((GuaranteeTypeCollection)((Object)collection2)).get(0));
            }
        }
        if ((data = this.getData(hsData, "FProject_number")) != null && data.toString().trim().length() > 0) {
            EntityViewInfo view3 = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            view3.setFilter(filter);
            collection2 = ProjectFactory.getLocalInstance((Context)ctx).getProjectCollection(view3);
            if (collection2.size() > 0) {
                info.setProject(collection2.get(0));
            }
        }
        if ((data = this.getData(hsData, "FFundFlowItem_number")) != null && data.toString().trim().length() > 0) {
            EntityViewInfo view4 = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            view4.setFilter(filter);
            collection2 = FundFlowItemFactory.getLocalInstance((Context)ctx).getFundFlowItemCollection(view4);
            if (collection2.size() > 0) {
                info.setFundFlowItem(collection2.get(0));
            }
        }
        if ((data = this.getData(hsData, "FCautionAcctBank_number")) != null && data.toString().trim().length() > 0) {
            EntityViewInfo view5 = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            view5.setFilter(filter);
            collection2 = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view5);
            if (collection2.size() > 0) {
                info.setCautionAcctBank(collection2.get(0));
            }
        }
        if ((data = this.getData(hsData, "FAuctionPerc")) != null && data.toString().trim().length() > 0) {
            info.setAuctionPerc(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        if ((data = this.getData(hsData, "FCautionAmt")) != null && data.toString().trim().length() > 0) {
            info.setCautionAmt(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        if ((data = this.getData(hsData, "FHandlerRemark")) != null && data.toString().trim().length() > 0) {
            info.setHandlerRemark(data.toString());
        }
        if ((data = this.getData(hsData, "FRemark")) != null && data.toString().trim().length() > 0) {
            info.setRemark(data.toString());
        }
        if ((data = this.getData(hsData, "FCostCenter_number")) != null && data.toString().trim().length() > 0) {
            EntityViewInfo view6 = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            view6.setFilter(filter);
            collection2 = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitCollection(view6);
            if (collection2.size() > 0) {
                info.setCostCenter(collection2.get(0));
            }
        }
        if ((data = this.getData(hsData, "FDepositary_number")) != null && data.toString().trim().length() > 0) {
            EntityViewInfo view7 = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            view7.setFilter(filter);
            collection2 = BankFactory.getLocalInstance((Context)ctx).getBankCollection(view7);
            if (collection2.size() > 0) {
                info.setDepositary(collection2.get(0));
            }
        } else if (info.getType() != null && WD.equals(info.getType().getName())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"670_LoanImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "FIsloanshare");
        boolean isloanshare = false;
        if (data != null && data.toString().trim().length() > 0) {
            if (!TRUE.equalsIgnoreCase(data.toString()) && !FALSE.equalsIgnoreCase(data.toString())) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"676_LoanImport", (Locale)ctx.getLocale()));
            }
            if (TRUE.equalsIgnoreCase(data.toString())) {
                isloanshare = true;
            }
            info.setIsloanshare(isloanshare);
        } else {
            info.setIsloanshare(isloanshare);
        }
        data = this.getData(hsData, "FIRR");
        if (data != null && data.toString().trim().length() > 0) {
            info.setIRR(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        data = this.getData(hsData, "FIsLoanAndRepay");
        boolean isLoanAndRepay = false;
        if (data != null && data.toString().trim().length() > 0) {
            if (!TRUE.equalsIgnoreCase(data.toString()) && !FALSE.equalsIgnoreCase(data.toString())) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"677_LoanImport", (Locale)ctx.getLocale()));
            }
            if (TRUE.equalsIgnoreCase(data.toString())) {
                isLoanAndRepay = true;
            }
            info.setIsLoanAndRepay(isLoanAndRepay);
        } else {
            info.setIsLoanAndRepay(isLoanAndRepay);
        }
        if (info.getType() != null) {
            info.setSource(new FinancingSourcesInfo());
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add(new SelectorItemInfo("*"));
            evi.getSelector().add(new SelectorItemInfo("FinancingSource.*"));
            FinancingProductsInfo fInfo = FinancingProductsFactory.getLocalInstance((Context)ctx).getFinancingProductsInfo((IObjectPK)new ObjectUuidPK(info.getType().getId()), evi.getSelector());
            info.setSource(fInfo.getFinancingSource());
        }
        if (info.getStatus() == null) {
            info.setStatus(FinBillStatusEnum.SAVE);
        } else {
            info.setStatus(info.getStatus());
        }
        info.setCreator(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        if (info.getGuaranteeTypeInputMode() == null) {
            info.setGuaranteeTypeInputMode(GuaranteeTypeInputModeEnum.notassure);
        }
        return info;
    }

    protected void _submit(CoreBaseInfo coreBaseInfo, Context ctx) throws BOSException, EASBizException {
        if (coreBaseInfo == null) {
            return;
        }
        if (coreBaseInfo.getId() == null || !this._getController(ctx).exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
            this._getController(ctx).addnew(coreBaseInfo);
        } else {
            LoanInfo info = (LoanInfo)coreBaseInfo;
            if (FinBillStatusEnum.SAVE.equals((Object)info.getStatus()) || FinBillStatusEnum.SUBMIT.equals((Object)info.getStatus())) {
                this._getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            } else {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"14_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        LoanInfo loanInfo = (LoanInfo)coreBaseInfo;
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)loanInfo.getEntrys())) {
            if (loanInfo.getRepaymentType() == RepaymentTypeEnum.BY_LUMP_SUM) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("parent", (Object)loanInfo.getId().toString(), CompareType.EQUALS));
                LoanEntryFactory.getLocalInstance(ctx).delete(filter);
                LoanEntryFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)this.getDefaultLoanEntry(ctx, loanInfo));
            }
        } else {
            LoanEntryFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)this.getDefaultLoanEntry(ctx, loanInfo));
        }
    }

    public LoanEntryInfo getDefaultLoanEntry(Context ctx, LoanInfo loanInfo) throws BOSException, EASBizException {
        LoanEntryInfo info = new LoanEntryInfo();
        info.setDate(loanInfo.getExpiredDate());
        info.setAmount(loanInfo.getAmount());
        info.setRepayIntType(RepayIntTypeEnum.REPAY_INT);
        info.setBlockFlowType(this.getDefaultBlockingFlowTypeInfo(ctx));
        info.setSeq(1);
        info.setParent(loanInfo);
        return info;
    }

    public BlockingFlowTypeInfo getDefaultBlockingFlowTypeInfo(Context ctx) throws EASBizException, BOSException {
        EntityViewInfo vi = new EntityViewInfo();
        FilterInfo fInfo = new FilterInfo();
        fInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"001", CompareType.EQUALS));
        vi.setFilter(fInfo);
        BlockingFlowTypeCollection bftCollection = null;
        bftCollection = BlockingFlowTypeFactory.getLocalInstance((Context)ctx).getBlockingFlowTypeCollection(vi);
        if (bftCollection == null || bftCollection.size() == 0) {
            throw new LoanException(LoanException.BLOCKINGFLOWTYPENUMBER001NOTEXISTS);
        }
        BlockingFlowTypeInfo bftInfo = bftCollection.get(0);
        return bftInfo;
    }

    public void submitHead(CoreBaseInfo coreBaseInfo, Context ctx) throws BOSException {
        try {
            IObjectPK pk = LoanFactory.getLocalInstance(ctx).save(coreBaseInfo);
            coreBaseInfo.setId(BOSUuid.read((String)pk.toString()));
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }

    protected String getTemplateNumber() {
        return "loanBill4History";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = super.getExportFilterForQuery(ctx);
        Object obj = this.getContextParameter().get("filter");
        if (obj != null && obj instanceof FilterInfo) {
            FilterInfo filter1 = (FilterInfo)obj;
            try {
                filter.mergeFilter(filter1, "AND");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fm.fin.app.LoanQuery";
    }

    public Hashtable _exportTransmit(IRowSet rs, Context ctx) throws EASBizException, BOSException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            int isLoanAndRepay;
            int isloanshare;
            String depositary;
            String costCenter;
            String remark;
            String handlerRemark;
            BigDecimal cautionAmt;
            BigDecimal auctionPerc;
            String cautionAcctBank;
            String fundFlowItem;
            String project;
            String garanteeType;
            Date firstRateAdjustDate;
            BigDecimal penAccrualRate;
            String intRateTypeExpression;
            Date lastPreIntDate;
            Date lastIntDate;
            BigDecimal intFreeAmt;
            String intFeeAcctView;
            String payIntMode;
            String intRateType;
            BigDecimal yieldRate;
            int floatAction;
            BigDecimal basePoints;
            String loanAcct;
            String settlementAcct;
            String bankAcct;
            String creditorGroup;
            String groupID;
            int historyBill;
            BigDecimal horizon;
            Date expiredDate;
            Date issueDate;
            BigDecimal amountLocalCur;
            BigDecimal localCurExRate;
            BigDecimal balance;
            BigDecimal amount;
            String currency;
            String contractNum;
            String typeNumber;
            Date bizDate;
            String description;
            String number;
            String companyNumber = this.getString(rs, "company.number");
            if (companyNumber != null) {
                result.put("FCompany_number", companyNumber);
            }
            if ((number = this.getString(rs, "number")) != null) {
                result.put("FNumber", number);
            }
            if ((description = this.getString(rs, "description")) != null) {
                result.put("FDescription", description);
            }
            if ((bizDate = rs.getDate("bizDate")) != null) {
                result.put("FBizDate", DateTimeUtils.format((java.util.Date)bizDate, (String)"yyyy-MM-dd"));
            }
            if ((typeNumber = this.getString(rs, "type.number")) != null) {
                result.put("FType_number", typeNumber);
            }
            if ((contractNum = this.getString(rs, "contractNum")) != null) {
                result.put("FContractNum", contractNum);
            }
            if ((currency = this.getString(rs, "currency.number")) != null) {
                result.put("FCurrency_number", currency);
            }
            if ((amount = rs.getBigDecimal("amount")) != null) {
                result.put("FAmount", amount);
            }
            if ((balance = rs.getBigDecimal("balance")) != null) {
                result.put("FBalance", balance);
            }
            if ((localCurExRate = rs.getBigDecimal("localCurExRate")) != null) {
                result.put("FLocalCurExRate", localCurExRate);
            }
            if ((amountLocalCur = rs.getBigDecimal("amountLocalCur")) != null) {
                result.put("FAmountLocalCur", amountLocalCur);
            }
            if ((issueDate = rs.getDate("issueDate")) != null) {
                result.put("FIssueDate", DateTimeUtils.format((java.util.Date)issueDate, (String)"yyyy-MM-dd"));
            }
            if ((expiredDate = rs.getDate("expiredDate")) != null) {
                result.put("FExpiredDate", DateTimeUtils.format((java.util.Date)expiredDate, (String)"yyyy-MM-dd"));
            }
            if ((horizon = rs.getBigDecimal("horizon")) != null) {
                result.put("FHorizon", horizon);
            }
            if ((historyBill = rs.getInt("historyBill")) == 0) {
                result.put("FHistoryBill", "false");
            } else if (historyBill == 1) {
                result.put("FHistoryBill", "true");
            }
            int isGroupLoan = rs.getInt("isGroupLoan");
            if (isGroupLoan == 0) {
                result.put("FIsGroupLoan", "false");
            } else if (isGroupLoan == 1) {
                result.put("FIsGroupLoan", "true");
            }
            int isBankLoan = rs.getInt("isBankLoan");
            if (isBankLoan == 0) {
                result.put("FIsBankLoan", "false");
            } else if (isBankLoan == 1) {
                result.put("FIsBankLoan", "true");
            }
            String institutionNumber = this.getString(rs, "institution.number");
            if (institutionNumber != null) {
                result.put("FInstitution_number", institutionNumber);
            }
            if ((groupID = this.getString(rs, "groupID.number")) != null) {
                result.put("FGroupID_number", groupID);
            }
            if ((creditorGroup = this.getString(rs, "creditorGroup.number")) != null) {
                result.put("FCreditorGroup_number", creditorGroup);
            }
            if ((bankAcct = this.getString(rs, "bankAcct.number")) != null) {
                result.put("FBankAcct_number", bankAcct);
            }
            if ((settlementAcct = this.getString(rs, "settlementAcct.number")) != null) {
                result.put("FSettlementAcct_number", settlementAcct);
            }
            if ((loanAcct = this.getString(rs, "loanAcct.number")) != null) {
                result.put("FLoanAcct_number", loanAcct);
            }
            if ((basePoints = rs.getBigDecimal("basePoints")) != null) {
                result.put("FBasePoints", basePoints);
            }
            if (FloatActionEnum.getEnum(floatAction = rs.getInt("floatAction")) != null) {
                result.put("FFloatAction", floatAction);
            }
            if ((yieldRate = rs.getBigDecimal("yieldRate")) != null) {
                result.put("FYieldRate", yieldRate);
            }
            if ((intRateType = this.getString(rs, "intRateType.number")) != null) {
                result.put("FIntRateType_number", intRateType);
            }
            if ((payIntMode = this.getString(rs, "payIntMode.number")) != null) {
                result.put("FPayIntMode_number", payIntMode);
            }
            if ((intFeeAcctView = this.getString(rs, "intFeeAcctView.number")) != null) {
                result.put("FIntFeeAcctView_number", intFeeAcctView);
            }
            if ((intFreeAmt = rs.getBigDecimal("intFreeAmt")) != null) {
                result.put("FIntFreeAmt", intFreeAmt);
            }
            if ((lastIntDate = rs.getDate("lastIntDate")) != null) {
                result.put("FLastIntDate", DateTimeUtils.format((java.util.Date)lastIntDate, (String)"yyyy-MM-dd"));
            }
            if ((lastPreIntDate = rs.getDate("lastPreIntDate")) != null) {
                result.put("FLastPreIntDate", DateTimeUtils.format((java.util.Date)lastPreIntDate, (String)"yyyy-MM-dd"));
            }
            if ((intRateTypeExpression = this.getString(rs, "intRateTypeExpression")) != null) {
                result.put("FIntRateTypeExpression", intRateTypeExpression);
            }
            int yearDays = rs.getInt("yearDays");
            result.put("FYearDays", yearDays);
            String penAccrualType = this.getString(rs, "penAccrualType");
            if (penAccrualType != null) {
                result.put("FPenAccrualType", penAccrualType);
            }
            if ((penAccrualRate = rs.getBigDecimal("penAccrualRate")) != null) {
                result.put("FPenAccrualRate", penAccrualRate);
            }
            if ((firstRateAdjustDate = rs.getDate("firstRateAdjustDate")) != null) {
                result.put("FFirstRateAdjustDate", DateTimeUtils.format((java.util.Date)firstRateAdjustDate, (String)"yyyy-MM-dd"));
            }
            int rateAdjustPeriod = rs.getInt("rateAdjustPeriod");
            result.put("FRateAdjustPeriod", rateAdjustPeriod);
            int repaymentType = rs.getInt("repaymentType");
            if (RepaymentTypeEnum.getEnum(repaymentType) != null) {
                result.put("FRepaymentType", repaymentType);
            }
            if ((garanteeType = this.getString(rs, "garanteeType.number")) != null) {
                result.put("FGaranteeType_number", garanteeType);
            }
            if ((project = this.getString(rs, "project.number")) != null) {
                result.put("FProject_number", project);
            }
            if ((fundFlowItem = this.getString(rs, "fundFlowItem.number")) != null) {
                result.put("FFundFlowItem_number", fundFlowItem);
            }
            if ((cautionAcctBank = this.getString(rs, "cautionAcctBank.number")) != null) {
                result.put("FCautionAcctBank_number", cautionAcctBank);
            }
            if ((auctionPerc = rs.getBigDecimal("auctionPerc")) != null) {
                result.put("FAuctionPerc", auctionPerc);
            }
            if ((cautionAmt = rs.getBigDecimal("cautionAmt")) != null) {
                result.put("FCautionAmt", cautionAmt);
            }
            if ((handlerRemark = this.getString(rs, "handlerRemark")) != null) {
                result.put("FHandlerRemark", handlerRemark);
            }
            if ((remark = this.getString(rs, "remark")) != null) {
                result.put("FRemark", remark);
            }
            if ((costCenter = this.getString(rs, "costCenter.number")) != null) {
                result.put("FCostCenter_number", costCenter);
            }
            if ((depositary = this.getString(rs, "depositary.number")) != null) {
                result.put("FDepositary_number", depositary);
            }
            if ((isloanshare = rs.getInt("isloanshare")) == 0) {
                result.put("FIsloanshare", "false");
            } else if (isloanshare == 1) {
                result.put("FIsloanshare", "true");
            }
            BigDecimal IRR = rs.getBigDecimal("IRR");
            if (IRR != null) {
                result.put("FIRR", IRR);
            }
            if ((isLoanAndRepay = rs.getInt("isLoanAndRepay")) == 0) {
                result.put("FIsLoanAndRepay", "false");
            } else if (isLoanAndRepay == 1) {
                result.put("FIsLoanAndRepay", "true");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return result;
    }

    private LoanInfo getHeadInfo(Context ctx, int mode, String number, String companyid) throws BOSException, EASBizException {
        if (mode == 16 || mode == 128) {
            if (companyid == null || number == null) {
                return new LoanInfo();
            }
            try {
                ILoan loanInfo = (ILoan)this.getController(ctx);
                LoanCollection coll = loanInfo.getLoanCollection("where number = '" + number + "' and company.id = '" + companyid + "'");
                if (coll != null && coll.size() > 0) {
                    return coll.get(0);
                }
                return new LoanInfo();
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"15_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        if (mode == 8) {
            return new LoanInfo();
        }
        return new LoanInfo();
    }
}

