/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.common.FinBillResult;
import com.kingdee.eas.fm.fin.BillTypeEnum;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.GuanTypeBillEnum;
import com.kingdee.eas.fm.fin.GuaranteeDetailInfo;
import com.kingdee.eas.fm.fin.GuaranteeTypeInputModeEnum;
import com.kingdee.eas.fm.fin.LoanApplyBillFacadeFactory;
import com.kingdee.eas.fm.fin.LoanApplyBillInfo;
import com.kingdee.eas.fm.fin.LoanCollection;
import com.kingdee.eas.fm.fin.LoanContractCollection;
import com.kingdee.eas.fm.fin.LoanContractEnum;
import com.kingdee.eas.fm.fin.LoanContractFactory;
import com.kingdee.eas.fm.fin.LoanContractInfo;
import com.kingdee.eas.fm.fin.LoanException;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.RevokeStatusEnum;
import com.kingdee.eas.fm.fin.app.AbstractLoanContractControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class LoanContractControllerBean
extends AbstractLoanContractControllerBean {
    private static Logger logger = Logger.getLogger(LoanContractControllerBean.class);

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanContractInfo info = (LoanContractInfo)model;
        if (EmptyUtil.isEmpty((String)info.getNumber())) {
            if (FMHelper.hasNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString())) {
                info.setNumber(FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString()));
            } else {
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"125_LoanContractControllerBean", (Locale)ctx.getLocale())});
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            info.setIssueDate(sdf.parse(sdf.format(info.getIssueDate())));
            info.setExpiredDate(sdf.parse(sdf.format(info.getExpiredDate())));
            info.setConStartDate(sdf.parse(sdf.format(info.getConStartDate())));
            info.setConEndDate(sdf.parse(sdf.format(info.getConEndDate())));
            info.setBizDate(sdf.parse(sdf.format(info.getBizDate())));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return super._addnew(ctx, model);
    }

    protected void afterAddNew(Context ctx, IObjectPK returnPK, IObjectValue model) throws EASBizException, BOSException {
        super.afterAddNew(ctx, returnPK, model);
        this.updateLoanApplyBill(ctx, (LoanContractInfo)model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        LoanContractInfo info = (LoanContractInfo)model;
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        super._update(ctx, pk, model);
        LoanContractControllerBean.removeAssureBotp(ctx, info);
        LoanContractControllerBean.removeWageBotp(ctx, info);
        this.addAssureAndWageBotp(ctx, info);
    }

    private void addAssureAndWageBotp(Context ctx, LoanContractInfo info) throws BOSException, EASBizException {
        Iterator iter = info.getGuaranteeEntrys().iterator();
        while (iter.hasNext()) {
            GuaranteeDetailInfo element = (GuaranteeDetailInfo)iter.next();
            if (element.getBillId() == null || RevokeStatusEnum.revoked.equals((Object)element.getRevokeStatus()) || element.getBilltype() != GuanTypeBillEnum.AssureBill && element.getBilltype() != GuanTypeBillEnum.wage) continue;
            FinUtils.addBotRelation(ctx, element.getBillId(), info.getId().toString());
        }
    }

    private void updateLoanApplyBill(Context ctx, LoanContractInfo info) throws BOSException, EASBizException {
        String srcID = info.getSourceBillId();
        if (FMHelper.isInstanceof((String)srcID, LoanApplyBillInfo.class)) {
            LoanApplyBillFacadeFactory.getLocalInstance(ctx).afterGenLoanBill((IObjectPK)new ObjectUuidPK(srcID));
            LoanApplyBillFacadeFactory.getLocalInstance(ctx).saveBOTPRelations(srcID, info.getId().toString());
        }
    }

    @Override
    protected void reduceQuantum(Context ctx, FinancingBillInfo info) throws BOSException, EASBizException {
        GuaranteeDetailInfo element;
        Iterator iter = info.getGuaranteeEntrys().iterator();
        while (iter.hasNext()) {
            element = (GuaranteeDetailInfo)iter.next();
            if (element.getBilltype() != GuanTypeBillEnum.AssureBill || element.getBillId() == null || RevokeStatusEnum.revoked.equals((Object)element.getRevokeStatus())) continue;
            FinUtils.addBotRelation(ctx, element.getBillId().toString(), info.getId().toString());
        }
        iter = info.getGuaranteeEntrys().iterator();
        while (iter.hasNext()) {
            element = (GuaranteeDetailInfo)iter.next();
            if (element.getBilltype() != GuanTypeBillEnum.wage || element.getBillId() == null || RevokeStatusEnum.revoked.equals((Object)element.getRevokeStatus())) continue;
            FinUtils.addBotRelation(ctx, element.getBillId().toString(), info.getId().toString());
        }
    }

    @Override
    protected void returnQuantum(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.submitOrSave(ctx, (LoanContractInfo)model, true);
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanContractInfo info = (LoanContractInfo)model;
        return this.submitOrSave(ctx, info, false);
    }

    @Override
    protected void verify(Context ctx, FinancingBillInfo finBill) throws BOSException, EASBizException {
        LoanContractInfo info = (LoanContractInfo)finBill;
        if (info.isIsBondsContract()) {
            this.checkBondsContract(ctx, info);
        } else {
            this.checkloanContract(ctx, info);
        }
        super.verify(ctx, finBill);
    }

    private void checkBondsContract(Context ctx, LoanContractInfo info) throws BOSException, EASBizException {
        if (!GuaranteeTypeInputModeEnum.notassure.equals((Object)info.getGuaranteeTypeInputMode()) && EmptyUtil.isEmpty((CoreBaseInfo)info.getGaranteeType())) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"126_LoanContractControllerBean", (Locale)ctx.getLocale())});
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getCompany())) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"127_LoanContractControllerBean", (Locale)ctx.getLocale())});
        }
        if (EmptyUtil.isEmpty((String)info.getContractNum())) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"128_LoanContractControllerBean", (Locale)ctx.getLocale())});
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getType())) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"129_LoanContractControllerBean", (Locale)ctx.getLocale())});
        }
        if (EmptyUtil.isEmpty((Object)info.getPlanIssuanceAmt()) || info.getPlanIssuanceAmt().compareTo(Constants.ZERO) <= 0) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"130_LoanContractControllerBean", (Locale)ctx.getLocale())});
        }
        if (EmptyUtil.isEmpty((Object)info.getAmount()) || info.getAmount().compareTo(Constants.ZERO) <= 0) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"131_LoanContractControllerBean", (Locale)ctx.getLocale())});
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getMarketPlace())) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"132_LoanContractControllerBean", (Locale)ctx.getLocale())});
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getPayIntMode())) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"133_LoanContractControllerBean", (Locale)ctx.getLocale())});
        }
        if (EmptyUtil.isEmpty((Object)info.getYieldRate())) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"134_LoanContractControllerBean", (Locale)ctx.getLocale())});
        }
        if (EmptyUtil.isEmpty((Object)info.getYearDays())) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"135_LoanContractControllerBean", (Locale)ctx.getLocale())});
        }
    }

    private void checkloanContract(Context ctx, LoanContractInfo info) throws BOSException, EASBizException {
        if (!GuaranteeTypeInputModeEnum.notassure.equals((Object)info.getGuaranteeTypeInputMode()) && EmptyUtil.isEmpty((CoreBaseInfo)info.getGaranteeType())) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"126_LoanContractControllerBean", (Locale)ctx.getLocale())});
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getCompany())) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"127_LoanContractControllerBean", (Locale)ctx.getLocale())});
        }
        if (EmptyUtil.isEmpty((String)info.getContractNum())) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"128_LoanContractControllerBean", (Locale)ctx.getLocale())});
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getPayIntMode())) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"133_LoanContractControllerBean", (Locale)ctx.getLocale())});
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getIntRateType())) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"136_LoanContractControllerBean", (Locale)ctx.getLocale())});
        }
        if (EmptyUtil.isEmpty((Object)info.getYieldRate())) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"137_LoanContractControllerBean", (Locale)ctx.getLocale())});
        }
        if (EmptyUtil.isEmpty((Object)info.getYearDays())) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"135_LoanContractControllerBean", (Locale)ctx.getLocale())});
        }
        if (EmptyUtil.isEmpty((Object)info.getAmount()) || info.getAmount().compareTo(Constants.ZERO) <= 0) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"138_LoanContractControllerBean", (Locale)ctx.getLocale())});
        }
    }

    protected IObjectPK submitOrSave(Context ctx, LoanContractInfo loanContractInfo, boolean isSubmit) throws EASBizException, BOSException {
        IObjectPK pk = null;
        if (isSubmit) {
            if (loanContractInfo.getStatus().equals((Object)LoanContractEnum.CLOSED)) {
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"139_LoanContractControllerBean", (Locale)ctx.getLocale())});
            }
            if (!loanContractInfo.getStatus().equals((Object)LoanContractEnum.AUDITED) && !loanContractInfo.getStatus().equals((Object)LoanContractEnum.CLOSED)) {
                loanContractInfo.setStatus(LoanContractEnum.SUBMIT);
            }
            pk = super._submit(ctx, (IObjectValue)loanContractInfo);
        } else {
            if (loanContractInfo.getStatus().equals((Object)LoanContractEnum.CLOSED)) {
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"140_LoanContractControllerBean", (Locale)ctx.getLocale())});
            }
            if (!(loanContractInfo.getStatus().equals((Object)LoanContractEnum.AUDITED) || loanContractInfo.getStatus().equals((Object)LoanContractEnum.SUBMIT) || loanContractInfo.getStatus().equals((Object)LoanContractEnum.CLOSED))) {
                loanContractInfo.setStatus(LoanContractEnum.SAVE);
            }
            pk = super._save(ctx, (IObjectValue)loanContractInfo);
        }
        return pk;
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanContractInfo info = this.getLoanContractInfo(ctx, pk);
        if (info.getStatus() == LoanContractEnum.SAVE || info.getStatus() == LoanContractEnum.AUDITED) {
            if (info.isIsBondsContract()) {
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"141_LoanContractControllerBean", (Locale)ctx.getLocale())});
            }
            throw new LoanException(LoanException.AUDIT_BILL_ERROR, new Object[]{info.getNumber()});
        }
        UserInfo currentUser = (UserInfo)ctx.get((Object)"UserInfo");
        String sql = "update T_FIN_LoanContract set FStatus = ?, FAuditorID = ? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(2), currentUser.getId().toString(), pk.toString()});
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanContractInfo info = this.getLoanContractInfo(ctx, pk);
        if (info.getStatus() == LoanContractEnum.SAVE || info.getStatus() == LoanContractEnum.SUBMIT) {
            if (info.isIsBondsContract()) {
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"142_LoanContractControllerBean", (Locale)ctx.getLocale())});
            }
            throw new LoanException(LoanException.ANTIAUDIT_BILL_ERROR, new Object[]{info.getNumber()});
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)info.getId().toString()));
        view.setFilter(filter);
        LoanCollection col = LoanFactory.getLocalInstance(ctx).getLoanCollection(view);
        if (col.size() > 0) {
            if (info.isIsBondsContract()) {
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"111_BondsContractFacadeControllerBean", (Locale)ctx.getLocale())});
            }
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"143_LoanContractControllerBean", (Locale)ctx.getLocale())});
        }
        String sql = "update T_FIN_LoanContract set FStatus = ?, FAuditorID = null  where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(0), pk.toString()});
    }

    @Override
    protected ArrayList _batchAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        ArrayList<FinBillResult> reslts = new ArrayList<FinBillResult>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idSet), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getSelectors());
        LoanContractCollection col = LoanContractFactory.getLocalInstance(ctx).getLoanContractCollection(view);
        for (int i = 0; i < col.size(); ++i) {
            LoanContractInfo loanInfo = col.get(i);
            FinBillResult resultInfo = new FinBillResult(loanInfo.getId().toString(), loanInfo.getNumber(), "");
            try {
                LoanContractFactory.getLocalInstance(ctx).audit((IObjectPK)new ObjectUuidPK(loanInfo.getId().toString()));
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                resultInfo.setDetailMsg(e.getMessage());
            }
            reslts.add(resultInfo);
        }
        col = null;
        return reslts;
    }

    @Override
    protected ArrayList _batchAntiAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        ArrayList<FinBillResult> reslts = new ArrayList<FinBillResult>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idSet), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getSelectors());
        LoanContractCollection col = LoanContractFactory.getLocalInstance(ctx).getLoanContractCollection(view);
        for (int i = 0; i < col.size(); ++i) {
            LoanContractInfo loanInfo = col.get(i);
            FinBillResult resultInfo = new FinBillResult(loanInfo.getId().toString(), loanInfo.getNumber(), "");
            try {
                LoanContractFactory.getLocalInstance(ctx).antiAudit((IObjectPK)new ObjectUuidPK(loanInfo.getId().toString()));
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                resultInfo.setDetailMsg(e.getMessage());
            }
            reslts.add(resultInfo);
        }
        col = null;
        return reslts;
    }

    @Override
    protected ArrayList _batchSubmit(Context ctx, Set idSet) throws BOSException, EASBizException {
        ArrayList<FinBillResult> reslts = new ArrayList<FinBillResult>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idSet), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getSelectors());
        LoanContractCollection col = LoanContractFactory.getLocalInstance(ctx).getLoanContractCollection(view);
        for (int i = 0; i < col.size(); ++i) {
            LoanContractInfo loanInfo = col.get(i);
            FinBillResult resultInfo = new FinBillResult(loanInfo.getId().toString(), loanInfo.getNumber(), "");
            try {
                LoanContractFactory.getLocalInstance(ctx).submit((CoreBaseInfo)loanInfo);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                resultInfo.setDetailMsg(e.getMessage());
            }
            reslts.add(resultInfo);
        }
        col = null;
        return reslts;
    }

    @Override
    protected void _close(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanContractInfo info = (LoanContractInfo)model;
        if (info.getStatus() != LoanContractEnum.AUDITED) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"112_BondsContractFacadeControllerBean", (Locale)ctx.getLocale())});
        }
        String sql = "update T_FIN_LoanContract set FStatus = ? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(3), info.getId().toString()});
    }

    @Override
    protected void _unClose(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanContractInfo info = (LoanContractInfo)model;
        if (info.getStatus() != LoanContractEnum.CLOSED) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"113_BondsContractFacadeControllerBean", (Locale)ctx.getLocale())});
        }
        String sql = "update T_FIN_LoanContract set FStatus = ? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(2), info.getId().toString()});
    }

    @Override
    protected ArrayList _batchClose(Context ctx, Set idSet) throws BOSException, EASBizException {
        ArrayList<FinBillResult> reslts = new ArrayList<FinBillResult>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idSet), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getSelectors());
        LoanContractCollection col = LoanContractFactory.getLocalInstance(ctx).getLoanContractCollection(view);
        for (int i = 0; i < col.size(); ++i) {
            LoanContractInfo loanInfo = col.get(i);
            FinBillResult resultInfo = new FinBillResult(loanInfo.getId().toString(), loanInfo.getNumber(), "");
            try {
                LoanContractFactory.getLocalInstance(ctx).close(loanInfo);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                resultInfo.setDetailMsg(e.getMessage());
            }
            reslts.add(resultInfo);
        }
        col = null;
        return reslts;
    }

    @Override
    protected ArrayList _batchUnClose(Context ctx, Set idSet) throws BOSException, EASBizException {
        ArrayList<FinBillResult> reslts = new ArrayList<FinBillResult>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idSet), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getSelectors());
        LoanContractCollection col = LoanContractFactory.getLocalInstance(ctx).getLoanContractCollection(view);
        for (int i = 0; i < col.size(); ++i) {
            LoanContractInfo loanInfo = col.get(i);
            FinBillResult resultInfo = new FinBillResult(loanInfo.getId().toString(), loanInfo.getNumber(), "");
            try {
                LoanContractFactory.getLocalInstance(ctx).unClose(loanInfo);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                resultInfo.setDetailMsg(e.getMessage());
            }
            reslts.add(resultInfo);
        }
        col = null;
        return reslts;
    }

    @Override
    protected void _updateHisData(Context ctx) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.name"));
        filter.getFilterItems().add(new FilterItemInfo("seqMulCon", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("hasUpdated", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("loanContractId", null, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", null, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("loanApplyBill.id", null, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isBondsContract", (Object)Boolean.FALSE, CompareType.EQUALS));
        filter.setMaskString("#0 AND #1 AND #2 AND(#3 OR #4)");
        view.setFilter(filter);
        view.setSelector(sic);
        LoanCollection col = LoanFactory.getLocalInstance(ctx).getLoanCollection(view);
        CoreBaseCollection batchUpdateData = new CoreBaseCollection();
        CoreBaseCollection batchAddnewData = new CoreBaseCollection();
        Timestamp time = new Timestamp(Calendar.getInstance().getTimeInMillis());
        for (int i = 0; i < col.size(); ++i) {
            LoanInfo loanInfo = col.get(i);
            LoanContractInfo info = new LoanContractInfo();
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            info.setCompany(loanInfo.getCompany());
            if (!FMHelper.hasNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString())) {
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{info.getCompany().getName() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"144_LoanContractControllerBean", (Locale)ctx.getLocale())});
            }
            info.setNumber(FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString()));
            info.setStatus(LoanContractEnum.SUBMIT);
            info.setContractNum(loanInfo.getContractNum());
            info.setBizDate(loanInfo.getBizDate());
            info.setIsGroupLoan(loanInfo.isIsGroupLoan());
            info.setIsBankLoan(loanInfo.isIsBankLoan());
            info.setType(loanInfo.getType());
            info.setInstitution(loanInfo.getInstitution());
            info.setCurrency(loanInfo.getCurrency());
            info.setLocalCurExRate(loanInfo.getLocalCurExRate());
            info.setAmount(loanInfo.getAmount());
            info.setAmountLocalCur(loanInfo.getAmountLocalCur());
            info.setIssueDate(loanInfo.getIssueDate());
            info.setExpiredDate(loanInfo.getExpiredDate());
            info.setBankAcct(loanInfo.getBankAcct());
            info.setGuaranteeTypeInputMode(loanInfo.getGuaranteeTypeInputMode());
            info.setGaranteeType(loanInfo.getGaranteeType());
            info.setHistoryBill(loanInfo.isHistoryBill());
            info.setIsLoanAndRepay(loanInfo.isIsLoanAndRepay());
            info.setDescription(loanInfo.getDescription());
            info.setPayIntMode(loanInfo.getPayIntMode());
            info.setIntRateType(loanInfo.getIntRateType());
            info.setFloatAction(loanInfo.getFloatAction());
            info.setBasePoints(loanInfo.getBasePoints());
            info.setRateAdjustPeriod(loanInfo.getRateAdjustPeriod());
            info.setYieldRate(loanInfo.getYieldRate());
            info.setIntRateTypeExpression(loanInfo.getIntRateTypeExpression());
            info.setYearDays(loanInfo.getYearDays());
            info.setIsInCredit(loanInfo.isIsInCredit());
            info.setIsRelBankInCredit(loanInfo.isIsRelBankInCredit());
            info.setCreditLimit(loanInfo.getCreditLimit());
            info.setCreditCurrency(loanInfo.getCreditCurrency());
            info.setCreditCurExRate(loanInfo.getCreditCurExRate());
            info.setCreditLocalAmt(loanInfo.getCreditLocalAmt());
            for (int t = 0; t < loanInfo.getGuaranteeEntrys().size(); ++t) {
                GuaranteeDetailInfo entry = loanInfo.getGuaranteeEntrys().get(t);
                entry.setId(BOSUuid.create((BOSObjectType)entry.getBOSType()));
                entry.setParentBillType(BillTypeEnum.LOANCONTRACT);
                info.getGuaranteeEntrys().add(entry);
            }
            info.setCreateTime(time);
            info.setCreator(loanInfo.getCreator());
            info.setLastUpdateTime(time);
            info.setLastUpdateUser(loanInfo.getCreator());
            info.setAuditor(loanInfo.getAuditor());
            batchAddnewData.add((CoreBaseInfo)info);
            LoanInfo updateInfo = new LoanInfo();
            updateInfo.setId(loanInfo.getId());
            updateInfo.setHasUpdated(true);
            updateInfo.setLoanContractId(info.getId().toString());
            batchUpdateData.add((CoreBaseInfo)updateInfo);
        }
        LoanContractFactory.getLocalInstance(ctx).saveBatchData(batchAddnewData);
        LoanFactory.getLocalInstance(ctx).updateBatchData(batchUpdateData);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanContractInfo info = (LoanContractInfo)this.getValue(ctx, pk);
        if (!info.getStatus().equals((Object)LoanContractEnum.SAVE) && !info.getStatus().equals((Object)LoanContractEnum.SUBMIT)) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"145_LoanContractControllerBean", (Locale)ctx.getLocale())});
        }
        super._delete(ctx, pk);
        if (FMHelper.isInstanceof((String)info.getSourceBillId(), LoanApplyBillInfo.class)) {
            LoanApplyBillFacadeFactory.getLocalInstance(ctx).afterLoanBillDeleted((IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
        }
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }
}

