/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillInfo;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.ctl.BankFactorFactory;
import com.kingdee.eas.fm.ctl.BankFactorInfo;
import com.kingdee.eas.fm.ctl.IBankFactor;
import com.kingdee.eas.fm.fin.FinBillStatusEnum;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.GuaranteeDetailInfo;
import com.kingdee.eas.fm.fin.GuaranteeTypePropertyEnum;
import com.kingdee.eas.fm.fin.LoanApplyBillFacadeFactory;
import com.kingdee.eas.fm.fin.LoanApplyBillInfo;
import com.kingdee.eas.fm.fin.LoanCollection;
import com.kingdee.eas.fm.fin.LoanContractActLoanSituationInfo;
import com.kingdee.eas.fm.fin.LoanContractFactory;
import com.kingdee.eas.fm.fin.LoanContractInfo;
import com.kingdee.eas.fm.fin.LoanEntryCollection;
import com.kingdee.eas.fm.fin.LoanEntryInfo;
import com.kingdee.eas.fm.fin.LoanException;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanForecastedBlockingFlowGenerator;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.LoanInterestCollection;
import com.kingdee.eas.fm.fin.LoanInterestFactory;
import com.kingdee.eas.fm.fin.LoanInterestInfo;
import com.kingdee.eas.fm.fin.LoanInterestPredictionFacadeFactory;
import com.kingdee.eas.fm.fin.MainConLoanFactory;
import com.kingdee.eas.fm.fin.MainConLoanInfo;
import com.kingdee.eas.fm.fin.MortgageTypeEnum;
import com.kingdee.eas.fm.fin.RepayIntTypeEnum;
import com.kingdee.eas.fm.fin.RepaymentCollection;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.app.AbstractLoanControllerBean;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.ft.FundTransferBillFactory;
import com.kingdee.eas.fm.ft.FundTransferBillInfo;
import com.kingdee.eas.fm.ivt.ChLoanInfo;
import com.kingdee.eas.fm.mnt.BlockingFlowTypeCollection;
import com.kingdee.eas.fm.mnt.BlockingFlowTypeFactory;
import com.kingdee.eas.fm.mnt.BlockingFlowTypeInfo;
import com.kingdee.eas.fm.mnt.ForecastedBlockingFlowFactory;
import com.kingdee.eas.fm.nt.LetterOfCreditReceiveInfo;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class LoanControllerBean
extends AbstractLoanControllerBean {
    private static final String RESOURCE = "com.kingdee.eas.fm.fin.FinResource";
    protected LoanInfo oldLoanInfo;

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanInfo info = (LoanInfo)model;
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)info);
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)info);
        if (info.getSourceBillId() != null) {
            FMBGHelper.reverseLoanExt((Context)ctx, (String)info.getSourceBillId(), (String)"1");
        }
        this.updateConsignmentLoanBill(ctx, info, true);
        return this.submitOrSave(ctx, (LoanInfo)model, true);
    }

    private void batchSubmitIntColl(Context ctx, LoanInfo loanInfo, IObjectPK pk, boolean isSubmit) throws EASBizException, BOSException {
        LoanInterestCollection newIntColl = loanInfo.getIntCollPrediction();
        if (newIntColl != null && newIntColl.size() > 0) {
            for (int i = 0; i < newIntColl.size(); ++i) {
                LoanInterestInfo intInfo = newIntColl.get(i);
                intInfo.setLoan(loanInfo);
            }
        }
        if (isSubmit) {
            LoanInterestPredictionFacadeFactory.getLocalInstance(ctx).submit(loanInfo.getId().toString(), newIntColl);
        } else if (newIntColl != null && newIntColl.size() > 0) {
            LoanInterestPredictionFacadeFactory.getLocalInstance(ctx).save(loanInfo.getId().toString(), newIntColl);
        }
    }

    private void updateCHLoan(Context ctx, String id, boolean isDelete, IObjectPK pk) throws BOSException {
        String sql = "";
        if (isDelete) {
            sql = " update T_IVT_CHLoan set FIsDownLoaded = 0 where fid = ? ";
        } else {
            HashMap<String, String> relation = new HashMap<String, String>();
            relation.put(id, pk.toString());
            FMHelper.saveBOTRelation((Context)ctx, relation);
            sql = " update T_IVT_CHLoan set FIsDownLoaded = 1 where fid = ? ";
        }
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{id});
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanInfo loanInfo = this.getLoanInfo(ctx, pk);
        this.deleteCheck(ctx, loanInfo);
        ForecastedBlockingFlowFactory.getLocalInstance((Context)ctx).deleteForecastedBlockingFlow(BOSUuid.read((String)pk.toString()));
        loanInfo.setIntCollPrediction(this.getIntCollPrediction(ctx, loanInfo.getId().toString()));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isPrediction", (Object)new Boolean(true)));
        filter.getFilterItems().add(new FilterItemInfo("loan.id", (Object)loanInfo.getId().toString()));
        LoanInterestFactory.getLocalInstance(ctx).delete(filter);
        this.updateBankFactorForDel(ctx, loanInfo);
        FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)pk);
        super._delete(ctx, pk);
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
        ChLoanInfo chLoanInfo = loanInfo.getEntLoanID();
        if (chLoanInfo != null) {
            this.updateCHLoan(ctx, chLoanInfo.getId().toString(), true, pk);
        }
        this.reverseSaveLoanContract(ctx, loanInfo, BOTBillOperStateEnum.DELETE, false);
        if (loanInfo.getSeqMulCon() != 1 && loanInfo.getMainConLoan() != null && loanInfo.getMainConLoan().getId() != null) {
            String sql1 = " update T_FIN_MainConLoan set FAddConAmount = FAddConAmount-?  where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql1, (Object[])new Object[]{loanInfo.getAmount(), loanInfo.getMainConLoan().getId().toString()});
            String sql2 = " update T_FIN_MainConLoan set FRemainConAmount = FRemainConAmount+?  where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{loanInfo.getAmount(), loanInfo.getMainConLoan().getId().toString()});
        } else if (loanInfo.getMainConLoan() != null && loanInfo.getMainConLoan().getId() != null) {
            String sql = " delete from T_FIN_MainConLoan where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{loanInfo.getMainConLoan().getId().toString()});
        }
        NumberRuleUtil.recycleNumber((Context)ctx, (CoreBaseInfo)loanInfo, (String)loanInfo.getCompany().getId().toString());
        this.restoreLoanApplyOnWay(ctx, loanInfo);
        if (loanInfo.getLoanApplyBill() != null) {
            LoanApplyBillFacadeFactory.getLocalInstance(ctx).afterLoanBillDeleted((IObjectPK)new ObjectUuidPK(loanInfo.getLoanApplyBill().getId()));
        }
        if (loanInfo.getTransBill() != null) {
            this.updateFundTransfer(ctx, loanInfo.getTransBill().getId().toString(), false);
        }
        this.updatePayablebill(ctx, loanInfo, false);
        this.updateConsignmentLoanBill(ctx, loanInfo, false);
        if (loanInfo.getSourceBillId() != null) {
            FMBGHelper.reverseLoanExt((Context)ctx, (String)loanInfo.getSourceBillId(), (String)"0");
        }
        this.updateLetterOfCreditReceive(ctx, loanInfo.getSourceBillId(), loanInfo, true);
    }

    protected void updateLetterOfCreditReceive(Context ctx, String srcId, LoanInfo info, boolean isDelete) throws BOSException {
        if (!EmptyUtil.isEmpty((String)srcId)) {
            if (FMHelper.isInstanceof((String)srcId, LetterOfCreditReceiveInfo.class)) {
                String sql = " update T_NT_LetterOfCreditReceive set FIsOutput = ? where fid = ? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Boolean(!isDelete), srcId});
            }
            if (!isDelete) {
                HashMap<String, String> relation = new HashMap<String, String>();
                relation.put(srcId, info.getId().toString());
                BOTPUtil.saveBOTRelation((Context)ctx, relation);
            }
        }
    }

    private void deleteCheck(Context ctx, LoanInfo info) throws EASBizException, BOSException {
        if (info.isIsGenRecBill()) {
            throw new FinBizException(FinBizException.DELETE1, new Object[]{info.getNumber()});
        }
        if (info.getStatus().equals((Object)FinBillStatusEnum.AUDITED)) {
            throw new FinBizException(FinBizException.DELETE2, new Object[]{info.getNumber()});
        }
        if (info.getMainConLoan() != null) {
            int seq = LoanFactory.getLocalInstance(ctx).getSeq((IObjectPK)new ObjectUuidPK(info.getMainConLoan().getId().toString()));
            if (info.getSeqMulCon() != seq) {
                throw new FinBizException(FinBizException.MUSTFLOWSEQ);
            }
        }
        if (info.getCashier() != null) {
            throw new FinBizException(FinBizException.DELETE3, new Object[]{info.getNumber()});
        }
        int adjustSeq = LoanFactory.getLocalInstance(ctx).getAdjust((IObjectPK)new ObjectUuidPK(info.getId().toString()));
        if (adjustSeq > 0) {
            throw new FinBizException(FinBizException.DELETE5, new Object[]{info.getNumber()});
        }
    }

    @Override
    protected void verify(Context ctx, FinancingBillInfo finBill) throws BOSException, EASBizException {
        LoanInfo loan = (LoanInfo)finBill;
        if (loan.isIsBonds()) {
            FMVerifyHelper.checkMustMoreThanZero((Context)ctx, (IObjectValue)finBill, (String)"LocalCurExRate");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)finBill, (String)"Horizon");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)finBill, (String)"BizDate");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)finBill, (String)"Company");
            if (this.isExpiredDateRequired()) {
                FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)finBill, (String)"ExpiredDate");
            }
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)finBill, (String)"IssueDate");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)finBill, (String)"Type");
            if (finBill.isUseAssureBill() && finBill.getAssureBill() == null) {
                throw new FinBizException(FinBizException.USEASSUREBILLMUSTHAVEASSUREBILL);
            }
            FMVerifyHelper.checkNotLessThanZero((Context)ctx, (IObjectValue)finBill, (String)"Balance");
            LoanEntryCollection collection = loan.getEntrys();
            int n = collection.size();
            if (n <= 0) {
                throw new LoanException(LoanException.ENTRY_SIZE_ERROR);
            }
            for (int i = 0; i < n; ++i) {
                LoanEntryInfo entryInfo = loan.getEntrys().get(i);
                FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)entryInfo, (String)"date");
                FMVerifyHelper.checkMustMoreThanZero((Context)ctx, (IObjectValue)entryInfo, (String)"amount");
                Date date = entryInfo.getDate();
                if (!date.before(loan.getIssueDate())) continue;
                throw new LoanException(LoanException.ENTRY_DATE_ERROR);
            }
        } else {
            super.verify(ctx, finBill);
            if (loan.isHistoryBill()) {
                FMVerifyHelper.checkNotLessThanZero((Context)ctx, (IObjectValue)finBill, (String)"Balance");
            } else {
                FMVerifyHelper.checkMustMoreThanZero((Context)ctx, (IObjectValue)finBill, (String)"Balance");
            }
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)finBill, (String)"CreditorGroup");
            if (loan.isIsGroupLoan()) {
                FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)finBill, (String)"GroupID");
            } else {
                FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)loan, (String)"Institution");
            }
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)finBill, (String)"RepaymentType");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)finBill, (String)"BasePoints");
            LoanEntryCollection collection = loan.getEntrys();
            int n = collection.size();
            if (n <= 0) {
                throw new LoanException(LoanException.ENTRY_SIZE_ERROR);
            }
            for (int i = 0; i < n; ++i) {
                LoanEntryInfo entryInfo = loan.getEntrys().get(i);
                FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)entryInfo, (String)"date");
                FMVerifyHelper.checkMustMoreThanZero((Context)ctx, (IObjectValue)entryInfo, (String)"amount");
                Date date = entryInfo.getDate();
                if (!date.before(loan.getIssueDate())) continue;
                throw new LoanException(LoanException.ENTRY_DATE_ERROR);
            }
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)((BillBaseInfo)model), (AbstractCoreBaseControllerBean)this);
        LoanInfo info = (LoanInfo)model;
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)info);
        info.setIsGenRecBill(false);
        boolean FIN023 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("FIN023", (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()));
        if (FIN023 && !info.isIsUpRepayRecord()) {
            info.setIsUpRepayRecord(true);
        }
        info.setBizDate(DateTimeUtils.truncateDate((Date)info.getBizDate()));
        IObjectPK pk = super._addnew(ctx, model);
        info = this.getLoanInfo(ctx, pk);
        this.updateBankFactorForAdd(ctx, info);
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        boolean exist = codingRuleManager.isExist((IObjectValue)info, info.getCompany().getId().toString());
        if (exist && codingRuleManager.isAddView((IObjectValue)info, info.getCompany().getId().toString()) && !codingRuleManager.isUseIntermitNumber((IObjectValue)info, info.getCompany().getId().toString())) {
            codingRuleManager.getNumber((IObjectValue)info, info.getCompany().getId().toString());
        }
        return pk;
    }

    protected void afterAddNew(Context ctx, IObjectPK returnPK, IObjectValue model) throws EASBizException, BOSException {
        super.afterAddNew(ctx, returnPK, model);
        this.updateLoanApplyBill(ctx, (LoanInfo)model);
        this.updateFundTransferBill(ctx, (LoanInfo)model);
        this.updateConsignmentLoanBill(ctx, (LoanInfo)model, true);
    }

    protected void updateConsignmentLoanBill(Context ctx, LoanInfo info, boolean isCreateToLoan) throws BOSException, EASBizException {
        String sourceBillId = info.getSourceBillId();
        if (sourceBillId == null || "".equals(sourceBillId.trim())) {
            return;
        }
        BOSObjectType bosType = BOSUuid.read((String)sourceBillId).getType();
        if (bosType.equals((Object)new ConsignmentLoanBillInfo().getBOSType())) {
            String updateSQl = "update T_CL_ConsignmentLoanBill set FIsCreateToLoan = ? where fid = ?";
            DbUtil.execute((Context)ctx, (String)updateSQl, (Object[])new Object[]{isCreateToLoan, sourceBillId});
        }
    }

    protected void checkBeforeAddNew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super.checkBeforeAddNew(ctx, model);
        LoanInfo info = (LoanInfo)model;
        if (info.getBalance().compareTo(SysConstant.BIGZERO) == 0 && !info.isHistoryBill()) {
            throw new FinBizException(FinBizException.BALANCEISZERO);
        }
    }

    private void updateFundTransferBill(Context ctx, LoanInfo info) throws BOSException, EASBizException {
        if (info.getTransBill() != null) {
            HashMap<String, String> botpRelationShip = new HashMap<String, String>();
            String srcID_fundTransferBill = info.getTransBill().getId().toString();
            botpRelationShip.put(srcID_fundTransferBill, info.getId().toString());
            FMHelper.saveBOTRelation((Context)ctx, botpRelationShip);
            this.updateFundTransfer(ctx, srcID_fundTransferBill, true);
        }
    }

    private void updateFundTransfer(Context ctx, String srcID_fundTransferBill, boolean isAdd) throws BOSException, EASBizException {
        String updateSQl = "update T_FT_FundTransferBill set fisGenLoan = ? where fid = ?";
        DbUtil.execute((Context)ctx, (String)updateSQl, (Object[])new Object[]{isAdd, srcID_fundTransferBill});
        this.updateLoanApplyWithFundTransfer(ctx, srcID_fundTransferBill, isAdd);
    }

    private void updateLoanApplyWithFundTransfer(Context ctx, String srcID_fundTransferBill, boolean isAdd) throws BOSException, EASBizException {
        FundTransferBillInfo fundTransferBillInfo = FundTransferBillFactory.getLocalInstance((Context)ctx).getFundTransferBillInfo((IObjectPK)new ObjectUuidPK(srcID_fundTransferBill));
        LoanApplyBillInfo loanApplyBillInfo = fundTransferBillInfo.getLoanApplyBill();
        if (!FMHelper.isEmpty((CoreBaseInfo)loanApplyBillInfo)) {
            String sql = "update T_FIN_LoanApplyBill set FIsGenLoanBill = ? where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{isAdd, loanApplyBillInfo.getId().toString()});
        }
    }

    private void updateLoanApplyBill(Context ctx, LoanInfo info) throws BOSException, EASBizException {
        if (info.getLoanApplyBill() != null) {
            LoanApplyBillFacadeFactory.getLocalInstance(ctx).afterGenLoanBill((IObjectPK)new ObjectUuidPK(info.getLoanApplyBill().getId()));
            LoanApplyBillFacadeFactory.getLocalInstance(ctx).saveBOTPRelations(info.getLoanApplyBill().getId().toString(), info.getId().toString());
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("guaranteeEntrys.*");
        LoanInfo loanInfo = (LoanInfo)this._getValue(ctx, pk, sic);
        if (!loanInfo.isIsInCredit()) {
            loanInfo.setUsedQuota(Constants.ZERO);
            loanInfo.setCreditCurExRate(Constants.ZERO);
            loanInfo.setCreditCurrency(null);
        }
        this.updateBankFactorForDel(ctx, loanInfo);
        super._update(ctx, pk, model);
        loanInfo = (LoanInfo)model;
        this.updateBankFactorForAdd(ctx, loanInfo);
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        LoanInfo info = (LoanInfo)srcBillVO;
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccountant(null);
                info.setFiVouchered(false);
                info.setVoucherNumber(null);
                info.setVoucherType(null);
            } else {
                info.setAccountant(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                info.setFiVouchered(true);
                String voucherID = relation.getDestObjectID();
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(voucherID));
                info.setVoucherNumber(voucherInfo.getNumber());
                info.setVoucherType(voucherInfo.getVoucherType());
            }
        }
        super.updateOnlyModel(ctx, srcBillPK, srcBillVO);
    }

    @Override
    protected String _transOverDueBatch(Context ctx, Set ids) throws BOSException, EASBizException {
        boolean success = true;
        Iterator iter = ids.iterator();
        String billid = "";
        HashMap hm = new HashMap();
        while (iter.hasNext()) {
            billid = (String)iter.next();
            if (!this.doCheckOverDue(ctx, billid, hm)) continue;
            this.doUpdate(ctx, billid, 1);
        }
        return this.getErrorMsg(ctx, hm, 1);
    }

    @Override
    protected String _cancelOverDueBatch(Context ctx, Set ids) throws BOSException, EASBizException {
        Iterator iter = ids.iterator();
        HashMap hm = new HashMap();
        while (iter.hasNext()) {
            String billid = (String)iter.next();
            if (!this.checkCancelOverDue(ctx, billid, hm)) continue;
            this.doUpdate(ctx, billid, 0);
        }
        return this.getErrorMsg(ctx, hm, 2);
    }

    private void doUpdate(Context ctx, String billid, int i) throws BOSException {
        String sql = "update T_FIN_Loan set FIsOverdue = ? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(i), billid});
    }

    private boolean checkCancelOverDue(Context ctx, String id, Map map) throws BOSException, EASBizException {
        boolean success = true;
        LoanInfo loanInfo = this.getLoanInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        if (!loanInfo.isIsOverdue()) {
            map.put(loanInfo.getNumber(), ResourceBase.getString((String)RESOURCE, (String)"BillNotOverDue", (Locale)ctx.getLocale()));
            return false;
        }
        return success;
    }

    private String getErrorMsg(Context ctx, Map map, int type) {
        StringBuffer sbError = new StringBuffer();
        for (String number : map.keySet()) {
            String msg = (String)map.get(number);
            if (1 == type) {
                sbError.append(number).append(ResourceBase.getString((String)RESOURCE, (String)"OverDueFailedReason", (Locale)ctx.getLocale())).append(msg).append("\n");
                continue;
            }
            sbError.append(number).append(ResourceBase.getString((String)RESOURCE, (String)"CancelOverDueFailedReason", (Locale)ctx.getLocale())).append(msg).append("\n");
        }
        return sbError.toString().trim();
    }

    private boolean doCheckOverDue(Context ctx, String id, Map map) throws BOSException, EASBizException {
        boolean success = true;
        LoanInfo loanInfo = this.getLoanInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        if (loanInfo.isIsOverdue()) {
            map.put(loanInfo.getNumber(), ResourceBase.getString((String)RESOURCE, (String)"BillHasTurnOverDue", (Locale)ctx.getLocale()));
            success = false;
        } else if (loanInfo.getBalance().compareTo(Constants.ZERO) <= 0) {
            map.put(loanInfo.getNumber(), ResourceBase.getString((String)RESOURCE, (String)"AmountZeroCanTOverduo", (Locale)ctx.getLocale()));
            success = false;
        } else if (loanInfo.getExpiredDate().compareTo(DateUtil.getDayBegin()) > 0) {
            map.put(loanInfo.getNumber(), ResourceBase.getString((String)RESOURCE, (String)"BillHasNotOverDuo", (Locale)ctx.getLocale()));
            success = false;
        }
        return success;
    }

    @Override
    protected int _getSeq(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        int seq = 0;
        String sql = "select isnull(max(FSeqMulCon),0) FSeqMulCon from T_FIN_Loan where FMainConLoanID = ?  ";
        Connection cn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            cn = this.getConnection(ctx);
            pstmt = cn.prepareStatement(sql);
            pstmt.setString(1, pk.toString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                seq = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
        return seq;
    }

    @Override
    protected LoanInfo _getFirstLoanInMul(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String id = "";
        String sql = " select fid from T_FIN_Loan where FMainConLoanID = ?";
        Connection cn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            cn = this.getConnection(ctx);
            pstmt = cn.prepareStatement(sql);
            pstmt.setString(1, pk.toString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                id = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
        return this.getLoanInfo(ctx, (IObjectPK)new ObjectUuidPK(id), this.getSelectors());
    }

    @Override
    protected boolean _isEditConAmount(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection cn;
        boolean isEdit;
        block9: {
            String sql2;
            block8: {
                isEdit = false;
                String sql0 = "select FMainConLoanID from T_Fin_loan where fid = ?";
                String sql1 = " select max(FSeqMulCon) from T_Fin_Loan where FMainConLoanID = ?";
                sql2 = " select fid from T_Fin_LoanDefer where FLoanID = ?";
                cn = null;
                pstmt = null;
                rs = null;
                String mainConId = null;
                cn = this.getConnection(ctx);
                pstmt = cn.prepareStatement(sql0);
                pstmt.setString(1, pk.toString());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    mainConId = rs.getString(1);
                }
                pstmt.close();
                rs.close();
                pstmt = cn.prepareStatement(sql1);
                pstmt.setString(1, mainConId);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block8;
                if (rs.getInt(1) == 1) {
                    isEdit = true;
                    break block8;
                }
                boolean bl = isEdit = false;
                SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
                return bl;
            }
            pstmt.close();
            rs.close();
            pstmt = cn.prepareStatement(sql2);
            pstmt.setString(1, pk.toString());
            rs = pstmt.executeQuery();
            if (!rs.next()) break block9;
            boolean bl = isEdit = false;
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
            return bl;
        }
        try {
            isEdit = true;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
        return isEdit;
    }

    @Override
    protected int _getAdjust(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sql2 = " select max(FAdjustSeq) from T_FIN_LoanAdjustInterest where floanid = ? ";
        int adjustSeq = 0;
        Connection cn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            cn = this.getConnection(ctx);
            pstmt = cn.prepareStatement(sql2);
            pstmt.setString(1, pk.toString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                adjustSeq = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
        return adjustSeq;
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanInfo info = this.getLoanInfo(ctx, pk);
        if (info.getStatus() == FinBillStatusEnum.SAVE || info.getStatus() == FinBillStatusEnum.AUDITED) {
            throw new LoanException(LoanException.AUDIT_BILL_ERROR, new Object[]{info.getNumber()});
        }
        UserInfo currentUser = (UserInfo)ctx.get((Object)"UserInfo");
        String sql = "update T_FIN_Loan set FStatus = ?, FAuditorID = ? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(3), currentUser.getId().toString(), pk.toString()});
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanInfo info = this.getLoanInfo(ctx, pk);
        if (info.getStatus() == FinBillStatusEnum.SAVE || info.getStatus() == FinBillStatusEnum.SUBMIT) {
            throw new LoanException(LoanException.ANTIAUDIT_BILL_ERROR, new Object[]{info.getNumber()});
        }
        if (!info.isIsBonds()) {
            if (!(FinHelper.hasDeferRecordOfLoan(ctx, info.getId().toString()) && FinHelper.hasIntRecordOfLoan(ctx, info.getId().toString()) && FinHelper.hasRepaymentOfLoan(ctx, info.getId().toString()))) {
                throw new LoanException(LoanException.ANTIAUDIT_HASOTHER_BILL_ERROR, new Object[]{info.getNumber()});
            }
        } else if (!FinHelper.hasIntRecordOfLoan(ctx, info.getId().toString()) || !FinHelper.hasRepaymentOfLoan(ctx, info.getId().toString())) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"146_LoanControllerBean", (Locale)ctx.getLocale())});
        }
        String sql = "update T_FIN_Loan set FStatus = ?, FAuditorID = null  where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(1), pk.toString()});
    }

    @Override
    protected void _batchAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            this.audit(ctx, (IObjectPK)new ObjectUuidPK((String)it.next()));
        }
    }

    @Override
    protected void _batchAntiAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            this.antiAudit(ctx, (IObjectPK)new ObjectUuidPK((String)it.next()));
        }
    }

    @Override
    protected void _setAuditingStatus(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        String sql = "update T_FIN_Loan set FStatus = ? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(3), id.toString()});
    }

    @Override
    protected void _setSubmitedStatus(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        String sql = "update T_FIN_Loan set FStatus = ? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(1), id.toString()});
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.submitOrSave(ctx, (LoanInfo)model, false);
    }

    protected IObjectPK submitOrSave(Context ctx, LoanInfo loanInfo, boolean isSubmit) throws EASBizException, BOSException {
        boolean isAddNew;
        IObjectPK pk = null;
        loanInfo.setIsOverdue(false);
        boolean bl = isAddNew = !this._exists(ctx, (IObjectPK)new ObjectUuidPK(loanInfo.getId()));
        if (!isAddNew) {
            this.oldLoanInfo = this.getLoanInfo(ctx, "select * where id='" + loanInfo.getId() + "'");
        }
        if (isSubmit) {
            if (loanInfo.getStatus() != FinBillStatusEnum.AUDITED) {
                loanInfo.setStatus(FinBillStatusEnum.SUBMIT);
            }
            pk = super._submit(ctx, (IObjectValue)loanInfo);
            LoanInfo bgLoanInfo = this.getLoanInfo(ctx, "select * where id='" + pk.toString() + "'");
            FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)bgLoanInfo);
        } else {
            if (loanInfo.getStatus() != FinBillStatusEnum.AUDITED) {
                loanInfo.setStatus(FinBillStatusEnum.SAVE);
            }
            pk = super._save(ctx, (IObjectValue)loanInfo);
        }
        if (!loanInfo.isIsBonds()) {
            ForecastedBlockingFlowFactory.getLocalInstance((Context)ctx).genForecastedBlockingFlow(BOSUuid.read((String)pk.toString()), LoanForecastedBlockingFlowGenerator.class.getName());
            ChLoanInfo chLoanInfo = loanInfo.getEntLoanID();
            if (chLoanInfo != null) {
                this.updateCHLoan(ctx, chLoanInfo.getId().toString(), false, pk);
            }
            this.updatePayablebill(ctx, loanInfo, true);
            this.updateLetterOfCreditReceive(ctx, loanInfo.getSourceBillId(), loanInfo, false);
        }
        this.updateMainConLoan(ctx, loanInfo, pk);
        FmMbgHelper.requestBudget((Context)ctx, (IObjectPK)pk);
        this.returnLoanApplyOnWay(ctx, loanInfo);
        this.batchSubmitIntColl(ctx, loanInfo, pk, isSubmit);
        this.reverseSaveLoanContract(ctx, loanInfo, BOTBillOperStateEnum.ADDNEW, isAddNew);
        return pk;
    }

    private void reverseSaveLoanContract(Context ctx, LoanInfo loanInfo, BOTBillOperStateEnum bOTBillOperStateEnum, boolean isAddNew) throws BOSException, EASBizException {
        if (FMHelper.isInstanceof((String)loanInfo.getSourceBillId(), LoanContractInfo.class)) {
            LoanContractInfo loanContractInfo = LoanContractFactory.getLocalInstance(ctx).getLoanContractInfo((IObjectPK)new ObjectUuidPK(loanInfo.getSourceBillId().toString()));
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)loanInfo.getSourceBillId().toString()));
            view.setFilter(filter);
            LoanCollection loanCol = LoanFactory.getLocalInstance(ctx).getLoanCollection(view);
            for (int i = 0; i < loanCol.size(); ++i) {
                loanCol.get(i).setIntCollPrediction(this.getIntCollPrediction(ctx, loanCol.get(i).getId().toString()));
            }
            this.fillLoanContractOverView(ctx, loanContractInfo, loanInfo, loanCol, bOTBillOperStateEnum);
            this.fillLoanContractActLoanSituation(ctx, loanContractInfo, loanInfo, bOTBillOperStateEnum, isAddNew);
            LoanContractFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(loanContractInfo.getId().toString()), (CoreBaseInfo)loanContractInfo);
        }
    }

    private void fillLoanContractOverView(Context ctx, LoanContractInfo info, LoanInfo loanInfo, LoanCollection loanCol, BOTBillOperStateEnum bOTBillOperStateEnum) throws BOSException, EASBizException {
        if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
            BigDecimal paidAmount = Constants.ZERO;
            BigDecimal historyPaidAmount = Constants.ZERO;
            for (int i = 0; i < loanCol.size(); ++i) {
                paidAmount = paidAmount.add(loanCol.get(i).getAmount());
            }
            if (info.isHistoryBill() && !EmptyUtil.isEmpty((AbstractObjectCollection)info.getLoanContractOverView()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getLoanContractOverView().get(1))) {
                historyPaidAmount = info.getLoanContractOverView().get(1).getPaidAmount();
                paidAmount = paidAmount.add(historyPaidAmount);
            }
            info.getLoanContractOverView().get(0).setPaidAmount(paidAmount.subtract(historyPaidAmount));
            info.setConAddAmount(paidAmount);
            info.setConRemainAmount(info.getAmount().subtract(paidAmount));
            BigDecimal repayedLocalAmt = info.getLoanContractOverView().get(0).getRepayedLocalAmt() == null ? Constants.ZERO : info.getLoanContractOverView().get(0).getRepayedLocalAmt();
            info.getLoanContractOverView().get(0).setUnRepayedLocalAmt(paidAmount.subtract(historyPaidAmount).subtract(repayedLocalAmt));
            LoanInterestCollection interstCol = loanInfo.getIntCollPrediction() == null ? new LoanInterestCollection() : loanInfo.getIntCollPrediction();
            BigDecimal allPreInterestAmt = info.getLoanContractOverView().get(0).getPreInterestUnPaidAmt() == null ? Constants.ZERO : info.getLoanContractOverView().get(0).getPreInterestUnPaidAmt();
            BigDecimal preInterestAmt = new BigDecimal(0);
            for (int i = 0; i < interstCol.size(); ++i) {
                preInterestAmt = preInterestAmt.add(interstCol.get(i).getInterest());
            }
            allPreInterestAmt = allPreInterestAmt.subtract(preInterestAmt);
            info.getLoanContractOverView().get(0).setPreInterestAmt(allPreInterestAmt);
            BigDecimal allPaidInterest = info.getLoanContractOverView().get(0).getPaidInterest() == null ? Constants.ZERO : info.getLoanContractOverView().get(0).getPaidInterest();
            info.getLoanContractOverView().get(0).setPreInterestUnPaidAmt(allPreInterestAmt.subtract(allPaidInterest));
        } else {
            BigDecimal paidAmount = Constants.ZERO;
            BigDecimal historyPaidAmount = Constants.ZERO;
            for (int i = 0; i < loanCol.size(); ++i) {
                paidAmount = paidAmount.add(loanCol.get(i).getAmount());
            }
            if (info.isHistoryBill() && !EmptyUtil.isEmpty((AbstractObjectCollection)info.getLoanContractOverView()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getLoanContractOverView().get(1))) {
                historyPaidAmount = info.getLoanContractOverView().get(1).getPaidAmount();
                paidAmount = paidAmount.add(historyPaidAmount);
            }
            info.getLoanContractOverView().get(0).setPaidAmount(paidAmount.subtract(historyPaidAmount));
            info.setConAddAmount(paidAmount);
            info.setConRemainAmount(info.getAmount().subtract(paidAmount));
            BigDecimal repayedLocalAmt = info.getLoanContractOverView().get(0).getRepayedLocalAmt() == null ? Constants.ZERO : info.getLoanContractOverView().get(0).getRepayedLocalAmt();
            info.getLoanContractOverView().get(0).setUnRepayedLocalAmt(paidAmount.subtract(historyPaidAmount).subtract(repayedLocalAmt));
            LoanInterestCollection interstCol = new LoanInterestCollection();
            for (int i = 0; i < loanCol.size(); ++i) {
                interstCol.addCollection(loanCol.get(i).getIntCollPrediction());
            }
            BigDecimal preInterestAmt = new BigDecimal(0);
            for (int i = 0; i < interstCol.size(); ++i) {
                preInterestAmt = preInterestAmt.add(interstCol.get(i).getInterest());
            }
            info.getLoanContractOverView().get(0).setPreInterestAmt(preInterestAmt);
            BigDecimal allPaidInterest = info.getLoanContractOverView().get(0).getPaidInterest() == null ? Constants.ZERO : info.getLoanContractOverView().get(0).getPaidInterest();
            info.getLoanContractOverView().get(0).setPreInterestUnPaidAmt(preInterestAmt.subtract(allPaidInterest));
        }
    }

    private void fillLoanContractActLoanSituation(Context ctx, LoanContractInfo info, LoanInfo loanInfo, BOTBillOperStateEnum bOTBillOperStateEnum, boolean isAddNew) throws BOSException, EASBizException {
        if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
            for (int i = 0; i < info.getLoanContractActLoanSituation().size(); ++i) {
                LoanContractActLoanSituationInfo loanContractActLoanSituation = info.getLoanContractActLoanSituation().get(i);
                if (!loanContractActLoanSituation.getLoanId().equals(loanInfo.getId().toString())) continue;
                info.getLoanContractActLoanSituation().remove(loanContractActLoanSituation);
            }
        } else if (isAddNew) {
            LoanContractActLoanSituationInfo loanContractActLoanSituation = new LoanContractActLoanSituationInfo();
            loanContractActLoanSituation.setLoanId(loanInfo.getId().toString());
            loanContractActLoanSituation.setLoanNumber(loanInfo.getNumber());
            loanContractActLoanSituation.setBeginDate(loanInfo.getIssueDate());
            loanContractActLoanSituation.setEndDate(loanInfo.getExpiredDate());
            loanContractActLoanSituation.setAmount(loanInfo.getAmount());
            loanContractActLoanSituation.setRepayedAmt(loanInfo.getAmount().subtract(loanInfo.getBalance()));
            loanContractActLoanSituation.setBalance(loanInfo.getBalance());
            info.getLoanContractActLoanSituation().add(loanContractActLoanSituation);
        } else {
            for (int i = 0; i < info.getLoanContractActLoanSituation().size(); ++i) {
                if (!info.getLoanContractActLoanSituation().get(i).getLoanId().equals(loanInfo.getId().toString())) continue;
                info.getLoanContractActLoanSituation().get(i).setLoanId(loanInfo.getId().toString());
                info.getLoanContractActLoanSituation().get(i).setLoanNumber(loanInfo.getNumber());
                info.getLoanContractActLoanSituation().get(i).setBeginDate(loanInfo.getIssueDate());
                info.getLoanContractActLoanSituation().get(i).setEndDate(loanInfo.getExpiredDate());
                info.getLoanContractActLoanSituation().get(i).setAmount(loanInfo.getAmount());
                info.getLoanContractActLoanSituation().get(i).setRepayedAmt(loanInfo.getAmount().subtract(loanInfo.getBalance()));
                info.getLoanContractActLoanSituation().get(i).setBalance(loanInfo.getBalance());
            }
        }
    }

    private void returnLoanApplyOnWay(Context ctx, LoanInfo loanInfo) throws EASBizException, BOSException {
        LoanApplyBillInfo loanApplyBillInfo = loanInfo.getLoanApplyBill();
        if (null != loanApplyBillInfo) {
            FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)loanApplyBillInfo);
            ObjectUuidPK pk = new ObjectUuidPK(loanApplyBillInfo.getId());
            FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)pk);
            FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
        }
    }

    private void restoreLoanApplyOnWay(Context ctx, LoanInfo loanInfo) throws EASBizException, BOSException {
        LoanApplyBillInfo loanApplyBillInfo = loanInfo.getLoanApplyBill();
        if (null != loanApplyBillInfo) {
            FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)loanApplyBillInfo);
            ObjectUuidPK pk = new ObjectUuidPK(loanApplyBillInfo.getId());
            FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)loanApplyBillInfo);
            NTHelper.OnWaybgCtrl((Context)ctx, (String)pk.toString());
        }
    }

    protected void updateMainConLoan(Context ctx, LoanInfo loanInfo, IObjectPK pk) throws BOSException, EASBizException {
        IObjectPK conPk;
        String sqld;
        MainConLoanInfo mcInfo = loanInfo.getMainConLoanInfo();
        if (mcInfo == null && loanInfo.getMainConLoan() != null) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add(new SelectorItemInfo("*"));
            evi.getSelector().add(new SelectorItemInfo("conNumber"));
            evi.getSelector().add(new SelectorItemInfo("seq"));
            evi.getSelector().add(new SelectorItemInfo("startDate"));
            evi.getSelector().add(new SelectorItemInfo("endDate"));
            evi.getSelector().add(new SelectorItemInfo("conAmount"));
            evi.getSelector().add(new SelectorItemInfo("addConAmount"));
            evi.getSelector().add(new SelectorItemInfo("remainConAmount"));
            evi.getSelector().add(new SelectorItemInfo("isMulCon"));
            mcInfo = MainConLoanFactory.getLocalInstance(ctx).getMainConLoanInfo((IObjectPK)new ObjectUuidPK(loanInfo.getMainConLoan().getId()), evi.getSelector());
        }
        if (!loanInfo.isIsMulCon()) {
            if (mcInfo != null && mcInfo.getId() != null) {
                sqld = " delete from T_FIN_MainConLoan where fid = ? ";
                DbUtil.execute((Context)ctx, (String)sqld, (Object[])new Object[]{mcInfo.getId().toString()});
            }
            if (mcInfo != null) {
                mcInfo.setConNumber(loanInfo.getContractNum());
                conPk = MainConLoanFactory.getLocalInstance(ctx).submit((CoreBaseInfo)mcInfo);
                String sql = " update T_FIN_Loan set FMainConLoanID = ? where fid = ? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{conPk.toString(), pk.toString()});
            }
        } else {
            String sql2;
            String sql1;
            String sql;
            if (loanInfo.getSeqMulCon() == 1) {
                if (mcInfo.getId() != null) {
                    sqld = " delete from T_FIN_MainConLoan where fid = ? ";
                    DbUtil.execute((Context)ctx, (String)sqld, (Object[])new Object[]{mcInfo.getId().toString()});
                }
                conPk = MainConLoanFactory.getLocalInstance(ctx).submit((CoreBaseInfo)mcInfo);
                sql = " update T_FIN_Loan set FMainConLoanID = ? where fid = ? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{conPk.toString(), pk.toString()});
            } else if (FMHelper.isInstanceof((String)loanInfo.getSourceBillId(), ConsignmentLoanBillInfo.class)) {
                conPk = MainConLoanFactory.getLocalInstance(ctx).submit((CoreBaseInfo)mcInfo);
                sql = " update T_FIN_Loan set FMainConLoanID = ? where fid = ? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{conPk.toString(), pk.toString()});
            } else {
                sql1 = " update T_FIN_MainConLoan set FAddConAmount = ?  where fid = ? ";
                DbUtil.execute((Context)ctx, (String)sql1, (Object[])new Object[]{mcInfo.getAddConAmount(), loanInfo.getMainConLoan().getId().toString()});
                sql2 = " update T_FIN_MainConLoan set FRemainConAmount = ?  where fid = ? ";
                DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{mcInfo.getRemainConAmount(), loanInfo.getMainConLoan().getId().toString()});
            }
            if (this.oldLoanInfo != null && mcInfo.getId() != null && !mcInfo.getId().equals((Object)this.oldLoanInfo.getMainConLoan().getId())) {
                if (this.oldLoanInfo.getSeqMulCon() == 1) {
                    sqld = " delete from T_FIN_MainConLoan where fid = ? ";
                    DbUtil.execute((Context)ctx, (String)sqld, (Object[])new Object[]{this.oldLoanInfo.getMainConLoan().getId().toString()});
                } else {
                    sql1 = " update T_FIN_MainConLoan set FAddConAmount = FAddConAmount - ?  where fid = ? ";
                    DbUtil.execute((Context)ctx, (String)sql1, (Object[])new Object[]{this.oldLoanInfo.getAmount(), this.oldLoanInfo.getMainConLoan().getId().toString()});
                    sql2 = " update T_FIN_MainConLoan set FRemainConAmount = FRemainConAmount + ?  where fid = ? ";
                    DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{this.oldLoanInfo.getAmount(), this.oldLoanInfo.getMainConLoan().getId().toString()});
                }
            }
        }
    }

    @Override
    protected Map _batchSubmit(Context ctx, Set idSet) throws BOSException, EASBizException {
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            LoanInfo loanInfo = this.getLoanInfo(ctx, (IObjectPK)new ObjectUuidPK((String)it.next()), this.getSelectors());
            this.setOtherProps(ctx, loanInfo);
            this.submit(ctx, (CoreBaseInfo)loanInfo);
        }
        return null;
    }

    private void setOtherProps(Context ctx, LoanInfo loanInfo) throws BOSException {
        loanInfo.setReduceCol(this.getReduceCol(ctx, (IObjectPK)new ObjectUuidPK(loanInfo.getId())));
        loanInfo.setIntCollPrediction(this.getIntCollPrediction(ctx, loanInfo.getId().toString()));
    }

    private LoanInterestCollection getIntCollPrediction(Context ctx, String loanId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loan.id", (Object)loanId));
        filter.getFilterItems().add(new FilterItemInfo("isPrediction", (Object)new Boolean(true)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return LoanInterestFactory.getLocalInstance(ctx).getLoanInterestCollection(evi);
    }

    @Override
    protected SelectorItemCollection getSelectors() {
        LoanInfo.loanSelectors();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("LocalCurExRate"));
        sic.add(new SelectorItemInfo("CreditCurrency.*"));
        sic.add(new SelectorItemInfo("CreditCurExRate"));
        sic.add(new SelectorItemInfo("IssueDate"));
        sic.add(new SelectorItemInfo("Remark"));
        sic.add(new SelectorItemInfo("AmountLocalCur"));
        sic.add(new SelectorItemInfo("Institution.*"));
        sic.add(new SelectorItemInfo("BasePoints"));
        sic.add(new SelectorItemInfo("YieldRate"));
        sic.add(new SelectorItemInfo("RepaymentType"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("CreditorGroup.*"));
        sic.add(new SelectorItemInfo("BankAcct.*"));
        sic.add(new SelectorItemInfo("LoanAcct.*"));
        sic.add(new SelectorItemInfo("Amount"));
        sic.add(new SelectorItemInfo("Balance"));
        sic.add(new SelectorItemInfo("ExpiredDate"));
        sic.add(new SelectorItemInfo("Horizon"));
        sic.add(new SelectorItemInfo("IsInCredit"));
        sic.add(new SelectorItemInfo("CreditLimit.*"));
        sic.add(new SelectorItemInfo("Currency"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("GroupID.*"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("SettlementAcct.*"));
        sic.add(new SelectorItemInfo("intRateTypeExpression"));
        sic.add(new SelectorItemInfo("penAccrualType"));
        sic.add(new SelectorItemInfo("lastIntDate"));
        sic.add(new SelectorItemInfo("penAccrualRate"));
        sic.add(new SelectorItemInfo("yearDays"));
        sic.add(new SelectorItemInfo("isMulCon"));
        sic.add(new SelectorItemInfo("contractNum"));
        sic.add(new SelectorItemInfo("IntRateType.*"));
        sic.add(new SelectorItemInfo("mainConLoan.*"));
        sic.add(new SelectorItemInfo("seqMulCon"));
        sic.add(new SelectorItemInfo("intFreeAmt"));
        sic.add(new SelectorItemInfo("Type.*"));
        sic.add(new SelectorItemInfo("project.*"));
        sic.add(new SelectorItemInfo("entrys.BlockFlowType.*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.amount"));
        sic.add(new SelectorItemInfo("entrys.date"));
        sic.add(new SelectorItemInfo("entrys.repayIntType"));
        sic.add(new SelectorItemInfo("fpItem.*"));
        sic.add(new SelectorItemInfo("rateAdjustPeriod"));
        sic.add(new SelectorItemInfo("floatAction"));
        sic.add(new SelectorItemInfo("firstRateAdjustDate"));
        sic.add(new SelectorItemInfo("payIntMode.*"));
        sic.add(new SelectorItemInfo("handlerRemark"));
        sic.add(new SelectorItemInfo("Type"));
        sic.add(new SelectorItemInfo("Type.id"));
        sic.add(new SelectorItemInfo("Type.number"));
        sic.add(new SelectorItemInfo("Type.name"));
        sic.add(new SelectorItemInfo("Type.financingSource.name"));
        sic.add(new SelectorItemInfo("Source"));
        sic.add(new SelectorItemInfo("Source.id"));
        sic.add(new SelectorItemInfo("Source.number"));
        sic.add(new SelectorItemInfo("Source.name"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("IsBankLoan"));
        sic.add(new SelectorItemInfo("Currency"));
        sic.add(new SelectorItemInfo("Currency.id"));
        sic.add(new SelectorItemInfo("Currency.number"));
        sic.add(new SelectorItemInfo("Currency.name"));
        sic.add(new SelectorItemInfo("company"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.basecurrency.id"));
        sic.add(new SelectorItemInfo("company.basecurrency.name"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("loanApplyBill.id"));
        sic.add("CreditLimit.CreditUsage.*");
        sic.add(new SelectorItemInfo("intBasis"));
        super.setEntrysSelector(sic);
        return sic;
    }

    @Override
    protected boolean _canEditLoan(Context ctx, String id) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)id)) {
            return true;
        }
        FilterInfo filterRepay = new FilterInfo();
        filterRepay.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)id));
        EntityViewInfo eviRepay = new EntityViewInfo();
        eviRepay.setFilter(filterRepay);
        RepaymentCollection colRepay = RepaymentFactory.getLocalInstance(ctx).getRepaymentCollection(eviRepay);
        if (colRepay != null && colRepay.size() > 0) {
            return false;
        }
        FilterInfo filterInt = new FilterInfo();
        filterInt.getFilterItems().add(new FilterItemInfo("loan.id", (Object)id));
        filterInt.getFilterItems().add(new FilterItemInfo("isPrediction", (Object)new Boolean(false)));
        EntityViewInfo eviInt = new EntityViewInfo();
        eviInt.setFilter(filterInt);
        LoanInterestCollection colInt = LoanInterestFactory.getLocalInstance(ctx).getLoanInterestCollection(eviInt);
        if (colInt != null && colInt.size() > 0) {
            return false;
        }
        return this._getAdjust(ctx, (IObjectPK)new ObjectUuidPK(id)) <= 0;
    }

    private void updateBankFactorForDel(Context ctx, LoanInfo loanInfo) throws BOSException, EASBizException {
        String sql = "update T_CTL_BankFactor set FLoanAmount = 0,FLoanBalance=0 ,FIsMortgage = 0 where FID = ?";
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        IBankFactor localInstance = BankFactorFactory.getLocalInstance((Context)ctx);
        Iterator iter = loanInfo.getGuaranteeEntrys().iterator();
        while (iter.hasNext()) {
            BankFactorInfo backFactor;
            GuaranteeDetailInfo element = (GuaranteeDetailInfo)iter.next();
            if (!GuaranteeTypePropertyEnum.pledge.equals((Object)element.getGuaranteeTypeProperty()) || !MortgageTypeEnum.Receivable.equals((Object)element.getMortgageType()) || element.getBillId() == null || (backFactor = localInstance.getBankFactorInfo((IObjectPK)new ObjectUuidPK(element.getBillId()))) == null) continue;
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{backFactor.getId().toString()});
            iBOTRelation.removeRelationBySrcObjId(backFactor.getId().toString(), loanInfo.getBOSType().toString());
        }
    }

    private void updateBankFactorForAdd(Context ctx, LoanInfo info) throws BOSException, EASBizException {
        ArrayList<String> idList = new ArrayList<String>();
        String sql = "update T_CTL_BankFactor set FLoanAmount = ?,FLoanBalance=? ,FIsMortgage = 1 where FID = ?";
        IBankFactor localInstance = BankFactorFactory.getLocalInstance((Context)ctx);
        Iterator iter = info.getGuaranteeEntrys().iterator();
        while (iter.hasNext()) {
            BankFactorInfo backFactor;
            GuaranteeDetailInfo element = (GuaranteeDetailInfo)iter.next();
            if (!GuaranteeTypePropertyEnum.pledge.equals((Object)element.getGuaranteeTypeProperty()) || !MortgageTypeEnum.Receivable.equals((Object)element.getMortgageType()) || element.getBillId() == null || (backFactor = localInstance.getBankFactorInfo((IObjectPK)new ObjectUuidPK(element.getBillId()))) == null) continue;
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getAmount(), info.getBalance(), backFactor.getId().toString()});
            idList.add(backFactor.getId().toString());
        }
        if (idList.size() > 0) {
            FMHelper.saveBOTRelation((Context)ctx, idList, (String)info.getId().toString());
        }
    }

    private void updatePayablebill(Context ctx, LoanInfo info, boolean isAdd) throws BOSException {
        String srcBillId = info.getSourceBillId();
        if (srcBillId == null || "".equals(srcBillId.trim()) || !BOSUuid.read((String)srcBillId).getType().equals((Object)new PayableBillInfo().getBOSType())) {
            return;
        }
        if (isAdd) {
            String sql = "update t_nt_payablebill set FBillState = ?,FTransferDate=?  where fid =?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(7), DateUtil.getSQLBegin((Date)info.getBizDate()), srcBillId});
            HashMap<String, String> relation = new HashMap<String, String>();
            relation.put(srcBillId, info.getId().toString());
            FMHelper.saveBOTRelation((Context)ctx, relation);
        } else {
            String sql = "update t_nt_payablebill set FBillState = ?,FTransferDate=null where fid =?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(NTHelper.getNTInitState((Context)ctx, (boolean)false)), srcBillId});
        }
    }

    private void prediction(Context ctx, LoanInfo info) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(info.getId().toString());
        Set intIDSet = LoanInterestPredictionFacadeFactory.getLocalInstance(ctx).genLoanInterestPredictionFromListUI(idSet);
    }

    @Override
    protected Map _submitLoanRepay(Context ctx, LoanInfo info, Map param) throws BOSException, EASBizException {
        int i;
        HashMap ret = new HashMap();
        CoreBaseCollection colls = new CoreBaseCollection();
        Date date = (Date)param.get("Date");
        BigDecimal rePaymentAmt = (BigDecimal)param.get("rePaymentAmt");
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("isUpRepayRecord"));
        selector.add(new SelectorItemInfo("entrys.id"));
        selector.add(new SelectorItemInfo("entrys.date"));
        selector.add(new SelectorItemInfo("entrys.amount"));
        selector.add(new SelectorItemInfo("entrys.repayIntType"));
        selector.add(new SelectorItemInfo("entrys.BlockFlowType"));
        selector.add(new SelectorItemInfo("entrys.isRepaid"));
        LoanInfo newInfo = LoanFactory.getLocalInstance(ctx).getLoanInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()), selector);
        newInfo.getEntrys().clear();
        for (i = 0; i < info.getEntrys().size(); ++i) {
            LoanEntryInfo entry = info.getEntrys().get(i);
            if (entry.getDate() != null && entry.getDate().compareTo(date) == 0 && rePaymentAmt.compareTo(entry.getAmount()) == 0 && !entry.isIsRepaid()) {
                entry.setIsRepaid(true);
            }
            if (Constants.ZERO.compareTo(entry.getAmount()) == 0) continue;
            newInfo.getEntrys().add(entry);
        }
        newInfo.getEntrys().sort("date");
        for (i = 0; i < newInfo.getEntrys().size(); ++i) {
            newInfo.getEntrys().get(i).setSeq(i);
        }
        if (!newInfo.isIsUpRepayRecord()) {
            newInfo.setIsUpRepayRecord(true);
        }
        colls.add((CoreBaseInfo)newInfo);
        super.updateBatchData(ctx, colls);
        this.prediction(ctx, newInfo);
        return ret;
    }

    @Override
    protected Map _batchUpdateLoanRepay(Context ctx, Set ids) throws BOSException, EASBizException {
        HashMap<String, Object> rlts = new HashMap<String, Object>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isUpRepayRecord", (Object)false));
        EntityViewInfo eviLoan = new EntityViewInfo();
        eviLoan.setFilter(filter);
        eviLoan.getSelector().add(new SelectorItemInfo("id"));
        eviLoan.getSelector().add(new SelectorItemInfo("isUpRepayRecord"));
        eviLoan.getSelector().add(new SelectorItemInfo("entrys.id"));
        eviLoan.getSelector().add(new SelectorItemInfo("entrys.date"));
        eviLoan.getSelector().add(new SelectorItemInfo("entrys.amount"));
        eviLoan.getSelector().add(new SelectorItemInfo("entrys.repayIntType"));
        eviLoan.getSelector().add(new SelectorItemInfo("entrys.BlockFlowType"));
        LoanCollection loanCol = LoanFactory.getLocalInstance(ctx).getLoanCollection(eviLoan);
        int total = loanCol.size();
        int success = 0;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < loanCol.size(); ++i) {
            try {
                LoanFactory.getLocalInstance(ctx).updateOneLoanRepay(loanCol.get(i));
                ++success;
                continue;
            }
            catch (Exception e) {
                sb.append(e.getMessage());
            }
        }
        rlts.put("total", total);
        rlts.put("success", success);
        rlts.put("error", sb.toString());
        return rlts;
    }

    private BlockingFlowTypeInfo getDefaultBlockingFlowTypeInfo(Context ctx) throws EASBizException, BOSException {
        EntityViewInfo vi = new EntityViewInfo();
        FilterInfo fInfo = new FilterInfo();
        fInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"001", CompareType.EQUALS));
        vi.setFilter(fInfo);
        BlockingFlowTypeCollection bftCollection = null;
        bftCollection = BlockingFlowTypeFactory.getLocalInstance((Context)ctx).getBlockingFlowTypeCollection(vi);
        if (bftCollection == null || bftCollection.size() == 0) {
            throw new LoanException(LoanException.BLOCKINGFLOWTYPENUMBER001NOTEXISTS);
        }
        BlockingFlowTypeInfo bftInfo = bftCollection.get(0);
        return bftInfo;
    }

    @Override
    protected Map _updateOneLoanRepay(Context ctx, LoanInfo info) throws BOSException, EASBizException {
        HashMap ret = new HashMap();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)info.getId().toString()));
        EntityViewInfo eviRepay = new EntityViewInfo();
        eviRepay.setFilter(filter);
        eviRepay.getSelector().add(new SelectorItemInfo("id"));
        eviRepay.getSelector().add(new SelectorItemInfo("bizDate"));
        eviRepay.getSelector().add(new SelectorItemInfo("Amount"));
        eviRepay.getSelector().add(new SelectorItemInfo("isRepayInt"));
        RepaymentCollection repayCol = RepaymentFactory.getLocalInstance(ctx).getRepaymentCollection(eviRepay);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)repayCol)) {
            int i;
            BlockingFlowTypeInfo bftInfo = this.getDefaultBlockingFlowTypeInfo(ctx);
            Date lastDate = new Date();
            try {
                String sql = "select MAX(FBIZDATE) AS FBIZDATE from T_FIN_Repayment where  FSOURCEBILLID = ?";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{info.getId().toString()});
                if (rs.next()) {
                    lastDate = rs.getDate("FBIZDATE");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            LoanEntryCollection entryRmColls = new LoanEntryCollection();
            for (i = 0; i < info.getEntrys().size(); ++i) {
                LoanEntryInfo entry = info.getEntrys().get(i);
                if (entry.getDate().compareTo(lastDate) == 1) continue;
                entryRmColls.add(entry);
            }
            for (i = 0; i < entryRmColls.size(); ++i) {
                info.getEntrys().remove(entryRmColls.get(i));
            }
            for (i = 0; i < repayCol.size(); ++i) {
                RepaymentInfo repayInfo = repayCol.get(i);
                LoanEntryInfo entry = new LoanEntryInfo();
                entry.setDate(repayInfo.getBizDate());
                entry.setAmount(repayInfo.getAmount());
                RepayIntTypeEnum repayIntTypeEnum = repayInfo.isIsRepayInt() ? RepayIntTypeEnum.REPAY_INT : RepayIntTypeEnum.REPAY_NOINT;
                entry.setRepayIntType(repayIntTypeEnum);
                entry.setBlockFlowType(bftInfo);
                entry.setIsRepaid(true);
                info.getEntrys().add(entry);
            }
            info.getEntrys().sort("date");
            for (i = 0; i < info.getEntrys().size(); ++i) {
                info.getEntrys().get(i).setSeq(i);
            }
        }
        info.setIsUpRepayRecord(true);
        CoreBaseCollection colls = new CoreBaseCollection();
        colls.add((CoreBaseInfo)info);
        super.updateBatchData(ctx, colls);
        this.prediction(ctx, info);
        return ret;
    }
}

