/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.freechart.util.Log;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.cl.ConsignLoanExtBillInfo;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.LoanContractInfo;
import com.kingdee.eas.fm.fin.LoanDeferInfo;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.StatusExtEnum;
import com.kingdee.eas.fm.fin.app.AbstractLoanDeferControllerBean;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.fm.ft.FundTransferExtBillInfo;
import com.kingdee.eas.fm.ivt.CHLoanExtendBillInfo;
import com.kingdee.eas.framework.AbstractCoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class LoanDeferControllerBean
extends AbstractLoanDeferControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.LoanDeferControllerBean");

    @Override
    protected Map _getInitDate(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        int maxDeferSeq = 0;
        java.util.Date lastDeferDate = null;
        HashMap<String, Comparable<Integer>> returnValue = new HashMap<String, Comparable<Integer>>();
        String sql = "select FSeq,FAfterDeferDate from T_FIN_LoanDefer where FSeq = ( select isnull(max(FSeq),0) from T_FIN_LoanDefer where FLoanID = ?) and FLoanID=?";
        Connection cn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            cn = this.getConnection(ctx);
            pstmt = cn.prepareStatement(sql);
            pstmt.setString(1, pk.toString());
            pstmt.setString(2, pk.toString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                maxDeferSeq = rs.getInt(1);
                Date d = rs.getDate(2);
                lastDeferDate = new java.util.Date(d.getTime());
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
        returnValue.clear();
        returnValue.put("maxDeferSeq", new Integer(++maxDeferSeq));
        returnValue.put("lastDeferDate", lastDeferDate);
        return returnValue;
    }

    private void checkStatus(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (!EmptyUtil.isEmpty((Object)model)) {
            LoanDeferInfo deferInfo = (LoanDeferInfo)model;
            if (StatusExtEnum.AUDIT == (deferInfo = this.getLoanDeferInfo(ctx, (IObjectPK)new ObjectUuidPK(deferInfo.getId().toString()))).getStatusExtEnum()) {
                throw new EASBizException(new NumericExceptionSubItem("", EASCommonResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"279_LoanDeferListUI", (Locale)ctx.getLocale())));
            }
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkStatus(ctx, model);
        super._update(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        this.checkSeqDup(ctx, info);
        this.verify(ctx, info);
        IObjectPK pk = super._submit(ctx, info);
        this.updateLoanInfo(ctx, (LoanDeferInfo)info, false);
        this.saveBOTPRelationShip(ctx, (LoanDeferInfo)info, pk);
        CHLoanExtendBillInfo chExInfo = ((LoanDeferInfo)info).getChLoanExtendBill();
        if (chExInfo != null) {
            this.updateCHLoanExtendBill(ctx, chExInfo.getId().toString(), false);
        }
        if (((AbstractCoreBillBaseInfo)info).getSourceBillId() != null) {
            FMBGHelper.reverseLoanExt((Context)ctx, (String)((AbstractCoreBillBaseInfo)info).getSourceBillId(), (String)"1");
        }
        return pk;
    }

    protected void verify(Context ctx, IObjectValue objectValue) throws BOSException, EASBizException {
        LoanDeferInfo info = (LoanDeferInfo)objectValue;
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"bizDate");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"loan");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"beforeDeferDate");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"afterDeferDate");
        java.util.Date dateBegin = DateTimeUtils.truncateDate((java.util.Date)info.getBeforeDeferDate());
        java.util.Date dateEnd = DateTimeUtils.truncateDate((java.util.Date)info.getAfterDeferDate());
        if (!dateEnd.after(dateBegin)) {
            throw new FinBizException(FinBizException.ENDDEFERDATEMUSTAFTERBEGINDEFERDATE);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"seq");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"balance");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"currency");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"exchangeRate");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"localAmount");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"rateExpression");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"yearDays");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"deferRate");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"penaIntType");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"peneIntRate");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"creator");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"company");
    }

    private void updateCHLoanExtendBill(Context ctx, String id, boolean isDelete) throws BOSException {
        String sql = "";
        sql = isDelete ? " update T_IVT_CHLoanExtendBill set FIsDownLoaded = 0 where fid = ? " : " update T_IVT_CHLoanExtendBill set FIsDownLoaded = 1 where fid = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{id});
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CHLoanExtendBillInfo chExInfo;
        LoanDeferInfo info = this.getLoanDeferInfo(ctx, pk);
        this.updateLoanInfo(ctx, info, true);
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
        super._delete(ctx, pk);
        if (info.getSourceBillId() != null) {
            BOSUuid bisid = BOSUuid.read((String)info.getSourceBillId());
            BOSObjectType idType = bisid.getType();
            if (idType.equals((Object)ConsignLoanExtBillInfo.BOSTYPE)) {
                String sql = "update T_CL_ConsignLoanExtBill set FIsGenLoanExt=0 where FID='" + info.getSourceBillId() + "'";
                DbUtil.execute((Context)ctx, (String)sql);
            } else if (idType.equals((Object)FundTransferExtBillInfo.BOSTYPE)) {
                String sql = "update T_FT_FundTransferExtBill set FIsGenLoanExt=0 where FID='" + info.getSourceBillId() + "'";
                DbUtil.execute((Context)ctx, (String)sql);
            }
        }
        if ((chExInfo = info.getChLoanExtendBill()) != null) {
            this.updateCHLoanExtendBill(ctx, chExInfo.getId().toString(), true);
        }
        if (info.getSourceBillId() != null) {
            FMBGHelper.reverseLoanExt((Context)ctx, (String)info.getSourceBillId(), (String)"0");
        }
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            LoanDeferInfo info = (LoanDeferInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccountant(null);
                info.setFivouchered(false);
            } else {
                info.setAccountant(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                info.setFivouchered(true);
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    private void updateLoanInfo(Context ctx, LoanDeferInfo loanDeferInfo, boolean isDelete) throws BOSException, EASBizException {
        String sql = "update T_FIN_LOAN set FExpiredDate = ? where fid = ?";
        String sql2 = "update T_FIN_LOAN set FHorizon = ? where fid = ?";
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("IssueDate"));
        evi.getSelector().add(new SelectorItemInfo("mainConLoan.*"));
        evi.getSelector().add(new SelectorItemInfo("mainConLoan.id"));
        LoanInfo loanInfo = LoanFactory.getLocalInstance(ctx).getLoanInfo((IObjectPK)new ObjectUuidPK(loanDeferInfo.getLoan().getId().toString()), evi.getSelector());
        if (!isDelete) {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{loanDeferInfo.getAfterDeferDate(), loanInfo.getId().toString()});
            this.updateMainLoanInfo(ctx, loanDeferInfo, false, loanInfo);
            this.updateLoanContract(ctx, loanDeferInfo, false, loanInfo);
            BigDecimal horizon = FinHorizon.getHorizon(loanInfo.getIssueDate(), loanDeferInfo.getAfterDeferDate());
            DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{horizon, loanInfo.getId().toString()});
        } else {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{loanDeferInfo.getBeforeDeferDate(), loanInfo.getId().toString()});
            this.updateMainLoanInfo(ctx, loanDeferInfo, true, loanInfo);
            this.updateLoanContract(ctx, loanDeferInfo, true, loanInfo);
            BigDecimal horizon = FinHorizon.getHorizon(loanInfo.getIssueDate(), loanDeferInfo.getBeforeDeferDate());
            DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{horizon, loanInfo.getId().toString()});
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateMainLoanInfo(Context ctx, LoanDeferInfo ldInfo, boolean isDelete, LoanInfo loanInfo) throws BOSException {
        if (isDelete) {
            String mSql = " update T_FIN_MainConLoan set FEndDate = ? where fid =?";
            try {
                DbUtil.execute((Context)ctx, (String)mSql, (Object[])new Object[]{ldInfo.getBeforeDeferDate(), loanInfo.getMainConLoan().getId().toString()});
                return;
            }
            catch (BOSException e) {
                throw new BOSException((Throwable)e);
            }
        }
        Date d = null;
        String mainLoanID = null;
        String sql1 = "select FMainConLoanID from T_FIN_Loan where FID=?";
        String sql2 = "select FEndDate from T_FIN_MainConLoan where fid =?";
        Connection cn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            cn = this.getConnection(ctx);
            pstmt = cn.prepareStatement(sql1);
            pstmt.setString(1, ldInfo.getLoan().getId().toString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                mainLoanID = rs.getString(1);
            }
            pstmt.close();
            rs.close();
            pstmt = cn.prepareStatement(sql2);
            pstmt.setString(1, mainLoanID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                d = rs.getDate(1);
            }
        }
        catch (SQLDataException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (SQLException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
        if (d == null) return;
        if (d.compareTo(ldInfo.getAfterDeferDate()) >= 0) return;
        String mSql = " update T_FIN_MainConLoan set FEndDate = ? where fid =?";
        DbUtil.execute((Context)ctx, (String)mSql, (Object[])new Object[]{ldInfo.getAfterDeferDate(), mainLoanID});
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateLoanContract(Context ctx, LoanDeferInfo ldInfo, boolean isDelete, LoanInfo loanInfo) throws BOSException {
        if (StringUtils.isEmpty((String)loanInfo.getLoanContractId())) return;
        if (!FMHelper.isInstanceof((String)loanInfo.getSourceBillId(), LoanContractInfo.class)) {
            return;
        }
        if (isDelete) {
            String updateloanContractSql = " update T_FIN_LOANCONTRACT set FCONENDDATE = ?,FEXPIREDDATE =? where fid =?";
            try {
                DbUtil.execute((Context)ctx, (String)updateloanContractSql, (Object[])new Object[]{ldInfo.getBeforeDeferDate(), ldInfo.getBeforeDeferDate(), loanInfo.getLoanContractId().toString()});
                return;
            }
            catch (BOSException e) {
                throw new BOSException((Throwable)e);
            }
        }
        Date nowEndDate = null;
        String loanContractID = null;
        String sql1 = "select FLOANCONTRACTID from T_FIN_Loan where FID=?";
        String sql2 = "select FCONENDDATE from T_FIN_LOANCONTRACT where fid =?";
        Connection cn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            cn = this.getConnection(ctx);
            pstmt = cn.prepareStatement(sql1);
            pstmt.setString(1, ldInfo.getLoan().getId().toString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                loanContractID = rs.getString(1);
            }
            pstmt.close();
            rs.close();
            pstmt = cn.prepareStatement(sql2);
            pstmt.setString(1, loanContractID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                nowEndDate = rs.getDate(1);
            }
        }
        catch (SQLDataException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (SQLException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
        if (nowEndDate == null) return;
        if (ldInfo.getAfterDeferDate() == null) return;
        if (nowEndDate.compareTo(ldInfo.getAfterDeferDate()) >= 0) return;
        String mSql = " update T_FIN_LOANCONTRACT set FCONENDDATE = ?,FEXPIREDDATE =? where fid =?";
        DbUtil.execute((Context)ctx, (String)mSql, (Object[])new Object[]{ldInfo.getAfterDeferDate(), ldInfo.getAfterDeferDate(), loanContractID});
    }

    private void saveBOTPRelationShip(Context ctx, LoanDeferInfo info, IObjectPK pk) throws BOSException {
        HashMap<String, String> botpRelationShip = new HashMap<String, String>();
        botpRelationShip.clear();
        botpRelationShip.put(info.getLoan().getId().toString(), pk.toString());
        FMHelper.saveBOTRelation((Context)ctx, botpRelationShip);
    }

    @Override
    protected Map _getMsgWhenCreateCHLoanExtendBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection cn;
        HashMap<String, Object> msg;
        block9: {
            msg = new HashMap<String, Object>();
            cn = null;
            pstmt = null;
            rs = null;
            String sql1 = " select FExtendSeq,FChLoanID from T_IVT_CHLoanExtendBill where fid = ?";
            String sql2 = " select FID from t_fin_loan where FEntLoanID = ?";
            String sql3 = " select isnull(max(FSeq),0) from t_fin_loandefer where FLoanID = ?";
            try {
                cn = this.getConnection(ctx);
                int extendSeq = 0;
                int recExtendSeq = 0;
                String chLoanId = "";
                pstmt = cn.prepareStatement(sql1);
                pstmt.setString(1, pk.toString());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    extendSeq = rs.getInt(1);
                    chLoanId = rs.getString(2);
                }
                msg.put("chLoanID", chLoanId);
                pstmt.close();
                rs.close();
                String loanID = "";
                pstmt = cn.prepareStatement(sql2);
                pstmt.setString(1, chLoanId);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    loanID = rs.getString(1);
                }
                if (FMHelper.isEmpty((String)loanID)) {
                    throw new FinBizException(FinBizException.LOANISNULL);
                }
                msg.put("loanID", loanID);
                pstmt.close();
                rs.close();
                pstmt = cn.prepareStatement(sql3);
                pstmt.setString(1, loanID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    recExtendSeq = rs.getInt(1);
                }
                if (extendSeq == recExtendSeq + 1) {
                    msg.put("canRec", new Boolean(true));
                    break block9;
                }
                msg.put("canRec", new Boolean(false));
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)cn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
        return msg;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanDeferInfo info = (LoanDeferInfo)model;
        info.setStatusExtEnum(StatusExtEnum.SUBMIT);
        if (FMHelper.isEmpty((String)info.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        this._checkNumberDup(ctx, (IObjectValue)info);
        this.checkSeqDup(ctx, (IObjectValue)info);
        IObjectPK pk = super._addnew(ctx, model);
        if (info.getSourceBillId() != null) {
            BOSUuid bisid = BOSUuid.read((String)info.getSourceBillId());
            BOSObjectType idType = bisid.getType();
            if (idType.equals((Object)ConsignLoanExtBillInfo.BOSTYPE)) {
                String sql = "update T_CL_ConsignLoanExtBill set FIsGenLoanExt=1 where FID='" + info.getSourceBillId() + "'";
                DbUtil.execute((Context)ctx, (String)sql);
            } else if (idType.equals((Object)FundTransferExtBillInfo.BOSTYPE)) {
                String sql = "update T_FT_FundTransferExtBill set FIsGenLoanExt=1 where FID='" + info.getSourceBillId() + "'";
                DbUtil.execute((Context)ctx, (String)sql);
            }
        }
        return pk;
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected void checkSeqDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = this.getCheckSeqDupFilter(model, true, "seq");
        if (this._exists(ctx, filter)) {
            throw new FinBizException(FinBizException.CHECKDUPSEQ, new Object[]{model.getString("seq"), ""});
        }
    }

    protected FilterInfo getCheckSeqDupFilter(IObjectValue model, boolean isNeedComp, String seqName) {
        FilterInfo filter = new FilterInfo();
        if (isNeedComp) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)model.getObjectValue("company").getBOSUuid("id")));
        }
        filter.getFilterItems().add(new FilterItemInfo(seqName, (Object)model.getString(seqName)));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)model.getBOSUuid("id"), CompareType.NOTEQUALS));
        LoanInfo loanInfo = (LoanInfo)model.get("loan");
        String loanid = null;
        if (!EmptyUtil.isEmpty((CoreBaseInfo)loanInfo)) {
            loanid = loanInfo.getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("loan.id", (Object)loanid));
        return filter;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.verify(ctx, model);
        return super._save(ctx, model);
    }

    @Override
    protected IObjectValue _getLoanInfo(Context ctx, String id) throws BOSException, EASBizException {
        BOSUuid bisid = BOSUuid.read((String)id);
        BOSObjectType idType = bisid.getType();
        if (idType.equals((Object)ConsignLoanExtBillInfo.BOSTYPE) || idType.equals((Object)FundTransferExtBillInfo.BOSTYPE)) {
            id = this.getRelationLoanBillID(ctx, id);
        }
        SelectorItemCollection selectors = LoanDeferControllerBean.getFinBillSelector();
        return LoanFactory.getLocalInstance(ctx).getLoanInfo((IObjectPK)new ObjectUuidPK(id), selectors);
    }

    private static SelectorItemCollection getFinBillSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("Institution.id"));
        sic.add(new SelectorItemInfo("Institution.number"));
        sic.add(new SelectorItemInfo("Institution.name"));
        sic.add(new SelectorItemInfo("BankAcct.id"));
        sic.add(new SelectorItemInfo("BankAcct.number"));
        sic.add(new SelectorItemInfo("BankAcct.name"));
        sic.add(new SelectorItemInfo("GroupID.id"));
        sic.add(new SelectorItemInfo("GroupID.number"));
        sic.add(new SelectorItemInfo("GroupID.name"));
        sic.add(new SelectorItemInfo("IntRateType.id"));
        sic.add(new SelectorItemInfo("IntRateType.number"));
        sic.add(new SelectorItemInfo("IntRateType.name"));
        return sic;
    }

    protected String getRelationLoanBillID(Context ctx, String sourceBillID) throws BOSException {
        String loanID = "";
        if (StringUtil.isEmpty((String)sourceBillID)) {
            return loanID;
        }
        BOSUuid bisid = BOSUuid.read((String)sourceBillID);
        BOSObjectType idType = bisid.getType();
        String sql = null;
        if (idType.equals((Object)ConsignLoanExtBillInfo.BOSTYPE)) {
            sql = "select loan.FID from T_CL_ConsignLoanExtBill con,T_FIN_Loan loan where con.FLoanID=loan.FSourceBillId and con.FID='" + sourceBillID + "'";
        } else if (idType.equals((Object)FundTransferExtBillInfo.BOSTYPE)) {
            sql = "select loan.FID from T_FT_FundTransferExtBill fun,T_FIN_Loan loan where fun.FLoanID=loan.FSourceBillId and fun.FID='" + sourceBillID + "'";
        }
        if (!StringUtil.isEmpty(sql)) {
            ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)ctx, sql);
            IRowSet set = exec.executeSQL();
            try {
                if (set != null && set.next()) {
                    loanID = set.getString(1);
                    set.close();
                }
            }
            catch (SQLException e) {
                Log.debug((Object)e.getMessage());
                return loanID;
            }
        }
        return loanID;
    }
}

