/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fin.LoanExhBillStatusEnum;
import com.kingdee.eas.fm.fin.LoanExhibitionCollection;
import com.kingdee.eas.fm.fin.LoanExhibitionFactory;
import com.kingdee.eas.fm.fin.LoanExhibitionInfo;
import com.kingdee.eas.fm.fin.app.AbstractLoanExhibitionControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class LoanExhibitionControllerBean
extends AbstractLoanExhibitionControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.LoanExhibitionControllerBean");

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        LoanExhibitionInfo info = LoanExhibitionFactory.getLocalInstance(ctx).getLoanExhibitionInfo(pk);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditDate(DateTimeUtils.truncateDate((Date)new Date()));
        info.setState(LoanExhBillStatusEnum.audit);
        try {
            this._update(ctx, pk, (IObjectValue)info);
        }
        catch (EASBizException e) {
            logger.debug((Object)e.getMessage(), e.fillInStackTrace());
        }
        super._passAudit(ctx, pk, model);
    }

    @Override
    protected void _batchAntiAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        LoanExhibitionCollection col = LoanExhibitionFactory.getLocalInstance(ctx).getLoanExhibitionCollection(view);
        for (int i = 0; i < col.size(); ++i) {
            if (col.get(i).getState() == null || !LoanExhBillStatusEnum.audit.equals((Object)col.get(i).getState())) continue;
            col.get(i).setAuditor(null);
            col.get(i).setAuditDate(null);
            col.get(i).setState(LoanExhBillStatusEnum.save);
        }
        try {
            this._updateBatchData(ctx, (IObjectCollection)col);
        }
        catch (EASBizException e) {
            logger.debug((Object)e.getMessage(), e.fillInStackTrace());
        }
    }

    @Override
    protected void _batchAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        LoanExhibitionCollection col = LoanExhibitionFactory.getLocalInstance(ctx).getLoanExhibitionCollection(view);
        for (int i = 0; i < col.size(); ++i) {
            if (col.get(i).getState() == null || !LoanExhBillStatusEnum.submit.equals((Object)col.get(i).getState())) continue;
            col.get(i).setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
            col.get(i).setAuditDate(DateTimeUtils.truncateDate((Date)new Date()));
            col.get(i).setState(LoanExhBillStatusEnum.audit);
        }
        try {
            this._updateBatchData(ctx, (IObjectCollection)col);
        }
        catch (EASBizException e) {
            logger.debug((Object)e.getMessage(), e.fillInStackTrace());
        }
    }

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanExhibitionInfo info = (LoanExhibitionInfo)model;
        if (FMHelper.isEmpty((String)info.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        this.checkNumberDup(ctx, model);
        IObjectPK pkReturn = super._addnew(ctx, model);
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        boolean exist = codingRuleManager.isExist((IObjectValue)info, info.getCompany().getId().toString());
        if (exist && codingRuleManager.isAddView((IObjectValue)info, info.getCompany().getId().toString()) && !codingRuleManager.isUseIntermitNumber((IObjectValue)info, info.getCompany().getId().toString())) {
            codingRuleManager.getNumber((IObjectValue)info, info.getCompany().getId().toString());
        }
        return pkReturn;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanExhibitionInfo info = this.getLoanExhibitionInfo(ctx, pk);
        NumberRuleUtil.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
        super._delete(ctx, pk);
    }
}

