/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fm.fin.LoanBookNotifyBuilder;
import com.kingdee.eas.fm.fin.LoanCollection;
import com.kingdee.eas.fm.fin.LoanException;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.LoanInterestFactory;
import com.kingdee.eas.fm.fin.app.AbstractLoanFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class LoanFacadeControllerBean
extends AbstractLoanFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.LoanFacadeControllerBean");

    @Override
    protected void _syncExpiredDate(Context ctx, String billId, Date date) throws BOSException, EASBizException {
    }

    @Override
    protected void _syncLastPreIntDate(Context ctx, String billId, Date date) throws BOSException {
    }

    @Override
    protected void _syncLastIntDate(Context ctx, String billId, Date date) throws BOSException, EASBizException {
    }

    @Override
    protected void _syncLoanBalance(Context ctx, String billId, BigDecimal amount) throws BOSException, EASBizException {
    }

    @Override
    protected void _book(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        this.verifyBeforeBook(ctx, idList);
        LoanBookNotifyBuilder builder = new LoanBookNotifyBuilder();
        JournalCollection journalColl = new JournalCollection();
        String sql = "UPDATE T_FIN_LOAN SET FCashierID = ? WHERE FID = ? ";
        String userId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString();
        String billId = null;
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            billId = (String)idList.get(i);
            if (this.isBooked(ctx, billId)) continue;
            journalColl.addCollection(builder.getJournalColl(ctx, billId));
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userId, billId});
        }
        IBookNotifyFacade bookFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        bookFacade.bookBatch(journalColl);
    }

    private boolean isBooked(Context ctx, String billId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        view.setFilter(filter);
        JournalCollection coll = JournalFactory.getLocalInstance((Context)ctx).getJournalCollection(view);
        return coll != null && coll.size() > 0;
    }

    private void verifyBeforeBook(Context ctx, List idList) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.setFilter(filter);
        LoanCollection coll = LoanFactory.getLocalInstance(ctx).getLoanCollection(evi);
        LoanInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (info.isIsGenRecBill()) {
                throw new LoanException(LoanException.HASBEENBOOK, new Object[]{info.getNumber()});
            }
            if (info.getBankAcct() == null) {
                throw new LoanException(LoanException.BOOKERROR, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"8_LoanFacadeControllerBean", (Locale)ctx.getLocale())});
            }
            if (info.getCautionAmt().compareTo(Constants.ZERO) == 0 || info.getCautionAcctBank() != null) continue;
            throw new LoanException(LoanException.BOOKERROR, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"9_LoanFacadeControllerBean", (Locale)ctx.getLocale())});
        }
    }

    @Override
    protected void _cancelBook(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        String sql = "UPDATE T_FIN_LOAN SET FCashierID = NULL WHERE FID = ? ";
        String billId = null;
        IBookNotifyFacade bookFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            billId = (String)idList.get(i);
            bookFacade.antiBook(billId);
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{billId});
        }
    }

    @Override
    protected void _audit(Context ctx, Set idSet) throws BOSException, EASBizException {
        String tableName = this.getTableName(ctx, idSet);
        if (tableName.equalsIgnoreCase("T_FIN_LoanInterest")) {
            for (String id : idSet) {
                LoanInterestFactory.getLocalInstance(ctx).audit4WF(id);
            }
        } else {
            this.doUpdate(ctx, idSet, tableName, 1);
        }
    }

    @Override
    protected void _antiAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        String tableName = this.getTableName(ctx, idSet);
        if (tableName.equalsIgnoreCase("T_FIN_LoanInterest")) {
            for (String id : idSet) {
                LoanInterestFactory.getLocalInstance(ctx).antiAudit4WF(id);
            }
        } else {
            this.doUpdate(ctx, idSet, tableName, 0);
        }
    }

    private void doUpdate(Context ctx, Set idSet, String tableName, int value) throws SQLDataException, BOSException {
        String userID = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
        String sql = "update " + tableName + " set fstatusextenum = ? , fauditorID = ? where fid = ?";
        Connection con = this.getConnection(ctx);
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
            ps.clearBatch();
            String[] ids = idSet.toArray(new String[idSet.size()]);
            for (int i = 0; i < ids.length; ++i) {
                ps.setInt(1, value);
                ps.setString(2, userID);
                ps.setString(3, ids[i]);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException exc) {
            logger.error((Object)("sql is:" + sql), (Throwable)exc);
            throw new BOSException("Sql3 execute exception : " + sql, (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup(null, (Statement)ps, (Connection)con);
        }
    }

    private String getTableName(Context ctx, Set idSet) {
        String id = idSet.toArray()[0].toString();
        BOSUuid uuid = BOSUuid.read((String)id);
        BOSObjectType bosType = uuid.getType();
        EntityObjectInfo eoi = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType);
        String tableName = eoi.getTable().getName();
        return tableName;
    }
}

