/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.base.core.util.StringUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AbstractBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.cl.ConsignLoanIntBillFactory;
import com.kingdee.eas.fm.cl.ConsignLoanIntBillInfo;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.ImAdjustIntRateCollection;
import com.kingdee.eas.fm.fin.ImLoanInfo;
import com.kingdee.eas.fm.fin.ImRepaymentBillCollection;
import com.kingdee.eas.fm.fin.ImRepaymentBillInfo;
import com.kingdee.eas.fm.fin.IntReverseInFinFacadeFactory;
import com.kingdee.eas.fm.fin.LoanAdjustInterestCollection;
import com.kingdee.eas.fm.fin.LoanAdjustInterestFactory;
import com.kingdee.eas.fm.fin.LoanAdjustInterestInfo;
import com.kingdee.eas.fm.fin.LoanCollection;
import com.kingdee.eas.fm.fin.LoanContractFactory;
import com.kingdee.eas.fm.fin.LoanContractInfo;
import com.kingdee.eas.fm.fin.LoanContractInterestInfo;
import com.kingdee.eas.fm.fin.LoanDeferCollection;
import com.kingdee.eas.fm.fin.LoanDeferFactory;
import com.kingdee.eas.fm.fin.LoanDeferInfo;
import com.kingdee.eas.fm.fin.LoanException;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.LoanInterestBookNotifyBuilder;
import com.kingdee.eas.fm.fin.LoanInterestCollection;
import com.kingdee.eas.fm.fin.LoanInterestEntryInfo;
import com.kingdee.eas.fm.fin.LoanInterestFactory;
import com.kingdee.eas.fm.fin.LoanInterestInfo;
import com.kingdee.eas.fm.fin.RepaymentCollection;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.SourceBillTypeEnum;
import com.kingdee.eas.fm.fin.StatusExtEnum;
import com.kingdee.eas.fm.fin.StrikeEnum;
import com.kingdee.eas.fm.fin.app.AbstractLoanInterestControllerBean;
import com.kingdee.eas.fm.fin.util.DeferDateInfo;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.fin.util.LoanIntPartInfoInFin;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.ft.FundTransferInterestBillFactory;
import com.kingdee.eas.fm.ft.FundTransferInterestBillInfo;
import com.kingdee.eas.fm.im.IntCalTypeEnum;
import com.kingdee.eas.fm.im.IntRateTypeCollection;
import com.kingdee.eas.fm.im.util.AbstractIntCalStragety;
import com.kingdee.eas.fm.im.util.IAdjustIntRateCollection;
import com.kingdee.eas.fm.im.util.ILoanInfo;
import com.kingdee.eas.fm.im.util.IRepaymentBillCollection;
import com.kingdee.eas.fm.im.util.IRepaymentBillInfo;
import com.kingdee.eas.fm.im.util.IntCalModel;
import com.kingdee.eas.fm.im.util.LoanInterestEntryCollection;
import com.kingdee.eas.fm.ivt.CHLoanException;
import com.kingdee.eas.fm.ivt.EntRepaymentBillInfo;
import com.kingdee.eas.fm.ivt.LoanInterestBillFactory;
import com.kingdee.eas.fm.ivt.LoanInterestBillInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LoanInterestControllerBean
extends AbstractLoanInterestControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.LoanInterestControllerBean");
    private static final String RESOURCE = "com.kingdee.eas.fm.fin.FinResource";
    private Map botpRelationShip = new HashMap();
    private Map imMap = new HashMap();
    private Map imMapRecAsFpItem = new HashMap();
    private boolean deleteRelated = false;
    private boolean hasSubmit = false;
    private static String TRANS_TABLE = "T_FT_FundTransferInterestBill";
    private static String CONSG_TABLE = "T_CL_ConsignLoanIntBill";
    private static final int ROUND = 4;
    LoanDeferCollection returnCol = new LoanDeferCollection();

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (!EmptyUtil.isEmpty((String)model.getString("id"))) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)model.getString("id").toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)((BillBaseInfo)model), (AbstractCoreBaseControllerBean)this);
        this.checkNumberDup(ctx, model);
        LoanInterestInfo infoInt = (LoanInterestInfo)model;
        infoInt.setIsGenPayBill(false);
        IObjectPK pkReturn = super._addnew(ctx, model);
        if (!infoInt.isIsPrediction()) {
            this.afterLoanInterestCreated(ctx, infoInt, pkReturn);
            infoInt.setRepaymentInfo(((LoanInterestInfo)model).getRepaymentInfo());
            this._afterSubmit(ctx, infoInt, pkReturn);
        }
        return pkReturn;
    }

    private void afterLoanInterestCreated(Context ctx, LoanInterestInfo infoInt, IObjectPK pkReturn) throws EASBizException, BOSException {
        if (infoInt.getInterestType().getValue() == 4) {
            this._afterRecIntSave(ctx, infoInt, pkReturn);
        } else if (infoInt.getInterestType().getValue() == 0 || infoInt.getInterestType().getValue() == 2) {
            // empty if block
        }
    }

    private void _afterRecIntSave(Context ctx, LoanInterestInfo infoInt, IObjectPK pkReturn) throws EASBizException, BOSException {
        this._saveBOTPRelationShip(ctx, infoInt, pkReturn);
        this._action1(ctx, infoInt);
        IntReverseInFinFacadeFactory.getLocalInstance(ctx).reverseAfterRecInt(infoInt);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        ((LoanInterestInfo)model).setStatusExtEnum(StatusExtEnum.SAVE);
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        LoanInterestInfo oldInfo;
        LoanInterestInfo intInfo = (LoanInterestInfo)model;
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)intInfo);
        boolean isAddNew = !this._exists(ctx, (IObjectPK)new ObjectUuidPK(intInfo.getId()));
        boolean bl = this.hasSubmit = !isAddNew;
        if (this.isRecSubmit(ctx, intInfo)) {
            intInfo.setStatusExtEnum(StatusExtEnum.SUBMIT);
            IObjectPK pk = super._submit(ctx, model);
            return pk;
        }
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)((LoanInterestInfo)model));
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)((BillBaseInfo)model), (AbstractCoreBaseControllerBean)this);
        intInfo.setFpItemFactor(Constants.ONE);
        boolean isNeedSubmitCheck = true;
        if (StatusExtEnum.SUBMIT.equals((Object)intInfo.getStatusExtEnum())) {
            isNeedSubmitCheck = false;
        }
        intInfo.setStatusExtEnum(StatusExtEnum.SUBMIT);
        if (null != intInfo.getId() && this._exists(ctx, (IObjectPK)new ObjectUuidPK(intInfo.getId())) && (oldInfo = this.getLoanInterestInfo(ctx, "select * where id='" + intInfo.getId().toString() + "'")) != null) {
            FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)new ObjectStringPK(oldInfo.getId().toString()));
        }
        intInfo.setStatusExtEnum(StatusExtEnum.SUBMIT);
        IObjectPK pk = super._submit(ctx, model);
        LoanInterestInfo loanInterestInfo = (LoanInterestInfo)this.getValue(ctx, pk);
        if (isAddNew && (intInfo.getInterestType().equals((Object)IntCalTypeEnum.PAY_INT) || intInfo.getInterestType().equals((Object)IntCalTypeEnum.REPAY_INT))) {
            this.afterSubmitLoanInterestInfo(ctx, loanInterestInfo);
        }
        if (intInfo.getInterestType() == IntCalTypeEnum.PRE_INT) {
            if (isNeedSubmitCheck) {
                this.submitCheck(ctx, loanInterestInfo);
            }
            this._afterSubmit(ctx, loanInterestInfo, pk);
            return pk;
        }
        this.updateFpItem(ctx, pk);
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)((LoanInterestInfo)model));
        return pk;
    }

    private boolean isRecSubmit(Context ctx, LoanInterestInfo intInfo) throws EASBizException, BOSException {
        boolean exists = this._exists(ctx, (IObjectPK)new ObjectUuidPK(intInfo.getId()));
        return intInfo.getId() != null && exists && intInfo.getInterestType().getValue() == 4;
    }

    private void submitCheck(Context ctx, LoanInterestInfo intInfo) throws EASBizException, BOSException {
        Date lastPreDate;
        Date startDate;
        if (intInfo.getInterestType() == IntCalTypeEnum.PRE_INT && (startDate = DateTimeUtils.truncateDate((Date)intInfo.getBeginDate())).compareTo(lastPreDate = this.getLastPreDate(ctx, intInfo)) <= 0) {
            if (intInfo.getNumber() != null) {
                throw new CHLoanException(CHLoanException.PREERROR, new Object[]{intInfo.getNumber()});
            }
            throw new FinBizException(FinBizException.PREERROR);
        }
    }

    private Date getLastPreDate(Context ctx, LoanInterestInfo intInfo) throws EASBizException, BOSException {
        LoanInfo info = LoanFactory.getLocalInstance(ctx).getLoanInfo((IObjectPK)new ObjectUuidPK(intInfo.getLoan().getId().toString()));
        boolean INT006 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("INT006", (IObjectPK)new ObjectUuidPK(intInfo.getCompany().getId().toString()));
        if (INT006) {
            Date lastRec;
            if (info.getLastPreIntDate() == null && info.getLastIntDate() == null) {
                Date date = info.getIssueDate();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.add(5, -1);
                return calendar.getTime();
            }
            if (info.getLastPreIntDate() == null && info.getLastIntDate() != null) {
                return info.getLastIntDate();
            }
            if (info.getLastPreIntDate() != null && info.getLastIntDate() == null) {
                return info.getLastPreIntDate();
            }
            Date lastPre = info.getLastPreIntDate();
            if (lastPre.compareTo(lastRec = info.getLastIntDate()) >= 0) {
                return lastPre;
            }
            return lastRec;
        }
        if (info.getLastPreIntDate() == null) {
            Date date = info.getIssueDate();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(5, -1);
            return calendar.getTime();
        }
        return info.getLastPreIntDate();
    }

    private void updateFpItem(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        FmMbgHelper.requestBudget((Context)ctx, (IObjectPK)pk);
    }

    private void _afterSubmit(Context ctx, LoanInterestInfo loanInterestInfo, IObjectPK pk) throws EASBizException, BOSException {
        if (loanInterestInfo.getInterestType().getValue() == 4) {
            this._afterRecIntSubmit(ctx, loanInterestInfo, pk);
        } else if (loanInterestInfo.getInterestType().getValue() == 0) {
            this._afterPreIntSubmit(ctx, loanInterestInfo, pk);
        } else if (loanInterestInfo.getInterestType().getValue() == 2) {
            this._afterRepaySubmit(ctx, loanInterestInfo, pk);
        }
        HashSet<String> adjIDSet = new HashSet<String>();
        if (!loanInterestInfo.isIsPrediction()) {
            LoanInfo loan = loanInterestInfo.getLoan();
            HashSet<String> loanIdSet = new HashSet<String>();
            loanIdSet.add(loan.getId().toString());
            LoanAdjustInterestCollection adjustColl = this.getAdjustColl(ctx, loanIdSet);
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)adjustColl)) {
                Iterator it = adjustColl.iterator();
                while (it.hasNext()) {
                    LoanAdjustInterestInfo adjInfo = (LoanAdjustInterestInfo)it.next();
                    if (adjInfo.getAdjustDate().compareTo(loanInterestInfo.getEndDate()) >= 0 || adjInfo.getAdjustDate().compareTo(loanInterestInfo.getBeginDate()) < 0) continue;
                    adjIDSet.add(adjInfo.getId().toString());
                }
            }
            if (!EmptyUtil.isEmpty(adjIDSet)) {
                this._batchUpdateLoanAdjust(ctx, adjIDSet, pk.toString());
            }
        }
    }

    private void _afterRepaySubmit(Context ctx, LoanInterestInfo loanInterestInfo, IObjectPK pk) throws EASBizException, BOSException {
        this._saveRepayBill(loanInterestInfo, ctx, pk);
        if (this.imMap.get("imid") != null) {
            LoanInterestEntryCollection iCol = ((com.kingdee.eas.fm.im.util.LoanInterestInfo)this.imMap.get("imid")).getEntries();
            for (int i = 0; i < iCol.size(); ++i) {
                com.kingdee.eas.fm.im.util.LoanInterestEntryInfo imLoanInterestInfo = iCol.get(i);
                if (FMHelper.isEmpty((String)imLoanInterestInfo.getAdjIntBillId())) continue;
                this._saveBOTPRelationShipLoanAdjust(ctx, imLoanInterestInfo.getAdjIntBillId(), loanInterestInfo);
            }
        }
        if (loanInterestInfo.getRepaymentInfo().getAddAmount().compareTo(this.getLoanPassByRepayment(ctx, loanInterestInfo.getRepaymentInfo()).getAmount()) == 0) {
            this._action1(ctx, loanInterestInfo);
        }
    }

    private void _saveRepayBill(LoanInterestInfo infoInt, Context ctx, IObjectPK pkReturn) throws EASBizException, BOSException {
        if (infoInt.getRepaymentInfo() != null) {
            RepaymentInfo info = infoInt.getRepaymentInfo();
            if (infoInt.getLoanInterestBill() == null) {
                info.setInterest(infoInt.getIntCurrencyAmt());
                info.setIsCalInt(true);
                info.setIsRepayInt(true);
                if (infoInt.getRealPunishInterest().compareTo(BigDecimal.ZERO) > 0) {
                    info.setIsCalPunishInt(true);
                }
                this._saveRepaymentBill(ctx, info);
            } else {
                BigDecimal interest = infoInt.getIntCurrencyAmt();
                boolean isCalPunishInt = false;
                if (infoInt.getRealPunishInterest().compareTo(BigDecimal.ZERO) > 0) {
                    isCalPunishInt = true;
                }
                if (interest != null) {
                    String sql = " update T_FIN_Repayment set FInterest = ? ,FPayment = ? ,FIsCalInt = ? , FIsCalPunishInt = ? ,FIsRepayInt = ? where fid = ? ";
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{interest, info.getAmount().add(interest), Boolean.TRUE, isCalPunishInt, Boolean.TRUE, info.getId().toString()});
                }
            }
            this._saveBOTPRelationShip(ctx, infoInt, pkReturn);
            if (infoInt.getRepaymentInfo().getAddAmount().compareTo(this.getLoanPassByRepayment(ctx, infoInt.getRepaymentInfo()).getAmount()) == 0) {
                IntReverseInFinFacadeFactory.getLocalInstance(ctx).reverseAfterRecInt(infoInt);
            }
        }
    }

    private void _afterPreIntSubmit(Context ctx, LoanInterestInfo loanInterestInfo, IObjectPK pk) throws EASBizException, BOSException {
        this._saveBOTPRelationShip(ctx, loanInterestInfo, pk);
        if (loanInterestInfo.getStatusExtEnum() == StatusExtEnum.SUBMIT && !this.hasSubmit) {
            IntReverseInFinFacadeFactory.getLocalInstance(ctx).reverseAfterPreInt(loanInterestInfo);
        }
    }

    private void _afterRecIntSubmit(Context ctx, LoanInterestInfo loanInterestBillInfo, IObjectPK pk) throws EASBizException, BOSException {
        this._action3(ctx, loanInterestBillInfo, pk);
    }

    private void _action3(Context ctx, LoanInterestInfo loanInterestInfo, IObjectPK pk) throws EASBizException, BOSException {
        this._book(ctx, loanInterestInfo, pk);
    }

    private void _book(Context ctx, LoanInterestInfo loanInterestInfo, IObjectPK pk) throws EASBizException, BOSException {
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            LoanInterestInfo info = (LoanInterestInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccountant(null);
                info.setFivouchered(false);
            } else {
                info.setAccountant(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                info.setFivouchered(true);
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    private CurrencyInfo _getCurrencyNumber(Context ctx, BOSUuid id) throws EASBizException, BOSException {
        CurrencyInfo info = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(id));
        return info;
    }

    private String _getAccountNumber(Context ctx, BOSUuid id) throws EASBizException, BOSException {
        InnerAccountInfo info = InnerAccountFactory.getLocalInstance((Context)ctx).getInnerAccountInfo((IObjectPK)new ObjectUuidPK(id));
        return info.getNumber();
    }

    private AbstractBankInfo _getClearingHouse(Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitInfo curent = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        BankInfo clearingHouse = BankFactory.getLocalInstance((Context)ctx).getClearingHouse(curent.getId().toString());
        return clearingHouse;
    }

    private void _action1(Context ctx, LoanInterestInfo loanInterestInfo) throws BOSException {
        SQLUtil sql1 = new SQLUtil();
        sql1.appendSql("update t_fin_loaninterest set FStrikeStatus=?,FPayInterestBillId=? ");
        sql1.appendSql("where  FEndDate<=?  and FInterestType = 0 and FLoanID = ? and FisPrediction = 0 and (fstatusextenum=0 or fstatusextenum=1) and (FStrikeStatus=? or FStrikeStatus is null)");
        String strikeEnum = "striked";
        boolean INT006 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("INT006", (IObjectPK)new ObjectUuidPK(loanInterestInfo.getCompany().getId().toString()));
        if (!INT006) {
            strikeEnum = "null";
        }
        sql1.addParams(new Object[]{strikeEnum, loanInterestInfo.getId().toString(), new java.sql.Date(loanInterestInfo.getEndDate().getTime()), loanInterestInfo.getLoan().getId().toString(), "null"});
        sql1.execute(ctx);
    }

    private void _saveBOTPRelationShip(Context ctx, LoanInterestInfo infoInt, IObjectPK pkReturn) throws BOSException {
        this.botpRelationShip.clear();
        this.botpRelationShip.put(infoInt.getLoan().getId().toString(), pkReturn.toString());
        FMHelper.saveBOTRelation((Context)ctx, (Map)this.botpRelationShip);
        if (infoInt.getRepaymentInfo() != null) {
            this.botpRelationShip.clear();
            this.botpRelationShip.put(infoInt.getRepaymentInfo().getId().toString(), pkReturn.toString());
            if (infoInt.getRepaymentInfo().getCreateFrom() != null) {
                this.botpRelationShip.put(infoInt.getRepaymentInfo().getCreateFrom(), infoInt.getRepaymentInfo().getId().toString());
            }
            FMHelper.saveBOTRelation((Context)ctx, (Map)this.botpRelationShip);
        }
    }

    private void _saveBOTPRelationShipLoanAdjust(Context ctx, String ajustId, LoanInterestInfo infoInt) throws BOSException {
        String sql = " update t_fin_loanadjustinterest set FIsUsed = 1 where fid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{ajustId});
        this.botpRelationShip.clear();
        this.botpRelationShip.put(ajustId, infoInt.getId().toString());
        FMHelper.saveBOTRelation((Context)ctx, (Map)this.botpRelationShip);
    }

    private void _batchUpdateLoanAdjust(Context ctx, Set ajustIdSet, String loanIntId) throws BOSException {
        if (!EmptyUtil.isEmpty((Collection)ajustIdSet)) {
            StringBuffer sql = new StringBuffer();
            sql.append(" update t_fin_loanadjustinterest set FIsUsed = 1 where");
            sql.append(StringUtil.buildIn((String)"fid", (Object[])ajustIdSet.toArray()) + "  ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            Iterator it = ajustIdSet.iterator();
            while (it.hasNext()) {
                this.botpRelationShip.clear();
                this.botpRelationShip.put((String)it.next(), loanIntId);
                BOTPUtil.saveBOTRelation((Context)ctx, (Map)this.botpRelationShip);
            }
        }
    }

    private void _saveRepaymentBill(Context ctx, RepaymentInfo repaymentInfo) throws EASBizException, BOSException {
        RepaymentFactory.getLocalInstance(ctx).submit((CoreBaseInfo)repaymentInfo);
    }

    protected BigDecimal _getUnVerifyAmount(Context ctx, LoanInterestInfo loanInterestInfo) throws BOSException, EASBizException {
        return Constants.ZERO;
    }

    @Override
    protected BigDecimal _getStrikeAmount(Context ctx, LoanInterestInfo loanInterestInfo) throws BOSException, EASBizException {
        StringBuffer sbSQL = new StringBuffer();
        BigDecimal returnValue = Constants.ZERO;
        sbSQL.append("select sum(FRealInterest + FRealPunishInterest) from t_fin_loaninterest ");
        sbSQL.append("where FEndDate<=?  and FInterestType=0 and  FStrikeStatus=? and floanid = ? and (fstatusextenum=0 or fstatusextenum=1) ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString(), (Object[])new Object[]{new java.sql.Date(loanInterestInfo.getEndDate().getTime()), "null", loanInterestInfo.getLoan().getId().toString()});
        try {
            if (rs.next()) {
                returnValue = rs.getBigDecimal(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (returnValue == null) {
            returnValue = Constants.ZERO;
        }
        return returnValue;
    }

    @Override
    protected LoanInterestInfo _calInt(Context ctx, Date startDate, Date endDate, RepaymentInfo repaymentInfo) throws BOSException, EASBizException {
        List li = this.getAllDeferDate(ctx);
        LoanInfo loanInfo = this.getLoanPassByRepayment(ctx, repaymentInfo);
        String loanid = loanInfo.getId().toString();
        HashSet<String> loanIDSet = new HashSet<String>();
        loanIDSet.add(loanid);
        LoanDeferCollection loanDeferColl = this.getLoanDeferColl(ctx, loanIDSet);
        LoanAdjustInterestCollection adjustColl = this.getAdjustColl(ctx, loanIDSet);
        RepaymentCollection repayColl = this.getRepayColl(ctx, loanIDSet);
        LoanCollection loanColl = this.getLoanColl(ctx, loanIDSet);
        LoanDeferCollection byIDsDefer = null;
        RepaymentCollection byIDsRepay = null;
        LoanAdjustInterestCollection byIDsAdjust = null;
        LoanInfo info = null;
        byIDsDefer = this.filterDeferByID(loanDeferColl, loanid);
        byIDsRepay = this.filterRepayByID(repayColl, loanid);
        byIDsAdjust = this.filterAdjustByID(adjustColl, loanid);
        info = this.filterLoanInfoByID(loanColl, loanid);
        IntCalModel model = this.getIntCalModel(startDate, endDate, info, byIDsAdjust, byIDsRepay, repaymentInfo, true);
        com.kingdee.eas.fm.im.util.LoanInterestInfo loanIntInfo = AbstractIntCalStragety.getInstance((IntCalTypeEnum)IntCalTypeEnum.REPAY_INT).calInt(ctx, model);
        this.imMap.put("imid", loanIntInfo);
        return this.transfrom(ctx, loanIntInfo, loanInfo, repaymentInfo);
    }

    private IntCalModel getIntCalModel(Date startDate, Date endDate, LoanInfo loanInfo, LoanAdjustInterestCollection adjColl, RepaymentCollection repayColl, RepaymentInfo repayInfo, boolean expireNoInterest) {
        ImLoanInfo iLoanInfo = new ImLoanInfo(loanInfo);
        ImAdjustIntRateCollection iAdjColl = new ImAdjustIntRateCollection(adjColl);
        ImRepaymentBillCollection iRepayColl = new ImRepaymentBillCollection(repayColl);
        ImRepaymentBillInfo iRepayInfo = new ImRepaymentBillInfo(repayInfo);
        IntCalModel model = new IntCalModel();
        model.setBeginDate(startDate);
        if (iLoanInfo.getExpiredDate().compareTo(endDate) < 0 && expireNoInterest) {
            model.setEndDate(iLoanInfo.getExpiredDate());
        } else {
            model.setEndDate(endDate);
        }
        model.setLoanInfo((ILoanInfo)iLoanInfo);
        model.setAdjIntRateColl((IAdjustIntRateCollection)iAdjColl);
        model.setRepayColl((IRepaymentBillCollection)iRepayColl);
        model.setRepayInfo((IRepaymentBillInfo)iRepayInfo);
        if (startDate != null) {
            model.setNewRequirement(true);
        } else {
            model.setNewRequirement(false);
        }
        return model;
    }

    private LoanInterestInfo transfrom(Context ctx, com.kingdee.eas.fm.im.util.LoanInterestInfo imIntInfo, LoanInfo loanInfo, RepaymentInfo repaymentInfo) throws FinBizException, EASBizException, BOSException {
        CompanyOrgUnitInfo CURRENT_COMPANY = loanInfo.getCompany();
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        BigDecimal interest = Constants.ZERO;
        BigDecimal punishInterest = Constants.ZERO;
        LoanInterestInfo finIntInfo = new LoanInterestInfo();
        LoanInterestEntryCollection imIntCol = imIntInfo.getEntries();
        for (int i = 0; i < imIntCol.size(); ++i) {
            com.kingdee.eas.fm.im.util.LoanInterestEntryInfo imEntryInfo = imIntCol.get(i);
            LoanInterestEntryInfo finEntryInfo = new LoanInterestEntryInfo();
            finEntryInfo.setSeq(imEntryInfo.getSeq());
            finEntryInfo.setBeginDate(imEntryInfo.getBeginDate());
            finEntryInfo.setEndDate(imEntryInfo.getEndDate());
            finEntryInfo.setDays(imEntryInfo.getDays());
            finEntryInfo.setAmount(this.processScale(ctx, imIntInfo, imEntryInfo.getPrincipal(), CURRENT_COMPANY));
            finEntryInfo.setIntRate(imEntryInfo.getIntRate());
            finEntryInfo.setInterest(this.processScale(ctx, imIntInfo, imEntryInfo.getInterest(), CURRENT_COMPANY));
            finEntryInfo.setYearDays(imEntryInfo.getConvertDays());
            finEntryInfo.setIntRateTypeExpression(imEntryInfo.getIntRateTypeExp());
            finEntryInfo.setDaysOverdue(imEntryInfo.getOverdueDays());
            finEntryInfo.setPunishIntRate(imEntryInfo.getPunishIntRate());
            finEntryInfo.setPunishInterest(this.processScale(ctx, imIntInfo, imEntryInfo.getPunishInterest(), CURRENT_COMPANY));
            finIntInfo.getEntrys().add(finEntryInfo);
        }
        finIntInfo.setRepaymentInfo(repaymentInfo);
        finIntInfo.setRepayment(repaymentInfo);
        finIntInfo.setLoan(loanInfo);
        finIntInfo.setProject(loanInfo.getProject());
        finIntInfo.setIntFeeAcctView(loanInfo.getIntFeeAcctView());
        finIntInfo.setAccount(loanInfo.getBankAcct());
        finIntInfo.setInterestType(imIntInfo.getIntCalType());
        if (loanInfo.getInstitution() != null) {
            finIntInfo.setCreditorAsBank(loanInfo.getInstitution());
        } else {
            finIntInfo.setCreditorAsCompany(loanInfo.getGroupID());
        }
        finIntInfo.setCompany(repaymentInfo == null ? CURRENT_COMPANY : repaymentInfo.getCompany());
        finIntInfo.setCurrency(imIntInfo.getCurrency());
        finIntInfo.setExchange(FinUtils.getCurrencyExRate(ctx, CURRENT_COMPANY.getId(), loanInfo.getCurrency().getId(), CURRENT_COMPANY.getBaseCurrency().getId(), new Date()));
        finIntInfo.setBizDate(imIntInfo.getBizDate());
        finIntInfo.setBeginDate(imIntInfo.getBeginDate());
        finIntInfo.setEndDate(imIntInfo.getEndDate());
        finIntInfo.setDays(imIntInfo.getDays());
        finIntInfo.setAmount(this.processScale(ctx, imIntInfo, imIntInfo.getPrincipal(), CURRENT_COMPANY));
        finIntInfo.setIntRate(imIntInfo.getIntRate());
        finIntInfo.setDaysOverdue(imIntInfo.getOverdueDays());
        finIntInfo.setPunishIntType(imIntInfo.getPunishType());
        finIntInfo.setPunishIntRate(imIntInfo.getPunishIntRate());
        punishInterest = this.processScale(ctx, imIntInfo, imIntInfo.getPunishInterest(), CURRENT_COMPANY);
        finIntInfo.setPunishInterest(punishInterest);
        interest = this.processScale(ctx, imIntInfo, imIntInfo.getInterest(), CURRENT_COMPANY);
        finIntInfo.setInterest(interest);
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        boolean INT006 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("INT006", (IObjectPK)new ObjectUuidPK(finIntInfo.getCompany().getId().toString()));
        if (!INT006 || finIntInfo.getInterestType() == IntCalTypeEnum.PRE_INT) {
            finIntInfo.setStrikeAmount(Constants.ZERO);
        } else {
            finIntInfo.setStrikeAmount(this.calcStrikeAmount(ctx, finIntInfo, repaymentInfo));
        }
        finIntInfo.setStrikeStatus(StrikeEnum.NULL);
        finIntInfo.setFivouchered(false);
        finIntInfo.setRealPunishInterest(punishInterest);
        finIntInfo.setRealInterest(interest);
        finIntInfo.setIntRateTypeExpression(imIntInfo.getIntRateTypeExp());
        finIntInfo.setLastIntDate(imIntInfo.getLastIntDate());
        finIntInfo.setCreator(user);
        finIntInfo.setIntFeeAcctView(loanInfo.getIntFeeAcctView());
        finIntInfo.setIsBond(loanInfo.isIsBonds());
        return finIntInfo;
    }

    private BigDecimal processScale(Context ctx, com.kingdee.eas.fm.im.util.LoanInterestInfo imIntInfo, BigDecimal interest, CompanyOrgUnitInfo CURRENT_COMPANY) throws EASBizException, BOSException {
        return FMHelper.getBigDecimalByScale((Context)ctx, (BigDecimal)interest, (CurrencyInfo)imIntInfo.getCurrency(), (CompanyOrgUnitInfo)CURRENT_COMPANY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchPreInt(Context ctx, Set loanIDSet, Date startDate, Date endDate, boolean isCalculate, boolean expireNoInterest) throws BOSException, EASBizException {
        List idList = FMHelper.set2List((Set)loanIDSet);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList appliedList = new ArrayList();
        try {
            Boolean boolResult;
            int i;
            Map resultRequest = iMutex.batchRequestObjIDForUpdate(idList);
            for (i = 0; i < idList.size(); ++i) {
                boolResult = (Boolean)resultRequest.get(idList.get(i));
                if (!boolResult.booleanValue()) continue;
                appliedList.add(idList.get(i));
            }
            for (i = 0; i < idList.size(); ++i) {
                boolResult = (Boolean)resultRequest.get(idList.get(i));
                if (boolResult.booleanValue()) continue;
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"147_LoanInterestControllerBean", (Locale)ctx.getLocale())});
            }
            HashMap<String, Object> hm = new HashMap<String, Object>();
            String errorMsgHeader = EASCommonResource.getString((String)RESOURCE, (String)"preInt_error_header", (Locale)ctx.getLocale());
            LoanInterestInfo loanInterestInfo = null;
            HashSet<IObjectPK> createdIntReceivedID = new HashSet<IObjectPK>();
            String loanID2 = "";
            StringBuffer sb = new StringBuffer();
            LoanAdjustInterestCollection adjustColl = this.getAdjustColl(ctx, loanIDSet);
            RepaymentCollection repayColl = this.getRepayColl(ctx, loanIDSet);
            LoanCollection loanColl = this.getLoanColl(ctx, loanIDSet);
            RepaymentCollection byIDsRepay = null;
            LoanAdjustInterestCollection byIDsAdjust = null;
            LoanInfo info = null;
            int successCount = 0;
            int failCount = 0;
            for (String loanID2 : loanIDSet) {
                byIDsRepay = this.filterRepayByID(repayColl, loanID2);
                byIDsAdjust = this.filterAdjustByID(adjustColl, loanID2);
                info = this.filterLoanInfoByID(loanColl, loanID2);
                IntCalModel model = this.getIntCalModel(startDate, endDate, info, byIDsAdjust, byIDsRepay, null, expireNoInterest);
                IObjectPK pk = null;
                com.kingdee.eas.fm.im.util.LoanInterestInfo imIntInfo = null;
                try {
                    imIntInfo = AbstractIntCalStragety.getInstance((IntCalTypeEnum)IntCalTypeEnum.PRE_INT).calInt(ctx, model);
                }
                catch (Exception e) {
                    ++failCount;
                    sb.append(info.getNumber()).append(errorMsgHeader).append(e.getMessage()).append("\n");
                    continue;
                }
                if (!EmptyUtil.isEmpty((Object)imIntInfo)) {
                    loanInterestInfo = this.transfrom(ctx, imIntInfo, info, null);
                    this.setLoanInterestDefault(loanInterestInfo);
                    if (isCalculate) {
                        loanInterestInfo.setInterestType(IntCalTypeEnum.CALCULATE);
                        pk = super.save(ctx, (CoreBaseInfo)loanInterestInfo);
                    } else {
                        this.submitCheck(ctx, loanInterestInfo);
                        pk = super.submit(ctx, (CoreBaseInfo)loanInterestInfo);
                    }
                    LoanInterestEntryCollection iCol = imIntInfo.getEntries();
                    for (int i2 = 0; i2 < iCol.size(); ++i2) {
                        com.kingdee.eas.fm.im.util.LoanInterestEntryInfo imLoanInterestInfo = iCol.get(i2);
                        if (FMHelper.isEmpty((String)imLoanInterestInfo.getAdjIntBillId())) continue;
                        this._saveBOTPRelationShipLoanAdjust(ctx, imLoanInterestInfo.getAdjIntBillId(), loanInterestInfo);
                    }
                    createdIntReceivedID.add(pk);
                    this.batchPreInt4WF(ctx, pk.toString());
                }
                ++successCount;
            }
            hm.put("createdID", createdIntReceivedID);
            hm.put("successCount", successCount);
            hm.put("failCount", failCount);
            if (sb.length() > 0) {
                String msg = EASCommonResource.getString((String)RESOURCE, (String)"followLoanPreError", (Locale)ctx.getLocale()) + sb.toString();
                hm.put("failureMsg", msg);
            }
            HashMap<String, Object> hashMap = hm;
            return hashMap;
        }
        finally {
            if (appliedList.size() > 0) {
                iMutex.batchReleaseObjIDForUpdate(appliedList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchRecInt(Context ctx, Set loanIDSet, Date startDate, Date endDate, boolean expireNoInterest) throws BOSException, EASBizException {
        List idList = FMHelper.set2List((Set)loanIDSet);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList appliedList = new ArrayList();
        try {
            Boolean boolResult;
            int i;
            Map resultRequest = iMutex.batchRequestObjIDForUpdate(idList);
            for (i = 0; i < idList.size(); ++i) {
                boolResult = (Boolean)resultRequest.get(idList.get(i));
                if (!boolResult.booleanValue()) continue;
                appliedList.add(idList.get(i));
            }
            for (i = 0; i < idList.size(); ++i) {
                boolResult = (Boolean)resultRequest.get(idList.get(i));
                if (boolResult.booleanValue()) continue;
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"147_LoanInterestControllerBean", (Locale)ctx.getLocale())});
            }
            HashMap<String, Object> hm = new HashMap<String, Object>();
            LoanInterestInfo loanInterestInfo = null;
            HashSet<IObjectPK> createdIntReceivedID = new HashSet<IObjectPK>();
            String errorMsgHeader = EASCommonResource.getString((String)RESOURCE, (String)"payInt_error_header", (Locale)ctx.getLocale());
            StringBuffer sb = new StringBuffer();
            LoanAdjustInterestCollection adjustColl = this.getAdjustColl(ctx, loanIDSet);
            RepaymentCollection repayColl = this.getRepayColl(ctx, loanIDSet);
            LoanCollection loanColl = this.getLoanColl(ctx, loanIDSet);
            IntRateTypeCollection intRateTypeColl = null;
            Object intRateTypeInfo = null;
            RepaymentCollection byIDsRepay = null;
            LoanAdjustInterestCollection byIDsAdjust = null;
            LoanInfo info = null;
            int successCount = 0;
            int failCount = 0;
            for (String loanid : loanIDSet) {
                byIDsRepay = this.filterRepayByID(repayColl, loanid);
                byIDsAdjust = this.filterAdjustByID(adjustColl, loanid);
                intRateTypeColl = this.filterIntRateTypeByID(adjustColl, loanid);
                info = this.filterLoanInfoByID(loanColl, loanid);
                IntCalModel model = this.getIntCalModel(startDate, endDate, info, byIDsAdjust, byIDsRepay, null, expireNoInterest);
                com.kingdee.eas.fm.im.util.LoanInterestInfo imIntInfo = null;
                try {
                    imIntInfo = AbstractIntCalStragety.getInstance((IntCalTypeEnum)IntCalTypeEnum.PAY_INT).calInt(ctx, model);
                }
                catch (FinBizException e) {
                    ++failCount;
                    if ("129".equals(e.getSubCode())) {
                        sb.append(info.getNumber()).append(errorMsgHeader).append(e.getMessage()).append("\n");
                        continue;
                    }
                    sb.append(info.getNumber()).append(errorMsgHeader).append(e.getMessage()).append("\n");
                    continue;
                }
                catch (Exception e) {
                    ++failCount;
                    sb.append(info.getNumber()).append(errorMsgHeader).append(e.getMessage()).append("\n");
                    continue;
                }
                if (!EmptyUtil.isEmpty((Object)imIntInfo)) {
                    loanInterestInfo = this.transfrom(ctx, imIntInfo, info, null);
                    this.setLoanInterestDefault(loanInterestInfo);
                    IObjectPK pk = null;
                    pk = FmMbgHelper.isCtrl((Context)ctx, (BOSObjectType)loanInterestInfo.getBOSType()) ? this._save(ctx, (IObjectValue)loanInterestInfo) : super.submit(ctx, (CoreBaseInfo)loanInterestInfo);
                    LoanInterestEntryCollection iCol = imIntInfo.getEntries();
                    for (int i2 = 0; i2 < iCol.size(); ++i2) {
                        com.kingdee.eas.fm.im.util.LoanInterestEntryInfo imLoanInterestInfo = iCol.get(i2);
                        if (FMHelper.isEmpty((String)imLoanInterestInfo.getAdjIntBillId())) continue;
                        this._saveBOTPRelationShipLoanAdjust(ctx, imLoanInterestInfo.getAdjIntBillId(), loanInterestInfo);
                    }
                    createdIntReceivedID.add(pk);
                    this.batchRecInt4WF(ctx, pk.toString());
                }
                ++successCount;
            }
            hm.put("createdID", createdIntReceivedID);
            hm.put("successCount", successCount);
            hm.put("failCount", failCount);
            if (sb.length() > 0) {
                String msg = EASCommonResource.getString((String)RESOURCE, (String)"followLoanRecError", (Locale)ctx.getLocale()) + sb.toString();
                hm.put("failureMsg", msg);
            }
            HashMap<String, Object> hashMap = hm;
            return hashMap;
        }
        finally {
            if (appliedList.size() > 0) {
                iMutex.batchReleaseObjIDForUpdate(appliedList);
            }
        }
    }

    @Override
    protected List _getInteretByLoan(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sql = "select fintcaltype,fenddate from t_ivt_loaninterestbill where floanbillid = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
        ArrayList<LoanIntPartInfoInFin> returnLi = new ArrayList<LoanIntPartInfoInFin>();
        LoanIntPartInfoInFin loanIntPartInfoInFin = null;
        try {
            while (rs.next()) {
                loanIntPartInfoInFin = new LoanIntPartInfoInFin(rs.getInt(1), rs.getDate(2));
                returnLi.add(loanIntPartInfoInFin);
            }
        }
        catch (SQLException e) {
            throw new EASBizException(EASBizException.DBDEADLOCK);
        }
        return returnLi;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanInterestInfo loanInterestInfo = this.getLoanInterestInfo(ctx, pk);
        this._deleteCheck(ctx, loanInterestInfo);
        this._afterDelete(ctx, loanInterestInfo);
        Map relMap = this.getAdjustRelation(ctx, loanInterestInfo);
        NumberRuleUtil.recycleNumber((Context)ctx, (CoreBaseInfo)loanInterestInfo, (String)loanInterestInfo.getCompany().getId().toString());
        FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)pk);
        super._delete(ctx, pk);
        LoanInterestBillInfo intBillInfo = loanInterestInfo.getLoanInterestBill();
        FundTransferInterestBillInfo fundIntInfo = loanInterestInfo.getFundTransferIntBill();
        ConsignLoanIntBillInfo consIntInfo = loanInterestInfo.getConsignLoanIntBill();
        if (intBillInfo != null) {
            this.updateLoanInterestBill(ctx, intBillInfo.getId().toString(), true);
        } else if (fundIntInfo != null) {
            this.updateIsGenLoanInt(ctx, TRANS_TABLE, fundIntInfo.getId().toString(), true);
        } else if (consIntInfo != null) {
            this.updateIsGenLoanInt(ctx, CONSG_TABLE, consIntInfo.getId().toString(), true);
        }
        this.updateAdjust(ctx, loanInterestInfo, relMap);
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
    }

    private Map getAdjustRelation(Context ctx, LoanInterestInfo loanInterestInfo) throws BOSException, EASBizException {
        HashMap<String, Object> relMap = new HashMap<String, Object>();
        Connection cn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = " select FSrcEntityID,FDestEntityID,FSrcObjectID from t_bot_relation where FDestObjectID = ? and FSrcEntityID = '08A5079B' ";
        try {
            cn = this.getConnection(ctx);
            String srcEntityID = null;
            String destEntityID = null;
            String srcObjectID = null;
            pstmt = cn.prepareStatement(sql);
            pstmt.setString(1, loanInterestInfo.getId().toString());
            rs = pstmt.executeQuery();
            int number = 0;
            while (rs.next()) {
                srcEntityID = rs.getString(1);
                destEntityID = rs.getString(2);
                srcObjectID = rs.getString(3);
                relMap.put("srcEntityID" + ++number, srcEntityID);
                relMap.put("destEntityID" + number, destEntityID);
                relMap.put("srcObjectID" + number, srcObjectID);
            }
            relMap.put("number", new Integer(number));
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
        return relMap;
    }

    private void afterSubmitLoanInterestInfo(Context ctx, LoanInterestInfo interestInfo) throws BOSException, EASBizException {
        LoanInfo loanInfo;
        if (!EmptyUtil.isEmpty((CoreBaseInfo)interestInfo.getLoan()) && !interestInfo.isIsPrediction() && FMHelper.isInstanceof((String)(loanInfo = LoanFactory.getLocalInstance(ctx).getLoanInfo((IObjectPK)new ObjectUuidPK(interestInfo.getLoan().getId().toString()))).getSourceBillId(), LoanContractInfo.class)) {
            LoanContractInfo loanContractInfo = LoanContractFactory.getLocalInstance(ctx).getLoanContractInfo((IObjectPK)new ObjectUuidPK(loanInfo.getSourceBillId().toString()));
            LoanContractInterestInfo entryInfo = new LoanContractInterestInfo();
            entryInfo.setLoanId(loanInfo.getId().toString());
            entryInfo.setLoanNumber(loanInfo.getNumber());
            entryInfo.setInterestNumber(interestInfo.getNumber());
            entryInfo.setInterestType(interestInfo.getInterestType().getAlias());
            entryInfo.setBeginDate(interestInfo.getBeginDate());
            entryInfo.setEndDate(interestInfo.getEndDate());
            entryInfo.setActInterest(interestInfo.getRealInterest());
            entryInfo.setInterestLocalAmt(interestInfo.getRealInterest().multiply(interestInfo.getExchange()));
            loanContractInfo.getLoanContractInterest().add(entryInfo);
            this.fillLoanContractOverView(ctx, loanContractInfo, loanInfo, interestInfo, BOTBillOperStateEnum.ADDNEW);
            LoanContractFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(loanContractInfo.getId().toString()), (CoreBaseInfo)loanContractInfo);
        }
    }

    private void afterDeleteLoanInterestInfo(Context ctx, LoanInterestInfo interestInfo) throws BOSException, EASBizException {
        LoanInfo loanInfo;
        if (!EmptyUtil.isEmpty((CoreBaseInfo)interestInfo.getLoan()) && FMHelper.isInstanceof((String)(loanInfo = LoanFactory.getLocalInstance(ctx).getLoanInfo((IObjectPK)new ObjectUuidPK(interestInfo.getLoan().getId().toString()))).getSourceBillId(), LoanContractInfo.class)) {
            LoanContractInfo loanContractInfo = LoanContractFactory.getLocalInstance(ctx).getLoanContractInfo((IObjectPK)new ObjectUuidPK(loanInfo.getSourceBillId().toString()));
            for (int i = 0; i < loanContractInfo.getLoanContractInterest().size(); ++i) {
                LoanContractInterestInfo entryInfo = loanContractInfo.getLoanContractInterest().get(i);
                if (!entryInfo.getInterestNumber().equals(interestInfo.getNumber())) continue;
                loanContractInfo.getLoanContractInterest().remove(entryInfo);
            }
            this.fillLoanContractOverView(ctx, loanContractInfo, loanInfo, interestInfo, BOTBillOperStateEnum.DELETE);
            LoanContractFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(loanContractInfo.getId().toString()), (CoreBaseInfo)loanContractInfo);
        }
    }

    private void fillLoanContractOverView(Context ctx, LoanContractInfo info, LoanInfo loanInfo, LoanInterestInfo interestInfo, BOTBillOperStateEnum bOTBillOperStateEnum) throws BOSException, EASBizException {
        if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
            BigDecimal preInterestAllAmt = info.getLoanContractOverView().get(0).getPreInterestAmt() == null ? new BigDecimal(0) : info.getLoanContractOverView().get(0).getPreInterestAmt();
            BigDecimal allPaidInterest = info.getLoanContractOverView().get(0).getPaidInterest() == null ? new BigDecimal(0) : info.getLoanContractOverView().get(0).getPaidInterest();
            BigDecimal paidInterest = interestInfo.getRealInterest() == null ? new BigDecimal(0) : interestInfo.getRealInterest();
            allPaidInterest = allPaidInterest.subtract(paidInterest);
            info.getLoanContractOverView().get(0).setPaidInterest(allPaidInterest);
            info.getLoanContractOverView().get(0).setPreInterestUnPaidAmt(preInterestAllAmt.subtract(allPaidInterest));
        } else {
            BigDecimal preInterestAllAmt = info.getLoanContractOverView().get(0).getPreInterestAmt() == null ? new BigDecimal(0) : info.getLoanContractOverView().get(0).getPreInterestAmt();
            BigDecimal allPaidInterest = info.getLoanContractOverView().get(0).getPaidInterest() == null ? new BigDecimal(0) : info.getLoanContractOverView().get(0).getPaidInterest();
            BigDecimal paidInterest = interestInfo.getRealInterest() == null ? new BigDecimal(0) : interestInfo.getRealInterest();
            allPaidInterest = allPaidInterest.add(paidInterest);
            info.getLoanContractOverView().get(0).setPaidInterest(allPaidInterest);
            info.getLoanContractOverView().get(0).setPreInterestUnPaidAmt(preInterestAllAmt.subtract(allPaidInterest));
        }
    }

    private void updateAdjust(Context ctx, LoanInterestInfo loanInterestInfo, Map relMap) throws BOSException, EASBizException {
        String sql1 = " select FID from t_bot_relation where FSrcObjectID = ? and FSrcEntityID =? ";
        int number = (Integer)relMap.get("number");
        Connection cn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        cn = this.getConnection(ctx);
        try {
            for (int i = 1; i <= number; ++i) {
                String srcObjectID = relMap.get("srcObjectID" + i).toString();
                String srcEntityID = relMap.get("srcEntityID" + i).toString();
                String fid = null;
                if (pstmt != null) {
                    pstmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
                pstmt = cn.prepareStatement(sql1);
                pstmt.setString(1, srcObjectID);
                pstmt.setString(2, srcEntityID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    fid = rs.getString(1);
                }
                if (fid != null) continue;
                String sql2 = " update t_fin_loanadjustinterest set FIsUsed = 0 where fid = ?";
                DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{srcObjectID});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs, pstmt, (Connection)cn);
        }
    }

    private void _deleteCheck(Context ctx, LoanInterestInfo loanInterestInfo) throws EASBizException, BOSException {
        if (loanInterestInfo.getStrikeStatus() != null && loanInterestInfo.getStrikeStatus() == StrikeEnum.STRIKED) {
            throw new FinBizException(FinBizException.LOANINTEREST_STRIKED_ERROR);
        }
        if (!this.deleteRelated && loanInterestInfo.getInterestType() == IntCalTypeEnum.REPAY_INT) {
            throw new CHLoanException(CHLoanException.INT_DELETE_ERROR2);
        }
        if (loanInterestInfo.getCashier() != null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"320_LoanInterestListUI", (Locale)ctx.getLocale()));
        }
        if (loanInterestInfo.isIsGenPayBill()) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"321_LoanInterestListUI", (Locale)ctx.getLocale()));
        }
        if (loanInterestInfo.isFivouchered()) {
            throw new FinBizException(FinBizException.INT_DELETE_ERROR1);
        }
        if (loanInterestInfo.getStatusExtEnum() == StatusExtEnum.AUDIT) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"322_LoanInterestListUI", (Locale)ctx.getLocale()));
        }
        if (!loanInterestInfo.getInterestType().equals((Object)IntCalTypeEnum.CALCULATE)) {
            this._check(loanInterestInfo, ctx);
        }
    }

    private void _check(LoanInterestInfo loanInterestInfo, Context ctx) throws BOSException, EASBizException {
        this._checkIsLastInt(loanInterestInfo, ctx);
        if (loanInterestInfo.getInterestType().getValue() == 0) {
            this._deletePreIntCheck(loanInterestInfo, ctx);
        }
        if (loanInterestInfo.getStatusExtEnum() == StatusExtEnum.AUDIT) {
            throw new FinBizException(FinBizException.INT_DELETE_ERROR5, new Object[]{loanInterestInfo.getNumber()});
        }
    }

    private void _deletePreIntCheck(LoanInterestInfo loanInterestInfo, Context ctx) throws BOSException, EASBizException {
        String sql = "select fid from t_fin_loaninterest where fstrikestatus = ? and fid = ? and FisPrediction = 0 ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{"striked", loanInterestInfo.getId().toString()});
        try {
            if (rs.next()) {
                throw new FinBizException(FinBizException.INT_DELETE_ERROR4);
            }
        }
        catch (SQLException e) {
            throw new FinBizException(FinBizException.INT_DELETE_ERROR4);
        }
    }

    private void _checkIsLastInt(LoanInterestInfo loanInterestInfo, Context ctx) throws BOSException, EASBizException {
        if (loanInterestInfo.getInterestType() == IntCalTypeEnum.PRE_INT) {
            this.deletePreInt(loanInterestInfo, ctx);
        } else {
            this.deleteOther(loanInterestInfo, ctx);
        }
    }

    private void deletePreInt(LoanInterestInfo loanInterestBillInfo, Context ctx) throws BOSException, CHLoanException {
        if (loanInterestBillInfo.getStatusExtEnum() != StatusExtEnum.SAVE) {
            String sql = "select max(fenddate) from t_fin_loaninterest where FInterestType = ? and floanid = ? and FisPrediction = 0 ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(loanInterestBillInfo.getInterestType().getValue()), loanInterestBillInfo.getLoan().getId().toString()});
            Date billEndDate = DateTimeUtils.truncateDate((Date)loanInterestBillInfo.getEndDate());
            try {
                if (rs.next()) {
                    Date maxEndDate = new Date(rs.getDate(1).getTime());
                    if (billEndDate.compareTo(maxEndDate = DateTimeUtils.truncateDate((Date)maxEndDate)) < 0) {
                        throw new CHLoanException(CHLoanException.INT_DELETE_ERROR3);
                    }
                }
            }
            catch (SQLException e) {
                throw new CHLoanException(CHLoanException.INT_DELETE_ERROR3);
            }
        }
    }

    private void deleteOther(LoanInterestInfo loanInterestBillInfo, Context ctx) throws BOSException, EASBizException {
        String sql = "select max(fenddate) from t_fin_loaninterest where (FInterestType = ? or FInterestType=?) and floanid = ? and FisPrediction = 0 ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(2), new Integer(4), loanInterestBillInfo.getLoan().getId().toString()});
        Date billEndDate = DateTimeUtils.truncateDate((Date)loanInterestBillInfo.getEndDate());
        try {
            if (rs.next()) {
                Date maxEndDate = new Date(rs.getDate(1).getTime());
                if (billEndDate.compareTo(maxEndDate = DateTimeUtils.truncateDate((Date)maxEndDate)) < 0) {
                    throw new CHLoanException(CHLoanException.INT_DELETE_ERROR3);
                }
            }
        }
        catch (SQLException e) {
            throw new CHLoanException(CHLoanException.INT_DELETE_ERROR3);
        }
    }

    private void _afterDelete(Context ctx, LoanInterestInfo loanInterestInfo) throws EASBizException, BOSException {
        if (loanInterestInfo.getInterestType().getValue() == 2) {
            String repayBillID = loanInterestInfo.getRepayment().getId().toString();
            boolean isRepayAllBill = this.isRepayAllBill(ctx, repayBillID);
            if (isRepayAllBill) {
                this._action4(ctx, loanInterestInfo);
                this._reverseDate(ctx, loanInterestInfo);
            }
            this.afterDeleteLoanInterestInfo(ctx, loanInterestInfo);
        } else if (loanInterestInfo.getInterestType().getValue() == 4) {
            this._action4(ctx, loanInterestInfo);
            this._reverseDate(ctx, loanInterestInfo);
            this.afterDeleteLoanInterestInfo(ctx, loanInterestInfo);
        } else {
            this._reverseDate(ctx, loanInterestInfo);
        }
    }

    private boolean isRepayAllBill(Context ctx, String repayBillID) throws BOSException {
        boolean isRepayAllBill = false;
        String sql = " select t_fin_repayment.FAddAmount,t_fin_loan.FAmount from  t_fin_repayment,t_fin_loan where t_fin_repayment.FSourceBillID = t_fin_loan.fid  and t_fin_repayment.fid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{repayBillID});
        BigDecimal loanAmtTotal = Constants.ZERO;
        BigDecimal repayAmtTotal = Constants.ZERO;
        try {
            if (rs.next()) {
                repayAmtTotal = rs.getBigDecimal(1);
                isRepayAllBill = repayAmtTotal.compareTo(loanAmtTotal = rs.getBigDecimal(2)) == 0;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return isRepayAllBill;
    }

    private void _reverseDate(Context ctx, LoanInterestInfo loanInterestInfo) throws EASBizException, BOSException {
        IntReverseInFinFacadeFactory.getLocalInstance(ctx).reverseAfterDelete(loanInterestInfo);
    }

    private void _action4(Context ctx, LoanInterestInfo loanInterestInfo) throws BOSException {
        if (loanInterestInfo.getInterestType() == IntCalTypeEnum.PAY_INT || loanInterestInfo.getInterestType() == IntCalTypeEnum.REPAY_INT) {
            StringBuffer sql = new StringBuffer();
            sql.append("update t_fin_loaninterest set FStrikeStatus=?,FPayInterestBillId=null ");
            sql.append("where FPayInterestBillId=? and FInterestType=0 and FLoanID = ? and FisPrediction = 0 ");
            String billid = loanInterestInfo.getLoan().getId().toString();
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{"null", loanInterestInfo.getId().toString(), billid});
        }
    }

    private void _antiBook(Context ctx, LoanInterestInfo loanInterestBillInfo) throws EASBizException, BOSException {
        SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).cancelBook(loanInterestBillInfo.getId().toString());
    }

    @Override
    protected void _checkSeq(Context ctx, LoanInterestInfo loanInterestInfo) throws BOSException, EASBizException {
    }

    @Override
    protected void _deleteRaleted(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fil = new FilterInfo();
        fil.getFilterItems().add(new FilterItemInfo("repayment.id", (Object)pk));
        evi.setFilter(fil);
        LoanInterestCollection col = LoanInterestFactory.getLocalInstance(ctx).getLoanInterestCollection(evi);
        for (int i = 0; i < col.size(); ++i) {
            this.deleteRelated = true;
            this.delete(ctx, (IObjectPK)new ObjectUuidPK(col.get(i).getId()));
        }
    }

    private List getAllDeferDate(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FLoanID,FBeforeDeferDate from T_FIN_LOANDEFER where  FSeq = 1");
        ArrayList<DeferDateInfo> li = new ArrayList<DeferDateInfo>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            Date firstExpDateBeforeDefer = new Date();
            DeferDateInfo info = null;
            while (rs.next()) {
                String id = rs.getString(1);
                java.sql.Date d = rs.getDate(2);
                firstExpDateBeforeDefer = d != null ? DateTimeUtils.truncateDate((Date)new Date(d.getTime())) : null;
                info = new DeferDateInfo(id, firstExpDateBeforeDefer);
                li.add(info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return li;
    }

    private LoanDeferCollection getLoanDeferColl(Context ctx, Set loanIDSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loan.id", (Object)loanIDSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("beforeDeferDate"));
        return LoanDeferFactory.getLocalInstance(ctx).getLoanDeferCollection(evi);
    }

    private LoanAdjustInterestCollection getAdjustColl(Context ctx, Set loanIDSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loan.id", (Object)loanIDSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("adjustDate"));
        evi.getSelector().add(new SelectorItemInfo("*"));
        return LoanAdjustInterestFactory.getLocalInstance(ctx).getLoanAdjustInterestCollection(evi);
    }

    private RepaymentCollection getRepayColl(Context ctx, Set loanIDSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)loanIDSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("BankAcct.name"));
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("bizDate"));
        return RepaymentFactory.getLocalInstance(ctx).getRepaymentCollection(evi);
    }

    private LoanCollection getLoanColl(Context ctx, Set loanIDSet) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)loanIDSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("company.*"));
        evi.getSelector().add(new SelectorItemInfo("Institution.name"));
        evi.getSelector().add(new SelectorItemInfo("Currency.name"));
        evi.getSelector().add(new SelectorItemInfo("Currency.number"));
        evi.getSelector().add(new SelectorItemInfo("Currency.precision"));
        evi.getSelector().add(new SelectorItemInfo("GroupID.name"));
        evi.setFilter(filter);
        return LoanFactory.getLocalInstance(ctx).getLoanCollection(evi);
    }

    private LoanDeferCollection filterDeferByID(LoanDeferCollection loanDeferColl, String loanid) {
        LoanDeferInfo tmp = null;
        for (int i = 0; i < loanDeferColl.size(); ++i) {
            tmp = loanDeferColl.get(i);
            if (!tmp.getLoan().getId().toString().equals(loanid)) continue;
            this.returnCol.add(tmp);
        }
        return this.returnCol;
    }

    private RepaymentCollection filterRepayByID(RepaymentCollection repayColl, String loanid) {
        RepaymentCollection returnCol = new RepaymentCollection();
        RepaymentInfo tmp = null;
        for (int i = 0; i < repayColl.size(); ++i) {
            tmp = repayColl.get(i);
            if (!tmp.getSourceBillId().toString().equals(loanid)) continue;
            returnCol.add(tmp);
        }
        return returnCol;
    }

    private IntRateTypeCollection filterIntRateTypeByID(LoanAdjustInterestCollection adjustColl, String loanId) {
        IntRateTypeCollection returnColl = new IntRateTypeCollection();
        LoanAdjustInterestInfo tmp = null;
        for (int i = 0; i < adjustColl.size(); ++i) {
            tmp = adjustColl.get(i);
            if (!tmp.getLoan().getId().toString().equals(loanId) || tmp.getIntRateType() == null) continue;
            returnColl.add(tmp.getIntRateType());
        }
        return returnColl;
    }

    private LoanAdjustInterestCollection filterAdjustByID(LoanAdjustInterestCollection adjustColl, String loanId) {
        LoanAdjustInterestCollection returnColl = new LoanAdjustInterestCollection();
        LoanAdjustInterestInfo tmp = null;
        for (int i = 0; i < adjustColl.size(); ++i) {
            tmp = adjustColl.get(i);
            if (!tmp.getLoan().getId().toString().equals(loanId)) continue;
            returnColl.add(tmp);
        }
        return returnColl;
    }

    private LoanInfo filterLoanInfoByID(LoanCollection loanColl, String loanid) {
        LoanInfo info = null;
        for (int i = 0; i < loanColl.size() && !(info = loanColl.get(i)).getId().toString().equals(loanid); ++i) {
        }
        return info;
    }

    private LoanInfo getLoanPassByRepayment(Context ctx, RepaymentInfo repaymentInfo) throws BOSException {
        String id = repaymentInfo.getSourceBillId();
        LoanInfo loanInfo = null;
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("Institution.name"));
            sic.add(new SelectorItemInfo("company.*"));
            sic.add(new SelectorItemInfo("Currency.name"));
            sic.add(new SelectorItemInfo("GroupID.name"));
            sic.add(new SelectorItemInfo("BankAcct.name"));
            loanInfo = LoanFactory.getLocalInstance(ctx).getLoanInfo((IObjectPK)new ObjectUuidPK(id), sic);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return loanInfo;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumberDup(ctx, model);
        super._update(ctx, pk, model);
        LoanInterestInfo infoInt = (LoanInterestInfo)model;
        if (!infoInt.isIsPrediction() && infoInt.getInterestType() == IntCalTypeEnum.REPAY_INT && !EmptyUtil.isEmpty((CoreBaseInfo)infoInt.getRepayment())) {
            String sql = " update t_fin_repayment set FInterest = ? where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{infoInt.getRealInterest(), infoInt.getRepayment().getId().toString()});
        }
        this.updateFpItem(ctx, pk);
    }

    private BigDecimal calcStrikeAmount(Context ctx, LoanInterestInfo intInfo, RepaymentInfo repayInfo) throws EASBizException, BOSException {
        BigDecimal returnValue = Constants.ZERO;
        if (repayInfo != null && repayInfo.getAddAmount().compareTo(this.getLoanPassByRepayment(ctx, repayInfo).getAmount()) != 0) {
            return returnValue;
        }
        returnValue = LoanInterestFactory.getLocalInstance(ctx).getStrikeAmount(intInfo);
        return returnValue;
    }

    @Override
    protected Map _createFromLoanInterestBill(Context ctx, String pk, SourceBillTypeEnum sourceBillType) throws BOSException, EASBizException {
        if (SourceBillTypeEnum.EntLoanInterest.equals((Object)sourceBillType)) {
            return this.createFromEntLoanInterestBill(ctx, pk);
        }
        if (SourceBillTypeEnum.FundTransferInterest.equals((Object)sourceBillType)) {
            return this.createFromFundTransferInterestBill(ctx, pk);
        }
        return this.createFromConsignLoanInterestBill(ctx, pk);
    }

    protected Map createFromEntLoanInterestBill(Context ctx, String pk) throws BOSException, EASBizException {
        try {
            IRowSet rs = null;
            StringBuffer selectSql = new StringBuffer();
            selectSql.append("select loan.fid,lint.floanbillid,lint.FEndDate from t_ivt_loaninterestbill lint ");
            selectSql.append("inner join t_fin_loan loan on lint.floanbillid = loan.fentloanid ");
            selectSql.append("where lint.fid = '").append(pk).append("' and lint.FIntCalType<>3 ");
            String loanID = "";
            String entLoanID = "";
            java.sql.Date endDate = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            if (rs.next()) {
                loanID = rs.getString(1);
                entLoanID = rs.getString(2);
                endDate = rs.getDate(3);
            }
            if (loanID == null || loanID.length() <= 0) {
                throw new FinBizException(FinBizException.LOANISNULL);
            }
            String sql3 = " select min(fenddate) from t_ivt_loaninterestbill where floanbillid = ? and fisdownloaded = 0  and fisPrediction = 0 and FIntCalType<>3  ";
            java.sql.Date minDate = null;
            rs = DbUtil.executeQuery((Context)ctx, (String)sql3, (Object[])new Object[]{entLoanID});
            if (rs.next()) {
                minDate = rs.getDate(1);
            }
            if (DateTimeUtils.truncateDate((Date)endDate).compareTo(DateTimeUtils.truncateDate((Date)minDate)) != 0) {
                throw new FinBizException(FinBizException.CREATEFROMLOANINTERESTBILLNOTBESEQ);
            }
            LoanInfo loanInfo = LoanFactory.getLocalInstance(ctx).getLoanInfo((IObjectPK)new ObjectUuidPK(loanID));
            LoanInterestBillInfo intBillInfo = LoanInterestBillFactory.getLocalInstance((Context)ctx).getLoanInterestBillInfo((IObjectPK)new ObjectUuidPK(pk));
            CoreBillBaseCollection srcCollection = new CoreBillBaseCollection();
            CoreBillBaseInfo srcInfo = (CoreBillBaseInfo)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(pk);
            srcCollection.add(srcInfo);
            EntRepaymentBillInfo entRepay = intBillInfo.getRepayment();
            RepaymentInfo repayInfo = null;
            if (entRepay != null) {
                String sql9 = " select fid from t_fin_repayment where FEntRepaymentBillID = ?";
                String repaymentID = "";
                rs = DbUtil.executeQuery((Context)ctx, (String)sql9, (Object[])new Object[]{entRepay.getId().toString()});
                if (rs.next()) {
                    repaymentID = rs.getString(1);
                }
                if (FMHelper.isEmpty((String)repaymentID)) {
                    throw new FinBizException(FinBizException.REPAYMENTISNULLONBEFORECREATEFROMLOANINTEREST);
                }
                repayInfo = RepaymentFactory.getLocalInstance(ctx).getRepaymentInfo((IObjectPK)new ObjectUuidPK(repaymentID));
            }
            CompanyOrgUnitInfo curent = loanInfo.getCompany();
            LoanInterestCollection lCol = (LoanInterestCollection)FinHelper.botpTransfromSubmit(ctx, srcCollection, new LoanInterestInfo().getBOSType());
            LoanInterestInfo intInfo = lCol.get(0);
            intInfo.setLoan(loanInfo);
            intInfo.setRepayment(repayInfo);
            intInfo.setRepaymentInfo(repayInfo);
            intInfo.setLoanInterestBill(intBillInfo);
            intInfo.setCompany(curent);
            intInfo.setStrikeStatus(StrikeEnum.NULL);
            this.setLoanInterestDefault(intInfo);
            if (IntCalTypeEnum.REC_INT.equals((Object)intInfo.getInterestType())) {
                intInfo.setInterestType(IntCalTypeEnum.PAY_INT);
            } else if (IntCalTypeEnum.PRE_INT.equals((Object)intInfo.getInterestType())) {
                intInfo.setStrikeAmount(Constants.ZERO);
            } else {
                intInfo.setStrikeAmount(this.calcStrikeAmount(ctx, intInfo, repayInfo));
            }
            IObjectPK newpk = this.save(ctx, (CoreBaseInfo)intInfo);
            HashMap hm = new HashMap();
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(newpk.toString());
            hm.put("createdID", idSet);
            this.updateLoanInterestBill(ctx, pk, false);
            this.createFromLoanInterestBill4WF(ctx, pk);
            return hm;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected Map createFromFundTransferInterestBill(Context ctx, String pk) throws BOSException, EASBizException {
        try {
            StringBuffer selectSql = new StringBuffer();
            selectSql.append("select loan.fid,fund.fid,fint.FEndDate from t_ft_fundTransferInterestBill fint ");
            selectSql.append("inner join t_ft_fundTransferBill fund on fund.fid = fint.FTransBillID ");
            selectSql.append("inner join t_fin_loan loan on loan.FTransBillID = fund.fid ");
            selectSql.append("where fint.fid = '").append(pk).append("'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            String loanID = null;
            String transID = null;
            String repayID = null;
            java.sql.Date endDate = null;
            if (rs.next()) {
                loanID = rs.getString(1);
                transID = rs.getString(2);
                endDate = rs.getDate(3);
            }
            if (loanID == null || loanID.length() <= 0) {
                throw new FinBizException(FinBizException.LOANISNULL);
            }
            String minDateSql = "select min(fendDate) from t_ft_fundTransferInterestBill where FTransBillID = ? and fisGenLoanInt = 0";
            rs = DbUtil.executeQuery((Context)ctx, (String)minDateSql, (Object[])new Object[]{transID});
            java.sql.Date minDate = null;
            if (rs.next()) {
                minDate = rs.getDate(1);
            }
            if (DateTimeUtils.truncateDate((Date)endDate).compareTo(DateTimeUtils.truncateDate((Date)minDate)) != 0) {
                throw new FinBizException(FinBizException.CREATEFROMLOANINTERESTBILLNOTBESEQ);
            }
            FundTransferInterestBillInfo transIntInfo = FundTransferInterestBillFactory.getLocalInstance((Context)ctx).getFundTransferInterestBillInfo((IObjectPK)new ObjectUuidPK(pk));
            LoanInfo loanInfo = LoanFactory.getLocalInstance(ctx).getLoanInfo((IObjectPK)new ObjectUuidPK(loanID));
            RepaymentInfo repayInfo = null;
            if (IntCalTypeEnum.REPAY_INT.equals((Object)transIntInfo.getIntCalType())) {
                selectSql.setLength(0);
                selectSql.append("select fid from t_fin_repayment where floanid = '").append(loanID).append("'");
                rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
                if (rs.next()) {
                    repayID = rs.getString(1);
                }
                if (repayID == null || repayID.length() <= 0) {
                    throw new FinBizException(FinBizException.REPAYMENTISNULLONBEFORECREATEFROMLOANINTEREST);
                }
                repayInfo = RepaymentFactory.getLocalInstance(ctx).getRepaymentInfo((IObjectPK)new ObjectUuidPK(repayID));
            }
            CoreBillBaseCollection srcCollection = new CoreBillBaseCollection();
            CoreBillBaseInfo srcInfo = (CoreBillBaseInfo)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(pk);
            srcCollection.add(srcInfo);
            CompanyOrgUnitInfo currCompany = loanInfo.getCompany();
            LoanInterestCollection lCol = (LoanInterestCollection)FinHelper.botpTransfromSubmit(ctx, srcCollection, new LoanInterestInfo().getBOSType());
            LoanInterestInfo intInfo = lCol.get(0);
            intInfo.setCompany(currCompany);
            intInfo.setLoan(loanInfo);
            intInfo.setRepayment(repayInfo);
            intInfo.setRepaymentInfo(repayInfo);
            intInfo.setFundTransferIntBill(transIntInfo);
            intInfo.setAccount(loanInfo.getBankAcct());
            intInfo.setStrikeStatus(StrikeEnum.NULL);
            this.setLoanInterestDefault(intInfo);
            if (IntCalTypeEnum.REC_INT.equals((Object)intInfo.getInterestType())) {
                intInfo.setInterestType(IntCalTypeEnum.PAY_INT);
            } else if (IntCalTypeEnum.PRE_INT.equals((Object)intInfo.getInterestType())) {
                intInfo.setStrikeAmount(Constants.ZERO);
            } else {
                intInfo.setStrikeAmount(this.calcStrikeAmount(ctx, intInfo, repayInfo));
            }
            IObjectPK newpk = this.save(ctx, (CoreBaseInfo)intInfo);
            HashMap hm = new HashMap();
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(newpk.toString());
            hm.put("createdID", idSet);
            this.updateIsGenLoanInt(ctx, TRANS_TABLE, pk, false);
            return hm;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected Map createFromConsignLoanInterestBill(Context ctx, String pk) throws BOSException, EASBizException {
        try {
            StringBuffer selectSql = new StringBuffer();
            selectSql.append("select loan.fid,cons.fid,cint.FEndDate from T_CL_ConsignLoanIntBill cint ");
            selectSql.append("inner join T_CL_ConsignmentLoanBill cons on cons.fid = cint.FLoanID ");
            selectSql.append("inner join t_fin_loan loan on loan.FSourceBillID = cons.fid ");
            selectSql.append("where cint.fid = '").append(pk).append("'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            String loanID = null;
            String consID = null;
            String repayID = null;
            java.sql.Date endDate = null;
            if (rs.next()) {
                loanID = rs.getString(1);
                consID = rs.getString(2);
                endDate = rs.getDate(3);
            }
            if (loanID == null || loanID.length() <= 0) {
                throw new FinBizException(FinBizException.LOANISNULL);
            }
            String minDateSql = "select min(fendDate) from T_CL_ConsignLoanIntBill where FLoanID = ? and fisGenLoanInt = 0";
            rs = DbUtil.executeQuery((Context)ctx, (String)minDateSql, (Object[])new Object[]{consID});
            java.sql.Date minDate = null;
            if (rs.next()) {
                minDate = rs.getDate(1);
            }
            if (DateTimeUtils.truncateDate((Date)endDate).compareTo(DateTimeUtils.truncateDate((Date)minDate)) != 0) {
                throw new FinBizException(FinBizException.CREATEFROMLOANINTERESTBILLNOTBESEQ);
            }
            ConsignLoanIntBillInfo consIntInfo = ConsignLoanIntBillFactory.getLocalInstance((Context)ctx).getConsignLoanIntBillInfo((IObjectPK)new ObjectUuidPK(pk));
            LoanInfo loanInfo = LoanFactory.getLocalInstance(ctx).getLoanInfo((IObjectPK)new ObjectUuidPK(loanID));
            RepaymentInfo repayInfo = null;
            if (IntCalTypeEnum.REPAY_INT.equals((Object)consIntInfo.getIntCalType())) {
                selectSql.setLength(0);
                selectSql.append("select fid from t_fin_repayment where floanid = '").append(loanID).append("'");
                rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
                if (rs.next()) {
                    repayID = rs.getString(1);
                }
                if (repayID == null || repayID.length() <= 0) {
                    throw new FinBizException(FinBizException.REPAYMENTISNULLONBEFORECREATEFROMLOANINTEREST);
                }
                repayInfo = RepaymentFactory.getLocalInstance(ctx).getRepaymentInfo((IObjectPK)new ObjectUuidPK(repayID));
            }
            CoreBillBaseCollection srcCollection = new CoreBillBaseCollection();
            CoreBillBaseInfo srcInfo = (CoreBillBaseInfo)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(pk);
            srcCollection.add(srcInfo);
            CompanyOrgUnitInfo currCompany = loanInfo.getCompany();
            LoanInterestCollection lCol = (LoanInterestCollection)FinHelper.botpTransfromSubmit(ctx, srcCollection, new LoanInterestInfo().getBOSType());
            LoanInterestInfo intInfo = lCol.get(0);
            intInfo.setCompany(currCompany);
            intInfo.setLoan(loanInfo);
            intInfo.setRepayment(repayInfo);
            intInfo.setRepaymentInfo(repayInfo);
            intInfo.setConsignLoanIntBill(consIntInfo);
            intInfo.setAccount(loanInfo.getBankAcct());
            intInfo.setStrikeStatus(StrikeEnum.NULL);
            this.setLoanInterestDefault(intInfo);
            if (intInfo.getInterestType().equals((Object)IntCalTypeEnum.REC_INT)) {
                intInfo.setInterestType(IntCalTypeEnum.PAY_INT);
            } else if (intInfo.getInterestType() == IntCalTypeEnum.PRE_INT) {
                intInfo.setStrikeAmount(Constants.ZERO);
            } else {
                intInfo.setStrikeAmount(this.calcStrikeAmount(ctx, intInfo, repayInfo));
            }
            IObjectPK newpk = this.save(ctx, (CoreBaseInfo)intInfo);
            HashMap hm = new HashMap();
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(newpk.toString());
            hm.put("createdID", idSet);
            this.updateIsGenLoanInt(ctx, CONSG_TABLE, pk, false);
            return hm;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void setLoanInterestDefault(LoanInterestInfo intInfo) {
        intInfo.setIntCurrency(intInfo.getCurrency());
        intInfo.setIntCurrencyRate(Constants.ONE);
        if (intInfo.getRealInterest() != null && intInfo.getRealPunishInterest() != null) {
            intInfo.setIntCurrencyAmt(intInfo.getRealInterest().add(intInfo.getRealPunishInterest()));
        }
    }

    private void updateLoanInterestBill(Context ctx, String id, boolean isDelete) throws BOSException {
        String sql = "";
        sql = isDelete ? " update T_IVT_LoanInterestBill set FIsDownLoaded = 0 where fid = ? " : " update T_IVT_LoanInterestBill set FIsDownLoaded = 1 where fid = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{id});
    }

    private void updateIsGenLoanInt(Context ctx, String table, String id, boolean isDelete) throws BOSException {
        String sql = "";
        sql = isDelete ? " update " + table + " set FIsGenLoanInt = 0 where fid = ? " : " update " + table + " set FIsGenLoanInt = 1 where fid = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{id});
    }

    @Override
    protected Map _batchSubmit(Context ctx, LoanInterestCollection loanInterestCollection) throws BOSException, EASBizException {
        if (loanInterestCollection == null || loanInterestCollection.isEmpty()) {
            return null;
        }
        HashMap hm = new HashMap();
        HashSet<String> idSet = new HashSet<String>();
        Iterator iter = loanInterestCollection.iterator();
        while (iter.hasNext()) {
            com.kingdee.eas.fm.im.util.LoanInterestInfo imIntInfo;
            LoanInterestInfo element = (LoanInterestInfo)iter.next();
            IObjectPK pk = super.submit(ctx, (CoreBaseInfo)element);
            idSet.add(pk.toString());
            if (element.isIsPrediction() || (imIntInfo = element.getImIntInfo()) == null) continue;
            LoanInterestEntryCollection iCol = imIntInfo.getEntries();
            for (int i = 0; i < iCol.size(); ++i) {
                com.kingdee.eas.fm.im.util.LoanInterestEntryInfo imLoanInterestInfo = iCol.get(i);
                if (FMHelper.isEmpty((String)imLoanInterestInfo.getAdjIntBillId())) continue;
                this._saveBOTPRelationShipLoanAdjust(ctx, imLoanInterestInfo.getAdjIntBillId(), element);
            }
        }
        hm.put("createdID", idSet);
        return hm;
    }

    @Override
    protected LoanInterestCollection _calIntAsFpItem(Context ctx, Date startDate, Date endDate, RepaymentInfo RepaymentInfo2) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected LoanInterestCollection _batchRecIntAsFpItem(Context ctx, Set loanIdSet, Date startDate, Date endDate, boolean expireNoInterest) throws BOSException, EASBizException {
        LoanInterestInfo loanInterestInfo = null;
        String errorMsgHeader = EASCommonResource.getString((String)RESOURCE, (String)"recInt_error_header", (Locale)ctx.getLocale());
        StringBuffer sb = new StringBuffer();
        LoanDeferCollection loanDeferColl = this.getLoanDeferColl(ctx, loanIdSet);
        LoanAdjustInterestCollection adjustColl = this.getAdjustColl(ctx, loanIdSet);
        RepaymentCollection repayColl = this.getRepayColl(ctx, loanIdSet);
        LoanCollection loanColl = this.getLoanColl(ctx, loanIdSet);
        LoanDeferCollection byIDsDefer = null;
        RepaymentCollection byIDsRepay = null;
        LoanAdjustInterestCollection byIDsAdjust = null;
        LoanInfo info = null;
        LoanInterestCollection loanIntCol = new LoanInterestCollection();
        for (String loanid : loanIdSet) {
            byIDsDefer = this.filterDeferByID(loanDeferColl, loanid);
            byIDsRepay = this.filterRepayByID(repayColl, loanid);
            byIDsAdjust = this.filterAdjustByID(adjustColl, loanid);
            info = this.filterLoanInfoByID(loanColl, loanid);
            IntCalModel model = this.getIntCalModel(startDate, endDate, info, byIDsAdjust, byIDsRepay, null, expireNoInterest);
            com.kingdee.eas.fm.im.util.LoanInterestInfo imIntInfo = AbstractIntCalStragety.getInstance((IntCalTypeEnum)IntCalTypeEnum.PAY_INT).calInt(ctx, model);
            try {
                loanInterestInfo = this.transfrom(ctx, imIntInfo, info, null);
                this.setLoanInterestDefault(loanInterestInfo);
                loanInterestInfo.setId(BOSUuid.create((BOSObjectType)new LoanInterestInfo().getBOSType()));
                loanInterestInfo.setImIntInfo(imIntInfo);
                loanIntCol.add(loanInterestInfo);
                this.batchRecInt4WF(ctx, loanInterestInfo.getId().toString());
            }
            catch (Exception e) {
                sb.append(info.getNumber()).append(errorMsgHeader).append(e.getMessage()).append("\n");
            }
        }
        return loanIntCol;
    }

    @Override
    protected void _book(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        this.verifyBeforeBook(ctx, idList);
        LoanInterestBookNotifyBuilder builder = new LoanInterestBookNotifyBuilder();
        JournalCollection journalColl = new JournalCollection();
        String sql = "UPDATE T_FIN_LoanInterest SET FCashierID = ? WHERE FID = ? ";
        String userId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString();
        String billId = null;
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            billId = (String)idList.get(i);
            if (!this.isBooked(ctx, billId)) {
                journalColl.addCollection(builder.getJournalColl(ctx, billId));
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userId, billId});
            }
            this.book4WF(ctx, billId);
        }
        IBookNotifyFacade bookFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        bookFacade.bookBatch(journalColl);
    }

    private boolean isBooked(Context ctx, String billId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        view.setFilter(filter);
        JournalCollection coll = JournalFactory.getLocalInstance((Context)ctx).getJournalCollection(view);
        return coll != null && coll.size() > 0;
    }

    private void verifyBeforeBook(Context ctx, List idList) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.setFilter(filter);
        LoanInterestCollection coll = this.getLoanInterestCollection(ctx, evi);
        LoanInterestInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (info.isIsGenPayBill()) {
                throw new LoanException(LoanException.HAS_GEN_PAY);
            }
            if (info.getAccount() != null) continue;
            throw new LoanException(LoanException.BOOKERROR, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"10_LoanInterestControllerBean", (Locale)ctx.getLocale())});
        }
    }

    @Override
    protected void _cancelBook(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        String sql = "UPDATE T_FIN_LoanInterest SET FCashierID = NULL WHERE FID = ? ";
        String billId = null;
        IBookNotifyFacade bookFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            billId = (String)idList.get(i);
            bookFacade.antiBook(billId);
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{billId});
            this.cancelBook4WF(ctx, billId);
        }
    }

    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        EntityViewInfo f = new EntityViewInfo();
        f.setFilter(filter);
        LoanInterestCollection col = this.getLoanInterestCollection(ctx, f);
        LoanInterestInfo info = null;
        for (int i = 0; i < col.size(); ++i) {
            info = col.get(i);
            if (!info.isIsPrediction()) {
                this._deleteCheck(ctx, info);
                this._afterDelete(ctx, info);
            }
            Map relMap = this.getAdjustRelation(ctx, info);
            String sql = " delete from t_bot_relation where FDestObjectID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getId().toString()});
            this.updateAdjust(ctx, info, relMap);
            FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
        }
        return super._delete(ctx, filter);
    }

    @Override
    protected void _batchPreInt4WF(Context ctx, String pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _batchRecInt4WF(Context ctx, String pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _book4WF(Context ctx, String pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _cancelBook4WF(Context ctx, String pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _createFromLoanInterestBill4WF(Context ctx, String pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _audit4WF(Context ctx, String id) throws BOSException, EASBizException {
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        String sql = "update t_fin_loanInterest set fstatusExtEnum = ?, fauditorID = ? where fid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{1, userInfo.getId().toString(), id});
    }

    @Override
    protected void _antiAudit4WF(Context ctx, String id) throws BOSException, EASBizException {
        String sql = "update t_fin_loanInterest set fstatusExtEnum = ?, fauditorID = null where fid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{0, id});
    }

    @Override
    protected Map _batchSave(Context ctx, LoanInterestCollection loanInterestCollection) throws BOSException, EASBizException {
        if (loanInterestCollection == null || loanInterestCollection.isEmpty()) {
            return null;
        }
        HashMap hm = new HashMap();
        HashSet<String> idSet = new HashSet<String>();
        Iterator iter = loanInterestCollection.iterator();
        while (iter.hasNext()) {
            com.kingdee.eas.fm.im.util.LoanInterestInfo imIntInfo;
            LoanInterestInfo element = (LoanInterestInfo)iter.next();
            IObjectPK pk = null;
            pk = (element.getInterestType() == IntCalTypeEnum.PRE_INT || element.getInterestType() == IntCalTypeEnum.REC_INT) && FmMbgHelper.isCtrl((Context)ctx, (BOSObjectType)element.getBOSType()) ? super.save(ctx, (CoreBaseInfo)element) : super.submit(ctx, (CoreBaseInfo)element);
            idSet.add(pk.toString());
            if (element.isIsPrediction() || (imIntInfo = element.getImIntInfo()) == null) continue;
            LoanInterestEntryCollection iCol = imIntInfo.getEntries();
            for (int i = 0; i < iCol.size(); ++i) {
                com.kingdee.eas.fm.im.util.LoanInterestEntryInfo imLoanInterestInfo = iCol.get(i);
                if (FMHelper.isEmpty((String)imLoanInterestInfo.getAdjIntBillId())) continue;
                this._saveBOTPRelationShipLoanAdjust(ctx, imLoanInterestInfo.getAdjIntBillId(), element);
            }
        }
        hm.put("createdID", idSet);
        return hm;
    }

    @Override
    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos, IObjectCollection destObjCol) throws BOSException, EASBizException {
        if (bOTRelationInfos == null || bOTRelationInfos.size() < 1) {
            return;
        }
        BOTRelationInfo botRelation = bOTRelationInfos.get(0);
        if (!new VoucherInfo().getBOSType().toString().equals(botRelation.getDestEntityID())) {
            return;
        }
        String vouche = "UPDATE T_FIN_LOANINTEREST SET ffivouchered = 1, faccountantid = ?, FVOUCHERNUMBER = ?, FVOUCHERTYPEID = ? WHERE FID = ? ";
        String unVouche = "UPDATE T_FIN_LOANINTEREST SET ffivouchered = 0, faccountantid = null, FVOUCHERNUMBER = null, FVOUCHERTYPEID = null WHERE FID = ? ";
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        for (int i = 0; i < bOTRelationInfos.size(); ++i) {
            String srcBillId = bOTRelationInfos.get(i).getSrcObjectID();
            VoucherInfo voucherInfo = new VoucherInfo();
            if (destObjCol != null && destObjCol.size() > 0) {
                try {
                    voucherInfo = (VoucherInfo)destObjCol.getObject(0);
                }
                catch (Exception e) {
                    voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(botRelation.getDestObjectID()));
                }
            } else {
                voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(botRelation.getDestObjectID()));
            }
            String voucherTypeID = voucherInfo.getVoucherType().getId().toString();
            String voucherNumber = voucherInfo.getNumber();
            if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                DbUtil.execute((Context)ctx, (String)unVouche, (Object[])new Object[]{srcBillId});
                continue;
            }
            DbUtil.execute((Context)ctx, (String)vouche, (Object[])new Object[]{userId, voucherNumber, voucherTypeID, srcBillId});
        }
    }
}

