/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.ImAdjustIntRateCollection;
import com.kingdee.eas.fm.fin.ImLoanInfo;
import com.kingdee.eas.fm.fin.ImRepaymentBillCollection;
import com.kingdee.eas.fm.fin.ImRepaymentBillInfo;
import com.kingdee.eas.fm.fin.LoanAdjustInterestCollection;
import com.kingdee.eas.fm.fin.LoanAdjustInterestFactory;
import com.kingdee.eas.fm.fin.LoanCollection;
import com.kingdee.eas.fm.fin.LoanContractFactory;
import com.kingdee.eas.fm.fin.LoanContractInfo;
import com.kingdee.eas.fm.fin.LoanEntryCollection;
import com.kingdee.eas.fm.fin.LoanEntryInfo;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.LoanInterestCollection;
import com.kingdee.eas.fm.fin.LoanInterestEntryInfo;
import com.kingdee.eas.fm.fin.LoanInterestFactory;
import com.kingdee.eas.fm.fin.LoanInterestInfo;
import com.kingdee.eas.fm.fin.LoanOfIntPayDateEntryInfo;
import com.kingdee.eas.fm.fin.RepayIntTypeEnum;
import com.kingdee.eas.fm.fin.RepaymentCollection;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.StrikeEnum;
import com.kingdee.eas.fm.fin.app.AbstractLoanInterestPredictionFacadeControllerBean;
import com.kingdee.eas.fm.fin.util.PredictionParamCollection;
import com.kingdee.eas.fm.im.CycleTypeEnum;
import com.kingdee.eas.fm.im.IntCalTypeEnum;
import com.kingdee.eas.fm.im.IntSchemeInfo;
import com.kingdee.eas.fm.im.util.AbstractIntCalStragety;
import com.kingdee.eas.fm.im.util.IAdjustIntRateCollection;
import com.kingdee.eas.fm.im.util.ILoanInfo;
import com.kingdee.eas.fm.im.util.IRepaymentBillCollection;
import com.kingdee.eas.fm.im.util.IRepaymentBillInfo;
import com.kingdee.eas.fm.im.util.IntCalModel;
import com.kingdee.eas.fm.im.util.LoanInterestEntryCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LoanInterestPredictionFacadeControllerBean
extends AbstractLoanInterestPredictionFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.LoanInterestPredictionFacadeControllerBean");

    protected BigDecimal getAmountAsRepayNotInt(LoanInfo loanInfo, RepaymentCollection repayColl) {
        BigDecimal balance = loanInfo.getAmount();
        for (int i = 0; i < repayColl.size(); ++i) {
            if (repayColl.get(i).isIsRepayInt()) continue;
            balance = balance.subtract(repayColl.get(i).getAmount());
        }
        return balance;
    }

    protected LoanInterestCollection predIntOnlyRepayColl(Context ctx, LoanInfo loanInfo, LoanAdjustInterestCollection adjColl, RepaymentCollection repayColl) throws EASBizException, BOSException {
        LoanInterestCollection loanIntColl = new LoanInterestCollection();
        Date startDate = loanInfo.getIssueDate();
        BigDecimal balance = this.getAmountAsRepayNotInt(loanInfo, repayColl);
        for (int j = 0; j < repayColl.size(); ++j) {
            RepaymentInfo repayInfo = repayColl.get(j);
            loanInfo.setBalance(balance);
            if (!repayInfo.isIsRepayInt()) continue;
            Date endDate = repayInfo.getBizDate();
            IntCalModel model = this.getIntCalModel(startDate, endDate, loanInfo, adjColl, repayColl, repayInfo);
            com.kingdee.eas.fm.im.util.LoanInterestInfo loanIntInfo = AbstractIntCalStragety.getInstance((IntCalTypeEnum)IntCalTypeEnum.REPAY_INT).calInt(ctx, model);
            LoanInterestInfo intInfo = this.transfrom(ctx, loanIntInfo, loanInfo, endDate);
            loanIntColl.add(intInfo);
            balance = balance.subtract(repayInfo.getAmount());
        }
        return loanIntColl;
    }

    private LoanInterestInfo transfrom(Context ctx, com.kingdee.eas.fm.im.util.LoanInterestInfo imIntInfo, LoanInfo loanInfo, Date bizDate) throws FinBizException, EASBizException, BOSException {
        CompanyOrgUnitInfo CURRENT_COMPANY = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        LoanInterestInfo finIntInfo = new LoanInterestInfo();
        LoanInterestEntryCollection imIntCol = imIntInfo.getEntries();
        for (int i = 0; i < imIntCol.size(); ++i) {
            com.kingdee.eas.fm.im.util.LoanInterestEntryInfo imEntryInfo = imIntCol.get(i);
            LoanInterestEntryInfo finEntryInfo = new LoanInterestEntryInfo();
            finEntryInfo.setSeq(imEntryInfo.getSeq());
            finEntryInfo.setBeginDate(imEntryInfo.getBeginDate());
            finEntryInfo.setEndDate(imEntryInfo.getEndDate());
            finEntryInfo.setDays(imEntryInfo.getDays());
            finEntryInfo.setAmount(imEntryInfo.getPrincipal());
            finEntryInfo.setIntRate(imEntryInfo.getIntRate());
            finEntryInfo.setInterest(imEntryInfo.getInterest());
            finEntryInfo.setYearDays(imEntryInfo.getConvertDays());
            finEntryInfo.setIntRateTypeExpression(imEntryInfo.getIntRateTypeExp());
            finEntryInfo.setDaysOverdue(imEntryInfo.getOverdueDays());
            finEntryInfo.setPunishIntRate(imEntryInfo.getPunishIntRate());
            finEntryInfo.setPunishInterest(imEntryInfo.getPunishInterest());
            finIntInfo.getEntrys().add(finEntryInfo);
        }
        finIntInfo.setLoan(loanInfo);
        finIntInfo.setAccount(loanInfo.getBankAcct());
        finIntInfo.setInterestType(imIntInfo.getIntCalType());
        if (loanInfo.getInstitution() != null) {
            finIntInfo.setCreditorAsBank(loanInfo.getInstitution());
        } else {
            finIntInfo.setCreditorAsCompany(loanInfo.getGroupID());
        }
        finIntInfo.setCompany(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany());
        finIntInfo.setCurrency(imIntInfo.getCurrency());
        finIntInfo.setExchange(FinUtils.getCurrencyExRate(ctx, CURRENT_COMPANY.getId(), loanInfo.getCurrency().getId(), CURRENT_COMPANY.getBaseCurrency().getId(), new Date()));
        finIntInfo.setBizDate(DateTimeUtils.truncateDate((Date)bizDate));
        finIntInfo.setBeginDate(imIntInfo.getBeginDate());
        finIntInfo.setEndDate(imIntInfo.getEndDate());
        finIntInfo.setDays(imIntInfo.getDays());
        finIntInfo.setAmount(imIntInfo.getPrincipal());
        finIntInfo.setIntRate(imIntInfo.getIntRate());
        finIntInfo.setDaysOverdue(imIntInfo.getOverdueDays());
        finIntInfo.setPunishIntType(imIntInfo.getPunishType());
        finIntInfo.setPunishIntRate(imIntInfo.getPunishIntRate());
        finIntInfo.setPunishInterest(imIntInfo.getPunishInterest());
        finIntInfo.setInterest(imIntInfo.getInterest());
        finIntInfo.setStrikeAmount(Constants.ZERO);
        finIntInfo.setStrikeStatus(StrikeEnum.NULL);
        finIntInfo.setFivouchered(false);
        finIntInfo.setRealPunishInterest(imIntInfo.getPunishInterest());
        finIntInfo.setRealInterest(imIntInfo.getInterest());
        finIntInfo.setIntRateTypeExpression(imIntInfo.getIntRateTypeExp());
        finIntInfo.setLastIntDate(imIntInfo.getLastIntDate());
        finIntInfo.setCreator(user);
        finIntInfo.setIsPrediction(true);
        finIntInfo.setId(BOSUuid.create((BOSObjectType)new LoanInterestInfo().getBOSType()));
        return finIntInfo;
    }

    private IntCalModel getIntCalModel(Date startDate, Date endDate, LoanInfo loanInfo, LoanAdjustInterestCollection adjColl, RepaymentCollection repayColl, RepaymentInfo repayInfo) {
        ImLoanInfo iLoanInfo = new ImLoanInfo(loanInfo);
        ImAdjustIntRateCollection iAdjColl = new ImAdjustIntRateCollection(adjColl);
        ImRepaymentBillCollection iRepayColl = new ImRepaymentBillCollection(repayColl);
        ImRepaymentBillInfo iRepayInfo = new ImRepaymentBillInfo(repayInfo);
        IntCalModel model = new IntCalModel();
        model.setIsPrediction(true);
        model.setBeginDate(startDate);
        model.setEndDate(endDate);
        model.setLoanInfo((ILoanInfo)iLoanInfo);
        model.setAdjIntRateColl((IAdjustIntRateCollection)iAdjColl);
        model.setRepayColl((IRepaymentBillCollection)iRepayColl);
        model.setRepayInfo((IRepaymentBillInfo)iRepayInfo);
        return model;
    }

    private LoanAdjustInterestCollection getAdjColl(Context ctx, BOSUuid loanID) throws BOSException {
        if (loanID == null) {
            return new LoanAdjustInterestCollection();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loan.id", (Object)loanID));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("adjustDate"));
        return LoanAdjustInterestFactory.getLocalInstance(ctx).getLoanAdjustInterestCollection(evi);
    }

    private List getPayIntTiemsList(IntSchemeInfo intScInfo, Date startDate, Date endDate, LoanInfo loanInfo) {
        TimesListOfPredictionInfo tlpInfo;
        ArrayList<TimesListOfPredictionInfo> timesList = new ArrayList<TimesListOfPredictionInfo>();
        CycleTypeEnum ctEnum = intScInfo.getCycleType();
        int settleDay = intScInfo.getSettleDay();
        startDate = DateTimeUtils.truncateDate((Date)startDate);
        endDate = DateTimeUtils.truncateDate((Date)endDate);
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(startDate);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(endDate);
        Calendar nextCalendar = Calendar.getInstance();
        if (ctEnum.equals((Object)CycleTypeEnum.YEAR)) {
            nextCalendar = this.getYearCalendar(startCalendar, endCalendar, settleDay);
            if (nextCalendar == null) {
                return null;
            }
            while (nextCalendar.getTime().compareTo(endDate) <= 0) {
                tlpInfo = new TimesListOfPredictionInfo();
                tlpInfo.setIsLoan(true);
                tlpInfo.setTime(DateTimeUtils.truncateDate((Date)nextCalendar.getTime()));
                timesList.add(tlpInfo);
                nextCalendar.add(1, 1);
            }
        }
        if (ctEnum.equals((Object)CycleTypeEnum.QUARTER)) {
            nextCalendar = this.getQuarterCalendar(startCalendar, endCalendar, settleDay);
            if (nextCalendar == null) {
                return null;
            }
            while (nextCalendar.getTime().compareTo(endDate) <= 0) {
                tlpInfo = new TimesListOfPredictionInfo();
                tlpInfo.setIsLoan(true);
                tlpInfo.setTime(DateTimeUtils.truncateDate((Date)nextCalendar.getTime()));
                timesList.add(tlpInfo);
                nextCalendar = this.setTimeOfNextPeriod(nextCalendar, settleDay, 3);
            }
        }
        if (ctEnum.equals((Object)CycleTypeEnum.MONTH)) {
            nextCalendar = this.getMonthCalendar(startCalendar, endCalendar, settleDay);
            if (nextCalendar == null) {
                return null;
            }
            while (nextCalendar.getTime().compareTo(endDate) <= 0) {
                tlpInfo = new TimesListOfPredictionInfo();
                tlpInfo.setIsLoan(true);
                tlpInfo.setTime(DateTimeUtils.truncateDate((Date)nextCalendar.getTime()));
                timesList.add(tlpInfo);
                nextCalendar = this.setTimeOfNextPeriod(nextCalendar, settleDay, 1);
            }
        }
        if (ctEnum.equals((Object)CycleTypeEnum.SETSELF)) {
            int n = loanInfo.getIntPayDateEntrys().size();
            for (int i = 0; i < n; ++i) {
                LoanOfIntPayDateEntryInfo tmpInfo = loanInfo.getIntPayDateEntrys().get(i);
                Calendar tmpPayDateCalendar = Calendar.getInstance();
                tmpPayDateCalendar.setTime(DateTimeUtils.truncateDate((Date)tmpInfo.getPayDate()));
                if (tmpPayDateCalendar.getTime().compareTo(startCalendar.getTime()) < 0 || tmpPayDateCalendar.getTime().compareTo(endCalendar.getTime()) > 0) continue;
                TimesListOfPredictionInfo tlpInfo2 = new TimesListOfPredictionInfo();
                tlpInfo2.setIsLoan(true);
                tlpInfo2.setTime(DateTimeUtils.truncateDate((Date)tmpPayDateCalendar.getTime()));
                timesList.add(tlpInfo2);
            }
        }
        return timesList;
    }

    protected Calendar setTimeOfNextPeriod(Calendar nextCalendar, int flashDay, int periodsMonth) {
        Calendar tmp = nextCalendar;
        if (flashDay == 29 || flashDay == 30 || flashDay == 31) {
            tmp.add(2, periodsMonth);
            int days = DateTimeUtils.daysOfMonth((int)tmp.get(1), (int)(tmp.get(2) + 1));
            if (days >= flashDay) {
                tmp.set(5, flashDay);
            } else {
                tmp.set(5, days);
            }
        } else {
            tmp.add(2, periodsMonth);
        }
        return tmp;
    }

    protected Calendar getYearCalendar(Calendar startCalendar, Calendar endCalendar, int settleDay) {
        Calendar yearCalendar = Calendar.getInstance();
        yearCalendar.set(1, startCalendar.get(1));
        yearCalendar.set(2, 11);
        yearCalendar.set(5, settleDay);
        if (yearCalendar.getTime().compareTo(startCalendar.getTime()) <= 0) {
            yearCalendar.add(1, 1);
        }
        if (yearCalendar.getTime().compareTo(startCalendar.getTime()) > 0 && yearCalendar.getTime().compareTo(endCalendar.getTime()) <= 0) {
            return yearCalendar;
        }
        return null;
    }

    protected Calendar getQuarterCalendar(Calendar startCalendar, Calendar endCalendar, int settleDay) {
        Calendar quarterCalendar = Calendar.getInstance();
        quarterCalendar.set(1, startCalendar.get(1));
        quarterCalendar.set(5, settleDay);
        int month = startCalendar.get(2);
        if (month <= 2) {
            quarterCalendar.set(2, 2);
        }
        if (month > 2 && month <= 5) {
            quarterCalendar.set(2, 5);
            if (settleDay == 31) {
                quarterCalendar.set(5, 30);
            }
        }
        if (month > 5 && month <= 8) {
            quarterCalendar.set(2, 8);
            if (settleDay == 31) {
                quarterCalendar.set(5, 30);
            }
        }
        if (month > 8 && month <= 11) {
            quarterCalendar.set(2, 11);
        }
        if (quarterCalendar.getTime().compareTo(startCalendar.getTime()) <= 0) {
            quarterCalendar = this.setTimeOfNextPeriod(quarterCalendar, settleDay, 3);
        }
        if (quarterCalendar.getTime().compareTo(startCalendar.getTime()) > 0 && quarterCalendar.getTime().compareTo(endCalendar.getTime()) <= 0) {
            return quarterCalendar;
        }
        return null;
    }

    protected Calendar getMonthCalendar(Calendar startCalendar, Calendar endCalendar, int settleDay) {
        Calendar monthCalendar = Calendar.getInstance();
        monthCalendar.set(1, startCalendar.get(1));
        monthCalendar.set(2, startCalendar.get(2));
        Calendar nextCalendar = Calendar.getInstance();
        nextCalendar.set(1, startCalendar.get(1));
        nextCalendar.set(2, startCalendar.get(2));
        nextCalendar.add(2, 1);
        nextCalendar.set(5, 1);
        nextCalendar.add(5, -1);
        int curDayCount = nextCalendar.getTime().getDate();
        if (curDayCount < settleDay) {
            settleDay = curDayCount;
        }
        monthCalendar.set(5, settleDay);
        if (monthCalendar.getTime().compareTo(startCalendar.getTime()) <= 0) {
            monthCalendar = this.setTimeOfNextPeriod(monthCalendar, settleDay, 1);
        }
        if (monthCalendar.getTime().compareTo(startCalendar.getTime()) > 0 && monthCalendar.getTime().compareTo(endCalendar.getTime()) <= 0) {
            return monthCalendar;
        }
        return null;
    }

    protected void deleteLoanInterestPrediction(Context ctx, String loanID) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isPrediction", (Object)new Boolean(true)));
        filter.getFilterItems().add(new FilterItemInfo("loan.id", (Object)loanID));
        LoanInterestFactory.getLocalInstance(ctx).delete(filter);
    }

    @Override
    protected Map _genLoanInterestPrediction(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, LoanInterestCollection> intCollMap = new HashMap<String, LoanInterestCollection>();
        Set keySet = paramMap.keySet();
        Calendar tmpCal = Calendar.getInstance();
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            LoanInterestCollection loanIntColl = new LoanInterestCollection();
            String key = (String)iter.next();
            PredictionParamCollection paramCollection = (PredictionParamCollection)paramMap.get(key);
            LoanInfo loanInfo = paramCollection.getLoanInfo();
            BOSUuid loanID = loanInfo.getId();
            LoanAdjustInterestCollection adjColl = this.getAdjColl(ctx, loanID);
            RepaymentCollection repayColl = paramCollection.getRepaymentCollection();
            IntSchemeInfo intScInfo = loanInfo.getPayIntMode();
            if (intScInfo != null) {
                List timesList = this.getPayIntTiemsList(intScInfo, loanInfo.getIssueDate(), loanInfo.getExpiredDate(), loanInfo);
                if (timesList != null && timesList.size() > 0) {
                    Date repayDate = null;
                    TimesListOfPredictionInfo tlpInfo = null;
                    for (int j = 0; j < repayColl.size(); ++j) {
                        RepaymentInfo repayInfo = repayColl.get(j);
                        if (!repayInfo.isIsRepayInt()) continue;
                        repayDate = DateTimeUtils.truncateDate((Date)repayInfo.getBizDate());
                        tlpInfo = new TimesListOfPredictionInfo();
                        tlpInfo.setIsLoan(true);
                        tlpInfo.setTime(DateUtil.getBeforeDay((Date)repayDate));
                        if (timesList.contains(tlpInfo)) {
                            timesList.remove(tlpInfo);
                            tlpInfo.setIsLoan(true);
                        } else {
                            tlpInfo.setIsLoan(false);
                        }
                        tlpInfo.setTime(DateUtil.getBeforeDay((Date)repayDate));
                        tlpInfo.setRepaymentInfo(repayInfo);
                        timesList.add(tlpInfo);
                    }
                    VOComparator vo = new VOComparator();
                    Collections.sort(timesList, vo);
                    Date startDate = loanInfo.getIssueDate();
                    BigDecimal balance = this.getAmountAsRepayNotInt(loanInfo, repayColl);
                    for (int i = 0; i < timesList.size(); ++i) {
                        tlpInfo = (TimesListOfPredictionInfo)timesList.get(i);
                        Date endDate = tlpInfo.getTime();
                        tmpCal.setTime(endDate);
                        loanInfo.setBalance(balance);
                        if (tlpInfo.getIsLoan()) {
                            tmpCal.add(5, 1);
                            endDate = tmpCal.getTime();
                            IntCalModel model = this.getIntCalModel(startDate, endDate, loanInfo, adjColl, repayColl, null);
                            com.kingdee.eas.fm.im.util.LoanInterestInfo loanIntInfo = AbstractIntCalStragety.getInstance((IntCalTypeEnum)IntCalTypeEnum.PAY_INT).calInt(ctx, model);
                            LoanInterestInfo intInfo = this.transfrom(ctx, loanIntInfo, loanInfo, endDate);
                            loanIntColl.add(intInfo);
                            startDate = endDate;
                            RepaymentInfo repayInfo = tlpInfo.getRepaymentInfo();
                            if (repayInfo == null) continue;
                            balance = balance.subtract(repayInfo.getAmount());
                            continue;
                        }
                        tmpCal.add(5, 1);
                        endDate = tmpCal.getTime();
                        RepaymentInfo repayInfo = tlpInfo.getRepaymentInfo();
                        IntCalModel model = this.getIntCalModel(startDate, endDate, loanInfo, adjColl, repayColl, repayInfo);
                        com.kingdee.eas.fm.im.util.LoanInterestInfo loanIntInfo = AbstractIntCalStragety.getInstance((IntCalTypeEnum)IntCalTypeEnum.REPAY_INT).calInt(ctx, model);
                        LoanInterestInfo intInfo = this.transfrom(ctx, loanIntInfo, loanInfo, endDate);
                        loanIntColl.add(intInfo);
                        balance = balance.subtract(repayInfo.getAmount());
                    }
                } else {
                    loanIntColl = this.predIntOnlyRepayColl(ctx, loanInfo, adjColl, repayColl);
                }
            } else {
                loanIntColl = this.predIntOnlyRepayColl(ctx, loanInfo, adjColl, repayColl);
            }
            intCollMap.put(key, loanIntColl);
        }
        return intCollMap;
    }

    @Override
    protected Set _batchSubmit(Context ctx, Map intCollMap) throws BOSException, EASBizException {
        HashSet<Set> intIDSet = new HashSet<Set>();
        for (Map.Entry entry : intCollMap.entrySet()) {
            intIDSet.add(this._submit(ctx, (String)entry.getKey(), (LoanInterestCollection)((Object)entry.getValue())));
        }
        return intIDSet;
    }

    @Override
    protected Set _submit(Context ctx, String loanID, LoanInterestCollection intColl) throws BOSException, EASBizException {
        this.deleteLoanInterestPrediction(ctx, loanID);
        HashSet<String> idSet = new HashSet<String>();
        if (intColl != null && intColl.size() > 0) {
            Iterator iter = intColl.iterator();
            while (iter.hasNext()) {
                LoanInterestInfo intInfo = (LoanInterestInfo)iter.next();
                String id = LoanInterestFactory.getLocalInstance(ctx).save((CoreBaseInfo)intInfo).toString();
                idSet.add(id);
            }
        }
        return idSet;
    }

    @Override
    protected Set _genLoanInterestPredictionFromListUI(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashMap<String, PredictionParamCollection> paramMap = new HashMap<String, PredictionParamCollection>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().add("*");
        view.getSelector().add("entrys.*");
        view.getSelector().add("payIntMode.cycleType");
        view.getSelector().add("payIntMode.settleDay");
        view.getSelector().add("intPayDateEntrys.*");
        LoanCollection loanColl = LoanFactory.getLocalInstance(ctx).getLoanCollection(view);
        HashSet<String> sourceBillIdSet = new HashSet<String>();
        int n = loanColl.size();
        for (int k = 0; k < n; ++k) {
            LoanInfo loanInfo = loanColl.get(k);
            String id = loanInfo.getId().toString();
            if (!EmptyUtil.isEmpty((String)loanInfo.getSourceBillId()) && !sourceBillIdSet.contains(loanInfo.getSourceBillId())) {
                sourceBillIdSet.add(loanInfo.getSourceBillId());
            }
            RepaymentCollection repayColl = new RepaymentCollection();
            LoanEntryCollection repayEntrys = loanInfo.getEntrys();
            for (int i = 0; i < repayEntrys.size(); ++i) {
                RepaymentInfo repayInfo = new RepaymentInfo();
                LoanEntryInfo loanEntryInfo = repayEntrys.get(i);
                repayInfo.setBizDate(loanEntryInfo.getDate());
                repayInfo.setAmount(loanEntryInfo.getAmount());
                RepayIntTypeEnum repayIntType = loanEntryInfo.getRepayIntType();
                if (RepayIntTypeEnum.REPAY_INT.equals((Object)repayIntType)) {
                    repayInfo.setIsCalInt(true);
                    repayInfo.setIsRepayInt(true);
                } else {
                    repayInfo.setIsCalInt(true);
                    repayInfo.setIsRepayInt(false);
                }
                repayColl.add(repayInfo);
            }
            PredictionParamCollection paramColl = new PredictionParamCollection();
            paramColl.setLoanInfo(loanInfo);
            paramColl.setRepaymentCollection(repayColl);
            paramMap.put(id, paramColl);
        }
        Map intCollMap = this._genLoanInterestPrediction(ctx, paramMap);
        Set ids = this._batchSubmit(ctx, intCollMap);
        for (String sourceBillId : sourceBillIdSet) {
            if (!FMHelper.isInstanceof((String)sourceBillId, LoanContractInfo.class)) continue;
            this.fillLoanContractOverView(ctx, sourceBillId);
        }
        return ids;
    }

    private LoanInterestCollection getIntCollPrediction(Context ctx, String loanId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loan.id", (Object)loanId));
        filter.getFilterItems().add(new FilterItemInfo("isPrediction", (Object)new Boolean(true)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return LoanInterestFactory.getLocalInstance(ctx).getLoanInterestCollection(evi);
    }

    private void fillLoanContractOverView(Context ctx, String sourceBillId) throws BOSException, EASBizException {
        LoanContractInfo info = LoanContractFactory.getLocalInstance(ctx).getLoanContractInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)sourceBillId));
        view.setFilter(filter);
        LoanCollection loanCol = LoanFactory.getLocalInstance(ctx).getLoanCollection(view);
        for (int i = 0; i < loanCol.size(); ++i) {
            loanCol.get(i).setIntCollPrediction(this.getIntCollPrediction(ctx, loanCol.get(i).getId().toString()));
        }
        LoanInterestCollection interstCol = new LoanInterestCollection();
        for (int i = 0; i < loanCol.size(); ++i) {
            interstCol.addCollection(loanCol.get(i).getIntCollPrediction());
        }
        BigDecimal preInterestAmt = new BigDecimal(0);
        for (int i = 0; i < interstCol.size(); ++i) {
            preInterestAmt = preInterestAmt.add(interstCol.get(i).getInterest());
        }
        info.getLoanContractOverView().get(0).setPreInterestAmt(preInterestAmt);
        BigDecimal allPaidInterest = info.getLoanContractOverView().get(0).getPaidInterest() == null ? Constants.ZERO : info.getLoanContractOverView().get(0).getPaidInterest();
        info.getLoanContractOverView().get(0).setPreInterestUnPaidAmt(preInterestAmt.subtract(allPaidInterest));
        LoanContractFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId().toString()), (CoreBaseInfo)info);
    }

    @Override
    protected Set _save(Context ctx, String loanID, LoanInterestCollection intColl) throws BOSException, EASBizException {
        this.deleteLoanInterestPrediction(ctx, loanID);
        HashSet<String> idSet = new HashSet<String>();
        if (intColl != null && intColl.size() > 0) {
            Iterator iter = intColl.iterator();
            while (iter.hasNext()) {
                LoanInterestInfo intInfo = (LoanInterestInfo)iter.next();
                String id = LoanInterestFactory.getLocalInstance(ctx).save((CoreBaseInfo)intInfo).toString();
                idSet.add(id);
            }
        }
        return idSet;
    }

    class VOComparator
    implements Comparator {
        VOComparator() {
        }

        public int compare(Object o1, Object o2) {
            TimesListOfPredictionInfo info1 = (TimesListOfPredictionInfo)o1;
            TimesListOfPredictionInfo info2 = (TimesListOfPredictionInfo)o2;
            return info1.getTime().compareTo(info2.getTime());
        }
    }

    class TimesListOfPredictionInfo {
        private boolean isLoan;
        private Date time;
        private RepaymentInfo repayInfo;

        TimesListOfPredictionInfo() {
        }

        public void setIsLoan(boolean isLoan) {
            this.isLoan = isLoan;
        }

        public boolean getIsLoan() {
            return this.isLoan;
        }

        public void setTime(Date time) {
            this.time = time;
        }

        public Date getTime() {
            return this.time;
        }

        public void setRepaymentInfo(RepaymentInfo repayInfo) {
            this.repayInfo = repayInfo;
        }

        public RepaymentInfo getRepaymentInfo() {
            return this.repayInfo;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TimesListOfPredictionInfo)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            TimesListOfPredictionInfo info = (TimesListOfPredictionInfo)obj;
            return this.time.compareTo(info.time) == 0 && this.isLoan == info.isLoan && this.repayInfo == info.repayInfo;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

