/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.ILoanInterest;
import com.kingdee.eas.fm.fin.LoanInterestCollection;
import com.kingdee.eas.fm.fin.LoanInterestFactory;
import com.kingdee.eas.fm.fin.LoanInterestInfo;
import com.kingdee.eas.fm.ss.BusinessTypeInfo;
import com.kingdee.eas.fm.ss.InterfaceTypeEnum;
import com.kingdee.eas.fm.ss.SmartSettleEntryBusinessInfo;
import com.kingdee.eas.fm.ss.SmartSettleSchemaInfo;
import com.kingdee.eas.fm.ss.app.AbstractSmartSettleProcess;
import com.kingdee.eas.fm.ss.app.ISmartSettleProcess;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class LoanInterestSmartFilter
extends AbstractSmartSettleProcess {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.LoanInterestSmartFilter");
    private String failMsg = null;

    public List getSourceBillList(Context ctx, String schemaID, String businessEntryID, String companyID, String filterSql, String queryPK) throws BOSException, EASBizException {
        List result = new ArrayList();
        filterSql = this.getFilter(ctx, schemaID, businessEntryID, companyID, filterSql, queryPK);
        SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)ctx.get((Object)"busiInfo");
        String operatorNumber = busiInfo.getOperatorNumber();
        try {
            FilterInfo filterInfo = new FilterInfo(filterSql);
            if (FilterUtility.hasFilterItem((FilterInfo)filterInfo)) {
                FilterItemCollection filterItemCol = filterInfo.getFilterItems();
                for (int i = 0; i < filterItemCol.size(); ++i) {
                    String compareOp;
                    FilterItemInfo filterItemInfo = filterItemCol.get(i);
                    String filterField = filterItemInfo.getPropertyName();
                    String filterValue = "";
                    Object cmpVal = filterItemInfo.getCompareValue();
                    if (cmpVal != null) {
                        filterValue = cmpVal.toString();
                    }
                    if ("=".equals(compareOp = filterItemInfo.getCompareType().toString()) && filterValue != null && filterValue.indexOf("00:00:00") > -1) {
                        String sql = "( " + filterField + ">='" + filterValue + "' and " + filterField + " <= '" + filterValue.substring(0, 10) + " 23:59:59')";
                        filterSql = filterSql.replaceAll(filterItemInfo.toString(), sql);
                        continue;
                    }
                    if (!"=".equals(compareOp) || filterValue == null || filterValue.indexOf(":") <= -1 || filterValue.indexOf("-") <= -1) continue;
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String endValue = "";
                    try {
                        Date date = df.parse(filterValue);
                        date.setTime(date.getTime() + 1000L);
                        endValue = df.format(date);
                        if (EmptyUtil.isEmpty((String)endValue)) continue;
                        String sql = "( " + filterField + ">='" + filterValue + "' and " + filterField + " <= '" + endValue + " ')";
                        filterSql = filterSql.replaceAll(filterItemInfo.toString(), sql);
                        continue;
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        String queryOql = "";
        if (filterSql != null && filterSql.length() > 0) {
            queryOql = "select id,number where " + filterSql + " and company.id = '" + companyID + "' ";
        }
        IMetaDataPK mainQueryPK = MetaDataPKFactory.getMetaDataPK((String)queryPK);
        IQueryExecutor iexec = this.getQueryExecutor(ctx, mainQueryPK, queryOql);
        logger.error((Object)("LoanInterestSmartFilter============" + iexec.getSQL()));
        result = this.getSourceBillRowSet(ctx, iexec.getSQL());
        return result;
    }

    private String getFilter(Context ctx, String schemaID, String businessEntryID, String companyID, String filterSql, String queryPK) throws BOSException, EASBizException {
        SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)ctx.get((Object)"busiInfo");
        String className = busiInfo.getBusinessType().getClassName();
        if (className == null || "".equals(className)) {
            return null;
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)ctx.get((Object)"companyInfo");
        String billIDFilter = "";
        try {
            billIDFilter = ((ISmartSettleProcess)Class.forName(className).newInstance()).getSouceBillFilter(ctx, (OrgUnitInfo)companyInfo);
        }
        catch (Exception e) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"148_LoanInterestSmartFilter", (Locale)ctx.getLocale()) + className + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"149_LoanInterestSmartFilter", (Locale)ctx.getLocale()), (Throwable)e);
        }
        StringBuffer result = new StringBuffer();
        if (!StringUtils.isEmpty((String)billIDFilter)) {
            result.append("id in (").append(billIDFilter).append(") ");
            if (filterSql != null && !"".equals(filterSql)) {
                result.append(" and ").append(" ( ").append(filterSql).append(" ) ");
            }
        } else {
            result.append(" ( ").append(filterSql).append(" ) ");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String operatorNumber = busiInfo.getOperatorNumber();
        if (InterfaceTypeEnum.loanInterest_audit.getName().equals(operatorNumber)) {
            result.append(" and ").append(" statusExtEnum = 0 ");
        }
        return result.toString();
    }

    public Map _process(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap map = new HashMap();
        SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)paramMap.get("busiInfo");
        SmartSettleSchemaInfo schemaInfo = (SmartSettleSchemaInfo)paramMap.get("schemaInfo");
        BusinessTypeInfo busiType = busiInfo.getBusinessType();
        List billList = (List)paramMap.get("billList");
        int success = 0;
        int failure = 0;
        String errorMsg = "";
        if (!EmptyUtil.isEmpty((Collection)billList)) {
            String operatorNumber = busiInfo.getOperatorNumber();
            ILoanInterest biz = LoanInterestFactory.getLocalInstance(ctx);
            LoanInterestCollection billColl = this.getBillColl(ctx, billList);
            if (InterfaceTypeEnum.loanInterest_audit.getName().equals(operatorNumber)) {
                for (int i = 0; i < billColl.size(); ++i) {
                    try {
                        LoanInterestInfo billInfo = billColl.get(i);
                        String sql = "update t_fin_loanInterest set fstatusExtEnum = ?, fauditorID = ? where fid = ?";
                        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{1, schemaInfo.getApprove().getId().toString(), billInfo.getId().toString()});
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
            }
        }
        result.put("state", errorMsg.toString().length() > 0 ? 1 : 0);
        result.put("success", success);
        result.put("errorMsg", errorMsg);
        result.put("failure", failure);
        return result;
    }

    private LoanInterestCollection getBillColl(Context ctx, List billList) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set((List)billList), CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        view.setSelector(sic);
        LoanInterestCollection coll = LoanInterestFactory.getLocalInstance(ctx).getLoanInterestCollection(view);
        return coll;
    }
}

