/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fin.LoanRepayStatusEnum;
import com.kingdee.eas.fm.fin.LoanRepaymentApplyCollection;
import com.kingdee.eas.fm.fin.LoanRepaymentApplyFactory;
import com.kingdee.eas.fm.fin.LoanRepaymentApplyInfo;
import com.kingdee.eas.fm.fin.app.AbstractLoanRepaymentApplyControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class LoanRepaymentApplyControllerBean
extends AbstractLoanRepaymentApplyControllerBean {
    protected static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.LoanRepaymentApplyControllerBean");
    private static final String RESOURCE_PATH = "com.kingdee.eas.fm.fin.client.LoanRepayResource";

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        LoanRepaymentApplyInfo info = LoanRepaymentApplyFactory.getLocalInstance(ctx).getLoanRepaymentApplyInfo(pk);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditDate(DateTimeUtils.truncateDate((Date)new Date()));
        info.setStatus(LoanRepayStatusEnum.AUDITED);
        try {
            this._update(ctx, pk, (IObjectValue)info);
        }
        catch (EASBizException e) {
            logger.debug((Object)e.getMessage(), e.fillInStackTrace());
        }
        super._passAudit(ctx, pk, model);
    }

    @Override
    protected void _batchAntiAudit(Context ctx, Set idSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        LoanRepaymentApplyCollection col = LoanRepaymentApplyFactory.getLocalInstance(ctx).getLoanRepaymentApplyCollection(view);
        for (int i = 0; i < col.size(); ++i) {
            if (col.get(i) == null || col.get(i).getStatus() == null || col.get(i).getStatus().getName() == null || !LoanRepayStatusEnum.AUDITED.getName().equalsIgnoreCase(col.get(i).getStatus().getName())) {
                throw new BOSException(ResourceBase.getString((String)RESOURCE_PATH, (String)"unAuditError", (Locale)ctx.getLocale()));
            }
            if (col.get(i).isIsCreateRepayBill()) {
                throw new BOSException(ResourceBase.getString((String)RESOURCE_PATH, (String)"unAuditError_hasCreate", (Locale)ctx.getLocale()));
            }
            if (col.get(i).getStatus() == null || !LoanRepayStatusEnum.AUDITED.equals((Object)col.get(i).getStatus())) continue;
            col.get(i).setAuditor(null);
            col.get(i).setAuditDate(null);
            col.get(i).setStatus(LoanRepayStatusEnum.SAVE);
        }
        try {
            this._updateBatchData(ctx, (IObjectCollection)col);
        }
        catch (EASBizException e) {
            logger.debug((Object)e.getMessage(), e.fillInStackTrace());
        }
    }

    @Override
    protected void _batchAudit(Context ctx, Set idSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        LoanRepaymentApplyCollection col = LoanRepaymentApplyFactory.getLocalInstance(ctx).getLoanRepaymentApplyCollection(view);
        for (int i = 0; i < col.size(); ++i) {
            if (col.get(i) == null || col.get(i).getStatus() == null || col.get(i).getStatus().getName() == null || LoanRepayStatusEnum.SAVE.getName().equalsIgnoreCase(col.get(i).getStatus().getName())) {
                throw new BOSException(ResourceBase.getString((String)RESOURCE_PATH, (String)"auditError", (Locale)ctx.getLocale()));
            }
            if (LoanRepayStatusEnum.AUDITED.getName().equalsIgnoreCase(col.get(i).getStatus().getName())) {
                throw new BOSException(ResourceBase.getString((String)RESOURCE_PATH, (String)"auditedError", (Locale)ctx.getLocale()));
            }
            if (col.get(i).getStatus() == null || !LoanRepayStatusEnum.SUBMIT.equals((Object)col.get(i).getStatus())) continue;
            col.get(i).setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
            col.get(i).setAuditDate(DateTimeUtils.truncateDate((Date)new Date()));
            col.get(i).setStatus(LoanRepayStatusEnum.AUDITED);
        }
        try {
            this._updateBatchData(ctx, (IObjectCollection)col);
        }
        catch (EASBizException e) {
            logger.debug((Object)e.getMessage(), e.fillInStackTrace());
        }
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        LoanRepaymentApplyInfo info = (LoanRepaymentApplyInfo)srcBillVO;
        if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
            info.setIsCreateRepayBill(true);
        } else if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
            info.setIsCreateRepayBill(false);
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanRepaymentApplyInfo info = (LoanRepaymentApplyInfo)model;
        if (FMHelper.isEmpty((String)info.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        this.checkNumberDup(ctx, model);
        IObjectPK pkReturn = super._addnew(ctx, model);
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        boolean exist = codingRuleManager.isExist((IObjectValue)info, info.getCompany().getId().toString());
        if (exist && codingRuleManager.isAddView((IObjectValue)info, info.getCompany().getId().toString()) && !codingRuleManager.isUseIntermitNumber((IObjectValue)info, info.getCompany().getId().toString())) {
            codingRuleManager.getNumber((IObjectValue)info, info.getCompany().getId().toString());
        }
        return pkReturn;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanRepaymentApplyInfo info = (LoanRepaymentApplyInfo)model;
        if (FMHelper.isEmpty((String)info.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        this.checkNumberDup(ctx, (IObjectValue)info);
        IObjectPK pk = super._submit(ctx, (IObjectValue)info);
        return pk;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanRepaymentApplyInfo info = this.getLoanRepaymentApplyInfo(ctx, pk);
        NumberRuleUtil.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
        super._delete(ctx, pk);
    }
}

