/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.DeferReturnCLEntryFactory;
import com.kingdee.eas.fm.fin.DeferReturnCLEntryInfo;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.LoanContractFactory;
import com.kingdee.eas.fm.fin.LoanContractInfo;
import com.kingdee.eas.fm.fin.LoanContractRepayEntryInfo;
import com.kingdee.eas.fm.fin.LoanEntryInfo;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.LoanInterestFactory;
import com.kingdee.eas.fm.fin.RepaymentCollection;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.app.AbstractRepaymentStragety;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.nt.BillMakeTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;

public class LoanRepaymentStragety
extends AbstractRepaymentStragety {
    @Override
    protected void beforeAddNew(Context ctx, IObjectValue model, FinancingBillInfo finBillInfo) throws BOSException, EASBizException {
        RepaymentInfo info = (RepaymentInfo)model;
        if (info.getLoan() == null) {
            LoanInfo loan = new LoanInfo();
            loan.setId(BOSUuid.read((String)info.getSourceBillId()));
            info.setLoan(loan);
        }
        info.setMakeType(BillMakeTypeEnum.SELF);
        info.setRepaySeq(this.getSeq(ctx, info.getLoan()));
    }

    protected int getSeq(Context ctx, LoanInfo info) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("SOURCEBILLID", (Object)info.getId().toString(), CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        RepaymentCollection coll = RepaymentFactory.getLocalInstance(ctx).getRepaymentCollection(evi);
        return coll.size() + 1;
    }

    @Override
    protected void dispose(Context ctx, IObjectValue model, FinancingBillInfo finBillInfo) throws BOSException, EASBizException {
    }

    @Override
    protected void afterAddNew(Context ctx, IObjectValue model, FinancingBillInfo finBillInfo) throws BOSException, EASBizException {
        if (finBillInfo.getBalance().compareTo(SysConstant.BIGZERO) == 0) {
            throw new FinBizException(FinBizException.BALANCEISZERO);
        }
    }

    @Override
    protected void delBookAndSubsidiary(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RepaymentInfo info = (RepaymentInfo)model;
        SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).cancelBook(info.getId().toString());
        BookNotifyFacadeFactory.getLocalInstance((Context)ctx).antiBook(info.getId().toString());
    }

    @Override
    protected boolean isCancelLimit(Context ctx, IObjectValue model, FinancingBillInfo finBillInfo) throws BOSException, EASBizException {
        RepaymentInfo info = (RepaymentInfo)model;
        DeferReturnCLEntryInfo deInfo = DeferReturnCLEntryFactory.getLocalInstance(ctx).getValueByRepaymentBill(info.getId().toString());
        return deInfo == null || deInfo.isIsReturnedCL();
    }

    @Override
    protected void beforeDelete(Context ctx, IObjectValue model, FinancingBillInfo finBillInfo) throws BOSException, EASBizException {
        RepaymentInfo info = (RepaymentInfo)model;
        LoanInterestFactory.getLocalInstance(ctx).deleteRaleted((IObjectPK)new ObjectUuidPK(info.getId()));
    }

    @Override
    protected void afterDelete(Context ctx, IObjectValue model, FinancingBillInfo finBillInfo) throws BOSException, EASBizException {
        RepaymentInfo repaymentInfo = (RepaymentInfo)model;
        if (FMHelper.isInstanceof((String)finBillInfo.getSourceBillId(), LoanContractInfo.class)) {
            LoanContractInfo loanInfo = LoanContractFactory.getLocalInstance(ctx).getLoanContractInfo((IObjectPK)new ObjectUuidPK(finBillInfo.getSourceBillId().toString()));
            this.fillLoanContractRepayEntry(ctx, loanInfo, finBillInfo, repaymentInfo, BOTBillOperStateEnum.DELETE);
            this.fillLoanContractOverView(ctx, loanInfo, (LoanInfo)finBillInfo, repaymentInfo, BOTBillOperStateEnum.DELETE);
            this.fillLoanContractActLoanSituation(ctx, loanInfo, (LoanInfo)finBillInfo, repaymentInfo, BOTBillOperStateEnum.DELETE);
            LoanContractFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(loanInfo.getId().toString()), (CoreBaseInfo)loanInfo);
        }
        if (FMHelper.isInstanceof((String)repaymentInfo.getSourceBillId(), LoanInfo.class)) {
            LoanInfo sourceInfo = LoanFactory.getLocalInstance(ctx).getLoanInfo((IObjectPK)new ObjectUuidPK(repaymentInfo.getSourceBillId().toString()), this.getLoanSelector());
            RepaymentInfo info = (RepaymentInfo)model;
            ArrayList<String> updateEntryIds = new ArrayList<String>();
            if (null == sourceInfo || null == sourceInfo.getEntrys() || sourceInfo.getEntrys().size() == 0) {
                return;
            }
            for (int i = 0; i < sourceInfo.getEntrys().size(); ++i) {
                LoanEntryInfo entry = sourceInfo.getEntrys().get(i);
                if (!entry.isIsRepaid() || info.getBizDate().compareTo(entry.getDate()) != 0 || entry.getAmount().compareTo(info.getAmount()) != 0) continue;
                updateEntryIds.add(entry.getId().toString());
            }
            if (updateEntryIds.size() == 0) {
                return;
            }
            String sql = "UPDATE t_fin_loanentry SET FISREPAID = 0 WHERE FID in (''";
            for (int i = 0; i < updateEntryIds.size(); ++i) {
                sql = sql + ",'" + (String)updateEntryIds.get(i) + "'";
            }
            sql = sql + ")";
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    private SelectorItemCollection getLoanSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("Institution.id"));
        sic.add(new SelectorItemInfo("Institution.number"));
        sic.add(new SelectorItemInfo("Institution.name"));
        sic.add(new SelectorItemInfo("CreditorGroup.id"));
        sic.add(new SelectorItemInfo("CreditorGroup.number"));
        sic.add(new SelectorItemInfo("CreditorGroup.name"));
        sic.add(new SelectorItemInfo("BankAcct.id"));
        sic.add(new SelectorItemInfo("BankAcct.number"));
        sic.add(new SelectorItemInfo("BankAcct.name"));
        sic.add(new SelectorItemInfo("depositary.id"));
        sic.add(new SelectorItemInfo("depositary.number"));
        sic.add(new SelectorItemInfo("depositary.name"));
        sic.add(new SelectorItemInfo("LoanAcct.id"));
        sic.add(new SelectorItemInfo("LoanAcct.number"));
        sic.add(new SelectorItemInfo("LoanAcct.name"));
        sic.add(new SelectorItemInfo("CreditLimit.id"));
        sic.add(new SelectorItemInfo("CreditLimit.ShareType"));
        sic.add(new SelectorItemInfo("CreditLimit.balance"));
        sic.add(new SelectorItemInfo("CreditLimit.number"));
        sic.add(new SelectorItemInfo("CreditLimit.currency.id"));
        sic.add(new SelectorItemInfo("CreditLimit.limitType"));
        sic.add(new SelectorItemInfo("CreditLimit.GuaranteeType.id"));
        sic.add(new SelectorItemInfo("CreditLimit.CreditUsage.colligateCredit"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.amount"));
        sic.add(new SelectorItemInfo("entrys.date"));
        sic.add(new SelectorItemInfo("entrys.repayIntType"));
        sic.add(new SelectorItemInfo("entrys.BlockFlowType.id"));
        sic.add(new SelectorItemInfo("entrys.BlockFlowType.number"));
        sic.add(new SelectorItemInfo("entrys.BlockFlowType.name"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.*"));
        sic.add(new SelectorItemInfo("CreditCurrency.id"));
        sic.add(new SelectorItemInfo("CreditCurrency.number"));
        sic.add(new SelectorItemInfo("CreditCurrency.name"));
        sic.add(new SelectorItemInfo("CreditCurrency.precision"));
        sic.add(new SelectorItemInfo("intPayDateEntrys.*"));
        sic.add(new SelectorItemInfo("GaranteeType.id"));
        sic.add(new SelectorItemInfo("GaranteeType.number"));
        sic.add(new SelectorItemInfo("GaranteeType.name"));
        sic.add(new SelectorItemInfo("GaranteeType.property"));
        sic.add(new SelectorItemInfo("costCenter.id"));
        sic.add(new SelectorItemInfo("costCenter.number"));
        sic.add(new SelectorItemInfo("costCenter.name"));
        sic.add(new SelectorItemInfo("fundFlowItem.*"));
        sic.add(new SelectorItemInfo("isLPR"));
        sic.add(new SelectorItemInfo("GaranteeType.*"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.id"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.parentBillType"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.parentBillId"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.scale"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.amount"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.exchangeRate"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.balance"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.guaranteeName"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.billId"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.billNumber"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.billtype"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.guaranteeCompHand"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.wage"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.wageRate"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.canWage"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.realWage"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.remark"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.mortgageType"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.guaranteeType.*"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.guaranteeComp.*"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.guaranteeCustomer.*"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.currency.*"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.guaranteeTypeProperty"));
        return sic;
    }

    @Override
    protected void afterSubmit(Context ctx, IObjectValue model, FinancingBillInfo finBillInfo, boolean isAddNew) throws BOSException, EASBizException {
        RepaymentInfo info = (RepaymentInfo)model;
        if (FMHelper.isInstanceof((String)finBillInfo.getSourceBillId(), LoanContractInfo.class)) {
            LoanContractInfo loanInfo = LoanContractFactory.getLocalInstance(ctx).getLoanContractInfo((IObjectPK)new ObjectUuidPK(finBillInfo.getSourceBillId().toString()));
            RepaymentInfo repaymentInfo = RepaymentFactory.getLocalInstance(ctx).getRepaymentInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()));
            if (isAddNew) {
                this.fillLoanContractRepayEntry(ctx, loanInfo, finBillInfo, repaymentInfo, BOTBillOperStateEnum.ADDNEW);
                this.fillLoanContractOverView(ctx, loanInfo, (LoanInfo)finBillInfo, repaymentInfo, BOTBillOperStateEnum.ADDNEW);
                this.fillLoanContractActLoanSituation(ctx, loanInfo, (LoanInfo)finBillInfo, repaymentInfo, BOTBillOperStateEnum.ADDNEW);
                LoanContractFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(loanInfo.getId().toString()), (CoreBaseInfo)loanInfo);
            } else {
                this.fillLoanContractRepayEntry(ctx, loanInfo, finBillInfo, repaymentInfo, BOTBillOperStateEnum.EDIT);
                LoanContractFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(loanInfo.getId().toString()), (CoreBaseInfo)loanInfo);
            }
        }
        if (FMHelper.isInstanceof((String)info.getSourceBillId(), LoanInfo.class) && !EmptyUtil.isEmpty((Object)info.getOldBizDate())) {
            int i;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("entrys.*"));
            LoanInfo sourceInfo = LoanFactory.getLocalInstance(ctx).getLoanInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId().toString()), this.getLoanSelector());
            for (i = 0; i < sourceInfo.getEntrys().size(); ++i) {
                LoanEntryInfo entry = sourceInfo.getEntrys().get(i);
                if (info.getOldBizDate().compareTo(entry.getDate()) != 0 || !info.getAmount().equals(entry.getAmount()) || !entry.isIsRepaid()) continue;
                entry.setDate(info.getBizDate());
            }
            sourceInfo.getEntrys().sort("date");
            for (i = 0; i < sourceInfo.getEntrys().size(); ++i) {
                sourceInfo.getEntrys().get(i).setSeq(i);
            }
            LoanFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(sourceInfo.getId().toString()), (CoreBaseInfo)sourceInfo);
        }
    }

    private void fillLoanContractRepayEntry(Context ctx, LoanContractInfo loanInfo, FinancingBillInfo finBillInfo, RepaymentInfo repaymentInfo, BOTBillOperStateEnum bOTBillOperStateEnum) throws BOSException, EASBizException {
        block3: {
            block4: {
                block2: {
                    if (!bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) break block2;
                    for (int i = 0; i < loanInfo.getLoanContractRepayEntry().size(); ++i) {
                        LoanContractRepayEntryInfo entryInfo = loanInfo.getLoanContractRepayEntry().get(i);
                        if (!entryInfo.getRepayNumber().equals(repaymentInfo.getNumber())) continue;
                        loanInfo.getLoanContractRepayEntry().remove(entryInfo);
                    }
                    break block3;
                }
                if (!bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.ADDNEW)) break block4;
                LoanContractRepayEntryInfo entryInfo = new LoanContractRepayEntryInfo();
                entryInfo.setLoanId(finBillInfo.getId().toString());
                entryInfo.setLoanNumber(finBillInfo.getNumber());
                entryInfo.setRepayNumber(repaymentInfo.getNumber());
                entryInfo.setDate(repaymentInfo.getBizDate());
                entryInfo.setRePayCurrency(repaymentInfo.getCurrency());
                entryInfo.setAmount(repaymentInfo.getSourceAmount());
                entryInfo.setRepayLocalAmt(repaymentInfo.getLocalAmount());
                loanInfo.getLoanContractRepayEntry().add(entryInfo);
                break block3;
            }
            if (!bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.EDIT)) break block3;
            for (int i = 0; i < loanInfo.getLoanContractRepayEntry().size(); ++i) {
                LoanContractRepayEntryInfo entryInfo = loanInfo.getLoanContractRepayEntry().get(i);
                if (!entryInfo.getRepayNumber().equals(repaymentInfo.getNumber())) continue;
                entryInfo.setLoanId(finBillInfo.getId().toString());
                entryInfo.setLoanNumber(finBillInfo.getNumber());
                entryInfo.setRepayNumber(repaymentInfo.getNumber());
                entryInfo.setDate(repaymentInfo.getBizDate());
                entryInfo.setRePayCurrency(repaymentInfo.getCurrency());
                entryInfo.setAmount(repaymentInfo.getSourceAmount());
                entryInfo.setRepayLocalAmt(repaymentInfo.getLocalAmount());
            }
        }
    }

    private void fillLoanContractOverView(Context ctx, LoanContractInfo info, LoanInfo loanInfo, RepaymentInfo repaymentInfo, BOTBillOperStateEnum bOTBillOperStateEnum) throws BOSException, EASBizException {
        if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
            BigDecimal paidAmount = info.getLoanContractOverView().get(0).getPaidAmount() == null ? new BigDecimal(0) : info.getLoanContractOverView().get(0).getPaidAmount();
            BigDecimal allRepayedAmt = info.getLoanContractOverView().get(0).getRepayedLocalAmt() == null ? new BigDecimal(0) : info.getLoanContractOverView().get(0).getRepayedLocalAmt();
            BigDecimal rePayedAmt = repaymentInfo.getAmount() == null ? new BigDecimal(0) : repaymentInfo.getAmount();
            allRepayedAmt = allRepayedAmt.subtract(rePayedAmt);
            info.getLoanContractOverView().get(0).setRepayedLocalAmt(allRepayedAmt);
            info.getLoanContractOverView().get(0).setUnRepayedLocalAmt(paidAmount.subtract(allRepayedAmt));
        } else {
            BigDecimal paidAmount = info.getLoanContractOverView().get(0).getPaidAmount() == null ? new BigDecimal(0) : info.getLoanContractOverView().get(0).getPaidAmount();
            BigDecimal allRepayedAmt = info.getLoanContractOverView().get(0).getRepayedLocalAmt() == null ? new BigDecimal(0) : info.getLoanContractOverView().get(0).getRepayedLocalAmt();
            BigDecimal rePayedAmt = repaymentInfo.getAmount() == null ? new BigDecimal(0) : repaymentInfo.getAmount();
            allRepayedAmt = allRepayedAmt.add(rePayedAmt);
            info.getLoanContractOverView().get(0).setRepayedLocalAmt(allRepayedAmt);
            info.getLoanContractOverView().get(0).setUnRepayedLocalAmt(paidAmount.subtract(allRepayedAmt));
        }
    }

    private void fillLoanContractActLoanSituation(Context ctx, LoanContractInfo info, LoanInfo loanInfo, RepaymentInfo repaymentInfo, BOTBillOperStateEnum bOTBillOperStateEnum) throws BOSException, EASBizException {
        for (int i = 0; i < info.getLoanContractActLoanSituation().size(); ++i) {
            BigDecimal repayedAmt;
            if (!loanInfo.getId().toString().equals(info.getLoanContractActLoanSituation().get(i).getLoanId())) continue;
            BigDecimal balance = Constants.ZERO;
            BigDecimal bigDecimal = repayedAmt = info.getLoanContractActLoanSituation().get(i).getRepayedAmt() == null ? Constants.ZERO : info.getLoanContractActLoanSituation().get(i).getRepayedAmt();
            if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                balance = loanInfo.getBalance().add(repaymentInfo.getAmount());
                repayedAmt = repayedAmt.subtract(repaymentInfo.getAmount());
            } else {
                balance = loanInfo.getBalance();
                repayedAmt = repayedAmt.add(repaymentInfo.getAmount());
            }
            info.getLoanContractActLoanSituation().get(i).setBalance(balance);
            info.getLoanContractActLoanSituation().get(i).setRepayedAmt(repayedAmt);
            break;
        }
    }

    @Override
    protected void subVerifyBeforeBook(Context ctx, RepaymentInfo info) throws BOSException, EASBizException {
    }

    @Override
    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new PaymentBillInfo().getBOSType())) {
            RepaymentInfo info = (RepaymentInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                RepaymentInfo repayInfo = RepaymentFactory.getLocalInstance(ctx).getRepaymentInfo("select totalPayedAmt where id = '" + srcBillPK.toString() + "'");
                info.setTotalPayedAmt(repayInfo.getTotalPayedAmt());
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO);
    }

    @Override
    protected PaymentBillCollection getPaymentBillColl(Context ctx, CoreBillBaseCollection coreBillBaseCol, String destBillBosType) throws BOSException, BTPException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        CoreBillBaseCollection newCoreBillBaseCol = new CoreBillBaseCollection();
        PaymentBillCollection paymentBillCol = new PaymentBillCollection();
        PaymentBillEntryCollection allEntrys = new PaymentBillEntryCollection();
        BTPTransformResult result = null;
        PaymentBillInfo cautionPaymentBill = null;
        for (int i = 0; i < coreBillBaseCol.size(); ++i) {
            newCoreBillBaseCol.clear();
            newCoreBillBaseCol.add(coreBillBaseCol.get(i));
            result = iBTPManager.transform(newCoreBillBaseCol, destBillBosType);
            PaymentBillInfo paymentBill = (PaymentBillInfo)result.getBills().getObject(0);
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)paymentBill.getEntries())) {
                for (int j = 0; j < paymentBill.getEntries().size(); ++j) {
                    paymentBill.getEntries().get(j).setSourceBillId(coreBillBaseCol.get(i).getId().toString());
                }
                allEntrys.addCollection(paymentBill.getEntries());
            }
            if (i == 0) {
                cautionPaymentBill = (PaymentBillInfo)result.getBills().getObject(0);
            }
            if (i != coreBillBaseCol.size() - 1) continue;
            paymentBill.getEntries().clear();
            paymentBill.getEntries().addCollection(allEntrys);
            paymentBillCol.add(paymentBill);
            paymentBillCol.add(cautionPaymentBill);
        }
        if (result != null && result.getBOTRelationCollection() != null && result.getBOTRelationCollection().get(0) != null) {
            this.mappingID = result.getBOTRelationCollection().get(0).getBOTMappingID();
        }
        return paymentBillCol;
    }

    @Override
    protected Map _commitToBe(Context ctx, String[] ids) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _synStatus(Context ctx, String[] ids) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _modifyBankReturnStatus(Context ctx, String id, int status) throws BOSException, EASBizException {
        return null;
    }
}

