/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.LoanInterestCollection;
import com.kingdee.eas.fm.fin.LoanInterestFactory;
import com.kingdee.eas.fm.fin.LoanInterestInfo;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.StatusExtEnum;
import com.kingdee.eas.fm.im.IntCalTypeEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class LoanReverseHelper {
    public static LoanReverseHelper instance = null;
    private Map botpRelationShip = new HashMap();

    private LoanReverseHelper() {
    }

    public static LoanReverseHelper getInstance() {
        if (instance == null) {
            instance = new LoanReverseHelper();
        }
        return instance;
    }

    public void receivingBillSubmited(Context ctx, String srcID, String receivingBillID) throws BOSException {
        if (this.isLoanSrc(srcID)) {
            this.updateLoanBill(ctx, srcID, Boolean.TRUE);
            this.saveBOTPRelationShip(ctx, srcID, receivingBillID);
        }
    }

    public void paymentBillSubmited(Context ctx, PaymentBillInfo info) throws BOSException, EASBizException {
        boolean loanIntMul;
        String srcid = info.getSourceBillId();
        boolean loanIntSingle = this.isInterestSrc(info) && info.getEntries().size() > 0 && EmptyUtil.isEmpty((String)info.getEntries().get(0).getSourceBillId());
        boolean bl = loanIntMul = this.isInterestSrc(info) && info.getEntries().size() > 0 && !EmptyUtil.isEmpty((String)info.getEntries().get(0).getSourceBillId());
        if (loanIntSingle || this.isRepaySrc(info.getSourceBillId())) {
            this.updateSrcBill(ctx, srcid, Boolean.TRUE);
            this.saveBOTPRelationShip(ctx, srcid, info.getId().toString());
        } else if (loanIntMul) {
            for (int index = 0; index < info.getEntries().size(); ++index) {
                srcid = info.getEntries().get(index).getSourceBillId();
                this.updateSrcBill(ctx, srcid, Boolean.TRUE);
                this.saveBOTPRelationShip(ctx, srcid, info.getId().toString());
            }
        }
    }

    public void paymentBillDelete(Context ctx, PaymentBillInfo info) throws BOSException, EASBizException {
        boolean loanIntMul;
        String srcid = info.getSourceBillId();
        boolean loanIntSingle = this.isInterestSrc(info) && info.getEntries().size() > 0 && EmptyUtil.isEmpty((String)info.getEntries().get(0).getSourceBillId());
        boolean bl = loanIntMul = this.isInterestSrc(info) && info.getEntries().size() > 0 && !EmptyUtil.isEmpty((String)info.getEntries().get(0).getSourceBillId());
        if (loanIntSingle) {
            this.updateSrcBill(ctx, srcid, Boolean.FALSE);
        } else if (loanIntMul) {
            for (int index = 0; index < info.getEntries().size(); ++index) {
                srcid = info.getEntries().get(index).getSourceBillId();
                this.updateSrcBill(ctx, srcid, Boolean.FALSE);
            }
        }
    }

    private boolean isRepaySrc(String srcID) {
        if (srcID == null || srcID.trim().length() == 0) {
            return false;
        }
        BOSUuid uuid = BOSUuid.read((String)srcID);
        BOSObjectType bosType = uuid.getType();
        return bosType.equals((Object)RepaymentInfo.BOSTYPE);
    }

    private boolean isInterestSrc(PaymentBillInfo info) {
        String srcid = info.getSourceBillId();
        if (EmptyUtil.isEmpty((String)srcid) && info.getEntries().size() > 0) {
            srcid = info.getEntries().get(0).getSourceBillId();
        }
        if (!EmptyUtil.isEmpty((String)srcid)) {
            BOSUuid uuid = BOSUuid.read((String)srcid);
            BOSObjectType bosType = uuid.getType();
            return bosType.equals((Object)new LoanInterestInfo().getBOSType());
        }
        return false;
    }

    private void updateSrcBill(Context ctx, String srcID, Boolean isGenPayBill) throws EASBizException, BOSException {
        BOSUuid uuid = BOSUuid.read((String)srcID);
        BOSObjectType bosType = uuid.getType();
        if (bosType.equals((Object)new LoanInterestInfo().getBOSType()) && isGenPayBill.booleanValue()) {
            LoanInterestInfo loanIntInfo;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)srcID));
            ev.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("interestType"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("cashier"));
            selector.add(new SelectorItemInfo("isGenPayBill"));
            selector.add(new SelectorItemInfo("statusExtEnum"));
            selector.add(new SelectorItemInfo("realInterest"));
            ev.setSelector(selector);
            LoanInterestCollection loanCollection = LoanInterestFactory.getLocalInstance(ctx).getLoanInterestCollection(ev);
            if (loanCollection.size() > 0 && ((loanIntInfo = loanCollection.get(0)).getInterestType() == IntCalTypeEnum.PRE_INT || loanIntInfo.getCashier() != null || loanIntInfo.isIsGenPayBill() || loanIntInfo.getStatusExtEnum() != StatusExtEnum.AUDIT || loanIntInfo == null || loanIntInfo.getRealInterest().compareTo(BigDecimal.ZERO) == 0)) {
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"150_LoanReverseHelper", (Locale)ctx.getLocale()) + loanIntInfo.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"151_LoanReverseHelper", (Locale)ctx.getLocale())});
            }
        }
        EntityObjectInfo eoi = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType);
        String tableName = eoi.getTable().getName();
        String sql = "update " + tableName + " set FIsGenPayBill = ?  where fid = ?".intern();
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{isGenPayBill, srcID});
    }

    private boolean isRepayOrInterestSrc(String srcID) {
        if (srcID == null || srcID.trim().length() == 0) {
            return false;
        }
        BOSUuid uuid = BOSUuid.read((String)srcID);
        BOSObjectType bosType = uuid.getType();
        return bosType.equals((Object)RepaymentInfo.BOSTYPE) || bosType.equals((Object)new LoanInterestInfo().getBOSType());
    }

    private boolean isLoanSrc(String srcID) {
        if (srcID == null || srcID.trim().length() == 0) {
            return false;
        }
        BOSUuid uuid = BOSUuid.read((String)srcID);
        BOSObjectType bosType = uuid.getType();
        return bosType.equals((Object)LoanInfo.BOSTYPE);
    }

    private void updateLoanBill(Context ctx, String srcID, Boolean isGenRecBill) throws BOSException {
        BOSUuid uuid = BOSUuid.read((String)srcID);
        BOSObjectType bosType = uuid.getType();
        EntityObjectInfo eoi = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType);
        String tableName = eoi.getTable().getName();
        String sql = "update " + tableName + " set FIsGenRecBill = ?  where fid = ?".intern();
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{isGenRecBill, srcID});
    }

    private void saveBOTPRelationShip(Context ctx, String srcID, String destID) throws BOSException {
        this.botpRelationShip.clear();
        this.botpRelationShip.put(srcID, destID);
        FMHelper.saveBOTRelation((Context)ctx, (Map)this.botpRelationShip);
    }

    public void receivingBillDelete(Context ctx, String srcID, String receivingBillID) throws BOSException {
        if (this.isLoanSrc(srcID)) {
            this.updateLoanBill(ctx, srcID, Boolean.FALSE);
        }
    }
}

