/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ebservice.CreditModifyDetail;
import com.kingdee.bos.ebservice.CreditModifyQueryResponseBody;
import com.kingdee.bos.ebservice.CreditModifyResponseBody;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.app.service.LetterOfCreditEBGServiceUtil;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.be.app.service.vo.ModifyCreditDetailVO;
import com.kingdee.eas.fm.be.app.service.vo.ModifyCreditQueryVO;
import com.kingdee.eas.fm.be.app.service.vo.ModifyCreditVO;
import com.kingdee.eas.fm.be.app.util.FmBeWebUtils;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.AbstractLetterOfCreditInfo;
import com.kingdee.eas.fm.fin.CreditFinancingReduceCollection;
import com.kingdee.eas.fm.fin.CreditFinancingReduceFactory;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.LetterException;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LetterStatusEnum;
import com.kingdee.eas.fm.fin.ModifyLetterCollection;
import com.kingdee.eas.fm.fin.ModifyLetterEntryCollection;
import com.kingdee.eas.fm.fin.ModifyLetterEntryInfo;
import com.kingdee.eas.fm.fin.ModifyLetterFactory;
import com.kingdee.eas.fm.fin.ModifyLetterInfo;
import com.kingdee.eas.fm.fin.app.AbstractModifyLetterControllerBean;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.log4j.Logger;
import org.jfree.util.Log;

public class ModifyLetterControllerBean
extends AbstractModifyLetterControllerBean {
    private static final long serialVersionUID = -3933417427763797165L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.ModifyLetterControllerBean");
    public static final String NTP_RESOURCE = "com.kingdee.eas.fm.ntp.NtpResource";
    private static final String NTP_RES = "com.kingdee.eas.fm.ntp.NtpResource";
    public static final String RESOURCE = "com.kingdee.eas.fm.fin.LetterOfCreditWebResource";
    private static String[] modifyItems = new String[]{"Beneficiary_en", "ExpiryDate_en", "ShipmentPeriod_en", "PortLoading_en", "AirportDestination_en", "Amount_en", "DispatchFrom_en", "DispatchTo_en", "AirportDeparture_en", "PortDischarge_en", "PlaceFinalDest_en", "PlaceDelivery_en", "PlaceRecepit_en", "Applicant_en", "DispatchFrom_zh", "DispatchTo_zh", "AirportDeparture_zh", "PortDischarge_zh", "PlaceFinalDest_zh", "PlaceDelivery_zh", "PlaceRecepit_zh", "Applicant_zh", "Beneficiary_zh", "ExpiryDate_zh", "ShipmentPeriod_zh", "PortLoading_zh", "AirportDestination_zh", "Amount_zh", "ContractNumber", "ContractAmount", "Amount", "IsForward", "ForwardDate", "ExpiredDate", "LoadPort", "DestinationPort", "LoadDate", "NotifyBank", "TransportMode", "IsDYZ", "FluctuateScale", "FluctuateScaleFloor", "LetterContent", "IsBatch", "IsDivert", "ReMark", "CreditPercentage"};
    private static String[] attrLcs = new String[]{"Beneficiary", "ExpiredDate", "LoadDate", "LoadPort", "DestinationPort", "Amount", "LoadPort", "DestinationPort", "LoadPort", "DestinationPort", "finalPlace", "DestinationPort", "LoadPort", "applicantName", "LoadPort", "DestinationPort", "LoadPort", "DestinationPort", "finalPlace", "DestinationPort", "LoadPort", "applicantName", "Beneficiary", "ExpiredDate", "LoadDate", "LoadPort", "DestinationPort", "Amount", "contractNumber", "contractAmount", "Amount", "IsForward", "forwardDate", "ExpiredDate", "LoadPort", "DestinationPort", "LoadDate", "NotifyBank", "TransportMode", "IsDYZ", "FluctuateScale", "FluctuateScaleFloor", "LtterContent", "IsBatch", "IsDivert", "Remark", "CreditPercentage"};

    @Override
    protected int _getModifyTimes(Context ctx, String id) throws BOSException, EASBizException {
        String sql = "Select count(*) as total_1 From T_FIN_ModifyLetter Where FLetterNumber = ? ";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{id});
        int num = 0;
        try {
            if (rowset.next()) {
                num = rowset.getInt("total_1");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return num;
    }

    @Override
    protected void _audit(Context ctx, String id, IObjectCollection col) throws BOSException, EASBizException {
        ModifyLetterInfo modifyLetterInfo = ModifyLetterFactory.getLocalInstance(ctx).getModifyLetterInfo((IObjectPK)new ObjectUuidPK(id));
        LetterOfCreditInfo letterOfCreditInfo = this.updateLetterColumn(ctx, (IObjectValue)modifyLetterInfo, 1);
        this.modifyOther(ctx, letterOfCreditInfo);
        if (col != null) {
            letterOfCreditInfo.setReduceCol((CreditFinancingReduceCollection)col);
        }
        this.verify(ctx, letterOfCreditInfo);
        if (!letterOfCreditInfo.isIsDirect()) {
            LetterOfCreditFactory.getLocalInstance(ctx).submit((CoreBaseInfo)letterOfCreditInfo);
        }
        String sql = " Update t_fin_modifyletter Set FAuditorID =?,FBillStatus =? Where FID=? ";
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString(), 3, id});
    }

    @Override
    protected void _reAudit(Context ctx, String id, IObjectCollection col) throws BOSException, EASBizException {
        this._checkStatus(ctx, id, 2);
        this._reAuditCheck(ctx, id);
        ModifyLetterInfo modifyLetterInfo = ModifyLetterFactory.getLocalInstance(ctx).getModifyLetterInfo((IObjectPK)new ObjectUuidPK(id));
        LetterOfCreditInfo letterOfCreditInfo = this.updateLetterColumn(ctx, (IObjectValue)modifyLetterInfo, 2);
        this.modifyOther(ctx, letterOfCreditInfo);
        if (col != null) {
            letterOfCreditInfo.setReduceCol((CreditFinancingReduceCollection)col);
        }
        this.verify(ctx, letterOfCreditInfo);
        LetterOfCreditFactory.getLocalInstance(ctx).submit((CoreBaseInfo)letterOfCreditInfo);
        String sql = " Update t_fin_modifyletter Set FAuditorID = null, FBillStatus =? Where FID=? ";
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{1, id});
    }

    @Override
    protected void _checkStatus(Context ctx, String id, int operateType) throws BOSException, EASBizException {
        String auditorId = null;
        String letterId = null;
        IRowSet rowset = null;
        AbstractLetterOfCreditInfo info = null;
        String sql = " Select FAuditorID as audi , fletterid From t_fin_modifyletter Where FID =?";
        rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
        try {
            if (rowset.next()) {
                auditorId = rowset.getString("audi");
                letterId = rowset.getString("fletterid");
                info = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(letterId));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (info != null && info.getLetterStatus().equals((Object)LetterStatusEnum.close)) {
            throw new LetterException(LetterException.LETTERISCLOSED);
        }
        if (operateType == 1) {
            if (!StringUtils.isEmpty((String)auditorId)) {
                throw new LetterException(LetterException.ISAUDITED);
            }
        } else if (operateType == 2) {
            if (StringUtils.isEmpty((String)auditorId)) {
                throw new LetterException(LetterException.ISNOTAUDITED);
            }
        } else if (operateType == 3) {
            if (!StringUtils.isEmpty((String)auditorId)) {
                throw new LetterException(LetterException.NOTEDIT);
            }
        } else if (!StringUtils.isEmpty((String)auditorId)) {
            throw new LetterException(LetterException.NOTDEL);
        }
    }

    protected LetterOfCreditInfo updateLetterColumn(Context arg0, IObjectValue arg1, int operateType) throws BOSException, EASBizException {
        int i;
        Object object = null;
        ModifyLetterInfo letterInfo = (ModifyLetterInfo)arg1;
        ModifyLetterEntryCollection letterInfoEntryCollection = letterInfo.getEntrys();
        LetterOfCreditInfo info = (LetterOfCreditInfo)FinUtils.getFinBillLocal(arg0, letterInfo.getLetterId());
        HashMap<String, String> map = new HashMap<String, String>();
        for (i = 0; i < modifyItems.length; ++i) {
            map.put(modifyItems[i], attrLcs[i]);
        }
        for (i = 0; i < letterInfoEntryCollection.size(); ++i) {
            ModifyLetterEntryInfo entryInfo = letterInfoEntryCollection.get(i);
            object = operateType == 1 ? this.getRealValue(entryInfo, entryInfo.getContentAfterM(), arg0) : this.getRealValue(entryInfo, entryInfo.getContentBeforeM(), arg0);
            this.setValue(info, (String)map.get(entryInfo.getModifyItem().getName()), object);
        }
        return info;
    }

    private Object getRealValue(ModifyLetterEntryInfo entryInfo, String value, Context ctx) throws BOSException, EASBizException {
        Object object = null;
        if (entryInfo.getModifyItem().getValue().equals("0") || entryInfo.getModifyItem().getValue().equals("153") || entryInfo.getModifyItem().getValue().equals("53") || entryInfo.getModifyItem().getValue().equals("154") || entryInfo.getModifyItem().getValue().equals("54") || entryInfo.getModifyItem().getValue().equals("156") || entryInfo.getModifyItem().getValue().equals("56") || entryInfo.getModifyItem().getValue().equals("157") || entryInfo.getModifyItem().getValue().equals("57") || entryInfo.getModifyItem().getValue().equals("159") || entryInfo.getModifyItem().getValue().equals("59") || entryInfo.getModifyItem().getValue().equals("160") || entryInfo.getModifyItem().getValue().equals("60") || entryInfo.getModifyItem().getValue().equals("162") || entryInfo.getModifyItem().getValue().equals("62") || entryInfo.getModifyItem().getValue().equals("163") || entryInfo.getModifyItem().getValue().equals("163") || entryInfo.getModifyItem().getValue().equals("10") || entryInfo.getModifyItem().getValue().equals("6") || entryInfo.getModifyItem().getValue().equals("7") || entryInfo.getModifyItem().getValue().equals("13") || entryInfo.getModifyItem().getValue().equals("1") || entryInfo.getModifyItem().getValue().equals("2") || entryInfo.getModifyItem().getValue().equals("12") || entryInfo.getModifyItem().getValue().equals("17") || entryInfo.getModifyItem().getValue().equals("4") || entryInfo.getModifyItem().getValue().equals("16") || entryInfo.getModifyItem().getValue().equals("161") || entryInfo.getModifyItem().getValue().equals("61") || entryInfo.getModifyItem().getValue().equals("52") || entryInfo.getModifyItem().getValue().equals("155") || entryInfo.getModifyItem().getValue().equals("55") || entryInfo.getModifyItem().getValue().equals("158") || entryInfo.getModifyItem().getValue().equals("56") || entryInfo.getModifyItem().getValue().equals("150") || entryInfo.getModifyItem().getValue().equals("50") || entryInfo.getModifyItem().getValue().equals("18")) {
            object = value;
        }
        if ((entryInfo.getModifyItem().getValue().equals("159") || entryInfo.getModifyItem().getValue().equals("59")) && value != null) {
            object = value.getBytes();
        }
        if ((entryInfo.getModifyItem().getValue().equals("5") || entryInfo.getModifyItem().getValue().equals("8") || entryInfo.getModifyItem().getValue().equals("151") || entryInfo.getModifyItem().getValue().equals("51") || entryInfo.getModifyItem().getValue().equals("52") || entryInfo.getModifyItem().getValue().equals("52")) && value != null) {
            DateFormat format = (DateFormat)FMHelper.getNantionalDateMap((Context)ctx).get("dateFormat");
            try {
                object = format.parse(value);
            }
            catch (ParseException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (entryInfo.getModifyItem().getValue().equals("14") || entryInfo.getModifyItem().getValue().equals("15") || entryInfo.getModifyItem().getValue().equals("11") || entryInfo.getModifyItem().getValue().equals("3")) {
            object = value != null ? new Boolean(value) : Boolean.valueOf(false);
        }
        if (entryInfo.getModifyItem().getValue().equals("9")) {
            if (value == null) {
                object = null;
            } else {
                BankInfo typeInfo = BankFactory.getLocalInstance((Context)ctx).getBankInfo((IObjectPK)new ObjectUuidPK(value));
                object = typeInfo;
            }
        }
        return object;
    }

    protected void verify(Context ctx, FinancingBillInfo letterOfCreditInfo) throws BOSException, EASBizException {
        LetterOfCreditInfo loc = (LetterOfCreditInfo)(letterOfCreditInfo = (LetterOfCreditInfo)letterOfCreditInfo);
        if (loc.getFluctuateScale() > 100 || loc.getFluctuateScale() < -100 || loc.getFluctuateScalefloor() > 100 || loc.getFluctuateScalefloor() < -100) {
            throw new LetterException(LetterException.FLUCTUATESCALE);
        }
        if (!loc.isIsDYZ()) {
            loc.setFluctuateScale(0);
            loc.setFluctuateScalefloor(0);
        }
        if (loc.getForwardDate() > 0 && !loc.isIsForward()) {
            loc.setForwardDate(0);
        }
        Date dateBegin = DateTimeUtils.truncateDate((Date)letterOfCreditInfo.getIssueDate());
        Date dateEnd = DateTimeUtils.truncateDate((Date)letterOfCreditInfo.getExpiredDate());
        if (!dateEnd.after(dateBegin)) {
            throw new LetterException(LetterException.LETTEROFCREDITENDDATELATERTHANBEGINDATE);
        }
    }

    private void setValue(LetterOfCreditInfo info, String ColumnName, Object ColumnValue) throws BOSException, EASBizException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entity = null;
        entity = loader.getEntity(info.getBOSType());
        PropertyCollection pc = entity.getInheritedNoDuplicatedProperties();
        try {
            for (int i = 0; i < pc.size(); ++i) {
                PropertyInfo pro = pc.get(i);
                String fieldName = pro.getName();
                if (!ColumnName.equalsIgnoreCase(fieldName)) continue;
                if (!"entrys".equals(fieldName)) {
                    BindingUtility.setBeanProperty((Object)info, (String)fieldName, (Object)ColumnValue);
                }
                break;
            }
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (RuntimeException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Throwable e) {
            throw new BOSException(e);
        }
    }

    @Override
    protected void _auditCheck(Context ctx, String id) throws BOSException, EASBizException {
        String sql = " Select count(*)  as total From t_fin_modifyletter Where FLetterId =? and (FAuditorID='' or FAuditorID is null) ";
        IRowSet rowset = null;
        int num = 0;
        rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
        try {
            if (rowset.next()) {
                num = rowset.getInt("total");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (num > 0) {
            throw new LetterException(LetterException.NOTPERMITAUDIT);
        }
    }

    @Override
    protected void _reAuditCheck(Context ctx, String id) throws BOSException, EASBizException {
        String sql = " Select count(*)  as total From t_fin_modifyletter Where FLetterId =? and FModifyNumber > ?";
        IRowSet rowset = null;
        int num = 0;
        ModifyLetterInfo info = ModifyLetterFactory.getLocalInstance(ctx).getModifyLetterInfo((IObjectPK)new ObjectUuidPK(id));
        rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{info.getLetterId(), String.valueOf(info.getModifyNumber())});
        try {
            if (rowset.next()) {
                num = rowset.getInt("total");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (num > 0) {
            throw new LetterException(LetterException.NOTPERMITREAUDIT);
        }
    }

    @Override
    protected void _modifyletterCheck(Context ctx, String id) throws BOSException, EASBizException {
        String sql = " Select count(*)  as total From t_fin_modifyletter Where FLetterId =? and (FAuditorID='' or FAuditorID is null) ";
        IRowSet rowset = null;
        int num = 0;
        rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
        try {
            if (rowset.next()) {
                num = rowset.getInt("total");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (num > 0) {
            throw new LetterException(LetterException.NOTPERMITAUDIT);
        }
    }

    private void modifyOther(Context ctx, LetterOfCreditInfo letterInfo) throws BOSException, EASBizException, FinBizException {
        BigDecimal Horizon = FinHorizon.getHorizon(letterInfo.getIssueDate(), letterInfo.getExpiredDate());
        BigDecimal biginfo = new BigDecimal(String.valueOf(Horizon));
        this.setValue(letterInfo, "Horizon", biginfo);
        BigDecimal bdAmount = letterInfo.getAmount();
        BigDecimal bdCurExRaTe = letterInfo.getLocalCurExRate();
        BigDecimal biginBalancefo = new BigDecimal(String.valueOf(bdAmount));
        this.setValue(letterInfo, "Amount", biginBalancefo);
        this.setValue(letterInfo, "AmountLocalCur", biginBalancefo.multiply(bdCurExRaTe));
        this.setValue(letterInfo, "CreditPercentage", letterInfo.getCreditPercentage());
        this.setValue(letterInfo, "usedCreditAmt", biginBalancefo);
        this.setValue(letterInfo, "creditLocalAmt", biginBalancefo.multiply(bdCurExRaTe));
        BigDecimal hasAmount = this.checkJe(ctx, letterInfo.getId().toString());
        if (hasAmount.equals(new BigDecimal(0))) {
            this.setValue(letterInfo, "Balance", biginBalancefo);
        } else {
            this.setValue(letterInfo, "Balance", biginBalancefo.subtract(hasAmount));
        }
        this.setValue(letterInfo, "creditLocalAmt", letterInfo.getAmount().multiply(letterInfo.getCreditCurExRate()).multiply(letterInfo.getCreditPercentage() == null ? Constants.ZERO : letterInfo.getCreditPercentage()).divide(Constants.ONE_HUNDRED, 2));
        this.setValue(letterInfo, "usedCreditAmt", letterInfo.getAmount().multiply(letterInfo.getCreditPercentage() == null ? Constants.ZERO : letterInfo.getCreditPercentage()).divide(Constants.ONE_HUNDRED, 2));
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
    }

    protected BigDecimal checkJe(Context ctx, String id) throws BOSException, EASBizException {
        String sql = "";
        IRowSet rowset = null;
        BigDecimal amount = new BigDecimal(0);
        BigDecimal balance = new BigDecimal(0);
        sql = " Select FAmount as amount,FBalance as balance From T_FIN_LETTEROFCREDIT Where FID =? ";
        rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
        try {
            while (rowset.next()) {
                amount = rowset.getBigDecimal("amount");
                balance = rowset.getBigDecimal("balance");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return amount.subtract(balance);
    }

    @Override
    protected Map _commitToBe(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        Set idSet = CASWebUtil.ids2Set((String[])ids);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.setSelector(this.getSelectors());
        ModifyLetterCollection coll = ModifyLetterFactory.getLocalInstance(ctx).getModifyLetterCollection(ev);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        ArrayList idList = new ArrayList(idSet);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
        for (int i = 0; i < coll.size(); ++i) {
            ModifyLetterInfo info = coll.get(i);
            LetterOfCreditInfo lcInfo = null;
            if (info.getLetterId() != null) {
                lcInfo = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectStringPK(info.getLetterId()), this.getLcSelectors());
            }
            Boolean isLocked = (Boolean)requestMap.get(info.getId().toString());
            try {
                this.beforeCommit(ctx, info, lcInfo, isLocked);
                this.doCommitToBe(ctx, info, lcInfo);
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(EASResource.getString((String)RESOURCE, (String)"MODIFYLETTER_COMMIT_TO_BE_FAILED", (Object[])new String[]{info.getLetterNumber(), e.getMessage()}));
            }
        }
        summary = success == ids.length ? summary + EASResource.getString((String)RESOURCE, (String)"ALL_COMMIT_TO_BE_SUCCESS") : summary + EASResource.getString((String)RESOURCE, (String)"COMMIT_TO_BE_RESULT", (Object[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    private void doCommitToBe(Context ctx, ModifyLetterInfo info, LetterOfCreditInfo lcInfo) throws EASBizException, BOSException {
        LetterOfCreditEBGServiceUtil util = new LetterOfCreditEBGServiceUtil();
        try {
            ModifyCreditVO vo = this.beforeProcess(ctx, info, lcInfo);
            CreditModifyResponseBody res = util.modifyCredit(ctx, vo);
            info.setIsCommitToBe(true);
            this.updatePartial(ctx, (CoreBaseInfo)info, ConvertUtils.SIC((Object[])new Object[]{"isCommitToBe"}));
            this.afterProcess(ctx, res.getDetails(), info, info.getDetailSeqID());
        }
        catch (BEException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            if (err instanceof AxisFault && ((AxisFault)err).getFaultString().indexOf("SAXException") != -1) {
                throw new BEException(BEException.EBSERVICE_PARAM_PARSE_ERROR);
            }
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
    }

    private void afterProcess(Context ctx, CreditModifyDetail[] creditModifyDetails, ModifyLetterInfo info, String detailSeqId) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        for (int i = 0; i < creditModifyDetails.length; ++i) {
            CreditModifyDetail detail = creditModifyDetails[i];
            if (detailSeqId == null || !detailSeqId.equals(detail.getDetailSeqId())) continue;
            sic.add(new SelectorItemInfo("bankReturnStatus"));
            info.setBankReturnStatus(BankReturnStatusEnum.getEnum((String)detail.getEbStatus()));
            sic.add(new SelectorItemInfo("bankReturnMsg"));
            info.setBankReturnMsg(detail.getBankStatusMsg());
            sic.add(new SelectorItemInfo("detailSeqID"));
            info.setDetailSeqID(detail.getDetailSeqId());
            if (3 != info.getBankReturnStatus().getValue()) continue;
            this.updateLetterOfCreditInfo(ctx, info);
        }
        this.updatePartial(ctx, (CoreBaseInfo)info, sic);
    }

    private void updateLetterOfCreditInfo(Context ctx, ModifyLetterInfo info) throws EASBizException, BOSException {
        ModifyLetterInfo mlInfo = ModifyLetterFactory.getLocalInstance(ctx).getModifyLetterInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()));
        LetterOfCreditInfo lcInfo = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectStringPK(info.getLetterId()), this.getLcSelectors());
        if (lcInfo.getCreditLimit() != null) {
            CreditFinancingReduceCollection col = CreditFinancingReduceFactory.getLocalInstance(ctx).getCreditFinancingReduceCollection(this.getQueryView(lcInfo.getCompany().getId(), lcInfo.getCreditLimit().getId(), lcInfo.getId()));
            lcInfo.setReduceCol(col);
        }
        lcInfo = this.updateLetterColumn(ctx, (IObjectValue)mlInfo, 1);
        this.modifyOther(ctx, lcInfo);
        LetterOfCreditFactory.getLocalInstance(ctx).submit((CoreBaseInfo)lcInfo);
    }

    private EntityViewInfo getQueryView(BOSUuid companyId, BOSUuid creditLimitId, BOSUuid financingBillid) {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.getSelector().add("shareOrg.*");
        evi.getSelector().add("finPro.*");
        evi.getSelector().add("creditEntry.*");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("ShareOrg.id", (Object)companyId));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("creditLimitID", (Object)creditLimitId.toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("billID", (Object)financingBillid.toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isUnion", (Object)Boolean.FALSE));
        String mask = "#0 and #1 and #2 and #3";
        evi.getFilter().setMaskString(mask);
        return evi;
    }

    private ModifyCreditVO beforeProcess(Context ctx, ModifyLetterInfo info, LetterOfCreditInfo lcInfo) throws EASBizException, BOSException {
        lcInfo = this.updateLetterColumn(ctx, (IObjectValue)info, 1);
        this.modifyOther(ctx, lcInfo);
        LetterOfCreditFactory.getLocalInstance(ctx).submit((CoreBaseInfo)lcInfo);
        ModifyCreditVO vo = new ModifyCreditVO();
        vo.setAccNo(lcInfo.getPayBankAcct().getBankAccountNumber());
        String[] serialNos = beServiceHelper.getSerialNumber((int)1);
        info.setDetailSeqID(serialNos[0]);
        info.setIsCommitToBe(true);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("detailSeqID"));
        sic.add(new SelectorItemInfo("isCommitToBe"));
        ModifyLetterFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
        vo.setBatchSeqId(serialNos[0]);
        vo.setBatchBizNo(info.getNumber());
        vo.setCurrency(lcInfo.getCurrency().getIsoCode());
        vo.setTotalCount("1");
        ModifyCreditDetailVO detailVo = new ModifyCreditDetailVO();
        ArrayList<ModifyCreditDetailVO> details = new ArrayList<ModifyCreditDetailVO>();
        detailVo.setApplicant(lcInfo.getApplicantName());
        detailVo.setApplyDate(info.getModifyDate().toString());
        detailVo.setBeneficiary(lcInfo.getBeneficiary());
        detailVo.setBranchNo(lcInfo.getInitialCode());
        detailVo.setCreditNo(info.getLetterNumber());
        detailVo.setDetailBizNo(info.getNumber());
        detailVo.setDetailSeqId(serialNos[0]);
        Log.error((Object)(" DetailSeqId:" + serialNos[0]));
        detailVo.setApplyItems(this.getApplyItems(ctx, info.getEntrys()));
        details.add(detailVo);
        vo.setDetails(details);
        return vo;
    }

    private String getApplyItems(Context ctx, ModifyLetterEntryCollection entries) throws EASBizException, BOSException {
        StringBuffer applyItems = new StringBuffer();
        for (int i = 0; i < entries.size(); ++i) {
            String beforeM;
            ModifyLetterEntryInfo entry = entries.get(i);
            String string = !entry.getModifyItem().getValue().equals("9") ? entry.getContentBeforeM() : (beforeM = this.getRealValue(entry, entry.getContentBeforeM(), ctx) == null ? null : ((BankInfo)this.getRealValue(entry, entry.getContentBeforeM(), ctx)).getName().toString());
            String afterM = !entry.getModifyItem().getValue().equals("9") ? entry.getContentAfterM() : (this.getRealValue(entry, entry.getContentAfterM(), ctx) == null ? null : ((BankInfo)this.getRealValue(entry, entry.getContentAfterM(), ctx)).getName().toString());
            applyItems.append(EASResource.getString((String)RESOURCE, (String)"modifyItems_102", (Object[])new String[]{entry.getModifyItem().getAlias(), beforeM, afterM}));
        }
        return applyItems.toString();
    }

    private void beforeCommit(Context ctx, ModifyLetterInfo info, LetterOfCreditInfo lcInfo, boolean isLocked) throws Exception {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_ModifyLetter_commitToBe");
        if (!isPermission) {
            throw new RuntimeException(EASResource.getString((String)RESOURCE, (String)"NO_COMMIT_TO_BE_PERMISSION", (Object[])new String[]{info.getCompany().getName()}));
        }
        if (!isLocked) {
            throw new Exception(EASResource.getString((String)RESOURCE, (String)"MODIFYLETTER_IS_LOCKED"));
        }
        if (3 != info.getBillStatus().getValue()) {
            throw new Exception(EASResource.getString((String)RESOURCE, (String)"MODIFYLETTER_NOT_AUDIT"));
        }
        if (!lcInfo.isIsDirect()) {
            throw new Exception(EASResource.getString((String)RESOURCE, (String)"MODIFYLETTER_IS_NOT_DIRECT"));
        }
        if (!info.isIsCommitToBe() || info.getBankReturnStatus() == null || BankReturnStatusEnum.COMMIT_FAIL.equals((Object)info.getBankReturnStatus())) {
            throw new LetterException(LetterException.COMMITEDCANTCMTAGIN);
        }
        if (info.isIsCommitToBe() && BankReturnStatusEnum.BANK_SUCCESS.equals((Object)info.getBankReturnStatus())) {
            throw new Exception(EASResource.getString((String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"043_COMMITTOBE_FINISHED"));
        }
    }

    @Override
    protected Map _synStatus(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        Set idSet = CASWebUtil.ids2Set((String[])ids);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.setSelector(this.getSelectors());
        ModifyLetterCollection coll = ModifyLetterFactory.getLocalInstance(ctx).getModifyLetterCollection(ev);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        ArrayList idList = new ArrayList(idSet);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
        int success = 0;
        for (int i = 0; i < coll.size(); ++i) {
            ModifyLetterInfo info = coll.get(i);
            LetterOfCreditInfo lcInfo = null;
            lcInfo = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(info.getLetterId()), this.getLcSelectors());
            try {
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_ModifyLetter_synStatus");
                if (!isPermission) {
                    throw new RuntimeException(EASResource.getString((String)RESOURCE, (String)"NO_SYN_STATUS_PERMISSION", (Object[])new String[]{lcInfo.getCompany().getName()}));
                }
                Boolean isLocked = (Boolean)requestMap.get(info.getId().toString());
                this.beforeSynStatus(ctx, info, lcInfo, isLocked);
                if (info.getBankReturnStatus() == null || info.getBankReturnStatus().getValue() != 3) {
                    this.doSynStatus(ctx, info, lcInfo);
                }
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(EASResource.getString((String)RESOURCE, (String)"MODIFYLETTER_SYN_STATUS_FAILED", (Object[])new String[]{info.getLetterNumber(), e.getMessage()}));
            }
        }
        summary = success == ids.length ? summary + EASResource.getString((String)RESOURCE, (String)"ALL_SYN_STATUS_SUCCESS") : summary + EASResource.getString((String)RESOURCE, (String)"MODIFYLETTER_SYN_STATUS_RESULT", (Object[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    private void doSynStatus(Context ctx, ModifyLetterInfo info, LetterOfCreditInfo lcInfo) throws EASBizException, BOSException {
        LetterOfCreditEBGServiceUtil util = new LetterOfCreditEBGServiceUtil();
        try {
            ModifyCreditQueryVO vo = this.beforeProcess4Update(ctx, info, lcInfo);
            CreditModifyQueryResponseBody res = util.modifyCreditQuery(ctx, vo);
            this.afterProcess(ctx, res.getDetails(), info, info.getDetailSeqID());
        }
        catch (BEException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            if (err instanceof AxisFault && ((AxisFault)err).getFaultString().indexOf("SAXException") != -1) {
                throw new BEException(BEException.EBSERVICE_PARAM_PARSE_ERROR);
            }
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
    }

    private ModifyCreditQueryVO beforeProcess4Update(Context ctx, ModifyLetterInfo info, LetterOfCreditInfo lcInfo) {
        ModifyCreditQueryVO vo = new ModifyCreditQueryVO();
        vo.setAccNo(lcInfo.getPayBankAcct().getBankAccountNumber());
        vo.setBatchSeqId(info.getDetailSeqID());
        vo.setCurrency(lcInfo.getCurrency().getIsoCode());
        return vo;
    }

    private void beforeSynStatus(Context ctx, ModifyLetterInfo info, LetterOfCreditInfo lcInfo, Boolean isLocked) throws LetterException {
        if (!info.isIsCommitToBe()) {
            throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fm.ntp.NtpResource", (String)"062_CANNOT_SYNCSTATUS"));
        }
        if (info.getBankReturnStatus() == BankReturnStatusEnum.BANK_FAIL || info.getBankReturnStatus() == BankReturnStatusEnum.BANK_SUCCESS || info.getBankReturnStatus() == BankReturnStatusEnum.BANK_EXCEPTION) {
            throw new LetterException(LetterException.SUCCESSORFAILCANTSYNSTATUS_064);
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entrys.modifyItem"));
        sic.add(new SelectorItemInfo("entrys.contentBeforeM"));
        sic.add(new SelectorItemInfo("entrys.contentAfterM"));
        sic.add(new SelectorItemInfo("entrys.letterAbstract"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("auditor.number"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("lastUpdateUser.number"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("letterNumber"));
        sic.add(new SelectorItemInfo("modifyDate"));
        sic.add(new SelectorItemInfo("isCommitToBe"));
        sic.add(new SelectorItemInfo("detailSeqID"));
        sic.add(new SelectorItemInfo("bankReturnStatus"));
        sic.add(new SelectorItemInfo("bankReturnMsg"));
        sic.add(new SelectorItemInfo("letterHandler.id"));
        sic.add(new SelectorItemInfo("letterHandler.number"));
        sic.add(new SelectorItemInfo("letterHandler.name"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("modifyNumber"));
        sic.add(new SelectorItemInfo("letterReason"));
        sic.add(new SelectorItemInfo("letterId"));
        return sic;
    }

    protected SelectorItemCollection getLcSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("payBankAcct.*"));
        sic.add(new SelectorItemInfo("payBankAcct.id"));
        sic.add(new SelectorItemInfo("payBankAcct.name"));
        sic.add(new SelectorItemInfo("payBankAcct.bankAccountNumber"));
        sic.add(new SelectorItemInfo("payBankAcct.number"));
        sic.add(new SelectorItemInfo("Currency.*"));
        sic.add(new SelectorItemInfo("Currency.id"));
        sic.add(new SelectorItemInfo("Currency.isoCode"));
        sic.add(new SelectorItemInfo("applicantName"));
        sic.add(new SelectorItemInfo("initialCode"));
        sic.add(new SelectorItemInfo("CreditLimit.*"));
        sic.add(new SelectorItemInfo("CreditLimit.id"));
        sic.add(new SelectorItemInfo("CreditLimit.number"));
        sic.add(new SelectorItemInfo("CreditLimit.name"));
        sic.add(new SelectorItemInfo("isDirect"));
        sic.add(new SelectorItemInfo("Amount"));
        sic.add(new SelectorItemInfo("Balance"));
        sic.add(new SelectorItemInfo("LocalCurExRate"));
        sic.add(new SelectorItemInfo("IsInCredit"));
        sic.add(new SelectorItemInfo("IssueDate"));
        sic.add(new SelectorItemInfo("ExpiredDate"));
        sic.add(new SelectorItemInfo("Horizon"));
        sic.add(new SelectorItemInfo("Remark"));
        sic.add(new SelectorItemInfo("Garantee"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("GaranteeType.name"));
        sic.add(new SelectorItemInfo("Currency.name"));
        sic.add(new SelectorItemInfo("Currency.isoCode"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("IsForward"));
        sic.add(new SelectorItemInfo("Beneficiary"));
        sic.add(new SelectorItemInfo("Institution.name"));
        sic.add(new SelectorItemInfo("Currency.id"));
        sic.add(new SelectorItemInfo("accountant.name"));
        sic.add(new SelectorItemInfo("creditPercentage"));
        sic.add(new SelectorItemInfo("ntType.name"));
        sic.add(new SelectorItemInfo("marginRate"));
        sic.add(new SelectorItemInfo("limitMargin"));
        sic.add(new SelectorItemInfo("marginCurrency.name"));
        sic.add(new SelectorItemInfo("marginExRate"));
        sic.add(new SelectorItemInfo("marginEx"));
        sic.add(new SelectorItemInfo("marginAcct.name"));
        sic.add(new SelectorItemInfo("marginBalance"));
        sic.add(new SelectorItemInfo("payBankAcct.name"));
        sic.add(new SelectorItemInfo("marginAlgorithm"));
        sic.add(new SelectorItemInfo("cashier.name"));
        sic.add(new SelectorItemInfo("department.name"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("LetterStatus"));
        sic.add(new SelectorItemInfo("operateStatus"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("contractNumber"));
        sic.add(new SelectorItemInfo("contractCurrenc.name"));
        sic.add(new SelectorItemInfo("letterNumber"));
        sic.add(new SelectorItemInfo("contractAmount"));
        sic.add(new SelectorItemInfo("AmountLocalCur"));
        sic.add(new SelectorItemInfo("BeneficiaryStat.name"));
        sic.add(new SelectorItemInfo("forwardDate"));
        sic.add(new SelectorItemInfo("intendPayDate"));
        sic.add(new SelectorItemInfo("TransportMode"));
        sic.add(new SelectorItemInfo("LoadPort"));
        sic.add(new SelectorItemInfo("DestinationPort"));
        sic.add(new SelectorItemInfo("LoadDate"));
        sic.add(new SelectorItemInfo("IsBatch"));
        sic.add(new SelectorItemInfo("IsDivert"));
        sic.add(new SelectorItemInfo("IsDYZ"));
        sic.add(new SelectorItemInfo("FluctuateScale"));
        sic.add(new SelectorItemInfo("LtterHandler.name"));
        sic.add(new SelectorItemInfo("babNumber"));
        sic.add(new SelectorItemInfo("hxdNumber"));
        sic.add(new SelectorItemInfo("NotifyBank.name"));
        sic.add(new SelectorItemInfo("guaranteeTypeInputMode"));
        sic.add(new SelectorItemInfo("contractCurrenc.id"));
        sic.add(new SelectorItemInfo("DeferReturnCreditLimitDays"));
        sic.add(new SelectorItemInfo("DeferReturnCLEntrys.seq"));
        sic.add(new SelectorItemInfo("Repayment.bizDate"));
        sic.add(new SelectorItemInfo("DeferReturnCLEntrys.isReturnedCL"));
        sic.add(new SelectorItemInfo("DeferReturnCLEntrys.supposeCLReturnDate"));
        sic.add(new SelectorItemInfo("DeferReturnCLEntrys.actualCLReturnDate"));
        sic.add(new SelectorItemInfo("Repayment.ReturnedQuota"));
        sic.add(new SelectorItemInfo("Repayment.id"));
        sic.add(new SelectorItemInfo("DeferReturnCLEntrys.id"));
        sic.add(new SelectorItemInfo("FluctuateScalefloor"));
        sic.add(new SelectorItemInfo("Currency2.id"));
        sic.add(new SelectorItemInfo("closeTime"));
        sic.add(new SelectorItemInfo("Currency2.name"));
        sic.add(new SelectorItemInfo("CreditCurExRate"));
        sic.add(new SelectorItemInfo("creditLocalAmt"));
        sic.add(new SelectorItemInfo("LtterHandler.name"));
        return sic;
    }

    @Override
    protected Map _modifyBankReturnStatus(Context ctx, String id, int status) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("bankReturnStatus"));
        ModifyLetterInfo info = ModifyLetterFactory.getLocalInstance(ctx).getModifyLetterInfo((IObjectPK)new ObjectUuidPK(id));
        try {
            if (!BankReturnStatusEnum.BANK_EXCEPTION.equals((Object)info.getBankReturnStatus())) {
                throw new LetterException(LetterException.CANTMODIFYBANKRETURNSTATUS_080);
            }
            info.setBankReturnStatus(BankReturnStatusEnum.getEnum((int)status));
            ModifyLetterFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
            if (status == 3) {
                this.updateLetterOfCreditInfo(ctx, info);
            }
            result.setError(0);
            result.setSummaryMsg(EASResource.getString((String)RESOURCE, (String)"StatusUpdateSuccess_103"));
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }
}

