/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.exception.biz.WfBizException;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.fin.IModifyLetter;
import com.kingdee.eas.fm.fin.LetterException;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LetterStatusEnum;
import com.kingdee.eas.fm.fin.ModifyLetterEntryCollection;
import com.kingdee.eas.fm.fin.ModifyLetterEntryInfo;
import com.kingdee.eas.fm.fin.ModifyLetterFactory;
import com.kingdee.eas.fm.fin.ModifyLetterInfo;
import com.kingdee.eas.fm.fin.ModifyLetterItem;
import com.kingdee.eas.fm.fin.ModifyLetterStatusEnum;
import com.kingdee.eas.fm.fin.app.AbstractModifyLetterWebFacadeControllerBean;
import com.kingdee.eas.fm.nt.LetterOfCreditApplyException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class ModifyLetterWebFacadeControllerBean
extends AbstractModifyLetterWebFacadeControllerBean {
    private static final long serialVersionUID = 1668826927217534534L;
    public static final String RESOURCE = "com.kingdee.eas.fm.fin.LetterOfCreditWebResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.ModifyLetterWebFacadeControllerBean");

    @Override
    protected Map _batchAudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        Object col = null;
        IModifyLetter modifyLetter = ModifyLetterFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("billStatus"));
        selector.add(new SelectorItemInfo("auditor"));
        UserInfo currentUser = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        for (int i = 0; i < ids.length; ++i) {
            ModifyLetterInfo letinfo = ModifyLetterFactory.getLocalInstance(ctx).getModifyLetterInfo((IObjectPK)new ObjectUuidPK(ids[i]));
            ModifyLetterEntryCollection infoEntrys = letinfo.getEntrys();
            LetterOfCreditInfo letterinfo = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(letinfo.getLetterId()), this.getLcSelectors());
            HashSet<String> idList = new HashSet<String>();
            idList.add(ids[i]);
            try {
                String companyId = letinfo.getCompany() != null ? letinfo.getCompany().getId().toString() : letterinfo.getCompany().getId().toString();
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                String companyName = company.getName();
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), (String)"fin_ModifyLetter_audit");
                if (!isPermission) {
                    throw new RuntimeException(EASResource.getString((String)RESOURCE, (String)"NO_AUDIT_PERMISSION", (Object[])new String[]{companyName}));
                }
                ModifyLetterFactory.getLocalInstance(ctx).checkStatus(ids[i], 1);
                for (int j = 0; j < infoEntrys.size(); ++j) {
                    ModifyLetterEntryInfo entryInfo = infoEntrys.get(j);
                    if (!entryInfo.getModifyItem().equals((Object)ModifyLetterItem.Amount) || new BigDecimal(entryInfo.getContentAfterM()).subtract(new BigDecimal(entryInfo.getContentBeforeM()).subtract(letterinfo.getBalance())).compareTo(new BigDecimal(0)) >= 0) continue;
                    throw new RuntimeException(EASResource.getString((String)RESOURCE, (String)"AfterAmountNoCanSmallThanYHK"));
                }
                letinfo.setAuditor(currentUser);
                letinfo.setBillStatus(ModifyLetterStatusEnum.AUDITED);
                modifyLetter.updatePartial((CoreBaseInfo)letinfo, selector);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(EASResource.getString((String)RESOURCE, (String)"MODIFYLETTER_AUDIT_FAILED", (Object[])new String[]{letinfo.getLetterNumber(), e.getMessage()}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(EASResource.getString((String)RESOURCE, (String)"MODIFYLETTER_AUDIT_FAILED", (Object[])new String[]{letinfo.getLetterNumber(), e.getMessage()}));
            }
        }
        summary = success == ids.length ? summary + EASResource.getString((String)RESOURCE, (String)"ALL_AUDIT_SUCCESS") : summary + EASResource.getString((String)RESOURCE, (String)"AUDIT_RESULT", (Object[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setError(ids.length - success);
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _batchUnAudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        Object col = null;
        IModifyLetter modifyLetter = ModifyLetterFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("billStatus"));
        selector.add(new SelectorItemInfo("auditor"));
        UserInfo currentUser = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        for (int i = 0; i < ids.length; ++i) {
            ModifyLetterInfo info = modifyLetter.getModifyLetterInfo((IObjectPK)new ObjectUuidPK(ids[i]), this.getSelectors());
            HashSet<String> idList = new HashSet<String>();
            idList.add(ids[i]);
            try {
                ModifyLetterFactory.getLocalInstance(ctx).checkStatus(ids[i], 2);
                if (info != null && info.isIsCommitToBe() && (info.getBankReturnStatus() == null || 4 != info.getBankReturnStatus().getValue())) {
                    throw new RuntimeException(EASResource.getString((String)RESOURCE, (String)"MODIFYLETTER_IS_COMMITTOBE"));
                }
                ModifyLetterInfo letinfo = ModifyLetterFactory.getLocalInstance(ctx).getModifyLetterInfo((IObjectPK)new ObjectUuidPK(ids[i]));
                ModifyLetterEntryCollection infoEntrys = letinfo.getEntrys();
                LetterOfCreditInfo letterinfo = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(letinfo.getLetterId()), this.getLcSelectors());
                String companyId = info.getCompany() != null ? info.getCompany().getId().toString() : letterinfo.getCompany().getId().toString();
                String companyName = info.getCompany() != null ? info.getCompany().getName() : letterinfo.getCompany().getName();
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), (String)"fin_ModifyLetter_cancelAudit");
                if (!isPermission) {
                    throw new RuntimeException(EASResource.getString((String)RESOURCE, (String)"NO_UNAUDIT_PERMISSION", (Object[])new String[]{companyName}));
                }
                for (int j = 0; j < infoEntrys.size(); ++j) {
                    ModifyLetterEntryInfo entryInfo = infoEntrys.get(j);
                    if (!entryInfo.getModifyItem().equals((Object)ModifyLetterItem.Amount) || new BigDecimal(entryInfo.getContentBeforeM()).subtract(new BigDecimal(entryInfo.getContentAfterM()).subtract(letterinfo.getBalance())).compareTo(new BigDecimal(0)) >= 0) continue;
                    throw new RuntimeException(EASResource.getString((String)RESOURCE, (String)"AfterAmountNoCanSmallThanYHK"));
                }
                letinfo.setAuditor(null);
                letinfo.setBillStatus(ModifyLetterStatusEnum.COMMITED);
                modifyLetter.updatePartial((CoreBaseInfo)letinfo, selector);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(EASResource.getString((String)RESOURCE, (String)"MODIFYLETTER_UNAUDIT_FAILED", (Object[])new String[]{info.getLetterNumber(), e.getMessage()}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(EASResource.getString((String)RESOURCE, (String)"MODIFYLETTER_UNAUDIT_FAILED", (Object[])new String[]{info.getLetterNumber(), e.getMessage()}));
            }
        }
        summary = success == ids.length ? summary + EASResource.getString((String)RESOURCE, (String)"ALL_UNAUDIT_SUCCESS") : summary + EASResource.getString((String)RESOURCE, (String)"UNAUDIT_RESULT", (Object[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setError(ids.length - success);
        result.setSummaryMsg(summary);
        return result;
    }

    private EntityViewInfo getQueryView(BOSUuid companyId, BOSUuid creditLimitId, BOSUuid financingBillid) {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.getSelector().add("shareOrg.*");
        evi.getSelector().add("finPro.*");
        evi.getSelector().add("creditEntry.*");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("ShareOrg.id", (Object)companyId));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("creditLimitID", (Object)creditLimitId.toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("billID", (Object)financingBillid.toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isUnion", (Object)Boolean.FALSE));
        String mask = "#0 and #1 and #2 and #3";
        evi.getFilter().setMaskString(mask);
        return evi;
    }

    @Override
    protected Map _batchDelete(Context ctx, String[] ids) throws BOSException, EASBizException {
        IModifyLetter modifyLetter = ModifyLetterFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        for (int i = 0; i < ids.length; ++i) {
            ModifyLetterInfo info = modifyLetter.getModifyLetterInfo((IObjectPK)new ObjectUuidPK(ids[i]), this.getSelectors());
            try {
                LetterOfCreditInfo letterinfo = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(info.getLetterId()), this.getLcSelectors());
                String companyId = info.getCompany() != null ? info.getCompany().getId().toString() : letterinfo.getCompany().getId().toString();
                String companyName = info.getCompany() != null ? info.getCompany().getName() : letterinfo.getCompany().getName();
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), (String)"fin_ModifyLetter_delete");
                if (!isPermission) {
                    throw new RuntimeException(EASResource.getString((String)RESOURCE, (String)"NO_DELETE_PERMISSION", (Object[])new String[]{companyName}));
                }
                if (info.getBillStatus().getValue() == ModifyLetterStatusEnum.AUDITED.getValue()) {
                    result.getDetailMsgList().add(EASResource.getString((String)RESOURCE, (String)"MODIFYLETTER_DELETE_AUDITED", (Object[])new String[]{info.getLetterNumber()}));
                    continue;
                }
                modifyLetter.delete((IObjectPK)new ObjectUuidPK(ids[i]));
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(EASResource.getString((String)RESOURCE, (String)"MODIFYLETTER_DELETE_FAILED", (Object[])new String[]{info.getLetterNumber(), e.getMessage()}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(EASResource.getString((String)RESOURCE, (String)"MODIFYLETTER_DELETE_FAILED", (Object[])new String[]{info.getLetterNumber(), e.getMessage()}));
            }
        }
        summary = success == ids.length ? summary + EASResource.getString((String)RESOURCE, (String)"ALL_DELETE_SUCCESS") : summary + EASResource.getString((String)RESOURCE, (String)"DELETE_RESULT", (Object[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setError(ids.length - success);
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _beforeSubmit(Context ctx, ModifyLetterInfo info) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        ModifyLetterEntryCollection infoEntrys = info.getEntrys();
        LetterOfCreditInfo letterinfo = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(info.getLetterId()));
        if (letterinfo == null) {
            throw new RuntimeException(EASResource.getString((String)RESOURCE, (String)"LC_IS_EMPTY"));
        }
        int ceilInt = letterinfo.getFluctuateScale();
        int floorInt = letterinfo.getFluctuateScalefloor();
        if (info.getModifyDate().before(letterinfo.getIssueDate())) {
            throw new RuntimeException(EASResource.getString((String)RESOURCE, (String)"editDateCheck"));
        }
        if (infoEntrys.size() <= 0) {
            throw new RuntimeException(EASResource.getString((String)RESOURCE, (String)"moreThanZero"));
        }
        HashMap<String, String> modifyItemMap = new HashMap<String, String>();
        int ceil = 0;
        int floor = 0;
        for (int i = 0; i < infoEntrys.size(); ++i) {
            if (infoEntrys.get(i).getModifyItem().getValue() == null) {
                throw new RuntimeException(EASResource.getString((String)RESOURCE, (String)"modifyCannotBeEmpty", (Object[])new String[]{String.valueOf(++i)}));
            }
            if (modifyItemMap.get(infoEntrys.get(i).getModifyItem().getValue()) != null) {
                throw new RuntimeException(EASResource.getString((String)RESOURCE, (String)"MODIFY_ITEM_REPEAT", (Object[])new String[]{infoEntrys.get(i).getModifyItem().getAlias()}));
            }
            modifyItemMap.put(infoEntrys.get(i).getModifyItem().getValue(), infoEntrys.get(i).getModifyItem().getValue());
            if (infoEntrys.get(i).getContentAfterM() == null) {
                throw new RuntimeException(EASResource.getString((String)RESOURCE, (String)"modifyContentCannotBeEmpty", (Object[])new String[]{String.valueOf(++i)}));
            }
            if (infoEntrys.get(i).getModifyItem().equals((Object)ModifyLetterItem.Amount)) {
                BigDecimal repayAmt = letterinfo.getAmount().subtract(letterinfo.getBalance());
                String iamount = infoEntrys.get(i).getContentAfterM();
                BigDecimal amount = Constants.ZERO;
                amount = iamount instanceof String ? new BigDecimal(iamount) : (BigDecimal)((Object)iamount);
                if (amount.compareTo(repayAmt) < 0) {
                    throw new RuntimeException(EASResource.getString((String)RESOURCE, (String)"AmountBigThanRepay"));
                }
            }
            if (infoEntrys.get(i).getModifyItem().equals((Object)ModifyLetterItem.FluctuateScale)) {
                String ceilString = infoEntrys.get(i).getContentAfterM();
                ceilInt = Integer.parseInt(ceilString);
                if (ceilInt < -100 || ceilInt > 100) {
                    throw new RuntimeException(EASResource.getString((String)RESOURCE, (String)"FluctuateScaleCeil"));
                }
                ceil = ceilInt;
            }
            if (!infoEntrys.get(i).getModifyItem().equals((Object)ModifyLetterItem.FluctuateScaleFloor)) continue;
            String floorString = infoEntrys.get(i).getContentAfterM();
            floorInt = Integer.parseInt(floorString);
            if (floorInt < -100 || floorInt > 100) {
                throw new RuntimeException(EASResource.getString((String)RESOURCE, (String)"FluctuateScaleFloor"));
            }
            floor = floorInt;
        }
        if (ceil != 0 && floor != 0 && ceil < floor) {
            throw new RuntimeException(EASResource.getString((String)RESOURCE, (String)"CeilMustBeGreaterThanFloor", (Object[])new String[]{String.valueOf(ceil), String.valueOf(floor)}));
        }
        return result;
    }

    @Override
    protected Map _submit(Context ctx, ModifyLetterInfo info) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        try {
            LetterOfCreditInfo letterinfo = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(info.getLetterId()));
            this.beforeSubmit(ctx, info);
            info.setCompany(letterinfo.getCompany());
            ModifyLetterFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
            result.setError(0);
            String summaryMsg = EASResource.getString((String)RESOURCE, (String)"MODIFYLETTER_SUBMIT_SUCCESS_90");
            result.setSummaryMsg(summaryMsg);
        }
        catch (WfBizException e) {
            result.setError(1);
            result.setSummaryMsg(CASWebUtil.getResource((Context)ctx, (String)"ALREADY_IN_WORKFLOW"));
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }

    @Override
    protected Map _commitToBe(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)ModifyLetterFactory.getLocalInstance(ctx).commitToBe(ids);
        return result;
    }

    @Override
    protected Map _synStatus(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)ModifyLetterFactory.getLocalInstance(ctx).synStatus(ids);
        return result;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entrys.modifyItem"));
        sic.add(new SelectorItemInfo("entrys.contentBeforeM"));
        sic.add(new SelectorItemInfo("entrys.contentAfterM"));
        sic.add(new SelectorItemInfo("entrys.letterAbstract"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("auditor.number"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("lastUpdateUser.number"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("letterNumber"));
        sic.add(new SelectorItemInfo("modifyDate"));
        sic.add(new SelectorItemInfo("isCommitToBe"));
        sic.add(new SelectorItemInfo("detailSeqID"));
        sic.add(new SelectorItemInfo("bankReturnStatus"));
        sic.add(new SelectorItemInfo("bankReturnMsg"));
        sic.add(new SelectorItemInfo("letterHandler.id"));
        sic.add(new SelectorItemInfo("letterHandler.number"));
        sic.add(new SelectorItemInfo("letterHandler.name"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("modifyNumber"));
        sic.add(new SelectorItemInfo("letterReason"));
        sic.add(new SelectorItemInfo("letterId"));
        return sic;
    }

    protected SelectorItemCollection getLcSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("payBankAcct.*"));
        sic.add(new SelectorItemInfo("payBankAcct.id"));
        sic.add(new SelectorItemInfo("payBankAcct.name"));
        sic.add(new SelectorItemInfo("payBankAcct.bankAccountNumber"));
        sic.add(new SelectorItemInfo("payBankAcct.number"));
        sic.add(new SelectorItemInfo("Currency.*"));
        sic.add(new SelectorItemInfo("Currency.id"));
        sic.add(new SelectorItemInfo("Currency.isoCode"));
        sic.add(new SelectorItemInfo("applicantName"));
        sic.add(new SelectorItemInfo("initialCode"));
        sic.add(new SelectorItemInfo("CreditLimit.*"));
        sic.add(new SelectorItemInfo("CreditLimit.id"));
        sic.add(new SelectorItemInfo("CreditLimit.number"));
        sic.add(new SelectorItemInfo("CreditLimit.name"));
        sic.add(new SelectorItemInfo("isDirect"));
        sic.add(new SelectorItemInfo("Amount"));
        sic.add(new SelectorItemInfo("Balance"));
        sic.add(new SelectorItemInfo("LocalCurExRate"));
        sic.add(new SelectorItemInfo("IsInCredit"));
        sic.add(new SelectorItemInfo("IssueDate"));
        sic.add(new SelectorItemInfo("ExpiredDate"));
        sic.add(new SelectorItemInfo("Horizon"));
        sic.add(new SelectorItemInfo("Remark"));
        sic.add(new SelectorItemInfo("Garantee"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("GaranteeType.name"));
        sic.add(new SelectorItemInfo("Currency.name"));
        sic.add(new SelectorItemInfo("Currency.isoCode"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("IsForward"));
        sic.add(new SelectorItemInfo("Beneficiary"));
        sic.add(new SelectorItemInfo("Institution.name"));
        sic.add(new SelectorItemInfo("Currency.id"));
        sic.add(new SelectorItemInfo("accountant.name"));
        sic.add(new SelectorItemInfo("creditPercentage"));
        sic.add(new SelectorItemInfo("ntType.name"));
        sic.add(new SelectorItemInfo("marginRate"));
        sic.add(new SelectorItemInfo("limitMargin"));
        sic.add(new SelectorItemInfo("marginCurrency.name"));
        sic.add(new SelectorItemInfo("marginExRate"));
        sic.add(new SelectorItemInfo("marginEx"));
        sic.add(new SelectorItemInfo("marginAcct.name"));
        sic.add(new SelectorItemInfo("marginBalance"));
        sic.add(new SelectorItemInfo("payBankAcct.name"));
        sic.add(new SelectorItemInfo("marginAlgorithm"));
        sic.add(new SelectorItemInfo("cashier.name"));
        sic.add(new SelectorItemInfo("department.name"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("LetterStatus"));
        sic.add(new SelectorItemInfo("operateStatus"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("contractNumber"));
        sic.add(new SelectorItemInfo("contractCurrenc.name"));
        sic.add(new SelectorItemInfo("letterNumber"));
        sic.add(new SelectorItemInfo("contractAmount"));
        sic.add(new SelectorItemInfo("AmountLocalCur"));
        sic.add(new SelectorItemInfo("BeneficiaryStat.name"));
        sic.add(new SelectorItemInfo("forwardDate"));
        sic.add(new SelectorItemInfo("intendPayDate"));
        sic.add(new SelectorItemInfo("TransportMode"));
        sic.add(new SelectorItemInfo("LoadPort"));
        sic.add(new SelectorItemInfo("DestinationPort"));
        sic.add(new SelectorItemInfo("LoadDate"));
        sic.add(new SelectorItemInfo("IsBatch"));
        sic.add(new SelectorItemInfo("IsDivert"));
        sic.add(new SelectorItemInfo("IsDYZ"));
        sic.add(new SelectorItemInfo("FluctuateScale"));
        sic.add(new SelectorItemInfo("LtterHandler.name"));
        sic.add(new SelectorItemInfo("babNumber"));
        sic.add(new SelectorItemInfo("hxdNumber"));
        sic.add(new SelectorItemInfo("NotifyBank.name"));
        sic.add(new SelectorItemInfo("guaranteeTypeInputMode"));
        sic.add(new SelectorItemInfo("contractCurrenc.id"));
        sic.add(new SelectorItemInfo("DeferReturnCreditLimitDays"));
        sic.add(new SelectorItemInfo("DeferReturnCLEntrys.seq"));
        sic.add(new SelectorItemInfo("Repayment.bizDate"));
        sic.add(new SelectorItemInfo("DeferReturnCLEntrys.isReturnedCL"));
        sic.add(new SelectorItemInfo("DeferReturnCLEntrys.supposeCLReturnDate"));
        sic.add(new SelectorItemInfo("DeferReturnCLEntrys.actualCLReturnDate"));
        sic.add(new SelectorItemInfo("Repayment.ReturnedQuota"));
        sic.add(new SelectorItemInfo("Repayment.id"));
        sic.add(new SelectorItemInfo("DeferReturnCLEntrys.id"));
        sic.add(new SelectorItemInfo("FluctuateScalefloor"));
        sic.add(new SelectorItemInfo("Currency2.id"));
        sic.add(new SelectorItemInfo("closeTime"));
        sic.add(new SelectorItemInfo("Currency2.name"));
        sic.add(new SelectorItemInfo("CreditCurExRate"));
        sic.add(new SelectorItemInfo("creditLocalAmt"));
        sic.add(new SelectorItemInfo("LtterHandler.name"));
        return sic;
    }

    @Override
    protected Map _addFee(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("company.id"));
            sic.add(new SelectorItemInfo("company.name"));
            sic.add(new SelectorItemInfo("LetterStatus"));
            sic.add(new SelectorItemInfo("letterNumber"));
            LetterOfCreditInfo info = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(id), sic);
            boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_FeeManager_addnew");
            if (!isPermission) {
                throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NO_ADDFEE_PERMISSION_41, (Object[])new String[]{info.getCompany().getName()});
            }
            if (LetterStatusEnum.close.equals((Object)info.getLetterStatus())) {
                throw new LetterException(LetterException.CANTADDFEECAUSECOLSED_079, new String[]{info.getLetterNumber()});
            }
            result.setError(0);
            String successMsg = EASResource.getString((String)RESOURCE, (String)"ADDFEESUCCESS_76");
            result.setSummaryMsg(successMsg);
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }

    @Override
    protected Map _viewLetter(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("company.id"));
            sic.add(new SelectorItemInfo("company.name"));
            LetterOfCreditInfo info = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(id), sic);
            boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_LetterOfCredit_view");
            if (!isPermission) {
                throw new LetterException(LetterException.NOCREDITVIEWPERMISSION_078, new String[]{info.getCompany().getName()});
            }
            result.setError(0);
            String successMsg = EASResource.getString((String)RESOURCE, (String)"ViewLetterPermVerifySuccess_95");
            result.setSummaryMsg(successMsg);
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }

    @Override
    protected Map _edit(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("company.id"));
            sic.add(new SelectorItemInfo("company.name"));
            sic.add(new SelectorItemInfo("billStatus"));
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            ModifyLetterInfo info = ModifyLetterFactory.getLocalInstance(ctx).getModifyLetterInfo((IObjectPK)new ObjectUuidPK(id), sic);
            boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_ModifyLetter_edit");
            if (!isPermission) {
                throw new LetterException(LetterException.NOMODIFYLETTEREDITPERMISSION_068, new String[]{info.getCompany().getName()});
            }
            result.setError(0);
            String successMsg = EASResource.getString((String)RESOURCE, (String)"EditModifyLetterPerVerifySuccess_97");
            result.setSummaryMsg(successMsg);
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }

    @Override
    protected Map _modifyBankReturnStatus(Context ctx, String id, int status) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)ModifyLetterFactory.getLocalInstance(ctx).modifyBankReturnStatus(id, status);
        return result;
    }
}

