/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AbstractFMDataImport;
import com.kingdee.eas.fm.fin.LoanException;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.LoanOfIntPayDateEntryFactory;
import com.kingdee.eas.fm.fin.LoanOfIntPayDateEntryInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeSet;

public class PayDateDataImport
extends AbstractFMDataImport {
    String loanIdParam = "";
    int entrySeq = 1;
    LoanInfo loanCache = null;
    private TreeSet<Date> payDateSet = new TreeSet();

    protected ICoreBase _getController(Context ctx) throws EASBizException, BOSException {
        return LoanOfIntPayDateEntryFactory.getLocalInstance(ctx);
    }

    protected CoreBaseInfo _transmit(Hashtable hsData, Context ctx) throws EASBizException, BOSException {
        LoanOfIntPayDateEntryInfo info = new LoanOfIntPayDateEntryInfo();
        this.prepareImport(ctx, (IObjectValue)info, hsData);
        Map loanMap = this.getContextMap();
        Date issureDate = (Date)loanMap.get("issureDate");
        Date expiredDate = (Date)loanMap.get("expiredDate");
        Date payDate = this.getDate(ctx, this.getData(hsData, "FPayDate"));
        if (!payDate.after(issureDate)) {
            throw new LoanException(LoanException.PAYDATE_ISSUREDATE_ERROR);
        }
        if (payDate.after(expiredDate)) {
            throw new LoanException(LoanException.PAYDATE_EXPIREDDATE_ERROR);
        }
        if (this.payDateSet.contains(payDate)) {
            throw new LoanException(LoanException.PAYDATE_EQUAL_ERROR);
        }
        if (!this.payDateSet.isEmpty() && payDate.before(this.payDateSet.last())) {
            throw new LoanException(LoanException.PAYDATE_SEQ_ERROR);
        }
        this.payDateSet.add(payDate);
        info.setPayDate(payDate);
        return info;
    }

    protected void _submit(CoreBaseInfo coreBaseInfo, Context ctx) throws BOSException, EASBizException {
        LoanOfIntPayDateEntryInfo info = (LoanOfIntPayDateEntryInfo)coreBaseInfo;
        String loanId = this.getLoanIdfromContextMap();
        if (EmptyUtil.isEmpty((String)loanId)) {
            return;
        }
        if (!loanId.equals(this.loanIdParam)) {
            this.loanIdParam = loanId;
            this.entrySeq = 1;
        }
        LoanInfo loan = this.getLoanInfo(ctx, loanId);
        info.setParent(loan);
        info.setSeq(this.entrySeq);
        if (this.entrySeq == 1) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent", (Object)loanId, CompareType.EQUALS));
            LoanOfIntPayDateEntryFactory.getLocalInstance(ctx).delete(filter);
        }
        ++this.entrySeq;
        LoanOfIntPayDateEntryFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)info);
    }

    private LoanInfo getLoanInfo(Context ctx, String loanId) throws EASBizException, BOSException {
        return LoanFactory.getLocalInstance(ctx).getLoanInfo((IObjectPK)new ObjectUuidPK(loanId));
    }

    public String getLoanIdfromContextMap() {
        Map loanIdMap = this.getContextMap();
        return (String)loanIdMap.get("loanId");
    }
}

