/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.DeferReturnCLEntryFactory;
import com.kingdee.eas.fm.fin.DeferReturnCLEntryInfo;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.GuanTypeBillEnum;
import com.kingdee.eas.fm.fin.GuaranteeDetailInfo;
import com.kingdee.eas.fm.fin.RepaymentBookNotifyBuilder;
import com.kingdee.eas.fm.fin.RepaymentCollection;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.app.AbstractRepaymentStragety;
import com.kingdee.eas.fm.fs.app.OverDraftCheckHelper;
import com.kingdee.eas.fm.nt.BillMakeTypeEnum;
import com.kingdee.eas.fm.nt.ElecBillStatusEnum;
import com.kingdee.eas.fm.nt.NTBookHelper;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Iterator;
import java.util.Map;

public class PayableBillRepaymentStragety
extends AbstractRepaymentStragety {
    @Override
    protected void beforeAddNew(Context ctx, IObjectValue model, FinancingBillInfo finBillInfo) throws BOSException, EASBizException {
        RepaymentInfo info = (RepaymentInfo)model;
        PayableBillInfo commerInfo = (PayableBillInfo)finBillInfo;
        info.setCommercialDraft(commerInfo);
        OverDraftCheckHelper.checkOverDraft4Repayment((Context)ctx, (IObjectValue)info);
    }

    @Override
    protected void dispose(Context ctx, IObjectValue model, FinancingBillInfo finBillInfo) throws BOSException, EASBizException {
    }

    @Override
    protected void afterAddNew(Context ctx, IObjectValue model, FinancingBillInfo finBillInfo) throws BOSException, EASBizException {
        RepaymentInfo info = (RepaymentInfo)model;
        PayableBillInfo commerInfo = (PayableBillInfo)finBillInfo;
        if (!commerInfo.isHistoryBill() && commerInfo.getMakeType() == BillMakeTypeEnum.SUB) {
            this.submit4wf(ctx, info);
        }
        if (!info.isBat4Payable()) {
            NTBookHelper.autoBookJournalforRec((Context)ctx, (String)info.getId().toString(), (CompanyOrgUnitInfo)info.getCompany(), (String)RepaymentBookNotifyBuilder.class.getName(), (boolean)info.isCreatePayment());
        }
        if (info.isCreatePayment()) {
            NTHelper.botpByRuleFilterNew((Context)ctx, (CoreBillBaseInfo)info, (String)new PaymentBillInfo().getBOSType().toString());
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("elecBillStatus");
        sic.add("lastElecStatus");
        PayableBillInfo payableBillinfo = PayableBillFactory.getLocalInstance((Context)ctx).getPayableBillInfo((IObjectPK)new ObjectUuidPK(commerInfo.getId()), sic);
        payableBillinfo.setLastElecStatus(payableBillinfo.getElecBillStatus());
        payableBillinfo.setElecBillStatus(ElecBillStatusEnum.NT000000);
        PayableBillFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)payableBillinfo, sic);
    }

    @Override
    protected void delBookAndSubsidiary(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RepaymentInfo info = (RepaymentInfo)model;
        PayableBillInfo commInfo = PayableBillFactory.getLocalInstance((Context)ctx).getPayableBillInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
        Iterator iter = commInfo.getGuaranteeEntrys().iterator();
        while (iter.hasNext()) {
            ReceivableBillInfo recBill;
            GuaranteeDetailInfo element = (GuaranteeDetailInfo)iter.next();
            if (element.getBilltype() != GuanTypeBillEnum.ReceivableBill || element.getBillId() == null || (recBill = ReceivableBillFactory.getLocalInstance((Context)ctx).getReceivableBillInfo((IObjectPK)new ObjectUuidPK(element.getBillId()))) == null || !recBill.isIsPledge()) continue;
            throw new FinBizException(FinBizException.NOTPLEDGESTATE);
        }
        if (commInfo.getMakeType() == BillMakeTypeEnum.ENTRUST) {
            RepaymentInfo repayInfo;
            PayableBillInfo subInfo = NTHelper.getSubPayInfo((Context)ctx, (PayableBillInfo)commInfo);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)subInfo.getId().toString()));
            evi.setFilter(filter);
            RepaymentCollection col = RepaymentFactory.getLocalInstance(ctx).getRepaymentCollection(evi);
            if (col.size() != 0 && (repayInfo = col.get(0)) != null) {
                DbUtil.execute((Context)ctx, (String)"update t_fin_repayment set FConfirmerid=null, FSourceCompanyId=null where FID=?", (Object[])new Object[]{repayInfo.getId().toString()});
            }
        }
        if (commInfo.getMakeType() == BillMakeTypeEnum.ENTRUST && !EmptyUtil.isEmpty((String)commInfo.getSourceBillId())) {
            DbUtil.execute((Context)ctx, (String)"update t_fin_repayment set FConfirmerid=null, FSourceCompanyId=null where Fsourcebillid=?", (Object[])new Object[]{commInfo.getSourceBillId().toString()});
        }
        NTBookHelper.autoAntiBookJournal((Context)ctx, (String)info.getId().toString(), (CompanyOrgUnitInfo)info.getCompany());
        NTBookHelper.antiBookSubsidiary((Context)ctx, (String)info.getId().toString());
    }

    @Override
    protected boolean isCancelLimit(Context ctx, IObjectValue model, FinancingBillInfo finBillInfo) throws BOSException, EASBizException {
        RepaymentInfo info = (RepaymentInfo)model;
        DeferReturnCLEntryInfo deInfo = DeferReturnCLEntryFactory.getLocalInstance(ctx).getValueByRepaymentBill(info.getId().toString());
        return deInfo == null || deInfo.isIsReturnedCL();
    }

    @Override
    protected void afterDelete(Context ctx, IObjectValue model, FinancingBillInfo finBillInfo) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)"update T_NT_PayableBill set felecbillstatus=null, flastelecstatus=null where fid=?", (Object[])new Object[]{finBillInfo.getId().toString()});
    }

    @Override
    protected void afterSubmit(Context ctx, IObjectValue model, FinancingBillInfo finBillInfo, boolean isAddNew) throws BOSException, EASBizException {
    }

    @Override
    protected void beforeDelete(Context ctx, IObjectValue model, FinancingBillInfo finBillInfo) throws BOSException, EASBizException {
    }

    @Override
    protected void _confirm(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RepaymentInfo info = (RepaymentInfo)model;
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        codingRuleManager.getNumber((IObjectValue)info, company.getId().toString());
        BOSUuid destCompanyId = company.getId();
        this.generateDestBill(ctx, destCompanyId, model);
    }

    private IObjectPK generateDestBill(Context ctx, BOSUuid destCompanyId, IObjectValue srcModel) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        companyInfo.setId(destCompanyId);
        RepaymentInfo srcInfo = (RepaymentInfo)srcModel;
        RepaymentInfo destInfo = (RepaymentInfo)srcInfo.clone();
        destInfo.setMakeType(BillMakeTypeEnum.ENTRUST);
        destInfo.setId(null);
        destInfo.setNumber(null);
        destInfo.setCompany(companyInfo);
        String srcCommerId = destInfo.getSourceBillId();
        destInfo.setSourceBillId(srcCommerId);
        PayableBillInfo commerInfo = new PayableBillInfo();
        commerInfo.setId(BOSUuid.read((String)srcCommerId));
        destInfo.setCommercialDraft(commerInfo);
        destInfo.setInnerAccount(null);
        IObjectPK pk = this._addnew(ctx, (IObjectValue)destInfo);
        DbUtil.execute((Context)ctx, (String)"update t_fin_repayment set FConfirmerid=?, FSourceCompanyId=? where FID=?", (Object[])new Object[]{ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getPerson().getId().toString(), destCompanyId.toString(), srcInfo.getId().toString()});
        DbUtil.execute((Context)ctx, (String)"update T_NT_PayableBill set fbillstate=1 where fid=?", (Object[])new Object[]{destInfo.getSourceBillId()});
        return pk;
    }

    @Override
    protected void _batchConfirm(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        for (RepaymentInfo element : colls) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)element, (String)company.getId().toString());
            element.setNumber(numberSilent);
            this.confirm(ctx, element);
        }
    }

    @Override
    protected void subVerifyBeforeBook(Context ctx, RepaymentInfo info) throws BOSException, EASBizException {
    }

    @Override
    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new PaymentBillInfo().getBOSType())) {
            RepaymentInfo info = (RepaymentInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                RepaymentInfo repayInfo = RepaymentFactory.getLocalInstance(ctx).getRepaymentInfo("select totalPayedAmt where id = '" + srcBillPK.toString() + "'");
                info.setTotalPayedAmt(repayInfo.getTotalPayedAmt());
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO);
    }

    @Override
    protected PaymentBillCollection getPaymentBillColl(Context ctx, CoreBillBaseCollection coreBillBaseCol, String destBillBosType) throws BOSException, BTPException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult result = iBTPManager.transform(coreBillBaseCol, destBillBosType);
        return (PaymentBillCollection)result.getBills();
    }

    @Override
    protected void verifyCanGatherGenPayBill(RepaymentCollection coll) throws BOSException, EASBizException {
        boolean isTotalPay;
        boolean bl = isTotalPay = coll.size() > 1;
        if (!isTotalPay) {
            return;
        }
        String lastPayerAcctId = null;
        String lastAcutionAcctBankId = null;
        for (int i = 0; i < coll.size(); ++i) {
            String acutionAcctBankId;
            RepaymentInfo repayment = coll.get(i);
            if (repayment.isIsGenPayBill() && isTotalPay) {
                throw new FinBizException(FinBizException.COMMON, new Object[]{EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"522_RepaymentListUI")});
            }
            if (repayment.getBankAcct() == null && isTotalPay) {
                throw new FinBizException(FinBizException.COMMON, new Object[]{EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"519_RepaymentListUI")});
            }
            String payerAcctId = repayment.getBankAcct() == null ? null : repayment.getBankAcct().getId().toString();
            String string = acutionAcctBankId = repayment.getAcutionAcctBank() == null ? null : repayment.getAcutionAcctBank().getId().toString();
            if (lastPayerAcctId != null) {
                if (!lastPayerAcctId.equals(payerAcctId)) {
                    throw new FinBizException(FinBizException.COMMON, new Object[]{EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"521_RepaymentListUI")});
                }
                if (lastAcutionAcctBankId != null && acutionAcctBankId != null && !lastAcutionAcctBankId.equals(acutionAcctBankId)) {
                    throw new FinBizException(FinBizException.COMMON, new Object[]{EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"520_RepaymentListUI")});
                }
            }
            lastPayerAcctId = payerAcctId;
            lastAcutionAcctBankId = acutionAcctBankId;
        }
    }

    @Override
    protected Map _commitToBe(Context ctx, String[] ids) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _synStatus(Context ctx, String[] ids) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _modifyBankReturnStatus(Context ctx, String id, int status) throws BOSException, EASBizException {
        return null;
    }
}

