/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AbstractFMDataImport;
import com.kingdee.eas.fm.fin.LoanEntryCollection;
import com.kingdee.eas.fm.fin.LoanEntryFactory;
import com.kingdee.eas.fm.fin.LoanEntryInfo;
import com.kingdee.eas.fm.fin.LoanException;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.RepayIntTypeEnum;
import com.kingdee.eas.fm.mnt.BlockingFlowTypeCollection;
import com.kingdee.eas.fm.mnt.BlockingFlowTypeFactory;
import com.kingdee.eas.fm.mnt.BlockingFlowTypeInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class RepayPlanDataImport
extends AbstractFMDataImport {
    private static final SimpleDateFormat date_format = new SimpleDateFormat("yyyyMMdd");
    String loanIdParam = "";
    int entrySeq = 1;
    LoanInfo loanCache = null;
    boolean FIN023 = false;
    boolean isRePaid = false;
    CoreBaseCollection entryCol = new CoreBaseCollection();
    Map<String, LoanEntryInfo> isRePaidMap = new HashMap<String, LoanEntryInfo>();
    LoanEntryCollection isNotRePaidCol = new LoanEntryCollection();

    protected ICoreBase _getController(Context ctx) throws EASBizException, BOSException {
        return LoanEntryFactory.getLocalInstance(ctx);
    }

    protected CoreBaseInfo _transmit(Hashtable hsData, Context ctx) throws EASBizException, BOSException {
        String key;
        LoanEntryInfo info = new LoanEntryInfo();
        this.prepareImport(ctx, (IObjectValue)info, hsData);
        String loanId = this.getLoanIdfromContextMap();
        if (!this.loanIdParam.equals(loanId)) {
            this.loanCache = this.getLoanInfo(ctx, loanId);
            this.FIN023 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("FIN023", (IObjectPK)new ObjectUuidPK(this.loanCache.getCompany().getId().toString()));
            if (this.entrySeq == 1 && this.FIN023) {
                this.entryCol = this.getRepayEntryCol(ctx, loanId);
                if (!EmptyUtil.isEmpty((AbstractObjectCollection)this.entryCol)) {
                    for (int i = 0; i < this.entryCol.size(); ++i) {
                        LoanEntryInfo entryInfo = (LoanEntryInfo)this.entryCol.get(i);
                        if (entryInfo.isIsRepaid()) {
                            String key2 = date_format.format(entryInfo.getDate()) + String.format("%.2f", entryInfo.getAmount()) + entryInfo.getRepayIntType().getAlias();
                            if (this.isRePaidMap.containsKey(key2)) continue;
                            this.isRePaidMap.put(key2, entryInfo);
                            continue;
                        }
                        this.isNotRePaidCol.add(entryInfo);
                    }
                    if (!EmptyUtil.isEmpty(this.isRePaidMap.keySet())) {
                        this.isRePaid = true;
                    }
                }
            }
        }
        Date bizDate = this.getDate(ctx, this.getData(hsData, "FDate"));
        BigDecimal amount = this.getAmount(ctx, this.getData(hsData, "FAmount"));
        int payIntType = this.getInt(ctx, this.getData(hsData, "FRepayIntType"));
        if (this.FIN023 && this.isRePaid && this.isRePaidMap.containsKey(key = date_format.format(bizDate) + String.format("%.2f", amount) + RepayIntTypeEnum.getEnum(payIntType).getAlias())) {
            return null;
        }
        if (this.loanCache.getIssueDate() != null && bizDate.before(this.loanCache.getIssueDate())) {
            throw new LoanException(LoanException.ENTRY_DATE_ERROR);
        }
        info.setDate(bizDate);
        if (amount.compareTo(BigDecimal.ZERO) < 0 || amount.compareTo(BigDecimal.ZERO) == 0) {
            throw new LoanException(LoanException.REPAY_AMOUNT_ERROR);
        }
        if (this.entrySeq == 1 ? amount.compareTo(this.loanCache.getAmount()) > 0 : amount.add(this.getRepayEntryTotal(ctx, loanId)).compareTo(this.loanCache.getAmount()) > 0) {
            throw new LoanException(LoanException.ABOVE_AMOUNT);
        }
        info.setAmount(amount);
        if (RepayIntTypeEnum.getEnum(payIntType) == null) {
            throw new LoanException(LoanException.PAYINT_TYPE_ERROR);
        }
        info.setRepayIntType(RepayIntTypeEnum.getEnum(payIntType));
        info.setDate(bizDate);
        return info;
    }

    protected void _submit(CoreBaseInfo coreBaseInfo, Context ctx) throws BOSException, EASBizException {
        LoanEntryInfo info = (LoanEntryInfo)coreBaseInfo;
        String loanId = this.getLoanIdfromContextMap();
        if (EmptyUtil.isEmpty((String)loanId) || info == null) {
            return;
        }
        if (!loanId.equals(this.loanIdParam)) {
            this.loanIdParam = loanId;
            this.entrySeq = 1;
        }
        LoanInfo loan = this.getLoanInfo(ctx, loanId);
        BlockingFlowTypeInfo bfTypeInfo = this.getDefaultBlockingFlowTypeInfo(ctx);
        info.setBlockFlowType(bfTypeInfo);
        info.setParent(loan);
        info.setSeq(this.entrySeq);
        if (this.entrySeq == 1) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isRepaid", (Object)false));
            filter.getFilterItems().add(new FilterItemInfo("parent", (Object)loanId, CompareType.EQUALS));
            LoanEntryFactory.getLocalInstance(ctx).delete(filter);
        }
        ++this.entrySeq;
        LoanEntryFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)info);
    }

    private LoanInfo getLoanInfo(Context ctx, String loanId) throws EASBizException, BOSException {
        return LoanFactory.getLocalInstance(ctx).getLoanInfo((IObjectPK)new ObjectUuidPK(loanId));
    }

    public BlockingFlowTypeInfo getDefaultBlockingFlowTypeInfo(Context ctx) throws EASBizException, BOSException {
        EntityViewInfo vi = new EntityViewInfo();
        FilterInfo fInfo = new FilterInfo();
        fInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"001", CompareType.EQUALS));
        vi.setFilter(fInfo);
        BlockingFlowTypeCollection bftCollection = null;
        bftCollection = BlockingFlowTypeFactory.getLocalInstance((Context)ctx).getBlockingFlowTypeCollection(vi);
        if (bftCollection == null || bftCollection.size() == 0) {
            throw new LoanException(LoanException.BLOCKINGFLOWTYPENUMBER001NOTEXISTS);
        }
        BlockingFlowTypeInfo bftInfo = bftCollection.get(0);
        return bftInfo;
    }

    public String getLoanIdfromContextMap() {
        Map loanIdMap = this.getContextMap();
        return (String)loanIdMap.get("loanID");
    }

    private CoreBaseCollection getRepayEntryCol(Context ctx, String loanId) throws BOSException {
        EntityViewInfo vi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent", (Object)loanId, CompareType.EQUALS));
        vi.setFilter(filter);
        return LoanEntryFactory.getLocalInstance(ctx).getCollection(vi);
    }

    protected String getTemplateNumber() {
        return "RepayPlan";
    }

    public BigDecimal getRepayEntryTotal(Context ctx, String loanId) throws BOSException {
        BigDecimal sumAmount = BigDecimal.ZERO;
        EntityViewInfo vi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent", (Object)loanId, CompareType.EQUALS));
        vi.setFilter(filter);
        CoreBaseCollection col = LoanEntryFactory.getLocalInstance(ctx).getCollection(vi);
        if (EmptyUtil.isEmpty((AbstractObjectCollection)col)) {
            return BigDecimal.ZERO;
        }
        for (int i = 0; i < col.size(); ++i) {
            LoanEntryInfo info = (LoanEntryInfo)col.get(i);
            sumAmount = sumAmount.add(info.getAmount());
        }
        return sumAmount;
    }
}

