/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fs.ISubsidiaryBookProvider;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;

public class RepaymentBillSubsidiaryBookProvider
implements ISubsidiaryBookProvider {
    public SubsidiaryLedgerCollection getCollection(Context ctx, String billId) throws BOSException, EASBizException {
        RepaymentInfo billInfo = this.getRepaymentBill(ctx, billId);
        BigDecimal creditAmt = billInfo.getAmount();
        if (billInfo.getSourceType() == FinancingBillTypeEnum.CommercialDraft) {
            PayableBillInfo commInfo = PayableBillFactory.getLocalInstance((Context)ctx).getPayableBillInfo((IObjectPK)new ObjectUuidPK(billInfo.getSourceBillId()));
            if (commInfo == null) {
                throw new BOSException("source bill is empty");
            }
            creditAmt = commInfo.getAmount();
        }
        SubsidiaryLedgerInfo slInfo = new SubsidiaryLedgerInfo();
        slInfo.setApplyUnit(billInfo.getInnerAccount().getApplyUnit());
        slInfo.setCompany(billInfo.getInnerAccount().getCompany());
        slInfo.setInnerAccount(billInfo.getInnerAccount());
        slInfo.setCurrency(billInfo.getCurrency());
        slInfo.setBillId(billInfo.getId());
        slInfo.setBillNumber(billInfo.getNumber());
        slInfo.setDate(DateTimeUtils.truncateDate((Date)billInfo.getBizDate()));
        slInfo.setCpCurrency(billInfo.getCurrency());
        slInfo.setDescription(EASCommonResource.getString((String)"com.kingdee.eas.fm.fin.FinResource.CommerDraftRepayment", (Locale)ctx.getLocale()));
        slInfo.setCreditAmount(creditAmt);
        slInfo.setDebitAmount(Constants.ZERO);
        slInfo.setExchangeRate(RepaymentBillSubsidiaryBookProvider.getExRate(ctx, billInfo.getCurrency().getId()));
        slInfo.setBookkeeper(billInfo.getCreator());
        slInfo.setIsDownLoad(false);
        SubsidiaryLedgerCollection coll = new SubsidiaryLedgerCollection();
        coll.add(slInfo);
        return coll;
    }

    private RepaymentInfo getRepaymentBill(Context ctx, String repaymentBillId) throws BOSException, EASBizException {
        SelectorItemCollection sicEndorse = new SelectorItemCollection();
        sicEndorse.add("*");
        sicEndorse.add("innerAccount.*");
        sicEndorse.add("innerAccount.company.*");
        sicEndorse.add("innerAccount.applyUnit.*");
        RepaymentInfo repaymentBillInfo = RepaymentFactory.getLocalInstance(ctx).getRepaymentInfo((IObjectPK)new ObjectUuidPK(repaymentBillId), sicEndorse);
        return repaymentBillInfo;
    }

    private static BigDecimal getExRate(Context ctx, BOSUuid currencyId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        BOSUuid companyId = currentCompany.getId();
        BOSUuid baseCurId = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(currentCompany).getId();
        return FinUtils.getCurrencyExRate(ctx, companyId, currencyId, baseCurId, DateUtil.getDayBegin());
    }
}

