/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.exception.biz.WfBizException;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.fin.IRepayment;
import com.kingdee.eas.fm.fin.LetOfCreditAcctRecordCollection;
import com.kingdee.eas.fm.fin.LetOfCreditAcctRecordFactory;
import com.kingdee.eas.fm.fin.LetterException;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LetterStatusEnum;
import com.kingdee.eas.fm.fin.LoanInterestInfo;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.StatusExtEnum;
import com.kingdee.eas.fm.fin.app.AbstractRepaymentWebFacadeControllerBean;
import com.kingdee.eas.fm.nt.LetterOfCreditApplyException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class RepaymentWebFacadeControllerBean
extends AbstractRepaymentWebFacadeControllerBean {
    private static final long serialVersionUID = -8262535379885894993L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.RepaymentWebFacadeControllerBean");
    public static final String RESOURCE = "com.kingdee.eas.fm.fin.FinWebResource";

    @Override
    protected Map _batchAudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        IRepayment repayment = RepaymentFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        for (int i = 0; i < ids.length; ++i) {
            RepaymentInfo info = repayment.getRepaymentInfo((IObjectPK)new ObjectUuidPK(ids[i]), this.getSelectors());
            try {
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_repayment_audit");
                if (!isPermission) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"NO_AUDIT_PERMISSION", (String[])new String[]{info.getCompany().getName()}));
                }
                if (0 != info.getStatusExtEnum().getValue()) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"CANNOT_AUDIT_FOR_UNSUBMIT"));
                }
                repayment.audit(info);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("auditor"));
                UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserByID(ctx.getCaller());
                info.setAuditor(user);
                repayment.updatePartial((CoreBaseInfo)info, selector);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"REPAYMENT_AUDIT_FAILED", (String[])new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource((Context)ctx, (String)"ALREADY_IN_WORKFLOW")}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"REPAYMENT_AUDIT_FAILED", (String[])new String[]{info.getNumber(), e.getMessage()}));
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"ALL_AUDIT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"AUDIT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _batchUnAudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        IRepayment repayment = RepaymentFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        for (int i = 0; i < ids.length; ++i) {
            RepaymentInfo info = RepaymentFactory.getLocalInstance(ctx).getRepaymentInfo((IObjectPK)new ObjectStringPK(ids[i]), this.getSelectors());
            try {
                this.beforeUnAudit(ctx, info);
                repayment.antiAudit(ids[i]);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"REPAYMENT_UNAUDIT_FAILED", (String[])new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource((Context)ctx, (String)"ALREADY_IN_WORKFLOW")}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"REPAYMENT_UNAUDIT_FAILED", (String[])new String[]{info.getNumber(), e.getMessage()}));
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"ALL_UNAUDIT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UNAUDIT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    private void beforeUnAudit(Context ctx, RepaymentInfo info) throws Exception {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_repayment_antiaudit");
        if (!isPermission) {
            throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"NO_UNAUDIT_PERMISSION", (String[])new String[]{info.getCompany().getName()}));
        }
        String reachId = info.getLetterOfCreditReachID();
        if (reachId != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bill.isDirect", (Object)new Integer("1"), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("reachId", (Object)reachId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("bankReturnStatus", (Object)3, CompareType.EQUALS));
            view.setFilter(filter);
            LetOfCreditAcctRecordCollection colls = LetOfCreditAcctRecordFactory.getLocalInstance(ctx).getLetOfCreditAcctRecordCollection(view);
            if (colls != null && colls.size() > 0) {
                throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"Reach_is_Accept_Cant_Unaudit"));
            }
        }
        if (info != null && info.isIsCommitToBe() && (info.getBankReturnStatus() == null || 4 != info.getBankReturnStatus().getValue())) {
            throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"UNAUDIT_FAILED_FOR_COMMIT_TO_BE"));
        }
        if (info != null && info.getStatusExtEnum() != StatusExtEnum.AUDIT) {
            throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"CANNOT_UNAUDIT_FOR_UNAUDIT"));
        }
        BOTRelationCollection colls = this.getBOTRelation(ctx, info.getId().toString());
        if (colls.size() > 0) {
            throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"canAntiAudit"));
        }
    }

    @Override
    protected Map _batchDelete(Context ctx, String[] ids) throws BOSException, EASBizException {
        IRepayment repayment = RepaymentFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        for (int i = 0; i < ids.length; ++i) {
            RepaymentInfo info = repayment.getRepaymentInfo((IObjectPK)new ObjectUuidPK(ids[i]), this.getSelectors());
            try {
                this.beforeDelete(ctx, info);
                RepaymentFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(ids[i]));
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"REPAYMENT_DELETE_FAILED", (String[])new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource((Context)ctx, (String)"ALREADY_IN_WORKFLOW")}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"REPAYMENT_DELETE_FAILED", (String[])new String[]{info.getNumber(), e.getMessage()}));
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"ALL_DELETE_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"DELETE_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    private void beforeDelete(Context ctx, RepaymentInfo info) throws EASBizException, BOSException {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_Repayment_delete");
        if (!isPermission) {
            throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"NO_DELETE_PERMISSION", (String[])new String[]{info.getCompany().getName()}));
        }
        if (0 != info.getStatusExtEnum().getValue() && -1 != info.getStatusExtEnum().getValue()) {
            throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"Repayment_CantAudit_180"));
        }
    }

    @Override
    protected Map _batchSubmit(Context ctx, String[] ids) throws BOSException, EASBizException {
        IRepayment repayment = RepaymentFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        for (int i = 0; i < ids.length; ++i) {
            RepaymentInfo info = repayment.getRepaymentInfo((IObjectPK)new ObjectUuidPK(ids[i]));
            HashSet<String> idList = new HashSet<String>();
            idList.add(ids[i]);
            try {
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_Repayment_update");
                if (!isPermission) {
                    String companyId = info.getCompany().getId().toString();
                    SelectorItemCollection companySic = new SelectorItemCollection();
                    companySic.add(new SelectorItemInfo("id"));
                    companySic.add(new SelectorItemInfo("name"));
                    CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), companySic);
                    throw new LetterException(LetterException.NOREPAYMENTEDITPREMISSION_066, new String[]{company.getName()});
                }
                if (-1 != info.getStatusExtEnum().getValue()) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"CANNOT_SUBMIT_FOR_UNSAVE"));
                }
                RepaymentFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"REPAYMENT_SUBMIT_FAILED", (String[])new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource((Context)ctx, (String)"ALREADY_IN_WORKFLOW")}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"REPAYMENT_SUBMIT_FAILED", (String[])new String[]{info.getNumber(), e.getMessage()}));
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"ALL_SUBMIT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"SUBMIT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _beforeSubmit(Context ctx, RepaymentInfo info) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((String)info.getSourceBillId())) {
            throw new LetterException(LetterException.PULLTOGENERATE_019);
        }
        if (info.getSourceBillId() != null) {
            ObjectUuidPK sourceId = new ObjectUuidPK(info.getSourceBillId());
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("isDYZ"));
            LetterOfCreditInfo letter = (LetterOfCreditInfo)LetterOfCreditFactory.getLocalInstance(ctx).getCoreBillBaseInfo((IObjectPK)sourceId, sic);
            if (!letter.isIsDYZ() && info.getSourceAmount().compareTo(new BigDecimal(String.valueOf(0))) < 0) {
                throw new LetterException(LetterException.SOURCEAMOUNTNOTNULL_020);
            }
        }
        return new HashMap();
    }

    @Override
    protected Map _submit(Context ctx, RepaymentInfo info) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        try {
            this.beforeSubmit(ctx, info);
            if (info.getHxdNumber() != null || info.getBabNumber() != null) {
                RepaymentFactory.getLocalInstance(ctx).writeLetterOfCredit(info);
            }
            String sourceBillId = info.getSourceBillId();
            String reachId = info.getLetterOfCreditReachID();
            LetterOfCreditInfo lcInfo = null;
            Object lcrInfo = null;
            if (sourceBillId != null) {
                lcInfo = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
                info.setIsDirect(lcInfo.isIsDirect());
            }
            RepaymentFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
            if (reachId != null) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("bill.isDirect", (Object)new Integer("1"), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("reachId", (Object)reachId, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("bankReturnStatus", (Object)3, CompareType.EQUALS));
                view.setFilter(filter);
                LetOfCreditAcctRecordCollection colls = LetOfCreditAcctRecordFactory.getLocalInstance(ctx).getLetOfCreditAcctRecordCollection(view);
                if (colls != null && colls.size() > 0) {
                    info.setStatusExtEnum(StatusExtEnum.AUDIT);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("statusExtEnum"));
                    RepaymentFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
                }
            }
            result.setSummaryMsg(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"SUBMIT_SUCCESS"));
            result.setError(0);
        }
        catch (WfBizException e) {
            result.setError(1);
            result.setSummaryMsg(CASWebUtil.getResource((Context)ctx, (String)"ALREADY_IN_WORKFLOW"));
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }

    @Override
    protected Map _commitToBe(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)RepaymentFactory.getLocalInstance(ctx).commitToBe(ids);
        return result;
    }

    @Override
    protected Map _synStatus(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)RepaymentFactory.getLocalInstance(ctx).synStatus(ids);
        return result;
    }

    @Override
    protected Map _addFee(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("company.id"));
            sic.add(new SelectorItemInfo("company.name"));
            sic.add(new SelectorItemInfo("LetterStatus"));
            sic.add(new SelectorItemInfo("letterNumber"));
            LetterOfCreditInfo info = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(id), sic);
            boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_FeeManager_addnew");
            if (!isPermission) {
                throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NO_ADDFEE_PERMISSION_41, (Object[])new String[]{info.getCompany().getName()});
            }
            if (LetterStatusEnum.close.equals((Object)info.getLetterStatus())) {
                throw new LetterException(LetterException.CANTADDFEECAUSECOLSED_079, new String[]{info.getLetterNumber()});
            }
            result.setError(0);
            String successMsg = CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"ADDFEESUCCESS_178");
            result.setSummaryMsg(successMsg);
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("isCommitToBe"));
        sic.add(new SelectorItemInfo("bankReturnStatus"));
        sic.add(new SelectorItemInfo("statusExtEnum"));
        sic.add(new SelectorItemInfo("SourceType"));
        sic.add(new SelectorItemInfo("letterOfCreditReachID"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("isDirect"));
        return sic;
    }

    private BOTRelationCollection getBOTRelation(Context ctx, String billId) throws BTPException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        view.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)billId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)new LoanInterestInfo().getBOSType().toString(), CompareType.NOTEQUALS));
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection relateColl = iBOTRelation.getCollection(view);
        return relateColl;
    }

    @Override
    protected Map _edit(Context ctx, String repaymentId) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        try {
            RepaymentInfo info = RepaymentFactory.getLocalInstance(ctx).getRepaymentInfo((IObjectPK)new ObjectUuidPK(repaymentId), this.getSelectors());
            boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_Repayment_update");
            if (!isPermission) {
                throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"No_Repayment_Edit_Permission_182", (String[])new String[]{info.getCompany().getName()}));
            }
            result.setError(0);
            result.setSummaryMsg(CASWebUtil.getResource((Context)ctx, (String)RESOURCE, (String)"Repayment_Edit_Perm_Pass_181"));
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }

    @Override
    protected Map _getSumInfo(Context ctx, String filter, String selectedIds) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fm.fin.app", "RepaymentBillSumQuery"));
        try {
            queryExecutor.setObjectView("SELECT billCount,moneySum where " + filter);
            IRowSet rowSet = queryExecutor.executeQuery();
            rowSet.next();
            result.put("billCount", rowSet.getBigDecimal("billCount"));
            result.put("moneySum", rowSet.getBigDecimal("moneySum"));
            HashMap<String, BigDecimal> idMap = new HashMap<String, BigDecimal>();
            queryExecutor.setObjectView("SELECT id,SourceAmount where " + filter);
            try {
                rowSet = queryExecutor.executeQuery();
                while (rowSet.next()) {
                    idMap.put(rowSet.getString("id"), rowSet.getBigDecimal("SourceAmount"));
                }
                result.put("idMap", idMap);
            }
            catch (Exception e) {
                result.put("error", 1);
                result.put("msg", e.getMessage());
                e.printStackTrace();
            }
            StringBuffer validIdSql = new StringBuffer("SELECT id where " + filter + " and id in('NE'");
            ArrayList<String> validIdList = new ArrayList<String>();
            if (!selectedIds.equals("")) {
                String[] idArr = selectedIds.split(",");
                for (int i = 0; i < idArr.length; ++i) {
                    validIdSql.append(",'" + idArr[i] + "'");
                }
                validIdSql.append(")");
                queryExecutor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fm.fin.app", "RepaymentWebQuery"));
                queryExecutor.setObjectView(validIdSql.toString());
                rowSet = queryExecutor.executeQuery();
                while (rowSet.next()) {
                    validIdList.add(rowSet.getString("id"));
                }
            }
            result.put("validIdList", validIdList);
            result.put("error", 0);
        }
        catch (Exception e) {
            result.put("error", 1);
            result.put("msg", e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    @Override
    protected Map _modifyBankReturnStatus(Context ctx, String id, int status) throws BOSException, EASBizException {
        BatchExecuteResult result = (BatchExecuteResult)RepaymentFactory.getLocalInstance(ctx).modifyBankReturnStatus(id, status);
        return result;
    }
}

