/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.app.IRptDimensionHandler;
import com.kingdee.eas.fm.fin.FinBaseDataException;
import com.kingdee.eas.fm.fin.LoanAdjustInterestCollection;
import com.kingdee.eas.fm.fin.LoanAdjustInterestFactory;
import com.kingdee.eas.fm.fin.LoanAdjustInterestInfo;
import com.kingdee.eas.fm.fin.app.RptFinanceCostMeasureFacadeControllerBean;
import com.kingdee.eas.fm.fin.vo.LoanLprResultVo;
import com.kingdee.eas.fm.im.IntRateBaseCollection;
import com.kingdee.eas.fm.im.IntRateBaseFactory;
import com.kingdee.eas.fm.im.IntRateBaseInfo;
import com.kingdee.eas.fm.im.IntRateTypeCollection;
import com.kingdee.eas.fm.im.IntRateTypeFactory;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.bireport.app.BireportBaseFacadeControllerBean;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class RptFinanceCostMeasureBaseHandler
implements IRptDimensionHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.RptFinanceCostMeasureBaseHandler");
    private String tbl = "loanForInterest";
    protected Set companyIds;
    protected Set bankIds;
    protected Date startDate;
    protected Date endDate;
    protected boolean inGroup;
    protected boolean outGroup;
    protected boolean containBonds;
    protected AmountUnitEnum unit;
    protected Set rateCurrencyIdSet;
    protected String temptable = "";
    protected int days = 0;
    protected String loc;
    private int[] ids;
    private String[] names;
    private Date[] edgeDates;
    private CompanyOrgUnitInfo currentCompany = null;
    private UserInfo currentUser = null;
    private boolean isVirtualCompany = false;
    private Calendar cal = Calendar.getInstance();

    public CompanyOrgUnitInfo getCurrentCompany(Context ctx) {
        if (this.currentCompany == null) {
            this.currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        }
        if (this.currentUser == null) {
            this.currentUser = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        }
        return this.currentCompany;
    }

    public RptFinanceCostMeasureBaseHandler(String tbl) {
        this.tbl = tbl;
    }

    public SchemaSource getSchemaSource(Context ctx, RptParams param) throws BOSException, EASBizException {
        this.getCurrentCompany(ctx);
        long startTime = System.currentTimeMillis();
        this.parseRptParams(ctx, param);
        long endTime = System.currentTimeMillis();
        logger.info((Object)("\u89e3\u6790\u53c2\u6570\u8017\u65f6\uff1a" + (endTime - startTime) / 1000L));
        startTime = System.currentTimeMillis();
        this.buildCurrencyRate(ctx);
        endTime = System.currentTimeMillis();
        logger.info((Object)("\u6784\u5efa\u5e01\u522b\u6c47\u7387\u4e34\u65f6\u8868\u8017\u65f6\uff1a" + (endTime - startTime) / 1000L));
        startTime = System.currentTimeMillis();
        this.buildLPRInterestRateFromLoan(ctx);
        endTime = System.currentTimeMillis();
        logger.info((Object)("\u6784\u5efa\u5e01\u522b\u6c47\u7387\u4e34\u65f6\u8868\u8017\u65f6\uff1a" + (endTime - startTime) / 1000L));
        SchemaSource ss = new SchemaSource();
        String factSql = this.getFactSql(ctx);
        ss.setDataItem("Fact", factSql, null);
        String[] name = this.getDimensionNames();
        String[] sqls = this.getDimensionSqls(ctx);
        for (int i = 0; i < name.length; ++i) {
            ss.setDataItem(name[i], sqls[i], null);
        }
        String mDXStr = this.getMDX(ctx, param);
        logger.error((Object)("mDXStr : " + mDXStr));
        ss.setMdx(mDXStr);
        ss.setFilename(this.getConfigXML());
        ss.setCaller(RptFinanceCostMeasureFacadeControllerBean.class);
        return ss;
    }

    private void parseRptParams(Context ctx, RptParams param) throws BOSException, EASBizException {
        this.loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        this.isVirtualCompany = (Boolean)param.getObjectElement("isVirtualCompany");
        this.companyIds = (Set)param.getObject("companyIdSet");
        this.startDate = (Date)param.getObjectElement("startDate.value");
        this.endDate = (Date)param.getObjectElement("endDate.value");
        this.bankIds = (Set)param.getObject("bankIdSet");
        this.unit = (AmountUnitEnum)param.getObjectElement("unit.value");
        this.inGroup = (Boolean)param.getObjectElement("inGroup.value");
        this.outGroup = (Boolean)param.getObjectElement("outGroup.value");
        this.containBonds = (Boolean)param.getObjectElement("containBonds.value");
        try {
            this.days = this.daysBetween(this.startDate, this.endDate);
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        this.rateCurrencyIdSet = (Set)param.getObject("RateCurrencySet");
    }

    private void buildCurrencyRate(Context ctx) throws BOSException, EASBizException {
        if (!EmptyUtil.isEmpty((Collection)this.companyIds)) {
            this.temptable = this.buildFactTempTable(ctx);
            HashSet<String> currencyIdSet = new HashSet<String>();
            String currencySql = this.getCurrencySql(ctx);
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)currencySql);
                while (rs.next()) {
                    currencyIdSet.add(rs.getString("FCurrencyId"));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            Iterator it = currencyIdSet.iterator();
            String locCurrencyId = (String)this.rateCurrencyIdSet.iterator().next();
            CurrencyInfo locCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(locCurrencyId));
            CompanyOrgUnitInfo company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            String currencyStr = "";
            while (it.hasNext()) {
                String currencyid = (String)it.next();
                BigDecimal rate = null;
                if (currencyid.equals(locCurrencyId)) {
                    rate = Constants.ONE;
                } else {
                    CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyid));
                    ExchangeRateInfo rateInfo = FMHelper.getExRateInfo((Context)ctx, (CurrencyInfo)currency, (CurrencyInfo)locCurrency, (CompanyOrgUnitInfo)company, (Date)this.endDate);
                    if (EmptyUtil.isEmpty((CoreBaseInfo)rateInfo)) {
                        currencyStr = currencyStr + "," + currency.getName();
                    } else {
                        rate = ConvertModeEnum.INDIRECTEXCHANGERATE.equals((Object)rateInfo.getConvertMode()) ? Constants.ONE.divide(rateInfo.getConvertRate(), 20, 4) : rateInfo.getConvertRate();
                    }
                }
                String sql = "insert into " + this.temptable + " values('" + currencyid + "', " + rate + ")";
                DbUtil.execute((Context)ctx, (String)sql);
            }
            if (currencyStr.length() > 0) {
                throw new FinBaseDataException(FinBaseDataException.EXCEPTIONEXHANGERATE, new Object[]{currencyStr.substring(1), locCurrency.getName()});
            }
        }
    }

    private void buildLPRInterestRateFromLoan(Context ctx) throws BOSException, EASBizException {
        Map<String, List<IntRateBaseInfo>> rateMap = this.prepareIntRateBaseMap(ctx);
        Map<String, List<LoanAdjustInterestInfo>> adjustMap = this.prepareAdjustInterestMap(ctx, new HashSet());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT  loan.FID AS FID, loan.Fnumber, loan.ldate, loan.FCURRENCYID, loan.fcompanyid, loan.fgroupid, loan.finstitutionid, loan.ftypeid, loan.FINTRATETYPEID AS LOANRATETYPEID");
        sb.append(",loan.FFIRSTRATEADJUSTDATE AS LOANFIRSTRATEADJUSTDATE ,loan.FRATEADJUSTPERIOD AS LOANRATEADJUSTPERIOD ,loan.FBASEPOINTS AS LOANBASEPOINTS, CASE WHEN FADJUSTDATE is null THEN 0 ELSE 1\tEND AS FISADJUST");
        sb.append(", justinterest.FADJUSTDATE,justinterest.FFIRSTRATEADJUSTDATE AS FFIRSTRATEADJUSTDATE, justinterest.FRATEADJUSTPERIOD");
        sb.append(", CASE WHEN loan.ldate < loan.fissuedate\tTHEN 0 WHEN loan.ldate >= loan.fissuedate THEN (isnull(loan.fbalance, 0) + isnull(repay.famount, 0)) ELSE 0\tEND AS Fbalance");
        sb.append(", loan.fbalance AS balance, justinterest.FMODIFYRATETYPE, justinterest.FADJUSTAFTERRATE");
        sb.append(", justinterest.FINTRATETYPEID, justinterest.FBASEPOINTS, loan.fissuedate, loan.fyieldrate, loan.fisbonds,loan.fyeardays");
        sb.append(" FROM ( SELECT ldate, fid, fnumber, fbalance, fyieldrate, FINTRATETYPEID, FFIRSTRATEADJUSTDATE, FRATEADJUSTPERIOD, FBASEPOINTS, FCURRENCYID, fcompanyid, fgroupid, finstitutionid, ftypeid, fissuedate,fisbonds,fyeardays FROM (SELECT {").append(sdf.format(this.startDate).trim()).append("} + rownum - 1 AS ldate FROM user_objects WHERE rownum < {").append(sdf.format(this.endDate).trim()).append("}-{").append(sdf.format(this.startDate).trim()).append("} + 1 AS dateA ) ");
        sb.append(",(SELECT\tfbalance, fid, fnumber, fyieldrate, FINTRATETYPEID, FFIRSTRATEADJUSTDATE, FRATEADJUSTPERIOD, FBASEPOINTS, FCURRENCYID, fcompanyid, fgroupid, finstitutionid, ftypeid, fissuedate,fisbonds,fyeardays FROM T_FIN_Loan loan ");
        sb.append(this.getFactWhere(ctx)).append(")) loan ");
        sb.append(" LEFT JOIN ((SELECT ldate, floanid, sum(famount) AS famount FROM (SELECT {").append(sdf.format(this.startDate).trim()).append(" } + rownum - 1 AS ldate FROM user_objects WHERE rownum < {").append(sdf.format(this.endDate).trim()).append("}-{").append(sdf.format(this.startDate).trim()).append("} + 1 ) AS dateA ");
        sb.append(" ,(SELECT FLOANID, famount, fbizdate\tFROM t_fin_repayment WHERE floanid IS NOT NULL) repay ");
        sb.append(" WHERE repay.fbizdate > dateA.ldate GROUP BY ldate, floanid)) repay ON repay.floanid = loan.fid AND repay.ldate = loan.ldate ");
        sb.append(" LEFT JOIN T_FIN_LOANADJUSTINTEREST justinterest ON justinterest.floanid = loan.fid");
        sb.append(" order by loan.FID, loan.ldate, justinterest.FADJUSTDATE, justinterest.FFIRSTRATEADJUSTDATE, justinterest.FMODIFYRATETYPE ");
        logger.error((Object)("QuerySql : " + sb.toString()));
        ArrayList<LoanLprResultVo> voList = new ArrayList<LoanLprResultVo>();
        HashMap<String, Date> firDateMap = new HashMap<String, Date>();
        HashSet<String> idSet = new HashSet<String>();
        HashSet<String> loanRateSet = new HashSet<String>();
        try {
            HashSet<String> keySet = null;
            Date firtstAdjustDate = null;
            LoanLprResultVo preLoanLprVo = new LoanLprResultVo();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            int index = 0;
            while (rs.next()) {
                LoanLprResultVo vo = new LoanLprResultVo();
                vo.setId(rs.getString("FID"));
                vo.setNumber(rs.getString("Fnumber"));
                vo.setlDate(rs.getDate("LDATE"));
                vo.setCurrencyId(rs.getString("FCURRENCYID"));
                vo.setCompanyId(rs.getString("FCOMPANYID"));
                vo.setGroupId(rs.getString("FGROUPID"));
                vo.setInstitutionId(rs.getString("FINSTITUTIONID"));
                vo.setTypeId(rs.getString("FTYPEID"));
                vo.setLoanRateTypeId(rs.getString("LOANRATETYPEID"));
                vo.setLoanFirstRateAdjustDate(rs.getDate("LOANFIRSTRATEADJUSTDATE"));
                vo.setLoanRateAdjustPeriod(rs.getInt("LOANRATEADJUSTPERIOD"));
                vo.setLoanBasePoints(rs.getBigDecimal("LOANBASEPOINTS"));
                vo.setIsAdjust(rs.getBoolean("FISADJUST"));
                vo.setAdjustDate(rs.getDate("FADJUSTDATE"));
                vo.setAdjustAfterRate(rs.getBigDecimal("FADJUSTAFTERRATE"));
                vo.setFirstFixedPriceDate(rs.getDate("FFIRSTRATEADJUSTDATE"));
                vo.setAdjustPiod(rs.getInt("FRATEADJUSTPERIOD"));
                vo.setfBalance(rs.getBigDecimal("FBalance"));
                vo.setBalance(rs.getBigDecimal("balance"));
                vo.setModifyRateType(rs.getInt("FMODIFYRATETYPE"));
                vo.setAdjustRateTypeId(rs.getString("FINTRATETYPEID"));
                vo.setBasePoints(rs.getBigDecimal("FBASEPOINTS"));
                vo.setIssueDate(rs.getDate("FIssuedate"));
                vo.setYieldrate(rs.getBigDecimal("FYIELDRATE"));
                vo.setIsBondsFlag(rs.getBoolean("fisbonds"));
                vo.setYearDays(rs.getInt("fyeardays"));
                String key = vo.getId() + vo.getlDate().toString();
                if (!idSet.contains(vo.getId())) {
                    keySet = null;
                    keySet = new HashSet<String>();
                    idSet.add(vo.getId());
                    keySet.add(key);
                    firtstAdjustDate = vo.getAdjustDate();
                    if (!loanRateSet.contains(vo.getLoanRateTypeId())) {
                        loanRateSet.add(vo.getLoanRateTypeId());
                    }
                    firDateMap.put(vo.getId(), firtstAdjustDate);
                } else if (keySet.contains(key)) {
                    if (vo.getlDate().before(firtstAdjustDate) && vo.getAdjustDate().after(firtstAdjustDate) || vo.getAdjustDate().after(vo.getlDate())) continue;
                    if (preLoanLprVo.getAdjustDate().before(vo.getlDate())) {
                        --index;
                        voList.remove(preLoanLprVo);
                    }
                } else {
                    keySet.add(key);
                }
                ++index;
                voList.add(vo);
                preLoanLprVo = vo;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        idSet = null;
        idSet = new HashSet();
        Map loanRateMap = this.prepareLoanRateMap(ctx, loanRateSet);
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Date adjustRateDate = null;
        Date pointAdjustDate = null;
        Date nextAdjustDate = null;
        for (int i = 0; i < voList.size(); ++i) {
            BigDecimal rate = Constants.ZERO;
            LoanLprResultVo vo = (LoanLprResultVo)voList.get(i);
            if (vo.isBondsFlag()) {
                BigDecimal yearDays = new BigDecimal(vo.getYearDays());
                rate = vo.getYieldrate();
                if (vo.getIsAdjust()) {
                    adjustRateDate = vo.getAdjustDate();
                    if ((vo.getlDate().equals(adjustRateDate) || vo.getlDate().after(adjustRateDate)) && vo.getModifyRateType().equals(new Integer("2"))) {
                        rate = vo.getAdjustAfterRate();
                    }
                }
            } else {
                if (!idSet.contains(vo.getId())) {
                    idSet.add(vo.getId());
                    if (!vo.getIsAdjust()) {
                        if (this.isLprRate(loanRateMap, vo.getLoanRateTypeId())) {
                            if (vo.getlDate().before(vo.getLoanFirstRateAdjustDate())) {
                                pointAdjustDate = vo.getlDate();
                            } else if (vo.getLoanRateAdjustPeriod() != 0) {
                                nextAdjustDate = vo.getLoanFirstRateAdjustDate();
                                while (vo.getlDate().equals(nextAdjustDate) || vo.getlDate().after(nextAdjustDate)) {
                                    pointAdjustDate = nextAdjustDate;
                                    nextAdjustDate = this.addPeriodDate(nextAdjustDate, vo.getLoanRateAdjustPeriod());
                                }
                            } else {
                                pointAdjustDate = vo.getlDate();
                            }
                        }
                    } else {
                        adjustRateDate = (Date)firDateMap.get(vo.getId());
                        if (adjustRateDate.after(vo.getLoanFirstRateAdjustDate()) && this.isLprRate(loanRateMap, vo.getLoanRateTypeId())) {
                            if (vo.getlDate().before(vo.getLoanFirstRateAdjustDate())) {
                                pointAdjustDate = vo.getlDate();
                            } else if (vo.getlDate().before(adjustRateDate) && (vo.getlDate().equals(vo.getLoanFirstRateAdjustDate()) || vo.getlDate().after(vo.getLoanFirstRateAdjustDate()))) {
                                if (vo.getLoanRateAdjustPeriod() != 0) {
                                    nextAdjustDate = vo.getLoanFirstRateAdjustDate();
                                    while (vo.getlDate().equals(nextAdjustDate) || vo.getlDate().after(nextAdjustDate)) {
                                        pointAdjustDate = nextAdjustDate;
                                        nextAdjustDate = this.addPeriodDate(nextAdjustDate, vo.getLoanRateAdjustPeriod());
                                    }
                                } else {
                                    pointAdjustDate = vo.getlDate();
                                }
                            } else if (vo.getlDate().before(vo.getFirstFixedPriceDate())) {
                                pointAdjustDate = vo.getAdjustDate();
                            } else if (vo.getAdjustPiod() != 0) {
                                nextAdjustDate = vo.getFirstFixedPriceDate();
                                while (vo.getlDate().equals(nextAdjustDate) || vo.getlDate().after(nextAdjustDate)) {
                                    pointAdjustDate = nextAdjustDate;
                                    nextAdjustDate = this.addPeriodDate(nextAdjustDate, vo.getAdjustPiod());
                                }
                            } else {
                                pointAdjustDate = vo.getlDate();
                            }
                        } else if (vo.getModifyRateType().equals(new Integer("2"))) {
                            pointAdjustDate = vo.getAdjustDate();
                        } else if (vo.getlDate().before(adjustRateDate)) {
                            pointAdjustDate = vo.getlDate();
                        } else if (vo.getlDate().before(vo.getFirstFixedPriceDate()) && (vo.getlDate().equals(adjustRateDate) || vo.getlDate().after(adjustRateDate))) {
                            pointAdjustDate = vo.getAdjustDate();
                        } else if (vo.getAdjustPiod() != 0) {
                            nextAdjustDate = vo.getFirstFixedPriceDate();
                            while (vo.getlDate().equals(nextAdjustDate) || vo.getlDate().after(nextAdjustDate)) {
                                pointAdjustDate = nextAdjustDate;
                                nextAdjustDate = this.addPeriodDate(nextAdjustDate, vo.getAdjustPiod());
                            }
                        } else {
                            pointAdjustDate = vo.getlDate();
                        }
                    }
                } else if (!vo.getIsAdjust()) {
                    if (this.isLprRate(loanRateMap, vo.getLoanRateTypeId())) {
                        if (vo.getlDate().before(vo.getLoanFirstRateAdjustDate())) {
                            pointAdjustDate = vo.getlDate();
                        } else if (vo.getLoanRateAdjustPeriod() != 0) {
                            nextAdjustDate = vo.getLoanFirstRateAdjustDate();
                            while (vo.getlDate().equals(nextAdjustDate) || vo.getlDate().after(nextAdjustDate)) {
                                pointAdjustDate = nextAdjustDate;
                                nextAdjustDate = this.addPeriodDate(nextAdjustDate, vo.getLoanRateAdjustPeriod());
                            }
                        } else {
                            pointAdjustDate = vo.getlDate();
                        }
                    }
                } else if (adjustRateDate.after(vo.getLoanFirstRateAdjustDate()) && this.isLprRate(loanRateMap, vo.getLoanRateTypeId())) {
                    if (vo.getlDate().before(vo.getLoanFirstRateAdjustDate())) {
                        pointAdjustDate = vo.getlDate();
                    } else if (vo.getlDate().before(adjustRateDate) && (vo.getlDate().equals(vo.getLoanFirstRateAdjustDate()) || vo.getlDate().after(vo.getLoanFirstRateAdjustDate()))) {
                        if (vo.getLoanRateAdjustPeriod() != 0) {
                            nextAdjustDate = vo.getLoanFirstRateAdjustDate();
                            while (vo.getlDate().equals(nextAdjustDate) || vo.getlDate().after(nextAdjustDate)) {
                                pointAdjustDate = nextAdjustDate;
                                nextAdjustDate = this.addPeriodDate(nextAdjustDate, vo.getLoanRateAdjustPeriod());
                            }
                        } else {
                            pointAdjustDate = vo.getlDate();
                        }
                    } else if (vo.getlDate().before(vo.getFirstFixedPriceDate())) {
                        pointAdjustDate = vo.getAdjustDate();
                    } else if (vo.getAdjustPiod() != 0) {
                        nextAdjustDate = vo.getFirstFixedPriceDate();
                        while (vo.getlDate().equals(nextAdjustDate) || vo.getlDate().after(nextAdjustDate)) {
                            pointAdjustDate = nextAdjustDate;
                            nextAdjustDate = this.addPeriodDate(nextAdjustDate, vo.getAdjustPiod());
                        }
                    } else {
                        pointAdjustDate = vo.getlDate();
                    }
                } else if (vo.getModifyRateType().equals(new Integer("2"))) {
                    pointAdjustDate = vo.getAdjustDate();
                } else if (vo.getlDate().before(adjustRateDate)) {
                    pointAdjustDate = vo.getlDate();
                } else if (vo.getlDate().before(vo.getFirstFixedPriceDate()) && (vo.getlDate().equals(adjustRateDate) || vo.getlDate().after(adjustRateDate))) {
                    pointAdjustDate = vo.getAdjustDate();
                } else if (vo.getAdjustPiod() != 0) {
                    nextAdjustDate = vo.getFirstFixedPriceDate();
                    while (vo.getlDate().equals(nextAdjustDate) || vo.getlDate().after(nextAdjustDate)) {
                        pointAdjustDate = nextAdjustDate;
                        nextAdjustDate = this.addPeriodDate(nextAdjustDate, vo.getAdjustPiod());
                    }
                } else {
                    pointAdjustDate = vo.getlDate();
                }
                rate = this.getTieredInterestRates(rateMap, loanRateMap, adjustRateDate, pointAdjustDate, rate, vo);
            }
            paramsList.add(new Object[]{vo.getId(), vo.getNumber(), vo.getfBalance(), vo.getlDate(), vo.getAdjustDate(), vo.getModifyRateType(), vo.getBalance(), vo.getCurrencyId(), vo.getCompanyId(), vo.getGroupId(), vo.getInstitutionId(), vo.getTypeId(), vo.getIssueDate(), rate});
        }
        String sql = "insert into " + this.tbl + " (FID, FNUMBER, BALANCE, FLDATE, FADJUSTDATE, FMODIFYRATETYPE, FBALANCE, FcurrencyId, FcompanyId, FgroupId, FinstitutionId, FtypeId, FissueDate, Rate) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
    }

    private BigDecimal getTieredInterestRates(Map<String, List<IntRateBaseInfo>> rateMap, Map<String, IntRateTypeInfo> loanRateMap, Date adjustRateDate, Date pointAdjustDate, BigDecimal rate, LoanLprResultVo vo) {
        if (!vo.getIsAdjust()) {
            if (vo.getLoanRateTypeId().equals("lJlpCQEQEADgAAc+wKgSjiR9knQ=") || vo.getLoanRateTypeId().equals("QYYAAAAKQTYkfZJ0")) {
                rate = vo.getYieldrate();
            } else if (this.isLprRate(loanRateMap, vo.getLoanRateTypeId())) {
                if (vo.getlDate().before(vo.getLoanFirstRateAdjustDate())) {
                    List<IntRateBaseInfo> intBaseList = rateMap.get(vo.getLoanRateTypeId());
                    rate = this.getLoanRateFromBaseRate(intBaseList, vo.getlDate()).add(vo.getLoanBasePoints());
                } else {
                    List<IntRateBaseInfo> intBaseList = rateMap.get(vo.getLoanRateTypeId());
                    rate = this.getLoanRateFromBaseRate(intBaseList, pointAdjustDate).add(vo.getLoanBasePoints());
                }
            } else {
                List<IntRateBaseInfo> intBaseList = rateMap.get(vo.getLoanRateTypeId());
                rate = this.getLoanRateFromBaseRate(intBaseList, vo.getlDate()).add(vo.getLoanBasePoints());
            }
        } else if (vo.getlDate().before(adjustRateDate)) {
            if (vo.getLoanRateTypeId().equals("lJlpCQEQEADgAAc+wKgSjiR9knQ=") || vo.getLoanRateTypeId().equals("QYYAAAAKQTYkfZJ0")) {
                rate = vo.getYieldrate();
            } else if (this.isLprRate(loanRateMap, vo.getLoanRateTypeId())) {
                List<IntRateBaseInfo> intBaseList = rateMap.get(vo.getAdjustRateTypeId());
                rate = this.getLoanRateFromBaseRate(intBaseList, pointAdjustDate).add(vo.getLoanBasePoints());
            } else {
                List<IntRateBaseInfo> intBaseList = rateMap.get(vo.getAdjustRateTypeId());
                rate = this.getLoanRateFromBaseRate(intBaseList, vo.getlDate()).add(vo.getLoanBasePoints());
            }
        } else if (vo.getlDate().equals(adjustRateDate) || vo.getlDate().after(adjustRateDate)) {
            if (vo.getModifyRateType().equals(new Integer("2"))) {
                rate = vo.getAdjustAfterRate();
            } else {
                List<IntRateBaseInfo> intBaseList = rateMap.get(vo.getAdjustRateTypeId());
                rate = this.getLoanRateFromBaseRate(intBaseList, pointAdjustDate).add(vo.getBasePoints());
            }
        }
        return rate;
    }

    private BigDecimal getLoanRateFromBaseRate(List<IntRateBaseInfo> intBaseList, Date ldate) {
        IntRateBaseInfo info;
        BigDecimal rate = Constants.ZERO;
        for (int t = 0; t < intBaseList.size() && !(info = intBaseList.get(t)).getEffectiveDate().after(ldate); ++t) {
            rate = info.getYearRate();
        }
        return rate;
    }

    private boolean isLprRate(Map loanRateMap, String loanRateTypeId) {
        IntRateTypeInfo rateInfo = (IntRateTypeInfo)loanRateMap.get(loanRateTypeId);
        return !EmptyUtil.isEmpty((CoreBaseInfo)rateInfo) && rateInfo.isIsLPR();
    }

    private Map prepareLoanRateMap(Context ctx, Set loanRateSet) throws BOSException {
        HashMap<String, IntRateTypeInfo> loanRateMap = new HashMap<String, IntRateTypeInfo>();
        if (EmptyUtil.isEmpty((Collection)loanRateSet)) {
            return loanRateMap;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection selector = view.getSelector();
        selector.add("id");
        selector.add("number");
        selector.add("isLPR");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)loanRateSet, CompareType.INCLUDE));
        IntRateTypeCollection rateCol = IntRateTypeFactory.getLocalInstance((Context)ctx).getIntRateTypeCollection(view);
        for (int i = 0; i < rateCol.size(); ++i) {
            IntRateTypeInfo rateInfo = rateCol.get(i);
            loanRateMap.put(rateInfo.getId().toString(), rateInfo);
        }
        return loanRateMap;
    }

    private Map<String, List<LoanAdjustInterestInfo>> prepareAdjustInterestMap(Context ctx, Set idSet) throws BOSException {
        List<LoanAdjustInterestInfo> list;
        HashMap<String, List<LoanAdjustInterestInfo>> rateMap = new HashMap<String, List<LoanAdjustInterestInfo>>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection selector = view.getSelector();
        selector.add("*");
        filter.getFilterItems().add(new FilterItemInfo("loan.id", (Object)idSet, CompareType.INCLUDE));
        LoanAdjustInterestCollection loanAdjustCol = LoanAdjustInterestFactory.getLocalInstance(ctx).getLoanAdjustInterestCollection(view);
        for (int i = 0; i < loanAdjustCol.size(); ++i) {
            LoanAdjustInterestInfo info = loanAdjustCol.get(i);
            String loanId = info.getLoan().getId().toString();
            if (rateMap.containsKey(loanId)) {
                list = (List)rateMap.get(loanId);
                list.add(info);
                continue;
            }
            list = new ArrayList();
            list.add(info);
            rateMap.put(loanId, list);
        }
        if (!EmptyUtil.isEmpty(rateMap.keySet())) {
            AdjustVOComparator c = new AdjustVOComparator();
            for (String loanId : rateMap.keySet()) {
                list = (List)rateMap.get(loanId);
                Collections.sort(list, c);
            }
        }
        return rateMap;
    }

    private Map<String, List<IntRateBaseInfo>> prepareIntRateBaseMap(Context ctx) throws BOSException {
        List<IntRateBaseInfo> list;
        HashMap<String, List<IntRateBaseInfo>> rateMap = new HashMap<String, List<IntRateBaseInfo>>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection selector = view.getSelector();
        selector.add("*");
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)"1", CompareType.EQUALS));
        IntRateBaseCollection rateBaseCol = IntRateBaseFactory.getLocalInstance((Context)ctx).getIntRateBaseCollection(view);
        for (int i = 0; i < rateBaseCol.size(); ++i) {
            IntRateBaseInfo info = rateBaseCol.get(i);
            String rateTypeId = info.getType().getId().toString();
            if (rateMap.containsKey(rateTypeId)) {
                list = (List)rateMap.get(rateTypeId);
                list.add(info);
                continue;
            }
            list = new ArrayList();
            list.add(info);
            rateMap.put(rateTypeId, list);
        }
        if (!EmptyUtil.isEmpty(rateMap.keySet())) {
            IntRateBaseVOComparator c = new IntRateBaseVOComparator();
            for (String typeId : rateMap.keySet()) {
                list = (List)rateMap.get(typeId);
                Collections.sort(list, c);
            }
        }
        return rateMap;
    }

    private Date addPeriodDate(Date baseDate, int adjustPiod) {
        this.cal.setTime(baseDate);
        this.cal.add(2, adjustPiod);
        return this.cal.getTime();
    }

    public int daysBetween(Date startDate, Date endData) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        startDate = sdf.parse(sdf.format(startDate));
        endData = sdf.parse(sdf.format(endData));
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        long startTime = cal.getTimeInMillis();
        cal.setTime(endData);
        long endTime = cal.getTimeInMillis();
        long between_days = (endTime - startTime) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    private String getFactSql(Context ctx) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuffer sql = new StringBuffer();
        sql.append(this.getFactSqlBegin());
        sql.append(" select fid,payrateSum,balancesum,ts,fbalanceA,fbalanceB,(isnull(fbalanceA,0)+isnull(fbalanceB,0))/ts as fbalance,fbankareatype,fcurrencyid,fcompanyid,fgroupid,finstitutionid,debteeId,typeid from (");
        sql.append(" select  loan.fid,payrateSum");
        if (this.rateCurrencyIdSet.size() > 0) {
            sql.append("*rate.frate/").append(this.unit.getValue());
        } else {
            sql.append("/").append(this.unit.getValue());
        }
        sql.append(" as payrateSum,balancesum");
        if (this.rateCurrencyIdSet.size() > 0) {
            sql.append("*rate.frate/").append(this.unit.getValue());
        } else {
            sql.append("/").append(this.unit.getValue());
        }
        sql.append(" as balancesum,avgrate, case when loan.FISSUEDATE <{").append(sdf.format(this.startDate).trim()).append("} then (fbalance+isnull(payA.famount,0))*({");
        sql.append(sdf.format(this.endDate)).append("}-{").append(sdf.format(this.startDate).trim()).append("})");
        if (this.rateCurrencyIdSet.size() > 0) {
            sql.append("*rate.frate/").append(this.unit.getValue());
        } else {
            sql.append("/").append(this.unit.getValue());
        }
        sql.append("  when loan.FISSUEDATE >={").append(sdf.format(this.startDate).trim()).append("} then (fbalance+isnull(payA.famount,0))*abs(DATEDIFF(day,{").append(sdf.format(this.endDate).trim());
        sql.append("},loan.FISSUEDATE))");
        if (this.rateCurrencyIdSet.size() > 0) {
            sql.append("*rate.frate/").append(this.unit.getValue());
        } else {
            sql.append("/").append(this.unit.getValue());
        }
        sql.append(" else 0 end as fbalanceA,isnull(payB.fbalanceA,0)");
        if (this.rateCurrencyIdSet.size() > 0) {
            sql.append("*rate.frate/").append(this.unit.getValue());
        } else {
            sql.append("/").append(this.unit.getValue());
        }
        sql.append(" as fbalanceB,{").append(sdf.format(this.endDate).trim()).append("}-{").append(sdf.format(this.startDate).trim()).append("} as ts,case when fbankareatype is null then 1 else fbankareatype end as fbankareatype,fcurrencyid,fcompanyid,fgroupid,finstitutionid, case when FGROUPID is null then FINSTITUTIONID else fgroupid end as debteeId,typeid from \n");
        sql.append("(select fid,payrate  as payrateSum,balancesum,case when balancesum=0 then 0 else (payrate/balancesum/365) end as avgrate,fbalance,fcurrencyid,fcompanyid,fgroupid,finstitutionid,ftypeid as typeid,fissuedate from (  \n");
        sql.append("select * from (  \n");
        sql.append("select fid,sum(balance*rate/100) as payrate,sum(balance) as balancesum,fbalance,fcurrencyid,fcompanyid,fgroupid,finstitutionid,ftypeid,fissuedate from \n");
        sql.append(this.tbl).append(" group by fid,fbalance,fcurrencyid,fcompanyid,fgroupid,finstitutionid,ftypeid, fissuedate))) loan  \n");
        sql.append("left join (select floanid,sum(famount) famount from t_fin_repayment where  floanid is not null  and fbizdate>{").append(sdf.format(DateUtil.getAfterDay((Date)this.endDate)).trim()).append("} group by floanid ) payA on payA.floanid=loan.fid  \n");
        sql.append("left join (select floanid,sum(isnull(famount,0)*ts) as fbalanceA from ( \n");
        sql.append(" select  floanid,repayment.famount, case when loan.FISSUEDATE <{").append(sdf.format(this.startDate).trim()).append("} then abs(DATEDIFF(day,{").append(sdf.format(this.startDate).trim()).append("},repayment.fbizdate)) when loan.FISSUEDATE >={").append(sdf.format(this.startDate).trim()).append("} then  abs(DATEDIFF(day,repayment.fbizdate,loan.fissuedate)) else 0 end as ts from  t_fin_repayment repayment \n");
        sql.append(" left join t_fin_loan loan on loan.fid = repayment.FLOANID \n");
        sql.append(" where  repayment.floanid is not null and  repayment.fbizdate>={").append(sdf.format(this.startDate).trim()).append("} and repayment.fbizdate<{").append(sdf.format(DateUtil.getAfterDay((Date)this.endDate)).trim()).append("} )group by floanid  \n").append(") payB on payB.floanid=loan.fid  \n");
        sql.append("left join  t_bd_bank bank on bank.fid=loan.finstitutionid  \n");
        sql.append("left join ").append(this.temptable).append(" rate on rate.FRateCurrencyID = loan.FCurrencyID ))\n");
        sql.append(this.getFactSqlEnd());
        logger.error((Object)("--------------------RptFinanceCostMeasure's Fact SQL: " + sql.toString()));
        return sql.toString();
    }

    protected abstract String getFactSqlBegin();

    protected abstract String getFactSqlEnd();

    protected abstract String[] getDimensionNames();

    protected abstract String[] getDimensionSqls(Context var1);

    protected abstract String getConfigXML();

    private String getCurrencySql(Context ctx) {
        String sql = "select distinct FCurrencyId from t_fin_loan loan " + this.getFactWhere(ctx);
        return sql;
    }

    protected String getFactWhere(Context ctx) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuilder sb = new StringBuilder();
        sb.append(" where 1=1  ");
        sb.append(" and loan.fstatus=3 \n");
        sb.append(" and (loan.fexpireddate>{").append(sdf.format(this.startDate).trim()).append("} and loan.fissuedate<{").append(sdf.format(this.endDate).trim()).append("}) \n");
        if (this.isVirtualCompany) {
            sb.append(" and loan.fcompanyid in ").append(FMHelper.setTran2String((Set)this.companyIds)).append(" \n");
        } else {
            sb.append(" and loan.fcompanyid='").append(this.currentCompany.getId().toString()).append("' \n");
        }
        if (this.inGroup && !this.outGroup) {
            if (this.bankIds == null || this.bankIds.size() == 0) {
                sb.append(" and loan.fisgrouploan=1 \n");
            } else {
                sb.append(" and loan.fgroupid in ").append(FMHelper.setTran2String((Set)this.bankIds)).append(" \n");
            }
        }
        if (!this.inGroup && this.outGroup) {
            if (this.bankIds == null || this.bankIds.size() == 0) {
                sb.append(" and loan.fisgrouploan=0 \n");
            } else {
                sb.append(" and loan.FINSTITUTIONID in ").append(FMHelper.setTran2String((Set)this.bankIds)).append(" \n");
            }
        }
        sb.append(" and loan.FBalance > 0 \n");
        if (!this.containBonds) {
            sb.append(" and loan.FISBONDS = 0 \n");
        }
        return sb.toString();
    }

    public ResultSet getFactResultSet(Context ctx, RptParams params) throws BOSException {
        return null;
    }

    private String buildFactTempTable(Context ctx) throws BOSException {
        String tmpTable = "T_Fin_RptCostMeasureRateTemp";
        String sSQL = "Delete From " + tmpTable;
        DbUtil.execute((Context)ctx, (String)sSQL);
        return tmpTable;
    }

    private static String getTempTableSql(Context ctx, String sql, SqlParams sp, String tempTableName) throws BOSException {
        String tempBankTablefact = BireportBaseFacadeControllerBean.getTempTableName((String)tempTableName, (Context)ctx);
        StringBuffer baseSqlfact = new StringBuffer();
        baseSqlfact.append("Select * into ").append(tempBankTablefact).append(" from ( ").append(sql).append(" ) as tt");
        BireportBaseFacadeControllerBean.executeSelectInto((String)baseSqlfact.toString(), (SqlParams)sp, (Context)ctx);
        String newSql = "select * from " + tempBankTablefact;
        return newSql;
    }

    private class AdjustVOComparator
    implements Comparator {
        private AdjustVOComparator() {
        }

        public int compare(Object o1, Object o2) {
            LoanAdjustInterestInfo info1 = (LoanAdjustInterestInfo)o1;
            LoanAdjustInterestInfo info2 = (LoanAdjustInterestInfo)o2;
            return info1.getAdjustDate().compareTo(info2.getAdjustDate());
        }
    }

    private class IntRateBaseVOComparator
    implements Comparator {
        private IntRateBaseVOComparator() {
        }

        public int compare(Object o1, Object o2) {
            IntRateBaseInfo info1 = (IntRateBaseInfo)o1;
            IntRateBaseInfo info2 = (IntRateBaseInfo)o2;
            return info1.getEffectiveDate().compareTo(info2.getEffectiveDate());
        }
    }
}

