/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.util.JournalBalanceUtil;
import com.kingdee.eas.fm.fin.LimitIsBankCreditEnum;
import com.kingdee.eas.fm.fin.app.AbstractRptGrantCreditCollectFacadeControllerBean;
import com.kingdee.eas.framework.bireport.util.BirtUtils;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptGrantCreditCollectFacadeControllerBean
extends AbstractRptGrantCreditCollectFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.RptGrantCreditCollectFacadeControllerBean");
    private LimitIsBankCreditEnum relations;

    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        SchemaSource ss = new SchemaSource();
        this.relations = (LimitIsBankCreditEnum)((Object)params.getObject("relations"));
        if (this.relations == LimitIsBankCreditEnum.TRUE || this.relations == LimitIsBankCreditEnum.FALSE) {
            this.createSchemaSource_Bank(ss, params, ctx);
        } else if (this.relations == LimitIsBankCreditEnum.INNER) {
            this.createSchemaSource_Company(ss, params, ctx);
        } else {
            this.createSchemaSource_Fix(ss, params, ctx);
        }
        return ss;
    }

    private void createSchemaSource_Fix(SchemaSource ss, RptParams params, Context ctx) throws BOSException {
        Timestamp dtUpTo = new Timestamp(((Date)params.getObjectElement("jdUpTo.value")).getTime());
        dtUpTo.setHours(23);
        dtUpTo.setMinutes(59);
        dtUpTo.setSeconds(59);
        String amountUnit = String.valueOf(((AmountUnitEnum)params.getObjectElement("jtAmountUnit.value")).getValue());
        Set creditCompanySet = (Set)params.getObject("creditCompanySet");
        Set companyIdSet = (Set)params.getObject("companyIdSet");
        boolean forCompany = (Boolean)params.getObjectElement("jrbCompany.value");
        boolean forOrganization = (Boolean)params.getObjectElement("jrbOrganization.value");
        boolean forCurrency = (Boolean)params.getObjectElement("jrbCurrency.value");
        String loc = RptGrantCreditCollectFacadeControllerBean.getLoc((Context)ctx);
        String configFile = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer mdx = new StringBuffer();
        sql.setLength(0);
        sql.append(" select distinct A.FID, A.FNumber, A.FName_" + loc + " FName from t_bd_currency A").append("\n inner join T_FIN_CreditLimit B on B.FCurrencyID=A.FID and B.FLimitType = 1 ");
        ss.setDataItem("Currency", sql.toString(), null);
        sql.setLength(0);
        sql.append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"51_RptGrantCreditCollectFacadeControllerBean", (Locale)ctx.getLocale()));
        ss.setDataItem("RegionType", sql.toString(), null);
        SqlParams spOrganization = new SqlParams();
        sql.setLength(0);
        sql.append("select distinct A.FID as fixid, ");
        sql.append("A.FNumber as fixNumber, ");
        sql.append("A.FName_").append(loc).append(" as fixName ");
        sql.append("from T_org_company A union all ");
        sql.append("select distinct A.FID as fixid, ");
        sql.append("A.FNumber as fixNumber, ");
        sql.append("A.FName_").append(loc).append(" as fixName ");
        sql.append("from T_bd_bank A ");
        ss.setDataItem("Organization", sql.toString(), spOrganization);
        SqlParams spCompany = new SqlParams();
        sql.setLength(0);
        sql.append(" select A.FID, A.FName_" + loc + " FName, A.FParentID from t_org_company  A \n where 1=1");
        JournalBalanceUtil.appendFilter((String)"A.FID", (Set)companyIdSet, (StringBuffer)sql, (SqlParams)spCompany, (String)"and");
        ss.setDataItem("Company", sql.toString(), spCompany);
        String tempTable = RptGrantCreditCollectFacadeControllerBean.getTempTableName((String)ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"43_RptGrantCreditCollectFacadeControllerBean", (Locale)ctx.getLocale()), (Context)ctx);
        StringBuffer baseSql = new StringBuffer();
        SqlParams baseSp = new SqlParams();
        baseSql.append("Select a.FID,").append(this.getFixOrgField("a")).append(",a.FRegion,a.FCurrencyID,a.FExchangeRate,a.FShareType,a.FCompanyID, ").append(" a.FLocalAmount/").append(amountUnit).append(" as FLocalSharedAmount, ").append(" a.FBalance*a.FExchangeRate/").append(amountUnit).append(" as FLocalBlance, ").append(" (a.FLocalAmount - a.FBalance*a.FExchangeRate)/").append(amountUnit).append(" as FLocalUsedAmount into ").append(tempTable).append("\n from T_FIN_CreditLimit a where 1=1 ");
        JournalBalanceUtil.appendFilter((String)"a.FCompanyID", (Set)companyIdSet, (StringBuffer)baseSql, (SqlParams)baseSp, (String)"and");
        baseSql.append("\n and a.FIssueDate<=? ");
        baseSp.addTimestamp(dtUpTo);
        boolean checkClosed = (Boolean)params.getObjectElement("checkClosed.value");
        if (checkClosed) {
            baseSql.append("\n and (FIsClosed=0 or FIsClosed=1) ");
        } else {
            baseSql.append("\n and FIsClosed=0 ");
        }
        baseSql.append("\n and a.FLimitType = 1 ");
        RptGrantCreditCollectFacadeControllerBean.executeSelectInto((String)baseSql.toString(), (SqlParams)baseSp, (Context)ctx);
        baseSql.setLength(0);
        Object rsFact = null;
        StringBuffer factSql = new StringBuffer();
        StringBuffer factGroup = new StringBuffer();
        SqlParams factsp = new SqlParams();
        if (forOrganization || forCurrency) {
            factSql.append("Select fixid,FRegion,FCurrencyID,sum(FLocalSharedAmount) as FLocalSharedAmountTotal, ").append("\n\tsum(FLocalUsedAmount) as FLocalUsedAmountTotal,sum(FLocalBlance) as FLocalBlanceTotal from ").append(tempTable).append(" group by fixid,FRegion,FCurrencyID ");
        } else {
            factSql.append(" Select FRegion,sum(FLocalSharedAmount) as FLocalSharedAmountTotal,sum(FLocalUsedAmount) as FLocalUsedAmountTotal, ").append(" sum(FLocalBlance) as FLocalBlanceTotal ").append(",FCompanyID from ").append(tempTable);
            factGroup.append("\n group by FRegion,FCompanyID ");
        }
        factSql.append(factGroup);
        ss.setDataItem("Fact", factSql.toString(), factsp);
        mdx.append(" ").append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"27_RptCreditLimitGSFacadeControllerBean", (Locale)ctx.getLocale()));
        StringBuffer selectColumns = new StringBuffer().append(" select {[Measures].members}").append(" ").append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"44_RptGrantCreditCollectFacadeControllerBean", (Locale)ctx.getLocale()));
        if (forCompany) {
            configFile = "RptGrantCreditCollect_company.xml";
            mdx.append(" ").append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"45_RptGrantCreditCollectFacadeControllerBean", (Locale)ctx.getLocale()));
            mdx.append(selectColumns);
            mdx.append(" ").append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"46_RptGrantCreditCollectFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        if (forOrganization) {
            configFile = "RptGrantCreditCollect_FixOrganization.xml";
            mdx.append(" ").append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"47_RptGrantCreditCollectFacadeControllerBean", (Locale)ctx.getLocale()));
            mdx.append(selectColumns);
            mdx.append(" ").append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"48_RptGrantCreditCollectFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        if (forCurrency) {
            configFile = "RptGrantCreditCollect_Currency.xml";
            mdx.append(" ").append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"31_RptCreditLimitGSFacadeControllerBean", (Locale)ctx.getLocale()));
            mdx.append(selectColumns);
            mdx.append(" ").append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"32_RptCreditLimitGSFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        mdx.append(" from fm");
        ss.setCaller(RptGrantCreditCollectFacadeControllerBean.class);
        ss.setFilename(configFile);
        ss.setMdx(mdx.toString());
    }

    private StringBuffer getFixOrgField(String alias) {
        StringBuffer sb = new StringBuffer();
        String isBankCredit = "";
        String creditInstitutionId = "";
        String creditCompanyID = "";
        if (alias.trim().length() == 0) {
            isBankCredit = "FIsBankCredit";
            creditInstitutionId = "FCreditInstitutionId";
            creditCompanyID = "FcreditCompanyID";
        } else {
            isBankCredit = alias + ".FIsBankCredit";
            creditInstitutionId = alias + ".FCreditInstitutionId";
            creditCompanyID = alias + ".FcreditCompanyID";
        }
        sb.append(" case ").append(isBankCredit).append(" \n");
        sb.append(" when  0  then ").append(creditInstitutionId).append(" \n");
        sb.append(" when  1  then ").append(creditInstitutionId).append(" \n");
        sb.append(" when  2  then ").append(creditCompanyID).append(" \n");
        sb.append(" else ").append(creditCompanyID).append(" \n");
        sb.append(" end as fixid \n");
        return sb;
    }

    private void createSchemaSource_Company(SchemaSource ss, RptParams params, Context ctx) throws BOSException {
        Timestamp dtUpTo = new Timestamp(((Date)params.getObjectElement("jdUpTo.value")).getTime());
        dtUpTo.setHours(23);
        dtUpTo.setMinutes(59);
        dtUpTo.setSeconds(59);
        String amountUnit = String.valueOf(((AmountUnitEnum)params.getObjectElement("jtAmountUnit.value")).getValue());
        Set creditCompanySet = (Set)params.getObject("creditCompanySet");
        Set companyIdSet = (Set)params.getObject("companyIdSet");
        boolean forCompany = (Boolean)params.getObjectElement("jrbCompany.value");
        boolean forOrganization = (Boolean)params.getObjectElement("jrbOrganization.value");
        boolean forCurrency = (Boolean)params.getObjectElement("jrbCurrency.value");
        String loc = RptGrantCreditCollectFacadeControllerBean.getLoc((Context)ctx);
        String configFile = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer mdx = new StringBuffer();
        sql.setLength(0);
        sql.append(" select distinct A.FID, A.FNumber, A.FName_" + loc + " FName from t_bd_currency A").append("\n inner join T_FIN_CreditLimit B on B.FCurrencyID=A.FID and B.FLimitType = 1 ");
        ss.setDataItem("Currency", sql.toString(), null);
        sql.setLength(0);
        sql.append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"51_RptGrantCreditCollectFacadeControllerBean", (Locale)ctx.getLocale()));
        ss.setDataItem("RegionType", sql.toString(), null);
        SqlParams spOrganization = new SqlParams();
        sql.setLength(0);
        sql.append(" select distinct A.FID, A.FNumber, A.FName_" + loc + " FName,A.FParentID FParentID ").append("\n from T_org_company A").append("\n where 1=1");
        ss.setDataItem("Organization", sql.toString(), spOrganization);
        SqlParams spCompany = new SqlParams();
        sql.setLength(0);
        sql.append(" select A.FID, A.FName_" + loc + " FName, A.FParentID from t_org_company  A \n where 1=1");
        JournalBalanceUtil.appendFilter((String)"A.FID", (Set)companyIdSet, (StringBuffer)sql, (SqlParams)spCompany, (String)"and");
        ss.setDataItem("Company", sql.toString(), spCompany);
        String tempTable = RptGrantCreditCollectFacadeControllerBean.getTempTableName((String)ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"43_RptGrantCreditCollectFacadeControllerBean", (Locale)ctx.getLocale()), (Context)ctx);
        StringBuffer baseSql = new StringBuffer();
        SqlParams baseSp = new SqlParams();
        baseSql.append("Select a.FID,a.FcreditCompanyID,a.FRegion,a.FCurrencyID,a.FExchangeRate,a.FShareType,a.FCompanyID, ").append(" a.FLocalAmount/").append(amountUnit).append(" as FLocalSharedAmount, ").append(" a.FBalance*a.FExchangeRate/").append(amountUnit).append(" as FLocalBlance, ").append(" (a.FLocalAmount - a.FBalance*a.FExchangeRate)/").append(amountUnit).append(" as FLocalUsedAmount into ").append(tempTable).append("\n from T_FIN_CreditLimit a where 1=1 ");
        this.addCommonCreditCompanyFilter(creditCompanySet, baseSql);
        JournalBalanceUtil.appendFilter((String)"a.FCompanyID", (Set)companyIdSet, (StringBuffer)baseSql, (SqlParams)baseSp, (String)"and");
        baseSql.append("\n and a.FIssueDate<=? ");
        baseSp.addTimestamp(dtUpTo);
        boolean checkClosed = (Boolean)params.getObjectElement("checkClosed.value");
        if (checkClosed) {
            baseSql.append("\n and (FIsClosed=0 or FIsClosed=1) ");
        } else {
            baseSql.append("\n and FIsClosed=0 ");
        }
        baseSql.append("\n and a.FLimitType = 1 ");
        RptGrantCreditCollectFacadeControllerBean.executeSelectInto((String)baseSql.toString(), (SqlParams)baseSp, (Context)ctx);
        baseSql.setLength(0);
        Object rsFact = null;
        StringBuffer factSql = new StringBuffer();
        StringBuffer factGroup = new StringBuffer();
        SqlParams factsp = new SqlParams();
        if (forOrganization || forCurrency) {
            factSql.append("Select FcreditCompanyID,FRegion,FCurrencyID,sum(FLocalSharedAmount) as FLocalSharedAmountTotal, ").append("\n\tsum(FLocalUsedAmount) as FLocalUsedAmountTotal,sum(FLocalBlance) as FLocalBlanceTotal from ").append(tempTable).append(" group by FcreditCompanyID,FRegion,FCurrencyID ");
        } else {
            factSql.append(" Select FRegion,sum(FLocalSharedAmount) as FLocalSharedAmountTotal,sum(FLocalUsedAmount) as FLocalUsedAmountTotal, ").append(" sum(FLocalBlance) as FLocalBlanceTotal ").append(",FCompanyID from ").append(tempTable);
            factGroup.append("\n group by FRegion,FCompanyID ");
        }
        factSql.append(factGroup);
        ss.setDataItem("Fact", factSql.toString(), factsp);
        mdx.append(" ").append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"27_RptCreditLimitGSFacadeControllerBean", (Locale)ctx.getLocale()));
        StringBuffer selectColumns = new StringBuffer().append(" select {[Measures].members}").append(" ").append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"44_RptGrantCreditCollectFacadeControllerBean", (Locale)ctx.getLocale()));
        if (forCompany) {
            configFile = "RptGrantCreditCollect_company.xml";
            mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"45_RptGrantCreditCollectFacadeControllerBean", (Locale)ctx.getLocale()));
            mdx.append(selectColumns);
            mdx.append(" ").append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"46_RptGrantCreditCollectFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        if (forOrganization) {
            configFile = "RptGrantCreditCollect_ByCompany.xml";
            mdx.append(" ").append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"49_RptGrantCreditCollectFacadeControllerBean", (Locale)ctx.getLocale()));
            mdx.append(selectColumns);
            mdx.append(" ").append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"50_RptGrantCreditCollectFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        if (forCurrency) {
            configFile = "RptGrantCreditCollect_Currency.xml";
            mdx.append(" ").append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"31_RptCreditLimitGSFacadeControllerBean", (Locale)ctx.getLocale()));
            mdx.append(selectColumns);
            mdx.append(" ").append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"32_RptCreditLimitGSFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        mdx.append(" from fm");
        ss.setCaller(RptGrantCreditCollectFacadeControllerBean.class);
        ss.setFilename(configFile);
        ss.setMdx(mdx.toString());
    }

    private void addCommonCreditCompanyFilter(Set creditCompanySet, StringBuffer sql) {
        if (creditCompanySet != null && creditCompanySet.size() > 0) {
            sql.append("\n and FcreditCompanyID in(");
            sql.append(BirtUtils.idListToInClause((Collection)creditCompanySet)).append(") and FCreditInstitutionId is null ");
        } else {
            sql.append("\n and FCreditInstitutionId is null");
        }
    }

    private void createSchemaSource_Bank(SchemaSource ss, RptParams params, Context ctx) throws BOSException {
        Timestamp dtUpTo = new Timestamp(((Date)params.getObjectElement("jdUpTo.value")).getTime());
        dtUpTo.setHours(23);
        dtUpTo.setMinutes(59);
        dtUpTo.setSeconds(59);
        String amountUnit = String.valueOf(((AmountUnitEnum)params.getObjectElement("jtAmountUnit.value")).getValue());
        Set organizationIdSet = (Set)params.getObject("organizationIdSet");
        Set companyIdSet = (Set)params.getObject("companyIdSet");
        boolean forCompany = (Boolean)params.getObjectElement("jrbCompany.value");
        boolean forOrganization = (Boolean)params.getObjectElement("jrbOrganization.value");
        boolean forCurrency = (Boolean)params.getObjectElement("jrbCurrency.value");
        String loc = RptGrantCreditCollectFacadeControllerBean.getLoc((Context)ctx);
        String configFile = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer mdx = new StringBuffer();
        Object rsCurrency = null;
        sql.setLength(0);
        sql.append(" select distinct A.FID, A.FNumber, A.FName_" + loc + " FName from t_bd_currency A").append("\n inner join T_FIN_CreditLimit B on B.FCurrencyID=A.FID  and B.FLimitType = 1 ");
        ss.setDataItem("Currency", sql.toString(), null);
        Object rsRegionType = null;
        sql.setLength(0);
        sql.append(" ").append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"51_RptGrantCreditCollectFacadeControllerBean", (Locale)ctx.getLocale()));
        ss.setDataItem("RegionType", sql.toString(), null);
        Object rsOrganization = null;
        SqlParams spOrganization = new SqlParams();
        sql.setLength(0);
        sql.append(" select distinct A.FID, A.FNumber, A.FName_" + loc + " FName,A.FParentID FParentID ").append("\n from T_BD_Bank A").append("\n where 1=1");
        if (this.relations == LimitIsBankCreditEnum.TRUE) {
            sql.append(" and A.FisBank = 1  ");
        } else if (this.relations == LimitIsBankCreditEnum.FALSE) {
            sql.append(" and A.FisBank = 0 ");
        }
        JournalBalanceUtil.appendFilter((String)"A.FID", (Set)organizationIdSet, (StringBuffer)sql, (SqlParams)spOrganization, (String)"or");
        ss.setDataItem("Organization", sql.toString(), spOrganization);
        SqlParams spCompany = new SqlParams();
        sql.setLength(0);
        sql.append(" select A.FID, A.FName_" + loc + " FName, A.FParentID from t_org_company  A \n where 1=1");
        JournalBalanceUtil.appendFilter((String)"A.FID", (Set)companyIdSet, (StringBuffer)sql, (SqlParams)spCompany, (String)"and");
        ss.setDataItem("Company", sql.toString(), spCompany);
        String tempTable = RptGrantCreditCollectFacadeControllerBean.getTempTableName((String)ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"43_RptGrantCreditCollectFacadeControllerBean", (Locale)ctx.getLocale()), (Context)ctx);
        StringBuffer baseSql = new StringBuffer();
        SqlParams baseSp = new SqlParams();
        baseSql.append("Select a.FID,a.FCreditInstitutionId,a.FRegion,a.FCurrencyID,a.FExchangeRate,a.FShareType,a.FCompanyID, ").append(" a.FLocalAmount/").append(amountUnit).append(" as FLocalSharedAmount, ").append(" a.FBalance*a.FExchangeRate/").append(amountUnit).append(" as FLocalBlance, ").append(" (a.FLocalAmount - a.FBalance*a.FExchangeRate)/").append(amountUnit).append(" as FLocalUsedAmount into ").append(tempTable).append("\n from T_FIN_CreditLimit a left outer join t_bd_bank b on a.FCreditInstitutionId = b.fid where 1=1 ");
        if (this.relations == LimitIsBankCreditEnum.TRUE) {
            baseSql.append(" and b.FisBank = 1  ");
        } else if (this.relations == LimitIsBankCreditEnum.FALSE) {
            baseSql.append(" and b.FisBank = 0 ");
        }
        if (organizationIdSet != null && organizationIdSet.size() > 0) {
            baseSql.append("\n and a.FCreditInstitutionId in(''");
            Iterator iter = organizationIdSet.iterator();
            while (iter.hasNext()) {
                baseSql.append(",?");
                baseSp.addString((String)iter.next());
            }
            baseSql.append(')');
        } else {
            baseSql.append("\n and a.FcreditCompanyID is null");
        }
        JournalBalanceUtil.appendFilter((String)"a.FCompanyID", (Set)companyIdSet, (StringBuffer)baseSql, (SqlParams)baseSp, (String)"and");
        baseSql.append("\n and a.FIssueDate<=? ");
        baseSp.addTimestamp(dtUpTo);
        boolean checkClosed = (Boolean)params.getObjectElement("checkClosed.value");
        if (checkClosed) {
            baseSql.append("\n and (FIsClosed=0 or FIsClosed=1) ");
        } else {
            baseSql.append("\n and FIsClosed=0 ");
        }
        baseSql.append("\n and a.FLimitType = 1 ");
        RptGrantCreditCollectFacadeControllerBean.executeSelectInto((String)baseSql.toString(), (SqlParams)baseSp, (Context)ctx);
        baseSql.setLength(0);
        Object rsFact = null;
        StringBuffer factSql = new StringBuffer();
        StringBuffer factGroup = new StringBuffer();
        SqlParams factsp = new SqlParams();
        if (forOrganization || forCurrency) {
            factSql.append("Select FCreditInstitutionId,FRegion,FCurrencyID,sum(FLocalSharedAmount) as FLocalSharedAmountTotal, ").append("\n\tsum(FLocalUsedAmount) as FLocalUsedAmountTotal,sum(FLocalBlance) as FLocalBlanceTotal from ").append(tempTable).append(" group by FCreditInstitutionId,FRegion,FCurrencyID ");
        } else {
            factSql.append(" Select FRegion,sum(FLocalSharedAmount) as FLocalSharedAmountTotal,sum(FLocalUsedAmount) as FLocalUsedAmountTotal, ").append(" sum(FLocalBlance) as FLocalBlanceTotal ").append(",FCompanyID from ").append(tempTable);
            factGroup.append("\n group by FRegion,FCompanyID ");
        }
        factSql.append(factGroup);
        ss.setDataItem("Fact", factSql.toString(), factsp);
        mdx.append(" ").append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"27_RptCreditLimitGSFacadeControllerBean", (Locale)ctx.getLocale()));
        StringBuffer selectColumns = new StringBuffer().append(" select {[Measures].members}").append(" ").append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"44_RptGrantCreditCollectFacadeControllerBean", (Locale)ctx.getLocale()));
        if (forCompany) {
            configFile = "RptGrantCreditCollect_company.xml";
            mdx.append(" ").append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"45_RptGrantCreditCollectFacadeControllerBean", (Locale)ctx.getLocale()));
            mdx.append(selectColumns);
            mdx.append(" ").append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"46_RptGrantCreditCollectFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        if (forOrganization) {
            configFile = "RptGrantCreditCollect_Organization.xml";
            mdx.append(" ").append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"49_RptGrantCreditCollectFacadeControllerBean", (Locale)ctx.getLocale()));
            mdx.append(selectColumns);
            mdx.append(" ").append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"50_RptGrantCreditCollectFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        if (forCurrency) {
            configFile = "RptGrantCreditCollect_Currency.xml";
            mdx.append(" ").append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"31_RptCreditLimitGSFacadeControllerBean", (Locale)ctx.getLocale()));
            mdx.append(selectColumns);
            mdx.append(" ").append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"32_RptCreditLimitGSFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        mdx.append(" from fm");
        ss.setCaller(RptGrantCreditCollectFacadeControllerBean.class);
        ss.setFilename(configFile);
        ss.setMdx(mdx.toString());
    }
}

