/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.fin.LoanBalanceDetailsQueryTypeEnum;
import com.kingdee.eas.fm.fin.RelationWithDebteeEnum;
import com.kingdee.eas.fm.fin.RptLoanBalanceDetailsParam;
import com.kingdee.eas.fm.fin.app.AbstractRptLoanBalanceDetailsControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class RptLoanBalanceDetailsControllerBean
extends AbstractRptLoanBalanceDetailsControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.RptLoanBalanceDetailsControllerBean");

    @Override
    protected IRowSet _getLoanBalanceDetails(Context ctx, FilterParam filerParam) throws BOSException {
        RptLoanBalanceDetailsParam param = (RptLoanBalanceDetailsParam)filerParam;
        ArrayList<Timestamp> paramList = new ArrayList<Timestamp>();
        String companyIds = this.companyIdArrayToIds(param);
        String currencyIds = this.currencyArrayToIds(param);
        Timestamp endDate = new Timestamp(param.getEndDate().getTime());
        IRowSet rowSet = null;
        StringBuffer sql = new StringBuffer();
        String lang = ctx.getLocale().getLanguage();
        sql.append("select");
        sql.append(" COMPANY.fname_").append(lang).append(" COMPANYName,TYPE.fname_").append(lang).append(" CREDITORGROUPName,t1.fnumber,CURRENCY.FName_").append(lang).append(" CURRENCYName,t1.FLocalCurExRate,t1.FAmount,t1.FAmountLocalCur,t1.Fid");
        sql.append(",INSTITUTION.fname_").append(lang).append(" INSTITUTIONName,GROP.fname_").append(lang).append(" GROUPName");
        sql.append(",GARANTEETYPE.fname_").append(lang).append(" GARANTEETYPEName");
        sql.append(",t1.FIsInCredit");
        sql.append(",(select sum(t3.FAmount) from T_FIN_Repayment t3 where t3.FbizDate<=? and t1.fid=t3.FLoanID)reAmount");
        sql.append(",(t1.fbalance + (select isnull(sum(t4.FAmount), 0) from T_FIN_Repayment t4 where t4.FbizDate>? and t1.fid=t4.FLoanID)) balance ");
        paramList.add(endDate);
        paramList.add(endDate);
        sql.append(",INTRATETYPE.fname_").append(lang).append(" INTRATETYPEName,t1.FIntRateTypeExpression,t1.FYieldRate,t1.FIssueDate,t1.FExpiredDate,t1.FRemark");
        sql.append(",t1.FLocalCurExRate");
        sql.append(" from T_FIN_Loan t1 ");
        sql.append(" left join T_BD_Currency CURRENCY on t1.FCurrencyID = CURRENCY.FID");
        sql.append(" left join T_ORG_Company COMPANY on t1.FCompanyID = COMPANY.FID");
        sql.append(" left join T_FIN_FinancingProducts TYPE on t1.FTypeID = TYPE.FID");
        sql.append(" left join T_INT_IntRateType INTRATETYPE on t1.FIntRateTypeID = INTRATETYPE.FID");
        sql.append(" left join T_BD_Bank INSTITUTION on t1.FInstitutionId = INSTITUTION.FID");
        sql.append(" left join T_ORG_Company GROP on t1.FGroupId = GROP.FID");
        sql.append(" left join T_FIN_GuaranteeType GARANTEETYPE on t1.FGaranteeTypeID = GARANTEETYPE.FID");
        sql.append(" where FCurrencyID in (" + currencyIds + ")");
        sql.append(" and(t1.FBalance<>0");
        sql.append(" or(t1.FBalance=0 and (select max(t2.FbizDate) from T_FIN_Repayment t2 where t1.fid=t2.FLoanID)>?))");
        paramList.add(endDate);
        sql.append(" and t1.FIssueDate<=?");
        paramList.add(endDate);
        sql.append(" and t1.FCompanyID in(" + companyIds + ")");
        if (RelationWithDebteeEnum.InGroup.equals((Object)param.getDebteeRelations())) {
            if (null != param.getDebteeOrg() && param.getDebteeOrg().length > 0) {
                sql.append(" and t1.FGroupId in(" + this.debteeArrayToIds(param, true) + ")");
            } else {
                sql.append(" and t1.FGroupId is not null");
            }
        } else if (RelationWithDebteeEnum.OutGroup.equals((Object)param.getDebteeRelations())) {
            if (null != param.getDebteeBankInfo() && param.getDebteeBankInfo().length > 0) {
                sql.append(" and t1.FInstitutionId in(" + this.debteeArrayToIds(param, false) + ")");
            } else {
                sql.append(" and t1.FInstitutionId is not null");
            }
        }
        sql.append(this.getGroupSql(param, ctx));
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
        return rowSet;
    }

    private String debteeArrayToIds(RptLoanBalanceDetailsParam param, boolean isOrg) {
        StringBuffer Ids = new StringBuffer();
        Object[] infos = null;
        infos = isOrg ? param.getDebteeOrg() : param.getDebteeBankInfo();
        for (int i = 0; i < infos.length; ++i) {
            Ids.append("'");
            Ids.append(infos[i].getId().toString());
            Ids.append("'");
            if (i >= infos.length - 1) continue;
            Ids.append(",");
        }
        return Ids.toString();
    }

    private String companyIdArrayToIds(RptLoanBalanceDetailsParam param) {
        StringBuffer companyIds = new StringBuffer();
        String[] ids = param.getCompanyIds();
        for (int i = 0; i < ids.length; ++i) {
            companyIds.append("'");
            companyIds.append(ids[i]);
            companyIds.append("'");
            if (i >= ids.length - 1) continue;
            companyIds.append(",");
        }
        return companyIds.toString();
    }

    private String currencyArrayToIds(RptLoanBalanceDetailsParam param) {
        StringBuffer currencyIds = new StringBuffer();
        CurrencyInfo[] currencyInfos = param.getCurrencys();
        for (int i = 0; i < currencyInfos.length; ++i) {
            currencyIds.append("'");
            currencyIds.append(currencyInfos[i].getId().toString());
            currencyIds.append("'");
            if (i >= currencyInfos.length - 1) continue;
            currencyIds.append(",");
        }
        return currencyIds.toString();
    }

    private String getGroupSql(RptLoanBalanceDetailsParam param, Context ctx) {
        String groupSql = "";
        String lang = ctx.getLocale().getLanguage();
        if (LoanBalanceDetailsQueryTypeEnum.CompanyDebtee.equals((Object)param.getQueryType())) {
            groupSql = " order by COMPANY.fname_" + lang + ",INSTITUTION.fname_" + lang + ",GROP.fname_" + lang;
        } else if (LoanBalanceDetailsQueryTypeEnum.DebteeCompany.equals((Object)param.getQueryType())) {
            groupSql = " order by INSTITUTION.fname_" + lang + ",GROP.fname_" + lang + ",COMPANY.fname_" + lang;
        } else if (LoanBalanceDetailsQueryTypeEnum.Debtee.equals((Object)param.getQueryType())) {
            groupSql = " order by INSTITUTION.fname_" + lang + ",GROP.fname_" + lang;
        } else if (LoanBalanceDetailsQueryTypeEnum.Currency.equals((Object)param.getQueryType())) {
            groupSql = " order by CURRENCY.FName_" + lang;
        } else if (LoanBalanceDetailsQueryTypeEnum.VouchType.equals((Object)param.getQueryType())) {
            groupSql = " order by GARANTEETYPE.fname_" + lang;
        } else if (LoanBalanceDetailsQueryTypeEnum.FinancingType.equals((Object)param.getQueryType())) {
            groupSql = " order by TYPE.fname_" + lang;
        } else if (LoanBalanceDetailsQueryTypeEnum.AmountRange.equals((Object)param.getQueryType())) {
            groupSql = " order by FIsInCredit";
        }
        return groupSql;
    }
}

