/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.util.JournalBalanceUtil;
import com.kingdee.eas.fm.fin.FinBaseDataException;
import com.kingdee.eas.fm.fin.app.AbstractRptLoanBalanceFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.bireport.util.BirtUtils;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptLoanBalanceFacadeControllerBean
extends AbstractRptLoanBalanceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.RptLoanBalanceFacadeControllerBean");

    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        SchemaSource ss = new SchemaSource();
        Timestamp dtTo = new Timestamp(((Date)params.getObjectElement("jdTo.value")).getTime());
        Timestamp dtTo1 = new Timestamp(dtTo.getTime());
        dtTo1.setHours(23);
        dtTo1.setMinutes(59);
        dtTo1.setSeconds(59);
        Timestamp dtTo2 = new Timestamp(dtTo.getTime());
        dtTo2.setHours(0);
        dtTo2.setMinutes(0);
        dtTo2.setSeconds(0);
        String amountUnit = String.valueOf(((AmountUnitEnum)params.getObjectElement("jtAmountUnit.value")).getValue());
        CurrencyInfo convertCurrency = (CurrencyInfo)params.getObjectElement("prmtConvertCurrency.value");
        Set bankIdSet = (Set)params.getObject("bankIdSet");
        Set inGroupIdSet = (Set)params.getObject("inGroupIdSet");
        Set companyIdSet = (Set)params.getObject("companyIdSet");
        String debteeState = (String)params.getObject("debteeState2");
        boolean forCompanyDebtee = (Boolean)params.getObjectElement("jrbCompanyDebtee.value");
        boolean forDebteeCompany = (Boolean)params.getObjectElement("jrbDebteeCompany.value");
        boolean forCompany = (Boolean)params.getObjectElement("jrbCompany.value");
        boolean forCurrency = (Boolean)params.getObjectElement("jrbCurrency.value");
        boolean forAmountRange = (Boolean)params.getObjectElement("jrbAmountRange.value");
        boolean forFinancingType = (Boolean)params.getObjectElement("jrbFinancingType.value");
        boolean forVouchType = (Boolean)params.getObjectElement("jrbVouchType.value");
        boolean forDebtee = (Boolean)params.getObjectElement("jrbDebtee.value");
        boolean forFinProduct = (Boolean)params.getObjectElement("jrbFinProduct.value");
        int level = (Integer)params.getObjectElement("kDSpinnerLevel.value");
        boolean isViewLongTime = (Boolean)params.getObjectElement("isViewLongTime.value");
        String loc = RptLoanBalanceFacadeControllerBean.getLoc((Context)ctx);
        StringBuffer sql = new StringBuffer();
        SqlParams sp = new SqlParams();
        StringBuffer mdx = new StringBuffer();
        String temptable = this.buildFactTempTable(ctx);
        if (convertCurrency != null) {
            StringBuffer currencySql = new StringBuffer();
            StringBuffer sqls = new StringBuffer();
            HashSet<String> currencyIdSet = new HashSet<String>();
            currencySql.append("Select distinct FCurrencyId From T_Fin_Loan where FIssueDate<=? and FBalance>0 ");
            if (bankIdSet != null && bankIdSet.size() > 0) {
                currencySql.append("\n and ((FInstitutionId in(");
                currencySql.append(BirtUtils.idListToInClause((Collection)bankIdSet)).append(")").append(")");
                if (inGroupIdSet != null && inGroupIdSet.size() > 0) {
                    currencySql.append(" or ").append("(FGroupId is not null)");
                }
                currencySql.append(")");
            } else if (inGroupIdSet == null || inGroupIdSet.size() <= 0) {
                currencySql.append("\n and FIsGroupLoan = 0  ");
            }
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)currencySql.toString(), (Object[])new Object[]{dtTo1});
                while (rs.next()) {
                    currencyIdSet.add(rs.getString("FCurrencyId"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            Iterator it = currencyIdSet.iterator();
            CompanyOrgUnitInfo company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            while (it.hasNext()) {
                String currencyId = (String)it.next();
                BigDecimal rate = null;
                if (currencyId.equals(convertCurrency.getId().toString())) {
                    rate = Constants.ONE;
                } else {
                    CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                    ExchangeRateInfo rateInfo = FMHelper.getExRateInfo((Context)ctx, (CurrencyInfo)currency, (CurrencyInfo)convertCurrency, (CompanyOrgUnitInfo)company, (Date)dtTo1);
                    if (EmptyUtil.isEmpty((CoreBaseInfo)rateInfo)) {
                        throw new FinBaseDataException(FinBaseDataException.EXCEPTIONEXHANGERATE, new Object[]{currency.getName(), convertCurrency.getName()});
                    }
                    rate = ConvertModeEnum.INDIRECTEXCHANGERATE.equals((Object)rateInfo.getConvertMode()) ? Constants.ONE.divide(rateInfo.getConvertRate(), 10, 4) : rateInfo.getConvertRate();
                }
                sqls = sqls.append("insert into " + temptable + " values('" + currencyId + "', " + rate + ")").append(";");
            }
            if (sqls.length() > 0) {
                this.executeBatchUpdate(ctx, sqls.toString().split(";"));
            }
        }
        if (!isViewLongTime) {
            sql.append("select 1 as fid, '").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"duanqijiekuan", (Locale)ctx.getLocale())).append("' as fname,1 as forder union all select 2 as fid, '").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"zhong", (Locale)ctx.getLocale())).append("(").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"chang", (Locale)ctx.getLocale())).append(")").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"qijiekuan", (Locale)ctx.getLocale())).append("' as fname,2 as forder ");
            ss.setDataItem("PeriodRType", sql.toString(), null);
        }
        sql.setLength(0);
        String fileSuffix = null;
        String field = null;
        String companyId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        int mnt001 = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("MNT001", (IObjectPK)new ObjectUuidPK(companyId));
        String expansion = "";
        if (mnt001 == 0) {
            expansion = ".levels(0)";
        }
        if (forCompanyDebtee || forDebteeCompany) {
            String newFactSql;
            SqlParams sp1;
            StringBuffer caseString = new StringBuffer();
            StringBuffer inCaseSting = new StringBuffer();
            try {
                if (debteeState.equals("1") || debteeState.equals("2") && (bankIdSet == null || bankIdSet.size() == 0)) {
                    IRowSet idListRs = null;
                    String sqlLevelRep = "select fid,flongnumber from t_bd_bank where (flevel<=" + level + " and fisLeaf=1) or (flevel=" + level + " and fisleaf=0)";
                    ArrayList<String> idList = new ArrayList<String>();
                    ArrayList<String> numberList = new ArrayList<String>();
                    idListRs = DbUtil.executeQuery((Context)ctx, (String)sqlLevelRep);
                    while (idListRs.next()) {
                        idList.add(idListRs.getString(1));
                        numberList.add(idListRs.getString(2));
                    }
                    if (idList.size() > 0) {
                        ArrayList<String> caseList = new ArrayList<String>();
                        IRowSet idRs = null;
                        String id = null;
                        String number = null;
                        String sqlBanksRep = null;
                        caseString.append(" case ");
                        int m = idList.size();
                        for (int i = 0; i < m; ++i) {
                            caseList.clear();
                            id = (String)idList.get(i);
                            number = (String)numberList.get(i);
                            sqlBanksRep = "select distinct b.fid from t_fin_loan as a inner join t_bd_bank as b on a.FInstitutionID = b.fid   where b.flongnumber like '" + number + "!%' or b.flongnumber = '" + number + "' and a.fbalance > 0";
                            idRs = DbUtil.executeQuery((Context)ctx, (String)sqlBanksRep);
                            while (idRs.next()) {
                                caseList.add(idRs.getString(1));
                            }
                            if (caseList.size() <= 0) continue;
                            inCaseSting.append(" when ");
                            int n = caseList.size();
                            for (int j = 0; j < n; ++j) {
                                inCaseSting.append(" FInstitutionID = '").append((String)caseList.get(j)).append("'");
                                if (j == n - 1) {
                                    inCaseSting.append(" then '").append(id).append("' ");
                                    continue;
                                }
                                inCaseSting.append(" or ");
                            }
                        }
                        caseString.append(inCaseSting);
                        if (debteeState.equals("2")) {
                            caseString.append(" end  FBanksID ");
                        } else {
                            caseString.append(" when FInstitutionID is null then '1111' end  FBanksID ");
                        }
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (forCompanyDebtee) {
                field = "FCompanyID";
                sql.setLength(0);
                sql.append(" select A.FID, A.FName_" + loc + " FName, A.FParentID from t_org_company  A \n where 1=1");
                JournalBalanceUtil.appendFilter((String)"A.FID", (Set)companyIdSet, (StringBuffer)sql, (SqlParams)sp, (String)"and");
                ss.setDataItem("Company", sql.toString(), sp);
                if (debteeState.equals("3")) {
                    sql.setLength(0);
                    sql.append("select A.FGroupID as FID,B.FNAME_").append(loc).append(" as FName from (select distinct FGroupID from t_fin_loan where FGroupID is not null) A ").append("inner join t_org_company B on A.FGroupID = B.FID");
                } else {
                    sql.setLength(0);
                    sql.append(" select A.FID, A.FName_" + loc + " FName from T_BD_Bank A").append("\n union all select '1111' as FID,N'").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"jituanneijiekuan", (Locale)ctx.getLocale())).append("' as FName ");
                }
                ss.setDataItem("Bank", sql.toString(), null);
                if (debteeState.equals("1")) {
                    if (inCaseSting.length() <= 0) {
                        caseString.setLength(0);
                        caseString.append(" case when FInstitutionID is null then '1111' else 'xxxxxxxx' end FBanksID ");
                    }
                    sql.setLength(0);
                    sp1 = new SqlParams();
                    sql.append("select * from (select * from (");
                    sql.append(this.getActualTable(params, sp1, temptable, caseString.toString(), 1));
                    sql.append("\n ) as bb where FBanksID is not null ) as xx where FBanksID not in ('xxxxxxxx')");
                    newFactSql = RptLoanBalanceFacadeControllerBean.getTempTableSql(ctx, sql.toString(), sp1, "rptloanbalanceFact");
                    ss.setDataItem("Fact", newFactSql.toString(), sp1);
                } else if (debteeState.equals("2")) {
                    if (bankIdSet != null && bankIdSet.size() > 0) {
                        sql.setLength(0);
                        sp1 = new SqlParams();
                        sql.append(this.getActualTable(params, sp1, temptable, null, 2));
                        newFactSql = RptLoanBalanceFacadeControllerBean.getTempTableSql(ctx, sql.toString(), sp1, "rptloanbalanceFact");
                        ss.setDataItem("Fact", newFactSql.toString(), sp1);
                    } else {
                        if (inCaseSting.length() <= 0) {
                            caseString.setLength(0);
                            caseString.append(" 'xxxxxxxx' FBanksID ");
                        }
                        sql.setLength(0);
                        sp1 = new SqlParams();
                        sql.append("select * from (select * from (");
                        sql.append(this.getActualTable(params, sp1, temptable, caseString.toString(), 3));
                        sql.append(") as bb where FBanksID is not null) as xx where FBanksID not in ('xxxxxxxx')");
                        newFactSql = RptLoanBalanceFacadeControllerBean.getTempTableSql(ctx, sql.toString(), sp1, "rptloanbalanceFact");
                        ss.setDataItem("Fact", newFactSql.toString(), sp1);
                    }
                } else if (debteeState.equals("3")) {
                    sql.setLength(0);
                    sp1 = new SqlParams();
                    sql.append("select * from (");
                    sql.append(this.getActualTable(params, sp1, temptable, null, 4));
                    sql.append(") as bb where FBanksID is not null ");
                    newFactSql = RptLoanBalanceFacadeControllerBean.getTempTableSql(ctx, sql.toString(), sp1, "rptloanbalanceFact");
                    ss.setDataItem("Fact", newFactSql.toString(), sp1);
                }
                if (isViewLongTime) {
                    fileSuffix = "companyDebteeNoLongTime";
                    mdx.append("\n with member [Company].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([Company].levels(0).members)' ,caption='").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("',formatString= '#,##0.00'").append("\n member [Bank].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([Bank].members)' ,caption='").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("',formatString= '#,##0.00'").append(" select {[Measures].members} on columns,  non empty {{[Company].levels(0).members}*{[Bank].members,[Bank].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]},{[Company].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]}*{[Bank].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]}} on rows from fm ");
                } else {
                    fileSuffix = "companyDebtee";
                    mdx.append("\n with member [PeriodRType].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([PeriodRType].members)',caption='").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("',formatString= '#,##0.00' ").append("\n member [Company].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([Company].levels(0).members)' ,caption='").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("',formatString= '#,##0.00'").append("\n member [Bank].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([Bank].members)' ,caption='").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("',formatString= '#,##0.00'").append(" select {[Measures].members} on columns, FactMembersWithPCD(PeriodRType,Company,Bank) on rows from fm ");
                }
            } else {
                if (debteeState.equals("3")) {
                    sql.append("select A.FGroupID as FID,B.FNAME_").append(loc).append(" as FName,B.FParentID as FParentID from (select distinct FGroupID from t_fin_loan where FGroupID is not null) A ").append("inner join t_org_company B on A.FGroupID = B.FID");
                } else {
                    sql.append(" select A.FID, A.FName_" + loc + " FName,A.FParentID FParentID from T_BD_Bank A").append("\n union all select '1111' as FID,N'").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"jituanneijiekuan", (Locale)ctx.getLocale())).append("' as FName,'1111' FParentID");
                }
                ss.setDataItem("Bank", sql.toString(), null);
                sql.setLength(0);
                sql.append(" select A.FID, A.FName_" + loc + " FName from t_org_company  A \n where 1=1");
                JournalBalanceUtil.appendFilter((String)"A.FID", (Set)companyIdSet, (StringBuffer)sql, (SqlParams)sp, (String)"and");
                ss.setDataItem("Company", sql.toString(), sp);
                sql.setLength(0);
                sp1 = new SqlParams();
                sql.append(this.getActualTable(params, sp1, temptable, null, 5));
                newFactSql = RptLoanBalanceFacadeControllerBean.getTempTableSql(ctx, sql.toString(), sp1, "rptloanbalanceFact");
                ss.setDataItem("Fact", newFactSql.toString(), sp1);
                if (isViewLongTime) {
                    fileSuffix = "debteeCompanyNoLongTime";
                    mdx.append("\n with member [Company].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([Company].levels(0).members)' ,caption='").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("',formatString= '#,##0.00'").append("\n member [Bank].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([Bank].levels(0).members)' ,caption='").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("',formatString= '#,##0.00'").append(" select {[Measures].members} on columns, non empty {{[Bank].members}*{[Company].members,[Company].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]},{[Bank].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]}*{[Company].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]}} on rows from fm ");
                } else {
                    fileSuffix = "debteeCompany";
                    mdx.append("\n with member [PeriodRType].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([PeriodRType].members)' ").append("\n member [Company].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([Company].members)' ").append("\n member [Bank].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([Bank].levels(0).members)' ").append(" select {[Measures].members} on columns, FactMembersWithPCD(PeriodRType,Bank,Company) on rows from fm ");
                }
            }
        } else {
            if (forCompany) {
                fileSuffix = "company";
                field = "FCompanyID";
                sql.append(" select A.FID, A.FName_" + loc + " FName, A.FParentID from t_org_company  A \n where 1=1");
                JournalBalanceUtil.appendFilter((String)"A.FID", (Set)companyIdSet, (StringBuffer)sql, (SqlParams)sp, (String)"and");
            } else if (forCurrency) {
                fileSuffix = "currency";
                field = "FCurrencyID";
                sql.append(" select A.FID, A.FName_" + loc + " FName from t_bd_currency A");
            } else if (forAmountRange) {
                fileSuffix = "amountRange";
                field = "FIsInCredit";
                sql.append("select 1 as fid, '").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"edunei", (Locale)ctx.getLocale())).append("' as fname  union all").append("\nselect 0 as fid, '").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"eduwai", (Locale)ctx.getLocale())).append("' as fname ");
            } else if (forFinancingType) {
                fileSuffix = "creditor";
                field = "FCreditorGroupID";
                sql.append(" select A.FID, A.FName_" + loc + " FName from T_FIN_CreditorGroup A");
            } else if (forVouchType) {
                fileSuffix = "garanteeType";
                field = "ISNULL(FGaranteeTypeID,'XXXXXX')";
                sql.append(" select A.FID, A.FName_" + loc + " FName from T_FIN_GuaranteeType A union select 'XXXXXX' as FID, N' ' as FName from T_FIN_GuaranteeType A");
            } else if (forDebtee) {
                fileSuffix = "debtee";
                field = "FInstitutionID";
                if (!debteeState.equals("3")) {
                    sql.append(" select A.FID, A.FName_" + loc + " FName,A.FParentID FParentID from T_BD_Bank A").append("\n union all select '1111' as FID,N'").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"jituanneijiekuan", (Locale)ctx.getLocale())).append("' as FName,'1111' FParentID");
                } else {
                    sql.append("select A.FGroupID as FID,B.FNAME_").append(loc).append(" as FName,B.FParentID as FParentID from (select distinct FGroupID from t_fin_loan where FGroupID is not null) A ").append("inner join t_org_company B on A.FGroupID = B.FID");
                }
            } else if (forFinProduct) {
                fileSuffix = "finProduct";
                field = "FTypeID";
                sql.append(" select A.FID, A.FName_" + loc + " FName, A.FParentID from T_FIN_FinancingProducts A");
            }
            if (isViewLongTime) {
                fileSuffix = fileSuffix + "NoLongTime";
            }
            ss.setDataItem("DyTable", sql.toString(), sp);
            sql.setLength(0);
            SqlParams sp1 = new SqlParams();
            if (convertCurrency != null) {
                sql.append("select FDyKey, FPeriodRangeType, ");
                sql.append("sum(FIn)*FRate/").append(amountUnit).append(" FIn,");
                sql.append("sum(FOut)*FRate/").append(amountUnit).append(" FOut,");
                sql.append("sum(FHKTW)*FRate/").append(amountUnit).append(" FHKTW,");
                sql.append("sum(FSum)*FRate/").append(amountUnit).append(" FSum");
                sql.append("\n from(\n select ");
            } else {
                sql.append("select FDyKey, FPeriodRangeType, ");
                sql.append("sum(FIn)*FLocalCurExRate/").append(amountUnit).append(" FIn,");
                sql.append("sum(FOut)*FLocalCurExRate/").append(amountUnit).append(" FOut,");
                sql.append("sum(FHKTW)*FLocalCurExRate/").append(amountUnit).append(" FHKTW,");
                sql.append("sum(FSum)*FLocalCurExRate/").append(amountUnit).append(" FSum");
                sql.append("\n from(\n select ");
            }
            if (forDebtee) {
                if (debteeState != null) {
                    if (debteeState.equals("1")) {
                        sql.append(" case when FInstitutionID is null then '1111' else FInstitutionID end ");
                    } else if (debteeState.equals("2")) {
                        sql.append(" FInstitutionID ");
                    } else if (debteeState.equals("3")) {
                        sql.append(" FGroupID ");
                    }
                }
            } else {
                sql.append(field);
            }
            sql.append(" FDyKey, ").append(convertCurrency == null ? "A.FLocalCurExRate" : "FRate").append(",");
            sql.append(" case when FHorizon > 12 then 2 else 1 end FPeriodRangeType,");
            sql.append(" case when A.FRegion=? then (A.FBalance + (select isnull(sum(B.FAmount), 0) from T_FIN_Repayment B where B.FbizDate>? and A.fid=B.FLoanID)) else 0 end FIn,");
            sql.append(" case when A.FRegion=? then (A.FBalance + (select isnull(sum(B.FAmount), 0) from T_FIN_Repayment B where B.FbizDate>? and A.fid=B.FLoanID)) else 0 end FOut,");
            sql.append(" case when A.FRegion=? then (A.FBalance + (select isnull(sum(B.FAmount), 0) from T_FIN_Repayment B where B.FbizDate>? and A.fid=B.FLoanID)) else 0 end FHKTW,");
            sql.append(" (A.FBalance + (select isnull(sum(B.FAmount), 0) from T_FIN_Repayment B where B.FbizDate>? and A.fid=B.FLoanID)) FSum ");
            sql.append("\n from T_FIN_Loan A");
            if (convertCurrency != null) {
                sql.append("\n left join " + temptable + " on " + temptable + ".FRateCurrencyId = A.FCurrencyId ");
            }
            sql.append("\n where (A.FIssueDate <= ? )");
            sp1.addInt(1).addTimestamp(dtTo1).addInt(2).addTimestamp(dtTo1).addInt(3).addTimestamp(dtTo1).addTimestamp(dtTo1).addTimestamp(dtTo1);
            JournalBalanceUtil.appendFilter((String)"A.FCompanyID", (Set)companyIdSet, (StringBuffer)sql, (SqlParams)sp1, (String)"and");
            if (debteeState.equals("1")) {
                sql.append(" and (A.FInstitutionID is not null or A.FGroupID is not null)");
            } else if (debteeState.equals("2")) {
                if (bankIdSet != null && bankIdSet.size() >= 1) {
                    JournalBalanceUtil.appendFilter((String)"A.FInstitutionID", (Set)bankIdSet, (StringBuffer)sql, (SqlParams)sp1, (String)"and");
                }
                sql.append(" and A.FInstitutionID is not null ");
            } else if (debteeState.equals("3")) {
                if (inGroupIdSet != null && inGroupIdSet.size() >= 1) {
                    JournalBalanceUtil.appendFilter((String)"A.FGroupID", (Set)inGroupIdSet, (StringBuffer)sql, (SqlParams)sp1, (String)"and");
                }
                sql.append(" and A.FGroupID is not null ");
            }
            sql.append("\n) TEMP group by FPeriodRangeType, ").append(convertCurrency == null ? "FLocalCurExRate" : "FRate").append(", FDyKey");
            String newFactSql = RptLoanBalanceFacadeControllerBean.getTempTableSql(ctx, sql.toString(), sp1, "rptloanbalanceFact");
            ss.setDataItem("Fact", newFactSql.toString(), sp1);
            if (!forDebtee) {
                if (isViewLongTime) {
                    mdx.append("with member [DyTable].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([DyTable].levels(0).members)' ").append("\n select {[Measures].members} on columns, ").append("\n non empty {{[DyTable]" + expansion + ".members},{[DyTable].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]}} ").append(" on rows  from fm");
                } else {
                    mdx.append("with member [DyTable].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([DyTable].levels(0).members)' ").append("\n member [PeriodRType].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([PeriodRType].members)' ").append("\n select {[Measures].members} on columns, ").append("\n non empty union({[PeriodRType].members}*{[DyTable]" + expansion + ".members,{[DyTable].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]}},").append("{[PeriodRType].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]}*{[DyTable].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]}) on rows  from fm");
                }
            } else if (isViewLongTime) {
                mdx.append("with member [DyTable].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([DyTable].levels(0).members)' ").append("\n select {[Measures].members} on columns, ").append("\n non empty {{[DyTable]" + expansion + ".members},{[DyTable].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]}} ").append(" on rows  from fm");
            } else {
                mdx.append("with member [DyTable].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([DyTable].levels(0).members)' ").append("\n member [PeriodRType].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("] as 'sum([PeriodRType].members)' ").append("\n select {[Measures].members} on columns, ").append("\n non empty union({[PeriodRType].members}*{[DyTable]" + expansion + ".members,{[DyTable].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]}},").append("{[PeriodRType].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]}*{[DyTable].[").append(ResourceBase.getString((String)"com.kingdee.eas.fm.common.FMRptCommonResource", (String)"heji", (Locale)ctx.getLocale())).append("]}) on rows  from fm");
            }
        }
        ss.setCaller(RptLoanBalanceFacadeControllerBean.class);
        ss.setFilename("RptLoanBalance_" + fileSuffix + ".xml");
        ss.setMdx(mdx.toString());
        return ss;
    }

    private String getActualTable(RptParams params, SqlParams sp, String temptable, String caseString, int seq) {
        String amountUnit = String.valueOf(((AmountUnitEnum)params.getObjectElement("jtAmountUnit.value")).getValue());
        CurrencyInfo convertCurrency = (CurrencyInfo)params.getObjectElement("prmtConvertCurrency.value");
        String debteeState = (String)params.getObject("debteeState2");
        StringBuffer sql = new StringBuffer();
        String FBanksID = null;
        if (seq == 1 || seq == 3) {
            FBanksID = caseString;
        } else if (seq == 2) {
            FBanksID = "A.FInstitutionID FBanksID";
        } else if (seq == 4) {
            FBanksID = "A.FGroupID FBanksID";
        } else if (seq == 5 && debteeState != null) {
            if (debteeState.equals("1")) {
                FBanksID = " case when FInstitutionID is null then '1111' else FInstitutionID end FBanksID";
            } else if (debteeState.equals("2")) {
                FBanksID = " FInstitutionID FBanksID";
            } else if (debteeState.equals("3")) {
                FBanksID = " FGroupID FBanksID";
            }
        }
        if (convertCurrency != null) {
            sql.append("select FCompanyID, FBanksID, FPeriodRangeType, ");
            sql.append("sum(FIn)*FRate/").append(amountUnit).append(" FIn,");
            sql.append("sum(FOut)*FRate/").append(amountUnit).append(" FOut,");
            sql.append("sum(FHKTW)*FRate/").append(amountUnit).append(" FHKTW,");
            sql.append("sum(FSum)*FRate/").append(amountUnit).append(" FSum");
            sql.append("\n from(\n select A.FCompanyID,").append(FBanksID).append(", FRate, ");
            sql.append("case when FHorizon > 12 then 2 else 1 end FPeriodRangeType, ");
        } else {
            sql.append("select FCompanyID,FBanksID, FPeriodRangeType, ");
            sql.append("sum(FIn)*FLocalCurExRate/").append(amountUnit).append(" FIn,");
            sql.append("sum(FOut)*FLocalCurExRate/").append(amountUnit).append(" FOut,");
            sql.append("sum(FHKTW)*FLocalCurExRate/").append(amountUnit).append(" FHKTW,");
            sql.append("sum(FSum)*FLocalCurExRate/").append(amountUnit).append(" FSum");
            sql.append("\n from(\n select A.FCompanyID, ").append(FBanksID).append(", A.FLocalCurExRate, ");
            sql.append("case when FHorizon > 12 then 2 else 1 end FPeriodRangeType, ");
        }
        sql.append("case when A.FRegion=? then (A.FBalance + (select isnull(sum(B.FAmount), 0) from T_FIN_Repayment B where B.FbizDate>? and A.fid=B.FLoanID)) else 0 end FIn,");
        sql.append("case when A.FRegion=? then (A.FBalance + (select isnull(sum(B.FAmount), 0) from T_FIN_Repayment B where B.FbizDate>? and A.fid=B.FLoanID)) else 0 end FOut,");
        sql.append("case when A.FRegion=? then (A.FBalance + (select isnull(sum(B.FAmount), 0) from T_FIN_Repayment B where B.FbizDate>? and A.fid=B.FLoanID)) else 0 end FHKTW,");
        sql.append(" (A.FBalance + (select isnull(sum(B.FAmount), 0) from T_FIN_Repayment B where B.FbizDate>? and A.fid=B.FLoanID)) FSum ");
        sql.append("from t_fin_loan A ");
        if (convertCurrency != null) {
            sql.append("\n left join " + temptable + " on " + temptable + ".FRateCurrencyId = A.FCurrencyId ");
        }
        sql.append(this.getActualTableWhere(params, sp, seq));
        return sql.toString();
    }

    private String getActualTableWhere(RptParams params, SqlParams sp, int seq) {
        StringBuffer sqlWhere = new StringBuffer();
        Timestamp dtTo = new Timestamp(((Date)params.getObjectElement("jdTo.value")).getTime());
        Timestamp dtTo1 = new Timestamp(dtTo.getTime());
        dtTo1.setHours(23);
        dtTo1.setMinutes(59);
        dtTo1.setSeconds(59);
        CurrencyInfo convertCurrency = (CurrencyInfo)params.getObjectElement("prmtConvertCurrency.value");
        Set bankIdSet = (Set)params.getObject("bankIdSet");
        Set inGroupIdSet = (Set)params.getObject("inGroupIdSet");
        Set companyIdSet = (Set)params.getObject("companyIdSet");
        String debteeState = (String)params.getObject("debteeState2");
        sqlWhere.append("\n where (A.FIssueDate <= ? )");
        sp.addInt(1).addTimestamp(dtTo1).addInt(2).addTimestamp(dtTo1).addInt(3).addTimestamp(dtTo1).addTimestamp(dtTo1).addTimestamp(dtTo1);
        String companyFilter = JournalBalanceUtil.getFilter((String)"A.FCompanyID", (Set)companyIdSet, (SqlParams)sp, (String)"and");
        String institutionFilter = JournalBalanceUtil.getFilter((String)"A.FInstitutionID", (Set)bankIdSet, (SqlParams)sp, (String)"and");
        String groupFilter = JournalBalanceUtil.getFilter((String)"A.FGroupID", (Set)inGroupIdSet, (SqlParams)sp, (String)"and");
        if (companyFilter != null) {
            sqlWhere.append(companyFilter);
        }
        if (seq == 2) {
            if (institutionFilter != null) {
                sqlWhere.append(institutionFilter);
            }
        } else if (seq == 4) {
            if (groupFilter != null) {
                sqlWhere.append(groupFilter);
            }
        } else if (seq == 5) {
            if (debteeState.equals("2")) {
                if (institutionFilter != null) {
                    sqlWhere.append(institutionFilter);
                }
                sqlWhere.append(" and A.FInstitutionID is not null ");
            } else if (debteeState.equals("3")) {
                if (groupFilter != null) {
                    sqlWhere.append(groupFilter);
                }
                sqlWhere.append(" and A.FGroupID is not null ");
            }
        }
        sqlWhere.append("\n) TEMP group by FPeriodRangeType, ");
        sqlWhere.append(convertCurrency == null ? "FLocalCurExRate" : "FRate").append(", FBanksID ,FCompanyID ");
        return sqlWhere.toString();
    }

    private String buildFactTempTable(Context ctx) throws BOSException {
        String sSQL = "if not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_TABNAME='T_Temp_RptLoanStruanalyse') Create Table T_Temp_RptLoanStruanalyse (FRateCurrencyId Varchar(44), FRate NUMERIC(17,8) DEFAULT 0);";
        DbUtil.execute((Context)ctx, (String)sSQL);
        sSQL = "Delete From T_Temp_RptLoanStruanalyse";
        DbUtil.execute((Context)ctx, (String)sSQL);
        return "T_Temp_RptLoanStruanalyse";
    }

    protected int[] executeBatchUpdate(Context ctx, String[] sqls) throws BOSException {
        int[] i2;
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection(ctx);
            ps = con.createStatement();
            int n = sqls.length;
            for (int i2 = 0; i2 < n; ++i2) {
                ps.addBatch(sqls[i2]);
            }
            i2 = ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                if (ps != null) {
                    e.setNextException(new SQLException("Execute batch update: " + ps));
                }
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
        return i2;
    }

    private static String getTempTableSql(Context ctx, String sql, SqlParams sp, String tempTableName) throws BOSException {
        String tempBankTablefact = RptLoanBalanceFacadeControllerBean.getTempTableName((String)tempTableName, (Context)ctx);
        StringBuffer baseSqlfact = new StringBuffer();
        baseSqlfact.append("Select * into ").append(tempBankTablefact).append(" from ( ").append(sql).append(" ) as tt");
        RptLoanBalanceFacadeControllerBean.executeSelectInto((String)baseSqlfact.toString(), (SqlParams)sp, (Context)ctx);
        String newSql = "select * from " + tempBankTablefact;
        return newSql;
    }
}

