/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperSrv;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.app.IRptDimensionHandler;
import com.kingdee.eas.fm.fin.CycleTypeEnum;
import com.kingdee.eas.fm.fin.FinBaseDataException;
import com.kingdee.eas.fm.fin.LoanPropertyEnum;
import com.kingdee.eas.fm.fin.app.RptRepaymentSumFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.bireport.app.BireportBaseFacadeControllerBean;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public abstract class RptRepaymentSumBaseHandler
implements IRptDimensionHandler {
    protected Set companyIds;
    protected Set loanerIds;
    protected Set projectIds;
    protected Set financingProductIds;
    protected LoanPropertyEnum loanProperty;
    protected Date currentDate;
    protected CycleTypeEnum timeType;
    protected int time;
    protected int forcastType;
    protected AmountUnitEnum unit;
    protected Set rateCurrencyIdSet;
    protected String temptable = "";
    private boolean forcastByLoaner;
    private boolean isCreateTemp4Bank = false;
    private boolean isContainBond;
    protected String loc;
    private int[] ids;
    private String[] names;
    private Date[] edgeDates;

    public SchemaSource getSchemaSource(Context ctx, RptParams param) throws BOSException, EASBizException {
        this.prepareForQuery(ctx, param);
        SchemaSource ss = new SchemaSource();
        ss.setDataItem("Fact", this.getFactSql(ctx), null);
        String[] name = this.getDimensionNames();
        String[] sqls = this.getDimensionSqls(ctx);
        for (int i = 0; i < name.length; ++i) {
            ss.setDataItem(name[i], sqls[i], null);
        }
        ss.setMdx(this.getMDX(ctx, param));
        ss.setFilename(this.getConfigXML());
        ss.setCaller(RptRepaymentSumFacadeControllerBean.class);
        return ss;
    }

    private void prepareForQuery(Context ctx, RptParams param) throws EASBizException, BOSException {
        this.loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        this.companyIds = (Set)param.getObject("companyIdSet");
        this.isContainBond = param.getBoolean("isContainBond");
        if (!this.isContainBond) {
            this.loanProperty = (LoanPropertyEnum)((Object)param.getObject("loanProperty"));
            this.loanerIds = (Set)param.getObject("loaner");
        }
        this.projectIds = (Set)param.getObject("project");
        this.financingProductIds = (Set)param.getObject("financingProduct");
        this.currentDate = (Date)param.getObject("currentDate");
        this.timeType = (CycleTypeEnum)((Object)param.getObject("timeType"));
        this.time = param.getInt("time");
        this.forcastType = param.getInt("forcastType");
        this.unit = (AmountUnitEnum)param.getObject("unit");
        this.forcastByLoaner = param.getBoolean("forcastByLoaner");
        this.rateCurrencyIdSet = (Set)param.getObject("RateCurrencySet");
        Timestamp dateTime = new Timestamp(DateTimeUtils.truncateDate((Date)this.currentDate).getTime());
        this.edgeDates = new Date[this.time + 1];
        this.names = new String[this.time];
        this.ids = new int[this.time];
        if (this.timeType == CycleTypeEnum.MONTH) {
            this.edgeDates[0] = DateUtil.getFirstDayOfMonth((Date)this.currentDate);
        } else if (this.timeType == CycleTypeEnum.QUARTER) {
            this.edgeDates[0] = DateUtil.getFirstDayOfMonth((Date)DateUtil.getFirstSeasonDate((Date)this.currentDate));
        } else if (this.timeType == CycleTypeEnum.YEAR) {
            this.edgeDates[0] = DateUtil.getFirstYearDate((Date)this.currentDate);
        } else if (this.timeType == CycleTypeEnum.WEEK) {
            this.edgeDates[0] = DateUtil.getFirstDayOfWeek((Date)this.currentDate);
        }
        boolean forEn = this.loc.equals("l1");
        SimpleDateFormat df = new SimpleDateFormat("MMM d, yyyy");
        for (int i = 1; i <= this.time; ++i) {
            String formatDate = FMConstants.FORMAT_DAY.format(this.edgeDates[i - 1]);
            if (this.timeType == CycleTypeEnum.MONTH) {
                this.edgeDates[i] = DateTimeUtils.addMonth((Date)this.edgeDates[i - 1], (int)1);
                this.ids[i - 1] = DateTimeUtils.getYear((Date)this.edgeDates[i - 1]) * 100 + DateTimeUtils.getMonth((Date)this.edgeDates[i - 1]);
                if (forEn) {
                    this.names[i - 1] = formatDate.substring(0, 7);
                    continue;
                }
                this.names[i - 1] = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"format_pattern1", (Locale)ctx.getLocale()), formatDate.substring(0, 4), formatDate.substring(5, 7));
                continue;
            }
            if (this.timeType == CycleTypeEnum.QUARTER) {
                this.edgeDates[i] = DateTimeUtils.addMonth((Date)this.edgeDates[i - 1], (int)3);
                this.ids[i - 1] = DateTimeUtils.getYear((Date)this.edgeDates[i - 1]) * 100 + DateTimeUtils.getQuarter((Date)this.edgeDates[i - 1]);
                this.names[i - 1] = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"QuarterResource", (Locale)ctx.getLocale()), DateTimeUtils.getYear((Date)this.edgeDates[i - 1]) + "", DateUtil.getSeason((int)this.edgeDates[i - 1].getMonth()) + "");
                continue;
            }
            if (this.timeType == CycleTypeEnum.YEAR) {
                this.edgeDates[i] = DateTimeUtils.addYear((Date)this.edgeDates[i - 1], (int)1);
                this.ids[i - 1] = DateTimeUtils.getYear((Date)this.edgeDates[i - 1]) * 100;
                if (forEn) {
                    this.names[i - 1] = formatDate.substring(0, 4);
                    continue;
                }
                this.names[i - 1] = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"format_pattern2", (Locale)ctx.getLocale()), formatDate.substring(0, 4));
                continue;
            }
            if (this.timeType != CycleTypeEnum.WEEK) continue;
            this.edgeDates[i] = DateTimeUtils.addDay((Date)this.edgeDates[i - 1], (long)6L);
            String formatDate_ = FMConstants.FORMAT_DAY.format(this.edgeDates[i]);
            String fromStr = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"format_pattern3", (Locale)ctx.getLocale()), formatDate.substring(0, 4), formatDate.substring(5, 7), formatDate.substring(8, 10));
            String toStr = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"format_pattern3", (Locale)ctx.getLocale()), formatDate_.substring(0, 4), formatDate_.substring(5, 7), formatDate_.substring(8, 10));
            String msgStr = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"529_RptRepaymentDetailHandlerBase", (Locale)ctx.getLocale()), fromStr, toStr);
            this.names[i - 1] = forEn ? MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"529_RptRepaymentDetailHandlerBase", (Locale)ctx.getLocale()), df.format(this.edgeDates[i - 1]), df.format(this.edgeDates[i])) : msgStr;
            this.edgeDates[i] = DateTimeUtils.addDay((Date)this.edgeDates[i - 1], (long)7L);
            this.ids[i - 1] = DateTimeUtils.getYear((Date)this.edgeDates[i - 1]) * 100 + this.getWeek(this.edgeDates[i - 1]);
        }
        if (this.rateCurrencyIdSet.size() > 0) {
            this.temptable = this.buildFactTempTable(ctx);
            HashSet<String> currencyIdSet = new HashSet<String>();
            String currencySql = this.getCurrencySql(ctx);
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)currencySql);
                while (rs.next()) {
                    currencyIdSet.add(rs.getString("FCurrencyID"));
                }
            }
            catch (SQLException rs) {
                // empty catch block
            }
            Iterator it = currencyIdSet.iterator();
            String locCurrencyId = (String)this.rateCurrencyIdSet.iterator().next();
            CurrencyInfo locCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(locCurrencyId));
            CompanyOrgUnitInfo company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            String currencyStr = "";
            while (it.hasNext()) {
                String currencyid = (String)it.next();
                BigDecimal rate = null;
                if (currencyid.equals(locCurrencyId)) {
                    rate = Constants.ONE;
                } else {
                    CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyid));
                    ExchangeRateInfo rateInfo = FMHelper.getExRateInfo((Context)ctx, (CurrencyInfo)currency, (CurrencyInfo)locCurrency, (CompanyOrgUnitInfo)company, (Date)dateTime);
                    if (EmptyUtil.isEmpty((CoreBaseInfo)rateInfo)) {
                        currencyStr = currencyStr + "," + currency.getName();
                    } else {
                        rate = ConvertModeEnum.INDIRECTEXCHANGERATE.equals((Object)rateInfo.getConvertMode()) ? Constants.ONE.divide(rateInfo.getConvertRate(), 20, 4) : rateInfo.getConvertRate();
                    }
                }
                String sql = "insert into " + this.temptable + " values('" + currencyid + "', " + rate + ")";
                DbUtil.execute((Context)ctx, (String)sql);
            }
            if (currencyStr.length() > 0) {
                throw new FinBaseDataException(FinBaseDataException.EXCEPTIONEXHANGERATE, new Object[]{currencyStr.substring(1), locCurrency.getName()});
            }
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select count(*) from T_BD_Bank");
            if (rs.next()) {
                this.isCreateTemp4Bank = rs.getInt(1) > 1000;
            }
        }
        catch (Exception e) {
            this.isCreateTemp4Bank = false;
        }
    }

    private int getWeek(Date vDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(vDate);
        cal.setMinimalDaysInFirstWeek(7);
        int week = cal.get(3);
        return week;
    }

    private String[] getDimensionNames() {
        return new String[]{"Company", "Currency", "Loaner", "PeriodRType"};
    }

    private String[] getDimensionSqls(Context ctx) throws BOSException {
        Set<String> institutionIds;
        String[] sqls = new String[4];
        sqls[0] = "select FID,FParentID,FName_" + this.loc + " AS FName from T_ORG_Company where FID in " + FMHelper.setTran2String((Set)this.companyIds);
        sqls[0] = this.getTempTableSql(ctx, sqls[0], "rptRepayCompany");
        sqls[1] = "select FID,FName_" + this.loc + " AS FName from T_BD_Currency";
        sqls[2] = this.loanProperty == LoanPropertyEnum.OutGroup ? "select FID,FParentID,FName_" + this.loc + " AS FName from T_BD_Bank" : (this.loanProperty == LoanPropertyEnum.InGroup ? "select FID,FParentID,FName_" + this.loc + " AS FName from T_ORG_Company" : (this.forcastByLoaner ? "select FID as FID,FParentID as FParentID,FName_" + this.loc + ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"100_RptRepaymentSumBaseHandler", (Locale)ctx.getLocale()) : (this.isContainBond ? "select 'xxxxxxxxx' as FID, '' as FParentID, N'\u503a\u5238' as FName union all select FID as FID,FParentID as FParentID,FName_" + this.loc + " AS FName from T_BD_Bank union all select FID as FID, FParentID as FParentID, FName_" + this.loc + " as FName from T_ORG_Company" : "select FID as FID,FParentID as FParentID,FName_" + this.loc + " AS FName from T_BD_Bank union all select FID as FID, FParentID as FParentID, FName_" + this.loc + " as FName from T_ORG_Company")));
        if (this.isCreateTemp4Bank && (institutionIds = this.getInstitutionIds(ctx)).size() > 0) {
            sqls[2] = sqls[2].replaceAll("T_BD_Bank", "T_BD_Bank where FID in " + FMHelper.setTran2String(institutionIds));
            sqls[2] = this.getTempTableSql(ctx, sqls[2], "rptRepayLoaner");
        }
        StringBuffer sql = new StringBuffer();
        for (int i = 0; i < this.time; ++i) {
            sql.append("select " + this.ids[i] + " as FID,'" + this.names[i] + "' as FName \n");
            if (i >= this.time - 1) continue;
            sql.append("union \n");
        }
        sqls[3] = sql.toString();
        return sqls;
    }

    private String getFactSql(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        if (this.isContainBond) {
            sql.append("select FCompanyID,case when FLoanerID is null then 'xxxxxxxxx' else FLoanerID end as FLoanerID,FCurrencyID,FPeriodRTypeID,FAmount,FBalance from ( \n");
        }
        sql.append("select FCompanyID,FLoanerID,FCurrencyID,FPeriodRTypeID,sum(FAmount) AS FAmount,sum(FBalance) as FBalance from");
        String sql1 = "";
        String sql2 = "";
        if (this.forcastType == 0 || this.forcastType == 2) {
            sql1 = this.getAmountSql(ctx);
        }
        if (this.forcastType == 1 || this.forcastType == 2) {
            sql2 = this.getBalanceSql(ctx);
        }
        if (this.forcastType == 0) {
            sql.append(sql1).append("as a group by FCompanyID,FLoanerID,FCurrencyID,FPeriodRTypeID \n");
        } else if (this.forcastType == 1) {
            sql.append(sql2).append("as b group by FCompanyID,FLoanerID,FCurrencyID,FPeriodRTypeID \n");
        } else if (this.forcastType == 2) {
            sql.append("(").append(sql1).append(" union all ").append(sql2).append(") as c ").append("group by FCompanyID,FLoanerID,FCurrencyID,FPeriodRTypeID \n");
        }
        if (this.isContainBond) {
            sql.append(")");
        }
        return this.getTempTableSql(ctx, sql.toString(), "rptRepayFact");
    }

    private String getCurrencySql(Context ctx) {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct FCurrencyID from ");
        StringBuffer sql1 = new StringBuffer();
        sql1.append("(\n");
        if (this.isContainBond) {
            sql1.append("select FCompanyID,case when FLoanerID is null then 'xxxxxxxxx' else FLoanerID end as FLoanerID,FCurrencyID,FPeriodRTypeID,FAmount,FBalance from ( \n");
        }
        sql1.append("select L.FCompanyID as FCompanyID,\n");
        if (this.loanProperty == null && this.forcastByLoaner && this.isContainBond) {
            sql1.append("case when L.FInstitutionID is null then '11111' else L.FInstitutionID end as FLoanerID, \n");
        } else {
            sql1.append("ISNULL(L.FInstitutionId,L.FGroupId) as FLoanerID,\n");
        }
        sql1.append("L.FCurrencyID as FCurrencyID,\n");
        if (this.timeType == CycleTypeEnum.MONTH) {
            sql1.append("(YEAR(E.FDate)*100 + MONTH(E.FDate)) as FPeriodRTypeID,\n");
        } else if (this.timeType == CycleTypeEnum.QUARTER) {
            sql1.append("(YEAR(E.FDate)*100 + (FLOOR((MONTH(E.FDate)-1)/3)+1))  as FPeriodRTypeID,\n");
        } else if (this.timeType == CycleTypeEnum.YEAR) {
            sql1.append("YEAR(E.FDate)*100 as FPeriodRTypeID,\n");
        } else if (this.timeType == CycleTypeEnum.WEEK) {
            sql1.append("(YEAR(E.FDate)*100 + WEEK(E.FDate)) as FPeriodRTypeID,\n");
        }
        sql1.append("E.FAmount/" + this.unit.getValue() + " as FAmount,\n");
        sql1.append("(E.FAmount * FLocalCurExRate/" + this.unit.getValue() + ") as FBalance\n");
        sql1.append("from T_FIN_Loan as L\n");
        sql1.append("left outer join T_FIN_LoanEntry as E\n");
        sql1.append("on L.FID = E.FParentId\n");
        sql1.append("where \n");
        CompanyOrgUnitInfo currentCom = new ContextHelperSrv(ctx).getCurrentCompany();
        if (currentCom != null && !currentCom.isIsBizUnit() && this.companyIds != null && this.companyIds.size() > 0) {
            sql1.append("L.FCompanyID in ");
            sql1.append(FMHelper.setTran2String((Set)this.companyIds));
            sql1.append("\n");
        } else if (currentCom != null) {
            sql1.append("L.FCompanyID = '");
            sql1.append(currentCom.getId().toString());
            sql1.append("'\n");
        }
        if (this.forcastType == 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sql1.append(" AND \n");
            sql1.append("E.FDate >= {ts'" + sdf.format(this.currentDate) + "'}");
            sql1.append(" AND \n");
            sql1.append("E.FDate < {ts'" + sdf.format(this.edgeDates[this.edgeDates.length - 1]) + "'}");
        }
        if (!this.isContainBond) {
            if (this.loanProperty == LoanPropertyEnum.OutGroup) {
                if (this.loanerIds != null && this.loanerIds.size() > 0) {
                    sql1.append("AND \n");
                    sql1.append("L.FInstitutionId IN ");
                    sql1.append(FMHelper.setTran2String((Set)this.loanerIds));
                    sql1.append("\n");
                } else {
                    sql1.append(" AND \n");
                    sql1.append("L.FInstitutionId is not null \n");
                }
            } else if (this.loanProperty == LoanPropertyEnum.InGroup) {
                if (this.loanerIds != null && this.loanerIds.size() > 0) {
                    sql1.append("AND \n");
                    sql1.append("L.FGroupId IN ");
                    sql1.append(FMHelper.setTran2String((Set)this.loanerIds));
                    sql1.append("\n");
                } else {
                    sql1.append(" AND \n");
                    sql1.append("L.FGroupId is not null \n");
                }
            }
        }
        if (this.financingProductIds != null && this.financingProductIds.size() > 0) {
            sql1.append("AND \n");
            sql1.append("L.FTypeID IN ");
            sql1.append(FMHelper.setTran2String((Set)this.financingProductIds));
            sql1.append("\n");
        }
        if (this.projectIds != null && this.projectIds.size() > 0) {
            sql1.append("AND \n");
            sql1.append("L.FProjectID IN ");
            sql1.append(FMHelper.setTran2String((Set)this.projectIds));
            sql1.append("\n");
        }
        sql1.append(" AND \n");
        sql1.append("L.FBalance > 0\n");
        if (this.isContainBond) {
            sql1.append(")");
        }
        sql1.append(") t\n");
        sql.append(sql1);
        return sql.toString();
    }

    private String getBalanceSql(Context ctx) {
        StringBuffer sql2 = new StringBuffer();
        sql2.append("(\n");
        sql2.append("select L.FCompanyID as FCompanyID,\n");
        if (this.loanProperty == null && this.forcastByLoaner && this.isContainBond) {
            sql2.append("case when L.FInstitutionID is null then '11111' else L.FInstitutionID end as FLoanerID, \n");
        } else {
            sql2.append("ISNULL(L.FInstitutionId,L.FGroupId) as FLoanerID,\n");
        }
        sql2.append("L.FCurrencyID as FCurrencyID,\n");
        if (this.timeType == CycleTypeEnum.MONTH) {
            sql2.append("(YEAR(I.FBizDate)*100 + MONTH(I.FBizDate)) as FPeriodRTypeID,\n");
        } else if (this.timeType == CycleTypeEnum.QUARTER) {
            sql2.append("(YEAR(I.FBizDate)*100 + (FLOOR((MONTH(I.FBizDate)-1)/3)+1)) as FPeriodRTypeID,\n");
        } else if (this.timeType == CycleTypeEnum.YEAR) {
            sql2.append("YEAR(I.FBizDate)*100 as FPeriodRTypeID,\n");
        } else if (this.timeType == CycleTypeEnum.WEEK) {
            sql2.append("case ");
            for (int i = 1; i < this.edgeDates.length; ++i) {
                sql2.append("when I.FBizDate >= {").append(this.date2String(this.edgeDates[i - 1])).append("} and I.FBizDate < {").append(this.date2String(this.edgeDates[i])).append("} ").append("then '").append(this.ids[i - 1]).append("' ");
            }
            sql2.append("end as FPeriodRTypeID,\n");
        }
        sql2.append("I.FInterest/" + this.unit.getValue() + " as FAmount,\n");
        if (this.rateCurrencyIdSet.size() > 0) {
            sql2.append("(I.FInterest * " + this.temptable + ".FRate/" + this.unit.getValue() + ") as FBalance\n");
        } else {
            sql2.append("(I.FInterest * L.FLocalCurExRate/" + this.unit.getValue() + ") as FBalance\n");
        }
        sql2.append("from T_FIN_Loan as L\n");
        sql2.append("left outer join T_FIN_LoanInterest as I\n");
        sql2.append("on L.FID = I.FLoanID\n");
        if (this.rateCurrencyIdSet.size() > 0) {
            sql2.append(" left join " + this.temptable + " on " + this.temptable + ".FRateCurrencyID = L.FCurrencyId ");
        }
        sql2.append("where \n");
        CompanyOrgUnitInfo currentCom = new ContextHelperSrv(ctx).getCurrentCompany();
        if (currentCom != null && !currentCom.isIsBizUnit() && this.companyIds != null && this.companyIds.size() > 0) {
            sql2.append("L.FCompanyID in ");
            sql2.append(FMHelper.setTran2String((Set)this.companyIds));
            sql2.append("\n");
        } else if (currentCom != null) {
            sql2.append("L.FCompanyID = '");
            sql2.append(currentCom.getId().toString());
            sql2.append("'\n");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sql2.append(" AND \n");
        sql2.append("I.FBizDate >= {ts'" + sdf.format(this.currentDate) + "'}");
        sql2.append(" AND \n");
        sql2.append("I.FBizDate < {ts'" + sdf.format(this.edgeDates[this.edgeDates.length - 1]) + "'}");
        if (!this.isContainBond) {
            if (this.loanProperty == LoanPropertyEnum.OutGroup) {
                if (this.loanerIds != null && this.loanerIds.size() > 0) {
                    sql2.append("AND \n");
                    sql2.append("L.FInstitutionId IN ");
                    sql2.append(FMHelper.setTran2String((Set)this.loanerIds));
                    sql2.append("\n");
                } else {
                    sql2.append(" AND \n");
                    sql2.append("L.FInstitutionId is not null \n");
                }
            } else if (this.loanProperty == LoanPropertyEnum.InGroup) {
                if (this.loanerIds != null && this.loanerIds.size() > 0) {
                    sql2.append("AND \n");
                    sql2.append("L.FGroupId IN ");
                    sql2.append(FMHelper.setTran2String((Set)this.loanerIds));
                    sql2.append("\n");
                } else {
                    sql2.append(" AND \n");
                    sql2.append("L.FGroupId is not null \n");
                }
            }
        }
        if (this.financingProductIds != null && this.financingProductIds.size() > 0) {
            sql2.append("AND \n");
            sql2.append("L.FTypeID IN ");
            sql2.append(FMHelper.setTran2String((Set)this.financingProductIds));
            sql2.append("\n");
        }
        if (this.projectIds != null && this.projectIds.size() > 0) {
            sql2.append("AND \n");
            sql2.append("L.FProjectID IN ");
            sql2.append(FMHelper.setTran2String((Set)this.projectIds));
            sql2.append("\n");
        }
        sql2.append(" AND \n");
        sql2.append("L.FBalance > 0\n");
        sql2.append(" AND \n");
        sql2.append("I.FIsPrediction = 1\n");
        sql2.append(")\n");
        return sql2.toString();
    }

    private String date2String(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    private String getAmountSql(Context ctx) {
        StringBuffer sql1 = new StringBuffer();
        sql1.append("(\n");
        sql1.append("select L.FCompanyID as FCompanyID,\n");
        if (this.loanProperty == null && this.forcastByLoaner && !this.isContainBond) {
            sql1.append("case when L.FInstitutionID is null then '11111' else L.FInstitutionID end as FLoanerID, \n");
        } else {
            sql1.append("ISNULL(L.FInstitutionId,L.FGroupId) as FLoanerID,\n");
        }
        sql1.append("L.FCurrencyID as FCurrencyID,\n");
        if (this.timeType == CycleTypeEnum.MONTH) {
            sql1.append("(YEAR(E.FDate)*100 + MONTH(E.FDate)) as FPeriodRTypeID,\n");
        } else if (this.timeType == CycleTypeEnum.QUARTER) {
            sql1.append("(YEAR(E.FDate)*100 + (FLOOR((MONTH(E.FDate)-1)/3)+1))  as FPeriodRTypeID,\n");
        } else if (this.timeType == CycleTypeEnum.YEAR) {
            sql1.append("YEAR(E.FDate)*100 as FPeriodRTypeID,\n");
        } else if (this.timeType == CycleTypeEnum.WEEK) {
            sql1.append("case ");
            for (int i = 1; i < this.edgeDates.length; ++i) {
                sql1.append("when E.FDate >= {").append(this.date2String(this.edgeDates[i - 1])).append("} and E.FDate < {").append(this.date2String(this.edgeDates[i])).append("} ").append("then '").append(this.ids[i - 1]).append("' ");
            }
            sql1.append("end as FPeriodRTypeID,\n");
        }
        sql1.append("E.FAmount/" + this.unit.getValue() + " as FAmount,\n");
        if (this.rateCurrencyIdSet.size() > 0) {
            sql1.append("(E.FAmount * " + this.temptable + ".FRate/" + this.unit.getValue() + ") as FBalance\n");
        } else {
            sql1.append("(E.FAmount * FLocalCurExRate/" + this.unit.getValue() + ") as FBalance\n");
        }
        sql1.append("from T_FIN_Loan as L\n");
        sql1.append("left outer join T_FIN_LoanEntry as E\n");
        sql1.append("on L.FID = E.FParentId\n");
        if (this.rateCurrencyIdSet.size() > 0) {
            sql1.append("left join " + this.temptable + " on " + this.temptable + ".FRateCurrencyID = L.FCurrencyId ");
        }
        sql1.append("where \n");
        CompanyOrgUnitInfo currentCom = new ContextHelperSrv(ctx).getCurrentCompany();
        if (currentCom != null && !currentCom.isIsBizUnit() && this.companyIds != null && this.companyIds.size() > 0) {
            sql1.append("L.FCompanyID in ");
            sql1.append(FMHelper.setTran2String((Set)this.companyIds));
            sql1.append("\n");
        } else if (currentCom != null) {
            sql1.append("L.FCompanyID = '");
            sql1.append(currentCom.getId().toString());
            sql1.append("'\n");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sql1.append(" AND \n");
        sql1.append("E.FDate >= {ts'" + sdf.format(this.currentDate) + "'}");
        sql1.append(" AND \n");
        sql1.append("E.FDate < {ts'" + sdf.format(this.edgeDates[this.edgeDates.length - 1]) + "'}");
        if (!this.isContainBond) {
            if (this.loanProperty == LoanPropertyEnum.OutGroup) {
                if (this.loanerIds != null && this.loanerIds.size() > 0) {
                    sql1.append("AND \n");
                    sql1.append("L.FInstitutionId IN ");
                    sql1.append(FMHelper.setTran2String((Set)this.loanerIds));
                    sql1.append("\n");
                } else {
                    sql1.append(" AND \n");
                    sql1.append("L.FInstitutionId is not null \n");
                }
            } else if (this.loanProperty == LoanPropertyEnum.InGroup) {
                if (this.loanerIds != null && this.loanerIds.size() > 0) {
                    sql1.append("AND \n");
                    sql1.append("L.FGroupId IN ");
                    sql1.append(FMHelper.setTran2String((Set)this.loanerIds));
                    sql1.append("\n");
                } else {
                    sql1.append(" AND \n");
                    sql1.append("L.FGroupId is not null \n");
                }
            }
        }
        if (this.financingProductIds != null && this.financingProductIds.size() > 0) {
            sql1.append("AND \n");
            sql1.append("L.FTypeID IN ");
            sql1.append(FMHelper.setTran2String((Set)this.financingProductIds));
            sql1.append("\n");
        }
        if (this.projectIds != null && this.projectIds.size() > 0) {
            sql1.append("AND \n");
            sql1.append("L.FProjectID IN ");
            sql1.append(FMHelper.setTran2String((Set)this.projectIds));
            sql1.append("\n");
        }
        sql1.append(" AND \n");
        sql1.append("L.FBalance > 0\n");
        sql1.append(")\n");
        return sql1.toString();
    }

    private Set<String> getInstitutionIds(Context ctx) {
        HashSet<String> ids = new HashSet<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuilder sql1 = new StringBuilder();
        sql1.append("select FInstitutionId from T_FIN_Loan L left join T_FIN_LoanEntry E on L.FID = E.FParentId \n");
        sql1.append(" where L.FCompanyId in ").append(FMHelper.setTran2String((Set)this.companyIds));
        sql1.append(" AND E.FDate >= {ts'").append(sdf.format(this.currentDate)).append("'}");
        sql1.append(" AND E.FDate < {ts'").append(sdf.format(this.edgeDates[this.edgeDates.length - 1])).append("'}");
        sql1.append(" AND L.FBalance > 0");
        StringBuilder sql2 = new StringBuilder();
        sql2.append("select FInstitutionId from T_FIN_Loan L left join T_FIN_LoanInterest I on L.FID = I.FLoanID \n");
        sql2.append(" where L.FCompanyId in ").append(FMHelper.setTran2String((Set)this.companyIds));
        sql2.append(" AND I.FBizDate >= {ts'").append(sdf.format(this.currentDate)).append("'}");
        sql2.append(" AND I.FBizDate < {ts'").append(sdf.format(this.edgeDates[this.edgeDates.length - 1])).append("'}");
        sql2.append(" AND L.FBalance > 0 AND I.FIsPrediction = 1");
        try {
            IRowSet rs;
            if (this.forcastType == 0 || this.forcastType == 2) {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
                while (rs.next()) {
                    ids.add(rs.getString(1));
                }
            }
            if (this.forcastType == 1 || this.forcastType == 2) {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql2.toString());
                while (rs.next()) {
                    ids.add(rs.getString(1));
                }
            }
        }
        catch (Exception e) {
            return new HashSet<String>();
        }
        return ids;
    }

    public String getTempTableSql(Context ctx, String sql, String tempTableName) throws BOSException {
        String tempTable = BireportBaseFacadeControllerBean.getTempTableName((String)tempTableName, (Context)ctx);
        StringBuffer baseSqlfact = new StringBuffer();
        baseSqlfact.append("select * into ").append(tempTable).append(" from ( ").append(sql).append(" ) as tt");
        BireportBaseFacadeControllerBean.executeSelectInto((String)baseSqlfact.toString(), null, (Context)ctx);
        return "select * from " + tempTable;
    }

    public ResultSet getFactResultSet(Context ctx, RptParams params) throws BOSException {
        return null;
    }

    protected abstract String getConfigXML();

    private String buildFactTempTable(Context ctx) throws BOSException {
        String sSQL = "if not exists (select * from KSQL_USERTABLES where KSQL_COL_TABNAME='T_Temp_RptLoanStruanalyse') Create Table T_Temp_RptLoanStruanalyse (FRateCurrencyId Varchar(44), FRate NUMERIC(17,8) DEFAULT 0);";
        DbUtil.execute((Context)ctx, (String)sSQL);
        sSQL = "Delete From T_Temp_RptLoanStruanalyse";
        DbUtil.execute((Context)ctx, (String)sSQL);
        return "T_Temp_RptLoanStruanalyse";
    }
}

