/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.td.StatisticalUnitEnum;
import com.kingdee.eas.fm.td.TimeDepositTypeEnum;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.bireport.util.SimpleTreeNode;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class RptTimeDepositDetailHelper {
    private CompanyOrgUnitInfo currentCompany;
    private CurrencyInfo baseCurrency;
    private String queryType;
    private Date endDate;
    private CurrencyInfo currencyInfo;
    private TimeDepositTypeEnum DepositType;
    private Set Depcompanys;
    private Set companys;
    private StatisticalUnitEnum amountUnit;
    private SimpleTreeNode companyTree;
    private String loc;
    private StringBuffer sql = null;
    private String configFile = "";
    private StringBuffer mdx = null;
    private BigDecimal startAmt;
    private BigDecimal endAmt;

    public RptTimeDepositDetailHelper(RptParams params, Context ctx) throws EASBizException, BOSException {
        this.currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        this.baseCurrency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(this.currentCompany);
        this.queryType = (String)params.getObject("queryType");
        this.endDate = (Date)params.getObject("endDate");
        this.currencyInfo = (CurrencyInfo)params.getObject("currency");
        this.DepositType = (TimeDepositTypeEnum)params.getObject("depositType");
        this.Depcompanys = (Set)params.getObject("DepCompanyIDS");
        this.companys = (Set)params.getObject("companyIDS");
        this.amountUnit = (StatisticalUnitEnum)params.getObject("amountUnit");
        this.companyTree = (SimpleTreeNode)params.getObject("companyTree");
        this.loc = RptTimeDepositDetailHelper.getLoc(ctx);
        this.startAmt = (BigDecimal)params.getObject("startdate");
        this.endAmt = (BigDecimal)params.getObject("enddate");
    }

    public static String getLoc(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    public static RptTimeDepositDetailHelper getInstance(RptParams params, Context ctx) throws EASBizException, BOSException {
        return new RptTimeDepositDetailHelper(params, ctx);
    }

    private String getCommonFilterToTimeDeposit() {
        Iterator it;
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        sb.append("fcurrencyid = '").append(this.currencyInfo.getId().toString()).append("' ");
        if (this.DepositType == TimeDepositTypeEnum.TIMEDEPOSIT_INNER || this.DepositType == TimeDepositTypeEnum.TIMEDEPOSIT_OUTER || this.DepositType == TimeDepositTypeEnum.CALLDEPOSIT_INNER || this.DepositType == TimeDepositTypeEnum.CALLDEPOSIT_OUTER) {
            sb.append(" and fdeposittype ='").append(this.DepositType.getValue()).append("' ");
        }
        if (this.companys.size() > 0) {
            sb.append(" and fcompanyid in (");
            it = this.companys.iterator();
            while (it.hasNext()) {
                sb.append("'").append(it.next().toString()).append("',");
            }
            sb.append("'')");
        }
        if (this.Depcompanys != null && this.Depcompanys.size() > 0) {
            sb.append(" and fdepcompanyid in (");
            it = this.Depcompanys.iterator();
            while (it.hasNext()) {
                sb.append("'").append(it.next().toString()).append("',");
            }
            sb.append("'')");
        }
        sb.append(" and FAmount > " + this.startAmt.toString() + " and FAmount < " + this.endAmt.toString());
        sb.append(")");
        return sb.toString();
    }

    private StringBuffer getFactTableSQL(Context ctx) {
        String unit = "1";
        if (this.amountUnit.equals((Object)StatisticalUnitEnum.THOUSAND)) {
            unit = "1000";
        } else if (this.amountUnit.equals((Object)StatisticalUnitEnum.TEN_THOUSAND)) {
            unit = "10000";
        } else if (this.amountUnit.equals((Object)StatisticalUnitEnum.MILLION)) {
            unit = "1000000";
        } else if (this.amountUnit.equals((Object)StatisticalUnitEnum.HUNDRED_THOUSAND)) {
            unit = "10000000";
        } else if (this.amountUnit.equals((Object)StatisticalUnitEnum.HUNDRED_MILLION)) {
            unit = "100000000";
        }
        StringBuffer factTableSQL = new StringBuffer();
        factTableSQL.append("select fcompanyid,fcurrencyid,fdepcompanyid,fcompanyname,");
        factTableSQL.append("(case fdeposittype ");
        factTableSQL.append(" when 'timedeposit' ");
        factTableSQL.append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"108_RptTimeDepositDetailHelper", (Locale)ctx.getLocale()));
        factTableSQL.append("when 'calldeposit' ");
        factTableSQL.append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"109_RptTimeDepositDetailHelper", (Locale)ctx.getLocale()));
        factTableSQL.append("else'' ");
        factTableSQL.append("end ");
        factTableSQL.append(") as fdeposittype, ");
        factTableSQL.append("   fcurrencyname,fdepcompanyname,fnumber,                                     ");
        factTableSQL.append("   FAmount/").append(unit).append(" as FAmount,FNaturalAmt/").append(unit).append(" as FNaturalAmt,                 ");
        factTableSQL.append("   fdecreaseedamt/").append(unit).append(" as fdecreaseedamt ,fdecreaseedamtlocal/").append(unit).append(" as fdecreaseedamtlocal,        ");
        factTableSQL.append("   fremamt/").append(unit).append(" as fremamt,fremamtlocal/").append(unit).append(" as fremamtlocal,                     ");
        factTableSQL.append("   feffectivedate,fmaturityday,fexchangerate, fcertificateno            ");
        factTableSQL.append("   from\t\t                                                         ");
        factTableSQL.append("   (                                                                    ");
        factTableSQL.append(this.getBasicSQL());
        factTableSQL.append("    )");
        factTableSQL.append(" where 1=1 and ");
        factTableSQL.append(this.getCommonFilterToTimeDeposit());
        if (this.queryType.equals("byDepCompany")) {
            factTableSQL.append("  group by fcompanyid ,fcurrencyid,fbankid,fcompanyname,ftimedeposittype,fcurrencyname,fbankname,fnumber,fdepositamtlocal,feffectivedate,fmaturityday,fexchangerate, fcertificateno,fdepositamt,fdecreaseedamt,fdecreaseedamtlocal,fremamt,fremamtlocal");
        } else if (this.queryType.equals("byCompany")) {
            factTableSQL.append("  group by fcompanyid ,fcurrencyid,fbankid,fcompanyname,ftimedeposittype,fcurrencyname,fbankname,fnumber,fdepositamtlocal,feffectivedate,fmaturityday,fexchangerate, fcertificateno,fdepositamt,fdecreaseedamt,fdecreaseedamtlocal,fremamt,fremamtlocal");
        } else if (this.queryType.equals("byCurrency")) {
            factTableSQL.append("  group by fcompanyid ,fcurrencyid,fbankid,fcompanyname,ftimedeposittype,fcurrencyname,fbankname,fnumber,fdepositamtlocal,feffectivedate,fmaturityday,fexchangerate, fcertificateno,fdepositamt,fdecreaseedamt,fdecreaseedamtlocal,fremamt,fremamtlocal");
        }
        return factTableSQL;
    }

    private StringBuffer getBasicSQL() {
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t     ");
        sbSQL.append("fcompanyid,fcurrencyid,fbankid,fcompanyname,ftimedeposittype,fcurrencyname,fbankname,fnumber,                  ");
        sbSQL.append("flocalAmt as fdepositamt,");
        sbSQL.append("(\t                                                                                                             ");
        sbSQL.append(" case (select FBaseCurrencyID from t_org_company where fid  =? )   ");
        sbSQL.append("  when fcurrencyid                                                                                             ");
        sbSQL.append("  then flocalAmt                                                                                               ");
        sbSQL.append("  else flocalAmt*fexchangerate                                                                                 ");
        sbSQL.append("  end\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append(") as fdepositamtlocal,\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("fdecreaseedAmt as fdecreaseedamt,");
        sbSQL.append("(\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append(" case (select FBaseCurrencyID from t_org_company where fid  =?)   ");
        sbSQL.append("  when fcurrencyid\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("  then fdecreaseedAmt\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("  else fdecreaseedAmt*fexchangerate\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("  end\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append(") as fdecreaseedamtlocal,\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("(flocalAmt-fdecreaseedAmt) as fremamt,");
        sbSQL.append("(\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append(" case (select FBaseCurrencyID from t_org_company where fid  =?)   ");
        sbSQL.append("  when fcurrencyid\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("  then (flocalAmt-fdecreaseedAmt)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("  else (flocalAmt-fdecreaseedAmt)*fexchangerate\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("  end\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append(") as fremamtlocal,\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("feffectivedate,fmaturityday,fexchangerate, fcertificateno\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("from \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("(\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("select tim.fcompanyid as fcompanyid,cur.fid as fcurrencyid, bank.fid as fbankid ,com.fname_" + this.loc + " as fcompanyname, ");
        sbSQL.append("ftimedeposittype , cur.fname_" + this.loc + " as fcurrencyname,bank.fname_" + this.loc + " as fbankname,tim.fnumber as fnumber,\t\t ");
        sbSQL.append("(case tim.fisredeposited\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("  when 1 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("   then \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("    case \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("     when (select fbizdate from t_td_timedepositbill tmp where tmp.fsourcebillid = tim.fid) > ? \t\t\t     ");
        sbSQL.append("      then (select fremamt from t_td_timedepositbill tmp where tmp.fsourcebillid = tim.fid)\t\t\t\t\t ");
        sbSQL.append("     else 0                                                       \t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("     end\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("  else \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("   case tim.fisundeposit\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("    when 1 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("     then      \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("      case\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("       when (select max(fbizdate) from  t_td_untimedepositbill tmp1 where tmp1.ftimedepositbillid=tim.fid\u3000and fbizdate < ?) < ?   ");
        sbSQL.append("        then  tim.fdepositamt + (select sum(tmp2.fundepositamt) from  t_td_untimedepositbill tmp2 where tmp2.ftimedepositbillid=tim.fid and tmp2.fbizdate<(select max(fbizdate) from  t_td_untimedepositbill tmp1 where tmp1.ftimedepositbillid=tim.fid)) ");
        sbSQL.append("       else\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("        tim.fdepositamt\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("      end        \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("     else  tim.fdepositamt\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("    end\u3000\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("  end      \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append(") as flocalAmt,\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("(\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("case tim.fisredeposited\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("  when 1 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("   then \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("    case \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("     when (select fbizdate from t_td_timedepositbill tmp where tmp.fsourcebillid = tim.fid) < ?                ");
        sbSQL.append("      then tim.fremamt     \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t     ");
        sbSQL.append("     else 0      \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("     end     \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("  else \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("   case tim.fisundeposit\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("    when 1 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("     then      \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("      case\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("       when (select max(fbizdate) from  t_td_untimedepositbill tmp1 where tmp1.ftimedepositbillid=tim.fid) < ? ");
        sbSQL.append("        then (select sum(tmp2.fundepositamt) from  t_td_untimedepositbill tmp2 where tmp2.ftimedepositbillid=tim.fid and fbizdate<tim.flastundepositdate)  ");
        sbSQL.append("       else 0 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("      end        \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("     else 0\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("    end\u3000\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append("  end      \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sbSQL.append(") as fdecreaseedAmt,tim.feffectivedate as feffectivedate,tim.fmaturityday as fmaturityday,tim.fexchangerate as fexchangerate,tim.fcertificateno as fcertificateno ");
        sbSQL.append("from t_td_timedepositbill tim , t_org_company com , t_bd_currency cur, t_bd_bank bank\t\t\t\t\t\t\t ");
        sbSQL.append("where tim.fcompanyid = com.fid and tim.fcurrencyid = cur.fid and tim.fdepositbankid = bank.fid\t\t\t\t ");
        sbSQL.append(")\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        return sbSQL;
    }

    public void setSchemaSource(SchemaSource ss, Context ctx) {
        String currentCompanyID = this.currentCompany.getId().toString();
        SqlParams sqlp = new SqlParams();
        sqlp.addObject((Object)currentCompanyID);
        sqlp.addObject((Object)currentCompanyID);
        sqlp.addObject((Object)currentCompanyID);
        sqlp.addObject((Object)this.endDate);
        sqlp.addObject((Object)this.endDate);
        sqlp.addObject((Object)this.endDate);
        sqlp.addObject((Object)this.endDate);
        sqlp.addObject((Object)this.endDate);
        ss.setDataItem("Fact", this.getFactTableSQL(ctx).toString(), sqlp);
        this.sql = new StringBuffer();
        this.sql.setLength(0);
        if (this.queryType.equals("byDepCompany")) {
            this.sql.append("select com.FId,com.FName_").append(this.loc).append(" as FName,FParentID as FParentID from  as com\n");
            ss.setDataItem("Bank", this.sql.toString(), null);
            this.configFile = "RptTimeDepositDetail_Bank.xml";
            this.mdx = new StringBuffer();
            this.mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"110_RptTimeDepositDetailHelper", (Locale)ctx.getLocale()));
            this.mdx.append("\n select  {[fbankname],[ftimedeposittype],[fcurrencyName],[fnumber], ");
            this.mdx.append(" [Measures].members,[feffectivedate],[fmaturityday],[fexchangerate],[fcertificateno]}");
            this.mdx.append("on columns,");
            this.mdx.append("\n non empty {[Bank]} on rows ");
            this.mdx.append("\n from fm");
        } else if (this.queryType.equals("byCompany")) {
            this.sql.append("select com.FId,com.FName_").append(this.loc).append(" as FName,FParentID as FParentID from T_ORG_Company as com\n");
            ss.setDataItem("Company", this.sql.toString(), null);
            this.configFile = "RptTimeDepositDetail_Company.xml";
            this.mdx = new StringBuffer();
            this.mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"111_RptTimeDepositDetailHelper", (Locale)ctx.getLocale()));
            this.mdx.append("\n select  {[fbankname],[ftimedeposittype],[fcurrencyName],[fnumber], ");
            this.mdx.append(" [Measures].members,[feffectivedate],[fmaturityday],[fexchangerate],[fcertificateno]}");
            this.mdx.append("on columns,");
            this.mdx.append("\n non empty {[Company].members} on rows ");
            this.mdx.append("\n from fm");
        } else if (this.queryType.equals("byCurrency")) {
            this.sql.append("select cur.FId,cur.FName_").append(this.loc).append(" as FName from T_BD_Currency as cur\n");
            ss.setDataItem("Currency", this.sql.toString(), null);
            this.configFile = "RptTimeDepositDetail_Currency.xml";
            this.mdx = new StringBuffer();
            this.mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"112_RptTimeDepositDetailHelper", (Locale)ctx.getLocale()));
            this.mdx.append("\n select  {[fbankname],[ftimedeposittype],[fcurrencyName],[fnumber], ");
            this.mdx.append(" [Measures].members,[feffectivedate],[fmaturityday],[fexchangerate],[fcertificateno]}");
            this.mdx.append("on columns,");
            this.mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"113_RptTimeDepositDetailHelper", (Locale)ctx.getLocale()));
            this.mdx.append("\n from fm");
        }
        ss.setFilename(this.configFile);
        ss.setMdx(this.mdx.toString());
    }
}

