/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.app.RptTimeCompDepositSumFacadeControllerBean;
import com.kingdee.eas.fm.td.StatisticalUnitEnum;
import com.kingdee.eas.fm.td.TimeDepositTypeEnum;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.bireport.util.SimpleTreeNode;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.LocaleUtils;
import java.sql.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class RptTimeDepositSumHelper {
    private String queryType;
    private Date startDate;
    private Date endDate;
    private CurrencyInfo currencyInfo;
    private CurrencyInfo baseCurrency;
    private CompanyOrgUnitInfo currentCompany;
    private TimeDepositTypeEnum timeDepositType;
    private Set depcompanys;
    private Set companys;
    private StatisticalUnitEnum amountUnit;
    private SimpleTreeNode companyTree = null;
    private String loc;
    private String configFile = "";
    private StringBuffer mdx = null;
    private String commonFilerToTimeDeposit;
    private StringBuffer sql = null;
    private boolean isNeedExchange = false;
    private String groupByColum = "";
    String unit = "1";

    public static RptTimeDepositSumHelper getInstance(RptParams params, Context ctx) throws EASBizException, BOSException {
        return new RptTimeDepositSumHelper(params, ctx);
    }

    public RptTimeDepositSumHelper(RptParams params, Context ctx) throws EASBizException, BOSException {
        this.currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        this.baseCurrency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(this.currentCompany);
        this.queryType = (String)params.getObject("queryType");
        this.startDate = (Date)params.getObject("startDate");
        this.endDate = (Date)params.getObject("endDate");
        try {
            this.currencyInfo = (CurrencyInfo)params.getObject("currency");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            this.timeDepositType = (TimeDepositTypeEnum)params.getObject("depositType");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.depcompanys = FMHelper.asSet((String[])((String[])params.getObject("DepCompanyIDS")));
        this.companys = (Set)params.getObject("companyIDS");
        this.amountUnit = (StatisticalUnitEnum)params.getObject("amountUnit");
        this.companyTree = (SimpleTreeNode)params.getObject("companyTree");
        this.loc = this.getLoc(ctx);
        this.isNeedExchange = this.setIsLocalCurrency(this.currencyInfo);
    }

    private boolean setIsLocalCurrency(CurrencyInfo currencyInfo2) {
        return currencyInfo2 == null;
    }

    private String getLoc(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    private String getCommonFilterToTimeDeposit() {
        Iterator it;
        StringBuffer sb = new StringBuffer();
        sb.append("(FEffectedStatus <> 1 ");
        if (this.currencyInfo != null) {
            sb.append(" and fcurrencyid = '").append(this.currencyInfo.getId().toString()).append("' ");
        }
        if (this.timeDepositType != null && (this.timeDepositType == TimeDepositTypeEnum.TIMEDEPOSIT_INNER || this.timeDepositType == TimeDepositTypeEnum.TIMEDEPOSIT_OUTER || this.timeDepositType == TimeDepositTypeEnum.CALLDEPOSIT_INNER || this.timeDepositType == TimeDepositTypeEnum.CALLDEPOSIT_OUTER)) {
            sb.append(" and FDepositType ='").append(this.timeDepositType.getValue()).append("' ");
        }
        if (this.companys.size() > 0) {
            sb.append(" and fcompanyid in (");
            it = this.companys.iterator();
            while (it.hasNext()) {
                sb.append("'").append(it.next().toString()).append("',");
            }
            sb.append("'')");
        }
        if (this.depcompanys != null && this.depcompanys.size() > 0) {
            sb.append(" and fdepcompanyid in (");
            it = this.depcompanys.iterator();
            while (it.hasNext()) {
                sb.append("'").append(it.next().toString()).append("',");
            }
            sb.append("'')");
        }
        sb.append(")");
        return sb.toString();
    }

    public void prepare(Context ctx, String queryType) throws BOSException, EASBizException {
        this.commonFilerToTimeDeposit = this.getCommonFilterToTimeDeposit();
        if (this.amountUnit.equals((Object)StatisticalUnitEnum.THOUSAND)) {
            this.unit = "1000";
        } else if (this.amountUnit.equals((Object)StatisticalUnitEnum.TEN_THOUSAND)) {
            this.unit = "10000";
        } else if (this.amountUnit.equals((Object)StatisticalUnitEnum.MILLION)) {
            this.unit = "1000000";
        } else if (this.amountUnit.equals((Object)StatisticalUnitEnum.HUNDRED_THOUSAND)) {
            this.unit = "10000000";
        } else if (this.amountUnit.equals((Object)StatisticalUnitEnum.HUNDRED_MILLION)) {
            this.unit = "100000000";
        }
    }

    public void setSchemaSource(Context ctx, SchemaSource ss) {
        ss.setDataItem("Fact", this.getSumSql1Prepare(this.unit), this.getParams());
        this.sql = new StringBuffer();
        this.sql.setLength(0);
        if (this.queryType.equals("byDepCompany")) {
            this.sql.append("select depcom.FId,depcom.FName_").append(this.loc).append(" as FName,FParentID as FParentID from T_ORG_Company as depcom\n");
            ss.setDataItem("DepCompany", this.sql.toString(), null);
            this.configFile = "RptTimeDepositSum_Company.xml";
            this.mdx = new StringBuffer();
            this.mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"114_RptTimeDepositSumHelper", (Locale)ctx.getLocale()));
            this.mdx.append("\n select  [Measures].members on columns, ");
            this.mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"530_RptTimeDepositSumHelper", (Locale)ctx.getLocale()));
            this.mdx.append(" \n from fm");
        } else if (this.queryType.equals("byCurrency")) {
            this.sql.append("select cur.FId,cur.FName_").append(this.loc).append(" as FName from T_BD_Currency as cur\n");
            ss.setDataItem("Currency", this.sql.toString(), null);
            this.configFile = "RptTimeDepositSum_Currency.xml";
            this.mdx = new StringBuffer();
            this.mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"112_RptTimeDepositDetailHelper", (Locale)ctx.getLocale()));
            this.mdx.append("\n select  [Measures].members on columns,");
            this.mdx.append(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"113_RptTimeDepositDetailHelper", (Locale)ctx.getLocale()));
            this.mdx.append("\n from fm");
        }
        ss.setCaller(RptTimeCompDepositSumFacadeControllerBean.class);
        ss.setFilename(this.configFile);
        ss.setMdx(this.mdx.toString());
    }

    private StringBuffer getInnerSQL3(StringBuffer sbInnerSQL2) {
        StringBuffer sqlInnerSQL3 = new StringBuffer();
        if (this.queryType.equals("byDepCompany")) {
            this.groupByColum = " fdepcompanyid ";
        } else if (this.queryType.equals("byCurrency")) {
            this.groupByColum = " fcurrencyid ";
        }
        sqlInnerSQL3.append("select ").append(this.groupByColum).append(",");
        sqlInnerSQL3.append("sum(FQICHUYUE)/").append(this.unit).append(" as FQICHUYUE,       \n");
        sqlInnerSQL3.append("sum(FBENQIZENGJIA)/").append(this.unit).append(" as FBENQIZENGJIA,\n");
        sqlInnerSQL3.append("sum(FBENQIJIANSHAO)/").append(this.unit).append(" as FBENQIJIANSHAO,\n");
        sqlInnerSQL3.append("sum(FQICHUYUE+FBENQIZENGJIA-FBENQIJIANSHAO)/").append(this.unit).append(" as FBENQIYUE \n");
        sqlInnerSQL3.append("from                                                        \n");
        sqlInnerSQL3.append("(                                                           \n");
        sqlInnerSQL3.append(sbInnerSQL2);
        sqlInnerSQL3.append(")  bb                                                         \n");
        sqlInnerSQL3.append("group by ").append(this.groupByColum);
        return sqlInnerSQL3;
    }

    private StringBuffer getInnerSQL2(StringBuffer sbInnerSQL1) {
        StringBuffer innerSQL2 = new StringBuffer();
        innerSQL2.append("select                                                       \n");
        innerSQL2.append("fid,fcompanyid,fcurrencyid,fdepcompanyid,                          \n");
        innerSQL2.append("(qichubenjinbase-unDepositAmt1-redeamt) as FQICHUYUE,                           \n");
        innerSQL2.append("benqizengjia as FBENQIZENGJIA,                           \n");
        innerSQL2.append("(unDepositAmt2 + redeamt1) as FBENQIJIANSHAO            \n");
        innerSQL2.append("                                                             \n");
        innerSQL2.append("from                                                         \n");
        innerSQL2.append("(                                                            \n");
        innerSQL2.append(sbInnerSQL1);
        innerSQL2.append(") aa                                                           \n");
        return innerSQL2;
    }

    private String getSumSql1Prepare(String unit2) {
        StringBuffer sbInnerSQL1 = this.getInnerSQL1Prepare();
        StringBuffer sbInnerSQL2 = this.getInnerSQL2(sbInnerSQL1);
        StringBuffer sbInnerSQL3 = this.getInnerSQL3(sbInnerSQL2);
        return sbInnerSQL3.toString();
    }

    private StringBuffer getInnerSQL1Prepare() {
        StringBuffer innerSQL1 = new StringBuffer();
        innerSQL1.append("select                                                                                             \n");
        innerSQL1.append("tim.fid,tim.fbizdate,tim.fdepcompanyid as fdepcompanyid,tim.fcurrencyid,tim.fcompanyid as fcompanyid,                 \n");
        innerSQL1.append("TIM.FIsHistory,                                                                                \n");
        if (this.isNeedExchange) {
            innerSQL1.append(" (select isnull(sum(tim3.finitbalanceofhistorybill*tim3.fexchangeRate),0)  from T_FIN_CompDepositAccountBill  tim3 where tim3.feffectivedate<? and tim3.fid = tim.fid ) as qichubenjinbase,  \n");
        } else {
            innerSQL1.append(" (select isnull(sum(tim3.finitbalanceofhistorybill),0)  from T_FIN_CompDepositAccountBill  tim3 where tim3.feffectivedate<? and tim3.fid = tim.fid ) as qichubenjinbase,  \n");
        }
        innerSQL1.append("(   \n");
        innerSQL1.append("\t\t  select isnull(sum(  ").append(this.getBenQiZengJia()).append("    ),0) from T_FIN_CompDepositAccountBill tim1  \n");
        innerSQL1.append("\t\t\twhere tim1.feffectivedate <= ? and  \n");
        innerSQL1.append("\t      tim1.feffectivedate >= ? and tim1.fid = tim.fid \n");
        innerSQL1.append(") as benqizengjia, \n");
        innerSQL1.append("(                                                                                                  \n");
        innerSQL1.append(" select isnull(sum( ").append(this.getUnDepositAmt()).append(" ),0)                                                          \n");
        innerSQL1.append(" from t_fin_untimedepositbill ff                                                                    \n");
        innerSQL1.append(" where  ff.FUntimeDate < ? ");
        innerSQL1.append(" and ff.ftimedepositbillid = tim.fid ) as unDepositAmt1,                                               \n");
        innerSQL1.append("(case tim.fisChangeByReDeposited                                                                           \n");
        innerSQL1.append("  when 1 then                                                                                      \n");
        innerSQL1.append("   isnull( (                                                                                              \n");
        innerSQL1.append("      select                             \n").append(this.getRedeamt());
        innerSQL1.append("      from T_FIN_CompDepositAccountBill timinner ");
        innerSQL1.append("\t\t\twhere timinner.feffectivedate < ? and timinner.fsourcebillid = tim.fid),0) \n");
        innerSQL1.append("  else 0                                                                                           \n");
        innerSQL1.append("  end                                                                                              \n");
        innerSQL1.append(") as redeamt,                                                                                      \n");
        innerSQL1.append("(case tim.fisChangeByReDeposited                                                                           \n");
        innerSQL1.append("  when 1 then                                                                                      \n");
        innerSQL1.append("      (select isnull(sum(  ").append(this.getRedeamt1()).append("  ),0)                             \n");
        innerSQL1.append("      from T_FIN_CompDepositAccountBill timinner ");
        innerSQL1.append("\t\t\twhere timinner.feffectivedate >= ? and timinner.feffectivedate <=? and timinner.fsourcebillid = tim.fid) \n");
        innerSQL1.append("  else 0                                                                                           \n");
        innerSQL1.append("  end                                                                                              \n");
        innerSQL1.append(") as redeamt1,                                                                                      \n");
        innerSQL1.append("(case TIM.FIsHistory                                                                           \n");
        innerSQL1.append(" when 1 then (select isnull((   ").append(this.getAmt3()).append(" )),0) ");
        innerSQL1.append(" from T_FIN_CompDepositAccountBill tim4 ");
        innerSQL1.append("\t\t\twhere tim4.feffectivedate <= ? and  \n");
        innerSQL1.append("\t      tim4.feffectivedate >= ? and tim4.fid = tim.fid) \n");
        innerSQL1.append("  else 0                                                                                           \n");
        innerSQL1.append("  end                                                                                              \n");
        innerSQL1.append(") as amt3,  \t\t\t\t\t\t\t                                                             \n");
        innerSQL1.append("(select isnull(sum( " + this.getUnDepositAmt() + " ),0)                                                          \n");
        innerSQL1.append(" from t_fin_untimedepositbill ff                                                                    \n");
        innerSQL1.append(" where     \n");
        innerSQL1.append("  FUntimeDate >= ? and FUntimeDate <= ? and \n");
        innerSQL1.append(" ff.ftimedepositbillid = tim.fid                                                                   \n");
        innerSQL1.append(") as unDepositAmt2                                                                                 \n");
        innerSQL1.append("from T_FIN_CompDepositAccountBill tim                                                                      \n");
        innerSQL1.append(" where ").append(this.getCommonFilterToTimeDepositPrepared());
        return innerSQL1;
    }

    private String getAmt3() {
        String returnValue = this.isNeedExchange ? "sum(tim4.FNaturalAmt - tim4.finitbalanceofhistorybill*tim4.FExchangeRate" : "sum(tim4.FAmount - tim4.finitbalanceofhistorybill";
        return returnValue;
    }

    private String getRedeamt1() {
        String returnValue = this.isNeedExchange ? "timinner.finitbalanceofhistorybill*timinner.fexchangeRate - timinner.faccrualtodepositamt*timinner.fexchangeRate" : "timinner.finitbalanceofhistorybill - timinner.faccrualtodepositamt";
        return returnValue;
    }

    private String getRedeamt() {
        String returnValue = this.isNeedExchange ? "timinner.finitbalanceofhistorybill*timinner.fexchangeRate - timinner.faccrualtodepositamt*timinner.fexchangeRate" : "timinner.finitbalanceofhistorybill - timinner.faccrualtodepositamt";
        return returnValue;
    }

    private String getUnDepositAmt() {
        String returnValue = this.isNeedExchange ? "ff.fundepositamtlocal" : "ff.FUnDepositAmt";
        return returnValue;
    }

    private String getBenQiZengJia() {
        String returnValue = "tim1.finitbalanceofhistorybill";
        if (this.isNeedExchange) {
            returnValue = returnValue + "*tim1.fexchangeRate";
        }
        return returnValue;
    }

    private SqlParams getParams() {
        Object[] fixParam = this.getFixPara();
        Object[] currencyParam = this.getCurrencyPara();
        Object[] timeDepositTypeParam = this.getTimeDepositTypePara();
        Object[] companyParam = this.getCompanyPara();
        Object[] depComanyParam = this.getdepcompanyPara();
        return this.combineParam(fixParam, currencyParam, timeDepositTypeParam, companyParam, depComanyParam);
    }

    private SqlParams combineParam(Object[] fixParam, Object[] currencyParam, Object[] timeDepositTypeParam, Object[] companyParam, Object[] depComanyParam) {
        int paramCount = fixParam.length + currencyParam.length + timeDepositTypeParam.length + companyParam.length + depComanyParam.length;
        Object[] allParam = new Object[paramCount];
        int copyPosition = 0;
        System.arraycopy(fixParam, 0, allParam, copyPosition, fixParam.length);
        System.arraycopy(currencyParam, 0, allParam, copyPosition += fixParam.length, currencyParam.length);
        System.arraycopy(timeDepositTypeParam, 0, allParam, copyPosition += currencyParam.length, timeDepositTypeParam.length);
        System.arraycopy(companyParam, 0, allParam, copyPosition += timeDepositTypeParam.length, companyParam.length);
        System.arraycopy(depComanyParam, 0, allParam, copyPosition += companyParam.length, depComanyParam.length);
        return new SqlParams(allParam);
    }

    private Object[] getdepcompanyPara() {
        if (this.depcompanys != null) {
            Object[] depcompanyIDParam = new Object[this.getPlaceholderCount(this.depcompanys.size())];
            int depcompanyIDChoosedCount = this.depcompanys.size();
            Object[] depcompanyids = this.depcompanys.toArray();
            System.arraycopy(depcompanyids, 0, depcompanyIDParam, 0, depcompanyids.length);
            for (int j = 0; j < depcompanyIDParam.length - depcompanyIDChoosedCount; ++j) {
                depcompanyIDParam[j + depcompanyIDChoosedCount] = "";
            }
            return depcompanyIDParam;
        }
        return new Object[0];
    }

    private Object[] getCompanyPara() {
        Object[] companyIDParam = new Object[this.getPlaceholderCount(this.companys.size())];
        int loanCompanyIDChoosedCount = this.companys.size();
        Object[] companyids = this.companys.toArray();
        System.arraycopy(companyids, 0, companyIDParam, 0, companyids.length);
        for (int j = 0; j < companyIDParam.length - loanCompanyIDChoosedCount; ++j) {
            companyIDParam[j + loanCompanyIDChoosedCount] = "";
        }
        return companyIDParam;
    }

    private Object[] getTimeDepositTypePara() {
        Object[] timeDepositTypeParam = null;
        if (this.timeDepositType != null) {
            if (this.timeDepositType == TimeDepositTypeEnum.TIMEDEPOSIT_INNER || this.timeDepositType == TimeDepositTypeEnum.TIMEDEPOSIT_OUTER || this.timeDepositType == TimeDepositTypeEnum.CALLDEPOSIT_INNER || this.timeDepositType == TimeDepositTypeEnum.CALLDEPOSIT_OUTER) {
                timeDepositTypeParam = new String[]{this.timeDepositType.getValue()};
            }
        } else {
            timeDepositTypeParam = new String[]{};
        }
        return timeDepositTypeParam;
    }

    private Object[] getCurrencyPara() {
        Object[] currencyParam = null;
        currencyParam = this.currencyInfo != null ? new String[]{this.currencyInfo.getId().toString()} : new String[]{};
        return currencyParam;
    }

    private Object[] getFixPara() {
        return new Object[]{this.startDate, this.endDate, this.startDate, this.startDate, this.startDate, this.startDate, this.endDate, this.endDate, this.startDate, this.startDate, this.endDate};
    }

    private String getCommonFilterToTimeDepositPrepared() {
        StringBuffer sb = new StringBuffer();
        sb.append("(FEffectedStatus <> 1 ");
        if (this.currencyInfo != null) {
            sb.append(" and fcurrencyid = ? ");
        }
        if (this.timeDepositType != null && (this.timeDepositType == TimeDepositTypeEnum.TIMEDEPOSIT_INNER || this.timeDepositType == TimeDepositTypeEnum.TIMEDEPOSIT_OUTER || this.timeDepositType == TimeDepositTypeEnum.CALLDEPOSIT_INNER || this.timeDepositType == TimeDepositTypeEnum.CALLDEPOSIT_OUTER)) {
            sb.append(" and FDepositType =? ");
        }
        if (this.companys.size() > 0) {
            sb.append(" and ").append(this.getCompanyPrepared(this.companys));
        }
        if (this.depcompanys != null && this.depcompanys.size() > 0) {
            sb.append(" and ").append(this.getBankPrepared(this.depcompanys));
        }
        sb.append(")");
        return sb.toString();
    }

    private String getBankPrepared(Set depcompanys) {
        StringBuffer sb = new StringBuffer();
        int placeholderCount = this.getPlaceholderCount(depcompanys.size());
        for (int i = 0; i < placeholderCount; ++i) {
            sb.append(" fdepcompanyid = ? ");
            if (i == placeholderCount - 1) continue;
            sb.append(" or ");
        }
        return "(" + sb.toString() + ")";
    }

    private String getCompanyPrepared(Set companys) {
        StringBuffer sb = new StringBuffer();
        int placeholderCount = this.getPlaceholderCount(companys.size());
        for (int i = 0; i < placeholderCount; ++i) {
            sb.append(" fcompanyid = ? ");
            if (i == placeholderCount - 1) continue;
            sb.append(" or ");
        }
        return "(" + sb.toString() + ")";
    }

    private int getPlaceholderCount(int i) {
        if (i <= 20) {
            return 20;
        }
        if (i > 20 && i <= 40) {
            return 40;
        }
        if (i > 40 && i <= 60) {
            return 60;
        }
        if (i > 60 && i <= 80) {
            return 80;
        }
        return i;
    }
}

