/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ebservice.NoteDetailRequestBody;
import com.kingdee.bos.ebservice.NoteReceivableBody;
import com.kingdee.bos.ebservice.NoteReceivableDetail;
import com.kingdee.bos.ebservice.NoteStatusBody;
import com.kingdee.bos.ebservice.NoteStatusDetail;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FundsMoveException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.be.NoteTypeEnum;
import com.kingdee.eas.fm.be.app.service.NoteReceivableOpUtil;
import com.kingdee.eas.fm.be.app.service.NoteUpdateStautsUtil;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.be.app.util.FmBeWebUtils;
import com.kingdee.eas.fm.be.app.util.NoteBizInfo;
import com.kingdee.eas.fm.be.model.BatchExecuteResult;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.edrafent.DraftCollateralizationRequestFactory;
import com.kingdee.eas.fm.edrafent.DraftCollateralizationRequestInfo;
import com.kingdee.eas.fm.fin.FinBillStatusEnum;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.IWageDisposer;
import com.kingdee.eas.fm.fin.WageBillEntryCollection;
import com.kingdee.eas.fm.fin.WageBillEntryFactory;
import com.kingdee.eas.fm.fin.WageBillEntryInfo;
import com.kingdee.eas.fm.fin.WageCollection;
import com.kingdee.eas.fm.fin.WageDisposerActionEnum;
import com.kingdee.eas.fm.fin.WageDisposerFactory;
import com.kingdee.eas.fm.fin.WageFactory;
import com.kingdee.eas.fm.fin.WageInfo;
import com.kingdee.eas.fm.fin.app.AbstractWageControllerBean;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.fm.nt.ElecBillStatusEnum;
import com.kingdee.eas.fm.nt.IReceivableBill;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.app.BillServerUtil;
import com.kingdee.eas.fm.nt.app.util.DraftBEUtil;
import com.kingdee.eas.fm.nt.app.util.ReceivableBillCommitToBEUtil;
import com.kingdee.eas.fm.ntp.NTPException;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class WageControllerBean
extends AbstractWageControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.WageControllerBean");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final String NTP_RES = "com.kingdee.eas.fm.ntp.NtpResource";

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        WageInfo info = (WageInfo)model;
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)info, (AbstractCoreBaseControllerBean)this);
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        this._checkNumberDup(ctx, pk, (IObjectValue)info);
        super._addnew(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        WageInfo info = (WageInfo)model;
        if (FMHelper.isEmpty((String)info.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        this._checkNumberDup(ctx, (IObjectValue)info);
        if (info.getBillStatus() == null) {
            info.setBillStatus(FinBillStatusEnum.SUBMIT);
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        return pk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        super._update(ctx, pk, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (this.checkeISUsed(ctx, pk.toString())) {
            throw new FinBizException(FinBizException.WAGEDODEL_1);
        }
        if (this.checkeISUsed2(ctx, pk.toString())) {
            throw new FinBizException(FinBizException.WAGEDODEL_1);
        }
        WageInfo info = this.getWageInfo(ctx, pk);
        if (info.getRelatedRecBills() == null || info.getRelatedRecBills().size() == 0) {
            super._delete(ctx, pk);
        } else {
            DbUtil.execute((Context)ctx, (String)"delete T_FIN_Wage  where FId=?", (Object[])new Object[]{pk.toString()});
        }
    }

    @Override
    protected void _antiWage(Context ctx, IObjectPK pk, BOSObjectType bosType) throws BOSException, EASBizException {
        WageInfo info = this.getWageInfo(ctx, pk);
        if (info.isIsAntiWage()) {
            throw new FinBizException(FinBizException.WAGEISWAGED);
        }
        this.dispose(ctx, pk, bosType, WageDisposerActionEnum.antiwage);
        DbUtil.execute((Context)ctx, (String)"update T_FIN_Wage set FIsWage=1  where FId=?", (Object[])new Object[]{pk.toString()});
    }

    @Override
    protected void _unAntiWage(Context ctx, IObjectPK pk, BOSObjectType bosType) throws BOSException, EASBizException {
        WageInfo info = this.getWageInfo(ctx, pk);
        if (!info.isIsAntiWage()) {
            throw new FinBizException(FinBizException.WAGEISANTIWAGE);
        }
        this.dispose(ctx, pk, bosType, WageDisposerActionEnum.unAntiwage);
        DbUtil.execute((Context)ctx, (String)"update T_FIN_Wage set FIsWage=0  where FId=?", (Object[])new Object[]{pk.toString()});
    }

    private void dispose(Context ctx, IObjectPK pk, BOSObjectType bosType, WageDisposerActionEnum disposerActionEnum) throws BOSException, EASBizException {
        IWageDisposer disposer = null;
        disposer = WageDisposerFactory.getInstance(ctx, bosType);
        if (disposer != null) {
            disposer.dispose(ctx, disposerActionEnum, pk);
        }
    }

    private boolean checkeISUsed(Context ctx, String id) throws BOSException, EASBizException {
        String sql = " select 1 from T_FIN_WageEntry where  FParentID='" + id + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        boolean result = false;
        try {
            result = rs.next();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private boolean checkeISUsed2(Context ctx, String id) throws BOSException, EASBizException {
        String sql = " select 1 from T_FIN_creditlimitgtentry where  fbillid='" + id + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        boolean result = false;
        try {
            result = rs.next();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk, BOSObjectType BOSType) throws BOSException, EASBizException {
        if (this.checkeISUsed(ctx, pk.toString())) {
            throw new FinBizException(FinBizException.WAGEDODEL_1);
        }
        if (this.checkeISUsed2(ctx, pk.toString())) {
            throw new FinBizException(FinBizException.WAGEDODEL_1);
        }
        this.dispose(ctx, pk, BOSType, WageDisposerActionEnum.delete);
        this._delete(ctx, pk);
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo botRelation = (BOTRelationInfo)bOTRelationInfo;
        if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("voucherType.*"));
            sic.add(new SelectorItemInfo("voucherNum"));
            sic.add(new SelectorItemInfo("voucherCreator.*"));
            sic.add(new SelectorItemInfo("fiVouchered"));
            WageInfo wageInfo = (WageInfo)srcBillVO;
            wageInfo.setFiVouchered(false);
            wageInfo.setVoucherType(null);
            wageInfo.setVoucherCreator(null);
            wageInfo.setVoucherNum(null);
            WageFactory.getLocalInstance(ctx).updatePartial(wageInfo, sic);
        } else if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("voucherType.*"));
            sic.add(new SelectorItemInfo("voucherNum"));
            sic.add(new SelectorItemInfo("voucherCreator.*"));
            sic.add(new SelectorItemInfo("fiVouchered"));
            WageInfo wageInfo = (WageInfo)srcBillVO;
            UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(botRelation.getDestObjectID()));
            wageInfo.setFiVouchered(true);
            wageInfo.setVoucherType(voucherInfo.getVoucherType());
            wageInfo.setVoucherCreator(userInfo);
            wageInfo.setVoucherNum(voucherInfo.getNumber());
            WageFactory.getLocalInstance(ctx).updatePartial(wageInfo, sic);
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    @Override
    protected void _antiAudit(Context ctx, Set Set2) throws BOSException, EASBizException {
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        if (Set2 == null || Set2.size() == 0) {
            throw new FundsMoveException(FundsMoveException.IDSETISNULL);
        }
        Iterator it = Set2.iterator();
        while (it.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)it.next().toString()));
            this.antiAudit4WF(ctx, (IObjectPK)pk);
        }
    }

    @Override
    protected void _antiAudit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        WageInfo info = WageFactory.getLocalInstance(ctx).getWageInfo(pk);
        if (info.getBillStatus() != FinBillStatusEnum.AUDITED) {
            throw new FMException(FMException.SELECT_AUDIT_BILL);
        }
        if (this.checkeISUsed(ctx, pk.toString())) {
            throw new FinBizException(FinBizException.WAGEDONOT_ANTIAUDIT);
        }
        if (this.checkeISUsed2(ctx, pk.toString())) {
            throw new FinBizException(FinBizException.WAGEDONOT_ANTIAUDIT);
        }
        if (info.isIsCommitToBE() && !this.isAllFail(ctx, (IObjectPK)new ObjectUuidPK(info.getId()))) {
            throw new NTPException(NTPException.BE_CANNOT_UNAUDIT);
        }
        info.setBillStatus(FinBillStatusEnum.SUBMIT);
        info.setNull("auditor");
        super._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (IObjectValue)info);
    }

    @Override
    protected void _audit(Context ctx, Set idSet) throws BOSException, EASBizException {
        if (idSet == null || idSet.size() == 0) {
            throw new FMException(FMException.IDSETISNULL);
        }
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)it.next().toString()));
            WageInfo info = WageFactory.getLocalInstance(ctx).getWageInfo((IObjectPK)pk);
            if (!info.getBillStatus().equals((Object)FinBillStatusEnum.SUBMIT)) continue;
            this.audit4WF(ctx, (IObjectPK)pk);
        }
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        WageInfo info = WageFactory.getLocalInstance(ctx).getWageInfo(pk);
        if (info.getBillStatus() != FinBillStatusEnum.SUBMIT && info.getBillStatus() != FinBillStatusEnum.SAVE) {
            throw new FMException(FMException.SELECT_SUBMITED_BILL);
        }
        info.setBillStatus(FinBillStatusEnum.AUDITED);
        info.setAuditor(userInfo);
        super._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (IObjectValue)info);
    }

    @Override
    protected void _updateCollateral(Context ctx, IObjectPK pk, boolean bool) throws BOSException, EASBizException {
        DraftCollateralizationRequestInfo info = DraftCollateralizationRequestFactory.getLocalInstance((Context)ctx).getDraftCollateralizationRequestInfo(pk);
        SelectorItemCollection selColl = new SelectorItemCollection();
        selColl.add(new SelectorItemInfo("isCollaterals"));
        if (bool) {
            info.setIsCollaterals(true);
        } else {
            info.setIsCollaterals(false);
        }
        DraftCollateralizationRequestFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)info, selColl);
    }

    @Override
    protected ArrayList _batchCommitToBE(Context ctx, HashSet idSet) throws BOSException, EASBizException {
        ArrayList<BankPayResult> commitResult = new ArrayList<BankPayResult>();
        WageCollection wageColl = this.getWageCollByBill(ctx, idSet);
        int count = wageColl.size();
        for (int index = 0; index < count; ++index) {
            WageInfo info = wageColl.get(index);
            TreeMap<String, ArrayList<ReceivableBillInfo>> accNoMap = new TreeMap<String, ArrayList<ReceivableBillInfo>>();
            int size = info.getBillEntrys().size();
            for (int i = 0; i < size; ++i) {
                ReceivableBillInfo entry = info.getBillEntrys().get(i).getReceivableBill();
                String accNo = entry.getHolderAccount().getBankAccountNumber();
                ArrayList<ReceivableBillInfo> lst = (ArrayList<ReceivableBillInfo>)accNoMap.get(accNo);
                if (lst == null) {
                    lst = new ArrayList<ReceivableBillInfo>();
                }
                lst.add(entry);
                accNoMap.put(accNo, lst);
            }
            NoteReceivableOpUtil recOpUtil = new NoteReceivableOpUtil(ctx);
            try {
                for (String accNo : accNoMap.keySet()) {
                    BigDecimal totalAmount = BigDecimal.ZERO;
                    List infoList = (List)accNoMap.get(accNo);
                    for (ReceivableBillInfo entry : infoList) {
                        totalAmount = totalAmount.add(entry.getBillAmt());
                    }
                    this.doCommitBE(ctx, recOpUtil, accNo, totalAmount, infoList, info);
                }
                continue;
            }
            catch (Exception e) {
                BankPayResult resultInfo = new BankPayResult();
                resultInfo.setId(info.getId().toString());
                resultInfo.setNumber(info.getNumber().toString());
                resultInfo.setErrorDetail(e.getMessage());
                commitResult.add(resultInfo);
            }
        }
        return commitResult;
    }

    @Override
    protected void _commitToBE(Context ctx, IObjectValue wageInfo) throws BOSException, EASBizException {
        if (wageInfo == null) {
            return;
        }
        WageInfo info = (WageInfo)wageInfo;
        logger.debug((Object)"begin to commitToBE WageInfo");
        TreeMap<String, ArrayList<ReceivableBillInfo>> accNoMap = new TreeMap<String, ArrayList<ReceivableBillInfo>>();
        for (int i = 0; i < info.getBillEntrys().size(); ++i) {
            ReceivableBillInfo entry = info.getBillEntrys().get(i).getReceivableBill();
            String accNo = entry.getHolderAccount().getBankAccountNumber();
            ArrayList<ReceivableBillInfo> lst = (ArrayList<ReceivableBillInfo>)accNoMap.get(accNo);
            if (lst == null) {
                lst = new ArrayList<ReceivableBillInfo>();
            }
            lst.add(entry);
            accNoMap.put(accNo, lst);
        }
        NoteReceivableOpUtil recOpUtil = new NoteReceivableOpUtil(ctx);
        for (String accNo : accNoMap.keySet()) {
            BigDecimal totalAmount = BigDecimal.ZERO;
            List infoList = (List)accNoMap.get(accNo);
            for (ReceivableBillInfo entry : infoList) {
                totalAmount = totalAmount.add(entry.getBillAmt());
            }
            this.doCommitBE(ctx, recOpUtil, accNo, totalAmount, infoList, info);
        }
    }

    private void doCommitBE(Context ctx, NoteReceivableOpUtil recOpUtil, String accNo, BigDecimal totalAmount, List<ReceivableBillInfo> infoList, WageInfo info) throws EASBizException, BOSException {
        logger.debug((Object)"begin to commitToBE EndorsementBillInfo");
        try {
            this.beforeProcess(ctx, info.isIsCommitToBE(), infoList);
            NoteReceivableBody body = this.parseRequestBody(ctx, totalAmount, infoList, info);
            NoteBizInfo bizInfo = new NoteBizInfo();
            bizInfo.setBankAcct(accNo);
            bizInfo.setNoteType(NoteTypeEnum.NOTE_PLEDGE);
            NoteReceivableDetail[] detail = recOpUtil.noteRecOp(ctx, bizInfo, body);
            info.setIsCommitToBE(true);
            this.updatePartial(ctx, info, ConvertUtils.SIC((Object[])new Object[]{"isCommitToBE"}));
            this.afterProcess(ctx, info, infoList, detail);
        }
        catch (BEException e) {
            ReceivableBillCommitToBEUtil.afterCommit4Exception((Context)ctx, (ReceivableBillCollection)info.getRelatedRecBills());
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            ReceivableBillCommitToBEUtil.afterCommit4Exception((Context)ctx, (ReceivableBillCollection)info.getRelatedRecBills());
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            ReceivableBillCommitToBEUtil.afterCommit4Exception((Context)ctx, (ReceivableBillCollection)info.getRelatedRecBills());
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            logger.error((Object)err);
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
    }

    private void beforeProcess(Context ctx, boolean isCommitBE, List<ReceivableBillInfo> infoList) throws EASBizException, BOSException {
        String[] serialNos = beServiceHelper.getSerialNumber((int)infoList.size());
        CoreBaseCollection recBillCollection = new CoreBaseCollection();
        for (int i = 0; i < infoList.size(); ++i) {
            ReceivableBillInfo info = infoList.get(i);
            info.setDetailSeqID(serialNos[i]);
            info.setBatchSeqID(serialNos[0]);
            if (isCommitBE && info.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL) {
                info.setBankReturnStatus(null);
                info.setBankReturnMsg(null);
            }
            recBillCollection.add((CoreBaseInfo)info);
        }
        ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(recBillCollection);
    }

    private NoteReceivableBody parseRequestBody(Context ctx, BigDecimal totalAmount, List<ReceivableBillInfo> infoList, WageInfo info) throws EASBizException, BOSException {
        NoteReceivableBody body = new NoteReceivableBody();
        String seqID = infoList.get(0).getBatchSeqID();
        body.setBatchSeqID(seqID);
        body.setBatchBizNo(seqID);
        body.setTotalCount(String.valueOf(infoList.size()));
        body.setTotalAmount(totalAmount.setScale(2, 4).toString());
        body.setNoteReceiableDetail(this.parseDetail(ctx, infoList, info));
        return body;
    }

    private NoteReceivableDetail[] parseDetail(Context ctx, List<ReceivableBillInfo> infoList, WageInfo info) throws EASBizException, BOSException {
        BankInfo bankInfo = info.getInstitution();
        NoteReceivableDetail[] details = null;
        if (infoList.size() > 0) {
            details = new NoteReceivableDetail[infoList.size()];
            for (int i = 0; i < infoList.size(); ++i) {
                ReceivableBillInfo recInfo = infoList.get(i);
                NoteReceivableDetail detail = new NoteReceivableDetail();
                detail.setDetailSeqID(recInfo.getDetailSeqID());
                detail.setDetailBizNo(recInfo.getDetailSeqID());
                detail.setBillNo(recInfo.getDraftPackageNumber());
                detail.setDraftType(recInfo.getNtType().getGroup().equals((Object)NTTypeGroupEnum.RECEIVABLE_BankAccept) ? "AC01" : "AC02");
                detail.setTransferFlag("EM01");
                detail.setOppAccNo("0");
                detail.setOppAccName(bankInfo.getName());
                detail.setOppBankName(bankInfo.getName());
                BEBankInfo beInfo = null;
                if (bankInfo.getAccountBank() != null) {
                    beInfo = BEBankFactory.getLocalInstance((Context)ctx).getBEBankInfo((IObjectPK)new ObjectUuidPK(bankInfo.getAccountBank().getId()));
                }
                if (beInfo != null) {
                    detail.setOppCnapsCode(beInfo.getNumber());
                }
                detail.setOppAmount(info.getWageAmount().setScale(2).toString());
                detail.setBookingDate(DraftBEUtil.date2String((Date)recInfo.getIssuesDate(), (String)"yyyyMMddHHmmss"));
                detail.setDueDate(DraftBEUtil.date2String((Date)recInfo.getExpiredDate(), (String)"yyyyMMdd"));
                detail.setDesc(recInfo.getDescription());
                if (recInfo.getSource().equals((Object)BillSourceEnum.BYNEW)) {
                    BillServerUtil.setKeepFlag((NoteReceivableDetail)detail, (ReceivableBillInfo)recInfo);
                    String bankRefKey = BillServerUtil.getBankRefKey((Context)ctx, (ReceivableBillInfo)recInfo);
                    detail.setKeepFlag(detail.getKeepFlag() + ";bankRefKey=" + bankRefKey);
                }
                details[i] = detail;
            }
        }
        return details;
    }

    private void afterProcess(Context ctx, WageInfo info, List<ReceivableBillInfo> infoList, NoteReceivableDetail[] details) throws EASBizException, BOSException {
        CoreBaseCollection recColl = new CoreBaseCollection();
        CoreBaseCollection wageColl = new CoreBaseCollection();
        this.updateWageByDetail(ctx, info, infoList, details, recColl);
        if (recColl != null && recColl.size() > 0) {
            wageColl.add((CoreBaseInfo)info);
            this.updateBatchData(ctx, wageColl);
            ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(recColl);
        }
    }

    private CoreBaseCollection afterProcess4Sys(Context ctx, WageInfo info, List<ReceivableBillInfo> infoList, NoteReceivableDetail[] details, CoreBaseCollection recColl) throws EASBizException, BOSException {
        this.updateWageByDetail(ctx, info, infoList, details, recColl);
        return recColl;
    }

    private void updateWageByDetail(Context ctx, WageInfo info, List<ReceivableBillInfo> infoList, NoteReceivableDetail[] details, CoreBaseCollection recColl) {
        int i;
        HashSet<String> idSet = new HashSet<String>();
        int count = infoList.size();
        for (i = 0; i < count; ++i) {
            idSet.add(infoList.get(i).getId().toString());
        }
        for (i = 0; i < info.getBillEntrys().size(); ++i) {
            ReceivableBillInfo recInfo = info.getBillEntrys().get(i).getReceivableBill();
            WageBillEntryInfo wageBillEntryInfo = info.getBillEntrys().get(i);
            if (idSet != null && !idSet.contains(wageBillEntryInfo.getReceivableBill().getId().toString()) || wageBillEntryInfo.getBankReturnStatus() == BankReturnStatusEnum.BANK_SUCCESS) continue;
            String detailSeqID = recInfo.getDetailSeqID();
            for (int j = 0; j < details.length; ++j) {
                NoteReceivableDetail detail = details[j];
                if (detailSeqID == null || !detailSeqID.equals(detail.getDetailSeqID())) continue;
                if (detail.getEbStatus().equals(BankReturnStatusEnum.BANK_SUCCESS.getName())) {
                    logger.error((Object)("\u8d28\u62bc\u64a4\u9500 \u662f\u5426\u6210\u529f detail.getReservedFiled2() = " + detail.getReservedFiled2()));
                    if ("note_cancle".equals(detail.getReservedFiled2())) {
                        this.setNoteCancelSign(ctx, info, recInfo, i, true);
                    }
                } else if (detail.getEbStatus().equals(BankReturnStatusEnum.BANK_FAIL.getName()) && !"note_cancle".equals(detail.getReservedFiled2())) {
                    this.setNoteCancelSign(ctx, info, recInfo, i, false);
                }
                try {
                    if (recInfo.getSource().equals((Object)BillSourceEnum.BYNEW)) {
                        ElecBillStatusEnum elecBillStatusEnum = null;
                        elecBillStatusEnum = recInfo.isIsDisPledge() ? (info.getBillEntrys().get(i).isIsCommitCancel() ? BillServerUtil.setElecBillStatus((String)"disPledge_Cancle", (ReceivableBillInfo)recInfo, (NoteReceivableDetail)detail) : BillServerUtil.setElecBillStatus((String)"disPledge", (ReceivableBillInfo)recInfo, (NoteReceivableDetail)detail)) : (info.getBillEntrys().get(i).isIsCommitCancel() ? BillServerUtil.setElecBillStatus((String)"pledge_Cancle", (ReceivableBillInfo)recInfo, (NoteReceivableDetail)detail) : BillServerUtil.setElecBillStatus((String)"pledge", (ReceivableBillInfo)recInfo, (NoteReceivableDetail)detail));
                        if (!EmptyUtil.isEmpty((Object)elecBillStatusEnum)) {
                            info.getBillEntrys().get(i).setElecBillStatus(elecBillStatusEnum);
                        }
                        BillServerUtil.setStartAndEndNo((Context)ctx, (String)detail.getKeepFlag(), (String)detail.getEbStatus(), (ReceivableBillInfo)recInfo);
                        info.getBillEntrys().get(i).setReserveds(detail.getKeepFlag());
                    } else if (!EmptyUtil.isEmpty((String)detail.getNoteStatus())) {
                        recInfo.setElecBillStatus(ElecBillStatusEnum.getEnum((String)detail.getNoteStatus()));
                        info.getBillEntrys().get(i).setElecBillStatus(ElecBillStatusEnum.getEnum((String)detail.getNoteStatus()));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                info.getBillEntrys().get(i).setBankReturnMsg(detail.getBankStatusMsg());
                info.getBillEntrys().get(i).setBankReturnStatus(DraftBEUtil.transferState((String)detail.getEbStatus()));
                if (BankReturnStatusEnum.BANK_FAIL.equals((Object)info.getBillEntrys().get(i).getBankReturnStatus()) && info.getBillEntrys().get(i).isIsCommitCancel()) {
                    info.getBillEntrys().get(i).setIsCommitCancel(false);
                }
                recColl.add((CoreBaseInfo)recInfo);
            }
        }
    }

    private void setNoteCancelSign(Context ctx, WageInfo info, ReceivableBillInfo recInfo, int i, boolean isnotecancel) {
        if (isnotecancel) {
            info.getBillEntrys().get(i).setIsNoteCancel(true);
        }
        recInfo.setIsPledge(false);
        recInfo.setWageId(null);
        recInfo.setDigest(null);
        recInfo.setTransferDate(null);
        boolean NT011 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("NT011", (IObjectPK)new ObjectUuidPK(recInfo.getCompany().getId()));
        logger.error((Object)("\u53c2\u6570NTO11 = " + NT011));
        if (NT011) {
            recInfo.setBillState(BillStateEnum.Audit);
        } else {
            recInfo.setBillState(BillStateEnum.SAVED);
        }
    }

    private void afterProcessNoteCancel(Context ctx, List<ReceivableBillInfo> infoList, NoteReceivableDetail[] details) throws EASBizException, BOSException {
        CoreBaseCollection recColl = new CoreBaseCollection();
        for (int i = 0; i < infoList.size(); ++i) {
            ReceivableBillInfo recInfo = infoList.get(i);
            String detailSeqID = recInfo.getDetailSeqID();
            for (int j = 0; j < details.length; ++j) {
                NoteReceivableDetail detail = details[j];
                if (!detailSeqID.equals(detail.getDetailSeqID())) continue;
                recInfo.setBankReturnStatus(DraftBEUtil.transferState((String)detail.getEbStatus()));
                logger.error((Object)("\u8d28\u62bc\u5355\u64a4\u9500\u6210\u529f\u6807\u5fd7begin\uff1a\u94f6\u4f01\u8fd4\u56de\u7535\u7968\u72b6\u6001 = " + detail.getEbStatus()));
                if (recInfo.getBankReturnStatus() == BankReturnStatusEnum.BANK_SUCCESS) {
                    logger.error((Object)("\u8d28\u62bc\u5355\u64a4\u9500\u6210\u529f\u6807\u5fd7\uff1a\u94f6\u4f01\u8fd4\u56de\u7535\u7968\u72b6\u6001 = " + detail.getEbStatus()));
                    boolean NT011 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("NT011", (IObjectPK)new ObjectUuidPK(recInfo.getCompany().getId()));
                    if (NT011) {
                        recInfo.setBillState(BillStateEnum.Audit);
                    } else {
                        recInfo.setBillState(BillStateEnum.SAVED);
                    }
                }
                if (!EmptyUtil.isEmpty((String)detail.getNoteStatus())) {
                    recInfo.setElecBillStatus(ElecBillStatusEnum.getEnum((String)detail.getNoteStatus()));
                }
                recInfo.setBankReturnMsg(detail.getEbStatusMsg());
            }
            recColl.add((CoreBaseInfo)recInfo);
        }
        ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(recColl);
    }

    @Override
    protected Map _synBillStatus(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = FmBeWebUtils.getResource((Context)ctx, (String)"104_BILLSUM", (String[])new String[]{idSet.size() + ""});
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("billEntrys.*"));
        sic.add(new SelectorItemInfo("billEntrys.company.*"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.*"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.holderAccount.id"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.holderAccount.name"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.holderAccount.bankAccountNumber"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.id"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.name"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.number"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.endorseDate"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.company.*"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.endorsedCompany.*"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.endorsedSupplier.*"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.endorsedCustomer.*"));
        view.setSelector(sic);
        int success = 0;
        WageCollection coll = this.getWageCollection(ctx, view);
        NoteReceivableOpUtil recOpUtil = new NoteReceivableOpUtil();
        WageInfo info = null;
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            try {
                if (!info.isIsCommitToBE()) {
                    throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"062_CANNOT_SYNCSTATUS"));
                }
                TreeMap<String, List<ReceivableBillInfo>> batchSeqMap = new TreeMap<String, List<ReceivableBillInfo>>();
                for (int j = 0; j < info.getBillEntrys().size(); ++j) {
                    WageBillEntryInfo wageentryinfo = info.getBillEntrys().get(j);
                    ReceivableBillInfo entry = info.getBillEntrys().get(j).getReceivableBill();
                    String batchSeqID = entry.getBatchSeqID();
                    if (EmptyUtil.isEmpty((String)batchSeqID) || wageentryinfo.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL) {
                        throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"071_COMMITFAIL_CANNOT_SYNCSTATUS"));
                    }
                    ArrayList<ReceivableBillInfo> lst = (ArrayList<ReceivableBillInfo>)batchSeqMap.get(batchSeqID);
                    if (lst == null) {
                        lst = new ArrayList<ReceivableBillInfo>();
                    }
                    lst.add(entry);
                    batchSeqMap.put(batchSeqID, lst);
                }
                this.doSyncStatus(ctx, info, recOpUtil, batchSeqMap);
                ++success;
                result.setError(0);
                continue;
            }
            catch (Exception e) {
                result.setError(1);
                result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"058_SYNCSTATUS_FAILED", (String[])new String[]{info.getNumber(), e.getMessage()}));
            }
        }
        summary = success == idSet.size() ? summary + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"059_ALL_SYNCSTATUS_SUCCESS") : summary + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"060_SYNCSTATUS_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    private void doSyncStatus(Context ctx, WageInfo info, NoteReceivableOpUtil recOpUtil, Map<String, List<ReceivableBillInfo>> batchSeqMap) throws EASBizException, BOSException {
        CoreBaseCollection recColl = new CoreBaseCollection();
        for (String key : batchSeqMap.keySet()) {
            List<ReceivableBillInfo> infoList = batchSeqMap.get(key);
            NoteReceivableDetail[] details = this.queryRec(ctx, recOpUtil, infoList);
            if (details == null) {
                throw new NTPException(NTPException.BE_RECORD_NOTEXIST);
            }
            this.afterProcess4Sys(ctx, info, infoList, details, recColl);
        }
        CoreBaseCollection wageColl = new CoreBaseCollection();
        if (recColl != null && recColl.size() > 0) {
            wageColl.add((CoreBaseInfo)info);
            this.updateBatchData(ctx, wageColl);
            BillServerUtil.updateBizBillSettle((Context)ctx, (CoreBaseCollection)recColl);
            ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(recColl);
        }
    }

    private NoteReceivableDetail[] queryRec(Context ctx, NoteReceivableOpUtil recOpUtil, List<ReceivableBillInfo> infoList) throws BEException {
        NoteReceivableDetail[] details = null;
        NoteReceivableBody body = new NoteReceivableBody();
        body.setBatchSeqID(infoList.get(0).getBatchSeqID());
        String accNo = infoList.get(0).getHolderAccount().getBankAccountNumber();
        try {
            details = recOpUtil.queryNoteReceivable(ctx, accNo, body);
        }
        catch (BEException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            logger.error((Object)err);
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
        return details;
    }

    @Override
    protected Map _synForceStatus(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = FmBeWebUtils.getResource((Context)ctx, (String)"104_BILLSUM", (String[])new String[]{idSet.size() + ""});
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("billEntrys.*"));
        sic.add(new SelectorItemInfo("billEntrys.company.*"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.*"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.holderAccount.id"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.holderAccount.name"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.holderAccount.bankAccountNumber"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.id"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.name"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.number"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.endorseDate"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.company.*"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.endorsedCompany.*"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.endorsedSupplier.*"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.endorsedCustomer.*"));
        view.setSelector(sic);
        int success = 0;
        WageCollection coll = this.getWageCollection(ctx, view);
        NoteReceivableOpUtil recOpUtil = new NoteReceivableOpUtil();
        WageInfo info = null;
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            try {
                if (!info.isIsCommitToBE()) {
                    throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"062_CANNOT_SYNCSTATUS"));
                }
                TreeMap<String, List<ReceivableBillInfo>> batchSeqMap = new TreeMap<String, List<ReceivableBillInfo>>();
                for (int j = 0; j < info.getBillEntrys().size(); ++j) {
                    WageBillEntryInfo wageentryinfo = info.getBillEntrys().get(j);
                    ReceivableBillInfo entry = info.getBillEntrys().get(j).getReceivableBill();
                    String batchSeqID = entry.getBatchSeqID();
                    if (EmptyUtil.isEmpty((String)batchSeqID) || wageentryinfo.getBankReturnStatus() == BankReturnStatusEnum.COMMIT_FAIL) {
                        throw new RuntimeException(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"071_COMMITFAIL_CANNOT_SYNCSTATUS"));
                    }
                    ArrayList<ReceivableBillInfo> lst = (ArrayList<ReceivableBillInfo>)batchSeqMap.get(batchSeqID);
                    if (lst == null) {
                        lst = new ArrayList<ReceivableBillInfo>();
                    }
                    lst.add(entry);
                    batchSeqMap.put(batchSeqID, lst);
                }
                this.doForceSyncStatus(ctx, info, recOpUtil, batchSeqMap);
                ++success;
                result.setError(0);
                continue;
            }
            catch (Exception e) {
                result.setError(1);
                result.getDetailMsgList().add(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"058_SYNCSTATUS_FAILED", (String[])new String[]{info.getNumber(), e.getMessage()}));
            }
        }
        summary = success == idSet.size() ? summary + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"059_ALL_SYNCSTATUS_SUCCESS") : summary + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"060_SYNCSTATUS_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    private void doForceSyncStatus(Context ctx, WageInfo info, NoteReceivableOpUtil recOpUtil, Map<String, List<ReceivableBillInfo>> batchSeqMap) throws EASBizException, BOSException {
        CoreBaseCollection recColl = new CoreBaseCollection();
        for (String key : batchSeqMap.keySet()) {
            List<ReceivableBillInfo> infoList = batchSeqMap.get(key);
            NoteReceivableDetail[] details = this.queryForceRec(ctx, recOpUtil, infoList);
            if (details == null) {
                throw new NTPException(NTPException.BE_RECORD_NOTEXIST);
            }
            this.afterProcess4Sys(ctx, info, infoList, details, recColl);
        }
        CoreBaseCollection wageColl = new CoreBaseCollection();
        if (recColl != null && recColl.size() > 0) {
            wageColl.add((CoreBaseInfo)info);
            this.updateBatchData(ctx, wageColl);
            ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(recColl);
        }
    }

    private NoteReceivableDetail[] queryForceRec(Context ctx, NoteReceivableOpUtil recOpUtil, List<ReceivableBillInfo> infoList) throws BEException {
        NoteReceivableDetail[] details = null;
        NoteReceivableBody body = new NoteReceivableBody();
        body.setBatchSeqID(infoList.get(0).getBatchSeqID());
        body.setReserved1("enforcequery");
        String accNo = infoList.get(0).getHolderAccount().getBankAccountNumber();
        try {
            details = recOpUtil.queryNoteReceivable(ctx, accNo, body);
        }
        catch (BEException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            logger.error((Object)err);
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
        return details;
    }

    @Override
    protected void _editStatus(Context ctx, List statusList) throws BOSException, EASBizException {
        WageInfo info;
        ArrayList<ReceivableBillInfo> updateList = new ArrayList<ReceivableBillInfo>();
        Map listmap = (Map)statusList.get(0);
        String recId = (String)listmap.get("id");
        SelectorItemCollection recsic = new SelectorItemCollection();
        recsic.add(new SelectorItemInfo("wageid"));
        IReceivableBill iReceivableBill = ReceivableBillFactory.getLocalInstance((Context)ctx);
        ReceivableBillInfo recInfo = iReceivableBill.getReceivableBillInfo((IObjectPK)new ObjectUuidPK(recId), recsic);
        HashMap<String, WageBillEntryInfo> entryMap = new HashMap<String, WageBillEntryInfo>();
        if (recInfo != null && recInfo.getWageId() != null) {
            info = this.getWageInfoById(ctx, recInfo.getWageId().getId().toString());
            WageBillEntryCollection coll = info.getBillEntrys();
            for (int i = 0; i < coll.size(); ++i) {
                entryMap.put(coll.get(i).getReceivableBill().getId().toString(), coll.get(i));
            }
        } else {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"169_WageControllerBean", (Locale)ctx.getLocale()));
        }
        CoreBaseCollection wageEntryColl = new CoreBaseCollection();
        for (int i = 0; i < statusList.size(); ++i) {
            Map map = (Map)statusList.get(i);
            String id = (String)map.get("id");
            if (!entryMap.containsKey(id)) continue;
            WageBillEntryInfo entryInfo = (WageBillEntryInfo)entryMap.get(id);
            if (entryInfo.getBankReturnStatus() != BankReturnStatusEnum.BANK_EXCEPTION) {
                throw new BEException(BEException.UPDATESTATEERROR1);
            }
            entryInfo.getReceivableBill().setBankReturnStatus((BankReturnStatusEnum)map.get("bankReturnStatus"));
            updateList.add(entryInfo.getReceivableBill());
            if (!BankReturnStatusEnum.BANK_FAIL.equals((Object)((BankReturnStatusEnum)map.get("bankReturnStatus")))) continue;
            entryInfo.setIsCommitCancel(false);
            wageEntryColl.add((CoreBaseInfo)entryInfo);
        }
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)wageEntryColl)) {
            WageBillEntryFactory.getLocalInstance(ctx).updateBatchData(wageEntryColl);
        }
        logger.debug((Object)"begin to updateBeStatus wageInfo");
        NoteUpdateStautsUtil util = new NoteUpdateStautsUtil();
        NoteStatusBody body = new NoteStatusBody();
        body.setTotalCount(String.valueOf(updateList.size()));
        body.setDetails(this.parseUpdteDetail(ctx, updateList));
        try {
            NoteStatusDetail[] details = util.updateNoteStatus(ctx, null, body);
            this.afterProcess4Update(ctx, info, updateList, details);
        }
        catch (BEException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            logger.error((Object)err);
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
    }

    private WageInfo getWageInfoById(Context ctx, String id) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("billEntrys.*"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.detailSeqID"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.batchSeqID"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.bankReturnStatus"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.bankReturnMsg"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.elecBillStatus"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.company.id"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        WageCollection coll = WageFactory.getLocalInstance(ctx).getWageCollection(view);
        if (coll != null && coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    private NoteStatusDetail[] parseUpdteDetail(Context ctx, List<ReceivableBillInfo> updateList) {
        NoteStatusDetail[] details = new NoteStatusDetail[updateList.size()];
        for (int i = 0; i < updateList.size(); ++i) {
            ReceivableBillInfo recInfo = updateList.get(i);
            NoteStatusDetail detail = new NoteStatusDetail();
            detail.setDetailSeqID(recInfo.getDetailSeqID());
            detail.setBatchSeqID(recInfo.getBatchSeqID());
            detail.setEbStatus(recInfo.getBankReturnStatus().getName());
            detail.setEbNoteType("noteRecivable");
            detail.setUpdateReason(FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"065_EDITBESTATUS_BYHAND"));
            detail.setOperator(ContextUtil.getCurrentUserInfo((Context)ctx).getName());
            detail.setOrganizationName(ContextUtil.getCurrentFIUnit((Context)ctx).getName());
            details[i] = detail;
        }
        return details;
    }

    private void afterProcess4Update(Context ctx, WageInfo info, List<ReceivableBillInfo> updateList, NoteStatusDetail[] details) throws EASBizException, BOSException {
        int i;
        CoreBaseCollection recColl = new CoreBaseCollection();
        CoreBaseCollection wageColl = new CoreBaseCollection();
        HashSet<String> idSet = new HashSet<String>();
        int count = updateList.size();
        for (i = 0; i < count; ++i) {
            idSet.add(updateList.get(i).getId().toString());
        }
        for (i = 0; i < info.getBillEntrys().size(); ++i) {
            ReceivableBillInfo recInfo = info.getBillEntrys().get(i).getReceivableBill();
            WageBillEntryInfo wageBillEntryInfo = info.getBillEntrys().get(i);
            if (idSet != null && !idSet.contains(wageBillEntryInfo.getReceivableBill().getId().toString())) continue;
            String detailSeqID = recInfo.getDetailSeqID();
            for (int j = 0; j < details.length; ++j) {
                NoteStatusDetail detail = details[j];
                if (detailSeqID == null || !detailSeqID.equals(detail.getDetailSeqID())) continue;
                if (detail.getEbStatus().equals(BankReturnStatusEnum.BANK_SUCCESS.getName())) {
                    logger.error((Object)("\u8d28\u62bc\u64a4\u9500 \u662f\u5426\u6210\u529f detail.getReservedFiled2() = " + wageBillEntryInfo.isIsNoteCancel()));
                    if (wageBillEntryInfo.isIsCommitCancel()) {
                        this.setNoteCancelSign(ctx, info, recInfo, i, true);
                    } else {
                        wageBillEntryInfo.setElecBillStatus(ElecBillStatusEnum.NT180006);
                        recInfo.setElecBillStatus(ElecBillStatusEnum.NT180006);
                    }
                } else if (detail.getEbStatus().equals(BankReturnStatusEnum.BANK_FAIL.getName()) && !wageBillEntryInfo.isIsCommitCancel()) {
                    this.setNoteCancelSign(ctx, info, recInfo, i, false);
                } else if (detail.getEbStatus().equals(BankReturnStatusEnum.BANK_FAIL.getName()) && wageBillEntryInfo.isIsCommitCancel()) {
                    wageBillEntryInfo.setIsCommitCancel(false);
                }
                try {
                    if (!EmptyUtil.isEmpty((String)detail.getNoteStatus())) {
                        recInfo.setElecBillStatus(ElecBillStatusEnum.getEnum((String)detail.getNoteStatus()));
                        info.getBillEntrys().get(i).setElecBillStatus(ElecBillStatusEnum.getEnum((String)detail.getNoteStatus()));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                info.getBillEntrys().get(i).setBankReturnMsg(detail.getBankStatusMsg());
                info.getBillEntrys().get(i).setBankReturnStatus(DraftBEUtil.transferState((String)detail.getEbStatus()));
            }
            recColl.add((CoreBaseInfo)recInfo);
        }
        wageColl.add((CoreBaseInfo)info);
        this.updateBatchData(ctx, wageColl);
        ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(recColl);
    }

    private boolean isAllFail(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        boolean flag = true;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("relatedRecBills.bankReturnStatus");
        WageInfo info = this.getWageInfo(ctx, pk, this.getSelectors());
        ReceivableBillCollection coll = info.getRelatedRecBills();
        ReceivableBillInfo recInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            recInfo = coll.get(i);
            if (BankReturnStatusEnum.COMMIT_FAIL == recInfo.getBankReturnStatus() || BankReturnStatusEnum.BANK_FAIL == recInfo.getBankReturnStatus()) continue;
            flag = false;
            break;
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _noteCancels(Context ctx, List billIdList, HashSet entryIdSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        int entryCount = entryIdSet.size();
        String summary = ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"68_BondApplyBillWebFacadeControllerBean", (Locale)ctx.getLocale()) + entryCount + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"170_WageControllerBean", (Locale)ctx.getLocale());
        WageCollection coll = this.getWageCollByBill(ctx, new HashSet(billIdList));
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        int fail = 0;
        for (int i = 0; i < coll.size(); ++i) {
            WageInfo info = coll.get(i);
            WageBillEntryCollection entrys = info.getBillEntrys();
            WageBillEntryCollection noteEntrys = new WageBillEntryCollection();
            for (int j = 0; j < entrys.size(); ++j) {
                WageBillEntryInfo entry = entrys.get(j);
                if (!entryIdSet.contains(entry.getId().toString())) continue;
                noteEntrys.add(entry);
            }
            boolean isLock = iMutex.requestObjIDForUpdate(ctx, info.getId().toString());
            try {
                this.verifyNoteCancelHead(ctx, isLock, info);
            }
            catch (Exception e) {
                fail += noteEntrys.size();
                for (int m = 0; m < noteEntrys.size(); ++m) {
                    ReceivableBillInfo receivable = noteEntrys.get(m).getReceivableBill();
                    result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"171_WageControllerBean", (Locale)ctx.getLocale()) + receivable.getDraftNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"172_WageControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
                }
                if (!isLock) continue;
                iMutex.releaseObjIDForUpdate(ctx, info.getId().toString());
                continue;
            }
            try {
                TreeMap accNoMap = new TreeMap();
                for (int j = 0; j < noteEntrys.size(); ++j) {
                    WageBillEntryInfo entry = noteEntrys.get(j);
                    ReceivableBillInfo recBill = entry.getReceivableBill();
                    try {
                        this.verifyNoteCancelEntry(ctx, entry);
                    }
                    catch (Exception e) {
                        ++fail;
                        result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"171_WageControllerBean", (Locale)ctx.getLocale()) + recBill.getDraftNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"172_WageControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
                        entryIdSet.remove(entry.getId().toString());
                        continue;
                    }
                    String accNo = recBill.getHolderAccount().getBankAccountNumber();
                    ArrayList lst = (List)accNoMap.get(accNo);
                    if (lst == null) {
                        lst = new ArrayList();
                    }
                    lst.add(recBill);
                    accNoMap.put(accNo, lst);
                }
                if (accNoMap.size() == 0) continue;
                for (String accNo : accNoMap.keySet()) {
                    BigDecimal totalAmount = BigDecimal.ZERO;
                    List receivableList = (List)accNoMap.get(accNo);
                    for (ReceivableBillInfo receivable : receivableList) {
                        totalAmount = totalAmount.add(receivable.getBillAmt());
                    }
                    try {
                        this.doNoteCancle(ctx, accNo, totalAmount, receivableList, info, entryIdSet);
                    }
                    catch (Exception e) {
                        fail += receivableList.size();
                        for (int m = 0; m < receivableList.size(); ++m) {
                            ReceivableBillInfo receivable = (ReceivableBillInfo)receivableList.get(m);
                            result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"171_WageControllerBean", (Locale)ctx.getLocale()) + receivable.getDraftNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"172_WageControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
                        }
                    }
                }
                continue;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (isLock) {
                    iMutex.releaseObjIDForUpdate(ctx, info.getId().toString());
                }
            }
        }
        if (fail == 0) {
            result.setError(0);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"155_NoteCancle");
        } else {
            result.setError(1);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"156_NoteCancle", (String[])new String[]{String.valueOf(entryCount - fail), String.valueOf(fail)});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    private void verifyNoteCancelHead(Context ctx, boolean isLock, WageInfo info) throws NTException {
        if (!isLock) {
            throw new NTException(NTException.COMMON, new Object[]{FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI")});
        }
        if (!info.isIsCommitToBE()) {
            throw new NTException(NTException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"173_WageControllerBean", (Locale)ctx.getLocale())});
        }
    }

    private void verifyNoteCancelEntry(Context ctx, WageBillEntryInfo entry) throws NTException {
        if (!ElecBillStatusEnum.NT180001.equals((Object)entry.getElecBillStatus())) {
            throw new NTException(NTException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"174_WageControllerBean", (Locale)ctx.getLocale())});
        }
        if (entry.isIsCommitCancel()) {
            throw new NTException(NTException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"175_WageControllerBean", (Locale)ctx.getLocale())});
        }
    }

    @Override
    protected void _noteCancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        WageInfo info = this.getWageInfo(ctx, pk, this.getSelectors());
        TreeMap<String, ArrayList<ReceivableBillInfo>> accNoMap = new TreeMap<String, ArrayList<ReceivableBillInfo>>();
        for (int i = 0; i < info.getBillEntrys().size(); ++i) {
            ReceivableBillInfo entry = info.getBillEntrys().get(i).getReceivableBill();
            String accNo = entry.getHolderAccount().getBankAccountNumber();
            ArrayList<ReceivableBillInfo> lst = (ArrayList<ReceivableBillInfo>)accNoMap.get(accNo);
            if (lst == null) {
                lst = new ArrayList<ReceivableBillInfo>();
            }
            lst.add(entry);
            accNoMap.put(accNo, lst);
        }
        for (String accNo : accNoMap.keySet()) {
            BigDecimal totalAmount = BigDecimal.ZERO;
            List infoList = (List)accNoMap.get(accNo);
            for (ReceivableBillInfo entry : infoList) {
                totalAmount = totalAmount.add(entry.getBillAmt());
            }
            this.doNoteCancle(ctx, accNo, totalAmount, infoList, info, null);
        }
    }

    private void doNoteCancle(Context ctx, String accNo, BigDecimal totalAmount, List<ReceivableBillInfo> infoList, WageInfo info, HashSet idSet) throws BOSException, EASBizException {
        logger.debug((Object)"begin to noteCancle WageInfo");
        try {
            String[] serialNos = beServiceHelper.getSerialNumber((int)infoList.size());
            CoreBaseCollection recBillCollection = new CoreBaseCollection();
            StringBuffer noteNumber = new StringBuffer();
            for (int i = 0; i < infoList.size(); ++i) {
                ReceivableBillInfo receivableBillInfo = infoList.get(i);
                receivableBillInfo.setLastBatchSeq(receivableBillInfo.getBatchSeqID());
                receivableBillInfo.setLastDetailSeq(receivableBillInfo.getDetailSeqID());
                receivableBillInfo.setDetailSeqID(serialNos[i]);
                receivableBillInfo.setBatchSeqID(serialNos[0]);
                if (i < infoList.size() - 1) {
                    noteNumber.append(receivableBillInfo.getDraftNumber()).append(";");
                } else {
                    noteNumber.append(receivableBillInfo.getDraftNumber());
                }
                recBillCollection.add((CoreBaseInfo)receivableBillInfo);
            }
            ReceivableBillFactory.getLocalInstance((Context)ctx).updateBatchData(recBillCollection);
            logger.error((Object)("\u8d28\u62bc\u5355\u7684\u7968\u636e\u53f7\u7801 = " + noteNumber.toString()));
            NoteReceivableOpUtil noteReceivableOpUtil = new NoteReceivableOpUtil();
            NoteReceivableBody noteReceivableBody = this.parseNoteReceivableBody(ctx, totalAmount, infoList, info);
            NoteBizInfo bizInfo = new NoteBizInfo();
            bizInfo.setBankAcct(accNo);
            bizInfo.setNoteType(NoteTypeEnum.NOTE_CANCLE);
            logger.error((Object)"\u2014\u2014\u2014\u2014\u2014\u2014before noteCancle\u2014\u2014\u2014\u2014\u2014\u2014");
            NoteReceivableDetail[] noteReceivableDetails = noteReceivableOpUtil.noteRecOp(ctx, bizInfo, noteReceivableBody);
            logger.error((Object)"\u2014\u2014\u2014\u2014\u2014\u2014end noteCancle\u2014\u2014\u2014\u2014\u2014\u2014");
            for (int i = 0; i < info.getBillEntrys().size(); ++i) {
                WageBillEntryInfo wageBillEntryInfo = info.getBillEntrys().get(i);
                if (!idSet.contains(wageBillEntryInfo.getId().toString())) continue;
                wageBillEntryInfo.setIsCommitCancel(true);
            }
            this.afterProcess(ctx, info, infoList, noteReceivableDetails);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
    }

    private NoteDetailRequestBody parseNoteDetailRequestBody(Context ctx, WageInfo info, String number) {
        NoteDetailRequestBody body = new NoteDetailRequestBody();
        body.setNoteNo(number);
        body.setTranType("18");
        body.setPageNum("1");
        return body;
    }

    private NoteReceivableBody parseNoteReceivableBody(Context ctx, BigDecimal totalAmount, List<ReceivableBillInfo> infoList, WageInfo info) throws NTException {
        NoteReceivableBody body = new NoteReceivableBody();
        String seqID = infoList.get(0).getBatchSeqID();
        body.setBatchSeqID(seqID);
        body.setBatchBizNo(seqID);
        body.setTotalCount(String.valueOf(infoList.size()));
        body.setTotalAmount(totalAmount.setScale(2, 4).toString());
        body.setNoteReceiableDetail(this.parseNoteReceiableDetail(ctx, infoList, info));
        return body;
    }

    private NoteReceivableDetail[] parseNoteReceiableDetail(Context ctx, List<ReceivableBillInfo> infoList, WageInfo info) throws NTException {
        NoteReceivableDetail[] details = new NoteReceivableDetail[infoList.size()];
        for (int i = 0; i < infoList.size(); ++i) {
            ReceivableBillInfo entry = infoList.get(i);
            NoteReceivableDetail detail = new NoteReceivableDetail();
            detail.setDetailSeqID(entry.getDetailSeqID());
            detail.setDetailBizNo(entry.getDetailSeqID());
            detail.setOppAccNo(entry.getAcceptorAccountName());
            detail.setOppAccName(entry.getAcceptorName());
            detail.setOppBankName(entry.getAcceptorBankName());
            detail.setOppCnapsCode(entry.getAcceptorBankNum());
            detail.setOppAmount(info.getWageAmount().setScale(2, 4).toString());
            detail.setBillNo(entry.getDraftPackageNumber());
            detail.setDraftType(entry.getNtType().getGroup().equals((Object)NTTypeGroupEnum.PAYABLE_BankAccept) ? "AC01" : "AC02");
            logger.error((Object)("\u80cc\u4e66\u64a4\u9500\u65f6\uff0cDetail\u94f6\u884c\u53c2\u8003\u53f7\u4e3a\uff1a " + detail.getBankRefKey()));
            logger.error((Object)("\u80cc\u4e66\u64a4\u9500\u65f6\uff0c\u5e94\u6536\u7968\u636eID\u4e3a\uff1a " + entry.getId().toString()));
            logger.error((Object)("\u80cc\u4e66\u64a4\u9500\u65f6\uff0c\u5e94\u6536\u7968\u636eNTPYPEID\u4e3a\uff1a " + entry.getNtType().getId().toString()));
            logger.error((Object)("\u80cc\u4e66\u64a4\u9500\u65f6\uff0c\u5e94\u6536\u7968\u636e\u7684\u7968\u636e\u7c7b\u578b\u5206\u7ec4\u4e3a\uff1a " + entry.getNtType().getGroup().toString()));
            logger.error((Object)("\u80cc\u4e66\u64a4\u9500\u65f6\uff0cDraftType \u4e3a\uff1a " + detail.getDraftType()));
            if ("AC02".equals(detail.getDraftType()) && "33333333-3333-3333-3333-3333333333331C9A9013".equals(entry.getNtType().getId().toString())) {
                logger.error((Object)"reWriting DraftType to  AC01");
                detail.setDraftType("AC01");
            }
            detail.setTransferFlag(entry.isIsTransfer() ? "EM00" : "EM01");
            detail.setBookingDate(DraftBEUtil.date2String((Date)entry.getIssuesDate(), (String)"yyyyMMddHHmmss"));
            detail.setDueDate(DraftBEUtil.date2String((Date)entry.getExpiredDate(), (String)"yyyyMMdd"));
            detail.setIssueDate(DraftBEUtil.date2String((Date)entry.getIssuesDate(), (String)"yyyyMMdd"));
            if (entry.getElecBillStatus() != null) {
                detail.setNoteStatus(entry.getElecBillStatus().getValue());
            }
            detail.setDesc(info.getDescription());
            detail.setOperationCode("18");
            detail.setOperationName("\u8d28\u62bc\u64a4\u9500");
            if (entry.getSource().equals((Object)BillSourceEnum.BYNEW)) {
                BillServerUtil.setKeepFlag((NoteReceivableDetail)detail, (ReceivableBillInfo)entry);
                WageBillEntryCollection entrys = info.getBillEntrys();
                String keepFlag = detail.getKeepFlag();
                for (int j = 0; j < entrys.size(); ++j) {
                    WageBillEntryInfo entryInfo = entrys.get(j);
                    if (entryInfo.getReceivableBill() == null || !entryInfo.getReceivableBill().getId().toString().equals(entry.getId().toString()) || EmptyUtil.isEmpty((String)entryInfo.getReserveds())) continue;
                    String[] reserveds = entryInfo.getReserveds().split(";");
                    for (int k = 0; k < reserveds.length; ++k) {
                        String returnValue = reserveds[k].trim();
                        if (returnValue.toUpperCase(Locale.ENGLISH).startsWith("bankRefKey=".toUpperCase(Locale.ENGLISH))) {
                            keepFlag = keepFlag + ";" + returnValue;
                        }
                        if (!returnValue.toUpperCase(Locale.ENGLISH).startsWith("bankRefDate=".toUpperCase(Locale.ENGLISH))) continue;
                        keepFlag = keepFlag + ";" + returnValue;
                    }
                }
                detail.setKeepFlag(keepFlag);
            }
            details[i] = detail;
        }
        return details;
    }

    private WageCollection getWageColl(Context ctx, HashSet idSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billEntrys.id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("receivableBill.*"));
        sic.add(new SelectorItemInfo("receivableBill.ntType.*"));
        sic.add(new SelectorItemInfo("receivableBill.currency.*"));
        sic.add(new SelectorItemInfo("receivableBill.holderAccount.*"));
        sic.add(new SelectorItemInfo("receivableBill.company.*"));
        sic.add(new SelectorItemInfo("billEntrys.*"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.*"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.holderAccount.*"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.currency.*"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.ntType.*"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.company.*"));
        view.setSelector(sic);
        WageCollection coll = WageFactory.getLocalInstance(ctx).getWageCollection(view);
        return coll;
    }

    private WageCollection getWageCollByBill(Context ctx, HashSet idSet) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("Currency.*"));
        selector.add(new SelectorItemInfo("Institution.*"));
        selector.add(new SelectorItemInfo("billEntrys.receivableBill.*"));
        selector.add(new SelectorItemInfo("billEntrys.receivableBill.ntType.*"));
        selector.add(new SelectorItemInfo("billEntrys.receivableBill.holderAccount.id"));
        selector.add(new SelectorItemInfo("billEntrys.receivableBill.holderAccount.name"));
        selector.add(new SelectorItemInfo("billEntrys.receivableBill.holderAccount.bankAccountNumber"));
        selector.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.id"));
        selector.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.name"));
        selector.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.number"));
        selector.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.endorseDate"));
        selector.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.company.*"));
        selector.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.endorsedCompany.*"));
        selector.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.endorsedSupplier.*"));
        selector.add(new SelectorItemInfo("billEntrys.receivableBill.endorseBill.endorsedCustomer.*"));
        selector.add(new SelectorItemInfo("billEntrys.company.*"));
        selector.add(new SelectorItemInfo("billEntrys.*"));
        view.setSelector(selector);
        WageCollection coll = WageFactory.getLocalInstance(ctx).getWageCollection(view);
        return coll;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("relatedRecBills.*"));
        sic.add(new SelectorItemInfo("relatedRecBills.company.id"));
        sic.add(new SelectorItemInfo("relatedRecBills.company.name"));
        sic.add(new SelectorItemInfo("relatedRecBills.company.number"));
        sic.add(new SelectorItemInfo("relatedRecBills.holderAccount.id"));
        sic.add(new SelectorItemInfo("relatedRecBills.holderAccount.name"));
        sic.add(new SelectorItemInfo("relatedRecBills.holderAccount.bankAccountNumber"));
        sic.add(new SelectorItemInfo("relatedRecBills.ntType.*"));
        sic.add(new SelectorItemInfo("billEntrys.*"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.*"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.ntType.*"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.currency.*"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.holderAccount.*"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.company.id"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.billstate"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.isNoteCancel"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.isCommitCancel"));
        return sic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _updateEntryStatus(Context ctx, List idList, List statusList) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"68_BondApplyBillWebFacadeControllerBean", (Locale)ctx.getLocale()) + statusList.size() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"170_WageControllerBean", (Locale)ctx.getLocale());
        WageCollection coll = this.getWageCollByBill(ctx, new HashSet(idList));
        HashMap<String, BankReturnStatusEnum> entry_statusMap = new HashMap<String, BankReturnStatusEnum>();
        for (int i = 0; i < statusList.size(); ++i) {
            Map map = (Map)statusList.get(i);
            String id = (String)map.get("id");
            BankReturnStatusEnum status = (BankReturnStatusEnum)map.get("bankReturnStatus");
            entry_statusMap.put(id, status);
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        int fail = 0;
        for (int i = 0; i < coll.size(); ++i) {
            WageInfo info = coll.get(i);
            if (!info.isIsCommitToBE()) continue;
            ArrayList<ReceivableBillInfo> updateList = new ArrayList<ReceivableBillInfo>();
            WageBillEntryCollection entrys = info.getBillEntrys();
            for (int j = 0; j < entrys.size(); ++j) {
                WageBillEntryInfo entry = entrys.get(j);
                if (!entry_statusMap.keySet().contains(entry.getId().toString())) continue;
                ReceivableBillInfo receivableBill = entry.getReceivableBill();
                receivableBill.setBankReturnStatus((BankReturnStatusEnum)entry_statusMap.get(entry.getId().toString()));
                entry.setBankReturnStatus((BankReturnStatusEnum)entry_statusMap.get(entry.getId().toString()));
                updateList.add(receivableBill);
            }
            if (updateList.size() == 0) continue;
            boolean isLock = iMutex.requestObjIDForUpdate(ctx, info.getId().toString());
            try {
                if (!isLock) {
                    throw new NTException(NTException.COMMON, new Object[]{FmBeWebUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"431_AgentPayBillListUI")});
                }
                this.doUpdateStatus(ctx, updateList, info);
                continue;
            }
            catch (Exception e) {
                fail += updateList.size();
                for (int m = 0; m < updateList.size(); ++m) {
                    ReceivableBillInfo receivable = (ReceivableBillInfo)updateList.get(m);
                    result.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"171_WageControllerBean", (Locale)ctx.getLocale()) + receivable.getDraftNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"183_WageControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
                }
                continue;
            }
            finally {
                if (isLock) {
                    iMutex.releaseObjIDForUpdate(ctx, info.getId().toString());
                }
            }
        }
        if (fail == 0) {
            result.setError(0);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"074_ALL_UPDATESTATUS_SUCCESS");
        } else {
            result.setError(1);
            summary = summary + FmBeWebUtils.getResource((Context)ctx, (String)NTP_RES, (String)"075_UPDATESTATUS_RESULT", (String[])new String[]{String.valueOf(statusList.size() - fail), String.valueOf(fail)});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    private void doUpdateStatus(Context ctx, List<ReceivableBillInfo> updateList, WageInfo info) throws BEException {
        logger.debug((Object)"begin to updateBeStatus wageInfo");
        NoteUpdateStautsUtil util = new NoteUpdateStautsUtil();
        NoteStatusBody body = new NoteStatusBody();
        body.setTotalCount(String.valueOf(updateList.size()));
        body.setDetails(this.parseUpdteDetail(ctx, updateList));
        try {
            NoteStatusDetail[] details = util.updateNoteStatus(ctx, null, body);
            this.afterProcess4Update(ctx, info, updateList, details);
        }
        catch (BEException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (ServiceException e) {
            throw new BEException(BEException.COMMON, new Object[]{e.getMessage()});
        }
        catch (Exception err) {
            if (err.getCause() instanceof ConnectException) {
                throw new BEException(BEException.GETSERVICEFAILURE);
            }
            logger.error((Object)err);
            throw new BEException(BEException.COMMON, new Object[]{err.getMessage()});
        }
    }
}

