/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

public class FinHorizon {
    public static BigDecimal getHorizon(KDDatePicker dpBegin, KDDatePicker dpEnd) {
        if (dpBegin.getValue() == null || dpEnd.getValue() == null) {
            return Constants.ZERO;
        }
        Date beginDate = DateTimeUtils.truncateDate((Date)dpBegin.getSqlDate());
        Date endDate = DateTimeUtils.truncateDate((Date)dpEnd.getSqlDate());
        return FinHorizon.getHorizon(beginDate, endDate);
    }

    public static BigDecimal getHorizon(Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            return Constants.ZERO;
        }
        BigDecimal months = new BigDecimal("0");
        Calendar c1 = Calendar.getInstance();
        c1.setTime(beginDate);
        BigDecimal year1 = new BigDecimal(String.valueOf(c1.get(1)));
        BigDecimal month1 = new BigDecimal(String.valueOf(c1.get(2)));
        BigDecimal day1 = new BigDecimal(String.valueOf(c1.get(5)));
        Calendar c2 = Calendar.getInstance();
        c2.setTime(endDate);
        BigDecimal year2 = new BigDecimal(String.valueOf(c2.get(1)));
        BigDecimal month2 = new BigDecimal(String.valueOf(c2.get(2)));
        BigDecimal day2 = new BigDecimal(String.valueOf(c2.get(5)));
        BigDecimal begainDaysOfMonth = new BigDecimal(String.valueOf(DateTimeUtils.daysOfMonth((int)year1.intValue(), (int)(month1.intValue() + 1))));
        if (beginDate.getTime() < endDate.getTime()) {
            if (year1.compareTo(year2) == 0 && month1.compareTo(month2) == 0) {
                months = day2.subtract(day1).add(new BigDecimal(String.valueOf(1))).divide(begainDaysOfMonth, 4, 4);
                return months;
            }
            BigDecimal midMonths = new BigDecimal(String.valueOf(FinHorizon.monthDiff(beginDate, endDate)));
            months = months.add(midMonths);
            months = months.add(begainDaysOfMonth.add(new BigDecimal(String.valueOf(1))).subtract(day1).divide(begainDaysOfMonth, 4, 4));
            BigDecimal endDaysOfMonth = new BigDecimal(String.valueOf(DateTimeUtils.daysOfMonth((int)year2.intValue(), (int)(month2.intValue() + 1))));
            months = months.add(day2.divide(endDaysOfMonth, 4, 4));
            return months;
        }
        return months;
    }

    public static BigDecimal getHorizon(Context ctx, Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            return Constants.ZERO;
        }
        BigDecimal months = new BigDecimal("0");
        Calendar c1 = Calendar.getInstance();
        c1.setTime(beginDate);
        BigDecimal year1 = new BigDecimal(String.valueOf(c1.get(1)));
        BigDecimal month1 = new BigDecimal(String.valueOf(c1.get(2)));
        BigDecimal day1 = new BigDecimal(String.valueOf(c1.get(5)));
        Calendar c2 = Calendar.getInstance();
        c2.setTime(endDate);
        BigDecimal year2 = new BigDecimal(String.valueOf(c2.get(1)));
        BigDecimal month2 = new BigDecimal(String.valueOf(c2.get(2)));
        BigDecimal day2 = new BigDecimal(String.valueOf(c2.get(5)));
        BigDecimal begainDaysOfMonth = new BigDecimal(String.valueOf(DateTimeUtils.daysOfMonth((int)year1.intValue(), (int)(month1.intValue() + 1))));
        if (beginDate.getTime() < endDate.getTime()) {
            if (year1.compareTo(year2) == 0 && month1.compareTo(month2) == 0) {
                months = day2.subtract(day1).add(new BigDecimal(String.valueOf(1))).divide(begainDaysOfMonth, 4, 4);
                return months;
            }
            BigDecimal midMonths = new BigDecimal(String.valueOf(FinHorizon.monthDiff(beginDate, endDate)));
            months = months.add(midMonths);
            months = months.add(begainDaysOfMonth.add(new BigDecimal(String.valueOf(1))).subtract(day1).divide(begainDaysOfMonth, 4, 4));
            BigDecimal endDaysOfMonth = new BigDecimal(String.valueOf(DateTimeUtils.daysOfMonth((int)year2.intValue(), (int)(month2.intValue() + 1))));
            months = months.add(day2.divide(endDaysOfMonth, 4, 4));
            return months;
        }
        return months;
    }

    public static long monthDiff(Date begainDate, Date endDate) {
        int coef = 1;
        Calendar c3 = Calendar.getInstance();
        c3.set(1, begainDate.getYear());
        c3.set(2, begainDate.getMonth());
        c3.set(5, 1);
        c3.set(11, 0);
        c3.set(12, 0);
        c3.set(13, 0);
        c3.set(14, 0);
        Calendar c4 = Calendar.getInstance();
        c4.set(1, endDate.getYear());
        c4.set(2, endDate.getMonth());
        c4.set(5, 1);
        c4.set(11, 0);
        c4.set(12, 0);
        c4.set(13, 0);
        c4.set(14, 0);
        long nbOccurence = 0L;
        c3.add(2, 1);
        Date dateTemp = c3.getTime();
        while (dateTemp.getTime() < c4.getTime().getTime()) {
            c3.add(2, 1);
            dateTemp = c3.getTime();
            ++nbOccurence;
        }
        return nbOccurence * (long)coef;
    }
}

