/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.app.CASReceivingBillImportVerify;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class InnerAccountBillImportVerify {
    private static Logger logger = Logger.getLogger((String)CASReceivingBillImportVerify.class.getName());
    private static final String resourcePath = "com.kingdee.eas.fm.fs.client.InnerAccountResource";

    public void verifyHead(Context ctx, CoreBaseInfo head) throws BOSException {
        if (!(head instanceof InnerAccountInfo)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"16_AccountBankDataImportVerify", (Locale)ctx.getLocale()));
        }
        InnerAccountInfo innerAccountInfo = (InnerAccountInfo)head;
        this.checkEmpty(innerAccountInfo.getNumber(), "NumberIsNull", ctx);
        this.checkEmpty(innerAccountInfo.getName(), "NameIsNull", ctx);
        this.checkEmpty(innerAccountInfo.getApplyUnit(), "applyUnitIsNull", ctx);
        CompanyOrgUnitInfo company = innerAccountInfo.getApplyUnit();
        if (company != null && GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company)) {
            throw new BOSException(ResourceBase.getString((String)resourcePath, (String)"CanNotOnlyUnion", (Locale)ctx.getLocale()));
        }
        this.checkEmpty(innerAccountInfo.getAcctNumber(), "acctNumberIsNull", ctx);
        this.checkEmpty(innerAccountInfo.getOpenDepositDate(), "createDateIsNull", ctx);
        this.verifyOpenDate(innerAccountInfo.getOpenDepositDate(), innerAccountInfo, ctx);
        this.checkEmpty(innerAccountInfo.getType(), "acctPropertyIsNull", ctx);
        this.checkEmpty(innerAccountInfo.getAcctView(), "acctViewIsNull", ctx);
        this.checkEmpty(innerAccountInfo.getCtrlParam(), "ctrlParamIsNull", ctx);
        if (innerAccountInfo.getBoolean("isDefaultReck") && !innerAccountInfo.getBoolean("isReckoning")) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"102_InnerAccountUI", (Locale)ctx.getLocale()));
        }
        if (innerAccountInfo.getBoolean("isReckoning")) {
            this.verifyApplyUnit(innerAccountInfo, ctx);
        }
    }

    private void verifyApplyUnit(InnerAccountInfo innerAccountInfo, Context ctx) throws BOSException {
        CompanyOrgUnitInfo companyInfo = innerAccountInfo.getApplyUnit();
        if (companyInfo != null) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("relatedCompany.id", (Object)companyInfo.getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("inGroup", (Object)new Boolean(true)));
            if (innerAccountInfo.getClearingHouse() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("parentInGroup", (Object)innerAccountInfo.getClearingHouse().getId().toString()));
            }
            evi.setFilter(filterInfo);
            BankCollection coll = BankFactory.getLocalInstance((Context)ctx).getBankCollection(evi);
            if (coll == null || coll.size() == 0) {
                throw new BOSException(ResourceBase.getString((String)resourcePath, (String)"reckoningApplyUnitMustBeDown", (Locale)ctx.getLocale()));
            }
        }
    }

    private void checkEmpty(Object obj, String msg, Context ctx) throws BOSException {
        String text = obj.toString();
        if (obj == null || text.trim().equals("")) {
            throw new BOSException(msg + ResourceBase.getString((String)resourcePath, (String)msg, (Locale)ctx.getLocale()));
        }
    }

    private void verifyOpenDate(Date innerOpenDate, InnerAccountInfo innerAccountInfo, Context ctx) throws BOSException {
        if (!innerAccountInfo.getClearingHouse().isUsed()) {
            innerOpenDate = DateTimeUtils.truncateDate((Date)innerOpenDate);
            Date openDate = DateTimeUtils.truncateDate((Date)innerAccountInfo.getClearingHouse().getOpenDate());
            if (innerOpenDate != null && !innerOpenDate.before(openDate)) {
                throw new BOSException(ResourceBase.getString((String)resourcePath, (String)"OpenDateBig", (Locale)ctx.getLocale()));
            }
        }
    }
}

