/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fs.ISettlementBillBuilder;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SendRecAcctTypeEnum;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettleMutilTypeEnum;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.SettlementBillSourceEnum;
import com.kingdee.eas.fm.fs.SettlementEntryInfo;
import com.kingdee.eas.fm.fs.UpReckoningTypeEnum;
import com.kingdee.eas.framework.BillBaseInfo;
import org.apache.log4j.Logger;

public class SettleBillBuilder
implements ISettlementBillBuilder {
    private static final Logger logger = CoreUIObject.getLogger(SettleBillBuilder.class);

    public static SettleBillBuilder getInstance(SendRecAcctTypeEnum type, boolean isBackBill) {
        SettleBillBuilder builder = new SettleBillBuilder();
        return builder;
    }

    @Override
    public BillBaseInfo getBillBaseInfo(Context ctx, String billId) throws BOSException, EASBizException {
        return this.getSettlementBillInfo(ctx, billId);
    }

    @Override
    public SettlementBillInfo getSettlementBillInfo(Context ctx, String billId, String type) throws EASBizException, BOSException {
        SettlementBillInfo srcSettleInfo = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        SettlementBillInfo settleInfo = this.cloneInfo(srcSettleInfo);
        settleInfo.setId(BOSUuid.create((BOSObjectType)settleInfo.getBOSType()));
        settleInfo.setHasEffected(false);
        if (type.equals("PayeeInnerAcct")) {
            settleInfo.setCompany(srcSettleInfo.getPayeeInnerAcct().getApplyUnit());
            AccountBankInfo relAccountBank = this.getAccountBank(ctx, srcSettleInfo.getPayeeInnerAcct());
            if (relAccountBank != null) {
                settleInfo.setPayeeBankAcct(relAccountBank);
                settleInfo.setPayeeBankAcctNum(relAccountBank.getBankAccountNumber());
                settleInfo.setPayeeBank(relAccountBank.getBank().getName());
                settleInfo.setPayeeAcct(relAccountBank.getAccount());
            }
            settleInfo.setUpReckoningType(UpReckoningTypeEnum.PAYEEACCOUNTBANK);
            settleInfo.setPayerInnerAcct(null);
            settleInfo.setPayerBankAcct(null);
            settleInfo.setMutilType(settleInfo.genMutilType(ctx));
            SettleMutilTypeEnum mutilType = settleInfo.getMutilType();
            if (mutilType != SettleMutilTypeEnum.TRANS) {
                if (mutilType == SettleMutilTypeEnum.PAY) {
                    if (settleInfo.getFinPayeeInAcct() != null) {
                        BankInfo currentCleareHouse = BankFactory.getLocalInstance((Context)ctx).getClearingHouse(settleInfo.getCompany().getId().toString());
                        BankInfo finPayeeCleareHouse = settleInfo.getFinPayeeInAcct().getClearingHouse();
                        if (currentCleareHouse != null && finPayeeCleareHouse != null && currentCleareHouse.getId().equals((Object)finPayeeCleareHouse.getId())) {
                            settleInfo.setPayeeInnerAcct(settleInfo.getFinPayeeInAcct());
                            settleInfo.setInnerPayeeAcct(settleInfo.getFinPayeeInAcct().getAcctView());
                            settleInfo.setPayeeFullName(settleInfo.getFinPayeeInAcct().getApplyUnit().getName());
                        }
                    }
                } else if (mutilType == SettleMutilTypeEnum.REC) {
                    if (settleInfo.getFinPayerInAcct() != null) {
                        settleInfo.setPayerInnerAcct(settleInfo.getFinPayerInAcct());
                        settleInfo.setPayerFullName(settleInfo.getFinPayerInAcct().getApplyUnit().getName());
                    } else if (srcSettleInfo.getPayerInnerAcct() != null && !srcSettleInfo.getPayerInnerAcct().isIsReckoning()) {
                        settleInfo.setPayerInnerAcct(srcSettleInfo.getPayerInnerAcct());
                        settleInfo.setPayerFullName(srcSettleInfo.getPayerInnerAcct().getApplyUnit().getName());
                    }
                    if (settleInfo.getFinPayeeInAcct() != null) {
                        BankInfo currentCleareHouse = BankFactory.getLocalInstance((Context)ctx).getClearingHouse(settleInfo.getCompany().getId().toString());
                        BankInfo finPayeeCleareHouse = settleInfo.getFinPayeeInAcct().getClearingHouse();
                        if (currentCleareHouse != null && finPayeeCleareHouse != null && currentCleareHouse.getId().equals((Object)finPayeeCleareHouse.getId())) {
                            settleInfo.setPayeeInnerAcct(settleInfo.getFinPayeeInAcct());
                            settleInfo.setInnerPayeeAcct(settleInfo.getFinPayeeInAcct().getAcctView());
                            settleInfo.setPayeeFullName(settleInfo.getFinPayeeInAcct().getApplyUnit().getName());
                        }
                    }
                }
            }
        } else if (type.equals("PayerInnerAcct")) {
            settleInfo.setCompany(srcSettleInfo.getPayerInnerAcct().getApplyUnit());
            AccountBankInfo relAcountBank = this.getAccountBank(ctx, srcSettleInfo.getPayerInnerAcct());
            if (relAcountBank != null) {
                settleInfo.setPayerBankAcct(relAcountBank);
                settleInfo.setPayerBankAcctNum(relAcountBank.getBankAccountNumber());
                settleInfo.setPayerBank(relAcountBank.getBank().getName());
                settleInfo.setPayerAcct(relAcountBank.getAccount());
            }
            settleInfo.setUpReckoningType(UpReckoningTypeEnum.PAYERACCOUNTBANK);
            settleInfo.setPayerInnerAcct(null);
            settleInfo.setPayeeBankAcct(null);
            settleInfo.setMutilType(settleInfo.genMutilType(ctx));
            SettleMutilTypeEnum mutilType = settleInfo.getMutilType();
            if (mutilType != SettleMutilTypeEnum.TRANS) {
                if (mutilType == SettleMutilTypeEnum.PAY) {
                    if (settleInfo.getFinPayeeInAcct() != null) {
                        settleInfo.setPayeeInnerAcct(settleInfo.getFinPayeeInAcct());
                        settleInfo.setPayeeFullName(settleInfo.getFinPayeeInAcct().getApplyUnit().getName());
                    } else if (srcSettleInfo.getPayeeInnerAcct() != null && !srcSettleInfo.getPayeeInnerAcct().isIsReckoning()) {
                        settleInfo.setPayeeInnerAcct(srcSettleInfo.getPayeeInnerAcct());
                        settleInfo.setPayeeFullName(srcSettleInfo.getPayeeInnerAcct().getApplyUnit().getName());
                    }
                    if (settleInfo.getFinPayerInAcct() != null) {
                        BankInfo currentCleareHouse = BankFactory.getLocalInstance((Context)ctx).getClearingHouse(settleInfo.getCompany().getId().toString());
                        BankInfo finPayerCleareHouse = settleInfo.getFinPayerInAcct().getClearingHouse();
                        if (currentCleareHouse != null && finPayerCleareHouse != null && currentCleareHouse.getId().equals((Object)finPayerCleareHouse.getId())) {
                            settleInfo.setPayerInnerAcct(settleInfo.getFinPayerInAcct());
                            settleInfo.setInnerPayerAcct(settleInfo.getFinPayerInAcct().getAcctView());
                            settleInfo.setPayerFullName(settleInfo.getFinPayerInAcct().getApplyUnit().getName());
                        }
                    }
                } else if (mutilType == SettleMutilTypeEnum.REC && settleInfo.getFinPayerInAcct() != null) {
                    BankInfo currentCleareHouse = BankFactory.getLocalInstance((Context)ctx).getClearingHouse(settleInfo.getCompany().getId().toString());
                    BankInfo finPayerCleareHouse = settleInfo.getFinPayerInAcct().getClearingHouse();
                    if (currentCleareHouse != null && finPayerCleareHouse != null && currentCleareHouse.getId().equals((Object)finPayerCleareHouse.getId())) {
                        settleInfo.setPayerInnerAcct(settleInfo.getFinPayerInAcct());
                        settleInfo.setInnerPayerAcct(settleInfo.getFinPayerInAcct().getAcctView());
                        settleInfo.setPayerFullName(settleInfo.getFinPayerInAcct().getApplyUnit().getName());
                    }
                }
            }
        } else if (type.equals("PayeeBankAcct")) {
            settleInfo.setCompany(srcSettleInfo.getPayeeBankAcct().getBank().getRelatedCompany());
            settleInfo.setPayeeInnerAcct(srcSettleInfo.getPayeeBankAcct().getInnerAcct());
            settleInfo.setInnerPayeeAcct(srcSettleInfo.getPayeeBankAcct().getInnerAcct().getAcctView());
            settleInfo.setPayeeFullName(srcSettleInfo.getPayeeBankAcct().getInnerAcct().getApplyUnit().toString());
            settleInfo.setUpReckoningType(UpReckoningTypeEnum.PAYEEINNERACCT);
            settleInfo.setPayerInnerAcct(null);
            settleInfo.setPayeeBankAcct(null);
            settleInfo.setPayerBankAcct(null);
            InnerAccountInfo finPayerInnerAcct = srcSettleInfo.getFinPayerInAcct();
            if (finPayerInnerAcct != null && settleInfo.getCompany().equals((Object)finPayerInnerAcct.getCompany())) {
                settleInfo.setPayerInnerAcct(finPayerInnerAcct);
                settleInfo.setInnerPayerAcct(finPayerInnerAcct.getAcctView());
                settleInfo.setPayerFullName(finPayerInnerAcct.getApplyUnit().getName());
                settleInfo.setPayeeAcct(null);
                settleInfo.setPayeeBankAcct(null);
                settleInfo.setMutilType(SettleMutilTypeEnum.PAY);
            }
        } else if (type.equals("PayerBankAcct")) {
            settleInfo.setCompany(srcSettleInfo.getPayerBankAcct().getBank().getRelatedCompany());
            settleInfo.setPayerInnerAcct(srcSettleInfo.getPayerBankAcct().getInnerAcct());
            settleInfo.setInnerPayerAcct(srcSettleInfo.getPayerBankAcct().getInnerAcct().getAcctView());
            settleInfo.setPayerFullName(srcSettleInfo.getPayerBankAcct().getInnerAcct().getApplyUnit().toString());
            settleInfo.setUpReckoningType(UpReckoningTypeEnum.PAYERINNERACCT);
            settleInfo.setPayeeInnerAcct(null);
            settleInfo.setPayeeBankAcct(null);
            settleInfo.setPayerBankAcct(null);
            InnerAccountInfo finPayeeInnerAcct = srcSettleInfo.getFinPayeeInAcct();
            if (finPayeeInnerAcct != null && settleInfo.getCompany().equals((Object)finPayeeInnerAcct.getCompany())) {
                settleInfo.setPayeeInnerAcct(finPayeeInnerAcct);
                settleInfo.setInnerPayeeAcct(finPayeeInnerAcct.getAcctView());
                settleInfo.setPayeeFullName(finPayeeInnerAcct.getApplyUnit().getName());
                settleInfo.setPayerAcct(null);
                settleInfo.setPayerBankAcct(null);
                settleInfo.setMutilType(SettleMutilTypeEnum.REC);
            }
        }
        settleInfo.setMutilType(settleInfo.genMutilType(ctx));
        settleInfo.setSource(SettlementBillSourceEnum.SETTLEBILL);
        settleInfo.setSourceBillId(srcSettleInfo.getId().toString());
        if (settleInfo.getPayeeInnerAcct() == null && (SettBizTypeEnum.PAYOUTSIDE != settleInfo.getType() || SettBizTypeEnum.LINKPAY != settleInfo.getType())) {
            settleInfo.setPayeeFullName(null);
        }
        if (settleInfo.getPayerInnerAcct() == null && SettBizTypeEnum.RECOUTSIDE != settleInfo.getType()) {
            settleInfo.setPayerFullName(null);
        }
        return settleInfo;
    }

    private AccountBankInfo getAccountBank(Context ctx, InnerAccountInfo innerAcctInfo) {
        AccountBankInfo acctBankInfo = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("InnerAcct.id", (Object)innerAcctInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("bank.inGroup", (Object)new Boolean(true), CompareType.EQUALS));
        evi.setFilter(filter);
        try {
            evi.getSelector().add("*");
            evi.getSelector().add("bank.name");
            evi.getSelector().add("InnerAcct.*");
            AccountBankCollection coll = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(evi);
            if (coll != null && coll.size() == 1) {
                acctBankInfo = coll.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return acctBankInfo;
    }

    private SettlementBillInfo cloneInfo(SettlementBillInfo srcSettleInfo) {
        SettlementBillInfo settleInfo = new SettlementBillInfo();
        settleInfo.setType(srcSettleInfo.getType());
        settleInfo.setBizDate(srcSettleInfo.getBizDate());
        settleInfo.setSettleDate(srcSettleInfo.getSettleDate());
        settleInfo.setPayeeBankAcctNum(srcSettleInfo.getPayeeBankAcctNum());
        settleInfo.setPayerBankAcctNum(srcSettleInfo.getPayerBankAcctNum());
        settleInfo.setPayeePlanItem(srcSettleInfo.getPayeePlanItem());
        settleInfo.setPayerPlanItem(srcSettleInfo.getPayerPlanItem());
        settleInfo.setExchange(srcSettleInfo.getExchange());
        settleInfo.setApplyUnit(srcSettleInfo.getApplyUnit());
        settleInfo.setPayeeFullName(srcSettleInfo.getPayeeFullName());
        settleInfo.setPayerFullName(srcSettleInfo.getPayerFullName());
        settleInfo.setIsGenPaymentBill(false);
        settleInfo.setIsGenReceivingBill(false);
        settleInfo.setAppendix(srcSettleInfo.getAppendix());
        settleInfo.setIsRelateNT(srcSettleInfo.isIsRelateNT());
        settleInfo.setIsTransfer(srcSettleInfo.isIsTransfer());
        settleInfo.setCheque(srcSettleInfo.getCheque());
        settleInfo.setBizType(srcSettleInfo.getBizType());
        settleInfo.setPayeeBank(srcSettleInfo.getPayeeBank());
        settleInfo.setPayerBank(srcSettleInfo.getPayerBank());
        settleInfo.setCurrency(srcSettleInfo.getCurrency());
        settleInfo.setSettleType(srcSettleInfo.getSettleType());
        settleInfo.setInnerSetteType(srcSettleInfo.getInnerSetteType());
        settleInfo.setOuterSettleNumber(srcSettleInfo.getOuterSettleNumber());
        settleInfo.setInnerSettleNumber(srcSettleInfo.getInnerSettleNumber());
        settleInfo.setIsUrgent(srcSettleInfo.getIsUrgent());
        settleInfo.setIsDifferPlace(srcSettleInfo.getIsDifferPlace());
        settleInfo.setSettleAcceptCH(srcSettleInfo.getSettleAcceptCH());
        settleInfo.setSettleConfirmCH(srcSettleInfo.getSettleConfirmCH());
        settleInfo.setSrcSettlementBill(srcSettleInfo);
        settleInfo.setDescription(srcSettleInfo.getDescription());
        settleInfo.setAmount(srcSettleInfo.getAmount());
        settleInfo.setLocalAmt(srcSettleInfo.getLocalAmt());
        settleInfo.setHasEffected(true);
        settleInfo.setFiVouchered(false);
        settleInfo.setFinPayeeInAcct(srcSettleInfo.getFinPayeeInAcct());
        settleInfo.setFinPayeeBankAct(srcSettleInfo.getFinPayeeBankAct());
        settleInfo.setFinPayerInAcct(srcSettleInfo.getFinPayerInAcct());
        settleInfo.setFinPayerBankAct(srcSettleInfo.getFinPayerBankAct());
        settleInfo.setProject(srcSettleInfo.getProject());
        settleInfo.setFeeType(srcSettleInfo.getFeeType());
        settleInfo.setPayerProject(srcSettleInfo.getPayerProject());
        settleInfo.setPayerFeeType(srcSettleInfo.getPayerFeeType());
        settleInfo.setUsage(srcSettleInfo.getUsage());
        settleInfo.setSourceBillNumber(srcSettleInfo.getSourceBillNumber());
        settleInfo.setIsHaveEntrys(srcSettleInfo.isIsHaveEntrys());
        for (int i = 0; i < srcSettleInfo.getEntrys().size(); ++i) {
            SettlementEntryInfo srcEntryInfo = srcSettleInfo.getEntrys().get(i);
            SettlementEntryInfo entryInfo = (SettlementEntryInfo)srcEntryInfo.clone();
            entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
            entryInfo.setSettlementBill(settleInfo);
            settleInfo.getEntrys().add(entryInfo);
        }
        return settleInfo;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("payeeInnerAcct.*");
        sic.add("payeeInnerAcct.applyUnit.id");
        sic.add("payeeInnerAcct.applyUnit.name");
        sic.add("payeeInnerAcct.applyUnit.number");
        sic.add("payerInnerAcct.*");
        sic.add("payerInnerAcct.applyUnit.id");
        sic.add("payerInnerAcct.applyUnit.name");
        sic.add("payerInnerAcct.applyUnit.number");
        sic.add("finPayeeInAcct.clearingHouse");
        sic.add("finPayerInAcct.clearingHouse");
        sic.add("finPayeeInAcct.clearingHouse.longNumberInGroup");
        sic.add("finPayerInAcct.clearingHouse.longNumberInGroup");
        sic.add("finPayeeInAcct.company.id");
        sic.add("finPayerInAcct.company.id");
        sic.add("finPayeeInAcct.applyUnit.id");
        sic.add("finPayerInAcct.applyUnit.id");
        sic.add("finPayeeInAcct.applyUnit.name");
        sic.add("finPayerInAcct.applyUnit.name");
        sic.add("finPayeeInAcct.acctView.id");
        sic.add("finPayerInAcct.acctView.id");
        sic.add("payeeBankAcct.*");
        sic.add("payeeBankAcct.InnerAcct.*");
        sic.add("payeeBankAcct.InnerAcct.applyUnit.name");
        sic.add("payeeBankAcct.InnerAcct.acctView.id");
        sic.add("payeeBankAcct.InnerAcct.acctView.number");
        sic.add("payeeBankAcct.InnerAcct.acctView.name");
        sic.add("payeeBankAcct.bank.relatedCompany.id");
        sic.add("payeeBankAcct.bank.relatedCompany.name");
        sic.add("payeeBankAcct.bank.relatedCompany.number");
        sic.add("payerBankAcct.*");
        sic.add("payerBankAcct.InnerAcct.*");
        sic.add("payerBankAcct.InnerAcct.applyUnit.name");
        sic.add("payerBankAcct.InnerAcct.acctView.id");
        sic.add("payerBankAcct.InnerAcct.acctView.number");
        sic.add("payerBankAcct.InnerAcct.acctView.name");
        sic.add("payerBankAcct.bank.relatedCompany.id");
        sic.add("payerBankAcct.bank.relatedCompany.name");
        sic.add("payerBankAcct.bank.relatedCompany.number");
        sic.add("entrys.*");
        return sic;
    }

    @Override
    public SettlementBillInfo getSettlementBillInfo(Context ctx, String billId) throws EASBizException, BOSException {
        return null;
    }
}

