/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import java.util.Set;

public class SettlementBillFilterParam
implements FilterParam {
    private static final long serialVersionUID = -5675370985511461655L;
    private transient boolean isBOTP;
    private String companyid;
    private String[] companyIdAry;
    private Date dateFrom;
    private Date dateTo;
    private int bizType;
    private String currencyId;
    private Set innerAcctIdSet;
    private int isAcceptted;
    private int isSettled;
    boolean isQuery = false;

    public String[] getCompanyIdAry() {
        return this.companyIdAry;
    }

    public void setCompanyIdAry(String[] companyIdAry) {
        this.companyIdAry = companyIdAry;
    }

    public int getBizType() {
        return this.bizType;
    }

    public void setBizType(int bizType) {
        this.bizType = bizType;
    }

    public String getCompanyid() {
        return this.companyid;
    }

    public void setCompanyid(String companyid) {
        this.companyid = companyid;
    }

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    public Date getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }

    public int getIsAcceptted() {
        return this.isAcceptted;
    }

    public void setIsAcceptted(int isAcceptted) {
        this.isAcceptted = isAcceptted;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public String getcurrencyId() {
        return this.currencyId;
    }

    public FilterInfo getFilter() {
        FilterInfo info = new FilterInfo();
        if (this.dateFrom == null || this.dateTo == null) {
            return info;
        }
        this.dateFrom = DateTimeUtils.truncateDate((Date)this.dateFrom);
        info.getFilterItems().add(new FilterItemInfo("bizDate", (Object)this.dateFrom, CompareType.GREATER_EQUALS));
        this.dateTo = DateTimeUtils.truncateDate((Date)this.dateTo);
        this.dateTo = DateUtil.getNextDay((Date)this.dateTo);
        info.getFilterItems().add(new FilterItemInfo("bizDate", (Object)this.dateTo, CompareType.LESS));
        if (this.bizType != -1) {
            info.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(this.bizType)));
        }
        if (this.isAcceptted != -1) {
            info.getFilterItems().add(new FilterItemInfo("isAccepted", (Object)new Integer(this.isAcceptted)));
        }
        if (this.isBOTP) {
            return info;
        }
        if (this.isSettled == 1) {
            info.getFilterItems().add(new FilterItemInfo("cashier.name", null));
        } else if (this.isSettled == 0) {
            info.getFilterItems().add(new FilterItemInfo("cashier.name", null, CompareType.NOTEQUALS));
        }
        if (this.isQuery) {
            info.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)FMHelper.asSet((String[])this.getCompanyIdAry()), CompareType.INCLUDE));
        } else {
            String currentCompanyId = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
            info.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompanyId, CompareType.INCLUDE));
        }
        if (this.currencyId != null) {
            info.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.currencyId));
        }
        if (this.innerAcctIdSet != null && this.innerAcctIdSet.size() > 0) {
            FilterInfo innerAcctFilter = new FilterInfo();
            innerAcctFilter.getFilterItems().add(new FilterItemInfo("payeeInnerAcct.id", (Object)this.innerAcctIdSet, CompareType.INCLUDE));
            innerAcctFilter.getFilterItems().add(new FilterItemInfo("payerInnerAcct.id", (Object)this.innerAcctIdSet, CompareType.INCLUDE));
            innerAcctFilter.setMaskString("#0 OR #1");
            try {
                info.mergeFilter(innerAcctFilter, "and");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return info;
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection sorters = new SorterItemCollection();
        sorters.add(new SorterItemInfo("id"));
        return sorters;
    }

    public boolean isBOTP() {
        return this.isBOTP;
    }

    public void setBOTP(boolean isBOTP) {
        this.isBOTP = isBOTP;
    }

    public void setInnerAcctId(Set innerAcctId) {
        this.innerAcctIdSet = innerAcctId;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public Set getInnerAcctId() {
        return this.innerAcctIdSet;
    }

    public int getIsSettled() {
        return this.isSettled;
    }

    public void setIsSettled(int isSettled) {
        this.isSettled = isSettled;
    }

    public boolean isQuery() {
        return this.isQuery;
    }

    public void setQuery(boolean isQuery) {
        this.isQuery = isQuery;
    }
}

