/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.util.BOTObjectCache;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.IPaymentDisposer;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.ISettlementBill;
import com.kingdee.eas.fm.fs.SettlementBillCollection;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SettlementPaymentDisposer
implements IPaymentDisposer {
    public BigDecimal getCashRebate(Date billDate, BigDecimal apAmount, String srcBillId, String srcBillEntryId) {
        return null;
    }

    public void dispose(Context ctx, BillDisposerAction action) throws BOSException, EASBizException {
        SettlementBillInfo settlementBillInfo;
        int i;
        PaymentBillInfo info = (PaymentBillInfo)action.getDestBill();
        Iterator it = info.getEntries().iterator();
        HashSet<String> idSet = new HashSet<String>();
        while (it.hasNext()) {
            PaymentBillEntryInfo entryInfo = (PaymentBillEntryInfo)it.next();
            idSet.add(entryInfo.getSourceBillId());
        }
        ISettlementBill iSettlement = SettlementBillFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.setSelector(this.getSelector());
        SettlementBillCollection settleColl = iSettlement.getSettlementBillCollection(evi);
        if (action.getActionType().equals((Object)DisposerActionEnum.DELETE)) {
            for (i = 0; i < settleColl.size(); ++i) {
                settlementBillInfo = settleColl.get(i);
                settlementBillInfo.setIsGenPaymentBill(false);
                if (!SettlementPaymentDisposer.isApplyUnitEqual(settlementBillInfo)) continue;
                settlementBillInfo.setIsGenReceivingBill(false);
            }
        } else if (action.getActionType().equals((Object)DisposerActionEnum.SAVE) || action.getActionType().equals((Object)DisposerActionEnum.SUBMIT)) {
            for (i = 0; i < settleColl.size(); ++i) {
                Set destBillIDSet;
                settlementBillInfo = settleColl.get(i);
                if (settlementBillInfo != null && settlementBillInfo.isIsGenPaymentBill() && (destBillIDSet = FMHelper.getDestBillIdSet((Context)ctx, (String)settlementBillInfo.getId().toString())) != null && destBillIDSet.size() > 0) {
                    for (String destID : destBillIDSet) {
                        boolean isSameBill;
                        if (FMHelper.isEmpty((String)destID)) continue;
                        boolean isPayBill = BOSUuid.read((String)destID).getType().equals((Object)new PaymentBillInfo().getBOSType());
                        boolean bl = isSameBill = info.getId() != null && destID.equals(info.getId().toString());
                        if (!isPayBill || info.getId() != null && isSameBill) continue;
                        throw new RecPayException(RecPayException.SETTLEHASGENPAYBILL, new Object[]{settlementBillInfo.getNumber()});
                    }
                }
                settlementBillInfo.setIsGenPaymentBill(true);
                if (!SettlementPaymentDisposer.isApplyUnitEqual(settlementBillInfo)) continue;
                settlementBillInfo.setIsGenReceivingBill(true);
            }
        }
        for (i = 0; i < settleColl.size(); ++i) {
            settlementBillInfo = settleColl.get(i);
            iSettlement.update((IObjectPK)new ObjectUuidPK(settlementBillInfo.getId()), (CoreBaseInfo)settlementBillInfo);
            IObjectValue srcObj = BOTObjectCache.getInstance((Context)ctx).get(settlementBillInfo.getId().toString());
            if (srcObj == null) continue;
            srcObj.putAll((IObjectValue)settlementBillInfo);
        }
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("payeeInnerAcct.*");
        sic.add("payerInnerAcct.*");
        return sic;
    }

    public static boolean isApplyUnitEqual(SettlementBillInfo settleInfo) {
        String payerApplyUnitId;
        if (settleInfo.getPayeeInnerAcct() == null || settleInfo.getPayerInnerAcct() == null) {
            return false;
        }
        String payeeApplyUnitId = settleInfo.getPayeeInnerAcct().getApplyUnit().getId().toString();
        return payeeApplyUnitId.equals(payerApplyUnitId = settleInfo.getPayerInnerAcct().getApplyUnit().getId().toString());
    }
}

