/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.util.BOTObjectCache;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.IReceivingDisposer;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.ISettlementBill;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.SettlementPaymentDisposer;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

public class SettlementReceivingDisposer
implements IReceivingDisposer {
    public BigDecimal getCashRebate(Date billDate, BigDecimal arAmount, String srcBillId, String srcBillEntryId) {
        return null;
    }

    public void dispose(Context ctx, BillDisposerAction action) throws BOSException, EASBizException {
        ReceivingBillInfo info = (ReceivingBillInfo)action.getDestBill();
        String sourceBillId = info.getEntries().get(0).getSourceBillId();
        ISettlementBill iSettlement = SettlementBillFactory.getLocalInstance(ctx);
        SettlementBillInfo settlementBillInfo = iSettlement.getSettlementBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)sourceBillId)), this.getSelector());
        if (action.getActionType().equals((Object)DisposerActionEnum.DELETE)) {
            settlementBillInfo.setIsGenReceivingBill(false);
            if (SettlementPaymentDisposer.isApplyUnitEqual(settlementBillInfo)) {
                settlementBillInfo.setIsGenPaymentBill(false);
            }
        } else if (action.getActionType().equals((Object)DisposerActionEnum.SAVE) || action.getActionType().equals((Object)DisposerActionEnum.SUBMIT)) {
            Set destBillIDSet;
            if (settlementBillInfo != null && settlementBillInfo.isIsGenReceivingBill() && (destBillIDSet = FMHelper.getDestBillIdSet((Context)ctx, (String)settlementBillInfo.getId().toString())) != null && destBillIDSet.size() > 0) {
                for (String destID : destBillIDSet) {
                    boolean isSameBill;
                    if (FMHelper.isEmpty((String)destID)) continue;
                    boolean isRecBill = BOSUuid.read((String)destID).getType().equals((Object)new ReceivingBillInfo().getBOSType());
                    boolean bl = isSameBill = info.getId() != null && destID.equals(info.getId().toString());
                    if (!isRecBill || info.getId() != null && isSameBill) continue;
                    throw new RecPayException(RecPayException.SETTLEHASGENRECBILL, new Object[]{settlementBillInfo.getNumber()});
                }
            }
            settlementBillInfo.setIsGenReceivingBill(true);
            if (SettlementPaymentDisposer.isApplyUnitEqual(settlementBillInfo)) {
                settlementBillInfo.setIsGenPaymentBill(true);
            }
        }
        iSettlement.update((IObjectPK)new ObjectUuidPK(settlementBillInfo.getId()), (CoreBaseInfo)settlementBillInfo);
        IObjectValue srcObj = BOTObjectCache.getInstance((Context)ctx).get(settlementBillInfo.getId().toString());
        if (srcObj != null) {
            srcObj.putAll((IObjectValue)settlementBillInfo);
        }
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("payeeInnerAcct.*");
        sic.add("payerInnerAcct.*");
        return sic;
    }
}

