/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.BankTransUpBillEntryInfo;
import com.kingdee.eas.fm.be.BankTransUpBillInfo;
import com.kingdee.eas.fm.be.BillTypeEnum;
import com.kingdee.eas.fm.be.IBankTransUpBillBuilder;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.fs.ITransUpBill;
import com.kingdee.eas.fm.fs.TransUpBillEntryInfo;
import com.kingdee.eas.fm.fs.TransUpBillFactory;
import com.kingdee.eas.fm.fs.TransUpBillInfo;
import java.sql.Timestamp;
import java.util.Calendar;

public class TransUpBill2BankBillBuilder
implements IBankTransUpBillBuilder {
    public BankTransUpBillInfo getBankTransUpBillInfo(Context ctx, String billId) throws BOSException, EASBizException {
        ITransUpBill iTransUpBill = TransUpBillFactory.getLocalInstance(ctx);
        TransUpBillInfo info = iTransUpBill.getTransUpBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        BankTransUpBillInfo bankTransUpInfo = new BankTransUpBillInfo();
        bankTransUpInfo.setSrcBillNumber(info.getNumber());
        bankTransUpInfo.setSourceBillId(info.getId().toString());
        bankTransUpInfo.setSrcBillType(BillTypeEnum.transUpBill);
        bankTransUpInfo.setCompany(info.getCompany());
        Timestamp time = new Timestamp(Calendar.getInstance().getTimeInMillis());
        bankTransUpInfo.setSubmitTime(time);
        bankTransUpInfo.setBizDate(info.getBizDate());
        bankTransUpInfo.setExpectTransTime(time);
        bankTransUpInfo.setCurrency(info.getCurrency());
        bankTransUpInfo.setTotalAmt(info.getTotalAmt());
        bankTransUpInfo.setTotalCounts(info.getTotalCounts());
        bankTransUpInfo.setState(BankPayingBillStateEnum.OS);
        bankTransUpInfo.setDescription(info.getDescription());
        bankTransUpInfo.setMotherAcctBank(info.getMotherAcctBank());
        bankTransUpInfo.setUsage(info.getUsage());
        bankTransUpInfo.setIsUrgent(info.isIsUrgent());
        bankTransUpInfo.setBankInterfaceType(info.getMotherAcctBank().getBankInterfaceType());
        bankTransUpInfo.setRecProvince(info.getRecProvince());
        bankTransUpInfo.setRecCity(info.getRecCity());
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            TransUpBillEntryInfo TransUpBillEntryInfo2 = info.getEntrys().get(i);
            BankTransUpBillEntryInfo BankTransUpBillEntryInfo2 = new BankTransUpBillEntryInfo();
            BankTransUpBillEntryInfo2.setParent(bankTransUpInfo);
            BankTransUpBillEntryInfo2.setUnitAcctBank(TransUpBillEntryInfo2.getUnitAcctBank());
            BankTransUpBillEntryInfo2.setUnit(TransUpBillEntryInfo2.getUnit());
            BankTransUpBillEntryInfo2.setAmount(TransUpBillEntryInfo2.getAmount());
            BankTransUpBillEntryInfo2.setSrcBillNumber(TransUpBillEntryInfo2.getId().toString());
            bankTransUpInfo.setSrcBillType(BillTypeEnum.transUpBill);
            Timestamp entryTime = new Timestamp(Calendar.getInstance().getTimeInMillis());
            BankTransUpBillEntryInfo2.setSubmitTime(entryTime);
            BankTransUpBillEntryInfo2.setExpectTransTime(time);
            BankTransUpBillEntryInfo2.setState(BankPayingBillStateEnum.OS);
            BankTransUpBillEntryInfo2.setIsBitBack(false);
            if (TransUpBillEntryInfo2.getUnitAcctBank() != null) {
                BankTransUpBillEntryInfo2.setBankInterfaceType(TransUpBillEntryInfo2.getUnitAcctBank().getBankInterfaceType());
            }
            BankTransUpBillEntryInfo2.setDescription(TransUpBillEntryInfo2.getDescription());
            String[] serialNumbers = beServiceHelper.getSerialNumber((int)1);
            BankTransUpBillEntryInfo2.setSerialNumber(serialNumbers[0]);
            bankTransUpInfo.getEntrys().add(BankTransUpBillEntryInfo2);
        }
        return bankTransUpInfo;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("motherAcctBank.id"));
        sic.add(new SelectorItemInfo("motherAcctBank.bank"));
        sic.add(new SelectorItemInfo("motherAcctBank.company"));
        sic.add(new SelectorItemInfo("motherAcctBank.bankInterfaceType"));
        sic.add(new SelectorItemInfo("motherAcctBank.openArea"));
        sic.add(new SelectorItemInfo("motherAcctBank.*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.unitAcctBank.*"));
        sic.add(new SelectorItemInfo("entrys.unit.*"));
        sic.add(new SelectorItemInfo("entrys.subAcct.*"));
        return sic;
    }
}

