/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.btp.app.BOTOrgUtils;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.bond.BondUtil;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.fs.ApplyTransDownCollection;
import com.kingdee.eas.fm.fs.ApplyTransDownFactory;
import com.kingdee.eas.fm.fs.ApplyTransDownInfo;
import com.kingdee.eas.fm.fs.ApplyTransDownStateEnum;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.TransDownBillEntryInfo;
import com.kingdee.eas.fm.fs.TransDownBillInfo;
import com.kingdee.eas.fm.fs.app.AbstractApplyTransDownControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ApplyTransDownControllerBean
extends AbstractApplyTransDownControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fs.app.ApplyTransDownControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ApplyTransDownInfo oldInfo;
        ApplyTransDownInfo info = (ApplyTransDownInfo)model;
        if (info != null && info.getId() != null && ApplyTransDownFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId())) && (oldInfo = ApplyTransDownFactory.getLocalInstance(ctx).getApplyTransDownInfo((IObjectPK)new ObjectUuidPK(info.getId()))) != null && ApplyTransDownStateEnum.AUDIT.equals((Object)oldInfo.getState())) {
            throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"201_ApplyTransDownControllerBean", (Locale)ctx.getLocale())});
        }
        if (FMHelper.isEmpty((String)info.getNumber())) {
            try {
                String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
                info.setNumber(numberSilent);
            }
            catch (Exception ex) {
                throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"202_ApplyTransDownControllerBean", (Locale)ctx.getLocale())});
            }
        }
        this._checkNumberDup(ctx, (IObjectValue)info);
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ApplyTransDownInfo oldInfo;
        ApplyTransDownInfo info = (ApplyTransDownInfo)model;
        ObjectUuidPK pk = new ObjectUuidPK(info.getId());
        if (info != null && info.getId() != null && ApplyTransDownFactory.getLocalInstance(ctx).exists((IObjectPK)pk) && (oldInfo = ApplyTransDownFactory.getLocalInstance(ctx).getApplyTransDownInfo((IObjectPK)pk)) != null && ApplyTransDownStateEnum.AUDIT.equals((Object)oldInfo.getState())) {
            throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"201_ApplyTransDownControllerBean", (Locale)ctx.getLocale())});
        }
        if (FMHelper.isEmpty((String)info.getNumber())) {
            try {
                String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
                info.setNumber(numberSilent);
            }
            catch (Exception ex) {
                throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"202_ApplyTransDownControllerBean", (Locale)ctx.getLocale())});
            }
        }
        if (!ApplyTransDownStateEnum.AUDIT.equals((Object)info.getState())) {
            info.setState(ApplyTransDownStateEnum.SUBMIT);
        }
        this._checkNumberDup(ctx, (IObjectValue)info);
        IObjectPK retPK = super._submit(ctx, (IObjectValue)info);
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)info);
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)retPK, (IFMBgUsed)info);
        FmMbgHelper.requestBudget((Context)ctx, (IObjectPK)retPK);
        return retPK;
    }

    @Override
    protected void _audit(Context ctx, Set idSet) throws BOSException, EASBizException {
        for (String id : idSet) {
            this.audit4WF(ctx, (IObjectPK)new ObjectUuidPK(id));
        }
    }

    @Override
    protected void _cancelAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("state"));
        view.getSelector().add(new SelectorItemInfo("auditDate"));
        ApplyTransDownCollection colls = ApplyTransDownFactory.getLocalInstance(ctx).getApplyTransDownCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            ApplyTransDownInfo info = colls.get(i);
            Set descSet = FMHelper.getDestBillIdSet((Context)ctx, (String)info.getId().toString());
            if (!info.getState().equals((Object)ApplyTransDownStateEnum.AUDIT) || descSet.size() > 0) {
                throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"203_ApplyTransDownControllerBean", (Locale)ctx.getLocale())});
            }
            info.setAuditor(null);
            info.setAuditDate(null);
            info.setState(ApplyTransDownStateEnum.SAVE);
            ApplyTransDownFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
            this.cancelAudit4WF(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ApplyTransDownInfo info = this.getApplyTransDownInfo(ctx, pk);
        if (!info.getState().equals((Object)ApplyTransDownStateEnum.SAVE) && !info.getState().equals((Object)ApplyTransDownStateEnum.SUBMIT)) {
            throw new FSException(FSException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"204_ApplyTransDownControllerBean", (Locale)ctx.getLocale())});
        }
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
        FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)pk);
        super._delete(ctx, pk);
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("auditDate"));
        sic.add(new SelectorItemInfo("transCompany.id"));
        sic.add(new SelectorItemInfo("company.id"));
        ApplyTransDownInfo info = ApplyTransDownFactory.getLocalInstance(ctx).getApplyTransDownInfo(pk, sic);
        Context newCtx = null;
        try {
            newCtx = BOTOrgUtils.switchOrg((Context)ctx, (String)info.getCompany().getId().toString());
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        boolean hasWFInstance = ApplyTransDownControllerBean.hasWFInstance(ctx, info.getId().toString());
        if (hasWFInstance) {
            ctx = newCtx;
        }
        if (!info.getState().equals((Object)ApplyTransDownStateEnum.SUBMIT)) {
            throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"205_ApplyTransDownControllerBean", (Locale)ctx.getLocale())});
        }
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        info.setAuditor(userInfo);
        info.setAuditDate(BondUtil.getNowDate());
        info.setState(ApplyTransDownStateEnum.AUDIT);
        info.setRejectRemark(null);
        ApplyTransDownFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        CompanyOrgUnitInfo company = info.getTransCompany();
        if (BondUtil.getBooleanParam((Context)ctx, (String)"TM108", (CompanyOrgUnitInfo)company)) {
            IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
            BTPTransformResult btpResult = iBTPManager.transform((CoreBillBaseInfo)info, new TransDownBillInfo().getBOSType().toString());
            IObjectCollection destBillCols = btpResult.getBills();
            BOTRelationCollection botRelateColl = btpResult.getBOTRelationCollection();
            if (botRelateColl.size() > 0) {
                TransDownBillInfo trans = (TransDownBillInfo)destBillCols.getObject(0);
                AccountBankInfo acctInfo = null;
                AccountBankInfo motherAccInfo = null;
                TransDownBillEntryInfo entry = null;
                Map<String, AccountBankInfo> acctMap = this.getAcctMap(ctx, trans);
                for (int index = 0; index < trans.getEntrys().size(); ++index) {
                    InnerAccountInfo innerAcctInfo;
                    entry = trans.getEntrys().get(index);
                    if (EmptyUtil.isEmpty((CoreBaseInfo)entry.getUnitAcctBank())) continue;
                    acctInfo = acctMap.get(entry.getUnitAcctBank().getId().toString());
                    motherAccInfo = acctMap.get(trans.getMotherAcctBank().getId().toString());
                    if (!EmptyUtil.isEmpty((CoreBaseInfo)acctInfo)) {
                        if (EmptyUtil.isEmpty((String)entry.getRecBank())) {
                            entry.setRecBank(acctInfo.getBank().getName());
                        }
                        if (EmptyUtil.isEmpty((String)entry.getRecProvince()) && !EmptyUtil.isEmpty((CoreBaseInfo)acctInfo.getOpenArea())) {
                            entry.setRecProvince(acctInfo.getOpenArea().getProvince());
                        }
                        if (EmptyUtil.isEmpty((String)entry.getRecCity()) && !EmptyUtil.isEmpty((CoreBaseInfo)acctInfo.getOpenArea())) {
                            entry.setRecCity(acctInfo.getOpenArea().getName());
                        }
                    }
                    if (EmptyUtil.isEmpty((CoreBaseInfo)(innerAcctInfo = acctInfo.getInnerAcct())) || !motherAccInfo.getCompany().getId().toString().equals(innerAcctInfo.getClearingHouse().getRelatedCompany().getId().toString())) {
                        entry.setUnitInnerAcct(null);
                        continue;
                    }
                    entry.setUnitInnerAcct(innerAcctInfo);
                }
                iBTPManager.saveRelations((CoreBillBaseInfo)trans, botRelateColl);
            }
        }
    }

    private Map<String, AccountBankInfo> getAcctMap(Context ctx, TransDownBillInfo trans) throws BOSException {
        HashSet<String> acctIdSet = new HashSet<String>();
        for (int index = 0; index < trans.getEntrys().size(); ++index) {
            if (EmptyUtil.isEmpty((CoreBaseInfo)trans.getEntrys().get(index).getUnitAcctBank())) continue;
            acctIdSet.add(trans.getEntrys().get(index).getUnitAcctBank().getId().toString());
        }
        acctIdSet.add(trans.getMotherAcctBank().getId().toString());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("bank.*"));
        sic.add(new SelectorItemInfo("InnerAcct.*"));
        sic.add(new SelectorItemInfo("InnerAcct.clearingHouse.relatedCompany"));
        sic.add(new SelectorItemInfo("openArea.*"));
        sic.add(new SelectorItemInfo("company.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", acctIdSet, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        AccountBankCollection acctInfoColl = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
        HashMap<String, AccountBankInfo> acctMap = new HashMap<String, AccountBankInfo>();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)acctInfoColl)) {
            for (int i = 0; i < acctInfoColl.size(); ++i) {
                acctMap.put(acctInfoColl.get(i).getId().toString(), acctInfoColl.get(i));
            }
        }
        return acctMap;
    }

    @Override
    protected void _cancelAudit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    public static boolean hasWFInstance(Context ctx, String billId) throws BOSException {
        boolean hasWorkflow = false;
        if (billId != null) {
            IEnactmentService service2 = EnactmentServiceFactory.createEnactService((Context)ctx);
            ProcessInstInfo instInfo = null;
            ProcessInstInfo[] procInsts = service2.getProcessInstanceByHoldedObjectId(billId);
            int n = procInsts.length;
            for (int i = 0; i < n; ++i) {
                if (!"open.running".equals(procInsts[i].getState())) continue;
                instInfo = procInsts[i];
            }
            hasWorkflow = instInfo != null;
        }
        return hasWorkflow;
    }
}

