/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.bond.BondUtil;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.fs.ApplyTransUpCollection;
import com.kingdee.eas.fm.fs.ApplyTransUpFactory;
import com.kingdee.eas.fm.fs.ApplyTransUpInfo;
import com.kingdee.eas.fm.fs.ApplyTransUpStateEnum;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.TransUpBillEntryInfo;
import com.kingdee.eas.fm.fs.TransUpBillInfo;
import com.kingdee.eas.fm.fs.app.AbstractApplyTransUpControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ApplyTransUpControllerBean
extends AbstractApplyTransUpControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fs.app.ApplyTransUpControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ApplyTransUpInfo oldInfo;
        ApplyTransUpInfo info = (ApplyTransUpInfo)model;
        if (info != null && info.getId() != null && ApplyTransUpFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId())) && (oldInfo = ApplyTransUpFactory.getLocalInstance(ctx).getApplyTransUpInfo((IObjectPK)new ObjectUuidPK(info.getId()))) != null && ApplyTransUpStateEnum.AUDIT.equals((Object)oldInfo.getState())) {
            throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"201_ApplyTransDownControllerBean", (Locale)ctx.getLocale())});
        }
        if (FMHelper.isEmpty((String)info.getNumber())) {
            try {
                String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
                info.setNumber(numberSilent);
            }
            catch (Exception ex) {
                throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"202_ApplyTransDownControllerBean", (Locale)ctx.getLocale())});
            }
        }
        this._checkNumberDup(ctx, (IObjectValue)info);
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ApplyTransUpInfo oldInfo;
        ApplyTransUpInfo info = (ApplyTransUpInfo)model;
        ObjectUuidPK pk = new ObjectUuidPK(info.getId());
        if (info != null && info.getId() != null && ApplyTransUpFactory.getLocalInstance(ctx).exists((IObjectPK)pk) && (oldInfo = ApplyTransUpFactory.getLocalInstance(ctx).getApplyTransUpInfo((IObjectPK)pk)) != null && ApplyTransUpStateEnum.AUDIT.equals((Object)oldInfo.getState())) {
            throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"201_ApplyTransDownControllerBean", (Locale)ctx.getLocale())});
        }
        if (FMHelper.isEmpty((String)info.getNumber())) {
            try {
                String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
                info.setNumber(numberSilent);
            }
            catch (Exception ex) {
                throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"202_ApplyTransDownControllerBean", (Locale)ctx.getLocale())});
            }
        }
        if (!ApplyTransUpStateEnum.AUDIT.equals((Object)info.getState())) {
            info.setState(ApplyTransUpStateEnum.SUBMIT);
        }
        this._checkNumberDup(ctx, (IObjectValue)info);
        IObjectPK retPK = super._submit(ctx, (IObjectValue)info);
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)info);
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)retPK, (IFMBgUsed)info);
        FmMbgHelper.requestBudget((Context)ctx, (IObjectPK)retPK);
        return retPK;
    }

    @Override
    protected void _audit(Context ctx, Set idSet) throws BOSException, EASBizException {
        for (String id : idSet) {
            this.audit4WF(ctx, (IObjectPK)new ObjectUuidPK(id));
        }
        String numbers = "";
        String companyID = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.getSelector().add(new SelectorItemInfo("number"));
        ApplyTransUpCollection colls = ApplyTransUpFactory.getLocalInstance(ctx).getApplyTransUpCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            ApplyTransUpInfo info = colls.get(i);
            numbers = EmptyUtil.isEmpty((String)numbers) ? info.getNumber() : numbers + "," + info.getNumber();
        }
        if (colls.size() > 0 && numbers != "") {
            IObjectPK iObjectPK = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new ApplyTransUpInfo().getBOSType(), null, (String)numbers, (String)"fs_appTransUp_Audit", (String)companyID, (String)"\u4e0a\u5212\u7533\u8bf7\u5355\u5ba1\u6279");
        }
    }

    @Override
    protected void _cancelAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("state"));
        view.getSelector().add(new SelectorItemInfo("auditDate"));
        ApplyTransUpCollection colls = ApplyTransUpFactory.getLocalInstance(ctx).getApplyTransUpCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            ApplyTransUpInfo info = colls.get(i);
            Set descSet = FMHelper.getDestBillIdSet((Context)ctx, (String)info.getId().toString());
            if (!info.getState().equals((Object)ApplyTransUpStateEnum.AUDIT) || descSet.size() > 0) {
                throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"203_ApplyTransDownControllerBean", (Locale)ctx.getLocale())});
            }
            info.setAuditor(null);
            info.setAuditDate(null);
            info.setState(ApplyTransUpStateEnum.SAVE);
            ApplyTransUpFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
            this.cancelAudit4WF(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ApplyTransUpInfo info = this.getApplyTransUpInfo(ctx, pk);
        if (!info.getState().equals((Object)ApplyTransUpStateEnum.SAVE) && !info.getState().equals((Object)ApplyTransUpStateEnum.SUBMIT)) {
            throw new FSException(FSException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"204_ApplyTransDownControllerBean", (Locale)ctx.getLocale())});
        }
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
        FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)pk);
        super._delete(ctx, pk);
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("auditDate"));
        sic.add(new SelectorItemInfo("transCompany.id"));
        ApplyTransUpInfo info = ApplyTransUpFactory.getLocalInstance(ctx).getApplyTransUpInfo(pk, sic);
        if (!info.getState().equals((Object)ApplyTransUpStateEnum.SUBMIT)) {
            throw new BEException(BEException.COMMON, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"206_ApplyTransUpControllerBean", (Locale)ctx.getLocale())});
        }
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        info.setAuditor(userInfo);
        info.setAuditDate(BondUtil.getNowDate());
        info.setState(ApplyTransUpStateEnum.AUDIT);
        info.setRejectRemark(null);
        ApplyTransUpFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        CompanyOrgUnitInfo company = info.getTransCompany();
        if (BondUtil.getBooleanParam((Context)ctx, (String)"TM107", (CompanyOrgUnitInfo)company)) {
            IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
            BTPTransformResult btpResult = iBTPManager.transform((CoreBillBaseInfo)info, new TransUpBillInfo().getBOSType().toString());
            IObjectCollection destBillCols = btpResult.getBills();
            BOTRelationCollection botRelateColl = btpResult.getBOTRelationCollection();
            if (botRelateColl.size() > 0) {
                TransUpBillInfo trans = (TransUpBillInfo)destBillCols.getObject(0);
                AccountBankInfo acctInfo = null;
                AccountBankInfo motherAccInfo = null;
                TransUpBillEntryInfo entry = null;
                Map<String, AccountBankInfo> acctMap = this.getAcctMap(ctx, trans);
                for (int index = 0; index < trans.getEntrys().size(); ++index) {
                    entry = trans.getEntrys().get(index);
                    if (EmptyUtil.isEmpty((CoreBaseInfo)entry.getUnitAcctBank())) continue;
                    acctInfo = acctMap.get(entry.getUnitAcctBank().getId().toString());
                    motherAccInfo = acctMap.get(trans.getMotherAcctBank().getId().toString());
                    if (EmptyUtil.isEmpty((CoreBaseInfo)acctInfo)) continue;
                    InnerAccountInfo innerAcctInfo = acctInfo.getInnerAcct();
                    if (EmptyUtil.isEmpty((CoreBaseInfo)innerAcctInfo) || !motherAccInfo.getCompany().getId().toString().equals(innerAcctInfo.getClearingHouse().getRelatedCompany().getId().toString())) {
                        entry.setUnitInnerAcct(null);
                        continue;
                    }
                    entry.setUnitInnerAcct(innerAcctInfo);
                }
                iBTPManager.saveRelations((CoreBillBaseInfo)trans, botRelateColl);
            }
        }
    }

    private Map<String, AccountBankInfo> getAcctMap(Context ctx, TransUpBillInfo trans) throws BOSException {
        HashSet<String> acctIdSet = new HashSet<String>();
        for (int index = 0; index < trans.getEntrys().size(); ++index) {
            if (EmptyUtil.isEmpty((CoreBaseInfo)trans.getEntrys().get(index).getUnitAcctBank())) continue;
            acctIdSet.add(trans.getEntrys().get(index).getUnitAcctBank().getId().toString());
        }
        acctIdSet.add(trans.getMotherAcctBank().getId().toString());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("bank.*"));
        sic.add(new SelectorItemInfo("InnerAcct.*"));
        sic.add(new SelectorItemInfo("InnerAcct.clearingHouse.relatedCompany"));
        sic.add(new SelectorItemInfo("openArea.*"));
        sic.add(new SelectorItemInfo("company.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", acctIdSet, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        AccountBankCollection acctInfoColl = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
        HashMap<String, AccountBankInfo> acctMap = new HashMap<String, AccountBankInfo>();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)acctInfoColl)) {
            for (int i = 0; i < acctInfoColl.size(); ++i) {
                acctMap.put(acctInfoColl.get(i).getId().toString(), acctInfoColl.get(i));
            }
        }
        return acctMap;
    }

    @Override
    protected void _cancelAudit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }
}

