/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.IAppLog;
import com.kingdee.eas.base.log.app.LogServerUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fs.DailySettleFacadeFactory;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.IDailySettleFacade;
import com.kingdee.eas.fm.fs.SettlementBill;
import com.kingdee.eas.fm.fs.app.AbstractAutoDailySettleFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AutoDailySettleFacadeControllerBean
extends AbstractAutoDailySettleFacadeControllerBean {
    static Logger logger = Logger.getLogger((String)AutoDailySettleFacadeControllerBean.class.getName());
    private static String resourcePath = "com.kingdee.eas.fm.fs.FSAutoGenerateResource";

    @Override
    protected void _autoDailySettle(Context ctx, String userNo) throws BOSException, EASBizException {
        ResultSet rs;
        IDailySettleFacade iDailySettleFacade = DailySettleFacadeFactory.getLocalInstance(ctx);
        Connection conn = this.getConnection(ctx);
        ArrayList<String> arr = new ArrayList<String>();
        String userId = "";
        PreparedStatement stmt = null;
        String sql = "SELECT COMPANY.FID AS ID FROM T_BD_BANK BANK JOIN T_ORG_COMPANY COMPANY ON COMPANY.FID = BANK.FRELATEDCOMPANYID WHERE BANK.FISINGROUP = ?";
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setBoolean(1, new Boolean(true));
            rs = stmt.executeQuery();
            while (rs.next()) {
                arr.add(rs.getString("id"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql = "SELECT FID AS ID FROM T_PM_User WHERE FNUMBER = ?";
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, userNo);
            rs = stmt.executeQuery();
            rs.next();
            userId = rs.getString("ID");
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String bizDate = DateUtil.getSQLBegin((Date)new Date()).toString();
        String year = bizDate.substring(0, 4);
        String month = bizDate.substring(5, 7);
        String day = bizDate.substring(8, 10);
        String successMsg = ResourceBase.getString((String)resourcePath, (String)"413_successMsg", (Locale)ctx.getLocale());
        String failureMsg = ResourceBase.getString((String)resourcePath, (String)"414_failureMsg", (Locale)ctx.getLocale());
        StringBuffer msgTitle = new StringBuffer(ResourceBase.getString((String)resourcePath, (String)"415_date", (Locale)ctx.getLocale()));
        String msgTitleSuffix = ResourceBase.getString((String)resourcePath, (String)"416_msgTitle", (Locale)ctx.getLocale());
        String dailySettle = ResourceBase.getString((String)resourcePath, (String)"417_dailySettle", (Locale)ctx.getLocale());
        MessageFormat mfTitle = new MessageFormat(msgTitle.toString());
        msgTitle = new StringBuffer(mfTitle.format(new String[]{year, month, day}));
        StringBuffer msgBody = new StringBuffer();
        if (arr.size() == 0) {
            return;
        }
        for (String id : arr) {
            MessageFormat mf;
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
            String name = companyInfo.getName();
            Date settleDate = FSHelper.getDailySettledDate(ctx, id);
            if (settleDate == null) {
                this.writeLog(ctx, new SettlementBill().getType(), dailySettle, null, null, dailySettle, id, dailySettle, new Boolean(false));
                continue;
            }
            String settleDateStr = DateUtil.getSQLBegin((Date)settleDate).toString();
            String settleDateMonth = settleDateStr.substring(5, 7);
            String settleDateDay = settleDateStr.substring(8, 10);
            Date lastSettleDate = DateUtil.getNextDay((Date)settleDate, (int)0);
            int settleCtrlType = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("TM024", (IObjectPK)new ObjectUuidPK(id));
            boolean canSettle = iDailySettleFacade.checkCanSettle(id, lastSettleDate);
            if (settleCtrlType == 0) {
                iDailySettleFacade.dailySettleBatch(id, settleDate, 1);
                msgTitle.append("{" + name + "}");
                mf = new MessageFormat(successMsg);
                msgBody.append(mf.format(new String[]{year, month, day, name, settleDateMonth, settleDateDay}) + "\n");
                this.writeLog(ctx, new SettlementBill().getType(), dailySettle, null, null, dailySettle, id, dailySettle, new Boolean(true));
                continue;
            }
            if (settleCtrlType != 2 && settleCtrlType != 1) continue;
            if (canSettle) {
                iDailySettleFacade.dailySettleBatch(id, settleDate, 1);
                msgTitle.append("{" + name + "}");
                mf = new MessageFormat(successMsg);
                msgBody.append(mf.format(new String[]{year, month, day, name, settleDateMonth, settleDateDay}) + "\n");
                this.writeLog(ctx, new SettlementBill().getType(), dailySettle, null, null, dailySettle, id, dailySettle, new Boolean(true));
                continue;
            }
            msgTitle.append(name);
            mf = new MessageFormat(failureMsg);
            msgBody.append(mf.format(new String[]{year, month, day, name}) + "\n");
            this.writeLog(ctx, new SettlementBill().getType(), dailySettle, null, null, dailySettle, id, dailySettle, new Boolean(false));
        }
        msgTitle.append(msgTitleSuffix);
        AutoDailySettleFacadeControllerBean.sendByMessage(ctx, msgTitle.toString(), "administrator", msgBody.toString(), userId);
    }

    private void writeLog(Context ctx, BOSObjectType bizObjType, String methodName, String instancePK, String instanceDetail, String logItemName, String companyId, String methodDescription, Boolean isSuccess) throws BOSException {
        HashMap<String, Object> hashLog = new HashMap<String, Object>();
        hashLog.put("FEntityID", bizObjType.toString());
        LogServerUtil.setEntityAlias((Context)ctx, (BOSObjectType)bizObjType, hashLog);
        hashLog.put("FMethodName", methodName);
        hashLog.put("FMethodAlias_" + ctx.getLocale().toString().toUpperCase(), methodName);
        hashLog.put("FInstanceID", instancePK);
        hashLog.put("FInstanceNo", instanceDetail);
        hashLog.put("successed", isSuccess);
        hashLog.put("FItemName", logItemName);
        hashLog.put("LOG_HIDDEN_WRITE_MODE", "LOG_HIDDEN_WRITE_MODE");
        IAppLog iAppLog = AppLogFactory.getLocalInstance((Context)ctx);
        iAppLog.writeLog(hashLog);
        LogServerUtil.setLogInfo(null, (Context)ctx, hashLog);
        OrgUnitInfo orgInfo = null;
        try {
            orgInfo = OrgUnitCommonFactory.getLocalInstance((Context)ctx).getOrgUnit(BOSUuid.read((String)companyId));
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        SolutionInfo soluctionInfo = AutoDailySettleFacadeControllerBean.getSolutionInfo(ctx);
        if (orgInfo != null && soluctionInfo != null) {
            String strKey = "FCompanyName_";
            LanguageCollection langCol = soluctionInfo.getLanguages();
            String strDefPostfix = soluctionInfo.getDefaultLanguage().getPostfix();
            for (int i = 0; i < langCol.size(); ++i) {
                LanguageInfo langInfo = langCol.get(i);
                String key = strKey + langInfo.getPostfix().toUpperCase();
                if (langInfo.getPostfix().equals(strDefPostfix)) {
                    if (orgInfo == null) {
                        hashLog.put(key, "");
                        continue;
                    }
                    hashLog.put(key, orgInfo.getName());
                    continue;
                }
                if (orgInfo == null) {
                    hashLog.put(key, "");
                    continue;
                }
                hashLog.put(key, orgInfo.get("name", langInfo.getLocale()));
            }
        }
        this.putMethodDesc(hashLog, ctx, methodDescription);
        iAppLog.writeLog(hashLog);
    }

    private static void sendByMessage(Context ctx, String msgTitle, String msgSender, String msgBody, String msgReceiver) {
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Locale[] lcla = AutoDailySettleFacadeControllerBean.getContextLocales(ctx);
        Locale locale2 = null;
        Message message = MessageFactory.newMessage((String)"kingdee.workflow");
        for (Locale locale2 : lcla) {
            message.setLocaleStringHeader("title", msgTitle, locale2);
            message.setLocaleStringHeader("sender", msgSender, locale2);
            message.setLocaleStringHeader("body", msgBody, locale2);
        }
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 50);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        message.setStringHeader("receiver", msgReceiver);
        senderAgent.sendMessage(message);
    }

    private static Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }

    private static SolutionInfo getSolutionInfo(Context ctx) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        SolutionInfo soInfo = loader.getSolution();
        return soInfo;
    }

    private void putMethodDesc(Map hashLog, Context ctx, String methodDescription) {
        SolutionInfo soInfo = AutoDailySettleFacadeControllerBean.getSolutionInfo(ctx);
        LanguageCollection lC = soInfo.getLanguages();
        for (int i = 0; i < lC.size(); ++i) {
            LanguageInfo lInfo = lC.get(i);
            String key = "FMethodDescription_" + lInfo.getPostfix().toUpperCase();
            if (lInfo.getLocaleString().equals(Locale.TRADITIONAL_CHINESE.toString())) {
                hashLog.put(key, STConverter.sc2tc((String)methodDescription));
                continue;
            }
            if (lInfo.getLocaleString().equals(Locale.SIMPLIFIED_CHINESE.toString())) {
                hashLog.put(key, STConverter.tc2sc((String)methodDescription));
                continue;
            }
            hashLog.put(key, methodDescription);
        }
    }
}

