/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.app.AbstractBatchFetchForFsFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BatchFetchForFsFacadeControllerBean
extends AbstractBatchFetchForFsFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fs.app.BatchFetchForFsFacadeControllerBean");
    private static final int ROUND = 4;

    @Override
    protected Map _fetchMsg(Context ctx, Map paramNameMap) throws BOSException, EASBizException {
        HashMap<String, Comparable<BigDecimal>> result = new HashMap<String, Comparable<BigDecimal>>();
        if (paramNameMap.get("settlementBillId") != null) {
            String settlementBillId = (String)paramNameMap.get("settlementBillId");
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("payeeInnerAcct.number"));
            sic.add(new SelectorItemInfo("payerInnerAcct.number"));
            sic.add(new SelectorItemInfo("payeeBankAcct.number"));
            sic.add(new SelectorItemInfo("payerBankAcct.number"));
            sic.add(new SelectorItemInfo("currency.number"));
            sic.add(new SelectorItemInfo("currency.precision"));
            sic.add(new SelectorItemInfo("payeeInnerAcct.company.id"));
            sic.add(new SelectorItemInfo("payerInnerAcct.company.id"));
            sic.add(new SelectorItemInfo("payeeBankAcct.company.id"));
            sic.add(new SelectorItemInfo("payerBankAcct.company.id"));
            sic.add(new SelectorItemInfo("payeeBankAcct.isSetBankInterface"));
            sic.add(new SelectorItemInfo("payerBankAcct.isSetBankInterface"));
            SettlementBillInfo info = SettlementBillFactory.getLocalInstance(ctx).getSettlementBillInfo((IObjectPK)new ObjectUuidPK(settlementBillId), sic);
            CurrencyInfo currency = info.getCurrency();
            InnerAccountInfo payeeInnerAcct = info.getPayeeInnerAcct();
            BigDecimal payeeInnerAcctBalance = this.getBalanceValue(ctx, currency, payeeInnerAcct);
            if (currency != null && payeeInnerAcct != null) {
                result.put(currency.getId().toString() + payeeInnerAcct.getId().toString(), payeeInnerAcctBalance);
            }
            InnerAccountInfo payerInnerAcct = info.getPayerInnerAcct();
            BigDecimal payerInnerAcctBalance = this.getBalanceValue(ctx, currency, payerInnerAcct);
            if (currency != null && payerInnerAcct != null) {
                result.put(currency.getId().toString() + payerInnerAcct.getId().toString(), payerInnerAcctBalance);
            }
            AccountBankInfo payeeBankAcct = info.getPayeeBankAcct();
            BigDecimal payeeAcctBankBalance = this.getBalanceValue(ctx, currency, payeeBankAcct);
            if (currency != null && payeeBankAcct != null) {
                result.put(currency.getId().toString() + payeeBankAcct.getId().toString(), payeeAcctBankBalance);
            }
            String CS132 = ContextHelperFactory.getLocalInstance((Context)ctx).getStringParam("CS132", (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()));
            AccountBankInfo payerBankAcct = info.getPayerBankAcct();
            BigDecimal payerAcctBankBalance = this.getBalanceValueByCS132(ctx, currency, payerBankAcct, CS132);
            if (currency != null && payerBankAcct != null) {
                result.put(currency.getId().toString() + payerBankAcct.getId().toString(), payerAcctBankBalance);
            }
        }
        if (paramNameMap.get("isClearingHouseUsed") != null) {
            boolean isClearingHouseUsed = BatchFetchForFsFacadeControllerBean.clearingHouseIsUsed(ctx);
            result.put("isClearingHouseUsed", Boolean.valueOf(isClearingHouseUsed));
        }
        if (paramNameMap.get("clearingHouse") != null) {
            BankInfo clearingHouse = BatchFetchForFsFacadeControllerBean.getClearingHouse(ctx);
            result.put("clearingHouse", (Comparable<BigDecimal>)clearingHouse);
        }
        if (paramNameMap.get("inAcctApplyCompany") != null) {
            CompanyOrgUnitCollection coll = InAcctFactory.getLocalInstance(ctx).getInAcctApplyCompany();
            result.put("inAcctApplyCompany", (Comparable<BigDecimal>)coll);
        }
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        if (paramNameMap.get("isClearinghouseCompany") != null) {
            boolean isClearinghouseCompany = BankFactory.getLocalInstance((Context)ctx).isClearinghouseCompany(currentCompany.getId().toString());
            result.put("isClearinghouseCompany", Boolean.valueOf(isClearinghouseCompany));
        }
        return result;
    }

    public static boolean clearingHouseIsUsed(Context ctx) throws EASBizException, BOSException {
        String cur = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        if (BankFactory.getLocalInstance((Context)ctx).getClearingHouse(cur) == null) {
            return false;
        }
        BankInfo clearingHouse = BatchFetchForFsFacadeControllerBean.getClearingHouse(ctx);
        return clearingHouse != null && clearingHouse.isUsed();
    }

    public static BankInfo getClearingHouse(Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitInfo curent = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        BankInfo clearingHouse = BankFactory.getLocalInstance((Context)ctx).getClearingHouse(curent.getId().toString());
        if (clearingHouse == null) {
            return null;
        }
        return clearingHouse;
    }

    protected BigDecimal getBalanceValue(Context ctx, CurrencyInfo currencyInfo, InnerAccountInfo innerAcctInfo) throws EASBizException, BOSException {
        if (currencyInfo == null || innerAcctInfo == null) {
            return Constants.ZERO;
        }
        ObjectUuidPK chCompanyPk = new ObjectUuidPK(innerAcctInfo.getCompany().getId());
        CompanyOrgUnitInfo chCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)chCompanyPk);
        BankInfo clearingHouse = BankFactory.getLocalInstance((Context)ctx).getClearingHouse(chCompany.getId().toString());
        Date unSettleDate = clearingHouse.getSettleDate();
        BigDecimal balance = InAcctFactory.getLocalInstance(ctx).inAcct(chCompany.getNumber(), innerAcctInfo.getNumber(), currencyInfo.getNumber(), unSettleDate, unSettleDate, InAcctDataTypeEnum.K);
        if (balance == null) {
            return Constants.ZERO;
        }
        balance = balance.setScale(currencyInfo.getPrecision(), 4);
        return balance;
    }

    protected BigDecimal getBalanceValue(Context ctx, CurrencyInfo currencyInfo, AccountBankInfo acctBankInfo) throws EASBizException, BOSException {
        if (currencyInfo == null || acctBankInfo == null || acctBankInfo.getCompany() == null) {
            return Constants.ZERO;
        }
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(acctBankInfo.getCompany().getId()));
        BigDecimal balance = BigDecimal.ZERO;
        if (!EmptyUtil.isEmpty((CoreBaseInfo)acctBankInfo) && acctBankInfo.isIsSetBankInterface()) {
            balance = PaymentBillFactory.getLocalInstance((Context)ctx).getBalanceValue(acctBankInfo.getId().toString(), currencyInfo.getId().toString());
        } else {
            balance = CashManagementFactory.getLocalInstance((Context)ctx).cash(companyInfo.getNumber(), CashDataSourceEnum.B, null, null, acctBankInfo.getNumber(), currencyInfo.getNumber(), new Date(), new Date(), CashDataTypeEnum.Y, false);
            BigDecimal totalAmt = CashManagementFactory.getLocalInstance((Context)ctx).getTotalSettleBillAmtByAccount(companyInfo.getId().toString(), acctBankInfo.getId().toString(), currencyInfo.getId().toString());
            if (balance == null) {
                balance = Constants.ZERO;
            }
            if (totalAmt != null) {
                balance = balance.add(totalAmt);
            }
        }
        balance = balance.setScale(currencyInfo.getPrecision(), 4);
        return balance;
    }

    protected BigDecimal getBalanceValueByCS132(Context ctx, CurrencyInfo currencyInfo, AccountBankInfo acctBankInfo, String CS132) throws EASBizException, BOSException {
        if (currencyInfo == null || acctBankInfo == null || acctBankInfo.getCompany() == null) {
            return Constants.ZERO;
        }
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(acctBankInfo.getCompany().getId()));
        BigDecimal balance = BigDecimal.ZERO;
        if (!EmptyUtil.isEmpty((CoreBaseInfo)acctBankInfo) && acctBankInfo.isIsSetBankInterface() && !"1".equals(CS132)) {
            balance = PaymentBillFactory.getLocalInstance((Context)ctx).getBalanceValue(acctBankInfo.getId().toString(), currencyInfo.getId().toString());
        } else {
            balance = CashManagementFactory.getLocalInstance((Context)ctx).cash(companyInfo.getNumber(), CashDataSourceEnum.B, null, null, acctBankInfo.getNumber(), currencyInfo.getNumber(), new Date(), new Date(), CashDataTypeEnum.Y, false);
            BigDecimal totalAmt = CashManagementFactory.getLocalInstance((Context)ctx).getTotalSettleBillAmtByAccount(companyInfo.getId().toString(), acctBankInfo.getId().toString(), currencyInfo.getId().toString());
            if (balance == null) {
                balance = Constants.ZERO;
            }
            if (totalAmt != null) {
                balance = balance.add(totalAmt);
            }
        }
        balance = balance.setScale(currencyInfo.getPrecision(), 4);
        return balance;
    }
}

