/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.HashSearchEngine;
import com.kingdee.eas.fm.fs.BalanceDirectionEnum;
import com.kingdee.eas.fm.fs.DailyBalanceFormCollection;
import com.kingdee.eas.fm.fs.DailyBalanceFormInfo;
import com.kingdee.eas.fm.fs.FSDailySettleException;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.IInnerAccount;
import com.kingdee.eas.fm.fs.ISubsidiaryLedger;
import com.kingdee.eas.fm.fs.ISummaryLedger;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SubsidiaryBalanceEntryCollection;
import com.kingdee.eas.fm.fs.SubsidiaryBalanceEntryInfo;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.fm.fs.SummaryLedgerCollection;
import com.kingdee.eas.fm.fs.SummaryLedgerFactory;
import com.kingdee.eas.fm.fs.SummaryLedgerInfo;
import com.kingdee.eas.fm.fs.app.AbstractDailyBalanceFormControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DailyBalanceFormControllerBean
extends AbstractDailyBalanceFormControllerBean {
    private static Logger logger = Logger.getLogger(DailyBalanceFormControllerBean.class);
    private static final String[] subKeys = new String[]{"type", "innerAcct", "bankAcct", "currency"};
    private static final int ZERO = 0;
    private static final int ONE = 1;

    @Override
    protected IObjectValue _genDailyBalanceForm(Context ctx, String companyId, Date date) throws BOSException, EASBizException {
        BankInfo clearingHouseInfo = FSHelper.getClearingHouseInfo(ctx, companyId);
        Date balDate = clearingHouseInfo.getSettleDate();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("GenDailyBalanceForm at: " + balDate));
        }
        if (balDate == null) {
            throw new FSDailySettleException(FSDailySettleException.CHECK_SETTLEDATE);
        }
        this.clearOldForm(ctx, balDate);
        date = balDate;
        SubsidiaryLedgerCollection subLedgerCollToSub = this.getSubsidiaryLedgerColl(ctx, date);
        SubsidiaryBalanceEntryCollection subBalColl = null;
        if (subLedgerCollToSub != null) {
            subBalColl = this.getSubsidiaryBalanceEntryColl(subLedgerCollToSub);
        }
        SubsidiaryBalanceEntryCollection newSubColl = null;
        if (subBalColl != null) {
            newSubColl = this.genNewSubCollection(ctx, subBalColl, balDate);
        }
        DailyBalanceFormInfo info = new DailyBalanceFormInfo();
        info.setDate(date);
        info.setBizDate(date);
        info.setIsSettled(false);
        info.setCompany(clearingHouseInfo.getRelatedCompany());
        info.setIsBalanced(true);
        info.getSbEntries().addCollection(newSubColl);
        this._addnew(ctx, (IObjectValue)info);
        return info;
    }

    private SubsidiaryBalanceEntryCollection getSubsidiaryBalanceEntryColl(SubsidiaryLedgerCollection subLedgerCollToSub) {
        SubsidiaryBalanceEntryCollection subBalColl = new SubsidiaryBalanceEntryCollection();
        int size = subLedgerCollToSub.size();
        for (int i = 0; i < size; ++i) {
            SubsidiaryLedgerInfo subLedgerInfo = subLedgerCollToSub.get(i);
            SubsidiaryBalanceEntryInfo subBalInfo = new SubsidiaryBalanceEntryInfo();
            subBalInfo.setCurrency(subLedgerInfo.getCurrency());
            subBalInfo.setInnerAcct(subLedgerInfo.getInnerAccount());
            if (subLedgerInfo.getPayeeBankAccount() != null) {
                subBalInfo.setBankAcct(subLedgerInfo.getPayeeBankAccount());
            } else if (subLedgerInfo.getPayerBankAccount() != null) {
                subBalInfo.setBankAcct(subLedgerInfo.getPayerBankAccount());
            }
            BigDecimal debitAmt = FMHelper.checkBigDecimal((BigDecimal)subLedgerInfo.getDebitAmount());
            BigDecimal creditAmt = FMHelper.checkBigDecimal((BigDecimal)subLedgerInfo.getCreditAmount());
            subBalInfo.setDailyDebitSubtotal(debitAmt);
            subBalInfo.setDailyCreditSubtotal(creditAmt);
            if (debitAmt.compareTo(Constants.ZERO) != 0) {
                subBalInfo.setDebitCounts(1);
            } else {
                subBalInfo.setDebitCounts(0);
            }
            if (creditAmt.compareTo(Constants.ZERO) != 0) {
                subBalInfo.setCreditCounts(1);
            } else {
                subBalInfo.setCreditCounts(0);
            }
            subBalColl.add(subBalInfo);
        }
        return subBalColl;
    }

    private SubsidiaryLedgerCollection getSubsidiaryLedgerColl(Context ctx, Date date) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("currency.id");
        selector.add("currency.number");
        selector.add("currency.name");
        selector.add("currency.precision");
        selector.add("innerAccount.id");
        selector.add("innerAccount.number");
        selector.add("innerAccount.name");
        selector.add("company.id");
        selector.add("company.number");
        selector.add("company.name");
        selector.add("cpInnerAccount.id");
        selector.add("cpInnerAccount.number");
        selector.add("cpInnerAccount.name");
        selector.add("*");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("date", (Object)DateTimeUtils.truncateDate((Date)date)));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        ISubsidiaryLedger iSubLedger = SubsidiaryLedgerFactory.getLocalInstance(ctx);
        SubsidiaryLedgerCollection subLedgerColl = iSubLedger.getSubsidiaryLedgerCollection(viewInfo);
        return subLedgerColl;
    }

    private SubsidiaryBalanceEntryCollection genNewSubCollection(Context ctx, SubsidiaryBalanceEntryCollection subColl, Date bizDate) throws EASBizException, BOSException {
        SubsidiaryBalanceEntryCollection newSubColl = new SubsidiaryBalanceEntryCollection();
        HashSearchEngine hash = new HashSearchEngine((IObjectCollection)newSubColl, subKeys);
        for (int i = 0; i < subColl.size(); ++i) {
            SubsidiaryBalanceEntryInfo subInfo = subColl.get(i);
            if (hash.evaluate((IObjectValue)subInfo)) {
                SubsidiaryBalanceEntryInfo rst = (SubsidiaryBalanceEntryInfo)hash.getResult();
                BigDecimal debitTotal = FMHelper.checkBigDecimal((BigDecimal)subInfo.getDailyDebitSubtotal());
                BigDecimal creditTotal = FMHelper.checkBigDecimal((BigDecimal)subInfo.getDailyCreditSubtotal());
                int debitCounts = rst.getDebitCounts() + subInfo.getDebitCounts();
                rst.setDebitCounts(debitCounts);
                BigDecimal newDebitTotal = rst.getDailyDebitSubtotal().add(debitTotal);
                rst.setDailyDebitSubtotal(newDebitTotal);
                int creditCounts = rst.getCreditCounts() + subInfo.getCreditCounts();
                rst.setCreditCounts(creditCounts);
                BigDecimal newCreditTotal = rst.getDailyCreditSubtotal().add(creditTotal);
                rst.setDailyCreditSubtotal(newCreditTotal);
                continue;
            }
            hash.add((IObjectValue)subInfo);
        }
        hash.cat((IObjectCollection)newSubColl);
        Date beforeDate = null;
        beforeDate = DateUtil.getBeforeDay((Date)bizDate);
        SummaryLedgerCollection sumLedgerCol = this.getSummaryLedgerCollection(ctx, beforeDate);
        Map map = FSHelper.getSumHashSearchMap((IObjectCollection)sumLedgerCol);
        for (int i = 0; i < newSubColl.size(); ++i) {
            SubsidiaryBalanceEntryInfo subInfo = newSubColl.get(i);
            this.setBalance(sumLedgerCol, map, subInfo);
        }
        return newSubColl;
    }

    private void setBalance(SummaryLedgerCollection sumLedgerCol, Map map, SubsidiaryBalanceEntryInfo subInfo) {
        String strKey = FSHelper.getKeyString((IObjectValue)subInfo, subKeys);
        if (sumLedgerCol != null && subInfo != null && map != null) {
            SummaryLedgerInfo sumInfo = (SummaryLedgerInfo)map.get(strKey);
            BigDecimal dailyDebitSubtotal = FMHelper.checkBigDecimal((BigDecimal)subInfo.getDailyDebitSubtotal());
            BigDecimal dailyCreditSubtotal = FMHelper.checkBigDecimal((BigDecimal)subInfo.getDailyCreditSubtotal());
            if (sumInfo != null) {
                BigDecimal endBalance = FMHelper.checkBigDecimal((BigDecimal)sumInfo.getEndBalance());
                subInfo.setBeginBalance(endBalance);
                subInfo.setEndBalance(FMHelper.checkBigDecimal((BigDecimal)endBalance.add(dailyDebitSubtotal).subtract(dailyCreditSubtotal)));
            } else {
                subInfo.setBeginBalance(Constants.ZERO);
                subInfo.setEndBalance(FMHelper.checkBigDecimal((BigDecimal)dailyDebitSubtotal.subtract(dailyCreditSubtotal)));
            }
        }
        subInfo.setBeginDC(FSHelper.getBalanceDirection(FMHelper.checkBigDecimal((BigDecimal)subInfo.getBeginBalance())));
        subInfo.setEndBalanceDC(FSHelper.getBalanceDirection(FMHelper.checkBigDecimal((BigDecimal)subInfo.getEndBalance())));
        subInfo.setLocalBeginBalance(Constants.ZERO);
        subInfo.setLocalEndBalance(Constants.ZERO);
        subInfo.setDailyLocalDebitSubtotal(Constants.ZERO);
        subInfo.setDailyLocalCreditSubtotal(Constants.ZERO);
    }

    protected void clearOldForm(Context ctx, Date date) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)TypeConversionUtils.objToDate((Object)date)));
        this._delete(ctx, filter);
    }

    protected boolean _checkLineExist(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected void _dailySettle(Context ctx, String companyId, Date date) throws EASBizException, BOSException {
        Date dailySettleDate = this._getDailySettledDate(ctx, companyId);
        if (FMHelper.dateCompare((Date)date, (Date)dailySettleDate) != 0) {
            throw new FSDailySettleException(FSDailySettleException.CHECK_DAILYSETTLEDATE);
        }
        DailyBalanceFormInfo dailyBalInfo = this.getDailyBalanceFormInfo(ctx, dailySettleDate);
        if (dailyBalInfo == null) {
            throw new FSDailySettleException(FSDailySettleException.ISBALANCED);
        }
        if (dailyBalInfo != null && !dailyBalInfo.isIsBalanced()) {
            throw new FSDailySettleException(FSDailySettleException.CHECK_BALANCE);
        }
        SummaryLedgerCollection sumCol = this.getNewSummaryLedgerCollection(ctx, dailySettleDate);
        Map innerAccountAndSumInfo = null;
        if (sumCol != null && sumCol.size() != 0) {
            innerAccountAndSumInfo = FSHelper.getSumHashSearchMap((IObjectCollection)sumCol);
        }
        SubsidiaryBalanceEntryCollection subCol = dailyBalInfo.getSbEntries();
        int size = subCol.size();
        for (int i = 0; i < size; ++i) {
            this.genSubEntrySummary(ctx, dailySettleDate, innerAccountAndSumInfo, subCol.get(i));
        }
        this.submitSumLedgerCollection(ctx, innerAccountAndSumInfo);
        this.signDailySettled(ctx, dailyBalInfo);
        this.updateClearingHouseSettleDate(ctx, null, DateUtil.getAfterDay((Date)dailySettleDate), true);
    }

    private void signDailySettled(Context ctx, DailyBalanceFormInfo dailyBalInfo) throws BOSException, EASBizException {
        dailyBalInfo.setIsSettled(true);
        this._submit(ctx, (IObjectValue)dailyBalInfo);
    }

    private void submitSumLedgerCollection(Context ctx, Map innerAccountAndSumInfo) throws BOSException, EASBizException {
        ISummaryLedger iSummary = SummaryLedgerFactory.getLocalInstance(ctx);
        Set sumSet = innerAccountAndSumInfo.keySet();
        Iterator sumIterator = sumSet.iterator();
        String strKey = null;
        while (sumIterator.hasNext()) {
            strKey = sumIterator.next().toString();
            SummaryLedgerInfo summaryInfo = (SummaryLedgerInfo)innerAccountAndSumInfo.get(strKey);
            iSummary.addnew(summaryInfo);
        }
    }

    private void genSubEntrySummary(Context ctx, Date dailySettleDate, Map innerAccountAndSumInfo, SubsidiaryBalanceEntryInfo subInfo) {
        String subKey = FSHelper.getKeyString((IObjectValue)subInfo, subKeys);
        SummaryLedgerInfo sumInfo = (SummaryLedgerInfo)innerAccountAndSumInfo.get(subKey);
        if (sumInfo != null) {
            sumInfo.setCurrency(subInfo.getCurrency());
            sumInfo.setInnerAccount(subInfo.getInnerAcct());
            sumInfo.setBizDate(dailySettleDate);
            sumInfo.setCompany(this.getCompanyByLedgerType(subInfo));
            sumInfo.setApplyUnit(subInfo.getInnerAcct().getApplyUnit());
            sumInfo.setBankAcct(subInfo.getBankAcct());
            BigDecimal debitTotal = FMHelper.checkBigDecimal((BigDecimal)sumInfo.getDebitTotal()).add(FMHelper.checkBigDecimal((BigDecimal)subInfo.getDailyDebitSubtotal()));
            BigDecimal creditTotal = FMHelper.checkBigDecimal((BigDecimal)sumInfo.getCreditTotal()).add(FMHelper.checkBigDecimal((BigDecimal)subInfo.getDailyCreditSubtotal()));
            sumInfo.setDebitTotal(debitTotal);
            sumInfo.setCreditTotal(creditTotal);
            sumInfo.setDebitCounts(subInfo.getDebitCounts());
            sumInfo.setCreditCounts(subInfo.getCreditCounts());
            BigDecimal endBalance = FMHelper.checkBigDecimal((BigDecimal)subInfo.getEndBalance());
            sumInfo.setEndBalance(endBalance);
            sumInfo.setEndBalanceDC(FSHelper.getBalanceDirection(endBalance));
            sumInfo.setLocalEndBalance(endBalance);
            sumInfo.setLocalDebitTotal(subInfo.getDailyLocalDebitSubtotal());
            sumInfo.setLocalCreditTotal(subInfo.getDailyLocalCreditSubtotal());
        } else {
            sumInfo = new SummaryLedgerInfo();
            sumInfo.setCurrency(subInfo.getCurrency());
            sumInfo.setInnerAccount(subInfo.getInnerAcct());
            sumInfo.setBizDate(dailySettleDate);
            sumInfo.setDebitTotal(FMHelper.checkBigDecimal((BigDecimal)subInfo.getDailyDebitSubtotal()));
            sumInfo.setCreditTotal(FMHelper.checkBigDecimal((BigDecimal)subInfo.getDailyCreditSubtotal()));
            sumInfo.setEndBalanceDC(subInfo.getEndBalanceDC());
            sumInfo.setEndBalance(FMHelper.checkBigDecimal((BigDecimal)subInfo.getEndBalance()));
            sumInfo.setDebitCounts(subInfo.getDebitCounts());
            sumInfo.setCreditCounts(subInfo.getCreditCounts());
            sumInfo.setLocalBeginBalance(subInfo.getLocalBeginBalance());
            sumInfo.setLocalEndBalance(subInfo.getLocalEndBalance());
            sumInfo.setLocalDebitTotal(subInfo.getDailyLocalDebitSubtotal());
            sumInfo.setLocalCreditTotal(subInfo.getDailyLocalCreditSubtotal());
            CompanyOrgUnitInfo company = this.getCompanyByLedgerType(subInfo);
            sumInfo.setCompany(company);
            sumInfo.setApplyUnit(subInfo.getInnerAcct().getApplyUnit());
            sumInfo.setBeginBalance(FMHelper.checkBigDecimal((BigDecimal)subInfo.getBeginBalance()));
            sumInfo.setBeginBalanceDC(subInfo.getBeginDC());
            sumInfo.setBankAcct(subInfo.getBankAcct());
            innerAccountAndSumInfo.put(subKey, sumInfo);
        }
    }

    private CompanyOrgUnitInfo getCompanyByLedgerType(SubsidiaryBalanceEntryInfo subInfo) {
        return subInfo.getInnerAcct().getCompany();
    }

    private DailyBalanceFormInfo getDailyBalanceFormInfo(Context ctx, Date date) throws BOSException {
        DailyBalanceFormCollection dailyBalCol = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("bizDate");
        selector.add("sbEntries.*");
        selector.add("sbEntries.id");
        selector.add("sbEntries.type");
        selector.add("sbEntries.capitalType");
        selector.add("sbEntries.currency.*");
        selector.add("sbEntries.currency.id");
        selector.add("sbEntries.innerAcct.*");
        selector.add("sbEntries.innerAcct.id");
        selector.add("sbEntries.bankAcct.id");
        selector.add("sbEntries.bankAcct.company.*");
        selector.add("abEntries.id");
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)date));
        ev.setFilter(filter);
        ev.getSelector().addObjectCollection((IObjectCollection)selector);
        dailyBalCol = this.getDailyBalanceFormCollection(ctx, ev);
        if (dailyBalCol.size() == 1) {
            return dailyBalCol.get(0);
        }
        return null;
    }

    private SummaryLedgerCollection getNewSummaryLedgerCollection(Context ctx, Date date) throws EASBizException, BOSException {
        Date beforeDate = DateUtil.getBeforeDay((Date)date);
        SummaryLedgerInfo sumInfo = null;
        BigDecimal beginBalance = Constants.ZERO;
        SummaryLedgerCollection sumCol = this.getSummaryLedgerCollection(ctx, beforeDate);
        int colSize = sumCol.size();
        for (int i = 0; i < colSize; ++i) {
            sumInfo = sumCol.get(i);
            beginBalance = FMHelper.checkBigDecimal((BigDecimal)sumInfo.getEndBalance());
            sumCol.get(i).setId(BOSUuid.create((BOSObjectType)sumInfo.getBOSType()));
            sumInfo.setBizDate(date);
            BalanceDirectionEnum beginBalanceDC = FSHelper.getBalanceDirection(FMHelper.checkBigDecimal((BigDecimal)beginBalance));
            sumInfo.setBeginBalanceDC(beginBalanceDC);
            sumInfo.setEndBalanceDC(beginBalanceDC);
            sumInfo.setBeginBalance(beginBalance);
            sumInfo.setEndBalance(beginBalance);
            sumInfo.setDebitTotal(Constants.ZERO);
            sumInfo.setLocalDebitTotal(Constants.ZERO);
            sumInfo.setCreditTotal(Constants.ZERO);
            sumInfo.setLocalCreditTotal(Constants.ZERO);
            sumInfo.setDebitCounts(0);
            sumInfo.setCreditCounts(0);
            sumInfo.setLocalBeginBalance(beginBalance);
            sumInfo.setLocalEndBalance(beginBalance);
        }
        return sumCol;
    }

    private SummaryLedgerCollection getSummaryLedgerCollection(Context ctx, Date date) throws BOSException {
        ISummaryLedger iSummary = SummaryLedgerFactory.getLocalInstance(ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("type");
        selector.add("capitalType");
        selector.add("innerAccount.*");
        selector.add("innerAccount.id");
        selector.add("currency.*");
        selector.add("currency.id");
        selector.add("company.id");
        selector.add("endBalance");
        selector.add("bankAcct");
        selector.add("bankAcct.id");
        selector.add("bankAcct.name");
        selector.add("bankAcct.number");
        selector.add("*");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)date));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        SummaryLedgerCollection sumCol = iSummary.getSummaryLedgerCollection(viewInfo);
        return sumCol;
    }

    @Override
    protected void _antiDailySettle(Context ctx, String companyId, Date date) throws BOSException, EASBizException {
        BankInfo clearingHouseInfo = FSHelper.getClearingHouseInfo(ctx, companyId);
        Date settlDate = clearingHouseInfo.getSettleDate();
        Date antiSettDate = DateUtil.getBeforeDay((Date)settlDate);
        this.deleteSummaryLedgerCol(ctx, antiSettDate);
        DailyBalanceFormInfo dailyBalFormInfo = this.getDailyBalanceFormInfo(ctx, antiSettDate);
        if (dailyBalFormInfo == null) {
            throw new EASBizException(EASBizException.CHECKEXIST, new Object[]{antiSettDate});
        }
        if (dailyBalFormInfo.isFiVouchered()) {
            throw new FSDailySettleException(FSDailySettleException.CHECK_ISDAILYSETTLED);
        }
        dailyBalFormInfo.setIsSettled(false);
        this._update(ctx, (IObjectPK)new ObjectUuidPK(dailyBalFormInfo.getId().toString()), (IObjectValue)dailyBalFormInfo);
        DailyBalanceFormInfo afterDateFormInfo = this.getDailyBalanceFormInfo(ctx, settlDate);
        if (afterDateFormInfo != null) {
            this._delete(ctx, (IObjectPK)new ObjectUuidPK(afterDateFormInfo.getId().toString()));
        }
        this.updateClearingHouseSettleDate(ctx, null, antiSettDate, false);
    }

    private void deleteSummaryLedgerCol(Context ctx, Date date) throws BOSException {
        String sqlStr = "DELETE T_FS_SummaryLedger WHERE FBizDate=?";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sqlStr);
            ps.setDate(1, TypeConversionUtils.objToDate((Object)date));
            ps.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    private void updateClearingHouseSettleDate(Context ctx, String companyId, Date date, boolean isSetOpen) throws EASBizException, BOSException {
        BankInfo houseInfo = FSHelper.getClearingHouseInfo(ctx, companyId);
        houseInfo.setSettleDate(date);
        if (isSetOpen) {
            // empty if block
        }
        BankFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(houseInfo.getId().toString()), (CoreBaseInfo)houseInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private InnerAccountInfo getInnerAccountByCompany(Context ctx, String companyId) throws EASBizException, BOSException {
        PreparedStatement ps;
        Connection conn;
        block4: {
            InnerAccountInfo innerAccountInfo;
            String sql = "SELECT FID FROM T_FS_InnerAccount WHERE FType=1 AND FCompanyID=?";
            conn = null;
            ps = null;
            ResultSet rs = null;
            String fid = null;
            try {
                conn = this.getConnection(ctx);
                ps = conn.prepareStatement(sql);
                ps.setString(1, companyId);
                rs = ps.executeQuery();
                if (!rs.next() || (fid = rs.getString("FID")) == null) break block4;
                innerAccountInfo = this.getInnerAccountByFID(ctx, fid);
            }
            catch (SQLException sQLException) {
                SQLUtils.cleanup(ps, (Connection)conn);
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ps, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
            return innerAccountInfo;
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return null;
    }

    private InnerAccountInfo getInnerAccountByFID(Context ctx, String fid) throws BOSException {
        IInnerAccount iInnerAcc = InnerAccountFactory.getLocalInstance(ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("clhClassification.id");
        selector.add("clhClassification.detailCollection.id");
        selector.add("clhClassification.detailCollection.accountlink.name");
        selector.add("clhClassification.detailCollection.accountlink.id");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)fid));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        InnerAccountCollection innerAccCol = iInnerAcc.getInnerAccountCollection(viewInfo);
        if (innerAccCol != null) {
            return innerAccCol.get(0);
        }
        return null;
    }

    @Override
    protected void _deleteDailyBalance(Context ctx, Date date) throws EASBizException, BOSException {
        if (date != null) {
            this.clearOldForm(ctx, date);
        } else {
            this.deleteNoSettledForm(ctx);
        }
    }

    protected void deleteNoSettledForm(Context ctx) throws BOSException, EASBizException {
        String strSql = "SELECT FID FROM T_FS_DailyBalanceForm WHERE FIsSettled=0 ";
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String fid = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(strSql);
            rs = ps.executeQuery();
            if (rs.next() && (fid = rs.getString("FID")) != null) {
                this._delete(ctx, (IObjectPK)new ObjectUuidPK(fid));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
    }

    @Override
    protected void _dailySettle(Context ctx, String id) throws BOSException, EASBizException {
    }

    @Override
    protected void _checkVouchered(Context ctx, Date date) throws BOSException, EASBizException {
    }

    @Override
    protected Date _getDailySettledDate(Context ctx, String companyId) throws BOSException, EASBizException {
        BankInfo clearingHouseInfo = FSHelper.getClearingHouseInfo(ctx, companyId);
        return clearingHouseInfo.getSettleDate();
    }

    @Override
    protected boolean _checkIsAntiSettleDate(Context ctx, String companyId, Date date) throws BOSException, EASBizException {
        BankInfo clearingHouseInfo = FSHelper.getClearingHouseInfo(ctx, companyId);
        Date settlDate = clearingHouseInfo.getSettleDate();
        Date antiSettDate = DateUtil.getBeforeDay((Date)settlDate);
        return date.equals(antiSettDate);
    }
}

