/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.fs.DepositContrastFilterParam;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.app.AbstractDepositContrastHelperFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DepositContrastHelperFacadeControllerBean
extends AbstractDepositContrastHelperFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fs.app.DepositContrastHelperFacadeControllerBean");
    private String loc;

    private String getSql(Context ctx, FilterParam param) throws EASBizException, BOSException {
        if (param == null) {
            return null;
        }
        String companyid = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        Date settleDate1 = FSHelper.getClearingHouseInfo(ctx, companyid).getSettleDate();
        if (EmptyUtil.isEmpty((Object)settleDate1)) {
            throw new FSException(FSException.CHNOTUSED);
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(settleDate1);
        cal1.add(5, -1);
        java.sql.Date settleDate = new java.sql.Date(cal1.getTime().getTime());
        DepositContrastFilterParam filterParam = (DepositContrastFilterParam)param;
        String companyids = this.getCompanyids(filterParam.getCompanyIds());
        java.sql.Date date = filterParam.getDate();
        StringBuffer sql = new StringBuffer();
        this.loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sql.append("SELECT COMPANY.FNUMBER AS COMPANYNUMBER,COMPANY.FNAME_").append(this.loc).append("  AS COMPANYNAME,\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("INNERACCOUNT.FNUMBER AS INNCTNUMBER,INNERACCOUNT.FNAME_").append(this.loc).append("  AS INNCTNAME,\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        this.addSQLTodayLess(sql);
        sql.append("CASE WHEN YESTERDAY.FSUMAMOUNT IS NULL THEN TODAY.FSUMAMOUNT ELSE (TODAY.FSUMAMOUNT - YESTERDAY.FSUMAMOUNT) END AS compareToYesterday\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append(",CASE WHEN ULTIMO.FSUMAMOUNT IS NULL THEN TODAY.FSUMAMOUNT ELSE (TODAY.FSUMAMOUNT - ULTIMO.FSUMAMOUNT) END AS compareToUltimo\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append(",CASE WHEN LASTYEAR.FSUMAMOUNT IS NULL THEN TODAY.FSUMAMOUNT ELSE (TODAY.FSUMAMOUNT - LASTYEAR.FSUMAMOUNT) END AS compareToLastYear\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("FROM  \tT_FS_INNERACCOUNT INNERACCOUNT left join \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        this.addSQLTodayTableMore(sql, settleDate, date);
        sql.append("ON INNERACCOUNT.FID = TODAY.FINNERACCOUNTID\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("");
        sql.append("left JOIN T_BD_CURRENCY CURRENCY\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("ON CURRENCY.FID = TODAY.FCURRENCYID\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        this.addSQLYesterdayTableMore(sql, settleDate, this.getYesterday(date));
        this.addSQLUltimoTableMore(sql, settleDate, this.getUltimo(date));
        this.addSQLLastYearTableMore(sql, settleDate, this.getLastYear(date));
        sql.append("INNER JOIN T_BD_ACCOUNTPROPERTY ACCOUNTPROPERTY\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("ON ACCOUNTPROPERTY.FID = INNERACCOUNT.FTYPEID \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("INNER JOIN T_ORG_COMPANY COMPANY\t\t\n");
        sql.append("ON COMPANY.FID = TODAY.FAPPLYUNITID\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("WHERE ACCOUNTPROPERTY.FPROPERTY <> 3\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("AND COMPANY.FID IN (" + companyids + ")\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("AND CURRENCY.FID = '" + filterParam.getCurrencyId() + "'\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        if (!filterParam.isClosedShow()) {
            sql.append("AND INNERACCOUNT.FCLOSED = 0\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        }
        sql.append("AND INNERACCOUNT.FCOMPANYID = '" + companyid + "'\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("order by COMPANY.FNUMBER\t\t\t");
        return sql.toString();
    }

    @Override
    protected IRowSet _getSQLResult(Context ctx, FilterParam param) throws BOSException, EASBizException {
        IRowSet rs = null;
        rs = DbUtil.executeQuery((Context)ctx, (String)this.getSql(ctx, param));
        return rs;
    }

    @Override
    protected IRowSet _getCompTotalRowSet(Context ctx, FilterParam param) throws BOSException, EASBizException {
        if (param == null) {
            return null;
        }
        String companyid = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        Date settleDate1 = FSHelper.getClearingHouseInfo(ctx, companyid).getSettleDate();
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(settleDate1);
        cal1.add(5, -1);
        java.sql.Date settleDate = new java.sql.Date(cal1.getTime().getTime());
        DepositContrastFilterParam filterParam = (DepositContrastFilterParam)param;
        String companyids = this.getCompanyids(filterParam.getCompanyIds());
        java.sql.Date date = filterParam.getDate();
        StringBuffer sql = new StringBuffer();
        this.loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sql.append("SELECT COMPANY.FNUMBER AS COMPANYNUMBER,COMPANY.FNAME_").append(this.loc).append("  AS COMPANYNAME,\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        this.addSQLTodayMore(sql);
        sql.append("sum(CASE WHEN YESTERDAY.FSUMAMOUNT IS NULL THEN TODAY.FSUMAMOUNT ELSE (TODAY.FSUMAMOUNT - YESTERDAY.FSUMAMOUNT) END) AS compareToYesterday\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append(",sum(CASE WHEN ULTIMO.FSUMAMOUNT IS NULL THEN TODAY.FSUMAMOUNT ELSE (TODAY.FSUMAMOUNT - ULTIMO.FSUMAMOUNT) END ) AS compareToUltimo\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append(",sum(CASE WHEN LASTYEAR.FSUMAMOUNT IS NULL THEN TODAY.FSUMAMOUNT ELSE (TODAY.FSUMAMOUNT - LASTYEAR.FSUMAMOUNT) END ) AS compareToLastYear\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("FROM \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        this.addSQLTodayTableMore(sql, settleDate, date);
        sql.append("INNER JOIN T_BD_CURRENCY CURRENCY\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("ON CURRENCY.FID = TODAY.FCURRENCYID\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("INNER JOIN T_FS_INNERACCOUNT INNERACCOUNT\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("ON INNERACCOUNT.FID = TODAY.FINNERACCOUNTID\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        this.addSQLYesterdayTableMore(sql, settleDate, this.getYesterday(date));
        this.addSQLUltimoTableMore(sql, settleDate, this.getUltimo(date));
        this.addSQLLastYearTableMore(sql, settleDate, this.getLastYear(date));
        sql.append("INNER JOIN T_BD_ACCOUNTPROPERTY ACCOUNTPROPERTY\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("ON ACCOUNTPROPERTY.FID = INNERACCOUNT.FTYPEID \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("INNER JOIN T_ORG_COMPANY COMPANY\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("ON COMPANY.FID = INNERACCOUNT.FAPPLYUNITID\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("WHERE ACCOUNTPROPERTY.FPROPERTY <> 3\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("AND COMPANY.FID IN (" + companyids + ")\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("AND CURRENCY.FID = '" + filterParam.getCurrencyId() + "'\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("AND INNERACCOUNT.FCOMPANYID = '" + companyid + "'\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        if (!filterParam.isClosedShow()) {
            sql.append("AND INNERACCOUNT.FCLOSED = 0\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        }
        sql.append("group by COMPANY.FNUMBER,COMPANY.FNAME_").append(this.loc).append("       \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("order by COMPANY.FNUMBER\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        IRowSet rs = null;
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    private String getCompanyids(String[] companyIDs) {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < companyIDs.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append("'");
            sb.append(companyIDs[i].toString());
            sb.append("'");
        }
        return sb.toString();
    }

    private java.sql.Date getYesterday(java.sql.Date date) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date);
        cal1.add(5, -1);
        return new java.sql.Date(cal1.getTime().getTime());
    }

    private java.sql.Date getUltimo(java.sql.Date date) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date);
        cal1.add(2, -1);
        return new java.sql.Date(cal1.getTime().getTime());
    }

    private java.sql.Date getLastYear(java.sql.Date date) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date);
        cal1.add(1, -1);
        return new java.sql.Date(cal1.getTime().getTime());
    }

    private boolean compareToYesterday(java.sql.Date settleDate, java.sql.Date yesterday) {
        return settleDate.compareTo(yesterday) <= 0;
    }

    private boolean compareToUltimo(java.sql.Date settleDate, java.sql.Date ultimo) {
        return settleDate.compareTo(ultimo) <= 0;
    }

    private boolean compareToLastYear(java.sql.Date settleDate, java.sql.Date lastYear) {
        return settleDate.compareTo(lastYear) <= 0;
    }

    private void addSQLTodayMore(StringBuffer sql) {
        sql.append(" SUM (CASE  WHEN ACCOUNTPROPERTY.FPROPERTY = 1 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("       THEN TODAY.FSUMAMOUNT ELSE 0\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("       END)  AS FCURRENTDEPOSIT,\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append(" SUM (CASE  WHEN ACCOUNTPROPERTY.FPROPERTY = 2 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("       THEN TODAY.FSUMAMOUNT ELSE 0 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("       END)  AS FFIXEDDEPOSIT,\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append(" SUM (TODAY.FSUMAMOUNT)  AS SUMDEPOSIT,\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
    }

    private void addSQLTodayLess(StringBuffer sql) {
        sql.append(" CASE  WHEN ACCOUNTPROPERTY.FPROPERTY = 1 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("       THEN TODAY.FSUMAMOUNT ELSE 0\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("       END  AS FCURRENTDEPOSIT,\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append(" CASE  WHEN ACCOUNTPROPERTY.FPROPERTY = 2 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("       THEN TODAY.FSUMAMOUNT ELSE 0 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("       END  AS FFIXEDDEPOSIT,\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append(" TODAY.FSUMAMOUNT  AS SUMDEPOSIT,\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
    }

    private void addSQLTableMore(StringBuffer sql, java.sql.Date settleDate, java.sql.Date today, String tb1, String in1) {
        sql.append("(select " + tb1 + ".finneraccountid AS FINNERACCOUNTID," + tb1 + ".fcurrencyid AS FCURRENCYID," + in1 + ".FApplyUnitID AS FAPPLYUNITID,\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append(" " + tb1 + ".fendbalance\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("as FSUMAMOUNT\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("from T_fs_inneraccount " + in1 + "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("LEFT JOIN (select finneraccountid,fcurrencyid,sum(fendbalance) fendbalance from ( \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("select finneraccountid,fcurrencyid,fendbalance from T_FS_SUMMARYLEDGER where fbizdate =   {ts'" + settleDate.toString() + " 0:00:00'}  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("union all (select finneraccountid,fcurrencyid,sum(fdebitAmount - FCreditAmount) as fendbalance from\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("t_fs_subsidiaryledger where fdate between {ts'" + settleDate.toString() + " 0:00:01'} and {ts'" + today.toString() + " 0:00:00'} \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("group by finneraccountid,fcurrencyid  ) ) xxx\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("group by finneraccountid,fcurrencyid) " + tb1 + "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("on " + tb1 + ".finneraccountid = " + in1 + ".fid  \t\t\t\t\t");
        sql.append(" where \t" + tb1 + ".fendbalance is not null )\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
    }

    private void addSQLTableLess(StringBuffer sql, java.sql.Date today, String sm1, String in1) {
        sql.append("(select " + sm1 + ".finneraccountid AS FINNERACCOUNTID," + sm1 + ".fcurrencyid AS FCURRENCYID," + in1 + ".FApplyUnitID AS FAPPLYUNITID,\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append(sm1 + ".Fbizdate AS FBIZDATE," + sm1 + ".fendbalance \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("as FSUMAMOUNT \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("from T_fs_inneraccount " + in1 + "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("left join\tT_FS_SUMMARYLEDGER " + sm1 + "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append(" ON " + sm1 + ".FINNERACCOUNTID = " + in1 + ".FID  \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("where " + sm1 + ".fbizdate = {ts'" + today.toString() + " 0:00:00'}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("group by " + sm1 + ".finneraccountid," + sm1 + ".fcurrencyid," + sm1 + ".fbizdate ," + in1 + ".FApplyUnitID," + sm1 + ".fendbalance ) \t\t\t\n");
    }

    private void addSQLTodayTableMore(StringBuffer sql, java.sql.Date settleDate, java.sql.Date today) {
        if (today.compareTo(settleDate) > 0) {
            this.addSQLTableMore(sql, settleDate, today, "tb1", "in1");
        } else {
            this.addSQLTableLess(sql, today, "sm1", "in1");
        }
        sql.append(" TODAY\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
    }

    private void addSQLSettleDateTable(StringBuffer sql, java.sql.Date settleDate, java.sql.Date date) {
        if (date.compareTo(settleDate) > 0) {
            this.addSQLTableLess(sql, settleDate, "stsm", "stin");
            sql.append(" SETTLEDATE\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        }
    }

    private void addSQLYesterdayTableMore(StringBuffer sql, java.sql.Date settleDate, java.sql.Date yesterday) {
        sql.append("LEFT JOIN \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        if (yesterday.compareTo(settleDate) > 0) {
            this.addSQLTableMore(sql, settleDate, yesterday, "tb2", "in2");
        } else {
            this.addSQLTableLess(sql, yesterday, "sm2", "in2");
        }
        sql.append(" YESTERDAY\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("ON YESTERDAY.FINNERACCOUNTID = TODAY.FINNERACCOUNTID \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("AND YESTERDAY.FCURRENCYID = TODAY.FCURRENCYID\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
    }

    private void addSQLUltimoTableMore(StringBuffer sql, java.sql.Date settleDate, java.sql.Date ultimo) {
        sql.append("LEFT JOIN \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        if (ultimo.compareTo(settleDate) > 0) {
            this.addSQLTableMore(sql, settleDate, ultimo, "tb3", "in3");
        } else {
            this.addSQLTableLess(sql, ultimo, "sm3", "in3");
        }
        sql.append(" ULTIMO\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("ON ULTIMO.FINNERACCOUNTID = TODAY.FINNERACCOUNTID\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append(" AND ULTIMO.FCURRENCYID = TODAY.FCURRENCYID\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
    }

    private void addSQLLastYearTableMore(StringBuffer sql, java.sql.Date settleDate, java.sql.Date lastyear) {
        sql.append("LEFT JOIN \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        if (lastyear.compareTo(settleDate) > 0) {
            this.addSQLTableMore(sql, settleDate, lastyear, "tb4", "in4");
        } else {
            this.addSQLTableLess(sql, lastyear, "sm4", "in4");
        }
        sql.append(" LASTYEAR\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("ON LASTYEAR.FINNERACCOUNTID = TODAY.FINNERACCOUNTID \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("AND LASTYEAR.FCURRENCYID = TODAY.FCURRENCYID\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
    }
}

