/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.FSSwitchStatusEnum;
import com.kingdee.eas.fm.fs.ISettlementBill;
import com.kingdee.eas.fm.fs.SettlementBillCollection;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.app.AbstractFSSwitchControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class FSSwitchControllerBean
extends AbstractFSSwitchControllerBean {
    @Override
    protected void _open(Context ctx, String companyId) throws BOSException, EASBizException {
        this.changeSwitchStatus(ctx, companyId, 1);
    }

    @Override
    protected void _close(Context ctx, String companyId) throws BOSException, EASBizException {
        this.changeSwitchStatus(ctx, companyId, 3);
    }

    private int changeSwitchStatus(Context ctx, String companyId, int status) throws EASBizException, BOSException {
        FSSwitchStatusEnum switchStatus = this.getCurrentStatus(ctx, companyId);
        if (switchStatus.getValue() != status) {
            String id = FSHelper.getClearingHouseInfo(ctx, companyId).getId().toString();
            String sql = "UPDATE T_BD_Bank SET FSwitchStatus = ? WHERE FID = ?";
            Connection conn = null;
            PreparedStatement stmt = null;
            try {
                conn = this.getConnection(ctx);
                stmt = conn.prepareStatement(sql);
                stmt.setInt(1, status);
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)2, (String)id);
                stmt.executeUpdate();
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(stmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
        return status;
    }

    @Override
    protected FSSwitchStatusEnum _getCurrentStatus(Context ctx, String companyId) throws BOSException, EASBizException {
        int switchStatus = -1;
        BankInfo clearingHouseInfo = FSHelper.getClearingHouseInfo(ctx, companyId);
        if (clearingHouseInfo == null) {
            return FSSwitchStatusEnum.CLOSED;
        }
        String id = clearingHouseInfo.getId().toString();
        String sql = "SELECT TOP 1 FSwitchStatus, FIsUsed FROM T_BD_Bank WHERE FID = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)1, (String)id);
            rs = stmt.executeQuery();
            if (rs.next()) {
                boolean isUsed = rs.getBoolean("FIsUsed");
                if (!isUsed) {
                    throw new FSException(FSException.CHNOTUSED);
                }
            } else {
                throw new FSException(FSException.CHNOTUSED);
            }
            switchStatus = rs.getInt("FSwitchStatus");
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return FSSwitchStatusEnum.getEnum(switchStatus);
    }

    @Override
    protected IObjectCollection _getUnAcceptSettlementBills(Context ctx, String companyId) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("isAccepted", (Object)new Integer(0)));
        fi.getFilterItems().add(new FilterItemInfo("HasEffected", (Object)new Integer(1)));
        ev.setFilter(fi);
        ISettlementBill iSettlementBill = SettlementBillFactory.getLocalInstance(ctx);
        SettlementBillCollection coll = iSettlementBill.getSettlementBillCollection(ev);
        return coll;
    }
}

