/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.RecAcctReceiveAcctBuilder;
import com.kingdee.eas.fm.fs.RecAcctVoucherEnum;
import com.kingdee.eas.fm.fs.ReceiveAccountCollection;
import com.kingdee.eas.fm.fs.ReceiveAccountException;
import com.kingdee.eas.fm.fs.ReceiveAccountInfo;
import com.kingdee.eas.fm.fs.ReceiveAcctBookNotifyBuilder;
import com.kingdee.eas.fm.fs.ReceiveAcctHelper;
import com.kingdee.eas.fm.fs.ReceiveAcctStatusEnum;
import com.kingdee.eas.fm.fs.SendAccountFactory;
import com.kingdee.eas.fm.fs.SendAcctStatusEnum;
import com.kingdee.eas.fm.fs.SendRecAcctTypeEnum;
import com.kingdee.eas.fm.fs.app.AbstractReceiveAccountControllerBean;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReceiveAccountControllerBean
extends AbstractReceiveAccountControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fs.app.ReceiveAccountControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ReceiveAccountInfo info = (ReceiveAccountInfo)model;
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)info, (AbstractCoreBaseControllerBean)this);
        if (FMHelper.isEmpty((String)info.getNumber())) {
            throw new ReceiveAccountException(ReceiveAccountException.NUMBERISNULL);
        }
        return super._addnew(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ReceiveAccountInfo info = (ReceiveAccountInfo)this._getValue(ctx, pk);
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
        super._delete(ctx, pk);
    }

    @Override
    protected void _check(Context ctx, Set idSet, int mode, String result) throws BOSException, EASBizException {
        if (idSet.isEmpty()) {
            return;
        }
        IContextHelper iContextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = iContextHelper.getCurrentCompany();
        UserInfo user = iContextHelper.getCurrentUser();
        boolean isNotSamePerson = false;
        ReceiveAccountCollection coll = this.getColl(ctx, idSet);
        ReceiveAccountInfo recInfo = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            recInfo = coll.get(i);
            if (isNotSamePerson && user.getId().toString().equals(recInfo.getCreator().getId().toString())) {
                throw new ReceiveAccountException(ReceiveAccountException.CHECKPARAMERROR, new String[]{recInfo.getNumber()});
            }
            if (mode == 10) {
                this.checkDispose(ctx, recInfo, companyInfo, result);
                continue;
            }
            if (mode != 11) continue;
            this.checkBack(ctx, recInfo, companyInfo, result);
        }
    }

    private void checkDispose(Context ctx, ReceiveAccountInfo recInfo, CompanyOrgUnitInfo companyInfo, String result) throws EASBizException, BOSException {
        ReceiveAcctHelper.beforeCheck(ctx, recInfo);
        String companyId = companyInfo.getId().toString();
        boolean isConfirmCh = companyId.equals(recInfo.getSettleConfirmCH().getRelatedCompany().getId().toString());
        boolean isAcceptCh = companyId.equals(recInfo.getSettleAcceptCH().getRelatedCompany().getId().toString());
        boolean isBackBill = recInfo.isIsBackBill();
        SendRecAcctTypeEnum type = recInfo.getType();
        ReceiveAcctHelper.genDownBill(ctx, recInfo, isConfirmCh, isAcceptCh, isBackBill, type);
        ReceiveAcctHelper.signCheck(ctx, recInfo.getId().toString(), result);
    }

    private void checkBack(Context ctx, ReceiveAccountInfo recInfo, CompanyOrgUnitInfo companyInfo, String result) throws EASBizException, BOSException {
        ReceiveAcctHelper.beforeCheck(ctx, recInfo);
        if (recInfo.isIsBackBill()) {
            throw new ReceiveAccountException(ReceiveAccountException.CHECKBACKERROR, new String[]{recInfo.getNumber()});
        }
        this._delete(ctx, (IObjectPK)new ObjectUuidPK(recInfo.getId()));
        SendAccountFactory.getLocalInstance(ctx).writeStatusAndResult(recInfo.getUpBillId(), SendAcctStatusEnum.BACKED, result);
    }

    private ReceiveAccountCollection getColl(Context ctx, Set idSet) throws BOSException {
        if (idSet == null || idSet.isEmpty()) {
            return new ReceiveAccountCollection();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("*");
        evi.getSelector().add("settleAcceptCH.*");
        evi.getSelector().add("settleConfirmCH.*");
        evi.getSelector().add("settleAcceptCH.relatedCompany.*");
        evi.getSelector().add("settleConfirmCH.relatedCompany.*");
        evi.getSelector().add("submitCH.*");
        evi.getSelector().add("upReckoningAcct.*");
        evi.getSelector().add("downReckoningAcct.*");
        return this.getReceiveAccountCollection(ctx, evi);
    }

    @Override
    protected void _antiCheck(Context ctx, Set idSet) throws BOSException, EASBizException {
        if (idSet == null || idSet.isEmpty()) {
            return;
        }
        ReceiveAccountCollection coll = this.getColl(ctx, idSet);
        ReceiveAccountInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            this.antiCheck(ctx, info);
        }
    }

    private void antiCheck(Context ctx, ReceiveAccountInfo recInfo) throws BOSException, EASBizException {
        if (!recInfo.getStatus().equals((Object)ReceiveAcctStatusEnum.CHECKED) || recInfo.isFivouchered()) {
            throw new ReceiveAccountException(ReceiveAccountException.ANTICHECKERROR, new String[]{recInfo.getNumber()});
        }
        ReceiveAcctHelper.signAntiCheck(ctx, recInfo.getId().toString());
        ReceiveAcctHelper.deleteDownBill(ctx, recInfo.getDownBillId());
    }

    @Override
    protected void _backBill(Context ctx, Set idSet, String result) throws BOSException, EASBizException {
        if (idSet == null || idSet.isEmpty()) {
            return;
        }
        ReceiveAccountCollection coll = this.getColl(ctx, idSet);
        ReceiveAccountInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            this.backBill(ctx, info, result);
        }
    }

    private void backBill(Context ctx, ReceiveAccountInfo recInfo, String result) throws EASBizException, BOSException {
        ReceiveAcctHelper.beforeBackBill(ctx, recInfo);
        String recBillId = recInfo.getId().toString();
        ReceiveAcctHelper.signBackBill(ctx, recBillId, result);
        String srcSendAcctId = recInfo.getUpBillId();
        SendAccountFactory.getLocalInstance(ctx).writeResult(srcSendAcctId, result);
        RecAcctReceiveAcctBuilder builder = new RecAcctReceiveAcctBuilder();
        ReceiveAccountInfo destInfo = builder.getReceiveAcctInfo(ctx, recBillId);
        this._submit(ctx, (IObjectValue)destInfo);
        HashMap<String, String> idMap = new HashMap<String, String>();
        idMap.put(recBillId, destInfo.getId().toString());
        FMHelper.saveBOTRelation((Context)ctx, idMap);
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        this.checkDispose(ctx, destInfo, companyInfo, null);
    }

    @Override
    protected void _settle(Context ctx, IObjectCollection coll, int mode) throws BOSException, EASBizException {
        if (coll == null || coll.isEmpty()) {
            return;
        }
        Set idSet = this.saveCHBankAcct(ctx, (ReceiveAccountCollection)coll);
        ReceiveAccountCollection recColl = this.getColl(ctx, idSet);
        ReceiveAccountInfo recInfo = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            recInfo = recColl.get(i);
            ReceiveAcctHelper.beforeSettle(ctx, recInfo);
        }
        if (mode == 30) {
            this.settle(ctx, idSet);
        } else if (mode == 31) {
            this.commit2Be(ctx, idSet);
        } else if (mode == 32) {
            this.writeOff(ctx, idSet);
        }
    }

    private Set saveCHBankAcct(Context ctx, ReceiveAccountCollection coll) throws BOSException {
        HashSet<String> idSet = new HashSet<String>();
        if (coll == null || coll.isEmpty()) {
            return idSet;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_FS_ReceiveAccount \n").append(" SET FAccountBankID = ?, FSettlementTypeID = ?, FSettleNumber = ? ").append(" WHERE FID = ? ");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            ReceiveAccountInfo info = null;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                info = coll.get(i);
                idSet.add(info.getId().toString());
                pstmt.setString(1, info.getAccountBank().getId().toString());
                if (info.getSettlementType() != null) {
                    pstmt.setString(2, info.getSettlementType().getId().toString());
                } else {
                    pstmt.setNull(2, 12);
                }
                pstmt.setString(3, info.getSettleNumber());
                pstmt.setString(4, info.getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return idSet;
    }

    private void settle(Context ctx, Set idSet) throws EASBizException, BOSException {
        IBookNotifyFacade facade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        String builderName = ReceiveAcctBookNotifyBuilder.class.getName();
        String id2 = null;
        for (String id2 : idSet) {
            facade.book(builderName, id2);
            ReceiveAcctHelper.signSettle(ctx, id2);
        }
    }

    private void commit2Be(Context ctx, Set idSet) {
    }

    private void writeOff(Context ctx, Set idSet) {
    }

    @Override
    protected void _antiSettle(Context ctx, Set idSet) throws BOSException, EASBizException {
        if (idSet == null || idSet.isEmpty()) {
            return;
        }
        ReceiveAccountCollection coll = this.getColl(ctx, idSet);
        ReceiveAccountInfo recInfo = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            recInfo = coll.get(i);
            this.antiSettle(ctx, recInfo);
        }
    }

    private void antiSettle(Context ctx, ReceiveAccountInfo recInfo) throws EASBizException, BOSException {
        if (!recInfo.getStatus().equals((Object)ReceiveAcctStatusEnum.SETTLEED) || recInfo.isFivouchered()) {
            throw new ReceiveAccountException(ReceiveAccountException.ANTISETTLEERROR, new String[]{recInfo.getNumber()});
        }
        String billId = recInfo.getId().toString();
        IBookNotifyFacade facade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        facade.antiBook(billId);
        ReceiveAcctHelper.signAntiSettle(ctx, billId);
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        CoreBillBaseCollection coll = (CoreBillBaseCollection)sourceBillCollection;
        this.beforeGenVoucher(ctx, coll);
        DAPTransformResult result = super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
        CoreBillBaseInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            ReceiveAcctHelper.signVoucher(ctx, info.getId().toString());
        }
        return result;
    }

    private void beforeGenVoucher(Context ctx, CoreBillBaseCollection billColl) throws ReceiveAccountException, BOSException {
        Set idSet = this.getIdSet(billColl);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        ReceiveAccountCollection coll = this.getReceiveAccountCollection(ctx, evi);
        ReceiveAccountInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            Object[] params = new String[]{info.getNumber()};
            if (info.getStatus().equals((Object)ReceiveAcctStatusEnum.UNDEALED)) {
                throw new ReceiveAccountException(ReceiveAccountException.VOUCHERSTATUSERROR, params);
            }
            if (!info.getVoucherEnum().equals((Object)RecAcctVoucherEnum.CONFIRMCH) || !info.getType().equals((Object)SendRecAcctTypeEnum.OUTERSETTLE) || info.getAccountBank() != null) continue;
            throw new ReceiveAccountException(ReceiveAccountException.VOUCHERERROR, params);
        }
    }

    private Set getIdSet(CoreBillBaseCollection coll) {
        HashSet<String> idSet = new HashSet<String>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            idSet.add(coll.get(i).getId().toString());
        }
        return idSet;
    }

    protected boolean _deleteVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        Set idSet = FMHelper.getSrcBillIdCollBySrcId((Context)ctx, (String)sourceBillPk.toString());
        Iterator iter = idSet.iterator();
        while (iter.hasNext()) {
            ReceiveAcctHelper.signDelVoucher(ctx, (String)iter.next());
        }
        return super._deleteVoucher(ctx, sourceBillPk);
    }

    @Override
    protected void _writeDownBillId(Context ctx, String billId, String downBillId) throws BOSException, EASBizException {
        ReceiveAcctHelper.writeDownBillId(ctx, billId, downBillId);
    }
}

