/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fs.ReckoningAccountException;
import com.kingdee.eas.fm.fs.ReckoningAccountInfo;
import com.kingdee.eas.fm.fs.app.AbstractReckoningAccountControllerBean;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class ReckoningAccountControllerBean
extends AbstractReckoningAccountControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fs.app.ReckoningAccountControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ReckoningAccountInfo info = (ReckoningAccountInfo)model;
        FMHelper.initNumber((Context)ctx, (DataBaseInfo)info, (String)info.getCompany().getId().toString(), (AbstractCoreBaseControllerBean)this);
        return super._addnew(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.beforeSave(ctx, (ReckoningAccountInfo)model);
        return super._submit(ctx, model);
    }

    private void beforeSave(Context ctx, ReckoningAccountInfo info) throws EASBizException, BOSException {
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"acctNumber");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"name");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"company");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"clearingHouse");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"acctView");
        this._checkNumberDup(ctx, (IObjectValue)info);
        this.checkDup(ctx, info);
        boolean isReferenced = this._isReferenced(ctx, info.getId());
        if (isReferenced) {
            ReckoningAccountInfo oldInfo = (ReckoningAccountInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
            if (!info.getClearingHouse().getId().toString().equals(oldInfo.getClearingHouse().getId().toString())) {
                throw new ReckoningAccountException(ReckoningAccountException.UPDATEERROR);
            }
        }
    }

    private void checkDup(Context ctx, ReckoningAccountInfo info) throws BOSException, ReckoningAccountException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID, FNumber FROM T_FS_ReckoningAccount ").append("\tWHERE FCompanyId = ? AND FClearingHouseId = ? ");
        Object[] params = new Object[]{info.getCompany().getId().toString(), info.getClearingHouse().getId().toString()};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        try {
            if (rs.next()) {
                String id = rs.getString("FID");
                if (info.getId() == null || !id.equals(info.getId().toString())) {
                    String number = rs.getString("FNumber");
                    throw new ReckoningAccountException(ReckoningAccountException.DUPERROR, new Object[]{number});
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected IObjectValue _getReckoningAcct(Context ctx, String companyId, String chId) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectValue _getUpReckoningAcct(Context ctx, String companyId) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectValue _getUpReckoningAcct(Context ctx, IObjectValue chInfo) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectCollection _getDownReckoningAcctColl(Context ctx, String companyId) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectCollection _getDownReckoningAcctColl(Context ctx, IObjectValue chInfo) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectValue _getDirectDownAndUpReckoningAcct(Context ctx, String chAId, String chBId) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected boolean _isReferenced(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return false;
        }
        return ReferenceDAO.isReferenced((Context)ctx, (BOSUuid)id);
    }
}

